CREATE DATABASE IF NOT EXISTS `pixeloriuiabde`;

USE `pixeloriuiabde`;

DROP TABLE IF EXISTS `llx_accounting_account`;
CREATE TABLE `llx_accounting_account` (
  `rowid` bigint NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_pcg_version` varchar(32) NOT NULL,
  `pcg_type` varchar(60) DEFAULT NULL,
  `account_number` varchar(32) NOT NULL,
  `account_parent` int DEFAULT '0',
  `label` varchar(255) NOT NULL,
  `labelshort` varchar(255) DEFAULT NULL,
  `fk_accounting_category` int DEFAULT '0',
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `reconcilable` tinyint NOT NULL DEFAULT '0',
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_accounting_account` (`account_number`,`entity`,`fk_pcg_version`),
  KEY `idx_accounting_account_fk_pcg_version` (`fk_pcg_version`),
  KEY `idx_accounting_account_account_parent` (`account_parent`),
  CONSTRAINT `fk_accounting_account_fk_pcg_version` FOREIGN KEY (`fk_pcg_version`) REFERENCES `llx_accounting_system` (`pcg_version`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_accounting_bookkeeping`;
CREATE TABLE `llx_accounting_bookkeeping` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `doc_date` date NOT NULL,
  `doc_type` varchar(30) NOT NULL,
  `doc_ref` varchar(300) NOT NULL,
  `fk_doc` int NOT NULL,
  `fk_docdet` int NOT NULL,
  `thirdparty_code` varchar(32) DEFAULT NULL,
  `subledger_account` varchar(32) DEFAULT NULL,
  `subledger_label` varchar(255) DEFAULT NULL,
  `numero_compte` varchar(32) NOT NULL,
  `label_compte` varchar(255) NOT NULL,
  `label_operation` varchar(255) DEFAULT NULL,
  `debit` double(24,8) NOT NULL,
  `credit` double(24,8) NOT NULL,
  `montant` double(24,8) DEFAULT NULL,
  `sens` varchar(1) DEFAULT NULL,
  `multicurrency_amount` double(24,8) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `lettering_code` varchar(255) DEFAULT NULL,
  `date_lettering` datetime DEFAULT NULL,
  `date_lim_reglement` datetime DEFAULT NULL,
  `fk_user_author` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `code_journal` varchar(32) NOT NULL,
  `journal_label` varchar(255) DEFAULT NULL,
  `piece_num` int NOT NULL,
  `date_validated` datetime DEFAULT NULL,
  `date_export` datetime DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_accounting_bookkeeping_doc_date` (`doc_date`),
  KEY `idx_accounting_bookkeeping_fk_doc` (`fk_doc`),
  KEY `idx_accounting_bookkeeping_fk_docdet` (`fk_docdet`),
  KEY `idx_accounting_bookkeeping_numero_compte` (`numero_compte`,`entity`),
  KEY `idx_accounting_bookkeeping_code_journal` (`code_journal`,`entity`),
  KEY `idx_accounting_bookkeeping_piece_num` (`piece_num`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_accounting_bookkeeping_tmp`;
CREATE TABLE `llx_accounting_bookkeeping_tmp` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `doc_date` date NOT NULL,
  `doc_type` varchar(30) NOT NULL,
  `doc_ref` varchar(300) NOT NULL,
  `fk_doc` int NOT NULL,
  `fk_docdet` int NOT NULL,
  `thirdparty_code` varchar(32) DEFAULT NULL,
  `subledger_account` varchar(32) DEFAULT NULL,
  `subledger_label` varchar(255) DEFAULT NULL,
  `numero_compte` varchar(32) DEFAULT NULL,
  `label_compte` varchar(255) NOT NULL,
  `label_operation` varchar(255) DEFAULT NULL,
  `debit` double(24,8) NOT NULL,
  `credit` double(24,8) NOT NULL,
  `montant` double(24,8) NOT NULL,
  `sens` varchar(1) DEFAULT NULL,
  `multicurrency_amount` double(24,8) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `lettering_code` varchar(255) DEFAULT NULL,
  `date_lettering` datetime DEFAULT NULL,
  `date_lim_reglement` datetime DEFAULT NULL,
  `fk_user_author` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `code_journal` varchar(32) NOT NULL,
  `journal_label` varchar(255) DEFAULT NULL,
  `piece_num` int NOT NULL,
  `date_validated` datetime DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_accounting_bookkeeping_tmp_doc_date` (`doc_date`),
  KEY `idx_accounting_bookkeeping_tmp_fk_docdet` (`fk_docdet`),
  KEY `idx_accounting_bookkeeping_tmp_numero_compte` (`numero_compte`),
  KEY `idx_accounting_bookkeeping_tmp_code_journal` (`code_journal`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_accounting_fiscalyear`;
CREATE TABLE `llx_accounting_fiscalyear` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `label` varchar(128) NOT NULL,
  `date_start` date DEFAULT NULL,
  `date_end` date DEFAULT NULL,
  `statut` tinyint NOT NULL DEFAULT '0',
  `entity` int NOT NULL DEFAULT '1',
  `datec` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_accounting_groups_account`;
CREATE TABLE `llx_accounting_groups_account` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_accounting_account` int NOT NULL,
  `fk_c_accounting_category` int NOT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_accounting_journal`;
CREATE TABLE `llx_accounting_journal` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `code` varchar(32) NOT NULL,
  `label` varchar(128) NOT NULL,
  `nature` smallint NOT NULL DEFAULT '1',
  `active` smallint DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_accounting_journal_code` (`code`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO `llx_accounting_journal` VALUES("1","1","VT","ACCOUNTING_SELL_JOURNAL","2","1");
INSERT INTO `llx_accounting_journal` VALUES("2","1","AC","ACCOUNTING_PURCHASE_JOURNAL","3","1");
INSERT INTO `llx_accounting_journal` VALUES("3","1","BQ","FinanceJournal","4","1");
INSERT INTO `llx_accounting_journal` VALUES("4","1","OD","ACCOUNTING_MISCELLANEOUS_JOURNAL","1","1");
INSERT INTO `llx_accounting_journal` VALUES("5","1","AN","ACCOUNTING_HAS_NEW_JOURNAL","9","1");
INSERT INTO `llx_accounting_journal` VALUES("6","1","ER","ExpenseReportsJournal","5","1");
INSERT INTO `llx_accounting_journal` VALUES("7","1","INV","InventoryJournal","8","1");



DROP TABLE IF EXISTS `llx_accounting_system`;
CREATE TABLE `llx_accounting_system` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_country` int DEFAULT NULL,
  `pcg_version` varchar(32) NOT NULL,
  `label` varchar(128) NOT NULL,
  `active` smallint DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_accounting_system_pcg_version` (`pcg_version`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=latin1;

INSERT INTO `llx_accounting_system` VALUES("1","1","PCG99-ABREGE","The simple accountancy french plan","1");
INSERT INTO `llx_accounting_system` VALUES("2","1","PCG99-BASE","The base accountancy french plan","1");
INSERT INTO `llx_accounting_system` VALUES("3","1","PCG14-DEV","The developed accountancy french plan 2014","1");
INSERT INTO `llx_accounting_system` VALUES("4","2","PCMN-BASE","The base accountancy belgium plan","1");
INSERT INTO `llx_accounting_system` VALUES("5","4","PCG08-PYME","The PYME accountancy spanish plan","1");
INSERT INTO `llx_accounting_system` VALUES("6","5","SKR03","Standardkontenrahmen SKR 03","1");
INSERT INTO `llx_accounting_system` VALUES("7","5","SKR04","Standardkontenrahmen SKR 04","1");
INSERT INTO `llx_accounting_system` VALUES("8","6","PCG_SUISSE","Switzerland plan","1");
INSERT INTO `llx_accounting_system` VALUES("9","7","ENG-BASE","England plan","1");
INSERT INTO `llx_accounting_system` VALUES("10","10","PCT","The Tunisia plan","1");
INSERT INTO `llx_accounting_system` VALUES("11","67","PC-MIPYME","The PYME accountancy Chile plan","1");
INSERT INTO `llx_accounting_system` VALUES("12","80","DK-STD","Standardkontoplan fra SKAT","1");
INSERT INTO `llx_accounting_system` VALUES("13","140","PCN-LUXEMBURG","Plan comptable normalisé Luxembourgeois","1");
INSERT INTO `llx_accounting_system` VALUES("14","12","PCG","The Moroccan chart of accounts","1");
INSERT INTO `llx_accounting_system` VALUES("15","49","SYSCOHADA-BJ","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("16","60","SYSCOHADA-BF","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("17","24","SYSCOHADA-CM","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("18","65","SYSCOHADA-CF","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("19","71","SYSCOHADA-KM","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("20","72","SYSCOHADA-CG","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("21","21","SYSCOHADA-CI","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("22","16","SYSCOHADA-GA","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("23","87","SYSCOHADA-GQ","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("24","147","SYSCOHADA-ML","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("25","168","SYSCOHADA-NE","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("26","73","SYSCOHADA-CD","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("27","22","SYSCOHADA-SN","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("28","66","SYSCOHADA-TD","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("29","15","SYSCOHADA-TG","Plan comptable Ouest-Africain","1");
INSERT INTO `llx_accounting_system` VALUES("30","188","RO-BASE","Plan de conturi romanesc","1");
INSERT INTO `llx_accounting_system` VALUES("31","20","BAS-K1-MINI","The Swedish mini chart of accounts","1");
INSERT INTO `llx_accounting_system` VALUES("32","1","PCG18-ASSOC","French foundation chart of accounts 2018","1");
INSERT INTO `llx_accounting_system` VALUES("33","1","PCGAFR14-DEV","The developed farm accountancy french plan 2014","1");
INSERT INTO `llx_accounting_system` VALUES("34","41","AT-BASE","Plan Austria","1");
INSERT INTO `llx_accounting_system` VALUES("35","11","US-BASE","USA basic chart of accounts","1");
INSERT INTO `llx_accounting_system` VALUES("36","14","CA-ENG-BASE","Canadian basic chart of accounts - English","1");
INSERT INTO `llx_accounting_system` VALUES("37","154","SAT/24-2019","Catalogo y codigo agrupador fiscal del 2019","1");
INSERT INTO `llx_accounting_system` VALUES("38","140","PCN2020-LUXEMBURG","Plan comptable normalisé 2020 Luxembourgeois","1");



DROP TABLE IF EXISTS `llx_actioncomm`;
CREATE TABLE `llx_actioncomm` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `datep` datetime DEFAULT NULL,
  `datep2` datetime DEFAULT NULL,
  `fk_action` int DEFAULT NULL,
  `code` varchar(50) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_mod` int DEFAULT NULL,
  `fk_project` int DEFAULT NULL,
  `fk_soc` int DEFAULT NULL,
  `fk_contact` int DEFAULT NULL,
  `fk_parent` int NOT NULL DEFAULT '0',
  `fk_user_action` int DEFAULT NULL,
  `fk_user_done` int DEFAULT NULL,
  `transparency` int DEFAULT NULL,
  `priority` smallint DEFAULT NULL,
  `fulldayevent` smallint NOT NULL DEFAULT '0',
  `percent` smallint NOT NULL DEFAULT '0',
  `location` varchar(128) DEFAULT NULL,
  `durationp` double DEFAULT NULL,
  `label` varchar(255) NOT NULL,
  `note` mediumtext,
  `email_subject` varchar(255) DEFAULT NULL,
  `email_msgid` varchar(255) DEFAULT NULL,
  `email_from` varchar(255) DEFAULT NULL,
  `email_sender` varchar(255) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `email_tocc` varchar(255) DEFAULT NULL,
  `email_tobcc` varchar(255) DEFAULT NULL,
  `errors_to` varchar(255) DEFAULT NULL,
  `recurid` varchar(128) DEFAULT NULL,
  `recurrule` varchar(128) DEFAULT NULL,
  `recurdateend` datetime DEFAULT NULL,
  `fk_element` int DEFAULT NULL,
  `elementtype` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `calling_duration` int DEFAULT NULL,
  `visibility` varchar(12) DEFAULT 'default',
  `reply_to` varchar(255) DEFAULT NULL,
  `num_vote` int DEFAULT NULL,
  `event_paid` smallint NOT NULL DEFAULT '0',
  `status` smallint NOT NULL DEFAULT '0',
  `ip` varchar(250) DEFAULT NULL,
  `fk_bookcal_calendar` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_actioncomm_fk_soc` (`fk_soc`),
  KEY `idx_actioncomm_fk_contact` (`fk_contact`),
  KEY `idx_actioncomm_code` (`code`),
  KEY `idx_actioncomm_fk_element` (`fk_element`),
  KEY `idx_actioncomm_fk_user_action` (`fk_user_action`),
  KEY `idx_actioncomm_fk_project` (`fk_project`),
  KEY `idx_actioncomm_datep` (`datep`),
  KEY `idx_actioncomm_datep2` (`datep2`),
  KEY `idx_actioncomm_recurid` (`recurid`),
  KEY `idx_actioncomm_ref_ext` (`ref_ext`),
  KEY `idx_actioncomm_percent` (`percent`),
  KEY `idx_actioncomm_ref` (`ref`,`entity`),
  KEY `idx_actioncomm_entity` (`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_actioncomm_extrafields`;
CREATE TABLE `llx_actioncomm_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_actioncomm_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_actioncomm_reminder`;
CREATE TABLE `llx_actioncomm_reminder` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `dateremind` datetime NOT NULL,
  `typeremind` varchar(32) NOT NULL,
  `fk_user` int NOT NULL,
  `offsetvalue` int NOT NULL,
  `offsetunit` varchar(1) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `entity` int NOT NULL DEFAULT '1',
  `fk_actioncomm` int NOT NULL,
  `fk_email_template` int DEFAULT NULL,
  `lasterror` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_actioncomm_reminder_unique` (`fk_user`,`typeremind`,`offsetvalue`,`offsetunit`,`fk_actioncomm`),
  KEY `idx_actioncomm_reminder_rowid` (`rowid`),
  KEY `idx_actioncomm_reminder_dateremind` (`dateremind`),
  KEY `idx_actioncomm_reminder_fk_user` (`fk_user`),
  KEY `idx_actioncomm_reminder_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_actioncomm_resources`;
CREATE TABLE `llx_actioncomm_resources` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_actioncomm` int NOT NULL,
  `element_type` varchar(50) NOT NULL,
  `fk_element` int NOT NULL,
  `answer_status` varchar(50) DEFAULT NULL,
  `mandatory` smallint DEFAULT NULL,
  `transparency` smallint DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_actioncomm_resources` (`fk_actioncomm`,`element_type`,`fk_element`),
  KEY `idx_actioncomm_resources_fk_element` (`fk_element`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_adherent`;
CREATE TABLE `llx_adherent` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `ref_ext` varchar(128) DEFAULT NULL,
  `civility` varchar(6) DEFAULT NULL,
  `lastname` varchar(50) DEFAULT NULL,
  `firstname` varchar(50) DEFAULT NULL,
  `login` varchar(50) DEFAULT NULL,
  `pass` varchar(50) DEFAULT NULL,
  `pass_crypted` varchar(128) DEFAULT NULL,
  `fk_adherent_type` int NOT NULL,
  `morphy` varchar(3) NOT NULL,
  `societe` varchar(128) DEFAULT NULL,
  `fk_soc` int DEFAULT NULL,
  `address` text,
  `zip` varchar(30) DEFAULT NULL,
  `town` varchar(50) DEFAULT NULL,
  `state_id` int DEFAULT NULL,
  `country` int DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `socialnetworks` text,
  `phone` varchar(30) DEFAULT NULL,
  `phone_perso` varchar(30) DEFAULT NULL,
  `phone_mobile` varchar(30) DEFAULT NULL,
  `birth` date DEFAULT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `statut` smallint NOT NULL DEFAULT '0',
  `public` smallint NOT NULL DEFAULT '0',
  `datefin` datetime DEFAULT NULL,
  `default_lang` varchar(6) DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `datevalid` datetime DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_mod` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `canvas` varchar(32) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `gender` varchar(10) DEFAULT NULL,
  `ip` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_adherent_ref` (`ref`,`entity`),
  UNIQUE KEY `uk_adherent_login` (`login`,`entity`),
  UNIQUE KEY `uk_adherent_fk_soc` (`fk_soc`),
  KEY `idx_adherent_fk_adherent_type` (`fk_adherent_type`),
  CONSTRAINT `adherent_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_adherent_adherent_type` FOREIGN KEY (`fk_adherent_type`) REFERENCES `llx_adherent_type` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_adherent_extrafields`;
CREATE TABLE `llx_adherent_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_adherent_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_adherent_type`;
CREATE TABLE `llx_adherent_type` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `tms` timestamp NULL DEFAULT NULL,
  `statut` smallint NOT NULL DEFAULT '0',
  `libelle` varchar(50) NOT NULL,
  `subscription` varchar(3) NOT NULL DEFAULT '1',
  `amount` double(24,8) DEFAULT NULL,
  `caneditamount` int DEFAULT '0',
  `vote` varchar(3) NOT NULL DEFAULT '1',
  `note` text,
  `mail_valid` text,
  `morphy` varchar(3) DEFAULT NULL,
  `duration` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_adherent_type_libelle` (`libelle`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_adherent_type_extrafields`;
CREATE TABLE `llx_adherent_type_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_adherent_type_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_adherent_type_lang`;
CREATE TABLE `llx_adherent_type_lang` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_type` int NOT NULL DEFAULT '0',
  `lang` varchar(5) NOT NULL DEFAULT '0',
  `label` varchar(255) NOT NULL,
  `description` text,
  `email` text,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_asset`;
CREATE TABLE `llx_asset` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(128) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `label` varchar(255) DEFAULT NULL,
  `fk_asset_model` int DEFAULT NULL,
  `reversal_amount_ht` double(24,8) DEFAULT NULL,
  `acquisition_value_ht` double(24,8) NOT NULL,
  `recovered_vat` double(24,8) DEFAULT NULL,
  `reversal_date` date DEFAULT NULL,
  `date_acquisition` date NOT NULL,
  `date_start` date NOT NULL,
  `qty` double NOT NULL DEFAULT '1',
  `acquisition_type` smallint NOT NULL DEFAULT '0',
  `asset_type` smallint NOT NULL DEFAULT '0',
  `not_depreciated` int DEFAULT '0',
  `disposal_date` date DEFAULT NULL,
  `disposal_amount_ht` double(24,8) DEFAULT NULL,
  `fk_disposal_type` int DEFAULT NULL,
  `disposal_depreciated` int DEFAULT '0',
  `disposal_subject_to_vat` int DEFAULT '0',
  `note_public` text,
  `note_private` text,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NOT NULL,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_asset_rowid` (`rowid`),
  KEY `idx_asset_ref` (`ref`),
  KEY `idx_asset_entity` (`entity`),
  KEY `idx_asset_fk_asset_model` (`fk_asset_model`),
  KEY `idx_asset_fk_disposal_type` (`fk_disposal_type`),
  KEY `fk_asset_user_creat` (`fk_user_creat`),
  KEY `fk_asset_user_modif` (`fk_user_modif`),
  CONSTRAINT `fk_asset_asset_model` FOREIGN KEY (`fk_asset_model`) REFERENCES `llx_asset_model` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_asset_disposal_type` FOREIGN KEY (`fk_disposal_type`) REFERENCES `llx_c_asset_disposal_type` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_asset_user_creat` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_asset_user_modif` FOREIGN KEY (`fk_user_modif`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_asset_accountancy_codes_economic`;
CREATE TABLE `llx_asset_accountancy_codes_economic` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_asset` int DEFAULT NULL,
  `fk_asset_model` int DEFAULT NULL,
  `asset` varchar(32) DEFAULT NULL,
  `depreciation_asset` varchar(32) DEFAULT NULL,
  `depreciation_expense` varchar(32) DEFAULT NULL,
  `value_asset_sold` varchar(32) DEFAULT NULL,
  `receivable_on_assignment` varchar(32) DEFAULT NULL,
  `proceeds_from_sales` varchar(32) DEFAULT NULL,
  `vat_collected` varchar(32) DEFAULT NULL,
  `vat_deductible` varchar(32) DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_asset_ace_fk_asset` (`fk_asset`),
  UNIQUE KEY `uk_asset_ace_fk_asset_model` (`fk_asset_model`),
  KEY `idx_asset_ace_rowid` (`rowid`),
  KEY `fk_asset_ace_user_modif` (`fk_user_modif`),
  CONSTRAINT `fk_asset_ace_asset` FOREIGN KEY (`fk_asset`) REFERENCES `llx_asset` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_asset_ace_asset_model` FOREIGN KEY (`fk_asset_model`) REFERENCES `llx_asset_model` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_asset_ace_user_modif` FOREIGN KEY (`fk_user_modif`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_asset_accountancy_codes_fiscal`;
CREATE TABLE `llx_asset_accountancy_codes_fiscal` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_asset` int DEFAULT NULL,
  `fk_asset_model` int DEFAULT NULL,
  `accelerated_depreciation` varchar(32) DEFAULT NULL,
  `endowment_accelerated_depreciation` varchar(32) DEFAULT NULL,
  `provision_accelerated_depreciation` varchar(32) DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_asset_acf_fk_asset` (`fk_asset`),
  UNIQUE KEY `uk_asset_acf_fk_asset_model` (`fk_asset_model`),
  KEY `idx_asset_acf_rowid` (`rowid`),
  KEY `fk_asset_acf_user_modif` (`fk_user_modif`),
  CONSTRAINT `fk_asset_acf_asset` FOREIGN KEY (`fk_asset`) REFERENCES `llx_asset` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_asset_acf_asset_model` FOREIGN KEY (`fk_asset_model`) REFERENCES `llx_asset_model` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_asset_acf_user_modif` FOREIGN KEY (`fk_user_modif`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_asset_depreciation`;
CREATE TABLE `llx_asset_depreciation` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_asset` int NOT NULL,
  `depreciation_mode` varchar(255) NOT NULL,
  `ref` varchar(255) NOT NULL,
  `depreciation_date` datetime NOT NULL,
  `depreciation_ht` double(24,8) NOT NULL,
  `cumulative_depreciation_ht` double(24,8) NOT NULL,
  `accountancy_code_debit` varchar(32) DEFAULT NULL,
  `accountancy_code_credit` varchar(32) DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_asset_depreciation_fk_asset` (`fk_asset`,`depreciation_mode`,`ref`),
  KEY `idx_asset_depreciation_rowid` (`rowid`),
  KEY `idx_asset_depreciation_fk_asset` (`fk_asset`),
  KEY `idx_asset_depreciation_depreciation_mode` (`depreciation_mode`),
  KEY `idx_asset_depreciation_ref` (`ref`),
  KEY `fk_asset_depreciation_user_modif` (`fk_user_modif`),
  CONSTRAINT `fk_asset_depreciation_asset` FOREIGN KEY (`fk_asset`) REFERENCES `llx_asset` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_asset_depreciation_user_modif` FOREIGN KEY (`fk_user_modif`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_asset_depreciation_options_economic`;
CREATE TABLE `llx_asset_depreciation_options_economic` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_asset` int DEFAULT NULL,
  `fk_asset_model` int DEFAULT NULL,
  `depreciation_type` smallint NOT NULL DEFAULT '0',
  `accelerated_depreciation_option` int DEFAULT NULL,
  `degressive_coefficient` double(24,8) DEFAULT NULL,
  `duration` smallint NOT NULL,
  `duration_type` smallint NOT NULL DEFAULT '0',
  `amount_base_depreciation_ht` double(24,8) DEFAULT NULL,
  `amount_base_deductible_ht` double(24,8) DEFAULT NULL,
  `total_amount_last_depreciation_ht` double(24,8) DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_asset_doe_fk_asset` (`fk_asset`),
  UNIQUE KEY `uk_asset_doe_fk_asset_model` (`fk_asset_model`),
  KEY `idx_asset_doe_rowid` (`rowid`),
  KEY `fk_asset_doe_user_modif` (`fk_user_modif`),
  CONSTRAINT `fk_asset_doe_asset` FOREIGN KEY (`fk_asset`) REFERENCES `llx_asset` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_asset_doe_asset_model` FOREIGN KEY (`fk_asset_model`) REFERENCES `llx_asset_model` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_asset_doe_user_modif` FOREIGN KEY (`fk_user_modif`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_asset_depreciation_options_fiscal`;
CREATE TABLE `llx_asset_depreciation_options_fiscal` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_asset` int DEFAULT NULL,
  `fk_asset_model` int DEFAULT NULL,
  `depreciation_type` smallint NOT NULL DEFAULT '0',
  `degressive_coefficient` double(24,8) DEFAULT NULL,
  `duration` smallint NOT NULL,
  `duration_type` smallint NOT NULL DEFAULT '0',
  `amount_base_depreciation_ht` double(24,8) DEFAULT NULL,
  `amount_base_deductible_ht` double(24,8) DEFAULT NULL,
  `total_amount_last_depreciation_ht` double(24,8) DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_asset_dof_fk_asset` (`fk_asset`),
  UNIQUE KEY `uk_asset_dof_fk_asset_model` (`fk_asset_model`),
  KEY `idx_asset_dof_rowid` (`rowid`),
  KEY `fk_asset_dof_user_modif` (`fk_user_modif`),
  CONSTRAINT `fk_asset_dof_asset` FOREIGN KEY (`fk_asset`) REFERENCES `llx_asset` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_asset_dof_asset_model` FOREIGN KEY (`fk_asset_model`) REFERENCES `llx_asset_model` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_asset_dof_user_modif` FOREIGN KEY (`fk_user_modif`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_asset_extrafields`;
CREATE TABLE `llx_asset_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_asset_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_asset_model`;
CREATE TABLE `llx_asset_model` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `ref` varchar(128) NOT NULL,
  `label` varchar(255) NOT NULL,
  `asset_type` smallint NOT NULL,
  `fk_pays` int DEFAULT '0',
  `note_public` text,
  `note_private` text,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `status` smallint NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_asset_model` (`entity`,`ref`),
  KEY `idx_asset_model_rowid` (`rowid`),
  KEY `idx_asset_model_ref` (`ref`),
  KEY `idx_asset_model_pays` (`fk_pays`),
  KEY `idx_asset_model_entity` (`entity`),
  KEY `fk_asset_model_user_creat` (`fk_user_creat`),
  KEY `fk_asset_model_user_modif` (`fk_user_modif`),
  CONSTRAINT `fk_asset_model_user_creat` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_asset_model_user_modif` FOREIGN KEY (`fk_user_modif`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_asset_model_extrafields`;
CREATE TABLE `llx_asset_model_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_asset_model_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_bank`;
CREATE TABLE `llx_bank` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datev` date DEFAULT NULL,
  `dateo` date DEFAULT NULL,
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `label` varchar(255) DEFAULT NULL,
  `fk_account` int DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_rappro` int DEFAULT NULL,
  `fk_type` varchar(6) DEFAULT NULL,
  `num_releve` varchar(50) DEFAULT NULL,
  `num_chq` varchar(50) DEFAULT NULL,
  `numero_compte` varchar(32) DEFAULT NULL,
  `rappro` tinyint DEFAULT '0',
  `note` text,
  `fk_bordereau` int DEFAULT '0',
  `banque` varchar(255) DEFAULT NULL,
  `emetteur` varchar(255) DEFAULT NULL,
  `author` varchar(40) DEFAULT NULL,
  `origin_id` int DEFAULT NULL,
  `origin_type` varchar(64) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `amount_main_currency` double(24,8) DEFAULT NULL,
  `position` int DEFAULT '0',
  PRIMARY KEY (`rowid`),
  KEY `idx_bank_datev` (`datev`),
  KEY `idx_bank_dateo` (`dateo`),
  KEY `idx_bank_fk_account` (`fk_account`),
  KEY `idx_bank_rappro` (`rappro`),
  KEY `idx_bank_num_releve` (`num_releve`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=latin1;

INSERT INTO `llx_bank` VALUES("1","2018-12-20 13:15:04",NULL,"2018-12-20","2018-12-20","0.00000000","(Solde initial)","1","1",NULL,"SOLD",NULL,NULL,"","0",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("2","2019-04-12 14:59:18",NULL,"2019-04-12","2019-04-12","400.00000000","(CustomerInvoicePayment)","1","1",NULL,"VIR2",NULL,NULL,"","0",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("3","2019-05-15 08:55:33",NULL,"2019-04-01","2019-04-01","800.00000000","(CustomerInvoicePayment)","1","1",NULL,"VIR",NULL,NULL,"","0",NULL,"0",NULL,"Cophil International",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("4","2019-08-08 16:51:52",NULL,"2019-08-08","2019-08-08","400.00000000","(CustomerInvoicePayment)","1","1",NULL,"VIR",NULL,NULL,"","0",NULL,"0",NULL,"Cophil International",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("5","2019-12-05 19:55:36",NULL,"2019-11-06","2019-11-06","200.00000000","(CustomerInvoicePayment)","1","1",NULL,"VIR",NULL,NULL,"","0",NULL,"0",NULL,"Cophil International",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("6","2020-03-06 14:00:58",NULL,"2020-02-04","2020-02-04","200.00000000","(CustomerInvoicePayment)","1","1",NULL,"VIR",NULL,NULL,"","0",NULL,"0",NULL,"Cophil International",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("7","2020-06-10 12:26:22",NULL,"2020-02-10","2020-02-10","1250.00000000","(CustomerInvoicePayment)","1","1",NULL,"CHQ",NULL,NULL,"","0",NULL,"0",NULL,"Cabinet MAXIM-VALERY",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("8","2020-07-09 12:04:38",NULL,"2020-05-31","2020-05-31","1800.00000000","(CustomerInvoicePayment)","1","1",NULL,"VIR",NULL,NULL,"","0",NULL,"0",NULL,"Cophil International",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("9","2020-07-09 12:08:11",NULL,"2020-06-11","2020-06-11","127.99000000","(CustomerInvoicePayment)","1","1",NULL,"VIR",NULL,NULL,"","0",NULL,"0",NULL,"Komaki shushi",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("10","2020-10-19 10:30:57",NULL,"2020-08-22","2020-08-22","850.00000000","(CustomerInvoicePayment)","1","1",NULL,"CHQ",NULL,NULL,"","0",NULL,"0",NULL,"Maison Garbage",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("11","2021-05-19 10:04:46",NULL,"2020-07-29","2020-07-29","500.00000000","(CustomerInvoicePayment)","1","1",NULL,"CHQ",NULL,NULL,"","0",NULL,"0",NULL,"Slimane Foie Gras",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("12","2021-05-19 10:05:40",NULL,"2020-09-21","2020-09-21","300.00000000","(CustomerInvoicePayment)","1","1",NULL,"CHQ",NULL,NULL,"","0",NULL,"0",NULL,"Slimane Foie Gras",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("13","2021-05-19 10:06:15",NULL,"2020-12-30","2020-12-30","1000.00000000","(CustomerInvoicePayment)","1","1",NULL,"CHQ",NULL,NULL,"","0",NULL,"0",NULL,"Slimane Foie Gras",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("14","2021-08-08 08:47:35",NULL,"2021-04-20","2021-04-20","1970.00000000","(CustomerInvoicePayment)","1","1",NULL,"VIR",NULL,NULL,"","0",NULL,"0",NULL,"Cophil International",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("15","2021-08-08 08:48:08",NULL,"2021-03-21","2021-03-21","1275.00000000","(CustomerInvoicePayment)","1","1",NULL,"CHQ",NULL,NULL,"","0",NULL,"0",NULL,"Cabinet MAXIM-VALERY",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("16","2021-08-08 08:48:51",NULL,"2021-05-04","2021-05-04","200.00000000","(CustomerInvoicePayment)","1","1",NULL,"CHQ",NULL,NULL,"","0",NULL,"0",NULL,"FITAN et FILS SAS Billards de France",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("17","2021-08-08 08:50:24",NULL,"2021-08-08","2021-08-08","850.00000000","(CustomerInvoicePayment)","1","1",NULL,"CHQ",NULL,NULL,"","0",NULL,"0",NULL,"Maison Garbage",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("18","2021-08-08 08:51:16",NULL,"2020-09-30","2020-09-30","200.00000000","(CustomerInvoicePayment)","1","1",NULL,"VIR",NULL,NULL,"","0",NULL,"0",NULL,"Cophil International",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("19","2022-06-07 21:17:33",NULL,"2022-06-07","2022-06-07","0.00000000","(Solde initial)","2","1",NULL,"SOLD",NULL,NULL,"","0",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("20","2022-06-13 11:13:37",NULL,"2022-06-10","2022-06-10","130.00000000","(CustomerInvoicePayment)","2","1",NULL,"VIR2",NULL,NULL,"","0",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("21","2022-10-27 17:13:45",NULL,"2022-10-27","2022-10-27","1100.00000000","(CustomerInvoicePayment)","2","1",NULL,"CHQ",NULL,NULL,"","0",NULL,"0",NULL,"Imprimerie Augé",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("22","2023-05-31 00:20:49",NULL,"2022-11-25","2022-11-25","716.99000000","(CustomerInvoicePayment)","2","1",NULL,"CHQ",NULL,NULL,"","0",NULL,"0",NULL,"Kit Auto",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("23","2023-05-31 00:23:10",NULL,"2022-09-08","2022-09-08","800.00000000","(CustomerInvoicePayment)","2","1",NULL,"VIR2",NULL,NULL,"","0",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("24","2023-09-11 11:03:14",NULL,"2023-09-08","2023-09-08","30.00000000","(CustomerInvoicePayment)","2","1",NULL,"CHQ",NULL,NULL,"","0",NULL,"0",NULL,"FITAN et FILS SAS Billards de France",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("25","2023-10-03 11:46:18",NULL,"2023-06-02","2023-06-02","800.00000000","(CustomerInvoicePayment)","2","1",NULL,"VIR2",NULL,NULL,"","0",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("26","2023-12-13 11:22:52",NULL,"2023-09-18","2023-09-18","400.00000000","(CustomerInvoicePayment)","2","1",NULL,"PAYPAL",NULL,NULL,"","0",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("27","2023-12-13 11:23:44",NULL,"2023-11-13","2023-11-13","400.00000000","(CustomerInvoicePayment)","2","1",NULL,"PAYPAL",NULL,NULL,"","0",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("28","2023-12-13 11:26:44",NULL,"2020-12-02","2020-12-02","250.00000000","(CustomerInvoicePayment)","2","1",NULL,"VIR",NULL,NULL,"","0",NULL,"0",NULL,"Planet form Tarbes",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("29","2024-03-23 21:20:57",NULL,"2024-01-01","2024-01-01","300.00000000","(CustomerInvoicePayment)","2","1",NULL,"CHQ",NULL,NULL,"","0",NULL,"0",NULL,"GDSA65",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("30","2024-03-23 21:26:17",NULL,"2021-09-20","2021-09-20","2980.00000000","(CustomerInvoicePayment)","2","1",NULL,"CHQ",NULL,NULL,"","0",NULL,"0",NULL,"FITAN et FILS SAS Billards de France",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("31","2024-10-11 18:31:57",NULL,"2024-10-11","2024-10-11","50.00000000","(CustomerInvoicePayment)","2","1",NULL,"CHQ",NULL,NULL,"","0",NULL,"0",NULL,"FITAN et FILS SAS Billards de France",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("32","2024-11-20 15:52:47",NULL,"2024-11-14","2024-11-14","64.00000000","(CustomerInvoicePayment)","2","1",NULL,"VIR",NULL,NULL,"","0",NULL,"0",NULL,"Maison Garbage",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("33","2024-11-20 15:56:02",NULL,"2024-11-15","2024-11-15","50.00000000","(CustomerInvoicePayment)","2","1",NULL,"VIR",NULL,NULL,"","0",NULL,"0",NULL,"Maison Garbage",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("34","2024-11-20 15:57:42",NULL,"2022-06-13","2022-06-13","60.00000000","(CustomerInvoicePayment)","2","1",NULL,"VIR",NULL,NULL,"","0",NULL,"0",NULL,"Maison Garbage",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_bank` VALUES("35","2024-12-03 17:46:25",NULL,"2024-12-03","2024-12-03","100.00000000","(CustomerInvoicePayment)","2","1",NULL,"VIR",NULL,NULL,"","0",NULL,"0",NULL,"Planet form Tarbes",NULL,NULL,NULL,NULL,NULL,"0");



DROP TABLE IF EXISTS `llx_bank_account`;
CREATE TABLE `llx_bank_account` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `ref` varchar(12) NOT NULL,
  `label` varchar(30) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `bank` varchar(60) DEFAULT NULL,
  `code_banque` varchar(128) DEFAULT NULL,
  `code_guichet` varchar(6) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `cle_rib` varchar(5) DEFAULT NULL,
  `bic` varchar(11) DEFAULT NULL,
  `bic_intermediate` varchar(11) DEFAULT NULL,
  `iban_prefix` varchar(34) DEFAULT NULL,
  `country_iban` varchar(2) DEFAULT NULL,
  `cle_iban` varchar(2) DEFAULT NULL,
  `domiciliation` varchar(255) DEFAULT NULL,
  `pti_in_ctti` smallint DEFAULT '0',
  `state_id` int DEFAULT NULL,
  `fk_pays` int NOT NULL,
  `proprio` varchar(60) DEFAULT NULL,
  `owner_address` varchar(255) DEFAULT NULL,
  `courant` smallint NOT NULL DEFAULT '0',
  `clos` smallint NOT NULL DEFAULT '0',
  `rappro` smallint DEFAULT '1',
  `url` varchar(128) DEFAULT NULL,
  `account_number` varchar(32) DEFAULT NULL,
  `fk_accountancy_journal` int DEFAULT NULL,
  `currency_code` varchar(3) NOT NULL,
  `min_allowed` int DEFAULT '0',
  `min_desired` int DEFAULT '0',
  `comment` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `ics` varchar(32) DEFAULT NULL,
  `ics_transfer` varchar(32) DEFAULT NULL,
  `owner_zip` varchar(25) DEFAULT NULL,
  `owner_town` varchar(50) DEFAULT NULL,
  `owner_country_id` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_bank_account_label` (`label`,`entity`),
  KEY `idx_fk_accountancy_journal` (`fk_accountancy_journal`),
  CONSTRAINT `fk_bank_account_accountancy_journal` FOREIGN KEY (`fk_accountancy_journal`) REFERENCES `llx_accounting_journal` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `llx_bank_account` VALUES("1","2018-12-20 12:15:04",NULL,"BNP","BNP","1",NULL,NULL,"BNP","30004","00752","00003144259","14","BNPAFRPPPAU",NULL,"FR76 3000 4007 5200 0031 4425 914",NULL,NULL,"BNPPARB TARBES (00752)","0","72","1","Benjou Abdelouhab","26 rue Jean Mermoz 65000 Tarbes","1","1","1",NULL,"",NULL,"EUR",NULL,NULL,"",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `llx_bank_account` VALUES("2","2022-06-07 19:17:33",NULL,"CA","Crédit Agricole","1",NULL,NULL,"Crédit Agricole","16906","01014","87044526725","79","AGRIFRPP869",NULL,"FR76 16906 01014 87044526725 79",NULL,NULL,"Tarbes","0","72","1","Benjou Abdelouhab","38 ter rue Raymond Peyres 65000 Tarbes","1","0","1",NULL,"",NULL,"EUR",NULL,NULL,"",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);



DROP TABLE IF EXISTS `llx_bank_account_extrafields`;
CREATE TABLE `llx_bank_account_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_bank_account_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_bank_categ`;
CREATE TABLE `llx_bank_categ` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `label` varchar(255) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_bank_class`;
CREATE TABLE `llx_bank_class` (
  `lineid` int NOT NULL,
  `fk_categ` int NOT NULL,
  UNIQUE KEY `uk_bank_class_lineid` (`lineid`,`fk_categ`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_bank_extrafields`;
CREATE TABLE `llx_bank_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_bank_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_bank_url`;
CREATE TABLE `llx_bank_url` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_bank` int DEFAULT NULL,
  `url_id` int DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `type` varchar(24) NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_bank_url` (`fk_bank`,`url_id`,`type`),
  KEY `idx_bank_url_url_id` (`url_id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=latin1;

INSERT INTO `llx_bank_url` VALUES("1","2","2","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("2","2","2","/htdocs/comm/card.php?socid=","Cophil International","company");
INSERT INTO `llx_bank_url` VALUES("3","3","3","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("4","3","2","/htdocs/comm/card.php?socid=","Cophil International","company");
INSERT INTO `llx_bank_url` VALUES("5","4","4","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("6","4","2","/htdocs/comm/card.php?socid=","Cophil International","company");
INSERT INTO `llx_bank_url` VALUES("7","5","5","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("8","5","2","/htdocs/comm/card.php?socid=","Cophil International","company");
INSERT INTO `llx_bank_url` VALUES("9","6","6","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("10","6","2","/htdocs/comm/card.php?socid=","Cophil International","company");
INSERT INTO `llx_bank_url` VALUES("11","7","7","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("12","7","8","/htdocs/comm/card.php?socid=","Cabinet MAXIM-VALERY","company");
INSERT INTO `llx_bank_url` VALUES("13","8","8","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("14","8","2","/htdocs/comm/card.php?socid=","Cophil International","company");
INSERT INTO `llx_bank_url` VALUES("15","9","9","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("16","9","1","/htdocs/comm/card.php?socid=","Komaki shushi","company");
INSERT INTO `llx_bank_url` VALUES("17","10","10","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("18","10","11","/htdocs/comm/card.php?socid=","Maison Garbage","company");
INSERT INTO `llx_bank_url` VALUES("19","11","11","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("20","11","10","/htdocs/comm/card.php?socid=","Slimane Foie Gras","company");
INSERT INTO `llx_bank_url` VALUES("21","12","12","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("22","12","10","/htdocs/comm/card.php?socid=","Slimane Foie Gras","company");
INSERT INTO `llx_bank_url` VALUES("23","13","13","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("24","13","10","/htdocs/comm/card.php?socid=","Slimane Foie Gras","company");
INSERT INTO `llx_bank_url` VALUES("25","14","14","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("26","14","2","/htdocs/comm/card.php?socid=","Cophil International","company");
INSERT INTO `llx_bank_url` VALUES("27","15","15","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("28","15","8","/htdocs/comm/card.php?socid=","Cabinet MAXIM-VALERY","company");
INSERT INTO `llx_bank_url` VALUES("29","16","16","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("30","16","16","/htdocs/comm/card.php?socid=","FITAN et FILS SAS Billards de France","company");
INSERT INTO `llx_bank_url` VALUES("31","17","17","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("32","17","11","/htdocs/comm/card.php?socid=","Maison Garbage","company");
INSERT INTO `llx_bank_url` VALUES("33","18","18","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("34","18","2","/htdocs/comm/card.php?socid=","Cophil International","company");
INSERT INTO `llx_bank_url` VALUES("35","20","19","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("36","20","1","/htdocs/comm/card.php?socid=","Komaki shushi","company");
INSERT INTO `llx_bank_url` VALUES("37","21","20","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("38","21","21","/htdocs/comm/card.php?socid=","Imprimerie Augé","company");
INSERT INTO `llx_bank_url` VALUES("39","22","21","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("40","22","22","/htdocs/comm/card.php?socid=","Kit Auto","company");
INSERT INTO `llx_bank_url` VALUES("41","23","22","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("42","23","4","/htdocs/comm/card.php?socid=","Planet form Tarbes","company");
INSERT INTO `llx_bank_url` VALUES("43","24","23","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("44","24","16","/htdocs/comm/card.php?socid=","FITAN et FILS SAS Billards de France","company");
INSERT INTO `llx_bank_url` VALUES("45","25","24","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("46","25","4","/htdocs/comm/card.php?socid=","Planet form Tarbes","company");
INSERT INTO `llx_bank_url` VALUES("47","26","25","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("48","26","23","/htdocs/comm/card.php?socid=","AMRI Mouhcine","company");
INSERT INTO `llx_bank_url` VALUES("49","27","26","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("50","27","23","/htdocs/comm/card.php?socid=","AMRI Mouhcine","company");
INSERT INTO `llx_bank_url` VALUES("51","28","27","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("52","28","4","/htdocs/comm/card.php?socid=","Planet form Tarbes","company");
INSERT INTO `llx_bank_url` VALUES("53","29","28","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("54","29","24","/htdocs/comm/card.php?socid=","GDSA65","company");
INSERT INTO `llx_bank_url` VALUES("55","30","29","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("56","30","16","/htdocs/comm/card.php?socid=","FITAN et FILS SAS Billards de France","company");
INSERT INTO `llx_bank_url` VALUES("57","31","30","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("58","31","16","/htdocs/comm/card.php?socid=","FITAN et FILS SAS Billards de France","company");
INSERT INTO `llx_bank_url` VALUES("59","32","31","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("60","32","11","/htdocs/comm/card.php?socid=","Maison Garbage","company");
INSERT INTO `llx_bank_url` VALUES("61","33","32","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("62","33","11","/htdocs/comm/card.php?socid=","Maison Garbage","company");
INSERT INTO `llx_bank_url` VALUES("63","34","33","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("64","34","11","/htdocs/comm/card.php?socid=","Maison Garbage","company");
INSERT INTO `llx_bank_url` VALUES("65","35","34","/htdocs/compta/paiement/card.php?id=","(paiement)","payment");
INSERT INTO `llx_bank_url` VALUES("66","35","4","/htdocs/comm/card.php?socid=","Planet form Tarbes","company");



DROP TABLE IF EXISTS `llx_blockedlog`;
CREATE TABLE `llx_blockedlog` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `date_creation` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `action` varchar(50) DEFAULT NULL,
  `amounts` double(24,8) NOT NULL,
  `element` varchar(50) DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `user_fullname` varchar(255) DEFAULT NULL,
  `fk_object` int DEFAULT NULL,
  `ref_object` varchar(255) DEFAULT NULL,
  `date_object` datetime DEFAULT NULL,
  `signature` varchar(100) NOT NULL,
  `signature_line` varchar(100) NOT NULL,
  `object_data` mediumtext,
  `certified` int DEFAULT NULL,
  `object_version` varchar(32) DEFAULT '',
  PRIMARY KEY (`rowid`),
  KEY `signature` (`signature`),
  KEY `fk_object_element` (`fk_object`,`element`),
  KEY `entity` (`entity`),
  KEY `fk_user` (`fk_user`),
  KEY `entity_action` (`entity`,`action`),
  KEY `entity_action_certified` (`entity`,`action`,`certified`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_blockedlog_authority`;
CREATE TABLE `llx_blockedlog_authority` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `blockchain` longtext NOT NULL,
  `signature` varchar(100) NOT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `signature` (`signature`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_bom_bom`;
CREATE TABLE `llx_bom_bom` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `ref` varchar(128) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `note_public` text,
  `note_private` text,
  `fk_product` int DEFAULT NULL,
  `qty` double(24,8) DEFAULT NULL,
  `efficiency` double(8,4) DEFAULT NULL,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_valid` datetime DEFAULT NULL,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `status` int NOT NULL,
  `duration` double(24,8) DEFAULT NULL,
  `fk_warehouse` int DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `bomtype` int DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_bom_bom_ref` (`ref`,`entity`),
  KEY `idx_bom_bom_rowid` (`rowid`),
  KEY `idx_bom_bom_ref` (`ref`),
  KEY `llx_bom_bom_fk_user_creat` (`fk_user_creat`),
  KEY `idx_bom_bom_status` (`status`),
  KEY `idx_bom_bom_fk_product` (`fk_product`),
  CONSTRAINT `llx_bom_bom_fk_user_creat` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_bom_bom_extrafields`;
CREATE TABLE `llx_bom_bom_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_bom_bom_extrafields_fk_object` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_bom_bomline`;
CREATE TABLE `llx_bom_bomline` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_bom` int NOT NULL,
  `fk_product` int NOT NULL,
  `fk_bom_child` int DEFAULT NULL,
  `description` text,
  `import_key` varchar(14) DEFAULT NULL,
  `qty` double(24,8) NOT NULL,
  `efficiency` double(8,4) NOT NULL DEFAULT '1.0000',
  `position` int NOT NULL,
  `qty_frozen` smallint DEFAULT '0',
  `disable_stock_change` smallint DEFAULT '0',
  `fk_unit` int DEFAULT NULL,
  `fk_default_workstation` int DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rowid`),
  KEY `idx_bom_bomline_rowid` (`rowid`),
  KEY `idx_bom_bomline_fk_product` (`fk_product`),
  KEY `idx_bom_bomline_fk_bom` (`fk_bom`),
  CONSTRAINT `llx_bom_bomline_fk_bom` FOREIGN KEY (`fk_bom`) REFERENCES `llx_bom_bom` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_bom_bomline_extrafields`;
CREATE TABLE `llx_bom_bomline_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_bookmark`;
CREATE TABLE `llx_bookmark` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_user` int NOT NULL,
  `dateb` datetime DEFAULT NULL,
  `url` text,
  `target` varchar(16) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `favicon` varchar(24) DEFAULT NULL,
  `position` int DEFAULT '0',
  `entity` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_bookmark_title` (`fk_user`,`entity`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_bordereau_cheque`;
CREATE TABLE `llx_bordereau_cheque` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `datec` datetime NOT NULL,
  `date_bordereau` date DEFAULT NULL,
  `amount` double(24,8) NOT NULL,
  `nbcheque` smallint NOT NULL,
  `fk_bank_account` int DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `statut` smallint NOT NULL DEFAULT '0',
  `tms` timestamp NULL DEFAULT NULL,
  `note` text,
  `entity` int NOT NULL DEFAULT '1',
  `type` varchar(6) DEFAULT 'CHQ',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_bordereau_cheque` (`ref`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_boxes`;
CREATE TABLE `llx_boxes` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `box_id` int NOT NULL,
  `position` smallint NOT NULL,
  `box_order` varchar(3) NOT NULL,
  `fk_user` int NOT NULL DEFAULT '0',
  `maxline` int DEFAULT NULL,
  `params` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_boxes` (`entity`,`box_id`,`position`,`fk_user`),
  KEY `idx_boxes_boxid` (`box_id`),
  KEY `idx_boxes_fk_user` (`fk_user`),
  CONSTRAINT `fk_boxes_box_id` FOREIGN KEY (`box_id`) REFERENCES `llx_boxes_def` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=latin1;

INSERT INTO `llx_boxes` VALUES("1","1","1","0","A01","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("2","1","2","0","A15","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("3","1","3","0","B14","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("4","1","4","0","A13","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("5","1","5","0","B12","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("6","1","6","0","A11","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("7","1","7","0","B10","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("8","1","8","0","A09","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("9","1","9","0","B08","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("10","1","10","0","A07","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("14","1","14","0","A03","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("15","1","15","0","B02","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("43","1","1","0","A02","1",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("44","1","15","0","A03","1",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("47","1","10","0","A06","1",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("48","1","9","0","A07","1",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("49","1","8","0","B01","1",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("50","1","7","0","B02","1",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("51","1","4","0","B03","1",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("52","1","3","0","B04","1",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("53","1","2","0","B05","1",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("55","1","29","0","0","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("56","1","31","0","0","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("57","1","32","0","0","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("58","1","33","0","0","0",NULL,NULL);
INSERT INTO `llx_boxes` VALUES("59","1","34","0","0","0",NULL,NULL);



DROP TABLE IF EXISTS `llx_boxes_def`;
CREATE TABLE `llx_boxes_def` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `file` varchar(200) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `tms` timestamp NULL DEFAULT NULL,
  `note` varchar(130) DEFAULT NULL,
  `fk_user` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_boxes_def` (`file`,`entity`,`note`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=latin1;

INSERT INTO `llx_boxes_def` VALUES("1","box_lastlogin.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("2","box_clients.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("3","box_prospect.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("4","box_contacts.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("5","box_activity.php","1",NULL,"(WarningUsingThisBoxSlowDown)","0");
INSERT INTO `llx_boxes_def` VALUES("6","box_goodcustomers.php","1",NULL,"(WarningUsingThisBoxSlowDown)","0");
INSERT INTO `llx_boxes_def` VALUES("7","box_graph_propales_permonth.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("8","box_propales.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("9","box_commandes.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("10","box_graph_orders_permonth.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("14","box_services_contracts.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("15","box_graph_product_distribution.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("17","box_funnel_of_prospection.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("19","box_scheduled_jobs.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("20","box_dolibarr_state_board.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("21","box_members_last_modified.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("22","box_members_last_subscriptions.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("23","box_members_subscriptions_by_year.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("24","box_members_by_type.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("25","box_graph_ticket_by_severity.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("26","box_graph_nb_ticket_last_x_days.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("27","box_graph_nb_tickets_type.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("28","box_graph_new_vs_close_ticket.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("29","box_comptes.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("30","box_birthdays.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("31","box_factures_imp.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("32","box_factures.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("33","box_graph_invoices_permonth.php","1",NULL,NULL,"0");
INSERT INTO `llx_boxes_def` VALUES("34","box_customers_outstanding_bill_reached.php","1",NULL,NULL,"0");



DROP TABLE IF EXISTS `llx_budget`;
CREATE TABLE `llx_budget` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `label` varchar(255) NOT NULL,
  `status` int DEFAULT NULL,
  `note` text,
  `date_start` date DEFAULT NULL,
  `date_end` date DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `import_key` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_budget_lines`;
CREATE TABLE `llx_budget_lines` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_budget` int NOT NULL,
  `fk_project_ids` varchar(180) NOT NULL,
  `amount` double(24,8) NOT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `import_key` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_budget_lines` (`fk_budget`,`fk_project_ids`),
  CONSTRAINT `fk_budget_lines_budget` FOREIGN KEY (`fk_budget`) REFERENCES `llx_budget` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_c_accounting_category`;
CREATE TABLE `llx_c_accounting_category` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `code` varchar(16) NOT NULL,
  `label` varchar(255) NOT NULL,
  `range_account` varchar(255) NOT NULL,
  `sens` tinyint NOT NULL DEFAULT '0',
  `category_type` tinyint NOT NULL DEFAULT '0',
  `formula` varchar(255) NOT NULL,
  `position` int DEFAULT '0',
  `fk_country` int DEFAULT NULL,
  `active` int DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_accounting_category` (`code`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_accounting_category` VALUES("1","1","INCOMES","Income of products/services","Example: 7xxxxx","0","0","","10","0","1");
INSERT INTO `llx_c_accounting_category` VALUES("2","1","EXPENSES","Expenses of products/services","Example: 6xxxxx","0","0","","20","0","1");
INSERT INTO `llx_c_accounting_category` VALUES("3","1","PROFIT","Balance","","0","1","INCOMES+EXPENSES","30","0","1");



DROP TABLE IF EXISTS `llx_c_action_trigger`;
CREATE TABLE `llx_c_action_trigger` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `elementtype` varchar(64) DEFAULT NULL,
  `code` varchar(128) DEFAULT NULL,
  `label` varchar(128) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `rang` int DEFAULT '0',
  `contexts` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_action_trigger_code` (`code`),
  KEY `idx_action_trigger_rang` (`rang`)
) ENGINE=InnoDB AUTO_INCREMENT=311 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_action_trigger` VALUES("1","societe","COMPANY_CREATE","Third party created","Executed when a third party is created","1",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("2","societe","COMPANY_SENTBYMAIL","Mails sent from third party card","Executed when you send email from third party card","1",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("3","propal","PROPAL_VALIDATE","Customer proposal validated","Executed when a commercial proposal is validated","2",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("4","propal","PROPAL_SENTBYMAIL","Commercial proposal sent by mail","Executed when a commercial proposal is sent by mail","3",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("5","propal","PROPAL_CLOSE_SIGNED","Customer proposal closed signed","Executed when a customer proposal is closed signed","2",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("6","propal","PROPAL_CLOSE_REFUSED","Customer proposal closed refused","Executed when a customer proposal is closed refused","2",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("7","propal","PROPAL_CLASSIFY_BILLED","Customer proposal set billed","Executed when a customer proposal is set to billed","2",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("8","commande","ORDER_VALIDATE","Customer order validate","Executed when a customer order is validated","4",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("9","commande","ORDER_CLOSE","Customer order classify delivered","Executed when a customer order is set delivered","5",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("10","commande","ORDER_CLASSIFY_BILLED","Customer order classify billed","Executed when a customer order is set to billed","5",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("11","commande","ORDER_CANCEL","Customer order canceled","Executed when a customer order is canceled","5",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("12","commande","ORDER_SENTBYMAIL","Customer order sent by mail","Executed when a customer order is sent by mail ","5",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("13","facture","BILL_VALIDATE","Customer invoice validated","Executed when a customer invoice is approved","6",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("14","facture","BILL_PAYED","Customer invoice payed","Executed when a customer invoice is payed","7",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("15","facture","BILL_CANCEL","Customer invoice canceled","Executed when a customer invoice is conceled","8",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("16","facture","BILL_SENTBYMAIL","Customer invoice sent by mail","Executed when a customer invoice is sent by mail","9",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("17","facture","BILL_UNVALIDATE","Customer invoice unvalidated","Executed when a customer invoice status set back to draft","9",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("18","proposal_supplier","PROPOSAL_SUPPLIER_VALIDATE","Price request validated","Executed when a commercial proposal is validated","10",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("19","proposal_supplier","PROPOSAL_SUPPLIER_SENTBYMAIL","Price request sent by mail","Executed when a commercial proposal is sent by mail","10",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("20","proposal_supplier","PROPOSAL_SUPPLIER_CLOSE_SIGNED","Price request closed signed","Executed when a customer proposal is closed signed","10",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("21","proposal_supplier","PROPOSAL_SUPPLIER_CLOSE_REFUSED","Price request closed refused","Executed when a customer proposal is closed refused","10",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("22","order_supplier","ORDER_SUPPLIER_VALIDATE","Supplier order validated","Executed when a supplier order is validated","12",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("23","order_supplier","ORDER_SUPPLIER_APPROVE","Supplier order request approved","Executed when a supplier order is approved","13",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("24","order_supplier","ORDER_SUPPLIER_SUBMIT","Supplier order request submited","Executed when a supplier order is approved","13",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("25","order_supplier","ORDER_SUPPLIER_RECEIVE","Supplier order request received","Executed when a supplier order is received","13",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("26","order_supplier","ORDER_SUPPLIER_REFUSE","Supplier order request refused","Executed when a supplier order is refused","13",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("27","order_supplier","ORDER_SUPPLIER_SENTBYMAIL","Supplier order sent by mail","Executed when a supplier order is sent by mail","14",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("28","order_supplier","ORDER_SUPPLIER_CLASSIFY_BILLED","Supplier order set billed","Executed when a supplier order is set as billed","14",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("29","invoice_supplier","BILL_SUPPLIER_VALIDATE","Supplier invoice validated","Executed when a supplier invoice is validated","15",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("30","invoice_supplier","BILL_SUPPLIER_UNVALIDATE","Supplier invoice unvalidated","Executed when a supplier invoice status is set back to draft","15",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("31","invoice_supplier","BILL_SUPPLIER_PAYED","Supplier invoice payed","Executed when a supplier invoice is payed","16",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("32","invoice_supplier","BILL_SUPPLIER_SENTBYMAIL","Supplier invoice sent by mail","Executed when a supplier invoice is sent by mail","17",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("33","invoice_supplier","BILL_SUPPLIER_CANCELED","Supplier invoice cancelled","Executed when a supplier invoice is cancelled","17",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("34","contrat","CONTRACT_VALIDATE","Contract validated","Executed when a contract is validated","18",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("35","contrat","CONTRACT_SENTBYMAIL","Contract sent by mail","Executed when a contract is sent by mail","18",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("36","shipping","SHIPPING_VALIDATE","Shipping validated","Executed when a shipping is validated","20",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("37","shipping","SHIPPING_SENTBYMAIL","Shipping sent by mail","Executed when a shipping is sent by mail","21",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("38","member","MEMBER_VALIDATE","Member validated","Executed when a member is validated","22",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("39","member","MEMBER_SENTBYMAIL","Mails sent from member card","Executed when you send email from member card","23",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("40","member","MEMBER_SUBSCRIPTION_CREATE","Member subscribtion recorded","Executed when a member subscribtion is deleted","24",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("41","member","MEMBER_SUBSCRIPTION_MODIFY","Member subscribtion modified","Executed when a member subscribtion is modified","24",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("42","member","MEMBER_SUBSCRIPTION_DELETE","Member subscribtion deleted","Executed when a member subscribtion is deleted","24",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("43","member","MEMBER_RESILIATE","Member resiliated","Executed when a member is resiliated","25",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("44","member","MEMBER_DELETE","Member deleted","Executed when a member is deleted","26",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("45","ficheinter","FICHINTER_VALIDATE","Intervention validated","Executed when a intervention is validated","30",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("46","ficheinter","FICHINTER_CLASSIFY_BILLED","Intervention set billed","Executed when a intervention is set to billed (when option FICHINTER_CLASSIFY_BILLED is set)","32",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("47","ficheinter","FICHINTER_CLASSIFY_UNBILLED","Intervention set unbilled","Executed when a intervention is set to unbilled (when option FICHINTER_CLASSIFY_BILLED is set)","33",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("48","ficheinter","FICHINTER_REOPEN","Intervention opened","Executed when a intervention is re-opened","34",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("49","ficheinter","FICHINTER_SENTBYMAIL","Intervention sent by mail","Executed when a intervention is sent by mail","35",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("50","product","PRODUCT_CREATE","Product or service created","Executed when a product or sevice is created","40",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("51","product","PRODUCT_DELETE","Product or service deleted","Executed when a product or sevice is deleted","42",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("52","expensereport","EXPENSE_REPORT_CREATE","Expense report created","Executed when an expense report is created","201",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("53","expensereport","EXPENSE_REPORT_VALIDATE","Expense report validated","Executed when an expense report is validated","202",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("54","expensereport","EXPENSE_REPORT_APPROVE","Expense report approved","Executed when an expense report is approved","203",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("55","expensereport","EXPENSE_REPORT_PAID","Expense report billed","Executed when an expense report is set as billed","204",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("56","project","PROJECT_VALIDATE","Project validation","Executed when a project is validated","141",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("57","project","PROJECT_DELETE","Project deleted","Executed when a project is deleted","143",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("58","product","PRODUCT_MODIFY","Product or service modified","Executed when a product or sevice is modified","41",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("59","member","MEMBER_MODIFY","Member modified","Executed when a member is modified","23",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("60","ficheinter","FICHINTER_MODIFY","Intervention modified","Executed when a intervention is modified","31",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("61","project","PROJECT_CREATE","Project creation","Executed when a project is created","140",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("62","project","PROJECT_MODIFY","Project modified","Executed when a project is modified","142",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("63","project","TASK_CREATE","Task created","Executed when a project task is created","150",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("64","project","TASK_MODIFY","Task modified","Executed when a project task is modified","151",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("65","project","TASK_DELETE","Task deleted","Executed when a project task is deleted","152",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("66","societe","COMPANY_DELETE","Third party deleted","Executed when you delete third party","1",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("67","propal","PROPAL_DELETE","Customer proposal deleted","Executed when a customer proposal is deleted","2",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("68","commande","ORDER_DELETE","Customer order deleted","Executed when a customer order is deleted","5",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("69","facture","BILL_DELETE","Customer invoice deleted","Executed when a customer invoice is deleted","9",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("70","proposal_supplier","PROPOSAL_SUPPLIER_DELETE","Price request deleted","Executed when a customer proposal delete","10",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("71","order_supplier","ORDER_SUPPLIER_DELETE","Supplier order deleted","Executed when a supplier order is deleted","14",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("72","invoice_supplier","BILL_SUPPLIER_DELETE","Supplier invoice deleted","Executed when a supplier invoice is deleted","17",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("73","contrat","CONTRACT_DELETE","Contract deleted","Executed when a contract is deleted","18",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("74","ficheinter","FICHINTER_DELETE","Intervention is deleted","Executed when a intervention is deleted","35",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("75","expensereport","EXPENSE_REPORT_DELETE","Expense report deleted","Executed when an expense report is deleted","204",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("76","expensereport","HOLIDAY_VALIDATE","Expense report validated","Executed when an expense report is validated","202",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("77","expensereport","HOLIDAY_APPROVE","Expense report approved","Executed when an expense report is approved","203",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("78","ticket","TICKET_CREATE","Ticket created","Executed when a ticket is created","161",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("79","ticket","TICKET_MODIFY","Ticket modified","Executed when a ticket is modified","163",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("80","ticket","TICKET_ASSIGNED","Ticket assigned","Executed when a ticket is assigned to another user","164",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("81","ticket","TICKET_CLOSE","Ticket closed","Executed when a ticket is closed","165",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("82","ticket","TICKET_SENTBYMAIL","Ticket message sent by email","Executed when a message is sent from the ticket record","166",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("83","ticket","TICKET_DELETE","Ticket deleted","Executed when a ticket is deleted","167",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("84","user","USER_SENTBYMAIL","Email sent","Executed when an email is sent from user card","300",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("85","bom","BOM_VALIDATE","BOM validated","Executed when a BOM is validated","650",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("86","bom","BOM_UNVALIDATE","BOM unvalidated","Executed when a BOM is unvalidated","651",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("87","bom","BOM_CLOSE","BOM disabled","Executed when a BOM is disabled","652",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("88","bom","BOM_REOPEN","BOM reopen","Executed when a BOM is re-open","653",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("89","bom","BOM_DELETE","BOM deleted","Executed when a BOM deleted","654",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("90","bom","MRP_MO_VALIDATE","MO validated","Executed when a MO is validated","660",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("91","bom","MRP_MO_PRODUCED","MO produced","Executed when a MO is produced","661",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("92","bom","MRP_MO_DELETE","MO deleted","Executed when a MO is deleted","662",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("93","bom","MRP_MO_CANCEL","MO canceled","Executed when a MO is canceled","663",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("94","contact","CONTACT_CREATE","Contact address created","Executed when a contact is created","50",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("95","contact","CONTACT_SENTBYMAIL","Mails sent from third party card","Executed when you send email from contact adress card","51",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("96","contact","CONTACT_DELETE","Contact address deleted","Executed when a contact is deleted","52",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("97","recruitment","RECRUITMENTJOBPOSITION_CREATE","Job created","Executed when a job is created","7500",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("98","recruitment","RECRUITMENTJOBPOSITION_MODIFY","Job modified","Executed when a job is modified","7502",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("99","recruitment","RECRUITMENTJOBPOSITION_SENTBYMAIL","Mails sent from job record","Executed when you send email from job record","7504",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("100","recruitment","RECRUITMENTJOBPOSITION_DELETE","Job deleted","Executed when a job is deleted","7506",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("101","recruitment","RECRUITMENTCANDIDATURE_CREATE","Candidature created","Executed when a candidature is created","7510",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("102","recruitment","RECRUITMENTCANDIDATURE_MODIFY","Candidature modified","Executed when a candidature is modified","7512",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("103","recruitment","RECRUITMENTCANDIDATURE_SENTBYMAIL","Mails sent from candidature record","Executed when you send email from candidature record","7514",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("104","recruitment","RECRUITMENTCANDIDATURE_DELETE","Candidature deleted","Executed when a candidature is deleted","7516",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("126","societe","COMPANY_MODIFY","Third party update","Executed when you update third party","1",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("127","contact","CONTACT_MODIFY","Contact address update","Executed when a contact is updated","51",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("128","order_supplier","ORDER_SUPPLIER_CANCEL","Supplier order request canceled","Executed when a supplier order is canceled","13",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("129","member","MEMBER_EXCLUDE","Member excluded","Executed when a member is excluded","27",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("130","user","USER_CREATE","User created","Executed when a user is created","301",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("131","user","USER_MODIFY","User update","Executed when a user is updated","302",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("132","user","USER_DELETE","User update","Executed when a user is deleted","303",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("133","user","USER_NEW_PASSWORD","User update","Executed when a user is change password","304",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("134","user","USER_ENABLEDISABLE","User update","Executed when a user is enable or disable","305",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("135","holiday","HOLIDAY_CREATE","Holiday created","Executed when a holiday is created","800",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("136","holiday","HOLIDAY_MODIFY","Holiday modified","Executed when a holiday is modified","801",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("139","holiday","HOLIDAY_CANCEL","Holiday canceled","Executed when a holiday is canceled","802",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("140","holiday","HOLIDAY_DELETE","Holiday deleted","Executed when a holiday is deleted","804",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("141","propal","PROPAL_MODIFY","Customer proposal modified","Executed when a customer proposal is modified","2",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("142","commande","ORDER_MODIFY","Customer order modified","Executed when a customer order is set modified","5",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("143","facture","BILL_MODIFY","Customer invoice modified","Executed when a customer invoice is modified","7",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("144","proposal_supplier","PROPOSAL_SUPPLIER_MODIFY","Price request modified","Executed when a commercial proposal is modified","10",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("145","order_supplier","ORDER_SUPPLIER_MODIFY","Supplier order request modified","Executed when a supplier order is modified","13",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("146","invoice_supplier","BILL_SUPPLIER_MODIFY","Supplier invoice modified","Executed when a supplier invoice is modified","15",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("147","contrat","CONTRACT_MODIFY","Contract modified","Executed when a contract is modified","18",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("148","shipping","SHIPPING_MODIFY","Shipping modified","Executed when a shipping is modified","20",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("151","expensereport","EXPENSE_REPORT_MODIFY","Expense report modified","Executed when an expense report is modified","202",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("153","project","PROJECT_SENTBYMAIL","Project sent by mail","Executed when a project is sent by email","144",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("209","shipping","SHIPPING_DELETE","Shipping sent is deleted","Executed when a shipping is deleted","21",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("210","reception","RECEPTION_VALIDATE","Reception validated","Executed when a reception is validated","22",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("211","reception","RECEPTION_SENTBYMAIL","Reception sent by mail","Executed when a reception is sent by mail","22",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("282","agenda","ACTION_CREATE","Action added","Executed when an action is added to the agenda","700",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("289","facturerec","BILLREC_CREATE","Template invoices created","Executed when a Template invoices is created","900",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("290","facturerec","BILLREC_MODIFY","Template invoices update","Executed when a Template invoices is updated","901",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("291","facturerec","BILLREC_DELETE","Template invoices deleted","Executed when a Template invoices is deleted","902",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("292","facturerec","BILLREC_AUTOCREATEBILL","Template invoices use to create invoices with auto batch","Executed when a Template invoices is use to create invoice with auto batch","903",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("293","project","PROJECT_CLOSE","Project closed","Executed when a project is closed","145",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("298","partnership","PARTNERSHIP_CREATE","Partnership created","Executed when a partnership is created","58000",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("299","partnership","PARTNERSHIP_MODIFY","Partnership modified","Executed when a partnership is modified","58002",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("300","partnership","PARTNERSHIP_SENTBYMAIL","Mails sent from partnership file","Executed when you send email from partnership file","58004",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("301","partnership","PARTNERSHIP_DELETE","Partnership deleted","Executed when a partnership is deleted","58006",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("302","hrm","HRM_EVALUATION_CREATE","HR Evaluation created","Executed when an evaluation is created","4000",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("303","hrm","HRM_EVALUATION_MODIFY","HR Evaluation modified","Executed when an evaluation is modified","4001",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("304","hrm","HRM_EVALUATION_VALIDATE","HR Evaluation validated","Executed when an evaluation is validated","4002",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("305","hrm","HRM_EVALUATION_UNVALIDATE","HR Evaluation back to draft","Executed when an evaluation is back to draft","4003",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("306","hrm","HRM_EVALUATION_DELETE","HR Evaluation deleted","Executed when an evaluation is dleted","4005",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("307","societe","COMPANY_RIB_CREATE","Third party payment information created","Executed when a third party payment information is created","1",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("308","societe","COMPANY_RIB_MODIFY","Third party payment information updated","Executed when a third party payment information is updated","1",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("309","societe","COMPANY_RIB_DELETE","Third party payment information deleted","Executed when a third party payment information is deleted","1",NULL);
INSERT INTO `llx_c_action_trigger` VALUES("310","ficheinter","FICHINTER_CLOSE","Intervention is done","Executed when a intervention is done","36",NULL);



DROP TABLE IF EXISTS `llx_c_actioncomm`;
CREATE TABLE `llx_c_actioncomm` (
  `id` int NOT NULL,
  `code` varchar(50) NOT NULL,
  `type` varchar(50) NOT NULL DEFAULT 'system',
  `libelle` varchar(128) DEFAULT NULL,
  `module` varchar(50) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `todo` tinyint DEFAULT NULL,
  `color` varchar(9) DEFAULT NULL,
  `picto` varchar(48) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_actioncomm` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_actioncomm` VALUES("1","AC_TEL","system","Phone call",NULL,"1",NULL,NULL,NULL,"2");
INSERT INTO `llx_c_actioncomm` VALUES("2","AC_FAX","system","Send Fax",NULL,"1",NULL,NULL,NULL,"3");
INSERT INTO `llx_c_actioncomm` VALUES("4","AC_EMAIL","system","Send Email",NULL,"1",NULL,NULL,NULL,"4");
INSERT INTO `llx_c_actioncomm` VALUES("5","AC_RDV","system","Rendez-vous",NULL,"1",NULL,NULL,NULL,"1");
INSERT INTO `llx_c_actioncomm` VALUES("6","AC_EMAIL_IN","system","reception Email",NULL,"1",NULL,NULL,NULL,"4");
INSERT INTO `llx_c_actioncomm` VALUES("11","AC_INT","system","Intervention on site",NULL,"1",NULL,NULL,NULL,"4");
INSERT INTO `llx_c_actioncomm` VALUES("40","AC_OTH_AUTO","systemauto","Other (automatically inserted events)",NULL,"1",NULL,NULL,NULL,"20");
INSERT INTO `llx_c_actioncomm` VALUES("50","AC_OTH","system","Other (manually inserted events)",NULL,"1",NULL,NULL,NULL,"5");
INSERT INTO `llx_c_actioncomm` VALUES("60","AC_EO_ONLINECONF","module","Online/Virtual conference","conference@eventorganization","1",NULL,NULL,NULL,"60");
INSERT INTO `llx_c_actioncomm` VALUES("61","AC_EO_INDOORCONF","module","Indoor conference","conference@eventorganization","1",NULL,NULL,NULL,"61");
INSERT INTO `llx_c_actioncomm` VALUES("62","AC_EO_ONLINEBOOTH","module","Online/Virtual booth","booth@eventorganization","1",NULL,NULL,NULL,"62");
INSERT INTO `llx_c_actioncomm` VALUES("63","AC_EO_INDOORBOOTH","module","Indoor booth","booth@eventorganization","1",NULL,NULL,NULL,"63");



DROP TABLE IF EXISTS `llx_c_asset_disposal_type`;
CREATE TABLE `llx_c_asset_disposal_type` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `code` varchar(16) NOT NULL,
  `label` varchar(50) NOT NULL,
  `active` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_asset_disposal_type` (`code`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_c_availability`;
CREATE TABLE `llx_c_availability` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(30) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `position` int NOT NULL DEFAULT '0',
  `type_duration` varchar(1) DEFAULT NULL,
  `qty` double DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_availability` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_availability` VALUES("1","AV_NOW","Immediate","1","0",NULL,"0");
INSERT INTO `llx_c_availability` VALUES("2","AV_1W","1 week","1","0","w","1");
INSERT INTO `llx_c_availability` VALUES("3","AV_2W","2 weeks","1","0","w","2");
INSERT INTO `llx_c_availability` VALUES("4","AV_3W","3 weeks","1","0","w","3");



DROP TABLE IF EXISTS `llx_c_barcode_type`;
CREATE TABLE `llx_c_barcode_type` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(16) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `libelle` varchar(128) DEFAULT NULL,
  `coder` varchar(16) NOT NULL,
  `example` varchar(16) NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_barcode_type` (`code`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_c_chargesociales`;
CREATE TABLE `llx_c_chargesociales` (
  `id` int NOT NULL AUTO_INCREMENT,
  `libelle` varchar(128) DEFAULT NULL,
  `deductible` smallint NOT NULL DEFAULT '0',
  `active` tinyint NOT NULL DEFAULT '1',
  `code` varchar(12) NOT NULL,
  `accountancy_code` varchar(32) DEFAULT NULL,
  `fk_pays` int NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10214 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_chargesociales` VALUES("1","Allocations familiales","1","1","TAXFAM",NULL,"1",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("2","CSG Deductible","1","1","TAXCSGD",NULL,"1",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("3","CSG/CRDS NON Deductible","0","1","TAXCSGND",NULL,"1",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("10","Taxe apprentissage","0","1","TAXAPP",NULL,"1",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("11","Taxe professionnelle","0","1","TAXPRO",NULL,"1",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("12","Cotisation fonciere des entreprises","0","1","TAXCFE",NULL,"1",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("13","Cotisation sur la valeur ajoutee des entreprises","0","1","TAXCVAE",NULL,"1",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("20","Impots locaux/fonciers","0","1","TAXFON",NULL,"1",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("25","Impots revenus","0","1","TAXREV",NULL,"1",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("30","Assurance Sante","0","1","TAXSECU",NULL,"1",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("40","Mutuelle","0","1","TAXMUT",NULL,"1",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("50","Assurance vieillesse","0","1","TAXRET",NULL,"1",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("60","Assurance Chomage","0","1","TAXCHOM",NULL,"1",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("201","ONSS","1","1","TAXBEONSS",NULL,"2",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("210","Precompte professionnel","1","1","TAXBEPREPRO",NULL,"2",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("220","Prime existence","1","1","TAXBEPRIEXI",NULL,"2",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("230","Precompte immobilier","1","1","TAXBEPREIMMO",NULL,"2",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("4101","Krankenversicherung","1","1","TAXATKV",NULL,"41",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("4102","Unfallversicherung","1","1","TAXATUV",NULL,"41",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("4103","Pensionsversicherung","1","1","TAXATPV",NULL,"41",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("4104","Arbeitslosenversicherung","1","1","TAXATAV",NULL,"41",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("4105","Insolvenzentgeltsicherungsfond","1","1","TAXATIESG",NULL,"41",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("4106","Wohnbauförderung","1","1","TAXATWF",NULL,"41",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("4107","Arbeiterkammerumlage","1","1","TAXATAK",NULL,"41",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("4108","Mitarbeitervorsorgekasse","1","1","TAXATMVK",NULL,"41",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("4109","Familienlastenausgleichsfond","1","1","TAXATFLAF",NULL,"41",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("10201","????????? ????????? ?????? (???)","1","1","???",NULL,"102",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("10202","????? ???????? ????????? (???)","1","1","???",NULL,"102",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("10203","???????????? ???????? (????)","1","1","????",NULL,"102",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("10204","??????????? ????? ???????????","0","1","??????",NULL,"102",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("10205","??????? ????? ??????????? ???????? (??.?.?.?) ","0","1","?????",NULL,"102",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("10206","?????? ????? ?????????? ??????? ??? ?.?.??.","1","1","????",NULL,"102",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("10207","????????????? ????????????","1","1","??",NULL,"102",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("10208","???????? ??? ??????????? ????????????","1","1","???",NULL,"102",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("10209","???? ???????????","1","1","????",NULL,"102",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("10210","???????? ????????","1","1","????????",NULL,"102",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("10211","???????","1","1","???????",NULL,"102",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("10212","???????????","1","1","?????",NULL,"102",NULL);
INSERT INTO `llx_c_chargesociales` VALUES("10213","?????????????","1","1","?????",NULL,"102",NULL);



DROP TABLE IF EXISTS `llx_c_civility`;
CREATE TABLE `llx_c_civility` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(6) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_civility` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_civility` VALUES("1","MME","Madame","1",NULL);
INSERT INTO `llx_c_civility` VALUES("3","MR","Monsieur","1",NULL);
INSERT INTO `llx_c_civility` VALUES("5","MLE","Mademoiselle","1",NULL);
INSERT INTO `llx_c_civility` VALUES("7","MTRE","Maître","1",NULL);
INSERT INTO `llx_c_civility` VALUES("8","DR","Docteur","1",NULL);



DROP TABLE IF EXISTS `llx_c_country`;
CREATE TABLE `llx_c_country` (
  `rowid` int NOT NULL,
  `code` varchar(2) NOT NULL,
  `code_iso` varchar(3) DEFAULT NULL,
  `label` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `favorite` tinyint NOT NULL DEFAULT '0',
  `eec` tinyint NOT NULL DEFAULT '0',
  `numeric_code` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_c_country_code` (`code`),
  UNIQUE KEY `idx_c_country_label` (`label`),
  UNIQUE KEY `idx_c_country_code_iso` (`code_iso`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_country` VALUES("0","",NULL,"-","1","1","0",NULL);
INSERT INTO `llx_c_country` VALUES("1","FR","FRA","France","1","0","1","250");
INSERT INTO `llx_c_country` VALUES("2","BE","BEL","Belgium","1","0","1","056");
INSERT INTO `llx_c_country` VALUES("3","IT","ITA","Italy","1","0","1","380");
INSERT INTO `llx_c_country` VALUES("4","ES","ESP","Spain","1","0","1","724");
INSERT INTO `llx_c_country` VALUES("5","DE","DEU","Germany","1","0","1","276");
INSERT INTO `llx_c_country` VALUES("6","CH","CHE","Switzerland","1","0","0","756");
INSERT INTO `llx_c_country` VALUES("7","GB","GBR","United Kingdom","1","0","1","826");
INSERT INTO `llx_c_country` VALUES("8","IE","IRL","Irland","1","0","1","372");
INSERT INTO `llx_c_country` VALUES("9","CN","CHN","China","1","0","0","156");
INSERT INTO `llx_c_country` VALUES("10","TN","TUN","Tunisia","1","0","0","788");
INSERT INTO `llx_c_country` VALUES("11","US","USA","United States","1","0","0","840");
INSERT INTO `llx_c_country` VALUES("12","MA","MAR","Maroc","1","0","0","504");
INSERT INTO `llx_c_country` VALUES("13","DZ","DZA","Algeria","1","0","0","012");
INSERT INTO `llx_c_country` VALUES("14","CA","CAN","Canada","1","0","0","124");
INSERT INTO `llx_c_country` VALUES("15","TG","TGO","Togo","1","0","0","768");
INSERT INTO `llx_c_country` VALUES("16","GA","GAB","Gabon","1","0","0","266");
INSERT INTO `llx_c_country` VALUES("17","NL","NLD","Nederland","1","0","1","528");
INSERT INTO `llx_c_country` VALUES("18","HU","HUN","Hongrie","1","0","1","348");
INSERT INTO `llx_c_country` VALUES("19","RU","RUS","Russia","1","0","0","643");
INSERT INTO `llx_c_country` VALUES("20","SE","SWE","Sweden","1","0","1","752");
INSERT INTO `llx_c_country` VALUES("21","CI","CIV","Côte d\'Ivoire","1","0","0","384");
INSERT INTO `llx_c_country` VALUES("22","SN","SEN","Senegal","1","0","0","686");
INSERT INTO `llx_c_country` VALUES("23","AR","ARG","Argentine","1","0","0","032");
INSERT INTO `llx_c_country` VALUES("24","CM","CMR","Cameroun","1","0","0","120");
INSERT INTO `llx_c_country` VALUES("25","PT","PRT","Portugal","1","0","1","620");
INSERT INTO `llx_c_country` VALUES("26","SA","SAU","Saudi Arabia","1","0","0","682");
INSERT INTO `llx_c_country` VALUES("27","MC","MCO","Monaco","1","0","1","492");
INSERT INTO `llx_c_country` VALUES("28","AU","AUS","Australia","1","0","0","036");
INSERT INTO `llx_c_country` VALUES("29","SG","SGP","Singapour","1","0","0","702");
INSERT INTO `llx_c_country` VALUES("30","AF","AFG","Afghanistan","1","0","0","004");
INSERT INTO `llx_c_country` VALUES("31","AX","ALA","Iles Aland","1","0","0","248");
INSERT INTO `llx_c_country` VALUES("32","AL","ALB","Albanie","1","0","0","008");
INSERT INTO `llx_c_country` VALUES("33","AS","ASM","Samoa américaines","1","0","0","016");
INSERT INTO `llx_c_country` VALUES("34","AD","AND","Andorre","1","0","0","020");
INSERT INTO `llx_c_country` VALUES("35","AO","AGO","Angola","1","0","0","024");
INSERT INTO `llx_c_country` VALUES("36","AI","AIA","Anguilla","1","0","0","660");
INSERT INTO `llx_c_country` VALUES("37","AQ","ATA","Antarctique","1","0","0","010");
INSERT INTO `llx_c_country` VALUES("38","AG","ATG","Antigua-et-Barbuda","1","0","0","028");
INSERT INTO `llx_c_country` VALUES("39","AM","ARM","Arménie","1","0","0","051");
INSERT INTO `llx_c_country` VALUES("40","AW","ABW","Aruba","1","0","0","533");
INSERT INTO `llx_c_country` VALUES("41","AT","AUT","Autriche","1","0","1","040");
INSERT INTO `llx_c_country` VALUES("42","AZ","AZE","Azerbaïdjan","1","0","0","031");
INSERT INTO `llx_c_country` VALUES("43","BS","BHS","Bahamas","1","0","0","044");
INSERT INTO `llx_c_country` VALUES("44","BH","BHR","Bahreïn","1","0","0","048");
INSERT INTO `llx_c_country` VALUES("45","BD","BGD","Bangladesh","1","0","0","050");
INSERT INTO `llx_c_country` VALUES("46","BB","BRB","Barbade","1","0","0","052");
INSERT INTO `llx_c_country` VALUES("47","BY","BLR","Biélorussie","1","0","0","112");
INSERT INTO `llx_c_country` VALUES("48","BZ","BLZ","Belize","1","0","0","084");
INSERT INTO `llx_c_country` VALUES("49","BJ","BEN","Bénin","1","0","0","204");
INSERT INTO `llx_c_country` VALUES("50","BM","BMU","Bermudes","1","0","0","060");
INSERT INTO `llx_c_country` VALUES("51","BT","BTN","Bhoutan","1","0","0","064");
INSERT INTO `llx_c_country` VALUES("52","BO","BOL","Bolivie","1","0","0","068");
INSERT INTO `llx_c_country` VALUES("53","BA","BIH","Bosnie-Herzégovine","1","0","0","070");
INSERT INTO `llx_c_country` VALUES("54","BW","BWA","Botswana","1","0","0","072");
INSERT INTO `llx_c_country` VALUES("55","BV","BVT","Ile Bouvet","1","0","0","074");
INSERT INTO `llx_c_country` VALUES("56","BR","BRA","Brazil","1","0","0","076");
INSERT INTO `llx_c_country` VALUES("57","IO","IOT","Territoire britannique de l\'Océan Indien","1","0","0","086");
INSERT INTO `llx_c_country` VALUES("58","BN","BRN","Brunei","1","0","0","096");
INSERT INTO `llx_c_country` VALUES("59","BG","BGR","Bulgarie","1","0","1","100");
INSERT INTO `llx_c_country` VALUES("60","BF","BFA","Burkina Faso","1","0","0","854");
INSERT INTO `llx_c_country` VALUES("61","BI","BDI","Burundi","1","0","0","108");
INSERT INTO `llx_c_country` VALUES("62","KH","KHM","Cambodge","1","0","0","116");
INSERT INTO `llx_c_country` VALUES("63","CV","CPV","Cap-Vert","1","0","0","132");
INSERT INTO `llx_c_country` VALUES("64","KY","CYM","Iles Cayman","1","0","0","136");
INSERT INTO `llx_c_country` VALUES("65","CF","CAF","République centrafricaine","1","0","0","140");
INSERT INTO `llx_c_country` VALUES("66","TD","TCD","Tchad","1","0","0","148");
INSERT INTO `llx_c_country` VALUES("67","CL","CHL","Chili","1","0","0","152");
INSERT INTO `llx_c_country` VALUES("68","CX","CXR","Ile Christmas","1","0","0","162");
INSERT INTO `llx_c_country` VALUES("69","CC","CCK","Iles des Cocos (Keeling)","1","0","0","166");
INSERT INTO `llx_c_country` VALUES("70","CO","COL","Colombie","1","0","0","170");
INSERT INTO `llx_c_country` VALUES("71","KM","COM","Comores","1","0","0","174");
INSERT INTO `llx_c_country` VALUES("72","CG","COG","Congo","1","0","0","178");
INSERT INTO `llx_c_country` VALUES("73","CD","COD","République démocratique du Congo","1","0","0","180");
INSERT INTO `llx_c_country` VALUES("74","CK","COK","Iles Cook","1","0","0","184");
INSERT INTO `llx_c_country` VALUES("75","CR","CRI","Costa Rica","1","0","0","188");
INSERT INTO `llx_c_country` VALUES("76","HR","HRV","Croatie","1","0","1","191");
INSERT INTO `llx_c_country` VALUES("77","CU","CUB","Cuba","1","0","0","192");
INSERT INTO `llx_c_country` VALUES("78","CY","CYP","Cyprus","1","0","1","196");
INSERT INTO `llx_c_country` VALUES("79","CZ","CZE","République Tchèque","1","0","1","203");
INSERT INTO `llx_c_country` VALUES("80","DK","DNK","Danemark","1","0","1","208");
INSERT INTO `llx_c_country` VALUES("81","DJ","DJI","Djibouti","1","0","0","262");
INSERT INTO `llx_c_country` VALUES("82","DM","DMA","Dominique","1","0","0","212");
INSERT INTO `llx_c_country` VALUES("83","DO","DOM","République Dominicaine","1","0","0","214");
INSERT INTO `llx_c_country` VALUES("84","EC","ECU","Equateur","1","0","0","218");
INSERT INTO `llx_c_country` VALUES("85","EG","EGY","Egypte","1","0","0","818");
INSERT INTO `llx_c_country` VALUES("86","SV","SLV","Salvador","1","0","0","222");
INSERT INTO `llx_c_country` VALUES("87","GQ","GNQ","Guinée Equatoriale","1","0","0","226");
INSERT INTO `llx_c_country` VALUES("88","ER","ERI","Erythrée","1","0","0","232");
INSERT INTO `llx_c_country` VALUES("89","EE","EST","Estonia","1","0","1","233");
INSERT INTO `llx_c_country` VALUES("90","ET","ETH","Ethiopie","1","0","0","231");
INSERT INTO `llx_c_country` VALUES("91","FK","FLK","Iles Falkland","1","0","0","238");
INSERT INTO `llx_c_country` VALUES("92","FO","FRO","Iles Féroé","1","0","0","234");
INSERT INTO `llx_c_country` VALUES("93","FJ","FJI","Iles Fidji","1","0","0","242");
INSERT INTO `llx_c_country` VALUES("94","FI","FIN","Finlande","1","0","1","246");
INSERT INTO `llx_c_country` VALUES("95","GF","GUF","Guyane française","1","0","0","254");
INSERT INTO `llx_c_country` VALUES("96","PF","PYF","Polynésie française","1","0","0","258");
INSERT INTO `llx_c_country` VALUES("97","TF","ATF","Terres australes françaises","1","0","0","260");
INSERT INTO `llx_c_country` VALUES("98","GM","GMB","Gambie","1","0","0","270");
INSERT INTO `llx_c_country` VALUES("99","GE","GEO","Georgia","1","0","0","268");
INSERT INTO `llx_c_country` VALUES("100","GH","GHA","Ghana","1","0","0","288");
INSERT INTO `llx_c_country` VALUES("101","GI","GIB","Gibraltar","1","0","0","292");
INSERT INTO `llx_c_country` VALUES("102","GR","GRC","Greece","1","0","1","300");
INSERT INTO `llx_c_country` VALUES("103","GL","GRL","Groenland","1","0","0","304");
INSERT INTO `llx_c_country` VALUES("104","GD","GRD","Grenade","1","0","0","308");
INSERT INTO `llx_c_country` VALUES("106","GU","GUM","Guam","1","0","0","316");
INSERT INTO `llx_c_country` VALUES("107","GT","GTM","Guatemala","1","0","0","320");
INSERT INTO `llx_c_country` VALUES("108","GN","GIN","Guinea","1","0","0","324");
INSERT INTO `llx_c_country` VALUES("109","GW","GNB","Guinea-Bissao","1","0","0","624");
INSERT INTO `llx_c_country` VALUES("111","HT","HTI","Haiti","1","0","0","332");
INSERT INTO `llx_c_country` VALUES("112","HM","HMD","Iles Heard et McDonald","1","0","0","334");
INSERT INTO `llx_c_country` VALUES("113","VA","VAT","Saint-Siège (Vatican)","1","0","0","336");
INSERT INTO `llx_c_country` VALUES("114","HN","HND","Honduras","1","0","0","340");
INSERT INTO `llx_c_country` VALUES("115","HK","HKG","Hong Kong","1","0","0","344");
INSERT INTO `llx_c_country` VALUES("116","IS","ISL","Islande","1","0","0","352");
INSERT INTO `llx_c_country` VALUES("117","IN","IND","India","1","0","0","356");
INSERT INTO `llx_c_country` VALUES("118","ID","IDN","Indonésie","1","0","0","360");
INSERT INTO `llx_c_country` VALUES("119","IR","IRN","Iran","1","0","0","364");
INSERT INTO `llx_c_country` VALUES("120","IQ","IRQ","Iraq","1","0","0","368");
INSERT INTO `llx_c_country` VALUES("121","IL","ISR","Israel","1","0","0","376");
INSERT INTO `llx_c_country` VALUES("122","JM","JAM","Jamaïque","1","0","0","388");
INSERT INTO `llx_c_country` VALUES("123","JP","JPN","Japon","1","0","0","392");
INSERT INTO `llx_c_country` VALUES("124","JO","JOR","Jordanie","1","0","0","400");
INSERT INTO `llx_c_country` VALUES("125","KZ","KAZ","Kazakhstan","1","0","0","398");
INSERT INTO `llx_c_country` VALUES("126","KE","KEN","Kenya","1","0","0","404");
INSERT INTO `llx_c_country` VALUES("127","KI","KIR","Kiribati","1","0","0","296");
INSERT INTO `llx_c_country` VALUES("128","KP","PRK","North Corea","1","0","0","408");
INSERT INTO `llx_c_country` VALUES("129","KR","KOR","South Corea","1","0","0","410");
INSERT INTO `llx_c_country` VALUES("130","KW","KWT","Koweït","1","0","0","414");
INSERT INTO `llx_c_country` VALUES("131","KG","KGZ","Kirghizistan","1","0","0","417");
INSERT INTO `llx_c_country` VALUES("132","LA","LAO","Laos","1","0","0","418");
INSERT INTO `llx_c_country` VALUES("133","LV","LVA","Lettonie","1","0","1","428");
INSERT INTO `llx_c_country` VALUES("134","LB","LBN","Liban","1","0","0","422");
INSERT INTO `llx_c_country` VALUES("135","LS","LSO","Lesotho","1","0","0","426");
INSERT INTO `llx_c_country` VALUES("136","LR","LBR","Liberia","1","0","0","430");
INSERT INTO `llx_c_country` VALUES("137","LY","LBY","Libye","1","0","0","434");
INSERT INTO `llx_c_country` VALUES("138","LI","LIE","Liechtenstein","1","0","0","438");
INSERT INTO `llx_c_country` VALUES("139","LT","LTU","Lituanie","1","0","1","440");
INSERT INTO `llx_c_country` VALUES("140","LU","LUX","Luxembourg","1","0","1","442");
INSERT INTO `llx_c_country` VALUES("141","MO","MAC","Macao","1","0","0","446");
INSERT INTO `llx_c_country` VALUES("142","MK","MKD","ex-République yougoslave de Macédoine","1","0","0","807");
INSERT INTO `llx_c_country` VALUES("143","MG","MDG","Madagascar","1","0","0","450");
INSERT INTO `llx_c_country` VALUES("144","MW","MWI","Malawi","1","0","0","454");
INSERT INTO `llx_c_country` VALUES("145","MY","MYS","Malaisie","1","0","0","458");
INSERT INTO `llx_c_country` VALUES("146","MV","MDV","Maldives","1","0","0","462");
INSERT INTO `llx_c_country` VALUES("147","ML","MLI","Mali","1","0","0","466");
INSERT INTO `llx_c_country` VALUES("148","MT","MLT","Malte","1","0","1","470");
INSERT INTO `llx_c_country` VALUES("149","MH","MHL","Iles Marshall","1","0","0","584");
INSERT INTO `llx_c_country` VALUES("151","MR","MRT","Mauritanie","1","0","0","478");
INSERT INTO `llx_c_country` VALUES("152","MU","MUS","Maurice","1","0","0","480");
INSERT INTO `llx_c_country` VALUES("153","YT","MYT","Mayotte","1","0","0","175");
INSERT INTO `llx_c_country` VALUES("154","MX","MEX","Mexique","1","0","0","484");
INSERT INTO `llx_c_country` VALUES("155","FM","FSM","Micronésie","1","0","0","583");
INSERT INTO `llx_c_country` VALUES("156","MD","MDA","Moldavie","1","0","0","498");
INSERT INTO `llx_c_country` VALUES("157","MN","MNG","Mongolie","1","0","0","496");
INSERT INTO `llx_c_country` VALUES("158","MS","MSR","Monserrat","1","0","0","500");
INSERT INTO `llx_c_country` VALUES("159","MZ","MOZ","Mozambique","1","0","0","508");
INSERT INTO `llx_c_country` VALUES("160","MM","MMR","Birmanie (Myanmar)","1","0","0","104");
INSERT INTO `llx_c_country` VALUES("161","NA","NAM","Namibie","1","0","0","516");
INSERT INTO `llx_c_country` VALUES("162","NR","NRU","Nauru","1","0","0","520");
INSERT INTO `llx_c_country` VALUES("163","NP","NPL","Népal","1","0","0","524");
INSERT INTO `llx_c_country` VALUES("165","NC","NCL","Nouvelle-Calédonie","1","0","0","540");
INSERT INTO `llx_c_country` VALUES("166","NZ","NZL","Nouvelle-Zélande","1","0","0","554");
INSERT INTO `llx_c_country` VALUES("167","NI","NIC","Nicaragua","1","0","0","558");
INSERT INTO `llx_c_country` VALUES("168","NE","NER","Niger","1","0","0","562");
INSERT INTO `llx_c_country` VALUES("169","NG","NGA","Nigeria","1","0","0","566");
INSERT INTO `llx_c_country` VALUES("170","NU","NIU","Nioué","1","0","0","570");
INSERT INTO `llx_c_country` VALUES("171","NF","NFK","Ile Norfolk","1","0","0","574");
INSERT INTO `llx_c_country` VALUES("172","MP","MNP","Mariannes du Nord","1","0","0","580");
INSERT INTO `llx_c_country` VALUES("173","NO","NOR","Norvège","1","0","0","578");
INSERT INTO `llx_c_country` VALUES("174","OM","OMN","Oman","1","0","0","512");
INSERT INTO `llx_c_country` VALUES("175","PK","PAK","Pakistan","1","0","0","586");
INSERT INTO `llx_c_country` VALUES("176","PW","PLW","Palaos","1","0","0","585");
INSERT INTO `llx_c_country` VALUES("177","PS","PSE","Territoire Palestinien Occupé","1","0","0","275");
INSERT INTO `llx_c_country` VALUES("178","PA","PAN","Panama","1","0","0","591");
INSERT INTO `llx_c_country` VALUES("179","PG","PNG","Papouasie-Nouvelle-Guinée","1","0","0","598");
INSERT INTO `llx_c_country` VALUES("180","PY","PRY","Paraguay","1","0","0","600");
INSERT INTO `llx_c_country` VALUES("181","PE","PER","Peru","1","0","0","604");
INSERT INTO `llx_c_country` VALUES("182","PH","PHL","Philippines","1","0","0","608");
INSERT INTO `llx_c_country` VALUES("183","PN","PCN","Iles Pitcairn","1","0","0","612");
INSERT INTO `llx_c_country` VALUES("184","PL","POL","Pologne","1","0","1","616");
INSERT INTO `llx_c_country` VALUES("185","PR","PRI","Porto Rico","1","0","0","630");
INSERT INTO `llx_c_country` VALUES("186","QA","QAT","Qatar","1","0","0","634");
INSERT INTO `llx_c_country` VALUES("188","RO","ROU","Roumanie","1","0","1","642");
INSERT INTO `llx_c_country` VALUES("189","RW","RWA","Rwanda","1","0","0","646");
INSERT INTO `llx_c_country` VALUES("190","SH","SHN","Sainte-Hélène","1","0","0","654");
INSERT INTO `llx_c_country` VALUES("191","KN","KNA","Saint-Christophe-et-Niévès","1","0","0","659");
INSERT INTO `llx_c_country` VALUES("192","LC","LCA","Sainte-Lucie","1","0","0","662");
INSERT INTO `llx_c_country` VALUES("193","PM","SPM","Saint-Pierre-et-Miquelon","1","0","0","666");
INSERT INTO `llx_c_country` VALUES("194","VC","VCT","Saint-Vincent-et-les-Grenadines","1","0","0","670");
INSERT INTO `llx_c_country` VALUES("195","WS","WSM","Samoa","1","0","0","882");
INSERT INTO `llx_c_country` VALUES("196","SM","SMR","Saint-Marin","1","0","0","674");
INSERT INTO `llx_c_country` VALUES("197","ST","STP","Sao Tomé-et-Principe","1","0","0","678");
INSERT INTO `llx_c_country` VALUES("198","RS","SRB","Serbie","1","0","0","688");
INSERT INTO `llx_c_country` VALUES("199","SC","SYC","Seychelles","1","0","0","690");
INSERT INTO `llx_c_country` VALUES("200","SL","SLE","Sierra Leone","1","0","0","694");
INSERT INTO `llx_c_country` VALUES("201","SK","SVK","Slovaquie","1","0","1","703");
INSERT INTO `llx_c_country` VALUES("202","SI","SVN","Slovénie","1","0","1","705");
INSERT INTO `llx_c_country` VALUES("203","SB","SLB","Iles Salomon","1","0","0","090");
INSERT INTO `llx_c_country` VALUES("204","SO","SOM","Somalie","1","0","0","706");
INSERT INTO `llx_c_country` VALUES("205","ZA","ZAF","South Africa","1","0","0","710");
INSERT INTO `llx_c_country` VALUES("206","GS","SGS","Iles Géorgie du Sud et Sandwich du Sud","1","0","0","239");
INSERT INTO `llx_c_country` VALUES("207","LK","LKA","Sri Lanka","1","0","0","144");
INSERT INTO `llx_c_country` VALUES("208","SD","SDN","Soudan","1","0","0","729");
INSERT INTO `llx_c_country` VALUES("209","SR","SUR","Suriname","1","0","0","740");
INSERT INTO `llx_c_country` VALUES("210","SJ","SJM","Iles Svalbard et Jan Mayen","1","0","0","744");
INSERT INTO `llx_c_country` VALUES("211","SZ","SWZ","Swaziland","1","0","0","748");
INSERT INTO `llx_c_country` VALUES("212","SY","SYR","Syrie","1","0","0","760");
INSERT INTO `llx_c_country` VALUES("213","TW","TWN","Taïwan","1","0","0","158");
INSERT INTO `llx_c_country` VALUES("214","TJ","TJK","Tadjikistan","1","0","0","762");
INSERT INTO `llx_c_country` VALUES("215","TZ","TZA","Tanzanie","1","0","0","834");
INSERT INTO `llx_c_country` VALUES("216","TH","THA","Thaïlande","1","0","0","764");
INSERT INTO `llx_c_country` VALUES("217","TL","TLS","Timor Oriental","1","0","0","626");
INSERT INTO `llx_c_country` VALUES("218","TK","TKL","Tokélaou","1","0","0","772");
INSERT INTO `llx_c_country` VALUES("219","TO","TON","Tonga","1","0","0","776");
INSERT INTO `llx_c_country` VALUES("220","TT","TTO","Trinité-et-Tobago","1","0","0","780");
INSERT INTO `llx_c_country` VALUES("221","TR","TUR","Turquie","1","0","0","792");
INSERT INTO `llx_c_country` VALUES("222","TM","TKM","Turkménistan","1","0","0","795");
INSERT INTO `llx_c_country` VALUES("223","TC","TCA","Iles Turks-et-Caicos","1","0","0","796");
INSERT INTO `llx_c_country` VALUES("224","TV","TUV","Tuvalu","1","0","0","798");
INSERT INTO `llx_c_country` VALUES("225","UG","UGA","Ouganda","1","0","0","800");
INSERT INTO `llx_c_country` VALUES("226","UA","UKR","Ukraine","1","0","0","804");
INSERT INTO `llx_c_country` VALUES("227","AE","ARE","United Arab Emirates","1","0","0","784");
INSERT INTO `llx_c_country` VALUES("228","UM","UMI","Iles mineures éloignées des États-Unis","1","0","0","581");
INSERT INTO `llx_c_country` VALUES("229","UY","URY","Uruguay","1","0","0","858");
INSERT INTO `llx_c_country` VALUES("230","UZ","UZB","Ouzbékistan","1","0","0","860");
INSERT INTO `llx_c_country` VALUES("231","VU","VUT","Vanuatu","1","0","0","548");
INSERT INTO `llx_c_country` VALUES("232","VE","VEN","Vénézuela","1","0","0","862");
INSERT INTO `llx_c_country` VALUES("233","VN","VNM","Viêt Nam","1","0","0","704");
INSERT INTO `llx_c_country` VALUES("234","VG","VGB","Iles Vierges britanniques","1","0","0","092");
INSERT INTO `llx_c_country` VALUES("235","VI","VIR","Iles Vierges américaines","1","0","0","850");
INSERT INTO `llx_c_country` VALUES("236","WF","WLF","Wallis-et-Futuna","1","0","0","876");
INSERT INTO `llx_c_country` VALUES("237","EH","ESH","Sahara occidental","1","0","0","732");
INSERT INTO `llx_c_country` VALUES("238","YE","YEM","Yémen","1","0","0","887");
INSERT INTO `llx_c_country` VALUES("239","ZM","ZMB","Zambie","1","0","0","894");
INSERT INTO `llx_c_country` VALUES("240","ZW","ZWE","Zimbabwe","1","0","0","716");
INSERT INTO `llx_c_country` VALUES("241","GG","GGY","Guernesey","1","0","0","831");
INSERT INTO `llx_c_country` VALUES("242","IM","IMN","Ile de Man","1","0","1","833");
INSERT INTO `llx_c_country` VALUES("243","JE","JEY","Jersey","1","0","0","832");
INSERT INTO `llx_c_country` VALUES("244","ME","MNE","Monténégro","1","0","0","499");
INSERT INTO `llx_c_country` VALUES("245","BL","BLM","Saint-Barthélemy","1","0","0","652");
INSERT INTO `llx_c_country` VALUES("246","MF","MAF","Saint-Martin","1","0","0","663");
INSERT INTO `llx_c_country` VALUES("300","CW","CUW","Curaçao","1","0","0","531");
INSERT INTO `llx_c_country` VALUES("301","SX","SXM","Sint Maarten","1","0","0","534");



DROP TABLE IF EXISTS `llx_c_currencies`;
CREATE TABLE `llx_c_currencies` (
  `code_iso` varchar(3) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `unicode` varchar(32) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`code_iso`),
  UNIQUE KEY `uk_c_currencies_code_iso` (`code_iso`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_currencies` VALUES("AED","United Arab Emirates Dirham",NULL,"1");
INSERT INTO `llx_c_currencies` VALUES("AFN","Afghanistan Afghani","[1547]","1");
INSERT INTO `llx_c_currencies` VALUES("ALL","Albania Lek","[76,101,107]","1");
INSERT INTO `llx_c_currencies` VALUES("ANG","Netherlands Antilles Guilder","[402]","1");
INSERT INTO `llx_c_currencies` VALUES("ARP","Pesos argentins",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("ARS","Argentino Peso","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("ATS","Shiliing autrichiens",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("AUD","Australia Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("AWG","Aruba Guilder","[402]","1");
INSERT INTO `llx_c_currencies` VALUES("AZN","Azerbaijan New Manat","[1084,1072,1085]","1");
INSERT INTO `llx_c_currencies` VALUES("BAM","Bosnia and Herzegovina Convertible Marka","[75,77]","1");
INSERT INTO `llx_c_currencies` VALUES("BBD","Barbados Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("BDT","Bangladeshi Taka","[2547]","1");
INSERT INTO `llx_c_currencies` VALUES("BEF","Francs belges",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("BGN","Bulgaria Lev","[1083,1074]","1");
INSERT INTO `llx_c_currencies` VALUES("BHD","Bahrain",NULL,"1");
INSERT INTO `llx_c_currencies` VALUES("BMD","Bermuda Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("BND","Brunei Darussalam Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("BOB","Bolivia Boliviano","[36,98]","1");
INSERT INTO `llx_c_currencies` VALUES("BRL","Brazil Real","[82,36]","1");
INSERT INTO `llx_c_currencies` VALUES("BSD","Bahamas Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("BWP","Botswana Pula","[80]","1");
INSERT INTO `llx_c_currencies` VALUES("BYR","Belarus Ruble","[112,46]","1");
INSERT INTO `llx_c_currencies` VALUES("BZD","Belize Dollar","[66,90,36]","1");
INSERT INTO `llx_c_currencies` VALUES("CAD","Canada Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("CHF","Switzerland Franc","[67,72,70]","1");
INSERT INTO `llx_c_currencies` VALUES("CLP","Chile Peso","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("CNY","China Yuan Renminbi","[165]","1");
INSERT INTO `llx_c_currencies` VALUES("COP","Colombia Peso","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("CRC","Costa Rica Colon","[8353]","1");
INSERT INTO `llx_c_currencies` VALUES("CUP","Cuba Peso","[8369]","1");
INSERT INTO `llx_c_currencies` VALUES("CZK","Czech Republic Koruna","[75,269]","1");
INSERT INTO `llx_c_currencies` VALUES("DEM","Deutsch mark",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("DKK","Denmark Krone","[107,114]","1");
INSERT INTO `llx_c_currencies` VALUES("DOP","Dominican Republic Peso","[82,68,36]","1");
INSERT INTO `llx_c_currencies` VALUES("DZD","Algeria Dinar",NULL,"1");
INSERT INTO `llx_c_currencies` VALUES("EEK","Estonia Kroon","[107,114]","1");
INSERT INTO `llx_c_currencies` VALUES("EGP","Egypt Pound","[163]","1");
INSERT INTO `llx_c_currencies` VALUES("ESP","Pesete",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("EUR","Euro Member Countries","[8364]","1");
INSERT INTO `llx_c_currencies` VALUES("FIM","Mark finlandais",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("FJD","Fiji Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("FKP","Falkland Islands (Malvinas) Pound","[163]","1");
INSERT INTO `llx_c_currencies` VALUES("FRF","Francs francais",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("GBP","United Kingdom Pound","[163]","1");
INSERT INTO `llx_c_currencies` VALUES("GGP","Guernsey Pound","[163]","1");
INSERT INTO `llx_c_currencies` VALUES("GHC","Ghana Cedis","[162]","1");
INSERT INTO `llx_c_currencies` VALUES("GIP","Gibraltar Pound","[163]","1");
INSERT INTO `llx_c_currencies` VALUES("GNF","Franc Guinéen","[70,71]","1");
INSERT INTO `llx_c_currencies` VALUES("GRD","Drachme (grece)",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("GTQ","Guatemala Quetzal","[81]","1");
INSERT INTO `llx_c_currencies` VALUES("GYD","Guyana Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("HKD","Hong Kong Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("HNL","Honduras Lempira","[76]","1");
INSERT INTO `llx_c_currencies` VALUES("HRK","Croatia Kuna","[107,110]","1");
INSERT INTO `llx_c_currencies` VALUES("HUF","Hungary Forint","[70,116]","1");
INSERT INTO `llx_c_currencies` VALUES("IDR","Indonesia Rupiah","[82,112]","1");
INSERT INTO `llx_c_currencies` VALUES("IEP","Livres irlandaises",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("ILS","Israel Shekel","[8362]","1");
INSERT INTO `llx_c_currencies` VALUES("IMP","Isle of Man Pound","[163]","1");
INSERT INTO `llx_c_currencies` VALUES("INR","India Rupee",NULL,"1");
INSERT INTO `llx_c_currencies` VALUES("IRR","Iran Rial","[65020]","1");
INSERT INTO `llx_c_currencies` VALUES("ISK","Iceland Krona","[107,114]","1");
INSERT INTO `llx_c_currencies` VALUES("ITL","Lires",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("JEP","Jersey Pound","[163]","1");
INSERT INTO `llx_c_currencies` VALUES("JMD","Jamaica Dollar","[74,36]","1");
INSERT INTO `llx_c_currencies` VALUES("JPY","Japan Yen","[165]","1");
INSERT INTO `llx_c_currencies` VALUES("KES","Kenya Shilling",NULL,"1");
INSERT INTO `llx_c_currencies` VALUES("KGS","Kyrgyzstan Som","[1083,1074]","1");
INSERT INTO `llx_c_currencies` VALUES("KHR","Cambodia Riel","[6107]","1");
INSERT INTO `llx_c_currencies` VALUES("KPW","Korea (North) Won","[8361]","1");
INSERT INTO `llx_c_currencies` VALUES("KRW","Korea (South) Won","[8361]","1");
INSERT INTO `llx_c_currencies` VALUES("KYD","Cayman Islands Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("KZT","Kazakhstan Tenge","[1083,1074]","1");
INSERT INTO `llx_c_currencies` VALUES("LAK","Laos Kip","[8365]","1");
INSERT INTO `llx_c_currencies` VALUES("LBP","Lebanon Pound","[163]","1");
INSERT INTO `llx_c_currencies` VALUES("LKR","Sri Lanka Rupee","[8360]","1");
INSERT INTO `llx_c_currencies` VALUES("LRD","Liberia Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("LTL","Lithuania Litas","[76,116]","1");
INSERT INTO `llx_c_currencies` VALUES("LUF","Francs luxembourgeois",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("LVL","Latvia Lat","[76,115]","1");
INSERT INTO `llx_c_currencies` VALUES("MAD","Morocco Dirham",NULL,"1");
INSERT INTO `llx_c_currencies` VALUES("MGA","Ariary",NULL,"1");
INSERT INTO `llx_c_currencies` VALUES("MKD","Macedonia Denar","[1076,1077,1085]","1");
INSERT INTO `llx_c_currencies` VALUES("MNT","Mongolia Tughrik","[8366]","1");
INSERT INTO `llx_c_currencies` VALUES("MRO","Mauritania Ouguiya",NULL,"1");
INSERT INTO `llx_c_currencies` VALUES("MUR","Mauritius Rupee","[8360]","1");
INSERT INTO `llx_c_currencies` VALUES("MXN","Mexico Peso","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("MXP","Pesos Mexicans",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("MYR","Malaysia Ringgit","[82,77]","1");
INSERT INTO `llx_c_currencies` VALUES("MZN","Mozambique Metical","[77,84]","1");
INSERT INTO `llx_c_currencies` VALUES("NAD","Namibia Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("NGN","Nigeria Naira","[8358]","1");
INSERT INTO `llx_c_currencies` VALUES("NIO","Nicaragua Cordoba","[67,36]","1");
INSERT INTO `llx_c_currencies` VALUES("NLG","Florins",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("NOK","Norway Krone","[107,114]","1");
INSERT INTO `llx_c_currencies` VALUES("NPR","Nepal Rupee","[8360]","1");
INSERT INTO `llx_c_currencies` VALUES("NZD","New Zealand Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("OMR","Oman Rial","[65020]","1");
INSERT INTO `llx_c_currencies` VALUES("PAB","Panama Balboa","[66,47,46]","1");
INSERT INTO `llx_c_currencies` VALUES("PEN","Peru Nuevo Sol","[83,47,46]","1");
INSERT INTO `llx_c_currencies` VALUES("PHP","Philippines Peso","[8369]","1");
INSERT INTO `llx_c_currencies` VALUES("PKR","Pakistan Rupee","[8360]","1");
INSERT INTO `llx_c_currencies` VALUES("PLN","Poland Zloty","[122,322]","1");
INSERT INTO `llx_c_currencies` VALUES("PTE","Escudos",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("PYG","Paraguay Guarani","[71,115]","1");
INSERT INTO `llx_c_currencies` VALUES("QAR","Qatar Riyal","[65020]","1");
INSERT INTO `llx_c_currencies` VALUES("RON","Romania New Leu","[108,101,105]","1");
INSERT INTO `llx_c_currencies` VALUES("RSD","Serbia Dinar","[1044,1080,1085,46]","1");
INSERT INTO `llx_c_currencies` VALUES("RUB","Russia Ruble","[1088,1091,1073]","1");
INSERT INTO `llx_c_currencies` VALUES("SAR","Saudi Arabia Riyal","[65020]","1");
INSERT INTO `llx_c_currencies` VALUES("SBD","Solomon Islands Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("SCR","Seychelles Rupee","[8360]","1");
INSERT INTO `llx_c_currencies` VALUES("SEK","Sweden Krona","[107,114]","1");
INSERT INTO `llx_c_currencies` VALUES("SGD","Singapore Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("SHP","Saint Helena Pound","[163]","1");
INSERT INTO `llx_c_currencies` VALUES("SKK","Couronnes slovaques",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("SOS","Somalia Shilling","[83]","1");
INSERT INTO `llx_c_currencies` VALUES("SRD","Suriname Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("SUR","Rouble",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("SVC","El Salvador Colon","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("SYP","Syria Pound","[163]","1");
INSERT INTO `llx_c_currencies` VALUES("THB","Thailand Baht","[3647]","1");
INSERT INTO `llx_c_currencies` VALUES("TND","Tunisia Dinar",NULL,"1");
INSERT INTO `llx_c_currencies` VALUES("TRL","Turkey Lira","[84,76]","1");
INSERT INTO `llx_c_currencies` VALUES("TRY","Turkey Lira","[8356]","1");
INSERT INTO `llx_c_currencies` VALUES("TTD","Trinidad and Tobago Dollar","[84,84,36]","1");
INSERT INTO `llx_c_currencies` VALUES("TVD","Tuvalu Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("TWD","Taiwan New Dollar","[78,84,36]","1");
INSERT INTO `llx_c_currencies` VALUES("UAH","Ukraine Hryvna","[8372]","1");
INSERT INTO `llx_c_currencies` VALUES("USD","United States Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("UYU","Uruguay Peso","[36,85]","1");
INSERT INTO `llx_c_currencies` VALUES("UZS","Uzbekistan Som","[1083,1074]","1");
INSERT INTO `llx_c_currencies` VALUES("VEF","Venezuela Bolivar Fuerte","[66,115]","1");
INSERT INTO `llx_c_currencies` VALUES("VND","Viet Nam Dong","[8363]","1");
INSERT INTO `llx_c_currencies` VALUES("XAF","Communaute Financiere Africaine (BEAC) CFA Franc",NULL,"1");
INSERT INTO `llx_c_currencies` VALUES("XCD","East Caribbean Dollar","[36]","1");
INSERT INTO `llx_c_currencies` VALUES("XEU","Ecus",NULL,"0");
INSERT INTO `llx_c_currencies` VALUES("XOF","Communaute Financiere Africaine (BCEAO) Franc",NULL,"1");
INSERT INTO `llx_c_currencies` VALUES("XPF","Franc CFP","[70]","1");
INSERT INTO `llx_c_currencies` VALUES("YER","Yemen Rial","[65020]","1");
INSERT INTO `llx_c_currencies` VALUES("ZAR","South Africa Rand","[82]","1");
INSERT INTO `llx_c_currencies` VALUES("ZWD","Zimbabwe Dollar","[90,36]","1");



DROP TABLE IF EXISTS `llx_c_departements`;
CREATE TABLE `llx_c_departements` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code_departement` varchar(6) NOT NULL,
  `fk_region` int DEFAULT NULL,
  `cheflieu` varchar(50) DEFAULT NULL,
  `tncc` int DEFAULT NULL,
  `ncc` varchar(50) DEFAULT NULL,
  `nom` varchar(50) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_departements` (`code_departement`,`fk_region`),
  KEY `idx_departements_fk_region` (`fk_region`),
  CONSTRAINT `fk_departements_fk_region` FOREIGN KEY (`fk_region`) REFERENCES `llx_c_regions` (`code_region`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=1431 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_departements` VALUES("1","0","0","0","0","-","-","1");
INSERT INTO `llx_c_departements` VALUES("2","971","1","97105","3","GUADELOUPE","Guadeloupe","1");
INSERT INTO `llx_c_departements` VALUES("3","972","2","97209","3","MARTINIQUE","Martinique","1");
INSERT INTO `llx_c_departements` VALUES("4","973","3","97302","3","GUYANE","Guyane","1");
INSERT INTO `llx_c_departements` VALUES("5","974","4","97411","3","REUNION","Réunion","1");
INSERT INTO `llx_c_departements` VALUES("6","976","6","97601","3","MAYOTTE","Mayotte","1");
INSERT INTO `llx_c_departements` VALUES("7","01","84","01053","5","AIN","Ain","1");
INSERT INTO `llx_c_departements` VALUES("8","02","32","02408","5","AISNE","Aisne","1");
INSERT INTO `llx_c_departements` VALUES("9","03","84","03190","5","ALLIER","Allier","1");
INSERT INTO `llx_c_departements` VALUES("10","04","93","04070","4","ALPES-DE-HAUTE-PROVENCE","Alpes-de-Haute-Provence","1");
INSERT INTO `llx_c_departements` VALUES("11","05","93","05061","4","HAUTES-ALPES","Hautes-Alpes","1");
INSERT INTO `llx_c_departements` VALUES("12","06","93","06088","4","ALPES-MARITIMES","Alpes-Maritimes","1");
INSERT INTO `llx_c_departements` VALUES("13","07","84","07186","5","ARDECHE","Ardèche","1");
INSERT INTO `llx_c_departements` VALUES("14","08","44","08105","4","ARDENNES","Ardennes","1");
INSERT INTO `llx_c_departements` VALUES("15","09","76","09122","5","ARIEGE","Ariège","1");
INSERT INTO `llx_c_departements` VALUES("16","10","44","10387","5","AUBE","Aube","1");
INSERT INTO `llx_c_departements` VALUES("17","11","76","11069","5","AUDE","Aude","1");
INSERT INTO `llx_c_departements` VALUES("18","12","76","12202","5","AVEYRON","Aveyron","1");
INSERT INTO `llx_c_departements` VALUES("19","13","93","13055","4","BOUCHES-DU-RHONE","Bouches-du-Rhône","1");
INSERT INTO `llx_c_departements` VALUES("20","14","28","14118","2","CALVADOS","Calvados","1");
INSERT INTO `llx_c_departements` VALUES("21","15","84","15014","2","CANTAL","Cantal","1");
INSERT INTO `llx_c_departements` VALUES("22","16","75","16015","3","CHARENTE","Charente","1");
INSERT INTO `llx_c_departements` VALUES("23","17","75","17300","3","CHARENTE-MARITIME","Charente-Maritime","1");
INSERT INTO `llx_c_departements` VALUES("24","18","24","18033","2","CHER","Cher","1");
INSERT INTO `llx_c_departements` VALUES("25","19","75","19272","3","CORREZE","Corrèze","1");
INSERT INTO `llx_c_departements` VALUES("26","2A","94","2A004","3","CORSE-DU-SUD","Corse-du-Sud","1");
INSERT INTO `llx_c_departements` VALUES("27","2B","94","2B033","3","HAUTE-CORSE","Haute-Corse","1");
INSERT INTO `llx_c_departements` VALUES("28","21","27","21231","3","COTE-D OR","Côte-d Or","1");
INSERT INTO `llx_c_departements` VALUES("29","22","53","22278","4","COTES-D ARMOR","Côtes-d Armor","1");
INSERT INTO `llx_c_departements` VALUES("30","23","75","23096","3","CREUSE","Creuse","1");
INSERT INTO `llx_c_departements` VALUES("31","24","75","24322","3","DORDOGNE","Dordogne","1");
INSERT INTO `llx_c_departements` VALUES("32","25","27","25056","2","DOUBS","Doubs","1");
INSERT INTO `llx_c_departements` VALUES("33","26","84","26362","3","DROME","Drôme","1");
INSERT INTO `llx_c_departements` VALUES("34","27","28","27229","5","EURE","Eure","1");
INSERT INTO `llx_c_departements` VALUES("35","28","24","28085","1","EURE-ET-LOIR","Eure-et-Loir","1");
INSERT INTO `llx_c_departements` VALUES("36","29","53","29232","2","FINISTERE","Finistère","1");
INSERT INTO `llx_c_departements` VALUES("37","30","76","30189","2","GARD","Gard","1");
INSERT INTO `llx_c_departements` VALUES("38","31","76","31555","3","HAUTE-GARONNE","Haute-Garonne","1");
INSERT INTO `llx_c_departements` VALUES("39","32","76","32013","2","GERS","Gers","1");
INSERT INTO `llx_c_departements` VALUES("40","33","75","33063","3","GIRONDE","Gironde","1");
INSERT INTO `llx_c_departements` VALUES("41","34","76","34172","5","HERAULT","Hérault","1");
INSERT INTO `llx_c_departements` VALUES("42","35","53","35238","1","ILLE-ET-VILAINE","Ille-et-Vilaine","1");
INSERT INTO `llx_c_departements` VALUES("43","36","24","36044","5","INDRE","Indre","1");
INSERT INTO `llx_c_departements` VALUES("44","37","24","37261","1","INDRE-ET-LOIRE","Indre-et-Loire","1");
INSERT INTO `llx_c_departements` VALUES("45","38","84","38185","5","ISERE","Isère","1");
INSERT INTO `llx_c_departements` VALUES("46","39","27","39300","2","JURA","Jura","1");
INSERT INTO `llx_c_departements` VALUES("47","40","75","40192","4","LANDES","Landes","1");
INSERT INTO `llx_c_departements` VALUES("48","41","24","41018","0","LOIR-ET-CHER","Loir-et-Cher","1");
INSERT INTO `llx_c_departements` VALUES("49","42","84","42218","3","LOIRE","Loire","1");
INSERT INTO `llx_c_departements` VALUES("50","43","84","43157","3","HAUTE-LOIRE","Haute-Loire","1");
INSERT INTO `llx_c_departements` VALUES("51","44","52","44109","3","LOIRE-ATLANTIQUE","Loire-Atlantique","1");
INSERT INTO `llx_c_departements` VALUES("52","45","24","45234","2","LOIRET","Loiret","1");
INSERT INTO `llx_c_departements` VALUES("53","46","76","46042","2","LOT","Lot","1");
INSERT INTO `llx_c_departements` VALUES("54","47","75","47001","0","LOT-ET-GARONNE","Lot-et-Garonne","1");
INSERT INTO `llx_c_departements` VALUES("55","48","76","48095","3","LOZERE","Lozère","1");
INSERT INTO `llx_c_departements` VALUES("56","49","52","49007","0","MAINE-ET-LOIRE","Maine-et-Loire","1");
INSERT INTO `llx_c_departements` VALUES("57","50","28","50502","3","MANCHE","Manche","1");
INSERT INTO `llx_c_departements` VALUES("58","51","44","51108","3","MARNE","Marne","1");
INSERT INTO `llx_c_departements` VALUES("59","52","44","52121","3","HAUTE-MARNE","Haute-Marne","1");
INSERT INTO `llx_c_departements` VALUES("60","53","52","53130","3","MAYENNE","Mayenne","1");
INSERT INTO `llx_c_departements` VALUES("61","54","44","54395","0","MEURTHE-ET-MOSELLE","Meurthe-et-Moselle","1");
INSERT INTO `llx_c_departements` VALUES("62","55","44","55029","3","MEUSE","Meuse","1");
INSERT INTO `llx_c_departements` VALUES("63","56","53","56260","2","MORBIHAN","Morbihan","1");
INSERT INTO `llx_c_departements` VALUES("64","57","44","57463","3","MOSELLE","Moselle","1");
INSERT INTO `llx_c_departements` VALUES("65","58","27","58194","3","NIEVRE","Nièvre","1");
INSERT INTO `llx_c_departements` VALUES("66","59","32","59350","2","NORD","Nord","1");
INSERT INTO `llx_c_departements` VALUES("67","60","32","60057","5","OISE","Oise","1");
INSERT INTO `llx_c_departements` VALUES("68","61","28","61001","5","ORNE","Orne","1");
INSERT INTO `llx_c_departements` VALUES("69","62","32","62041","2","PAS-DE-CALAIS","Pas-de-Calais","1");
INSERT INTO `llx_c_departements` VALUES("70","63","84","63113","2","PUY-DE-DOME","Puy-de-Dôme","1");
INSERT INTO `llx_c_departements` VALUES("71","64","75","64445","4","PYRENEES-ATLANTIQUES","Pyrénées-Atlantiques","1");
INSERT INTO `llx_c_departements` VALUES("72","65","76","65440","4","HAUTES-PYRENEES","Hautes-Pyrénées","1");
INSERT INTO `llx_c_departements` VALUES("73","66","76","66136","4","PYRENEES-ORIENTALES","Pyrénées-Orientales","1");
INSERT INTO `llx_c_departements` VALUES("74","67","44","67482","2","BAS-RHIN","Bas-Rhin","1");
INSERT INTO `llx_c_departements` VALUES("75","68","44","68066","2","HAUT-RHIN","Haut-Rhin","1");
INSERT INTO `llx_c_departements` VALUES("76","69","84","69123","2","RHONE","Rhône","1");
INSERT INTO `llx_c_departements` VALUES("77","70","27","70550","3","HAUTE-SAONE","Haute-Saône","1");
INSERT INTO `llx_c_departements` VALUES("78","71","27","71270","0","SAONE-ET-LOIRE","Saône-et-Loire","1");
INSERT INTO `llx_c_departements` VALUES("79","72","52","72181","3","SARTHE","Sarthe","1");
INSERT INTO `llx_c_departements` VALUES("80","73","84","73065","3","SAVOIE","Savoie","1");
INSERT INTO `llx_c_departements` VALUES("81","74","84","74010","3","HAUTE-SAVOIE","Haute-Savoie","1");
INSERT INTO `llx_c_departements` VALUES("82","75","11","75056","0","PARIS","Paris","1");
INSERT INTO `llx_c_departements` VALUES("83","76","28","76540","3","SEINE-MARITIME","Seine-Maritime","1");
INSERT INTO `llx_c_departements` VALUES("84","77","11","77288","0","SEINE-ET-MARNE","Seine-et-Marne","1");
INSERT INTO `llx_c_departements` VALUES("85","78","11","78646","4","YVELINES","Yvelines","1");
INSERT INTO `llx_c_departements` VALUES("86","79","75","79191","4","DEUX-SEVRES","Deux-Sèvres","1");
INSERT INTO `llx_c_departements` VALUES("87","80","32","80021","3","SOMME","Somme","1");
INSERT INTO `llx_c_departements` VALUES("88","81","76","81004","2","TARN","Tarn","1");
INSERT INTO `llx_c_departements` VALUES("89","82","76","82121","0","TARN-ET-GARONNE","Tarn-et-Garonne","1");
INSERT INTO `llx_c_departements` VALUES("90","83","93","83137","2","VAR","Var","1");
INSERT INTO `llx_c_departements` VALUES("91","84","93","84007","0","VAUCLUSE","Vaucluse","1");
INSERT INTO `llx_c_departements` VALUES("92","85","52","85191","3","VENDEE","Vendée","1");
INSERT INTO `llx_c_departements` VALUES("93","86","75","86194","3","VIENNE","Vienne","1");
INSERT INTO `llx_c_departements` VALUES("94","87","75","87085","3","HAUTE-VIENNE","Haute-Vienne","1");
INSERT INTO `llx_c_departements` VALUES("95","88","44","88160","4","VOSGES","Vosges","1");
INSERT INTO `llx_c_departements` VALUES("96","89","27","89024","5","YONNE","Yonne","1");
INSERT INTO `llx_c_departements` VALUES("97","90","27","90010","0","TERRITOIRE DE BELFORT","Territoire de Belfort","1");
INSERT INTO `llx_c_departements` VALUES("98","91","11","91228","5","ESSONNE","Essonne","1");
INSERT INTO `llx_c_departements` VALUES("99","92","11","92050","4","HAUTS-DE-SEINE","Hauts-de-Seine","1");
INSERT INTO `llx_c_departements` VALUES("100","93","11","93008","3","SEINE-SAINT-DENIS","Seine-Saint-Denis","1");
INSERT INTO `llx_c_departements` VALUES("101","94","11","94028","2","VAL-DE-MARNE","Val-de-Marne","1");
INSERT INTO `llx_c_departements` VALUES("102","95","11","95500","2","VAL-D OISE","Val-d Oise","1");
INSERT INTO `llx_c_departements` VALUES("103","B","4101",NULL,NULL,"BURGENLAND","Burgenland","1");
INSERT INTO `llx_c_departements` VALUES("104","K","4101",NULL,NULL,"KAERNTEN","Kärnten","1");
INSERT INTO `llx_c_departements` VALUES("105","N","4101",NULL,NULL,"NIEDEROESTERREICH","Niederösterreich","1");
INSERT INTO `llx_c_departements` VALUES("106","O","4101",NULL,NULL,"OBEROESTERREICH","Oberösterreich","1");
INSERT INTO `llx_c_departements` VALUES("107","S","4101",NULL,NULL,"SALZBURG","Salzburg","1");
INSERT INTO `llx_c_departements` VALUES("108","ST","4101",NULL,NULL,"STEIERMARK","Steiermark","1");
INSERT INTO `llx_c_departements` VALUES("109","T","4101",NULL,NULL,"TIROL","Tirol","1");
INSERT INTO `llx_c_departements` VALUES("110","V","4101",NULL,NULL,"VORARLBERG","Vorarlberg","1");
INSERT INTO `llx_c_departements` VALUES("111","W","4101",NULL,NULL,"WIEN","Wien","1");
INSERT INTO `llx_c_departements` VALUES("112","01","201","","1","ANVERS","Anvers","1");
INSERT INTO `llx_c_departements` VALUES("113","02","203","","3","BRUXELLES-CAPITALE","Bruxelles-Capitale","1");
INSERT INTO `llx_c_departements` VALUES("114","03","202","","2","BRABANT-WALLON","Brabant-Wallon","1");
INSERT INTO `llx_c_departements` VALUES("115","04","201","","1","BRABANT-FLAMAND","Brabant-Flamand","1");
INSERT INTO `llx_c_departements` VALUES("116","05","201","","1","FLANDRE-OCCIDENTALE","Flandre-Occidentale","1");
INSERT INTO `llx_c_departements` VALUES("117","06","201","","1","FLANDRE-ORIENTALE","Flandre-Orientale","1");
INSERT INTO `llx_c_departements` VALUES("118","07","202","","2","HAINAUT","Hainaut","1");
INSERT INTO `llx_c_departements` VALUES("119","08","201","","2","LIEGE","Liège","1");
INSERT INTO `llx_c_departements` VALUES("120","09","202","","1","LIMBOURG","Limbourg","1");
INSERT INTO `llx_c_departements` VALUES("121","10","202","","2","LUXEMBOURG","Luxembourg","1");
INSERT INTO `llx_c_departements` VALUES("122","11","201","","2","NAMUR","Namur","1");
INSERT INTO `llx_c_departements` VALUES("123","AG","315",NULL,NULL,NULL,"AGRIGENTO","1");
INSERT INTO `llx_c_departements` VALUES("124","AL","312",NULL,NULL,NULL,"ALESSANDRIA","1");
INSERT INTO `llx_c_departements` VALUES("125","AN","310",NULL,NULL,NULL,"ANCONA","1");
INSERT INTO `llx_c_departements` VALUES("126","AO","319",NULL,NULL,NULL,"AOSTA","1");
INSERT INTO `llx_c_departements` VALUES("127","AR","316",NULL,NULL,NULL,"AREZZO","1");
INSERT INTO `llx_c_departements` VALUES("128","AP","310",NULL,NULL,NULL,"ASCOLI PICENO","1");
INSERT INTO `llx_c_departements` VALUES("129","AT","312",NULL,NULL,NULL,"ASTI","1");
INSERT INTO `llx_c_departements` VALUES("130","AV","304",NULL,NULL,NULL,"AVELLINO","1");
INSERT INTO `llx_c_departements` VALUES("131","BA","313",NULL,NULL,NULL,"BARI","1");
INSERT INTO `llx_c_departements` VALUES("132","BT","313",NULL,NULL,NULL,"BARLETTA-ANDRIA-TRANI","1");
INSERT INTO `llx_c_departements` VALUES("133","BL","320",NULL,NULL,NULL,"BELLUNO","1");
INSERT INTO `llx_c_departements` VALUES("134","BN","304",NULL,NULL,NULL,"BENEVENTO","1");
INSERT INTO `llx_c_departements` VALUES("135","BG","309",NULL,NULL,NULL,"BERGAMO","1");
INSERT INTO `llx_c_departements` VALUES("136","BI","312",NULL,NULL,NULL,"BIELLA","1");
INSERT INTO `llx_c_departements` VALUES("137","BO","305",NULL,NULL,NULL,"BOLOGNA","1");
INSERT INTO `llx_c_departements` VALUES("138","BZ","317",NULL,NULL,NULL,"BOLZANO","1");
INSERT INTO `llx_c_departements` VALUES("139","BS","309",NULL,NULL,NULL,"BRESCIA","1");
INSERT INTO `llx_c_departements` VALUES("140","BR","313",NULL,NULL,NULL,"BRINDISI","1");
INSERT INTO `llx_c_departements` VALUES("141","CA","314",NULL,NULL,NULL,"CAGLIARI","1");
INSERT INTO `llx_c_departements` VALUES("142","CL","315",NULL,NULL,NULL,"CALTANISSETTA","1");
INSERT INTO `llx_c_departements` VALUES("143","CB","311",NULL,NULL,NULL,"CAMPOBASSO","1");
INSERT INTO `llx_c_departements` VALUES("144","CI","314",NULL,NULL,NULL,"CARBONIA-IGLESIAS","1");
INSERT INTO `llx_c_departements` VALUES("145","CE","304",NULL,NULL,NULL,"CASERTA","1");
INSERT INTO `llx_c_departements` VALUES("146","CT","315",NULL,NULL,NULL,"CATANIA","1");
INSERT INTO `llx_c_departements` VALUES("147","CZ","303",NULL,NULL,NULL,"CATANZARO","1");
INSERT INTO `llx_c_departements` VALUES("148","CH","301",NULL,NULL,NULL,"CHIETI","1");
INSERT INTO `llx_c_departements` VALUES("149","CO","309",NULL,NULL,NULL,"COMO","1");
INSERT INTO `llx_c_departements` VALUES("150","CS","303",NULL,NULL,NULL,"COSENZA","1");
INSERT INTO `llx_c_departements` VALUES("151","CR","309",NULL,NULL,NULL,"CREMONA","1");
INSERT INTO `llx_c_departements` VALUES("152","KR","303",NULL,NULL,NULL,"CROTONE","1");
INSERT INTO `llx_c_departements` VALUES("153","CN","312",NULL,NULL,NULL,"CUNEO","1");
INSERT INTO `llx_c_departements` VALUES("154","EN","315",NULL,NULL,NULL,"ENNA","1");
INSERT INTO `llx_c_departements` VALUES("155","FM","310",NULL,NULL,NULL,"FERMO","1");
INSERT INTO `llx_c_departements` VALUES("156","FE","305",NULL,NULL,NULL,"FERRARA","1");
INSERT INTO `llx_c_departements` VALUES("157","FI","316",NULL,NULL,NULL,"FIRENZE","1");
INSERT INTO `llx_c_departements` VALUES("158","FG","313",NULL,NULL,NULL,"FOGGIA","1");
INSERT INTO `llx_c_departements` VALUES("159","FC","305",NULL,NULL,NULL,"FORLI-CESENA","1");
INSERT INTO `llx_c_departements` VALUES("160","FR","307",NULL,NULL,NULL,"FROSINONE","1");
INSERT INTO `llx_c_departements` VALUES("161","GE","308",NULL,NULL,NULL,"GENOVA","1");
INSERT INTO `llx_c_departements` VALUES("162","GO","306",NULL,NULL,NULL,"GORIZIA","1");
INSERT INTO `llx_c_departements` VALUES("163","GR","316",NULL,NULL,NULL,"GROSSETO","1");
INSERT INTO `llx_c_departements` VALUES("164","IM","308",NULL,NULL,NULL,"IMPERIA","1");
INSERT INTO `llx_c_departements` VALUES("165","IS","311",NULL,NULL,NULL,"ISERNIA","1");
INSERT INTO `llx_c_departements` VALUES("166","SP","308",NULL,NULL,NULL,"LA SPEZIA","1");
INSERT INTO `llx_c_departements` VALUES("167","AQ","301",NULL,NULL,NULL,"L AQUILA","1");
INSERT INTO `llx_c_departements` VALUES("168","LT","307",NULL,NULL,NULL,"LATINA","1");
INSERT INTO `llx_c_departements` VALUES("169","LE","313",NULL,NULL,NULL,"LECCE","1");
INSERT INTO `llx_c_departements` VALUES("170","LC","309",NULL,NULL,NULL,"LECCO","1");
INSERT INTO `llx_c_departements` VALUES("171","LI","314",NULL,NULL,NULL,"LIVORNO","1");
INSERT INTO `llx_c_departements` VALUES("172","LO","309",NULL,NULL,NULL,"LODI","1");
INSERT INTO `llx_c_departements` VALUES("173","LU","316",NULL,NULL,NULL,"LUCCA","1");
INSERT INTO `llx_c_departements` VALUES("174","MC","310",NULL,NULL,NULL,"MACERATA","1");
INSERT INTO `llx_c_departements` VALUES("175","MN","309",NULL,NULL,NULL,"MANTOVA","1");
INSERT INTO `llx_c_departements` VALUES("176","MS","316",NULL,NULL,NULL,"MASSA-CARRARA","1");
INSERT INTO `llx_c_departements` VALUES("177","MT","302",NULL,NULL,NULL,"MATERA","1");
INSERT INTO `llx_c_departements` VALUES("178","VS","314",NULL,NULL,NULL,"MEDIO CAMPIDANO","1");
INSERT INTO `llx_c_departements` VALUES("179","ME","315",NULL,NULL,NULL,"MESSINA","1");
INSERT INTO `llx_c_departements` VALUES("180","MI","309",NULL,NULL,NULL,"MILANO","1");
INSERT INTO `llx_c_departements` VALUES("181","MB","309",NULL,NULL,NULL,"MONZA e BRIANZA","1");
INSERT INTO `llx_c_departements` VALUES("182","MO","305",NULL,NULL,NULL,"MODENA","1");
INSERT INTO `llx_c_departements` VALUES("183","NA","304",NULL,NULL,NULL,"NAPOLI","1");
INSERT INTO `llx_c_departements` VALUES("184","NO","312",NULL,NULL,NULL,"NOVARA","1");
INSERT INTO `llx_c_departements` VALUES("185","NU","314",NULL,NULL,NULL,"NUORO","1");
INSERT INTO `llx_c_departements` VALUES("186","OG","314",NULL,NULL,NULL,"OGLIASTRA","1");
INSERT INTO `llx_c_departements` VALUES("187","OT","314",NULL,NULL,NULL,"OLBIA-TEMPIO","1");
INSERT INTO `llx_c_departements` VALUES("188","OR","314",NULL,NULL,NULL,"ORISTANO","1");
INSERT INTO `llx_c_departements` VALUES("189","PD","320",NULL,NULL,NULL,"PADOVA","1");
INSERT INTO `llx_c_departements` VALUES("190","PA","315",NULL,NULL,NULL,"PALERMO","1");
INSERT INTO `llx_c_departements` VALUES("191","PR","305",NULL,NULL,NULL,"PARMA","1");
INSERT INTO `llx_c_departements` VALUES("192","PV","309",NULL,NULL,NULL,"PAVIA","1");
INSERT INTO `llx_c_departements` VALUES("193","PG","318",NULL,NULL,NULL,"PERUGIA","1");
INSERT INTO `llx_c_departements` VALUES("194","PU","310",NULL,NULL,NULL,"PESARO e URBINO","1");
INSERT INTO `llx_c_departements` VALUES("195","PE","301",NULL,NULL,NULL,"PESCARA","1");
INSERT INTO `llx_c_departements` VALUES("196","PC","305",NULL,NULL,NULL,"PIACENZA","1");
INSERT INTO `llx_c_departements` VALUES("197","PI","316",NULL,NULL,NULL,"PISA","1");
INSERT INTO `llx_c_departements` VALUES("198","PT","316",NULL,NULL,NULL,"PISTOIA","1");
INSERT INTO `llx_c_departements` VALUES("199","PN","306",NULL,NULL,NULL,"PORDENONE","1");
INSERT INTO `llx_c_departements` VALUES("200","PZ","302",NULL,NULL,NULL,"POTENZA","1");
INSERT INTO `llx_c_departements` VALUES("201","PO","316",NULL,NULL,NULL,"PRATO","1");
INSERT INTO `llx_c_departements` VALUES("202","RG","315",NULL,NULL,NULL,"RAGUSA","1");
INSERT INTO `llx_c_departements` VALUES("203","RA","305",NULL,NULL,NULL,"RAVENNA","1");
INSERT INTO `llx_c_departements` VALUES("204","RC","303",NULL,NULL,NULL,"REGGIO CALABRIA","1");
INSERT INTO `llx_c_departements` VALUES("205","RE","305",NULL,NULL,NULL,"REGGIO NELL EMILIA","1");
INSERT INTO `llx_c_departements` VALUES("206","RI","307",NULL,NULL,NULL,"RIETI","1");
INSERT INTO `llx_c_departements` VALUES("207","RN","305",NULL,NULL,NULL,"RIMINI","1");
INSERT INTO `llx_c_departements` VALUES("208","RM","307",NULL,NULL,NULL,"ROMA","1");
INSERT INTO `llx_c_departements` VALUES("209","RO","320",NULL,NULL,NULL,"ROVIGO","1");
INSERT INTO `llx_c_departements` VALUES("210","SA","304",NULL,NULL,NULL,"SALERNO","1");
INSERT INTO `llx_c_departements` VALUES("211","SS","314",NULL,NULL,NULL,"SASSARI","1");
INSERT INTO `llx_c_departements` VALUES("212","SV","308",NULL,NULL,NULL,"SAVONA","1");
INSERT INTO `llx_c_departements` VALUES("213","SI","316",NULL,NULL,NULL,"SIENA","1");
INSERT INTO `llx_c_departements` VALUES("214","SR","315",NULL,NULL,NULL,"SIRACUSA","1");
INSERT INTO `llx_c_departements` VALUES("215","SO","309",NULL,NULL,NULL,"SONDRIO","1");
INSERT INTO `llx_c_departements` VALUES("216","TA","313",NULL,NULL,NULL,"TARANTO","1");
INSERT INTO `llx_c_departements` VALUES("217","TE","301",NULL,NULL,NULL,"TERAMO","1");
INSERT INTO `llx_c_departements` VALUES("218","TR","318",NULL,NULL,NULL,"TERNI","1");
INSERT INTO `llx_c_departements` VALUES("219","TO","312",NULL,NULL,NULL,"TORINO","1");
INSERT INTO `llx_c_departements` VALUES("220","TP","315",NULL,NULL,NULL,"TRAPANI","1");
INSERT INTO `llx_c_departements` VALUES("221","TN","317",NULL,NULL,NULL,"TRENTO","1");
INSERT INTO `llx_c_departements` VALUES("222","TV","320",NULL,NULL,NULL,"TREVISO","1");
INSERT INTO `llx_c_departements` VALUES("223","TS","306",NULL,NULL,NULL,"TRIESTE","1");
INSERT INTO `llx_c_departements` VALUES("224","UD","306",NULL,NULL,NULL,"UDINE","1");
INSERT INTO `llx_c_departements` VALUES("225","VA","309",NULL,NULL,NULL,"VARESE","1");
INSERT INTO `llx_c_departements` VALUES("226","VE","320",NULL,NULL,NULL,"VENEZIA","1");
INSERT INTO `llx_c_departements` VALUES("227","VB","312",NULL,NULL,NULL,"VERBANO-CUSIO-OSSOLA","1");
INSERT INTO `llx_c_departements` VALUES("228","VC","312",NULL,NULL,NULL,"VERCELLI","1");
INSERT INTO `llx_c_departements` VALUES("229","VR","320",NULL,NULL,NULL,"VERONA","1");
INSERT INTO `llx_c_departements` VALUES("230","VV","303",NULL,NULL,NULL,"VIBO VALENTIA","1");
INSERT INTO `llx_c_departements` VALUES("231","VI","320",NULL,NULL,NULL,"VICENZA","1");
INSERT INTO `llx_c_departements` VALUES("232","VT","307",NULL,NULL,NULL,"VITERBO","1");
INSERT INTO `llx_c_departements` VALUES("233","AL01","1301","","0","","Wilaya d\'Adrar","1");
INSERT INTO `llx_c_departements` VALUES("234","AL02","1301","","0","","Wilaya de Chlef","1");
INSERT INTO `llx_c_departements` VALUES("235","AL03","1301","","0","","Wilaya de Laghouat","1");
INSERT INTO `llx_c_departements` VALUES("236","AL04","1301","","0","","Wilaya d\'Oum El Bouaghi","1");
INSERT INTO `llx_c_departements` VALUES("237","AL05","1301","","0","","Wilaya de Batna","1");
INSERT INTO `llx_c_departements` VALUES("238","AL06","1301","","0","","Wilaya de Béjaïa","1");
INSERT INTO `llx_c_departements` VALUES("239","AL07","1301","","0","","Wilaya de Biskra","1");
INSERT INTO `llx_c_departements` VALUES("240","AL08","1301","","0","","Wilaya de Béchar","1");
INSERT INTO `llx_c_departements` VALUES("241","AL09","1301","","0","","Wilaya de Blida","1");
INSERT INTO `llx_c_departements` VALUES("242","AL10","1301","","0","","Wilaya de Bouira","1");
INSERT INTO `llx_c_departements` VALUES("243","AL11","1301","","0","","Wilaya de Tamanrasset","1");
INSERT INTO `llx_c_departements` VALUES("244","AL12","1301","","0","","Wilaya de Tébessa","1");
INSERT INTO `llx_c_departements` VALUES("245","AL13","1301","","0","","Wilaya de Tlemcen","1");
INSERT INTO `llx_c_departements` VALUES("246","AL14","1301","","0","","Wilaya de Tiaret","1");
INSERT INTO `llx_c_departements` VALUES("247","AL15","1301","","0","","Wilaya de Tizi Ouzou","1");
INSERT INTO `llx_c_departements` VALUES("248","AL16","1301","","0","","Wilaya d\'Alger","1");
INSERT INTO `llx_c_departements` VALUES("249","AL17","1301","","0","","Wilaya de Djelfa","1");
INSERT INTO `llx_c_departements` VALUES("250","AL18","1301","","0","","Wilaya de Jijel","1");
INSERT INTO `llx_c_departements` VALUES("251","AL19","1301","","0","","Wilaya de Sétif	","1");
INSERT INTO `llx_c_departements` VALUES("252","AL20","1301","","0","","Wilaya de Saïda","1");
INSERT INTO `llx_c_departements` VALUES("253","AL21","1301","","0","","Wilaya de Skikda","1");
INSERT INTO `llx_c_departements` VALUES("254","AL22","1301","","0","","Wilaya de Sidi Bel Abbès","1");
INSERT INTO `llx_c_departements` VALUES("255","AL23","1301","","0","","Wilaya d\'Annaba","1");
INSERT INTO `llx_c_departements` VALUES("256","AL24","1301","","0","","Wilaya de Guelma","1");
INSERT INTO `llx_c_departements` VALUES("257","AL25","1301","","0","","Wilaya de Constantine","1");
INSERT INTO `llx_c_departements` VALUES("258","AL26","1301","","0","","Wilaya de Médéa","1");
INSERT INTO `llx_c_departements` VALUES("259","AL27","1301","","0","","Wilaya de Mostaganem","1");
INSERT INTO `llx_c_departements` VALUES("260","AL28","1301","","0","","Wilaya de M\'Sila","1");
INSERT INTO `llx_c_departements` VALUES("261","AL29","1301","","0","","Wilaya de Mascara","1");
INSERT INTO `llx_c_departements` VALUES("262","AL30","1301","","0","","Wilaya d\'Ouargla","1");
INSERT INTO `llx_c_departements` VALUES("263","AL31","1301","","0","","Wilaya d\'Oran","1");
INSERT INTO `llx_c_departements` VALUES("264","AL32","1301","","0","","Wilaya d\'El Bayadh","1");
INSERT INTO `llx_c_departements` VALUES("265","AL33","1301","","0","","Wilaya d\'Illizi","1");
INSERT INTO `llx_c_departements` VALUES("266","AL34","1301","","0","","Wilaya de Bordj Bou Arreridj","1");
INSERT INTO `llx_c_departements` VALUES("267","AL35","1301","","0","","Wilaya de Boumerdès","1");
INSERT INTO `llx_c_departements` VALUES("268","AL36","1301","","0","","Wilaya d\'El Tarf","1");
INSERT INTO `llx_c_departements` VALUES("269","AL37","1301","","0","","Wilaya de Tindouf","1");
INSERT INTO `llx_c_departements` VALUES("270","AL38","1301","","0","","Wilaya de Tissemsilt","1");
INSERT INTO `llx_c_departements` VALUES("271","AL39","1301","","0","","Wilaya d\'El Oued","1");
INSERT INTO `llx_c_departements` VALUES("272","AL40","1301","","0","","Wilaya de Khenchela","1");
INSERT INTO `llx_c_departements` VALUES("273","AL41","1301","","0","","Wilaya de Souk Ahras","1");
INSERT INTO `llx_c_departements` VALUES("274","AL42","1301","","0","","Wilaya de Tipaza","1");
INSERT INTO `llx_c_departements` VALUES("275","AL43","1301","","0","","Wilaya de Mila","1");
INSERT INTO `llx_c_departements` VALUES("276","AL44","1301","","0","","Wilaya d\'Aïn Defla","1");
INSERT INTO `llx_c_departements` VALUES("277","AL45","1301","","0","","Wilaya de Naâma","1");
INSERT INTO `llx_c_departements` VALUES("278","AL46","1301","","0","","Wilaya d\'Aïn Témouchent","1");
INSERT INTO `llx_c_departements` VALUES("279","AL47","1301","","0","","Wilaya de Ghardaia","1");
INSERT INTO `llx_c_departements` VALUES("280","AL48","1301","","0","","Wilaya de Relizane","1");
INSERT INTO `llx_c_departements` VALUES("281","MA","1209","","0","","Province de Benslimane","1");
INSERT INTO `llx_c_departements` VALUES("282","MA1","1209","","0","","Province de Berrechid","1");
INSERT INTO `llx_c_departements` VALUES("283","MA2","1209","","0","","Province de Khouribga","1");
INSERT INTO `llx_c_departements` VALUES("284","MA3","1209","","0","","Province de Settat","1");
INSERT INTO `llx_c_departements` VALUES("285","MA4","1210","","0","","Province d\'El Jadida","1");
INSERT INTO `llx_c_departements` VALUES("286","MA5","1210","","0","","Province de Safi","1");
INSERT INTO `llx_c_departements` VALUES("287","MA6","1210","","0","","Province de Sidi Bennour","1");
INSERT INTO `llx_c_departements` VALUES("288","MA7","1210","","0","","Province de Youssoufia","1");
INSERT INTO `llx_c_departements` VALUES("289","MA6B","1205","","0","","Préfecture de Fès","1");
INSERT INTO `llx_c_departements` VALUES("290","MA7B","1205","","0","","Province de Boulemane","1");
INSERT INTO `llx_c_departements` VALUES("291","MA8","1205","","0","","Province de Moulay Yacoub","1");
INSERT INTO `llx_c_departements` VALUES("292","MA9","1205","","0","","Province de Sefrou","1");
INSERT INTO `llx_c_departements` VALUES("293","MA8A","1202","","0","","Province de Kénitra","1");
INSERT INTO `llx_c_departements` VALUES("294","MA9A","1202","","0","","Province de Sidi Kacem","1");
INSERT INTO `llx_c_departements` VALUES("295","MA10","1202","","0","","Province de Sidi Slimane","1");
INSERT INTO `llx_c_departements` VALUES("296","MA11","1208","","0","","Préfecture de Casablanca","1");
INSERT INTO `llx_c_departements` VALUES("297","MA12","1208","","0","","Préfecture de Mohammédia","1");
INSERT INTO `llx_c_departements` VALUES("298","MA13","1208","","0","","Province de Médiouna","1");
INSERT INTO `llx_c_departements` VALUES("299","MA14","1208","","0","","Province de Nouaceur","1");
INSERT INTO `llx_c_departements` VALUES("300","MA15","1214","","0","","Province d\'Assa-Zag","1");
INSERT INTO `llx_c_departements` VALUES("301","MA16","1214","","0","","Province d\'Es-Semara","1");
INSERT INTO `llx_c_departements` VALUES("302","MA17A","1214","","0","","Province de Guelmim","1");
INSERT INTO `llx_c_departements` VALUES("303","MA18","1214","","0","","Province de Tata","1");
INSERT INTO `llx_c_departements` VALUES("304","MA19","1214","","0","","Province de Tan-Tan","1");
INSERT INTO `llx_c_departements` VALUES("305","MA15","1215","","0","","Province de Boujdour","1");
INSERT INTO `llx_c_departements` VALUES("306","MA16","1215","","0","","Province de Lâayoune","1");
INSERT INTO `llx_c_departements` VALUES("307","MA17","1215","","0","","Province de Tarfaya","1");
INSERT INTO `llx_c_departements` VALUES("308","MA18","1211","","0","","Préfecture de Marrakech","1");
INSERT INTO `llx_c_departements` VALUES("309","MA19","1211","","0","","Province d\'Al Haouz","1");
INSERT INTO `llx_c_departements` VALUES("310","MA20","1211","","0","","Province de Chichaoua","1");
INSERT INTO `llx_c_departements` VALUES("311","MA21","1211","","0","","Province d\'El Kelâa des Sraghna","1");
INSERT INTO `llx_c_departements` VALUES("312","MA22","1211","","0","","Province d\'Essaouira","1");
INSERT INTO `llx_c_departements` VALUES("313","MA23","1211","","0","","Province de Rehamna","1");
INSERT INTO `llx_c_departements` VALUES("314","MA24","1206","","0","","Préfecture de Meknès","1");
INSERT INTO `llx_c_departements` VALUES("315","MA25","1206","","0","","Province d’El Hajeb","1");
INSERT INTO `llx_c_departements` VALUES("316","MA26","1206","","0","","Province d\'Errachidia","1");
INSERT INTO `llx_c_departements` VALUES("317","MA27","1206","","0","","Province d’Ifrane","1");
INSERT INTO `llx_c_departements` VALUES("318","MA28","1206","","0","","Province de Khénifra","1");
INSERT INTO `llx_c_departements` VALUES("319","MA29","1206","","0","","Province de Midelt","1");
INSERT INTO `llx_c_departements` VALUES("320","MA30","1204","","0","","Préfecture d\'Oujda-Angad","1");
INSERT INTO `llx_c_departements` VALUES("321","MA31","1204","","0","","Province de Berkane","1");
INSERT INTO `llx_c_departements` VALUES("322","MA32","1204","","0","","Province de Driouch","1");
INSERT INTO `llx_c_departements` VALUES("323","MA33","1204","","0","","Province de Figuig","1");
INSERT INTO `llx_c_departements` VALUES("324","MA34","1204","","0","","Province de Jerada","1");
INSERT INTO `llx_c_departements` VALUES("325","MA35","1204","","0","","Province de Nador","1");
INSERT INTO `llx_c_departements` VALUES("326","MA36","1204","","0","","Province de Taourirt","1");
INSERT INTO `llx_c_departements` VALUES("327","MA37","1216","","0","","Province d\'Aousserd","1");
INSERT INTO `llx_c_departements` VALUES("328","MA38","1216","","0","","Province d\'Oued Ed-Dahab","1");
INSERT INTO `llx_c_departements` VALUES("329","MA39","1207","","0","","Préfecture de Rabat","1");
INSERT INTO `llx_c_departements` VALUES("330","MA40","1207","","0","","Préfecture de Skhirat-Témara","1");
INSERT INTO `llx_c_departements` VALUES("331","MA41","1207","","0","","Préfecture de Salé","1");
INSERT INTO `llx_c_departements` VALUES("332","MA42","1207","","0","","Province de Khémisset","1");
INSERT INTO `llx_c_departements` VALUES("333","MA43","1213","","0","","Préfecture d\'Agadir Ida-Outanane","1");
INSERT INTO `llx_c_departements` VALUES("334","MA44","1213","","0","","Préfecture d\'Inezgane-Aït Melloul","1");
INSERT INTO `llx_c_departements` VALUES("335","MA45","1213","","0","","Province de Chtouka-Aït Baha","1");
INSERT INTO `llx_c_departements` VALUES("336","MA46","1213","","0","","Province d\'Ouarzazate","1");
INSERT INTO `llx_c_departements` VALUES("337","MA47","1213","","0","","Province de Sidi Ifni","1");
INSERT INTO `llx_c_departements` VALUES("338","MA48","1213","","0","","Province de Taroudant","1");
INSERT INTO `llx_c_departements` VALUES("339","MA49","1213","","0","","Province de Tinghir","1");
INSERT INTO `llx_c_departements` VALUES("340","MA50","1213","","0","","Province de Tiznit","1");
INSERT INTO `llx_c_departements` VALUES("341","MA51","1213","","0","","Province de Zagora","1");
INSERT INTO `llx_c_departements` VALUES("342","MA52","1212","","0","","Province d\'Azilal","1");
INSERT INTO `llx_c_departements` VALUES("343","MA53","1212","","0","","Province de Beni Mellal","1");
INSERT INTO `llx_c_departements` VALUES("344","MA54","1212","","0","","Province de Fquih Ben Salah","1");
INSERT INTO `llx_c_departements` VALUES("345","MA55","1201","","0","","Préfecture de M\'diq-Fnideq","1");
INSERT INTO `llx_c_departements` VALUES("346","MA56","1201","","0","","Préfecture de Tanger-Asilah","1");
INSERT INTO `llx_c_departements` VALUES("347","MA57","1201","","0","","Province de Chefchaouen","1");
INSERT INTO `llx_c_departements` VALUES("348","MA58","1201","","0","","Province de Fahs-Anjra","1");
INSERT INTO `llx_c_departements` VALUES("349","MA59","1201","","0","","Province de Larache","1");
INSERT INTO `llx_c_departements` VALUES("350","MA60","1201","","0","","Province d\'Ouezzane","1");
INSERT INTO `llx_c_departements` VALUES("351","MA61","1201","","0","","Province de Tétouan","1");
INSERT INTO `llx_c_departements` VALUES("352","MA62","1203","","0","","Province de Guercif","1");
INSERT INTO `llx_c_departements` VALUES("353","MA63","1203","","0","","Province d\'Al Hoceïma","1");
INSERT INTO `llx_c_departements` VALUES("354","MA64","1203","","0","","Province de Taounate","1");
INSERT INTO `llx_c_departements` VALUES("355","MA65","1203","","0","","Province de Taza","1");
INSERT INTO `llx_c_departements` VALUES("356","MA6A","1205","","0","","Préfecture de Fès","1");
INSERT INTO `llx_c_departements` VALUES("357","MA7A","1205","","0","","Province de Boulemane","1");
INSERT INTO `llx_c_departements` VALUES("358","MA15A","1214","","0","","Province d\'Assa-Zag","1");
INSERT INTO `llx_c_departements` VALUES("359","MA16A","1214","","0","","Province d\'Es-Semara","1");
INSERT INTO `llx_c_departements` VALUES("360","MA18A","1211","","0","","Préfecture de Marrakech","1");
INSERT INTO `llx_c_departements` VALUES("361","MA19A","1214","","0","","Province de Tan-Tan","1");
INSERT INTO `llx_c_departements` VALUES("362","MA19B","1214","","0","","Province de Tan-Tan","1");
INSERT INTO `llx_c_departements` VALUES("363","TN01","1001","","0","","Ariana","1");
INSERT INTO `llx_c_departements` VALUES("364","TN02","1001","","0","","Béja","1");
INSERT INTO `llx_c_departements` VALUES("365","TN03","1001","","0","","Ben Arous","1");
INSERT INTO `llx_c_departements` VALUES("366","TN04","1001","","0","","Bizerte","1");
INSERT INTO `llx_c_departements` VALUES("367","TN05","1001","","0","","Gabès","1");
INSERT INTO `llx_c_departements` VALUES("368","TN06","1001","","0","","Gafsa","1");
INSERT INTO `llx_c_departements` VALUES("369","TN07","1001","","0","","Jendouba","1");
INSERT INTO `llx_c_departements` VALUES("370","TN08","1001","","0","","Kairouan","1");
INSERT INTO `llx_c_departements` VALUES("371","TN09","1001","","0","","Kasserine","1");
INSERT INTO `llx_c_departements` VALUES("372","TN10","1001","","0","","Kébili","1");
INSERT INTO `llx_c_departements` VALUES("373","TN11","1001","","0","","La Manouba","1");
INSERT INTO `llx_c_departements` VALUES("374","TN12","1001","","0","","Le Kef","1");
INSERT INTO `llx_c_departements` VALUES("375","TN13","1001","","0","","Mahdia","1");
INSERT INTO `llx_c_departements` VALUES("376","TN14","1001","","0","","Médenine","1");
INSERT INTO `llx_c_departements` VALUES("377","TN15","1001","","0","","Monastir","1");
INSERT INTO `llx_c_departements` VALUES("378","TN16","1001","","0","","Nabeul","1");
INSERT INTO `llx_c_departements` VALUES("379","TN17","1001","","0","","Sfax","1");
INSERT INTO `llx_c_departements` VALUES("380","TN18","1001","","0","","Sidi Bouzid","1");
INSERT INTO `llx_c_departements` VALUES("381","TN19","1001","","0","","Siliana","1");
INSERT INTO `llx_c_departements` VALUES("382","TN20","1001","","0","","Sousse","1");
INSERT INTO `llx_c_departements` VALUES("383","TN21","1001","","0","","Tataouine","1");
INSERT INTO `llx_c_departements` VALUES("384","TN22","1001","","0","","Tozeur","1");
INSERT INTO `llx_c_departements` VALUES("385","TN23","1001","","0","","Tunis","1");
INSERT INTO `llx_c_departements` VALUES("386","TN24","1001","","0","","Zaghouan","1");
INSERT INTO `llx_c_departements` VALUES("387","001","5201","","0","","Belisario Boeto","1");
INSERT INTO `llx_c_departements` VALUES("388","002","5201","","0","","Hernando Siles","1");
INSERT INTO `llx_c_departements` VALUES("389","003","5201","","0","","Jaime Zudáñez","1");
INSERT INTO `llx_c_departements` VALUES("390","004","5201","","0","","Juana Azurduy de Padilla","1");
INSERT INTO `llx_c_departements` VALUES("391","005","5201","","0","","Luis Calvo","1");
INSERT INTO `llx_c_departements` VALUES("392","006","5201","","0","","Nor Cinti","1");
INSERT INTO `llx_c_departements` VALUES("393","007","5201","","0","","Oropeza","1");
INSERT INTO `llx_c_departements` VALUES("394","008","5201","","0","","Sud Cinti","1");
INSERT INTO `llx_c_departements` VALUES("395","009","5201","","0","","Tomina","1");
INSERT INTO `llx_c_departements` VALUES("396","010","5201","","0","","Yamparáez","1");
INSERT INTO `llx_c_departements` VALUES("397","011","5202","","0","","Abel Iturralde","1");
INSERT INTO `llx_c_departements` VALUES("398","012","5202","","0","","Aroma","1");
INSERT INTO `llx_c_departements` VALUES("399","013","5202","","0","","Bautista Saavedra","1");
INSERT INTO `llx_c_departements` VALUES("400","014","5202","","0","","Caranavi","1");
INSERT INTO `llx_c_departements` VALUES("401","015","5202","","0","","Eliodoro Camacho","1");
INSERT INTO `llx_c_departements` VALUES("402","016","5202","","0","","Franz Tamayo","1");
INSERT INTO `llx_c_departements` VALUES("403","017","5202","","0","","Gualberto Villarroel","1");
INSERT INTO `llx_c_departements` VALUES("404","018","5202","","0","","Ingaví","1");
INSERT INTO `llx_c_departements` VALUES("405","019","5202","","0","","Inquisivi","1");
INSERT INTO `llx_c_departements` VALUES("406","020","5202","","0","","José Ramón Loayza","1");
INSERT INTO `llx_c_departements` VALUES("407","021","5202","","0","","Larecaja","1");
INSERT INTO `llx_c_departements` VALUES("408","022","5202","","0","","Los Andes (Bolivia)","1");
INSERT INTO `llx_c_departements` VALUES("409","023","5202","","0","","Manco Kapac","1");
INSERT INTO `llx_c_departements` VALUES("410","024","5202","","0","","Muñecas","1");
INSERT INTO `llx_c_departements` VALUES("411","025","5202","","0","","Nor Yungas","1");
INSERT INTO `llx_c_departements` VALUES("412","026","5202","","0","","Omasuyos","1");
INSERT INTO `llx_c_departements` VALUES("413","027","5202","","0","","Pacajes","1");
INSERT INTO `llx_c_departements` VALUES("414","028","5202","","0","","Pedro Domingo Murillo","1");
INSERT INTO `llx_c_departements` VALUES("415","029","5202","","0","","Sud Yungas","1");
INSERT INTO `llx_c_departements` VALUES("416","030","5202","","0","","General José Manuel Pando","1");
INSERT INTO `llx_c_departements` VALUES("417","031","5203","","0","","Arani","1");
INSERT INTO `llx_c_departements` VALUES("418","032","5203","","0","","Arque","1");
INSERT INTO `llx_c_departements` VALUES("419","033","5203","","0","","Ayopaya","1");
INSERT INTO `llx_c_departements` VALUES("420","034","5203","","0","","Bolívar (Bolivia)","1");
INSERT INTO `llx_c_departements` VALUES("421","035","5203","","0","","Campero","1");
INSERT INTO `llx_c_departements` VALUES("422","036","5203","","0","","Capinota","1");
INSERT INTO `llx_c_departements` VALUES("423","037","5203","","0","","Cercado (Cochabamba)","1");
INSERT INTO `llx_c_departements` VALUES("424","038","5203","","0","","Esteban Arze","1");
INSERT INTO `llx_c_departements` VALUES("425","039","5203","","0","","Germán Jordán","1");
INSERT INTO `llx_c_departements` VALUES("426","040","5203","","0","","José Carrasco","1");
INSERT INTO `llx_c_departements` VALUES("427","041","5203","","0","","Mizque","1");
INSERT INTO `llx_c_departements` VALUES("428","042","5203","","0","","Punata","1");
INSERT INTO `llx_c_departements` VALUES("429","043","5203","","0","","Quillacollo","1");
INSERT INTO `llx_c_departements` VALUES("430","044","5203","","0","","Tapacarí","1");
INSERT INTO `llx_c_departements` VALUES("431","045","5203","","0","","Tiraque","1");
INSERT INTO `llx_c_departements` VALUES("432","046","5203","","0","","Chapare","1");
INSERT INTO `llx_c_departements` VALUES("433","047","5204","","0","","Carangas","1");
INSERT INTO `llx_c_departements` VALUES("434","048","5204","","0","","Cercado (Oruro)","1");
INSERT INTO `llx_c_departements` VALUES("435","049","5204","","0","","Eduardo Avaroa","1");
INSERT INTO `llx_c_departements` VALUES("436","050","5204","","0","","Ladislao Cabrera","1");
INSERT INTO `llx_c_departements` VALUES("437","051","5204","","0","","Litoral de Atacama","1");
INSERT INTO `llx_c_departements` VALUES("438","052","5204","","0","","Mejillones","1");
INSERT INTO `llx_c_departements` VALUES("439","053","5204","","0","","Nor Carangas","1");
INSERT INTO `llx_c_departements` VALUES("440","054","5204","","0","","Pantaleón Dalence","1");
INSERT INTO `llx_c_departements` VALUES("441","055","5204","","0","","Poopó","1");
INSERT INTO `llx_c_departements` VALUES("442","056","5204","","0","","Sabaya","1");
INSERT INTO `llx_c_departements` VALUES("443","057","5204","","0","","Sajama","1");
INSERT INTO `llx_c_departements` VALUES("444","058","5204","","0","","San Pedro de Totora","1");
INSERT INTO `llx_c_departements` VALUES("445","059","5204","","0","","Saucarí","1");
INSERT INTO `llx_c_departements` VALUES("446","060","5204","","0","","Sebastián Pagador","1");
INSERT INTO `llx_c_departements` VALUES("447","061","5204","","0","","Sud Carangas","1");
INSERT INTO `llx_c_departements` VALUES("448","062","5204","","0","","Tomás Barrón","1");
INSERT INTO `llx_c_departements` VALUES("449","063","5205","","0","","Alonso de Ibáñez","1");
INSERT INTO `llx_c_departements` VALUES("450","064","5205","","0","","Antonio Quijarro","1");
INSERT INTO `llx_c_departements` VALUES("451","065","5205","","0","","Bernardino Bilbao","1");
INSERT INTO `llx_c_departements` VALUES("452","066","5205","","0","","Charcas (Potosí)","1");
INSERT INTO `llx_c_departements` VALUES("453","067","5205","","0","","Chayanta","1");
INSERT INTO `llx_c_departements` VALUES("454","068","5205","","0","","Cornelio Saavedra","1");
INSERT INTO `llx_c_departements` VALUES("455","069","5205","","0","","Daniel Campos","1");
INSERT INTO `llx_c_departements` VALUES("456","070","5205","","0","","Enrique Baldivieso","1");
INSERT INTO `llx_c_departements` VALUES("457","071","5205","","0","","José María Linares","1");
INSERT INTO `llx_c_departements` VALUES("458","072","5205","","0","","Modesto Omiste","1");
INSERT INTO `llx_c_departements` VALUES("459","073","5205","","0","","Nor Chichas","1");
INSERT INTO `llx_c_departements` VALUES("460","074","5205","","0","","Nor Lípez","1");
INSERT INTO `llx_c_departements` VALUES("461","075","5205","","0","","Rafael Bustillo","1");
INSERT INTO `llx_c_departements` VALUES("462","076","5205","","0","","Sud Chichas","1");
INSERT INTO `llx_c_departements` VALUES("463","077","5205","","0","","Sud Lípez","1");
INSERT INTO `llx_c_departements` VALUES("464","078","5205","","0","","Tomás Frías","1");
INSERT INTO `llx_c_departements` VALUES("465","079","5206","","0","","Aniceto Arce","1");
INSERT INTO `llx_c_departements` VALUES("466","080","5206","","0","","Burdet O\'Connor","1");
INSERT INTO `llx_c_departements` VALUES("467","081","5206","","0","","Cercado (Tarija)","1");
INSERT INTO `llx_c_departements` VALUES("468","082","5206","","0","","Eustaquio Méndez","1");
INSERT INTO `llx_c_departements` VALUES("469","083","5206","","0","","José María Avilés","1");
INSERT INTO `llx_c_departements` VALUES("470","084","5206","","0","","Gran Chaco","1");
INSERT INTO `llx_c_departements` VALUES("471","085","5207","","0","","Andrés Ibáñez","1");
INSERT INTO `llx_c_departements` VALUES("472","086","5207","","0","","Caballero","1");
INSERT INTO `llx_c_departements` VALUES("473","087","5207","","0","","Chiquitos","1");
INSERT INTO `llx_c_departements` VALUES("474","088","5207","","0","","Cordillera (Bolivia)","1");
INSERT INTO `llx_c_departements` VALUES("475","089","5207","","0","","Florida","1");
INSERT INTO `llx_c_departements` VALUES("476","090","5207","","0","","Germán Busch","1");
INSERT INTO `llx_c_departements` VALUES("477","091","5207","","0","","Guarayos","1");
INSERT INTO `llx_c_departements` VALUES("478","092","5207","","0","","Ichilo","1");
INSERT INTO `llx_c_departements` VALUES("479","093","5207","","0","","Obispo Santistevan","1");
INSERT INTO `llx_c_departements` VALUES("480","094","5207","","0","","Sara","1");
INSERT INTO `llx_c_departements` VALUES("481","095","5207","","0","","Vallegrande","1");
INSERT INTO `llx_c_departements` VALUES("482","096","5207","","0","","Velasco","1");
INSERT INTO `llx_c_departements` VALUES("483","097","5207","","0","","Warnes","1");
INSERT INTO `llx_c_departements` VALUES("484","098","5207","","0","","Ángel Sandóval","1");
INSERT INTO `llx_c_departements` VALUES("485","099","5207","","0","","Ñuflo de Chaves","1");
INSERT INTO `llx_c_departements` VALUES("486","100","5208","","0","","Cercado (Beni)","1");
INSERT INTO `llx_c_departements` VALUES("487","101","5208","","0","","Iténez","1");
INSERT INTO `llx_c_departements` VALUES("488","102","5208","","0","","Mamoré","1");
INSERT INTO `llx_c_departements` VALUES("489","103","5208","","0","","Marbán","1");
INSERT INTO `llx_c_departements` VALUES("490","104","5208","","0","","Moxos","1");
INSERT INTO `llx_c_departements` VALUES("491","105","5208","","0","","Vaca Díez","1");
INSERT INTO `llx_c_departements` VALUES("492","106","5208","","0","","Yacuma","1");
INSERT INTO `llx_c_departements` VALUES("493","107","5208","","0","","General José Ballivián Segurola","1");
INSERT INTO `llx_c_departements` VALUES("494","108","5209","","0","","Abuná","1");
INSERT INTO `llx_c_departements` VALUES("495","109","5209","","0","","Madre de Dios","1");
INSERT INTO `llx_c_departements` VALUES("496","110","5209","","0","","Manuripi","1");
INSERT INTO `llx_c_departements` VALUES("497","111","5209","","0","","Nicolás Suárez","1");
INSERT INTO `llx_c_departements` VALUES("498","112","5209","","0","","General Federico Román","1");
INSERT INTO `llx_c_departements` VALUES("499","NSW","2801","","1","","New South Wales","1");
INSERT INTO `llx_c_departements` VALUES("500","VIC","2801","","1","","Victoria","1");
INSERT INTO `llx_c_departements` VALUES("501","QLD","2801","","1","","Queensland","1");
INSERT INTO `llx_c_departements` VALUES("502","SA","2801","","1","","South Australia","1");
INSERT INTO `llx_c_departements` VALUES("503","ACT","2801","","1","","Australia Capital Territory","1");
INSERT INTO `llx_c_departements` VALUES("504","TAS","2801","","1","","Tasmania","1");
INSERT INTO `llx_c_departements` VALUES("505","WA","2801","","1","","Western Australia","1");
INSERT INTO `llx_c_departements` VALUES("506","NT","2801","","1","","Northern Territory","1");
INSERT INTO `llx_c_departements` VALUES("507","ON","1401","","1","","Ontario","1");
INSERT INTO `llx_c_departements` VALUES("508","QC","1401","","1","","Quebec","1");
INSERT INTO `llx_c_departements` VALUES("509","NS","1401","","1","","Nova Scotia","1");
INSERT INTO `llx_c_departements` VALUES("510","NB","1401","","1","","New Brunswick","1");
INSERT INTO `llx_c_departements` VALUES("511","MB","1401","","1","","Manitoba","1");
INSERT INTO `llx_c_departements` VALUES("512","BC","1401","","1","","British Columbia","1");
INSERT INTO `llx_c_departements` VALUES("513","PE","1401","","1","","Prince Edward Island","1");
INSERT INTO `llx_c_departements` VALUES("514","SK","1401","","1","","Saskatchewan","1");
INSERT INTO `llx_c_departements` VALUES("515","AB","1401","","1","","Alberta","1");
INSERT INTO `llx_c_departements` VALUES("516","NL","1401","","1","","Newfoundland and Labrador","1");
INSERT INTO `llx_c_departements` VALUES("517","VI","419","","19","ALAVA","Álava","1");
INSERT INTO `llx_c_departements` VALUES("518","AB","404","","4","ALBACETE","Albacete","1");
INSERT INTO `llx_c_departements` VALUES("519","A","411","","11","ALICANTE","Alicante","1");
INSERT INTO `llx_c_departements` VALUES("520","AL","401","","1","ALMERIA","Almería","1");
INSERT INTO `llx_c_departements` VALUES("521","AV","403","","3","AVILA","Avila","1");
INSERT INTO `llx_c_departements` VALUES("522","BA","412","","12","BADAJOZ","Badajoz","1");
INSERT INTO `llx_c_departements` VALUES("523","PM","414","","14","ISLAS BALEARES","Islas Baleares","1");
INSERT INTO `llx_c_departements` VALUES("524","B","406","","6","BARCELONA","Barcelona","1");
INSERT INTO `llx_c_departements` VALUES("525","BU","403","","8","BURGOS","Burgos","1");
INSERT INTO `llx_c_departements` VALUES("526","CC","412","","12","CACERES","Cáceres","1");
INSERT INTO `llx_c_departements` VALUES("527","CA","401","","1","CADIZ","Cádiz","1");
INSERT INTO `llx_c_departements` VALUES("528","CS","411","","11","CASTELLON","Castellón","1");
INSERT INTO `llx_c_departements` VALUES("529","CR","404","","4","CIUDAD REAL","Ciudad Real","1");
INSERT INTO `llx_c_departements` VALUES("530","CO","401","","1","CORDOBA","Córdoba","1");
INSERT INTO `llx_c_departements` VALUES("531","C","413","","13","LA CORUÑA","La Coruña","1");
INSERT INTO `llx_c_departements` VALUES("532","CU","404","","4","CUENCA","Cuenca","1");
INSERT INTO `llx_c_departements` VALUES("533","GI","406","","6","GERONA","Gerona","1");
INSERT INTO `llx_c_departements` VALUES("534","GR","401","","1","GRANADA","Granada","1");
INSERT INTO `llx_c_departements` VALUES("535","GU","404","","4","GUADALAJARA","Guadalajara","1");
INSERT INTO `llx_c_departements` VALUES("536","SS","419","","19","GUIPUZCOA","Guipúzcoa","1");
INSERT INTO `llx_c_departements` VALUES("537","H","401","","1","HUELVA","Huelva","1");
INSERT INTO `llx_c_departements` VALUES("538","HU","402","","2","HUESCA","Huesca","1");
INSERT INTO `llx_c_departements` VALUES("539","J","401","","1","JAEN","Jaén","1");
INSERT INTO `llx_c_departements` VALUES("540","LE","403","","3","LEON","León","1");
INSERT INTO `llx_c_departements` VALUES("541","L","406","","6","LERIDA","Lérida","1");
INSERT INTO `llx_c_departements` VALUES("542","LO","415","","15","LA RIOJA","La Rioja","1");
INSERT INTO `llx_c_departements` VALUES("543","LU","413","","13","LUGO","Lugo","1");
INSERT INTO `llx_c_departements` VALUES("544","M","416","","16","MADRID","Madrid","1");
INSERT INTO `llx_c_departements` VALUES("545","MA","401","","1","MALAGA","Málaga","1");
INSERT INTO `llx_c_departements` VALUES("546","MU","417","","17","MURCIA","Murcia","1");
INSERT INTO `llx_c_departements` VALUES("547","NA","408","","8","NAVARRA","Navarra","1");
INSERT INTO `llx_c_departements` VALUES("548","OR","413","","13","ORENSE","Orense","1");
INSERT INTO `llx_c_departements` VALUES("549","O","418","","18","ASTURIAS","Asturias","1");
INSERT INTO `llx_c_departements` VALUES("550","P","403","","3","PALENCIA","Palencia","1");
INSERT INTO `llx_c_departements` VALUES("551","GC","405","","5","LAS PALMAS","Las Palmas","1");
INSERT INTO `llx_c_departements` VALUES("552","PO","413","","13","PONTEVEDRA","Pontevedra","1");
INSERT INTO `llx_c_departements` VALUES("553","SA","403","","3","SALAMANCA","Salamanca","1");
INSERT INTO `llx_c_departements` VALUES("554","TF","405","","5","STA. CRUZ DE TENERIFE","Sta. Cruz de Tenerife","1");
INSERT INTO `llx_c_departements` VALUES("555","S","410","","10","CANTABRIA","Cantabria","1");
INSERT INTO `llx_c_departements` VALUES("556","SG","403","","3","SEGOVIA","Segovia","1");
INSERT INTO `llx_c_departements` VALUES("557","SE","401","","1","SEVILLA","Sevilla","1");
INSERT INTO `llx_c_departements` VALUES("558","SO","403","","3","SORIA","Soria","1");
INSERT INTO `llx_c_departements` VALUES("559","T","406","","6","TARRAGONA","Tarragona","1");
INSERT INTO `llx_c_departements` VALUES("560","TE","402","","2","TERUEL","Teruel","1");
INSERT INTO `llx_c_departements` VALUES("561","TO","404","","5","TOLEDO","Toledo","1");
INSERT INTO `llx_c_departements` VALUES("562","V","411","","11","VALENCIA","Valencia","1");
INSERT INTO `llx_c_departements` VALUES("563","VA","403","","3","VALLADOLID","Valladolid","1");
INSERT INTO `llx_c_departements` VALUES("564","BI","419","","19","VIZCAYA","Vizcaya","1");
INSERT INTO `llx_c_departements` VALUES("565","ZA","403","","3","ZAMORA","Zamora","1");
INSERT INTO `llx_c_departements` VALUES("566","Z","402","","1","ZARAGOZA","Zaragoza","1");
INSERT INTO `llx_c_departements` VALUES("567","CE","407","","7","CEUTA","Ceuta","1");
INSERT INTO `llx_c_departements` VALUES("568","ML","409","","9","MELILLA","Melilla","1");
INSERT INTO `llx_c_departements` VALUES("569","BW","501",NULL,NULL,"BADEN-WÜRTTEMBERG","Baden-Württemberg","1");
INSERT INTO `llx_c_departements` VALUES("570","BY","501",NULL,NULL,"BAYERN","Bayern","1");
INSERT INTO `llx_c_departements` VALUES("571","BE","501",NULL,NULL,"BERLIN","Berlin","1");
INSERT INTO `llx_c_departements` VALUES("572","BB","501",NULL,NULL,"BRANDENBURG","Brandenburg","1");
INSERT INTO `llx_c_departements` VALUES("573","HB","501",NULL,NULL,"BREMEN","Bremen","1");
INSERT INTO `llx_c_departements` VALUES("574","HH","501",NULL,NULL,"HAMBURG","Hamburg","1");
INSERT INTO `llx_c_departements` VALUES("575","HE","501",NULL,NULL,"HESSEN","Hessen","1");
INSERT INTO `llx_c_departements` VALUES("576","MV","501",NULL,NULL,"MECKLENBURG-VORPOMMERN","Mecklenburg-Vorpommern","1");
INSERT INTO `llx_c_departements` VALUES("577","NI","501",NULL,NULL,"NIEDERSACHSEN","Niedersachsen","1");
INSERT INTO `llx_c_departements` VALUES("578","NW","501",NULL,NULL,"NORDRHEIN-WESTFALEN","Nordrhein-Westfalen","1");
INSERT INTO `llx_c_departements` VALUES("579","RP","501",NULL,NULL,"RHEINLAND-PFALZ","Rheinland-Pfalz","1");
INSERT INTO `llx_c_departements` VALUES("580","SL","501",NULL,NULL,"SAARLAND","Saarland","1");
INSERT INTO `llx_c_departements` VALUES("581","SN","501",NULL,NULL,"SACHSEN","Sachsen","1");
INSERT INTO `llx_c_departements` VALUES("582","ST","501",NULL,NULL,"SACHSEN-ANHALT","Sachsen-Anhalt","1");
INSERT INTO `llx_c_departements` VALUES("583","SH","501",NULL,NULL,"SCHLESWIG-HOLSTEIN","Schleswig-Holstein","1");
INSERT INTO `llx_c_departements` VALUES("584","TH","501",NULL,NULL,"THÜRINGEN","Thüringen","1");
INSERT INTO `llx_c_departements` VALUES("585","66","10201","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("586","67","10205","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("587","01","10205","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("588","02","10205","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("589","03","10205","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("590","04","10205","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("591","05","10205","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("592","06","10203","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("593","07","10203","","0","","???????????","1");
INSERT INTO `llx_c_departements` VALUES("594","08","10203","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("595","09","10203","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("596","10","10203","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("597","11","10203","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("598","12","10203","","0","","?????????","1");
INSERT INTO `llx_c_departements` VALUES("599","13","10206","","0","","????","1");
INSERT INTO `llx_c_departements` VALUES("600","14","10206","","0","","?????????","1");
INSERT INTO `llx_c_departements` VALUES("601","15","10206","","0","","????????","1");
INSERT INTO `llx_c_departements` VALUES("602","16","10206","","0","","???????","1");
INSERT INTO `llx_c_departements` VALUES("603","17","10213","","0","","???????","1");
INSERT INTO `llx_c_departements` VALUES("604","18","10213","","0","","????????","1");
INSERT INTO `llx_c_departements` VALUES("605","19","10213","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("606","20","10213","","0","","???????","1");
INSERT INTO `llx_c_departements` VALUES("607","21","10212","","0","","????????","1");
INSERT INTO `llx_c_departements` VALUES("608","22","10212","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("609","23","10212","","0","","????????","1");
INSERT INTO `llx_c_departements` VALUES("610","24","10212","","0","","???????","1");
INSERT INTO `llx_c_departements` VALUES("611","25","10212","","0","","????????","1");
INSERT INTO `llx_c_departements` VALUES("612","26","10212","","0","","???????","1");
INSERT INTO `llx_c_departements` VALUES("613","27","10202","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("614","28","10202","","0","","?????????","1");
INSERT INTO `llx_c_departements` VALUES("615","29","10202","","0","","????????","1");
INSERT INTO `llx_c_departements` VALUES("616","30","10202","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("617","31","10209","","0","","????????","1");
INSERT INTO `llx_c_departements` VALUES("618","32","10209","","0","","???????","1");
INSERT INTO `llx_c_departements` VALUES("619","33","10209","","0","","????????","1");
INSERT INTO `llx_c_departements` VALUES("620","34","10209","","0","","???????","1");
INSERT INTO `llx_c_departements` VALUES("621","35","10209","","0","","????????","1");
INSERT INTO `llx_c_departements` VALUES("622","36","10211","","0","","???????????????","1");
INSERT INTO `llx_c_departements` VALUES("623","37","10211","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("624","38","10211","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("625","39","10207","","0","","????????","1");
INSERT INTO `llx_c_departements` VALUES("626","40","10207","","0","","???????","1");
INSERT INTO `llx_c_departements` VALUES("627","41","10207","","0","","??????????","1");
INSERT INTO `llx_c_departements` VALUES("628","42","10207","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("629","43","10207","","0","","???????","1");
INSERT INTO `llx_c_departements` VALUES("630","44","10208","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("631","45","10208","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("632","46","10208","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("633","47","10208","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("634","48","10208","","0","","????","1");
INSERT INTO `llx_c_departements` VALUES("635","49","10210","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("636","50","10210","","0","","????","1");
INSERT INTO `llx_c_departements` VALUES("637","51","10210","","0","","????????","1");
INSERT INTO `llx_c_departements` VALUES("638","52","10210","","0","","????????","1");
INSERT INTO `llx_c_departements` VALUES("639","53","10210","","0","","???-??????","1");
INSERT INTO `llx_c_departements` VALUES("640","54","10210","","0","","??","1");
INSERT INTO `llx_c_departements` VALUES("641","55","10210","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("642","56","10210","","0","","???????","1");
INSERT INTO `llx_c_departements` VALUES("643","57","10210","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("644","58","10210","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("645","59","10210","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("646","60","10210","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("647","61","10210","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("648","62","10204","","0","","????????","1");
INSERT INTO `llx_c_departements` VALUES("649","63","10204","","0","","??????","1");
INSERT INTO `llx_c_departements` VALUES("650","64","10204","","0","","???????","1");
INSERT INTO `llx_c_departements` VALUES("651","65","10204","","0","","?????","1");
INSERT INTO `llx_c_departements` VALUES("652","AG","601",NULL,NULL,"ARGOVIE","Argovie","1");
INSERT INTO `llx_c_departements` VALUES("653","AI","601",NULL,NULL,"APPENZELL RHODES INTERIEURES","Appenzell Rhodes intérieures","1");
INSERT INTO `llx_c_departements` VALUES("654","AR","601",NULL,NULL,"APPENZELL RHODES EXTERIEURES","Appenzell Rhodes extérieures","1");
INSERT INTO `llx_c_departements` VALUES("655","BE","601",NULL,NULL,"BERNE","Berne","1");
INSERT INTO `llx_c_departements` VALUES("656","BL","601",NULL,NULL,"BALE CAMPAGNE","Bâle Campagne","1");
INSERT INTO `llx_c_departements` VALUES("657","BS","601",NULL,NULL,"BALE VILLE","Bâle Ville","1");
INSERT INTO `llx_c_departements` VALUES("658","FR","601",NULL,NULL,"FRIBOURG","Fribourg","1");
INSERT INTO `llx_c_departements` VALUES("659","GE","601",NULL,NULL,"GENEVE","Genève","1");
INSERT INTO `llx_c_departements` VALUES("660","GL","601",NULL,NULL,"GLARIS","Glaris","1");
INSERT INTO `llx_c_departements` VALUES("661","GR","601",NULL,NULL,"GRISONS","Grisons","1");
INSERT INTO `llx_c_departements` VALUES("662","JU","601",NULL,NULL,"JURA","Jura","1");
INSERT INTO `llx_c_departements` VALUES("663","LU","601",NULL,NULL,"LUCERNE","Lucerne","1");
INSERT INTO `llx_c_departements` VALUES("664","NE","601",NULL,NULL,"NEUCHATEL","Neuchâtel","1");
INSERT INTO `llx_c_departements` VALUES("665","NW","601",NULL,NULL,"NIDWALD","Nidwald","1");
INSERT INTO `llx_c_departements` VALUES("666","OW","601",NULL,NULL,"OBWALD","Obwald","1");
INSERT INTO `llx_c_departements` VALUES("667","SG","601",NULL,NULL,"SAINT-GALL","Saint-Gall","1");
INSERT INTO `llx_c_departements` VALUES("668","SH","601",NULL,NULL,"SCHAFFHOUSE","Schaffhouse","1");
INSERT INTO `llx_c_departements` VALUES("669","SO","601",NULL,NULL,"SOLEURE","Soleure","1");
INSERT INTO `llx_c_departements` VALUES("670","SZ","601",NULL,NULL,"SCHWYZ","Schwyz","1");
INSERT INTO `llx_c_departements` VALUES("671","TG","601",NULL,NULL,"THURGOVIE","Thurgovie","1");
INSERT INTO `llx_c_departements` VALUES("672","TI","601",NULL,NULL,"TESSIN","Tessin","1");
INSERT INTO `llx_c_departements` VALUES("673","UR","601",NULL,NULL,"URI","Uri","1");
INSERT INTO `llx_c_departements` VALUES("674","VD","601",NULL,NULL,"VAUD","Vaud","1");
INSERT INTO `llx_c_departements` VALUES("675","VS","601",NULL,NULL,"VALAIS","Valais","1");
INSERT INTO `llx_c_departements` VALUES("676","ZG","601",NULL,NULL,"ZUG","Zug","1");
INSERT INTO `llx_c_departements` VALUES("677","ZH","601",NULL,NULL,"ZURICH","Zürich","1");
INSERT INTO `llx_c_departements` VALUES("678","701","701",NULL,"0",NULL,"Bedfordshire","1");
INSERT INTO `llx_c_departements` VALUES("679","702","701",NULL,"0",NULL,"Berkshire","1");
INSERT INTO `llx_c_departements` VALUES("680","703","701",NULL,"0",NULL,"Bristol, City of","1");
INSERT INTO `llx_c_departements` VALUES("681","704","701",NULL,"0",NULL,"Buckinghamshire","1");
INSERT INTO `llx_c_departements` VALUES("682","705","701",NULL,"0",NULL,"Cambridgeshire","1");
INSERT INTO `llx_c_departements` VALUES("683","706","701",NULL,"0",NULL,"Cheshire","1");
INSERT INTO `llx_c_departements` VALUES("684","707","701",NULL,"0",NULL,"Cleveland","1");
INSERT INTO `llx_c_departements` VALUES("685","708","701",NULL,"0",NULL,"Cornwall","1");
INSERT INTO `llx_c_departements` VALUES("686","709","701",NULL,"0",NULL,"Cumberland","1");
INSERT INTO `llx_c_departements` VALUES("687","710","701",NULL,"0",NULL,"Cumbria","1");
INSERT INTO `llx_c_departements` VALUES("688","711","701",NULL,"0",NULL,"Derbyshire","1");
INSERT INTO `llx_c_departements` VALUES("689","712","701",NULL,"0",NULL,"Devon","1");
INSERT INTO `llx_c_departements` VALUES("690","713","701",NULL,"0",NULL,"Dorset","1");
INSERT INTO `llx_c_departements` VALUES("691","714","701",NULL,"0",NULL,"Co. Durham","1");
INSERT INTO `llx_c_departements` VALUES("692","715","701",NULL,"0",NULL,"East Riding of Yorkshire","1");
INSERT INTO `llx_c_departements` VALUES("693","716","701",NULL,"0",NULL,"East Sussex","1");
INSERT INTO `llx_c_departements` VALUES("694","717","701",NULL,"0",NULL,"Essex","1");
INSERT INTO `llx_c_departements` VALUES("695","718","701",NULL,"0",NULL,"Gloucestershire","1");
INSERT INTO `llx_c_departements` VALUES("696","719","701",NULL,"0",NULL,"Greater Manchester","1");
INSERT INTO `llx_c_departements` VALUES("697","720","701",NULL,"0",NULL,"Hampshire","1");
INSERT INTO `llx_c_departements` VALUES("698","721","701",NULL,"0",NULL,"Hertfordshire","1");
INSERT INTO `llx_c_departements` VALUES("699","722","701",NULL,"0",NULL,"Hereford and Worcester","1");
INSERT INTO `llx_c_departements` VALUES("700","723","701",NULL,"0",NULL,"Herefordshire","1");
INSERT INTO `llx_c_departements` VALUES("701","724","701",NULL,"0",NULL,"Huntingdonshire","1");
INSERT INTO `llx_c_departements` VALUES("702","725","701",NULL,"0",NULL,"Isle of Man","1");
INSERT INTO `llx_c_departements` VALUES("703","726","701",NULL,"0",NULL,"Isle of Wight","1");
INSERT INTO `llx_c_departements` VALUES("704","727","701",NULL,"0",NULL,"Jersey","1");
INSERT INTO `llx_c_departements` VALUES("705","728","701",NULL,"0",NULL,"Kent","1");
INSERT INTO `llx_c_departements` VALUES("706","729","701",NULL,"0",NULL,"Lancashire","1");
INSERT INTO `llx_c_departements` VALUES("707","730","701",NULL,"0",NULL,"Leicestershire","1");
INSERT INTO `llx_c_departements` VALUES("708","731","701",NULL,"0",NULL,"Lincolnshire","1");
INSERT INTO `llx_c_departements` VALUES("709","732","701",NULL,"0",NULL,"London - City of London","1");
INSERT INTO `llx_c_departements` VALUES("710","733","701",NULL,"0",NULL,"Merseyside","1");
INSERT INTO `llx_c_departements` VALUES("711","734","701",NULL,"0",NULL,"Middlesex","1");
INSERT INTO `llx_c_departements` VALUES("712","735","701",NULL,"0",NULL,"Norfolk","1");
INSERT INTO `llx_c_departements` VALUES("713","736","701",NULL,"0",NULL,"North Yorkshire","1");
INSERT INTO `llx_c_departements` VALUES("714","737","701",NULL,"0",NULL,"North Riding of Yorkshire","1");
INSERT INTO `llx_c_departements` VALUES("715","738","701",NULL,"0",NULL,"Northamptonshire","1");
INSERT INTO `llx_c_departements` VALUES("716","739","701",NULL,"0",NULL,"Northumberland","1");
INSERT INTO `llx_c_departements` VALUES("717","740","701",NULL,"0",NULL,"Nottinghamshire","1");
INSERT INTO `llx_c_departements` VALUES("718","741","701",NULL,"0",NULL,"Oxfordshire","1");
INSERT INTO `llx_c_departements` VALUES("719","742","701",NULL,"0",NULL,"Rutland","1");
INSERT INTO `llx_c_departements` VALUES("720","743","701",NULL,"0",NULL,"Shropshire","1");
INSERT INTO `llx_c_departements` VALUES("721","744","701",NULL,"0",NULL,"Somerset","1");
INSERT INTO `llx_c_departements` VALUES("722","745","701",NULL,"0",NULL,"Staffordshire","1");
INSERT INTO `llx_c_departements` VALUES("723","746","701",NULL,"0",NULL,"Suffolk","1");
INSERT INTO `llx_c_departements` VALUES("724","747","701",NULL,"0",NULL,"Surrey","1");
INSERT INTO `llx_c_departements` VALUES("725","748","701",NULL,"0",NULL,"Sussex","1");
INSERT INTO `llx_c_departements` VALUES("726","749","701",NULL,"0",NULL,"Tyne and Wear","1");
INSERT INTO `llx_c_departements` VALUES("727","750","701",NULL,"0",NULL,"Warwickshire","1");
INSERT INTO `llx_c_departements` VALUES("728","751","701",NULL,"0",NULL,"West Midlands","1");
INSERT INTO `llx_c_departements` VALUES("729","752","701",NULL,"0",NULL,"West Sussex","1");
INSERT INTO `llx_c_departements` VALUES("730","753","701",NULL,"0",NULL,"West Yorkshire","1");
INSERT INTO `llx_c_departements` VALUES("731","754","701",NULL,"0",NULL,"West Riding of Yorkshire","1");
INSERT INTO `llx_c_departements` VALUES("732","755","701",NULL,"0",NULL,"Wiltshire","1");
INSERT INTO `llx_c_departements` VALUES("733","756","701",NULL,"0",NULL,"Worcestershire","1");
INSERT INTO `llx_c_departements` VALUES("734","757","701",NULL,"0",NULL,"Yorkshire","1");
INSERT INTO `llx_c_departements` VALUES("735","758","702",NULL,"0",NULL,"Anglesey","1");
INSERT INTO `llx_c_departements` VALUES("736","759","702",NULL,"0",NULL,"Breconshire","1");
INSERT INTO `llx_c_departements` VALUES("737","760","702",NULL,"0",NULL,"Caernarvonshire","1");
INSERT INTO `llx_c_departements` VALUES("738","761","702",NULL,"0",NULL,"Cardiganshire","1");
INSERT INTO `llx_c_departements` VALUES("739","762","702",NULL,"0",NULL,"Carmarthenshire","1");
INSERT INTO `llx_c_departements` VALUES("740","763","702",NULL,"0",NULL,"Ceredigion","1");
INSERT INTO `llx_c_departements` VALUES("741","764","702",NULL,"0",NULL,"Denbighshire","1");
INSERT INTO `llx_c_departements` VALUES("742","765","702",NULL,"0",NULL,"Flintshire","1");
INSERT INTO `llx_c_departements` VALUES("743","766","702",NULL,"0",NULL,"Glamorgan","1");
INSERT INTO `llx_c_departements` VALUES("744","767","702",NULL,"0",NULL,"Gwent","1");
INSERT INTO `llx_c_departements` VALUES("745","768","702",NULL,"0",NULL,"Gwynedd","1");
INSERT INTO `llx_c_departements` VALUES("746","769","702",NULL,"0",NULL,"Merionethshire","1");
INSERT INTO `llx_c_departements` VALUES("747","770","702",NULL,"0",NULL,"Monmouthshire","1");
INSERT INTO `llx_c_departements` VALUES("748","771","702",NULL,"0",NULL,"Mid Glamorgan","1");
INSERT INTO `llx_c_departements` VALUES("749","772","702",NULL,"0",NULL,"Montgomeryshire","1");
INSERT INTO `llx_c_departements` VALUES("750","773","702",NULL,"0",NULL,"Pembrokeshire","1");
INSERT INTO `llx_c_departements` VALUES("751","774","702",NULL,"0",NULL,"Powys","1");
INSERT INTO `llx_c_departements` VALUES("752","775","702",NULL,"0",NULL,"Radnorshire","1");
INSERT INTO `llx_c_departements` VALUES("753","776","702",NULL,"0",NULL,"South Glamorgan","1");
INSERT INTO `llx_c_departements` VALUES("754","777","703",NULL,"0",NULL,"Aberdeen, City of","1");
INSERT INTO `llx_c_departements` VALUES("755","778","703",NULL,"0",NULL,"Angus","1");
INSERT INTO `llx_c_departements` VALUES("756","779","703",NULL,"0",NULL,"Argyll","1");
INSERT INTO `llx_c_departements` VALUES("757","780","703",NULL,"0",NULL,"Ayrshire","1");
INSERT INTO `llx_c_departements` VALUES("758","781","703",NULL,"0",NULL,"Banffshire","1");
INSERT INTO `llx_c_departements` VALUES("759","782","703",NULL,"0",NULL,"Berwickshire","1");
INSERT INTO `llx_c_departements` VALUES("760","783","703",NULL,"0",NULL,"Bute","1");
INSERT INTO `llx_c_departements` VALUES("761","784","703",NULL,"0",NULL,"Caithness","1");
INSERT INTO `llx_c_departements` VALUES("762","785","703",NULL,"0",NULL,"Clackmannanshire","1");
INSERT INTO `llx_c_departements` VALUES("763","786","703",NULL,"0",NULL,"Dumfriesshire","1");
INSERT INTO `llx_c_departements` VALUES("764","787","703",NULL,"0",NULL,"Dumbartonshire","1");
INSERT INTO `llx_c_departements` VALUES("765","788","703",NULL,"0",NULL,"Dundee, City of","1");
INSERT INTO `llx_c_departements` VALUES("766","789","703",NULL,"0",NULL,"East Lothian","1");
INSERT INTO `llx_c_departements` VALUES("767","790","703",NULL,"0",NULL,"Fife","1");
INSERT INTO `llx_c_departements` VALUES("768","791","703",NULL,"0",NULL,"Inverness","1");
INSERT INTO `llx_c_departements` VALUES("769","792","703",NULL,"0",NULL,"Kincardineshire","1");
INSERT INTO `llx_c_departements` VALUES("770","793","703",NULL,"0",NULL,"Kinross-shire","1");
INSERT INTO `llx_c_departements` VALUES("771","794","703",NULL,"0",NULL,"Kirkcudbrightshire","1");
INSERT INTO `llx_c_departements` VALUES("772","795","703",NULL,"0",NULL,"Lanarkshire","1");
INSERT INTO `llx_c_departements` VALUES("773","796","703",NULL,"0",NULL,"Midlothian","1");
INSERT INTO `llx_c_departements` VALUES("774","797","703",NULL,"0",NULL,"Morayshire","1");
INSERT INTO `llx_c_departements` VALUES("775","798","703",NULL,"0",NULL,"Nairnshire","1");
INSERT INTO `llx_c_departements` VALUES("776","799","703",NULL,"0",NULL,"Orkney","1");
INSERT INTO `llx_c_departements` VALUES("777","800","703",NULL,"0",NULL,"Peebleshire","1");
INSERT INTO `llx_c_departements` VALUES("778","801","703",NULL,"0",NULL,"Perthshire","1");
INSERT INTO `llx_c_departements` VALUES("779","802","703",NULL,"0",NULL,"Renfrewshire","1");
INSERT INTO `llx_c_departements` VALUES("780","803","703",NULL,"0",NULL,"Ross & Cromarty","1");
INSERT INTO `llx_c_departements` VALUES("781","804","703",NULL,"0",NULL,"Roxburghshire","1");
INSERT INTO `llx_c_departements` VALUES("782","805","703",NULL,"0",NULL,"Selkirkshire","1");
INSERT INTO `llx_c_departements` VALUES("783","806","703",NULL,"0",NULL,"Shetland","1");
INSERT INTO `llx_c_departements` VALUES("784","807","703",NULL,"0",NULL,"Stirlingshire","1");
INSERT INTO `llx_c_departements` VALUES("785","808","703",NULL,"0",NULL,"Sutherland","1");
INSERT INTO `llx_c_departements` VALUES("786","809","703",NULL,"0",NULL,"West Lothian","1");
INSERT INTO `llx_c_departements` VALUES("787","810","703",NULL,"0",NULL,"Wigtownshire","1");
INSERT INTO `llx_c_departements` VALUES("788","811","704",NULL,"0",NULL,"Antrim","1");
INSERT INTO `llx_c_departements` VALUES("789","812","704",NULL,"0",NULL,"Armagh","1");
INSERT INTO `llx_c_departements` VALUES("790","813","704",NULL,"0",NULL,"Co. Down","1");
INSERT INTO `llx_c_departements` VALUES("791","814","704",NULL,"0",NULL,"Co. Fermanagh","1");
INSERT INTO `llx_c_departements` VALUES("792","815","704",NULL,"0",NULL,"Co. Londonderry","1");
INSERT INTO `llx_c_departements` VALUES("793","AL","1101","","0","ALABAMA","Alabama","1");
INSERT INTO `llx_c_departements` VALUES("794","AK","1101","","0","ALASKA","Alaska","1");
INSERT INTO `llx_c_departements` VALUES("795","AZ","1101","","0","ARIZONA","Arizona","1");
INSERT INTO `llx_c_departements` VALUES("796","AR","1101","","0","ARKANSAS","Arkansas","1");
INSERT INTO `llx_c_departements` VALUES("797","CA","1101","","0","CALIFORNIA","California","1");
INSERT INTO `llx_c_departements` VALUES("798","CO","1101","","0","COLORADO","Colorado","1");
INSERT INTO `llx_c_departements` VALUES("799","CT","1101","","0","CONNECTICUT","Connecticut","1");
INSERT INTO `llx_c_departements` VALUES("800","DE","1101","","0","DELAWARE","Delaware","1");
INSERT INTO `llx_c_departements` VALUES("801","FL","1101","","0","FLORIDA","Florida","1");
INSERT INTO `llx_c_departements` VALUES("802","GA","1101","","0","GEORGIA","Georgia","1");
INSERT INTO `llx_c_departements` VALUES("803","HI","1101","","0","HAWAII","Hawaii","1");
INSERT INTO `llx_c_departements` VALUES("804","ID","1101","","0","IDAHO","Idaho","1");
INSERT INTO `llx_c_departements` VALUES("805","IL","1101","","0","ILLINOIS","Illinois","1");
INSERT INTO `llx_c_departements` VALUES("806","IN","1101","","0","INDIANA","Indiana","1");
INSERT INTO `llx_c_departements` VALUES("807","IA","1101","","0","IOWA","Iowa","1");
INSERT INTO `llx_c_departements` VALUES("808","KS","1101","","0","KANSAS","Kansas","1");
INSERT INTO `llx_c_departements` VALUES("809","KY","1101","","0","KENTUCKY","Kentucky","1");
INSERT INTO `llx_c_departements` VALUES("810","LA","1101","","0","LOUISIANA","Louisiana","1");
INSERT INTO `llx_c_departements` VALUES("811","ME","1101","","0","MAINE","Maine","1");
INSERT INTO `llx_c_departements` VALUES("812","MD","1101","","0","MARYLAND","Maryland","1");
INSERT INTO `llx_c_departements` VALUES("813","MA","1101","","0","MASSACHUSSETTS","Massachusetts","1");
INSERT INTO `llx_c_departements` VALUES("814","MI","1101","","0","MICHIGAN","Michigan","1");
INSERT INTO `llx_c_departements` VALUES("815","MN","1101","","0","MINNESOTA","Minnesota","1");
INSERT INTO `llx_c_departements` VALUES("816","MS","1101","","0","MISSISSIPPI","Mississippi","1");
INSERT INTO `llx_c_departements` VALUES("817","MO","1101","","0","MISSOURI","Missouri","1");
INSERT INTO `llx_c_departements` VALUES("818","MT","1101","","0","MONTANA","Montana","1");
INSERT INTO `llx_c_departements` VALUES("819","NE","1101","","0","NEBRASKA","Nebraska","1");
INSERT INTO `llx_c_departements` VALUES("820","NV","1101","","0","NEVADA","Nevada","1");
INSERT INTO `llx_c_departements` VALUES("821","NH","1101","","0","NEW HAMPSHIRE","New Hampshire","1");
INSERT INTO `llx_c_departements` VALUES("822","NJ","1101","","0","NEW JERSEY","New Jersey","1");
INSERT INTO `llx_c_departements` VALUES("823","NM","1101","","0","NEW MEXICO","New Mexico","1");
INSERT INTO `llx_c_departements` VALUES("824","NY","1101","","0","NEW YORK","New York","1");
INSERT INTO `llx_c_departements` VALUES("825","NC","1101","","0","NORTH CAROLINA","North Carolina","1");
INSERT INTO `llx_c_departements` VALUES("826","ND","1101","","0","NORTH DAKOTA","North Dakota","1");
INSERT INTO `llx_c_departements` VALUES("827","OH","1101","","0","OHIO","Ohio","1");
INSERT INTO `llx_c_departements` VALUES("828","OK","1101","","0","OKLAHOMA","Oklahoma","1");
INSERT INTO `llx_c_departements` VALUES("829","OR","1101","","0","OREGON","Oregon","1");
INSERT INTO `llx_c_departements` VALUES("830","PA","1101","","0","PENNSYLVANIA","Pennsylvania","1");
INSERT INTO `llx_c_departements` VALUES("831","RI","1101","","0","RHODE ISLAND","Rhode Island","1");
INSERT INTO `llx_c_departements` VALUES("832","SC","1101","","0","SOUTH CAROLINA","South Carolina","1");
INSERT INTO `llx_c_departements` VALUES("833","SD","1101","","0","SOUTH DAKOTA","South Dakota","1");
INSERT INTO `llx_c_departements` VALUES("834","TN","1101","","0","TENNESSEE","Tennessee","1");
INSERT INTO `llx_c_departements` VALUES("835","TX","1101","","0","TEXAS","Texas","1");
INSERT INTO `llx_c_departements` VALUES("836","UT","1101","","0","UTAH","Utah","1");
INSERT INTO `llx_c_departements` VALUES("837","VT","1101","","0","VERMONT","Vermont","1");
INSERT INTO `llx_c_departements` VALUES("838","VA","1101","","0","VIRGINIA","Virginia","1");
INSERT INTO `llx_c_departements` VALUES("839","WA","1101","","0","WASHINGTON","Washington","1");
INSERT INTO `llx_c_departements` VALUES("840","WV","1101","","0","WEST VIRGINIA","West Virginia","1");
INSERT INTO `llx_c_departements` VALUES("841","WI","1101","","0","WISCONSIN","Wisconsin","1");
INSERT INTO `llx_c_departements` VALUES("842","WY","1101","","0","WYOMING","Wyoming","1");
INSERT INTO `llx_c_departements` VALUES("843","GR","1701",NULL,NULL,NULL,"Groningen","1");
INSERT INTO `llx_c_departements` VALUES("844","FR","1701",NULL,NULL,NULL,"Friesland","1");
INSERT INTO `llx_c_departements` VALUES("845","DR","1701",NULL,NULL,NULL,"Drenthe","1");
INSERT INTO `llx_c_departements` VALUES("846","OV","1701",NULL,NULL,NULL,"Overijssel","1");
INSERT INTO `llx_c_departements` VALUES("847","GD","1701",NULL,NULL,NULL,"Gelderland","1");
INSERT INTO `llx_c_departements` VALUES("848","FL","1701",NULL,NULL,NULL,"Flevoland","1");
INSERT INTO `llx_c_departements` VALUES("849","UT","1701",NULL,NULL,NULL,"Utrecht","1");
INSERT INTO `llx_c_departements` VALUES("850","NH","1701",NULL,NULL,NULL,"Noord-Holland","1");
INSERT INTO `llx_c_departements` VALUES("851","ZH","1701",NULL,NULL,NULL,"Zuid-Holland","1");
INSERT INTO `llx_c_departements` VALUES("852","ZL","1701",NULL,NULL,NULL,"Zeeland","1");
INSERT INTO `llx_c_departements` VALUES("853","NB","1701",NULL,NULL,NULL,"Noord-Brabant","1");
INSERT INTO `llx_c_departements` VALUES("854","LB","1701",NULL,NULL,NULL,"Limburg","1");
INSERT INTO `llx_c_departements` VALUES("855","SS","8601","","0","","San Salvador","1");
INSERT INTO `llx_c_departements` VALUES("856","SA","8603","","0","","Santa Ana","1");
INSERT INTO `llx_c_departements` VALUES("857","AH","8603","","0","","Ahuachapan","1");
INSERT INTO `llx_c_departements` VALUES("858","SO","8603","","0","","Sonsonate","1");
INSERT INTO `llx_c_departements` VALUES("859","US","8602","","0","","Usulutan","1");
INSERT INTO `llx_c_departements` VALUES("860","SM","8602","","0","","San Miguel","1");
INSERT INTO `llx_c_departements` VALUES("861","MO","8602","","0","","Morazan","1");
INSERT INTO `llx_c_departements` VALUES("862","LU","8602","","0","","La Union","1");
INSERT INTO `llx_c_departements` VALUES("863","LL","8601","","0","","La Libertad","1");
INSERT INTO `llx_c_departements` VALUES("864","CH","8601","","0","","Chalatenango","1");
INSERT INTO `llx_c_departements` VALUES("865","CA","8601","","0","","Cabañas","1");
INSERT INTO `llx_c_departements` VALUES("866","LP","8601","","0","","La Paz","1");
INSERT INTO `llx_c_departements` VALUES("867","SV","8601","","0","","San Vicente","1");
INSERT INTO `llx_c_departements` VALUES("868","CU","8601","","0","","Cuscatlan","1");
INSERT INTO `llx_c_departements` VALUES("869","2301","2301","","0","CATAMARCA","Catamarca","1");
INSERT INTO `llx_c_departements` VALUES("870","2302","2301","","0","JUJUY","Jujuy","1");
INSERT INTO `llx_c_departements` VALUES("871","2303","2301","","0","TUCAMAN","Tucamán","1");
INSERT INTO `llx_c_departements` VALUES("872","2304","2301","","0","SANTIAGO DEL ESTERO","Santiago del Estero","1");
INSERT INTO `llx_c_departements` VALUES("873","2305","2301","","0","SALTA","Salta","1");
INSERT INTO `llx_c_departements` VALUES("874","2306","2302","","0","CHACO","Chaco","1");
INSERT INTO `llx_c_departements` VALUES("875","2307","2302","","0","CORRIENTES","Corrientes","1");
INSERT INTO `llx_c_departements` VALUES("876","2308","2302","","0","ENTRE RIOS","Entre Ríos","1");
INSERT INTO `llx_c_departements` VALUES("877","2309","2302","","0","FORMOSA","Formosa","1");
INSERT INTO `llx_c_departements` VALUES("878","2310","2302","","0","SANTA FE","Santa Fe","1");
INSERT INTO `llx_c_departements` VALUES("879","2311","2303","","0","LA RIOJA","La Rioja","1");
INSERT INTO `llx_c_departements` VALUES("880","2312","2303","","0","MENDOZA","Mendoza","1");
INSERT INTO `llx_c_departements` VALUES("881","2313","2303","","0","SAN JUAN","San Juan","1");
INSERT INTO `llx_c_departements` VALUES("882","2314","2303","","0","SAN LUIS","San Luis","1");
INSERT INTO `llx_c_departements` VALUES("883","2315","2304","","0","CORDOBA","Córdoba","1");
INSERT INTO `llx_c_departements` VALUES("884","2316","2304","","0","BUENOS AIRES","Buenos Aires","1");
INSERT INTO `llx_c_departements` VALUES("885","2317","2304","","0","CABA","Caba","1");
INSERT INTO `llx_c_departements` VALUES("886","2318","2305","","0","LA PAMPA","La Pampa","1");
INSERT INTO `llx_c_departements` VALUES("887","2319","2305","","0","NEUQUEN","Neuquén","1");
INSERT INTO `llx_c_departements` VALUES("888","2320","2305","","0","RIO NEGRO","Río Negro","1");
INSERT INTO `llx_c_departements` VALUES("889","2321","2305","","0","CHUBUT","Chubut","1");
INSERT INTO `llx_c_departements` VALUES("890","2322","2305","","0","SANTA CRUZ","Santa Cruz","1");
INSERT INTO `llx_c_departements` VALUES("891","2323","2305","","0","TIERRA DEL FUEGO","Tierra del Fuego","1");
INSERT INTO `llx_c_departements` VALUES("892","2324","2305","","0","ISLAS MALVINAS","Islas Malvinas","1");
INSERT INTO `llx_c_departements` VALUES("893","2325","2305","","0","ANTARTIDA","Antártida","1");
INSERT INTO `llx_c_departements` VALUES("894","2326","2305","","0","MISIONES","Misiones","1");
INSERT INTO `llx_c_departements` VALUES("895","CC","4601","Oistins","0","CC","Christ Church","1");
INSERT INTO `llx_c_departements` VALUES("896","SA","4601","Greenland","0","SA","Saint Andrew","1");
INSERT INTO `llx_c_departements` VALUES("897","SG","4601","Bulkeley","0","SG","Saint George","1");
INSERT INTO `llx_c_departements` VALUES("898","JA","4601","Holetown","0","JA","Saint James","1");
INSERT INTO `llx_c_departements` VALUES("899","SJ","4601","Four Roads","0","SJ","Saint John","1");
INSERT INTO `llx_c_departements` VALUES("900","SB","4601","Bathsheba","0","SB","Saint Joseph","1");
INSERT INTO `llx_c_departements` VALUES("901","SL","4601","Crab Hill","0","SL","Saint Lucy","1");
INSERT INTO `llx_c_departements` VALUES("902","SM","4601","Bridgetown","0","SM","Saint Michael","1");
INSERT INTO `llx_c_departements` VALUES("903","SP","4601","Speightstown","0","SP","Saint Peter","1");
INSERT INTO `llx_c_departements` VALUES("904","SC","4601","Crane","0","SC","Saint Philip","1");
INSERT INTO `llx_c_departements` VALUES("905","ST","4601","Hillaby","0","ST","Saint Thomas","1");
INSERT INTO `llx_c_departements` VALUES("906","AC","5601","ACRE","0","AC","Acre","1");
INSERT INTO `llx_c_departements` VALUES("907","AL","5601","ALAGOAS","0","AL","Alagoas","1");
INSERT INTO `llx_c_departements` VALUES("908","AP","5601","AMAPA","0","AP","Amapá","1");
INSERT INTO `llx_c_departements` VALUES("909","AM","5601","AMAZONAS","0","AM","Amazonas","1");
INSERT INTO `llx_c_departements` VALUES("910","BA","5601","BAHIA","0","BA","Bahia","1");
INSERT INTO `llx_c_departements` VALUES("911","CE","5601","CEARA","0","CE","Ceará","1");
INSERT INTO `llx_c_departements` VALUES("912","ES","5601","ESPIRITO SANTO","0","ES","Espirito Santo","1");
INSERT INTO `llx_c_departements` VALUES("913","GO","5601","GOIAS","0","GO","Goiás","1");
INSERT INTO `llx_c_departements` VALUES("914","MA","5601","MARANHAO","0","MA","Maranhão","1");
INSERT INTO `llx_c_departements` VALUES("915","MT","5601","MATO GROSSO","0","MT","Mato Grosso","1");
INSERT INTO `llx_c_departements` VALUES("916","MS","5601","MATO GROSSO DO SUL","0","MS","Mato Grosso do Sul","1");
INSERT INTO `llx_c_departements` VALUES("917","MG","5601","MINAS GERAIS","0","MG","Minas Gerais","1");
INSERT INTO `llx_c_departements` VALUES("918","PA","5601","PARA","0","PA","Pará","1");
INSERT INTO `llx_c_departements` VALUES("919","PB","5601","PARAIBA","0","PB","Paraiba","1");
INSERT INTO `llx_c_departements` VALUES("920","PR","5601","PARANA","0","PR","Paraná","1");
INSERT INTO `llx_c_departements` VALUES("921","PE","5601","PERNAMBUCO","0","PE","Pernambuco","1");
INSERT INTO `llx_c_departements` VALUES("922","PI","5601","PIAUI","0","PI","Piauí","1");
INSERT INTO `llx_c_departements` VALUES("923","RJ","5601","RIO DE JANEIRO","0","RJ","Rio de Janeiro","1");
INSERT INTO `llx_c_departements` VALUES("924","RN","5601","RIO GRANDE DO NORTE","0","RN","Rio Grande do Norte","1");
INSERT INTO `llx_c_departements` VALUES("925","RS","5601","RIO GRANDE DO SUL","0","RS","Rio Grande do Sul","1");
INSERT INTO `llx_c_departements` VALUES("926","RO","5601","RONDONIA","0","RO","Rondônia","1");
INSERT INTO `llx_c_departements` VALUES("927","RR","5601","RORAIMA","0","RR","Roraima","1");
INSERT INTO `llx_c_departements` VALUES("928","SC","5601","SANTA CATARINA","0","SC","Santa Catarina","1");
INSERT INTO `llx_c_departements` VALUES("929","SE","5601","SERGIPE","0","SE","Sergipe","1");
INSERT INTO `llx_c_departements` VALUES("930","SP","5601","SAO PAULO","0","SP","Sao Paulo","1");
INSERT INTO `llx_c_departements` VALUES("931","TO","5601","TOCANTINS","0","TO","Tocantins","1");
INSERT INTO `llx_c_departements` VALUES("932","DF","5601","DISTRITO FEDERAL","0","DF","Distrito Federal","1");
INSERT INTO `llx_c_departements` VALUES("933","151","6715","","0","151","Arica","1");
INSERT INTO `llx_c_departements` VALUES("934","152","6715","","0","152","Parinacota","1");
INSERT INTO `llx_c_departements` VALUES("935","011","6701","","0","011","Iquique","1");
INSERT INTO `llx_c_departements` VALUES("936","014","6701","","0","014","Tamarugal","1");
INSERT INTO `llx_c_departements` VALUES("937","021","6702","","0","021","Antofagasa","1");
INSERT INTO `llx_c_departements` VALUES("938","022","6702","","0","022","El Loa","1");
INSERT INTO `llx_c_departements` VALUES("939","023","6702","","0","023","Tocopilla","1");
INSERT INTO `llx_c_departements` VALUES("940","031","6703","","0","031","Copiapó","1");
INSERT INTO `llx_c_departements` VALUES("941","032","6703","","0","032","Chañaral","1");
INSERT INTO `llx_c_departements` VALUES("942","033","6703","","0","033","Huasco","1");
INSERT INTO `llx_c_departements` VALUES("943","041","6704","","0","041","Elqui","1");
INSERT INTO `llx_c_departements` VALUES("944","042","6704","","0","042","Choapa","1");
INSERT INTO `llx_c_departements` VALUES("945","043","6704","","0","043","Limarí","1");
INSERT INTO `llx_c_departements` VALUES("946","051","6705","","0","051","Valparaíso","1");
INSERT INTO `llx_c_departements` VALUES("947","052","6705","","0","052","Isla de Pascua","1");
INSERT INTO `llx_c_departements` VALUES("948","053","6705","","0","053","Los Andes","1");
INSERT INTO `llx_c_departements` VALUES("949","054","6705","","0","054","Petorca","1");
INSERT INTO `llx_c_departements` VALUES("950","055","6705","","0","055","Quillota","1");
INSERT INTO `llx_c_departements` VALUES("951","056","6705","","0","056","San Antonio","1");
INSERT INTO `llx_c_departements` VALUES("952","057","6705","","0","057","San Felipe de Aconcagua","1");
INSERT INTO `llx_c_departements` VALUES("953","058","6705","","0","058","Marga Marga","1");
INSERT INTO `llx_c_departements` VALUES("954","061","6706","","0","061","Cachapoal","1");
INSERT INTO `llx_c_departements` VALUES("955","062","6706","","0","062","Cardenal Caro","1");
INSERT INTO `llx_c_departements` VALUES("956","063","6706","","0","063","Colchagua","1");
INSERT INTO `llx_c_departements` VALUES("957","071","6707","","0","071","Talca","1");
INSERT INTO `llx_c_departements` VALUES("958","072","6707","","0","072","Cauquenes","1");
INSERT INTO `llx_c_departements` VALUES("959","073","6707","","0","073","Curicó","1");
INSERT INTO `llx_c_departements` VALUES("960","074","6707","","0","074","Linares","1");
INSERT INTO `llx_c_departements` VALUES("961","081","6708","","0","081","Concepción","1");
INSERT INTO `llx_c_departements` VALUES("962","082","6708","","0","082","Arauco","1");
INSERT INTO `llx_c_departements` VALUES("963","083","6708","","0","083","Biobío","1");
INSERT INTO `llx_c_departements` VALUES("964","084","6708","","0","084","Ñuble","1");
INSERT INTO `llx_c_departements` VALUES("965","091","6709","","0","091","Cautín","1");
INSERT INTO `llx_c_departements` VALUES("966","092","6709","","0","092","Malleco","1");
INSERT INTO `llx_c_departements` VALUES("967","141","6714","","0","141","Valdivia","1");
INSERT INTO `llx_c_departements` VALUES("968","142","6714","","0","142","Ranco","1");
INSERT INTO `llx_c_departements` VALUES("969","101","6710","","0","101","Llanquihue","1");
INSERT INTO `llx_c_departements` VALUES("970","102","6710","","0","102","Chiloé","1");
INSERT INTO `llx_c_departements` VALUES("971","103","6710","","0","103","Osorno","1");
INSERT INTO `llx_c_departements` VALUES("972","104","6710","","0","104","Palena","1");
INSERT INTO `llx_c_departements` VALUES("973","111","6711","","0","111","Coihaique","1");
INSERT INTO `llx_c_departements` VALUES("974","112","6711","","0","112","Aisén","1");
INSERT INTO `llx_c_departements` VALUES("975","113","6711","","0","113","Capitán Prat","1");
INSERT INTO `llx_c_departements` VALUES("976","114","6711","","0","114","General Carrera","1");
INSERT INTO `llx_c_departements` VALUES("977","121","6712","","0","121","Magallanes","1");
INSERT INTO `llx_c_departements` VALUES("978","122","6712","","0","122","Antártica Chilena","1");
INSERT INTO `llx_c_departements` VALUES("979","123","6712","","0","123","Tierra del Fuego","1");
INSERT INTO `llx_c_departements` VALUES("980","124","6712","","0","124","Última Esperanza","1");
INSERT INTO `llx_c_departements` VALUES("981","131","6713","","0","131","Santiago","1");
INSERT INTO `llx_c_departements` VALUES("982","132","6713","","0","132","Cordillera","1");
INSERT INTO `llx_c_departements` VALUES("983","133","6713","","0","133","Chacabuco","1");
INSERT INTO `llx_c_departements` VALUES("984","134","6713","","0","134","Maipo","1");
INSERT INTO `llx_c_departements` VALUES("985","135","6713","","0","135","Melipilla","1");
INSERT INTO `llx_c_departements` VALUES("986","136","6713","","0","136","Talagante","1");
INSERT INTO `llx_c_departements` VALUES("987","AN","11701",NULL,"0","AN","Andaman & Nicobar","1");
INSERT INTO `llx_c_departements` VALUES("988","AP","11701",NULL,"0","AP","Andhra Pradesh","1");
INSERT INTO `llx_c_departements` VALUES("989","AR","11701",NULL,"0","AR","Arunachal Pradesh","1");
INSERT INTO `llx_c_departements` VALUES("990","AS","11701",NULL,"0","AS","Assam","1");
INSERT INTO `llx_c_departements` VALUES("991","BR","11701",NULL,"0","BR","Bihar","1");
INSERT INTO `llx_c_departements` VALUES("992","CG","11701",NULL,"0","CG","Chattisgarh","1");
INSERT INTO `llx_c_departements` VALUES("993","CH","11701",NULL,"0","CH","Chandigarh","1");
INSERT INTO `llx_c_departements` VALUES("994","DD","11701",NULL,"0","DD","Daman & Diu","1");
INSERT INTO `llx_c_departements` VALUES("995","DL","11701",NULL,"0","DL","Delhi","1");
INSERT INTO `llx_c_departements` VALUES("996","DN","11701",NULL,"0","DN","Dadra and Nagar Haveli","1");
INSERT INTO `llx_c_departements` VALUES("997","GA","11701",NULL,"0","GA","Goa","1");
INSERT INTO `llx_c_departements` VALUES("998","GJ","11701",NULL,"0","GJ","Gujarat","1");
INSERT INTO `llx_c_departements` VALUES("999","HP","11701",NULL,"0","HP","Himachal Pradesh","1");
INSERT INTO `llx_c_departements` VALUES("1000","HR","11701",NULL,"0","HR","Haryana","1");
INSERT INTO `llx_c_departements` VALUES("1001","JH","11701",NULL,"0","JH","Jharkhand","1");
INSERT INTO `llx_c_departements` VALUES("1002","JK","11701",NULL,"0","JK","Jammu & Kashmir","1");
INSERT INTO `llx_c_departements` VALUES("1003","KA","11701",NULL,"0","KA","Karnataka","1");
INSERT INTO `llx_c_departements` VALUES("1004","KL","11701",NULL,"0","KL","Kerala","1");
INSERT INTO `llx_c_departements` VALUES("1005","LD","11701",NULL,"0","LD","Lakshadweep","1");
INSERT INTO `llx_c_departements` VALUES("1006","MH","11701",NULL,"0","MH","Maharashtra","1");
INSERT INTO `llx_c_departements` VALUES("1007","ML","11701",NULL,"0","ML","Meghalaya","1");
INSERT INTO `llx_c_departements` VALUES("1008","MN","11701",NULL,"0","MN","Manipur","1");
INSERT INTO `llx_c_departements` VALUES("1009","MP","11701",NULL,"0","MP","Madhya Pradesh","1");
INSERT INTO `llx_c_departements` VALUES("1010","MZ","11701",NULL,"0","MZ","Mizoram","1");
INSERT INTO `llx_c_departements` VALUES("1011","NL","11701",NULL,"0","NL","Nagaland","1");
INSERT INTO `llx_c_departements` VALUES("1012","OR","11701",NULL,"0","OR","Orissa","1");
INSERT INTO `llx_c_departements` VALUES("1013","PB","11701",NULL,"0","PB","Punjab","1");
INSERT INTO `llx_c_departements` VALUES("1014","PY","11701",NULL,"0","PY","Puducherry","1");
INSERT INTO `llx_c_departements` VALUES("1015","RJ","11701",NULL,"0","RJ","Rajasthan","1");
INSERT INTO `llx_c_departements` VALUES("1016","SK","11701",NULL,"0","SK","Sikkim","1");
INSERT INTO `llx_c_departements` VALUES("1017","TN","11701",NULL,"0","TN","Tamil Nadu","1");
INSERT INTO `llx_c_departements` VALUES("1018","TR","11701",NULL,"0","TR","Tripura","1");
INSERT INTO `llx_c_departements` VALUES("1019","UL","11701",NULL,"0","UL","Uttarakhand","1");
INSERT INTO `llx_c_departements` VALUES("1020","UP","11701",NULL,"0","UP","Uttar Pradesh","1");
INSERT INTO `llx_c_departements` VALUES("1021","WB","11701",NULL,"0","WB","West Bengal","1");
INSERT INTO `llx_c_departements` VALUES("1022","BA","11801",NULL,"0","BA","Bali","1");
INSERT INTO `llx_c_departements` VALUES("1023","BB","11801",NULL,"0","BB","Bangka Belitung","1");
INSERT INTO `llx_c_departements` VALUES("1024","BT","11801",NULL,"0","BT","Banten","1");
INSERT INTO `llx_c_departements` VALUES("1025","BE","11801",NULL,"0","BA","Bengkulu","1");
INSERT INTO `llx_c_departements` VALUES("1026","YO","11801",NULL,"0","YO","DI Yogyakarta","1");
INSERT INTO `llx_c_departements` VALUES("1027","JK","11801",NULL,"0","JK","DKI Jakarta","1");
INSERT INTO `llx_c_departements` VALUES("1028","GO","11801",NULL,"0","GO","Gorontalo","1");
INSERT INTO `llx_c_departements` VALUES("1029","JA","11801",NULL,"0","JA","Jambi","1");
INSERT INTO `llx_c_departements` VALUES("1030","JB","11801",NULL,"0","JB","Jawa Barat","1");
INSERT INTO `llx_c_departements` VALUES("1031","JT","11801",NULL,"0","JT","Jawa Tengah","1");
INSERT INTO `llx_c_departements` VALUES("1032","JI","11801",NULL,"0","JI","Jawa Timur","1");
INSERT INTO `llx_c_departements` VALUES("1033","KB","11801",NULL,"0","KB","Kalimantan Barat","1");
INSERT INTO `llx_c_departements` VALUES("1034","KS","11801",NULL,"0","KS","Kalimantan Selatan","1");
INSERT INTO `llx_c_departements` VALUES("1035","KT","11801",NULL,"0","KT","Kalimantan Tengah","1");
INSERT INTO `llx_c_departements` VALUES("1036","KI","11801",NULL,"0","KI","Kalimantan Timur","1");
INSERT INTO `llx_c_departements` VALUES("1037","KU","11801",NULL,"0","KU","Kalimantan Utara","1");
INSERT INTO `llx_c_departements` VALUES("1038","KR","11801",NULL,"0","KR","Kepulauan Riau","1");
INSERT INTO `llx_c_departements` VALUES("1039","LA","11801",NULL,"0","LA","Lampung","1");
INSERT INTO `llx_c_departements` VALUES("1040","MA","11801",NULL,"0","MA","Maluku","1");
INSERT INTO `llx_c_departements` VALUES("1041","MU","11801",NULL,"0","MU","Maluku Utara","1");
INSERT INTO `llx_c_departements` VALUES("1042","AC","11801",NULL,"0","AC","Nanggroe Aceh Darussalam","1");
INSERT INTO `llx_c_departements` VALUES("1043","NB","11801",NULL,"0","NB","Nusa Tenggara Barat","1");
INSERT INTO `llx_c_departements` VALUES("1044","NT","11801",NULL,"0","NT","Nusa Tenggara Timur","1");
INSERT INTO `llx_c_departements` VALUES("1045","PA","11801",NULL,"0","PA","Papua","1");
INSERT INTO `llx_c_departements` VALUES("1046","PB","11801",NULL,"0","PB","Papua Barat","1");
INSERT INTO `llx_c_departements` VALUES("1047","RI","11801",NULL,"0","RI","Riau","1");
INSERT INTO `llx_c_departements` VALUES("1048","SR","11801",NULL,"0","SR","Sulawesi Barat","1");
INSERT INTO `llx_c_departements` VALUES("1049","SN","11801",NULL,"0","SN","Sulawesi Selatan","1");
INSERT INTO `llx_c_departements` VALUES("1050","ST","11801",NULL,"0","ST","Sulawesi Tengah","1");
INSERT INTO `llx_c_departements` VALUES("1051","SG","11801",NULL,"0","SG","Sulawesi Tenggara","1");
INSERT INTO `llx_c_departements` VALUES("1052","SA","11801",NULL,"0","SA","Sulawesi Utara","1");
INSERT INTO `llx_c_departements` VALUES("1053","SB","11801",NULL,"0","SB","Sumatera Barat","1");
INSERT INTO `llx_c_departements` VALUES("1054","SS","11801",NULL,"0","SS","Sumatera Selatan","1");
INSERT INTO `llx_c_departements` VALUES("1055","SU","11801",NULL,"0","SU","Sumatera Utara	","1");
INSERT INTO `llx_c_departements` VALUES("1056","DIF","15401","","0","DIF","Distrito Federal","1");
INSERT INTO `llx_c_departements` VALUES("1057","AGS","15401","","0","AGS","Aguascalientes","1");
INSERT INTO `llx_c_departements` VALUES("1058","BCN","15401","","0","BCN","Baja California Norte","1");
INSERT INTO `llx_c_departements` VALUES("1059","BCS","15401","","0","BCS","Baja California Sur","1");
INSERT INTO `llx_c_departements` VALUES("1060","CAM","15401","","0","CAM","Campeche","1");
INSERT INTO `llx_c_departements` VALUES("1061","CHP","15401","","0","CHP","Chiapas","1");
INSERT INTO `llx_c_departements` VALUES("1062","CHI","15401","","0","CHI","Chihuahua","1");
INSERT INTO `llx_c_departements` VALUES("1063","COA","15401","","0","COA","Coahuila","1");
INSERT INTO `llx_c_departements` VALUES("1064","COL","15401","","0","COL","Colima","1");
INSERT INTO `llx_c_departements` VALUES("1065","DUR","15401","","0","DUR","Durango","1");
INSERT INTO `llx_c_departements` VALUES("1066","GTO","15401","","0","GTO","Guanajuato","1");
INSERT INTO `llx_c_departements` VALUES("1067","GRO","15401","","0","GRO","Guerrero","1");
INSERT INTO `llx_c_departements` VALUES("1068","HGO","15401","","0","HGO","Hidalgo","1");
INSERT INTO `llx_c_departements` VALUES("1069","JAL","15401","","0","JAL","Jalisco","1");
INSERT INTO `llx_c_departements` VALUES("1070","MEX","15401","","0","MEX","México","1");
INSERT INTO `llx_c_departements` VALUES("1071","MIC","15401","","0","MIC","Michoacán de Ocampo","1");
INSERT INTO `llx_c_departements` VALUES("1072","MOR","15401","","0","MOR","Morelos","1");
INSERT INTO `llx_c_departements` VALUES("1073","NAY","15401","","0","NAY","Nayarit","1");
INSERT INTO `llx_c_departements` VALUES("1074","NLE","15401","","0","NLE","Nuevo León","1");
INSERT INTO `llx_c_departements` VALUES("1075","OAX","15401","","0","OAX","Oaxaca","1");
INSERT INTO `llx_c_departements` VALUES("1076","PUE","15401","","0","PUE","Puebla","1");
INSERT INTO `llx_c_departements` VALUES("1077","QRO","15401","","0","QRO","Querétaro","1");
INSERT INTO `llx_c_departements` VALUES("1078","ROO","15401","","0","ROO","Quintana Roo","1");
INSERT INTO `llx_c_departements` VALUES("1079","SLP","15401","","0","SLP","San Luis Potosí","1");
INSERT INTO `llx_c_departements` VALUES("1080","SIN","15401","","0","SIN","Sinaloa","1");
INSERT INTO `llx_c_departements` VALUES("1081","SON","15401","","0","SON","Sonora","1");
INSERT INTO `llx_c_departements` VALUES("1082","TAB","15401","","0","TAB","Tabasco","1");
INSERT INTO `llx_c_departements` VALUES("1083","TAM","15401","","0","TAM","Tamaulipas","1");
INSERT INTO `llx_c_departements` VALUES("1084","TLX","15401","","0","TLX","Tlaxcala","1");
INSERT INTO `llx_c_departements` VALUES("1085","VER","15401","","0","VER","Veracruz","1");
INSERT INTO `llx_c_departements` VALUES("1086","YUC","15401","","0","YUC","Yucatán","1");
INSERT INTO `llx_c_departements` VALUES("1087","ZAC","15401","","0","ZAC","Zacatecas","1");
INSERT INTO `llx_c_departements` VALUES("1088","ANT","7001","","0","ANT","Antioquia","1");
INSERT INTO `llx_c_departements` VALUES("1089","BOL","7001","","0","BOL","Bolívar","1");
INSERT INTO `llx_c_departements` VALUES("1090","BOY","7001","","0","BOY","Boyacá","1");
INSERT INTO `llx_c_departements` VALUES("1091","CAL","7001","","0","CAL","Caldas","1");
INSERT INTO `llx_c_departements` VALUES("1092","CAU","7001","","0","CAU","Cauca","1");
INSERT INTO `llx_c_departements` VALUES("1093","CUN","7001","","0","CUN","Cundinamarca","1");
INSERT INTO `llx_c_departements` VALUES("1094","HUI","7001","","0","HUI","Huila","1");
INSERT INTO `llx_c_departements` VALUES("1095","LAG","7001","","0","LAG","La Guajira","1");
INSERT INTO `llx_c_departements` VALUES("1096","MET","7001","","0","MET","Meta","1");
INSERT INTO `llx_c_departements` VALUES("1097","NAR","7001","","0","NAR","Nariño","1");
INSERT INTO `llx_c_departements` VALUES("1098","NDS","7001","","0","NDS","Norte de Santander","1");
INSERT INTO `llx_c_departements` VALUES("1099","SAN","7001","","0","SAN","Santander","1");
INSERT INTO `llx_c_departements` VALUES("1100","SUC","7001","","0","SUC","Sucre","1");
INSERT INTO `llx_c_departements` VALUES("1101","TOL","7001","","0","TOL","Tolima","1");
INSERT INTO `llx_c_departements` VALUES("1102","VAC","7001","","0","VAC","Valle del Cauca","1");
INSERT INTO `llx_c_departements` VALUES("1103","RIS","7001","","0","RIS","Risalda","1");
INSERT INTO `llx_c_departements` VALUES("1104","ATL","7001","","0","ATL","Atlántico","1");
INSERT INTO `llx_c_departements` VALUES("1105","COR","7001","","0","COR","Córdoba","1");
INSERT INTO `llx_c_departements` VALUES("1106","SAP","7001","","0","SAP","San Andrés, Providencia y Santa Catalina","1");
INSERT INTO `llx_c_departements` VALUES("1107","ARA","7001","","0","ARA","Arauca","1");
INSERT INTO `llx_c_departements` VALUES("1108","CAS","7001","","0","CAS","Casanare","1");
INSERT INTO `llx_c_departements` VALUES("1109","AMA","7001","","0","AMA","Amazonas","1");
INSERT INTO `llx_c_departements` VALUES("1110","CAQ","7001","","0","CAQ","Caquetá","1");
INSERT INTO `llx_c_departements` VALUES("1111","CHO","7001","","0","CHO","Chocó","1");
INSERT INTO `llx_c_departements` VALUES("1112","GUA","7001","","0","GUA","Guainía","1");
INSERT INTO `llx_c_departements` VALUES("1113","GUV","7001","","0","GUV","Guaviare","1");
INSERT INTO `llx_c_departements` VALUES("1114","PUT","7001","","0","PUT","Putumayo","1");
INSERT INTO `llx_c_departements` VALUES("1115","QUI","7001","","0","QUI","Quindío","1");
INSERT INTO `llx_c_departements` VALUES("1116","VAU","7001","","0","VAU","Vaupés","1");
INSERT INTO `llx_c_departements` VALUES("1117","BOG","7001","","0","BOG","Bogotá","1");
INSERT INTO `llx_c_departements` VALUES("1118","VID","7001","","0","VID","Vichada","1");
INSERT INTO `llx_c_departements` VALUES("1119","CES","7001","","0","CES","Cesar","1");
INSERT INTO `llx_c_departements` VALUES("1120","MAG","7001","","0","MAG","Magdalena","1");
INSERT INTO `llx_c_departements` VALUES("1121","AT","11401","","0","AT","Atlántida","1");
INSERT INTO `llx_c_departements` VALUES("1122","CH","11401","","0","CH","Choluteca","1");
INSERT INTO `llx_c_departements` VALUES("1123","CL","11401","","0","CL","Colón","1");
INSERT INTO `llx_c_departements` VALUES("1124","CM","11401","","0","CM","Comayagua","1");
INSERT INTO `llx_c_departements` VALUES("1125","CO","11401","","0","CO","Copán","1");
INSERT INTO `llx_c_departements` VALUES("1126","CR","11401","","0","CR","Cortés","1");
INSERT INTO `llx_c_departements` VALUES("1127","EP","11401","","0","EP","El Paraíso","1");
INSERT INTO `llx_c_departements` VALUES("1128","FM","11401","","0","FM","Francisco Morazán","1");
INSERT INTO `llx_c_departements` VALUES("1129","GD","11401","","0","GD","Gracias a Dios","1");
INSERT INTO `llx_c_departements` VALUES("1130","IN","11401","","0","IN","Intibucá","1");
INSERT INTO `llx_c_departements` VALUES("1131","IB","11401","","0","IB","Islas de la Bahía","1");
INSERT INTO `llx_c_departements` VALUES("1132","LP","11401","","0","LP","La Paz","1");
INSERT INTO `llx_c_departements` VALUES("1133","LM","11401","","0","LM","Lempira","1");
INSERT INTO `llx_c_departements` VALUES("1134","OC","11401","","0","OC","Ocotepeque","1");
INSERT INTO `llx_c_departements` VALUES("1135","OL","11401","","0","OL","Olancho","1");
INSERT INTO `llx_c_departements` VALUES("1136","SB","11401","","0","SB","Santa Bárbara","1");
INSERT INTO `llx_c_departements` VALUES("1137","VL","11401","","0","VL","Valle","1");
INSERT INTO `llx_c_departements` VALUES("1138","YO","11401","","0","YO","Yoro","1");
INSERT INTO `llx_c_departements` VALUES("1139","DC","11401","","0","DC","Distrito Central","1");
INSERT INTO `llx_c_departements` VALUES("1140","AB","18801","","0","","Alba","1");
INSERT INTO `llx_c_departements` VALUES("1141","AR","18801","","0","","Arad","1");
INSERT INTO `llx_c_departements` VALUES("1142","AG","18801","","0","","Arge?","1");
INSERT INTO `llx_c_departements` VALUES("1143","BC","18801","","0","","Bac?u","1");
INSERT INTO `llx_c_departements` VALUES("1144","BH","18801","","0","","Bihor","1");
INSERT INTO `llx_c_departements` VALUES("1145","BN","18801","","0","","Bistri?a-N?s?ud","1");
INSERT INTO `llx_c_departements` VALUES("1146","BT","18801","","0","","Boto?ani","1");
INSERT INTO `llx_c_departements` VALUES("1147","BV","18801","","0","","Bra?ov","1");
INSERT INTO `llx_c_departements` VALUES("1148","BR","18801","","0","","Br?ila","1");
INSERT INTO `llx_c_departements` VALUES("1149","BZ","18801","","0","","Buz?u","1");
INSERT INTO `llx_c_departements` VALUES("1150","CL","18801","","0","","C?l?ra?i","1");
INSERT INTO `llx_c_departements` VALUES("1151","CS","18801","","0","","Cara?-Severin","1");
INSERT INTO `llx_c_departements` VALUES("1152","CJ","18801","","0","","Cluj","1");
INSERT INTO `llx_c_departements` VALUES("1153","CT","18801","","0","","Constan?a","1");
INSERT INTO `llx_c_departements` VALUES("1154","CV","18801","","0","","Covasna","1");
INSERT INTO `llx_c_departements` VALUES("1155","DB","18801","","0","","Dâmbovi?a","1");
INSERT INTO `llx_c_departements` VALUES("1156","DJ","18801","","0","","Dolj","1");
INSERT INTO `llx_c_departements` VALUES("1157","GL","18801","","0","","Gala?i","1");
INSERT INTO `llx_c_departements` VALUES("1158","GR","18801","","0","","Giurgiu","1");
INSERT INTO `llx_c_departements` VALUES("1159","GJ","18801","","0","","Gorj","1");
INSERT INTO `llx_c_departements` VALUES("1160","HR","18801","","0","","Harghita","1");
INSERT INTO `llx_c_departements` VALUES("1161","HD","18801","","0","","Hunedoara","1");
INSERT INTO `llx_c_departements` VALUES("1162","IL","18801","","0","","Ialomi?a","1");
INSERT INTO `llx_c_departements` VALUES("1163","IS","18801","","0","","Ia?i","1");
INSERT INTO `llx_c_departements` VALUES("1164","IF","18801","","0","","Ilfov","1");
INSERT INTO `llx_c_departements` VALUES("1165","MM","18801","","0","","Maramure?","1");
INSERT INTO `llx_c_departements` VALUES("1166","MH","18801","","0","","Mehedin?i","1");
INSERT INTO `llx_c_departements` VALUES("1167","MS","18801","","0","","Mure?","1");
INSERT INTO `llx_c_departements` VALUES("1168","NT","18801","","0","","Neam?","1");
INSERT INTO `llx_c_departements` VALUES("1169","OT","18801","","0","","Olt","1");
INSERT INTO `llx_c_departements` VALUES("1170","PH","18801","","0","","Prahova","1");
INSERT INTO `llx_c_departements` VALUES("1171","SM","18801","","0","","Satu Mare","1");
INSERT INTO `llx_c_departements` VALUES("1172","SJ","18801","","0","","S?laj","1");
INSERT INTO `llx_c_departements` VALUES("1173","SB","18801","","0","","Sibiu","1");
INSERT INTO `llx_c_departements` VALUES("1174","SV","18801","","0","","Suceava","1");
INSERT INTO `llx_c_departements` VALUES("1175","TR","18801","","0","","Teleorman","1");
INSERT INTO `llx_c_departements` VALUES("1176","TM","18801","","0","","Timi?","1");
INSERT INTO `llx_c_departements` VALUES("1177","TL","18801","","0","","Tulcea","1");
INSERT INTO `llx_c_departements` VALUES("1178","VS","18801","","0","","Vaslui","1");
INSERT INTO `llx_c_departements` VALUES("1179","VL","18801","","0","","Vâlcea","1");
INSERT INTO `llx_c_departements` VALUES("1180","VN","18801","","0","","Vrancea","1");
INSERT INTO `llx_c_departements` VALUES("1181","BU","18801","","0","","Bucuresti","1");
INSERT INTO `llx_c_departements` VALUES("1182","VE-L","23201","","0","VE-L","Mérida","1");
INSERT INTO `llx_c_departements` VALUES("1183","VE-T","23201","","0","VE-T","Trujillo","1");
INSERT INTO `llx_c_departements` VALUES("1184","VE-E","23201","","0","VE-E","Barinas","1");
INSERT INTO `llx_c_departements` VALUES("1185","VE-M","23202","","0","VE-M","Miranda","1");
INSERT INTO `llx_c_departements` VALUES("1186","VE-W","23202","","0","VE-W","Vargas","1");
INSERT INTO `llx_c_departements` VALUES("1187","VE-A","23202","","0","VE-A","Distrito Capital","1");
INSERT INTO `llx_c_departements` VALUES("1188","VE-D","23203","","0","VE-D","Aragua","1");
INSERT INTO `llx_c_departements` VALUES("1189","VE-G","23203","","0","VE-G","Carabobo","1");
INSERT INTO `llx_c_departements` VALUES("1190","VE-I","23204","","0","VE-I","Falcón","1");
INSERT INTO `llx_c_departements` VALUES("1191","VE-K","23204","","0","VE-K","Lara","1");
INSERT INTO `llx_c_departements` VALUES("1192","VE-U","23204","","0","VE-U","Yaracuy","1");
INSERT INTO `llx_c_departements` VALUES("1193","VE-F","23205","","0","VE-F","Bolívar","1");
INSERT INTO `llx_c_departements` VALUES("1194","VE-X","23205","","0","VE-X","Amazonas","1");
INSERT INTO `llx_c_departements` VALUES("1195","VE-Y","23205","","0","VE-Y","Delta Amacuro","1");
INSERT INTO `llx_c_departements` VALUES("1196","VE-O","23206","","0","VE-O","Nueva Esparta","1");
INSERT INTO `llx_c_departements` VALUES("1197","VE-Z","23206","","0","VE-Z","Dependencias Federales","1");
INSERT INTO `llx_c_departements` VALUES("1198","VE-C","23207","","0","VE-C","Apure","1");
INSERT INTO `llx_c_departements` VALUES("1199","VE-J","23207","","0","VE-J","Guárico","1");
INSERT INTO `llx_c_departements` VALUES("1200","VE-H","23207","","0","VE-H","Cojedes","1");
INSERT INTO `llx_c_departements` VALUES("1201","VE-P","23207","","0","VE-P","Portuguesa","1");
INSERT INTO `llx_c_departements` VALUES("1202","VE-B","23208","","0","VE-B","Anzoátegui","1");
INSERT INTO `llx_c_departements` VALUES("1203","VE-N","23208","","0","VE-N","Monagas","1");
INSERT INTO `llx_c_departements` VALUES("1204","VE-R","23208","","0","VE-R","Sucre","1");
INSERT INTO `llx_c_departements` VALUES("1205","VE-V","23209","","0","VE-V","Zulia","1");
INSERT INTO `llx_c_departements` VALUES("1206","VE-S","23209","","0","VE-S","Táchira","1");
INSERT INTO `llx_c_departements` VALUES("1207","LU0001","14001","","0","","Clervaux","1");
INSERT INTO `llx_c_departements` VALUES("1208","LU0002","14001","","0","","Diekirch","1");
INSERT INTO `llx_c_departements` VALUES("1209","LU0003","14001","","0","","Redange","1");
INSERT INTO `llx_c_departements` VALUES("1210","LU0004","14001","","0","","Vianden","1");
INSERT INTO `llx_c_departements` VALUES("1211","LU0005","14001","","0","","Wiltz","1");
INSERT INTO `llx_c_departements` VALUES("1212","LU0006","14002","","0","","Echternach","1");
INSERT INTO `llx_c_departements` VALUES("1213","LU0007","14002","","0","","Grevenmacher","1");
INSERT INTO `llx_c_departements` VALUES("1214","LU0008","14002","","0","","Remich","1");
INSERT INTO `llx_c_departements` VALUES("1215","LU0009","14003","","0","","Capellen","1");
INSERT INTO `llx_c_departements` VALUES("1216","LU0010","14003","","0","","Esch-sur-Alzette","1");
INSERT INTO `llx_c_departements` VALUES("1217","LU0011","14003","","0","","Luxembourg","1");
INSERT INTO `llx_c_departements` VALUES("1218","LU0012","14003","","0","","Mersch","1");
INSERT INTO `llx_c_departements` VALUES("1219","0101","18101","","0","","Chachapoyas","1");
INSERT INTO `llx_c_departements` VALUES("1220","0102","18101","","0","","Bagua","1");
INSERT INTO `llx_c_departements` VALUES("1221","0103","18101","","0","","Bongará","1");
INSERT INTO `llx_c_departements` VALUES("1222","0104","18101","","0","","Condorcanqui","1");
INSERT INTO `llx_c_departements` VALUES("1223","0105","18101","","0","","Luya","1");
INSERT INTO `llx_c_departements` VALUES("1224","0106","18101","","0","","Rodríguez de Mendoza","1");
INSERT INTO `llx_c_departements` VALUES("1225","0107","18101","","0","","Utcubamba","1");
INSERT INTO `llx_c_departements` VALUES("1226","0201","18102","","0","","Huaraz","1");
INSERT INTO `llx_c_departements` VALUES("1227","0202","18102","","0","","Aija","1");
INSERT INTO `llx_c_departements` VALUES("1228","0203","18102","","0","","Antonio Raymondi","1");
INSERT INTO `llx_c_departements` VALUES("1229","0204","18102","","0","","Asunción","1");
INSERT INTO `llx_c_departements` VALUES("1230","0205","18102","","0","","Bolognesi","1");
INSERT INTO `llx_c_departements` VALUES("1231","0206","18102","","0","","Carhuaz","1");
INSERT INTO `llx_c_departements` VALUES("1232","0207","18102","","0","","Carlos Fermín Fitzcarrald","1");
INSERT INTO `llx_c_departements` VALUES("1233","0208","18102","","0","","Casma","1");
INSERT INTO `llx_c_departements` VALUES("1234","0209","18102","","0","","Corongo","1");
INSERT INTO `llx_c_departements` VALUES("1235","0210","18102","","0","","Huari","1");
INSERT INTO `llx_c_departements` VALUES("1236","0211","18102","","0","","Huarmey","1");
INSERT INTO `llx_c_departements` VALUES("1237","0212","18102","","0","","Huaylas","1");
INSERT INTO `llx_c_departements` VALUES("1238","0213","18102","","0","","Mariscal Luzuriaga","1");
INSERT INTO `llx_c_departements` VALUES("1239","0214","18102","","0","","Ocros","1");
INSERT INTO `llx_c_departements` VALUES("1240","0215","18102","","0","","Pallasca","1");
INSERT INTO `llx_c_departements` VALUES("1241","0216","18102","","0","","Pomabamba","1");
INSERT INTO `llx_c_departements` VALUES("1242","0217","18102","","0","","Recuay","1");
INSERT INTO `llx_c_departements` VALUES("1243","0218","18102","","0","","Papá","1");
INSERT INTO `llx_c_departements` VALUES("1244","0219","18102","","0","","Sihuas","1");
INSERT INTO `llx_c_departements` VALUES("1245","0220","18102","","0","","Yungay","1");
INSERT INTO `llx_c_departements` VALUES("1246","0301","18103","","0","","Abancay","1");
INSERT INTO `llx_c_departements` VALUES("1247","0302","18103","","0","","Andahuaylas","1");
INSERT INTO `llx_c_departements` VALUES("1248","0303","18103","","0","","Antabamba","1");
INSERT INTO `llx_c_departements` VALUES("1249","0304","18103","","0","","Aymaraes","1");
INSERT INTO `llx_c_departements` VALUES("1250","0305","18103","","0","","Cotabambas","1");
INSERT INTO `llx_c_departements` VALUES("1251","0306","18103","","0","","Chincheros","1");
INSERT INTO `llx_c_departements` VALUES("1252","0307","18103","","0","","Grau","1");
INSERT INTO `llx_c_departements` VALUES("1253","0401","18104","","0","","Arequipa","1");
INSERT INTO `llx_c_departements` VALUES("1254","0402","18104","","0","","Camaná","1");
INSERT INTO `llx_c_departements` VALUES("1255","0403","18104","","0","","Caravelí","1");
INSERT INTO `llx_c_departements` VALUES("1256","0404","18104","","0","","Castilla","1");
INSERT INTO `llx_c_departements` VALUES("1257","0405","18104","","0","","Caylloma","1");
INSERT INTO `llx_c_departements` VALUES("1258","0406","18104","","0","","Condesuyos","1");
INSERT INTO `llx_c_departements` VALUES("1259","0407","18104","","0","","Islay","1");
INSERT INTO `llx_c_departements` VALUES("1260","0408","18104","","0","","La Unión","1");
INSERT INTO `llx_c_departements` VALUES("1261","0501","18105","","0","","Huamanga","1");
INSERT INTO `llx_c_departements` VALUES("1262","0502","18105","","0","","Cangallo","1");
INSERT INTO `llx_c_departements` VALUES("1263","0503","18105","","0","","Huanca Sancos","1");
INSERT INTO `llx_c_departements` VALUES("1264","0504","18105","","0","","Huanta","1");
INSERT INTO `llx_c_departements` VALUES("1265","0505","18105","","0","","La Mar","1");
INSERT INTO `llx_c_departements` VALUES("1266","0506","18105","","0","","Lucanas","1");
INSERT INTO `llx_c_departements` VALUES("1267","0507","18105","","0","","Parinacochas","1");
INSERT INTO `llx_c_departements` VALUES("1268","0508","18105","","0","","Páucar del Sara Sara","1");
INSERT INTO `llx_c_departements` VALUES("1269","0509","18105","","0","","Sucre","1");
INSERT INTO `llx_c_departements` VALUES("1270","0510","18105","","0","","Víctor Fajardo","1");
INSERT INTO `llx_c_departements` VALUES("1271","0511","18105","","0","","Vilcas Huamán","1");
INSERT INTO `llx_c_departements` VALUES("1272","0601","18106","","0","","Cajamarca","1");
INSERT INTO `llx_c_departements` VALUES("1273","0602","18106","","0","","Cajabamba","1");
INSERT INTO `llx_c_departements` VALUES("1274","0603","18106","","0","","Celendín","1");
INSERT INTO `llx_c_departements` VALUES("1275","0604","18106","","0","","Chota","1");
INSERT INTO `llx_c_departements` VALUES("1276","0605","18106","","0","","Contumazá","1");
INSERT INTO `llx_c_departements` VALUES("1277","0606","18106","","0","","Cutervo","1");
INSERT INTO `llx_c_departements` VALUES("1278","0607","18106","","0","","Hualgayoc","1");
INSERT INTO `llx_c_departements` VALUES("1279","0608","18106","","0","","Jaén","1");
INSERT INTO `llx_c_departements` VALUES("1280","0609","18106","","0","","San Ignacio","1");
INSERT INTO `llx_c_departements` VALUES("1281","0610","18106","","0","","San Marcos","1");
INSERT INTO `llx_c_departements` VALUES("1282","0611","18106","","0","","San Miguel","1");
INSERT INTO `llx_c_departements` VALUES("1283","0612","18106","","0","","San Pablo","1");
INSERT INTO `llx_c_departements` VALUES("1284","0613","18106","","0","","Santa Cruz","1");
INSERT INTO `llx_c_departements` VALUES("1285","0701","18107","","0","","Callao","1");
INSERT INTO `llx_c_departements` VALUES("1286","0801","18108","","0","","Cusco","1");
INSERT INTO `llx_c_departements` VALUES("1287","0802","18108","","0","","Acomayo","1");
INSERT INTO `llx_c_departements` VALUES("1288","0803","18108","","0","","Anta","1");
INSERT INTO `llx_c_departements` VALUES("1289","0804","18108","","0","","Calca","1");
INSERT INTO `llx_c_departements` VALUES("1290","0805","18108","","0","","Canas","1");
INSERT INTO `llx_c_departements` VALUES("1291","0806","18108","","0","","Canchis","1");
INSERT INTO `llx_c_departements` VALUES("1292","0807","18108","","0","","Chumbivilcas","1");
INSERT INTO `llx_c_departements` VALUES("1293","0808","18108","","0","","Espinar","1");
INSERT INTO `llx_c_departements` VALUES("1294","0809","18108","","0","","La Convención","1");
INSERT INTO `llx_c_departements` VALUES("1295","0810","18108","","0","","Paruro","1");
INSERT INTO `llx_c_departements` VALUES("1296","0811","18108","","0","","Paucartambo","1");
INSERT INTO `llx_c_departements` VALUES("1297","0812","18108","","0","","Quispicanchi","1");
INSERT INTO `llx_c_departements` VALUES("1298","0813","18108","","0","","Urubamba","1");
INSERT INTO `llx_c_departements` VALUES("1299","0901","18109","","0","","Huancavelica","1");
INSERT INTO `llx_c_departements` VALUES("1300","0902","18109","","0","","Acobamba","1");
INSERT INTO `llx_c_departements` VALUES("1301","0903","18109","","0","","Angaraes","1");
INSERT INTO `llx_c_departements` VALUES("1302","0904","18109","","0","","Castrovirreyna","1");
INSERT INTO `llx_c_departements` VALUES("1303","0905","18109","","0","","Churcampa","1");
INSERT INTO `llx_c_departements` VALUES("1304","0906","18109","","0","","Huaytará","1");
INSERT INTO `llx_c_departements` VALUES("1305","0907","18109","","0","","Tayacaja","1");
INSERT INTO `llx_c_departements` VALUES("1306","1001","18110","","0","","Huánuco","1");
INSERT INTO `llx_c_departements` VALUES("1307","1002","18110","","0","","Ambón","1");
INSERT INTO `llx_c_departements` VALUES("1308","1003","18110","","0","","Dos de Mayo","1");
INSERT INTO `llx_c_departements` VALUES("1309","1004","18110","","0","","Huacaybamba","1");
INSERT INTO `llx_c_departements` VALUES("1310","1005","18110","","0","","Huamalíes","1");
INSERT INTO `llx_c_departements` VALUES("1311","1006","18110","","0","","Leoncio Prado","1");
INSERT INTO `llx_c_departements` VALUES("1312","1007","18110","","0","","Marañón","1");
INSERT INTO `llx_c_departements` VALUES("1313","1008","18110","","0","","Pachitea","1");
INSERT INTO `llx_c_departements` VALUES("1314","1009","18110","","0","","Puerto Inca","1");
INSERT INTO `llx_c_departements` VALUES("1315","1010","18110","","0","","Lauricocha","1");
INSERT INTO `llx_c_departements` VALUES("1316","1011","18110","","0","","Yarowilca","1");
INSERT INTO `llx_c_departements` VALUES("1317","1101","18111","","0","","Ica","1");
INSERT INTO `llx_c_departements` VALUES("1318","1102","18111","","0","","Chincha","1");
INSERT INTO `llx_c_departements` VALUES("1319","1103","18111","","0","","Nazca","1");
INSERT INTO `llx_c_departements` VALUES("1320","1104","18111","","0","","Palpa","1");
INSERT INTO `llx_c_departements` VALUES("1321","1105","18111","","0","","Pisco","1");
INSERT INTO `llx_c_departements` VALUES("1322","1201","18112","","0","","Huancayo","1");
INSERT INTO `llx_c_departements` VALUES("1323","1202","18112","","0","","Concepción","1");
INSERT INTO `llx_c_departements` VALUES("1324","1203","18112","","0","","Chanchamayo","1");
INSERT INTO `llx_c_departements` VALUES("1325","1204","18112","","0","","Jauja","1");
INSERT INTO `llx_c_departements` VALUES("1326","1205","18112","","0","","Junín","1");
INSERT INTO `llx_c_departements` VALUES("1327","1206","18112","","0","","Satipo","1");
INSERT INTO `llx_c_departements` VALUES("1328","1207","18112","","0","","Tarma","1");
INSERT INTO `llx_c_departements` VALUES("1329","1208","18112","","0","","Yauli","1");
INSERT INTO `llx_c_departements` VALUES("1330","1209","18112","","0","","Chupaca","1");
INSERT INTO `llx_c_departements` VALUES("1331","1301","18113","","0","","Trujillo","1");
INSERT INTO `llx_c_departements` VALUES("1332","1302","18113","","0","","Ascope","1");
INSERT INTO `llx_c_departements` VALUES("1333","1303","18113","","0","","Bolívar","1");
INSERT INTO `llx_c_departements` VALUES("1334","1304","18113","","0","","Chepén","1");
INSERT INTO `llx_c_departements` VALUES("1335","1305","18113","","0","","Julcán","1");
INSERT INTO `llx_c_departements` VALUES("1336","1306","18113","","0","","Otuzco","1");
INSERT INTO `llx_c_departements` VALUES("1337","1307","18113","","0","","Pacasmayo","1");
INSERT INTO `llx_c_departements` VALUES("1338","1308","18113","","0","","Pataz","1");
INSERT INTO `llx_c_departements` VALUES("1339","1309","18113","","0","","Sánchez Carrión","1");
INSERT INTO `llx_c_departements` VALUES("1340","1310","18113","","0","","Santiago de Chuco","1");
INSERT INTO `llx_c_departements` VALUES("1341","1311","18113","","0","","Gran Chimú","1");
INSERT INTO `llx_c_departements` VALUES("1342","1312","18113","","0","","Virú","1");
INSERT INTO `llx_c_departements` VALUES("1343","1401","18114","","0","","Chiclayo","1");
INSERT INTO `llx_c_departements` VALUES("1344","1402","18114","","0","","Ferreñafe","1");
INSERT INTO `llx_c_departements` VALUES("1345","1403","18114","","0","","Lambayeque","1");
INSERT INTO `llx_c_departements` VALUES("1346","1501","18115","","0","","Lima","1");
INSERT INTO `llx_c_departements` VALUES("1347","1502","18116","","0","","Huaura","1");
INSERT INTO `llx_c_departements` VALUES("1348","1503","18116","","0","","Barranca","1");
INSERT INTO `llx_c_departements` VALUES("1349","1504","18116","","0","","Cajatambo","1");
INSERT INTO `llx_c_departements` VALUES("1350","1505","18116","","0","","Canta","1");
INSERT INTO `llx_c_departements` VALUES("1351","1506","18116","","0","","Cañete","1");
INSERT INTO `llx_c_departements` VALUES("1352","1507","18116","","0","","Huaral","1");
INSERT INTO `llx_c_departements` VALUES("1353","1508","18116","","0","","Huarochirí","1");
INSERT INTO `llx_c_departements` VALUES("1354","1509","18116","","0","","Oyón","1");
INSERT INTO `llx_c_departements` VALUES("1355","1510","18116","","0","","Yauyos","1");
INSERT INTO `llx_c_departements` VALUES("1356","1601","18117","","0","","Maynas","1");
INSERT INTO `llx_c_departements` VALUES("1357","1602","18117","","0","","Alto Amazonas","1");
INSERT INTO `llx_c_departements` VALUES("1358","1603","18117","","0","","Loreto","1");
INSERT INTO `llx_c_departements` VALUES("1359","1604","18117","","0","","Mariscal Ramón Castilla","1");
INSERT INTO `llx_c_departements` VALUES("1360","1605","18117","","0","","Requena","1");
INSERT INTO `llx_c_departements` VALUES("1361","1606","18117","","0","","Ucayali","1");
INSERT INTO `llx_c_departements` VALUES("1362","1607","18117","","0","","Datem del Marañón","1");
INSERT INTO `llx_c_departements` VALUES("1363","1701","18118","","0","","Tambopata","1");
INSERT INTO `llx_c_departements` VALUES("1364","1702","18118","","0","","Manú","1");
INSERT INTO `llx_c_departements` VALUES("1365","1703","18118","","0","","Tahuamanu","1");
INSERT INTO `llx_c_departements` VALUES("1366","1801","18119","","0","","Mariscal Nieto","1");
INSERT INTO `llx_c_departements` VALUES("1367","1802","18119","","0","","General Sánchez Cerro","1");
INSERT INTO `llx_c_departements` VALUES("1368","1803","18119","","0","","Ilo","1");
INSERT INTO `llx_c_departements` VALUES("1369","1901","18120","","0","","Pasco","1");
INSERT INTO `llx_c_departements` VALUES("1370","1902","18120","","0","","Daniel Alcides Carrión","1");
INSERT INTO `llx_c_departements` VALUES("1371","1903","18120","","0","","Oxapampa","1");
INSERT INTO `llx_c_departements` VALUES("1372","2001","18121","","0","","Piura","1");
INSERT INTO `llx_c_departements` VALUES("1373","2002","18121","","0","","Ayabaca","1");
INSERT INTO `llx_c_departements` VALUES("1374","2003","18121","","0","","Huancabamba","1");
INSERT INTO `llx_c_departements` VALUES("1375","2004","18121","","0","","Morropón","1");
INSERT INTO `llx_c_departements` VALUES("1376","2005","18121","","0","","Paita","1");
INSERT INTO `llx_c_departements` VALUES("1377","2006","18121","","0","","Sullana","1");
INSERT INTO `llx_c_departements` VALUES("1378","2007","18121","","0","","Talara","1");
INSERT INTO `llx_c_departements` VALUES("1379","2008","18121","","0","","Sechura","1");
INSERT INTO `llx_c_departements` VALUES("1380","2101","18122","","0","","Puno","1");
INSERT INTO `llx_c_departements` VALUES("1381","2102","18122","","0","","Azángaro","1");
INSERT INTO `llx_c_departements` VALUES("1382","2103","18122","","0","","Carabaya","1");
INSERT INTO `llx_c_departements` VALUES("1383","2104","18122","","0","","Chucuito","1");
INSERT INTO `llx_c_departements` VALUES("1384","2105","18122","","0","","El Collao","1");
INSERT INTO `llx_c_departements` VALUES("1385","2106","18122","","0","","Huancané","1");
INSERT INTO `llx_c_departements` VALUES("1386","2107","18122","","0","","Lampa","1");
INSERT INTO `llx_c_departements` VALUES("1387","2108","18122","","0","","Melgar","1");
INSERT INTO `llx_c_departements` VALUES("1388","2109","18122","","0","","Moho","1");
INSERT INTO `llx_c_departements` VALUES("1389","2110","18122","","0","","San Antonio de Putina","1");
INSERT INTO `llx_c_departements` VALUES("1390","2111","18122","","0","","San Román","1");
INSERT INTO `llx_c_departements` VALUES("1391","2112","18122","","0","","Sandia","1");
INSERT INTO `llx_c_departements` VALUES("1392","2113","18122","","0","","Yunguyo","1");
INSERT INTO `llx_c_departements` VALUES("1393","2201","18123","","0","","Moyobamba","1");
INSERT INTO `llx_c_departements` VALUES("1394","2202","18123","","0","","Bellavista","1");
INSERT INTO `llx_c_departements` VALUES("1395","2203","18123","","0","","El Dorado","1");
INSERT INTO `llx_c_departements` VALUES("1396","2204","18123","","0","","Huallaga","1");
INSERT INTO `llx_c_departements` VALUES("1397","2205","18123","","0","","Lamas","1");
INSERT INTO `llx_c_departements` VALUES("1398","2206","18123","","0","","Mariscal Cáceres","1");
INSERT INTO `llx_c_departements` VALUES("1399","2207","18123","","0","","Picota","1");
INSERT INTO `llx_c_departements` VALUES("1400","2208","18123","","0","","La Rioja","1");
INSERT INTO `llx_c_departements` VALUES("1401","2209","18123","","0","","San Martín","1");
INSERT INTO `llx_c_departements` VALUES("1402","2210","18123","","0","","Tocache","1");
INSERT INTO `llx_c_departements` VALUES("1403","2301","18124","","0","","Tacna","1");
INSERT INTO `llx_c_departements` VALUES("1404","2302","18124","","0","","Candarave","1");
INSERT INTO `llx_c_departements` VALUES("1405","2303","18124","","0","","Jorge Basadre","1");
INSERT INTO `llx_c_departements` VALUES("1406","2304","18124","","0","","Tarata","1");
INSERT INTO `llx_c_departements` VALUES("1407","2401","18125","","0","","Tumbes","1");
INSERT INTO `llx_c_departements` VALUES("1408","2402","18125","","0","","Contralmirante Villar","1");
INSERT INTO `llx_c_departements` VALUES("1409","2403","18125","","0","","Zarumilla","1");
INSERT INTO `llx_c_departements` VALUES("1410","2501","18126","","0","","Coronel Portillo","1");
INSERT INTO `llx_c_departements` VALUES("1411","2502","18126","","0","","Atalaya","1");
INSERT INTO `llx_c_departements` VALUES("1412","2503","18126","","0","","Padre Abad","1");
INSERT INTO `llx_c_departements` VALUES("1413","2504","18126","","0","","Purús","1");
INSERT INTO `llx_c_departements` VALUES("1414","PA-1","17801","","0","","Bocas del Toro","1");
INSERT INTO `llx_c_departements` VALUES("1415","PA-2","17801","","0","","Coclé","1");
INSERT INTO `llx_c_departements` VALUES("1416","PA-3","17801","","0","","Colón","1");
INSERT INTO `llx_c_departements` VALUES("1417","PA-4","17801","","0","","Chiriquí","1");
INSERT INTO `llx_c_departements` VALUES("1418","PA-5","17801","","0","","Darién","1");
INSERT INTO `llx_c_departements` VALUES("1419","PA-6","17801","","0","","Herrera","1");
INSERT INTO `llx_c_departements` VALUES("1420","PA-7","17801","","0","","Los Santos","1");
INSERT INTO `llx_c_departements` VALUES("1421","PA-8","17801","","0","","Panamá","1");
INSERT INTO `llx_c_departements` VALUES("1422","PA-9","17801","","0","","Veraguas","1");
INSERT INTO `llx_c_departements` VALUES("1423","PA-13","17801","","0","","Panamá Oeste","1");
INSERT INTO `llx_c_departements` VALUES("1424","AE-1","22701","","0","","Abu Dhabi","1");
INSERT INTO `llx_c_departements` VALUES("1425","AE-2","22701","","0","","Dubai","1");
INSERT INTO `llx_c_departements` VALUES("1426","AE-3","22701","","0","","Ajman","1");
INSERT INTO `llx_c_departements` VALUES("1427","AE-4","22701","","0","","Fujairah","1");
INSERT INTO `llx_c_departements` VALUES("1428","AE-5","22701","","0","","Ras al-Khaimah","1");
INSERT INTO `llx_c_departements` VALUES("1429","AE-6","22701","","0","","Sharjah","1");
INSERT INTO `llx_c_departements` VALUES("1430","AE-7","22701","","0","","Umm al-Quwain","1");



DROP TABLE IF EXISTS `llx_c_ecotaxe`;
CREATE TABLE `llx_c_ecotaxe` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(64) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `price` double(24,8) DEFAULT NULL,
  `organization` varchar(255) DEFAULT NULL,
  `fk_pays` int NOT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_ecotaxe` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_ecotaxe` VALUES("1","25040","PETIT APPAREILS MENAGERS","0.25000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("2","25050","TRES PETIT APPAREILS MENAGERS","0.08000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("3","32070","ECRAN POIDS < 5 KG","2.08000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("4","32080","ECRAN POIDS > 5 KG","1.25000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("5","32051","ORDINATEUR PORTABLE","0.42000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("6","32061","TABLETTE INFORMATIQUE","0.84000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("7","36011","ORDINATEUR FIXE (UC)","1.15000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("8","36021","IMPRIMANTES","0.83000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("9","36030","IT (INFORMATIQUE ET TELECOMS)","0.83000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("10","36040","PETIT IT (CLAVIERS / SOURIS)","0.08000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("11","36050","TELEPHONIE MOBILE","0.02000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("12","36060","CONNECTIQUE CABLES","0.02000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("13","45010","GROS MATERIEL GRAND PUBLIC (TELEAGRANDISSEURS)","1.67000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("14","45020","MOYEN MATERIEL GRAND PUBLIC (LOUPES ELECTRONIQUES)","0.42000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("15","45030","PETIT MATERIEL GRAND PUBLIC (VIE QUOTIDIENNE)","0.08000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("16","75030","JOUETS < 0,5 KG","0.08000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("17","75040","JOUETS ENTRE 0,5 KG ET 10 KG","0.17000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("18","74050","JOUETS > 10 KG","1.67000000","Eco-systèmes","1","1");
INSERT INTO `llx_c_ecotaxe` VALUES("19","85010","EQUIPEMENT MEDICAL < 0,5 KG","0.08000000","Eco-systèmes","1","1");



DROP TABLE IF EXISTS `llx_c_effectif`;
CREATE TABLE `llx_c_effectif` (
  `id` int NOT NULL,
  `code` varchar(12) NOT NULL,
  `libelle` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_effectif` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_effectif` VALUES("0","EF0","-","1",NULL);
INSERT INTO `llx_c_effectif` VALUES("1","EF1-5","1 - 5","1",NULL);
INSERT INTO `llx_c_effectif` VALUES("2","EF6-10","6 - 10","1",NULL);
INSERT INTO `llx_c_effectif` VALUES("3","EF11-50","11 - 50","1",NULL);
INSERT INTO `llx_c_effectif` VALUES("4","EF51-100","51 - 100","1",NULL);
INSERT INTO `llx_c_effectif` VALUES("5","EF101-500","101 - 500","1",NULL);
INSERT INTO `llx_c_effectif` VALUES("6","EF500-","> 500","1",NULL);



DROP TABLE IF EXISTS `llx_c_email_senderprofile`;
CREATE TABLE `llx_c_email_senderprofile` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `private` smallint NOT NULL DEFAULT '0',
  `date_creation` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `signature` text,
  `position` smallint DEFAULT '0',
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_email_senderprofile` (`entity`,`label`,`email`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_c_email_templates`;
CREATE TABLE `llx_c_email_templates` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  `type_template` varchar(32) DEFAULT NULL,
  `lang` varchar(6) DEFAULT '',
  `private` smallint NOT NULL DEFAULT '0',
  `fk_user` int DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `label` varchar(180) DEFAULT NULL,
  `position` smallint DEFAULT NULL,
  `enabled` varchar(255) DEFAULT '1',
  `active` tinyint NOT NULL DEFAULT '1',
  `topic` text,
  `joinfiles` text,
  `content` mediumtext,
  `content_lines` text,
  `email_from` varchar(255) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `email_tocc` varchar(255) DEFAULT NULL,
  `email_tobcc` varchar(255) DEFAULT NULL,
  `defaultfortype` smallint DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_email_templates` (`entity`,`label`,`lang`),
  KEY `idx_type` (`type_template`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_email_templates` VALUES("1","0","banque","thirdparty","","0",NULL,NULL,NULL,"(YourSEPAMandate)","1","1","0","__(YourSEPAMandate)__",NULL,"__(Hello)__,<br><br>\n\n__(FindYourSEPAMandate)__ :<br>\n__MYCOMPANY_NAME__<br>\n__MYCOMPANY_FULLADDRESS__<br><br>\n__(Sincerely)__<br>\n__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("2","0","adherent","member","","0",NULL,NULL,NULL,"(SendingEmailOnAutoSubscription)","10","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(YourMembershipRequestWasReceived)__","1","__(Hello)__ __MEMBER_FULLNAME__,<br><br>\n\n__(ThisIsContentOfYourMembershipRequestWasReceived)__<br>\n<br>__ONLINE_PAYMENT_TEXT_AND_URL__<br>\n<br><br>\n__(Sincerely)__<br>__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("3","0","adherent","member","","0",NULL,NULL,NULL,"(SendingEmailOnMemberValidation)","20","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(YourMembershipWasValidated)__","1","__(Hello)__ __MEMBER_FULLNAME__,<br><br>\n\n__(ThisIsContentOfYourMembershipWasValidated)__<br>__INFOS__<br>\n<br>__ONLINE_PAYMENT_TEXT_AND_URL__<br>\n<br><br>\n__(Sincerely)__<br>__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("4","0","adherent","member","","0",NULL,NULL,NULL,"(SendingEmailOnNewSubscription)","30","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(YourSubscriptionWasRecorded)__","1","__(Hello)__ __MEMBER_FULLNAME__,<br><br>\n\n__(ThisIsContentOfYourSubscriptionWasRecorded)__<br>\n\n<br><br>\n__(Sincerely)__<br>__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("5","0","adherent","member","","0",NULL,NULL,NULL,"(SendingReminderForExpiredSubscription)","40","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(SubscriptionReminderEmail)__","1","__(Hello)__ __MEMBER_FULLNAME__,<br><br>\n\n__(ThisIsContentOfSubscriptionReminderEmail)__<br>\n<br>__ONLINE_PAYMENT_TEXT_AND_URL__<br>\n<br><br>\n__(Sincerely)__<br>__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("6","0","adherent","member","","0",NULL,NULL,NULL,"(SendingEmailOnCancelation)","50","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(YourMembershipWasCanceled)__","1","__(Hello)__ __MEMBER_FULLNAME__,<br><br>\n\n__(YourMembershipWasCanceled)__<br>\n<br><br>\n__(Sincerely)__<br>__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("7","0","adherent","member","","0",NULL,NULL,NULL,"(SendingAnEMailToMember)","60","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(CardContent)__","1","__(Hello)__,<br><br>\n\n__(ThisIsContentOfYourCard)__<br>\n__(ID)__ : __ID__<br>\n__(Civiliyty)__ : __MEMBER_CIVILITY__<br>\n__(Firstname)__ : __MEMBER_FIRSTNAME__<br>\n__(Lastname)__ : __MEMBER_LASTNAME__<br>\n__(Fullname)__ : __MEMBER_FULLNAME__<br>\n__(Company)__ : __MEMBER_COMPANY__<br>\n__(Address)__ : __MEMBER_ADDRESS__<br>\n__(Zip)__ : __MEMBER_ZIP__<br>\n__(Town)__ : __MEMBER_TOWN__<br>\n__(Country)__ : __MEMBER_COUNTRY__<br>\n__(Email)__ : __MEMBER_EMAIL__<br>\n__(Birthday)__ : __MEMBER_BIRTH__<br>\n__(Photo)__ : __MEMBER_PHOTO__<br>\n__(Login)__ : __MEMBER_LOGIN__<br>\n__(Password)__ : __MEMBER_PASSWORD__<br>\n__(Phone)__ : __MEMBER_PHONE__<br>\n__(PhonePerso)__ : __MEMBER_PHONEPRO__<br>\n__(PhoneMobile)__ : __MEMBER_PHONEMOBILE__<br><br>\n__(Sincerely)__<br>__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("8","1",NULL,"order_send",NULL,"0",NULL,NULL,NULL,"paypal commande","1","1","1","payer votre commande sur paypal","1","Bonjour Veuillez trouver, ci-joint, la commande __REF__<br />\r\n<br />\r\nMerci de bien vouloir r&eacute;gler par carte bancaire en suivant ce lien (Paiement eni&egrave;rement securis&eacute;)<br />\r\n&nbsp;<a href=\"http://gestion.pixelorigin.com/htdocs/public/payment/newpayment.php?source=order&amp;ref=__REF__\">PAYER avec PAYPAL</a><br />\r\n<br />\r\nCordialement<br />\r\n<br />\r\n__SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("9","1",NULL,"facture_send",NULL,"0",NULL,NULL,NULL,"fac1","1","1","1","Envoi de la facture __REF__","1","Bonjour Veuillez trouver, ci-joint, la facture __REF__<br />\r\n<br />\r\nSinc&egrave;rement\r\n<h2><strong>PIXELORIGIN</strong></h2>\r\n\r\n<p>Benjou Abdelouhab&nbsp;<br />\r\n38 ter rue Raymond Peyres<br />\r\n65000 Tarbes<br />\r\n<strong><strong><a href=\"https://tel:+33651413714\" target=\"_blank\">+33651413714</a></strong></strong></p>\r\n",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("10","1",NULL,"propal_send",NULL,"0","1",NULL,NULL,"dev","5","1","1","Votre devis","1","Bonjour Veuillez trouver, ci-joint, le devis __REF__<br />\r\nVous pouvez valider le devis en suivant ce lien :<br />\r\n<a href=\"https://gestion.pixelorigin.com/htdocs/public/onlinesign/newonlinesign.php?source=proposal&amp;ref=PR2507-0029&amp;securekey=$2y$10$ama5f7elGnGg7.BboHAHa.6rIsMLc/wIGzXOdlsfuJLZmgp4h.UAW\">Lien pour valider en ligne le devis</a><br />\r\n<br />\r\nCordialement<br />\r\n<br />\r\n&nbsp;",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("11","0","recruitment","recruitmentcandidature_send","","0",NULL,NULL,NULL,"(AnswerCandidature)","100","$conf->recruitment->enabled","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(YourCandidature)__","0","__(Hello)__ __CANDIDATE_FULLNAME__,<br><br>\n\n__(YourCandidatureAnswer)__<br>\n<br><br>\n__(Sincerely)__<br>__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("13","0","","conferenceorbooth","","0",NULL,NULL,NULL,"(EventOrganizationEmailAskConf)","10","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(EventOrganizationEmailAskConf)__",NULL,"__(Hello)__,<br /><br />__(OrganizationEventConfRequestWasReceived)__<br /><br /><br />__(Sincerely)__<br />__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("14","0","","conferenceorbooth","","0",NULL,NULL,NULL,"(EventOrganizationEmailAskBooth)","20","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(EventOrganizationEmailAskBooth)__",NULL,"__(Hello)__,<br /><br />__(OrganizationEventBoothRequestWasReceived)__<br /><br /><br />__(Sincerely)__<br />__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("15","0","","conferenceorbooth","","0",NULL,NULL,NULL,"(EventOrganizationEmailSubsBooth)","30","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(EventOrganizationEmailBoothPayment)__",NULL,"__(Hello)__,<br /><br />__(OrganizationEventPaymentOfBoothWasReceived)__<br /><br /><br />__(Sincerely)__<br />__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("16","0","","conferenceorbooth","","0",NULL,NULL,NULL,"(EventOrganizationEmailSubsEvent)","40","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(EventOrganizationEmailRegistrationPayment)__",NULL,"__(Hello)__,<br /><br />__(OrganizationEventPaymentOfRegistrationWasReceived)__<br /><br />__(Sincerely)__<br />__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("17","0","","conferenceorbooth","","0",NULL,NULL,NULL,"(EventOrganizationMassEmailAttendees)","50","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(EventOrganizationMassEmailAttendees)__",NULL,"__(Hello)__,<br /><br />__(OrganizationEventBulkMailToAttendees)__<br /><br />__(Sincerely)__<br />__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("18","0","","conferenceorbooth","","0",NULL,NULL,NULL,"(EventOrganizationMassEmailSpeakers)","60","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(EventOrganizationMassEmailSpeakers)__",NULL,"__(Hello)__,<br /><br />__(OrganizationEventBulkMailToSpeakers)__<br /><br />__(Sincerely)__<br />__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("19","0","partnership","partnership_send","","0",NULL,NULL,NULL,"(SendingEmailOnPartnershipWillSoonBeCanceled)","100","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] - __(YourPartnershipWillSoonBeCanceledTopic)__","0","<body>\n <p>Hello,<br><br>\n__(YourPartnershipWillSoonBeCanceledContent)__</p>\n<br />\n\n<br />\n\n            __(Sincerely)__ <br />\n            __[MAIN_INFO_SOCIETE_NOM]__ <br />\n </body>\n",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("20","0","partnership","partnership_send","","0",NULL,NULL,NULL,"(SendingEmailOnPartnershipCanceled)","100","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] - __(YourPartnershipCanceledTopic)__","0","<body>\n <p>Hello,<br><br>\n__(YourPartnershipCanceledContent)__</p>\n<br />\n\n<br />\n\n            __(Sincerely)__ <br />\n            __[MAIN_INFO_SOCIETE_NOM]__ <br />\n </body>\n",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("21","0","partnership","partnership_send","","0",NULL,NULL,NULL,"(SendingEmailOnPartnershipRefused)","100","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] - __(YourPartnershipRefusedTopic)__","0","<body>\n <p>Hello,<br><br>\n__(YourPartnershipRefusedContent)__</p>\n<br />\n\n<br />\n\n            __(Sincerely)__ <br />\n            __[MAIN_INFO_SOCIETE_NOM]__ <br />\n </body>\n",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("22","0","partnership","partnership_send","","0",NULL,NULL,NULL,"(SendingEmailOnPartnershipAccepted)","100","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] - __(YourPartnershipAcceptedTopic)__","0","<body>\n <p>Hello,<br><br>\n__(YourPartnershipAcceptedContent)__</p>\n<br />\n\n<br />\n\n            __(Sincerely)__ <br />\n            __[MAIN_INFO_SOCIETE_NOM]__ <br />\n </body>\n",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("25","0","","conferenceorbooth","","0",NULL,NULL,NULL,"(EventOrganizationEmailBoothPayment)","30","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(EventOrganizationEmailBoothPayment)__",NULL,"__(Hello)__,<br /><br />__(OrganizationEventPaymentOfBoothWasReceived)__<br /><br /><br />__(Sincerely)__<br />__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("26","0","","conferenceorbooth","","0",NULL,NULL,NULL,"(EventOrganizationEmailRegistrationPayment)","40","1","1","[__[MAIN_INFO_SOCIETE_NOM]__] __(EventOrganizationEmailRegistrationPayment)__",NULL,"__(Hello)__,<br /><br />__(OrganizationEventPaymentOfRegistrationWasReceived)__<br /><br />__(Sincerely)__<br />__USER_SIGNATURE__",NULL,NULL,NULL,NULL,NULL,"0");
INSERT INTO `llx_c_email_templates` VALUES("27","1",NULL,"propal_send",NULL,"0",NULL,NULL,NULL,"dev1","1","1","1","Nouveau devis",NULL,"<br />\r\nhttps://gestion.pixelorigin.com/htdocs/public/onlinesign/newonlinesign.php?source=proposal&amp;ref=PR2507-0029&amp;securekey=$2y$10$50R0qgIKZq9qSz6pmFskPeq986V5FhVyFcCDjEi/n52Ut3em0p6JG<br />\r\n<br />\r\n__ONLINE_SIGN_URL__<br />\r\n&nbsp;",NULL,NULL,NULL,NULL,NULL,"0");



DROP TABLE IF EXISTS `llx_c_exp_tax_cat`;
CREATE TABLE `llx_c_exp_tax_cat` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `label` varchar(128) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `active` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_exp_tax_cat` VALUES("1","ExpAutoCat","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("2","ExpCycloCat","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("3","ExpMotoCat","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("4","ExpAuto3CV","1","1");
INSERT INTO `llx_c_exp_tax_cat` VALUES("5","ExpAuto4CV","1","1");
INSERT INTO `llx_c_exp_tax_cat` VALUES("6","ExpAuto5CV","1","1");
INSERT INTO `llx_c_exp_tax_cat` VALUES("7","ExpAuto6CV","1","1");
INSERT INTO `llx_c_exp_tax_cat` VALUES("8","ExpAuto7CV","1","1");
INSERT INTO `llx_c_exp_tax_cat` VALUES("9","ExpAuto8CV","1","1");
INSERT INTO `llx_c_exp_tax_cat` VALUES("10","ExpAuto9CV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("11","ExpAuto10CV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("12","ExpAuto11CV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("13","ExpAuto12CV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("14","ExpAuto3PCV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("15","ExpAuto4PCV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("16","ExpAuto5PCV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("17","ExpAuto6PCV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("18","ExpAuto7PCV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("19","ExpAuto8PCV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("20","ExpAuto9PCV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("21","ExpAuto10PCV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("22","ExpAuto11PCV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("23","ExpAuto12PCV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("24","ExpAuto13PCV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("25","ExpCyclo","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("26","ExpMoto12CV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("27","ExpMoto345CV","1","0");
INSERT INTO `llx_c_exp_tax_cat` VALUES("28","ExpMoto5PCV","1","0");



DROP TABLE IF EXISTS `llx_c_exp_tax_range`;
CREATE TABLE `llx_c_exp_tax_range` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_c_exp_tax_cat` int NOT NULL DEFAULT '1',
  `range_ik` double NOT NULL DEFAULT '0',
  `entity` int NOT NULL DEFAULT '1',
  `active` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_exp_tax_range` VALUES("1","4","0","1","1");
INSERT INTO `llx_c_exp_tax_range` VALUES("2","4","5000","1","1");
INSERT INTO `llx_c_exp_tax_range` VALUES("3","4","20000","1","1");
INSERT INTO `llx_c_exp_tax_range` VALUES("4","5","0","1","1");
INSERT INTO `llx_c_exp_tax_range` VALUES("5","5","5000","1","1");
INSERT INTO `llx_c_exp_tax_range` VALUES("6","5","20000","1","1");
INSERT INTO `llx_c_exp_tax_range` VALUES("7","6","0","1","1");
INSERT INTO `llx_c_exp_tax_range` VALUES("8","6","5000","1","1");
INSERT INTO `llx_c_exp_tax_range` VALUES("9","6","20000","1","1");
INSERT INTO `llx_c_exp_tax_range` VALUES("10","7","0","1","1");
INSERT INTO `llx_c_exp_tax_range` VALUES("11","7","5000","1","1");
INSERT INTO `llx_c_exp_tax_range` VALUES("12","7","20000","1","1");
INSERT INTO `llx_c_exp_tax_range` VALUES("13","8","0","1","1");
INSERT INTO `llx_c_exp_tax_range` VALUES("14","8","5000","1","1");
INSERT INTO `llx_c_exp_tax_range` VALUES("15","8","20000","1","1");



DROP TABLE IF EXISTS `llx_c_field_list`;
CREATE TABLE `llx_c_field_list` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `element` varchar(64) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `name` varchar(32) NOT NULL,
  `alias` varchar(32) NOT NULL,
  `title` varchar(32) NOT NULL,
  `align` varchar(6) DEFAULT 'left',
  `sort` tinyint NOT NULL DEFAULT '1',
  `search` tinyint NOT NULL DEFAULT '0',
  `visible` tinyint NOT NULL DEFAULT '1',
  `enabled` varchar(255) DEFAULT '1',
  `rang` int DEFAULT '0',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_c_format_cards`;
CREATE TABLE `llx_c_format_cards` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `paper_size` varchar(20) NOT NULL,
  `orientation` varchar(1) NOT NULL,
  `metric` varchar(5) NOT NULL,
  `leftmargin` double(24,8) NOT NULL,
  `topmargin` double(24,8) NOT NULL,
  `nx` int NOT NULL,
  `ny` int NOT NULL,
  `spacex` double(24,8) NOT NULL,
  `spacey` double(24,8) NOT NULL,
  `width` double(24,8) NOT NULL,
  `height` double(24,8) NOT NULL,
  `font_size` int NOT NULL,
  `custom_x` double(24,8) NOT NULL,
  `custom_y` double(24,8) NOT NULL,
  `active` int NOT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_format_cards` VALUES("1","5160","Avery-5160, WL-875WX","letter","P","mm","5.58165000","12.70000000","3","10","3.55600000","0.00000000","65.87490000","25.40000000","7","0.00000000","0.00000000","1");
INSERT INTO `llx_c_format_cards` VALUES("2","5161","Avery-5161, WL-75WX","letter","P","mm","4.44500000","12.70000000","2","10","3.96800000","0.00000000","101.60000000","25.40000000","7","0.00000000","0.00000000","1");
INSERT INTO `llx_c_format_cards` VALUES("3","5162","Avery-5162, WL-100WX","letter","P","mm","3.87350000","22.35200000","2","7","4.95400000","0.00000000","101.60000000","33.78100000","8","0.00000000","0.00000000","1");
INSERT INTO `llx_c_format_cards` VALUES("4","5163","Avery-5163, WL-125WX","letter","P","mm","4.57200000","12.70000000","2","5","3.55600000","0.00000000","101.60000000","50.80000000","10","0.00000000","0.00000000","1");
INSERT INTO `llx_c_format_cards` VALUES("5","5164","5164 (Letter)","letter","P","in","0.14800000","0.50000000","2","3","0.20310000","0.00000000","4.00000000","3.33000000","12","0.00000000","0.00000000","0");
INSERT INTO `llx_c_format_cards` VALUES("6","8600","Avery-8600","letter","P","mm","7.10000000","19.00000000","3","10","9.50000000","3.10000000","66.60000000","25.40000000","7","0.00000000","0.00000000","1");
INSERT INTO `llx_c_format_cards` VALUES("7","99012","DYMO 99012 89*36mm","custom","L","mm","1.00000000","1.00000000","1","1","0.00000000","0.00000000","36.00000000","89.00000000","10","36.00000000","89.00000000","1");
INSERT INTO `llx_c_format_cards` VALUES("8","99014","DYMO 99014 101*54mm","custom","L","mm","1.00000000","1.00000000","1","1","0.00000000","0.00000000","54.00000000","101.00000000","10","54.00000000","101.00000000","1");
INSERT INTO `llx_c_format_cards` VALUES("9","AVERYC32010","Avery-C32010","A4","P","mm","15.00000000","13.00000000","2","5","10.00000000","0.00000000","85.00000000","54.00000000","10","0.00000000","0.00000000","1");
INSERT INTO `llx_c_format_cards` VALUES("10","CARD","Dolibarr Business cards","A4","P","mm","15.00000000","15.00000000","2","5","0.00000000","0.00000000","85.00000000","54.00000000","10","0.00000000","0.00000000","1");
INSERT INTO `llx_c_format_cards` VALUES("11","L7163","Avery-L7163","A4","P","mm","5.00000000","15.00000000","2","7","2.50000000","0.00000000","99.10000000","38.10000000","8","0.00000000","0.00000000","1");



DROP TABLE IF EXISTS `llx_c_forme_juridique`;
CREATE TABLE `llx_c_forme_juridique` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` int NOT NULL,
  `fk_pays` int NOT NULL,
  `libelle` varchar(255) DEFAULT NULL,
  `isvatexempted` tinyint NOT NULL DEFAULT '0',
  `active` tinyint NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_forme_juridique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=298 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_forme_juridique` VALUES("1","0","0","-","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("2","2301","23","Monotributista","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("3","2302","23","Sociedad Civil","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("4","2303","23","Sociedades Comerciales","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("5","2304","23","Sociedades de Hecho","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("6","2305","23","Sociedades Irregulares","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("7","2306","23","Sociedad Colectiva","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("8","2307","23","Sociedad en Comandita Simple","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("9","2308","23","Sociedad de Capital e Industria","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("10","2309","23","Sociedad Accidental o en participación","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("11","2310","23","Sociedad de Responsabilidad Limitada","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("12","2311","23","Sociedad Anónima","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("13","2312","23","Sociedad Anónima con Participación Estatal Mayoritaria","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("14","2313","23","Sociedad en Comandita por Acciones (arts. 315 a 324, LSC)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("15","4100","41","GmbH - Gesellschaft mit beschränkter Haftung","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("16","4101","41","GesmbH - Gesellschaft mit beschränkter Haftung","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("17","4102","41","AG - Aktiengesellschaft","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("18","4103","41","EWIV - Europäische wirtschaftliche Interessenvereinigung","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("19","4104","41","KEG - Kommanditerwerbsgesellschaft","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("20","4105","41","OEG - Offene Erwerbsgesellschaft","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("21","4106","41","OHG - Offene Handelsgesellschaft","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("22","4107","41","AG & Co KG - Kommanditgesellschaft","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("23","4108","41","GmbH & Co KG - Kommanditgesellschaft","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("24","4109","41","KG - Kommanditgesellschaft","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("25","4110","41","OG - Offene Gesellschaft","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("26","4111","41","GbR - Gesellschaft nach bürgerlichem Recht","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("27","4112","41","GesbR - Gesellschaft nach bürgerlichem Recht","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("28","4113","41","GesnbR - Gesellschaft nach bürgerlichem Recht","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("29","4114","41","e.U. - eingetragener Einzelunternehmer","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("30","11","1","Artisan Commerçant (EI)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("31","12","1","Commerçant (EI)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("32","13","1","Artisan (EI)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("33","14","1","Officier public ou ministériel","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("34","15","1","Profession libérale (EI)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("35","16","1","Exploitant agricole","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("36","17","1","Agent commercial","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("37","18","1","Associé Gérant de société","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("38","19","1","Personne physique","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("39","21","1","Indivision","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("40","22","1","Société créée de fait","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("41","23","1","Société en participation","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("42","27","1","Paroisse hors zone concordataire","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("43","29","1","Groupement de droit privé non doté de la personnalité morale","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("44","31","1","Personne morale de droit étranger, immatriculée au RCS","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("45","32","1","Personne morale de droit étranger, non immatriculée au RCS","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("46","35","1","Régime auto-entrepreneur","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("47","41","1","Etablissement public ou régie à caractère industriel ou commercial","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("48","51","1","Société coopérative commerciale particulière","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("49","52","1","Société en nom collectif","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("50","53","1","Société en commandite","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("51","54","1","Société à responsabilité limitée (SARL)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("52","55","1","Société anonyme à conseil d administration","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("53","56","1","Société anonyme à directoire","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("54","57","1","Société par actions simplifiée (SAS)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("55","58","1","Entreprise Unipersonnelle à Responsabilité Limitée (EURL)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("56","59","1","Société par actions simplifiée unipersonnelle (SASU)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("57","60","1","Entreprise Individuelle à Responsabilité Limitée (EIRL)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("58","61","1","Caisse d\'épargne et de prévoyance","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("59","62","1","Groupement d\'intérêt économique (GIE)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("60","63","1","Société coopérative agricole","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("61","64","1","Société non commerciale d assurances","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("62","65","1","Société civile","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("63","69","1","Personnes de droit privé inscrites au RCS","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("64","71","1","Administration de l état","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("65","72","1","Collectivité territoriale","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("66","73","1","Etablissement public administratif","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("67","74","1","Personne morale de droit public administratif","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("68","81","1","Organisme gérant régime de protection social à adhésion obligatoire","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("69","82","1","Organisme mutualiste","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("70","83","1","Comité d entreprise","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("71","84","1","Organisme professionnel","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("72","85","1","Organisme de retraite à adhésion non obligatoire","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("73","91","1","Syndicat de propriétaires","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("74","92","1","Association loi 1901 ou assimilé","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("75","93","1","Fondation","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("76","99","1","Personne morale de droit privé","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("77","200","2","Indépendant","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("78","201","2","SRL - Société à responsabilité limitée","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("79","202","2","SA   - Société Anonyme","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("80","203","2","SCRL - Société coopérative à responsabilité limitée","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("81","204","2","ASBL - Association sans but Lucratif","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("82","205","2","SCRI - Société coopérative à responsabilité illimitée","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("83","206","2","SCS  - Société en commandite simple","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("84","207","2","SCA  - Société en commandite par action","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("85","208","2","SNC  - Société en nom collectif","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("86","209","2","GIE  - Groupement d intérêt économique","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("87","210","2","GEIE - Groupement européen d intérêt économique","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("88","220","2","Eenmanszaak","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("89","221","2","BVBA - Besloten vennootschap met beperkte aansprakelijkheid","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("90","222","2","NV   - Naamloze Vennootschap","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("91","223","2","CVBA - Coöperatieve vennootschap met beperkte aansprakelijkheid","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("92","224","2","VZW  - Vereniging zonder winstoogmerk","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("93","225","2","CVOA - Coöperatieve vennootschap met onbeperkte aansprakelijkheid ","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("94","226","2","GCV  - Gewone commanditaire vennootschap","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("95","227","2","Comm.VA - Commanditaire vennootschap op aandelen","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("96","228","2","VOF  - Vennootschap onder firma","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("97","229","2","VS0  - Vennootschap met sociaal oogmerk","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("98","500","5","GmbH - Gesellschaft mit beschränkter Haftung","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("99","501","5","AG - Aktiengesellschaft ","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("100","502","5","GmbH&Co. KG - Gesellschaft mit beschränkter Haftung & Compagnie Kommanditgesellschaft","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("101","503","5","Gewerbe - Personengesellschaft","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("102","504","5","UG - Unternehmergesellschaft -haftungsbeschränkt-","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("103","505","5","GbR - Gesellschaft des bürgerlichen Rechts","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("104","506","5","KG - Kommanditgesellschaft","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("105","507","5","Ltd. - Limited Company","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("106","508","5","OHG - Offene Handelsgesellschaft","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("107","10201","102","??????? ??????????","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("108","10202","102","????????  ??????????","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("109","10203","102","????????? ???????? ?.?","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("110","10204","102","??????????? ???????? ?.?","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("111","10205","102","???????? ????????????? ??????? ?.?.?","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("112","10206","102","??????? ???????? ?.?","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("113","10207","102","??????? ?????????? ???????? ?.?.?","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("114","10208","102","?????????????","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("115","10209","102","??????????????","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("116","301","3","Società semplice","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("117","302","3","Società in nome collettivo s.n.c.","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("118","303","3","Società in accomandita semplice s.a.s.","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("119","304","3","Società per azioni s.p.a.","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("120","305","3","Società a responsabilità limitata s.r.l.","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("121","306","3","Società in accomandita per azioni s.a.p.a.","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("122","307","3","Società cooperativa a r.l.","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("123","308","3","Società consortile","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("124","309","3","Società europea","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("125","310","3","Società cooperativa europea","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("126","311","3","Società unipersonale","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("127","312","3","Società di professionisti","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("128","313","3","Società di fatto","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("129","315","3","Società apparente","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("130","316","3","Impresa individuale ","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("131","317","3","Impresa coniugale","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("132","318","3","Impresa familiare","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("133","319","3","Consorzio cooperativo","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("134","320","3","Società cooperativa sociale","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("135","321","3","Società cooperativa di consumo","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("136","322","3","Società cooperativa agricola","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("137","323","3","A.T.I. Associazione temporanea di imprese","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("138","324","3","R.T.I. Raggruppamento temporaneo di imprese","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("139","325","3","Studio associato","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("140","600","6","Raison Individuelle","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("141","601","6","Société Simple","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("142","602","6","Société en nom collectif","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("143","603","6","Société en commandite","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("144","604","6","Société anonyme (SA)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("145","605","6","Société en commandite par actions","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("146","606","6","Société à responsabilité limitée (SARL)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("147","607","6","Société coopérative","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("148","608","6","Association","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("149","609","6","Fondation","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("150","700","7","Sole Trader","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("151","701","7","Partnership","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("152","702","7","Private Limited Company by shares (LTD)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("153","703","7","Public Limited Company","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("154","704","7","Workers Cooperative","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("155","705","7","Limited Liability Partnership","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("156","706","7","Franchise","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("157","1000","10","Société à responsabilité limitée (SARL)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("158","1001","10","Société en Nom Collectif (SNC)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("159","1002","10","Société en Commandite Simple (SCS)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("160","1003","10","société en participation","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("161","1004","10","Société Anonyme (SA)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("162","1005","10","Société Unipersonnelle à Responsabilité Limitée (SUARL)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("163","1006","10","Groupement d\'intérêt économique (GEI)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("164","1007","10","Groupe de sociétés","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("165","1701","17","Eenmanszaak","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("166","1702","17","Maatschap","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("167","1703","17","Vennootschap onder firma","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("168","1704","17","Commanditaire vennootschap","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("169","1705","17","Besloten vennootschap (BV)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("170","1706","17","Naamloze Vennootschap (NV)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("171","1707","17","Vereniging","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("172","1708","17","Stichting","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("173","1709","17","Coöperatie met beperkte aansprakelijkheid (BA)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("174","1710","17","Coöperatie met uitgesloten aansprakelijkheid (UA)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("175","1711","17","Coöperatie met wettelijke aansprakelijkheid (WA)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("176","1712","17","Onderlinge waarborgmaatschappij","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("177","401","4","Empresario Individual","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("178","402","4","Comunidad de Bienes","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("179","403","4","Sociedad Civil","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("180","404","4","Sociedad Colectiva","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("181","405","4","Sociedad Limitada","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("182","406","4","Sociedad Anónima","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("183","407","4","Sociedad Comanditaria por Acciones","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("184","408","4","Sociedad Comanditaria Simple","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("185","409","4","Sociedad Laboral","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("186","410","4","Sociedad Cooperativa","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("187","411","4","Sociedad de Garantía Recíproca","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("188","412","4","Entidad de Capital-Riesgo","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("189","413","4","Agrupación de Interés Económico","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("190","414","4","Sociedad de Inversión Mobiliaria","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("191","415","4","Agrupación sin Ánimo de Lucro","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("192","15201","152","Mauritius Private Company Limited By Shares","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("193","15202","152","Mauritius Company Limited By Guarantee","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("194","15203","152","Mauritius Public Company Limited By Shares","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("195","15204","152","Mauritius Foreign Company","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("196","15205","152","Mauritius GBC1 (Offshore Company)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("197","15206","152","Mauritius GBC2 (International Company)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("198","15207","152","Mauritius General Partnership","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("199","15208","152","Mauritius Limited Partnership","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("200","15209","152","Mauritius Sole Proprietorship","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("201","15210","152","Mauritius Trusts","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("202","15401","154","Sociedad en nombre colectivo","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("203","15402","154","Sociedad en comandita simple","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("204","15403","154","Sociedad de responsabilidad limitada","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("205","15404","154","Sociedad anónima","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("206","15405","154","Sociedad en comandita por acciones","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("207","15406","154","Sociedad cooperativa","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("208","14001","140","Entreprise individuelle","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("209","14002","140","Société en nom collectif (SENC)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("210","14003","140","Société en commandite simple (SECS)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("211","14004","140","Société en commandite par actions (SECA)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("212","14005","140","Société à responsabilité limitée (SARL)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("213","14006","140","Société anonyme (SA)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("214","14007","140","Société coopérative (SC)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("215","14008","140","Société européenne (SE)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("216","18801","188","AFJ - Alte forme juridice","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("217","18802","188","ASF - Asociatie familialã","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("218","18803","188","CON - Concesiune","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("219","18804","188","CRL - Soc civilã profesionala cu pers. juridica si rãspundere limitata (SPRL)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("220","18805","188","INC - Închiriere","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("221","18806","188","LOC - Loca?ie de gestiune","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("222","18807","188","OC1 - Organiza?ie cooperatistã me?te?ugãreascã","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("223","18808","188","OC2 - Organiza?ie cooperatistã de consum","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("224","18809","188","OC3 - Organiza?ie cooperatistã de credit","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("225","18810","188","PFA - Persoanã fizicã independentã","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("226","18811","188","RA - Regie autonomã","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("227","18812","188","SA - Societate comercialã pe ac?iuni","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("228","18813","188","SCS - Societate comercialã în comanditã simplã","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("229","18814","188","SNC - Societate comercialã în nume colectiv","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("230","18815","188","SPI - Societate profesionala practicieni in insolventa (SPPI)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("231","18816","188","SRL - Societate comercialã cu rãspundere limitatã","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("232","18817","188","URL - Intreprindere profesionala unipersonala cu rãspundere limitata (IPURL)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("233","17801","178","Empresa individual","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("234","17802","178","Asociación General","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("235","17803","178","Sociedad de Responsabilidad Limitada","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("236","17804","178","Sociedad Civil","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("237","17805","178","Sociedad Anónima","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("238","8001","80","Aktieselvskab A/S","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("239","8002","80","Anparts Selvskab ApS","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("240","8003","80","Personlig ejet selvskab","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("241","8004","80","Iværksætterselvskab IVS","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("242","8005","80","Interessentskab I/S","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("243","8006","80","Holdingselskab","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("244","8007","80","Selskab Med Begrænset Hæftelse SMBA","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("245","8008","80","Kommanditselskab K/S","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("246","8009","80","SPE-selskab","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("247","2001","20","Aktiebolag","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("248","2002","20","Publikt aktiebolag (AB publ)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("249","2003","20","Ekonomisk förening (ek. för.)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("250","2004","20","Bostadsrättsförening (BRF)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("251","2005","20","Hyresrättsförening (HRF)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("252","2006","20","Kooperativ","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("253","2007","20","Enskild firma (EF)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("254","2008","20","Handelsbolag (HB)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("255","2009","20","Kommanditbolag (KB)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("256","2010","20","Enkelt bolag","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("257","2011","20","Ideell förening","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("258","2012","20","Stiftelse","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("265","15407","154","610 - Residentes en el Extranjero sin Establecimiento Permanente en México","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("266","15408","154","611 - Ingresos por Dividendos (socios y accionistas)","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("267","15409","154","612 - Personas Físicas con Actividades Empresariales y Profesionales","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("268","15410","154","614 - Ingresos por intereses","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("269","15411","154","615 - Régimen de los ingresos por obtención de premios","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("270","15412","154","616 - Sin obligaciones fiscales","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("271","15413","154","620 - Sociedades Cooperativas de Producción que optan por diferir sus ingresos","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("272","15414","154","621 - Incorporación Fiscal","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("273","15415","154","622 - Actividades Agrícolas, Ganaderas, Silvícolas y Pesqueras","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("274","15416","154","623 - Opcional para Grupos de Sociedades","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("275","15417","154","624 - Coordinados","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("276","15418","154","625 - Régimen de las Actividades Empresariales con ingresos a través de Plataformas Tecnológicas","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("277","15419","154","626 - Régimen Simplificado de Confianza","0","1",NULL,"0");
INSERT INTO `llx_c_forme_juridique` VALUES("297","66","1","Société publique locale","0","1",NULL,"0");



DROP TABLE IF EXISTS `llx_c_holiday_types`;
CREATE TABLE `llx_c_holiday_types` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(16) NOT NULL,
  `label` varchar(255) NOT NULL,
  `affect` int NOT NULL,
  `delay` int NOT NULL,
  `newbymonth` double(8,5) NOT NULL DEFAULT '0.00000',
  `fk_country` int DEFAULT NULL,
  `block_if_negative` int NOT NULL DEFAULT '0',
  `active` int DEFAULT '1',
  `sortorder` smallint DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_holiday_types` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_holiday_types` VALUES("1","LEAVE_SICK","Sick leave","0","0","0.00000",NULL,"0","1",NULL);
INSERT INTO `llx_c_holiday_types` VALUES("2","LEAVE_OTHER","Other leave","0","0","0.00000",NULL,"0","1",NULL);
INSERT INTO `llx_c_holiday_types` VALUES("3","LEAVE_PAID","Paid vacation","1","7","0.00000",NULL,"0","0",NULL);
INSERT INTO `llx_c_holiday_types` VALUES("4","LEAVE_RTT_FR","RTT","1","7","0.83000","1","0","1",NULL);
INSERT INTO `llx_c_holiday_types` VALUES("5","LEAVE_PAID_FR","Paid vacation","1","30","2.08334","1","0","1",NULL);
INSERT INTO `llx_c_holiday_types` VALUES("6","5D1Y","???????? ?????(????????? 1? ????)","1","0","1.66700","102","0","1","6");
INSERT INTO `llx_c_holiday_types` VALUES("7","5D2Y","???????? ?????(????????? 2? ????)","1","0","1.75000","102","0","1","7");
INSERT INTO `llx_c_holiday_types` VALUES("8","5D3-10Y","???????? ?????(????????? 3? ??? 10? ????)","1","0","1.83300","102","0","1","8");
INSERT INTO `llx_c_holiday_types` VALUES("9","5D10-25Y","???????? ?????(????????? 10? ??? 25? ????)","1","0","2.08300","102","0","1","9");
INSERT INTO `llx_c_holiday_types` VALUES("10","5D25+Y","???????? ?????(????????? 25+ ???)","1","0","2.16600","102","0","1","10");
INSERT INTO `llx_c_holiday_types` VALUES("11","6D1Y","???????? ?????(???????? 1? ????)","1","0","2.00000","102","0","1","11");
INSERT INTO `llx_c_holiday_types` VALUES("12","6D2Y","???????? ?????(???????? 2? ????)","1","0","2.08300","102","0","1","12");
INSERT INTO `llx_c_holiday_types` VALUES("13","6D3-10Y","???????? ?????(???????? 3? ??? 10? ????)","1","0","2.16600","102","0","1","13");
INSERT INTO `llx_c_holiday_types` VALUES("14","6D10-25Y","???????? ?????(???????? 10? ??? 25? ????)","1","0","2.08300","102","0","1","14");
INSERT INTO `llx_c_holiday_types` VALUES("15","6D25+Y","???????? ?????(???????? 25+ ???)","1","0","2.16600","102","0","1","15");
INSERT INTO `llx_c_holiday_types` VALUES("16","5D-WED","????????? ????? ?????(?? ????????)","0","0","0.00000","102","0","0","16");
INSERT INTO `llx_c_holiday_types` VALUES("17","6D-WED","???????? ????? ?????(?? ????????)","0","0","0.00000","102","0","0","17");
INSERT INTO `llx_c_holiday_types` VALUES("18","7D-AR","????????? ????? ???????? ?????????????? ????????????(?? ????????)","0","0","0.00000","102","0","0","18");
INSERT INTO `llx_c_holiday_types` VALUES("19","1D-BC","????????? ????? ????????????? ?????????(?? ????????)","0","0","0.00000","102","0","0","19");
INSERT INTO `llx_c_holiday_types` VALUES("20","1D-GYN","????????? ????? ?????????????? ???????(?? ????????)","0","0","0.00000","102","0","0","20");
INSERT INTO `llx_c_holiday_types` VALUES("21","149D-ML","????? ?????????? (????? ?????? – ???????)56 ?????? ????-93 ?????? ????(?? ????????)","0","0","0.00000","102","0","0","21");
INSERT INTO `llx_c_holiday_types` VALUES("22","14D-PL","14????? ????? ??????????(?? ????????)","0","0","0.00000","102","0","0","22");
INSERT INTO `llx_c_holiday_types` VALUES("23","1-2H-CC","????? ????????? ??????? (???????? ??????  https://www.kepea.gr/aarticle.php?id=1984)","0","0","0.00000","102","0","0","23");
INSERT INTO `llx_c_holiday_types` VALUES("24","9M-M","?????? ????? ?????????? ?????????? 9 ?????(????? ????????)","0","0","0.00000","102","0","0","24");
INSERT INTO `llx_c_holiday_types` VALUES("25","4M-M","????????? ?????? ????? ????????? ??????(????? ????????)","0","0","0.00000","102","0","0","25");
INSERT INTO `llx_c_holiday_types` VALUES("26","6-8D-SP","???????? ? ????????? ????? ??? ???????????? ???????????(?? ????????)","0","0","0.00000","102","0","0","26");
INSERT INTO `llx_c_holiday_types` VALUES("27","6-8-14D-FC","????? ??? ???????? ????? ???????????(????? ????????, 6 ??????/???? ??? ????? - 8 ??????/???? ??? ?????? ??? ?? 14 ??????/???? ???? (3) ?????? ??? ????","0","0","0.00000","102","0","0","27");
INSERT INTO `llx_c_holiday_types` VALUES("28","10D-CD","????????? ?????? ????? ??? ????? ?? ?????? ???????? ??? ???? ????????? ???????(?? ????????)","0","0","0.00000","102","0","0","28");
INSERT INTO `llx_c_holiday_types` VALUES("29","30D-CD","????? ???? ????????? ??? ???????(??? 30 ??????/???? ????? ????????)","0","0","0.00000","102","0","0","29");
INSERT INTO `llx_c_holiday_types` VALUES("30","5D-CG","????? ?????????(??? 5 ??????/???? ????? ????????)","0","0","0.00000","102","0","0","30");
INSERT INTO `llx_c_holiday_types` VALUES("31","2D-CG","????? ???????? ??? ??? ??????? ??? ?????? ???????? ????(??? 2 ??????/???? ?? ????????)","0","0","0.00000","102","0","0","31");
INSERT INTO `llx_c_holiday_types` VALUES("32","2D-SC","????? ??? ????????????? ???????? ????????(??? 2 ??????/???? ?? ????????)","0","0","0.00000","102","0","0","32");
INSERT INTO `llx_c_holiday_types` VALUES("33","1D-BD","????????? ????? ??????????(?? ????????)","0","0","0.00000","102","0","0","33");
INSERT INTO `llx_c_holiday_types` VALUES("34","22D-BT","????? ??? ????????? ??????? & ???????????(??? 22 ??????/???? ?? ????????)","0","0","0.00000","102","0","0","34");
INSERT INTO `llx_c_holiday_types` VALUES("35","30D-HIV","????? ???? AIDS(??? ??? (1) ????/???? ?? ????????)","0","0","0.00000","102","0","0","35");
INSERT INTO `llx_c_holiday_types` VALUES("36","20D-CD","????? ?????????? ??????(20 ?????? ?? ????????)","0","0","0.00000","102","0","0","36");
INSERT INTO `llx_c_holiday_types` VALUES("37","2D-FD","????? ???? ??????? ?????????(2 ?????? ?? ????????)","0","0","0.00000","102","0","0","37");
INSERT INTO `llx_c_holiday_types` VALUES("38","DIS","?????? ????????(30 ?????? ?? ????????)","0","0","0.00000","102","0","0","38");
INSERT INTO `llx_c_holiday_types` VALUES("39","SE","????? ????????? ???????, ??????????, ????????(30 ?????? ????? ????????)","0","0","0.00000","102","0","0","39");
INSERT INTO `llx_c_holiday_types` VALUES("40","NOT PAID","????? ???? ????????(??? ??? (1) ????)","0","0","0.00000","102","0","0","40");



DROP TABLE IF EXISTS `llx_c_hrm_department`;
CREATE TABLE `llx_c_hrm_department` (
  `rowid` int NOT NULL,
  `pos` tinyint NOT NULL DEFAULT '0',
  `code` varchar(16) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_hrm_department` VALUES("1","5","MANAGEMENT","Management","1");
INSERT INTO `llx_c_hrm_department` VALUES("3","15","TRAINING","Training","1");
INSERT INTO `llx_c_hrm_department` VALUES("4","20","IT","Inform. Technology (IT)","0");
INSERT INTO `llx_c_hrm_department` VALUES("5","25","MARKETING","Marketing","0");
INSERT INTO `llx_c_hrm_department` VALUES("6","30","SALES","Sales","1");
INSERT INTO `llx_c_hrm_department` VALUES("7","35","LEGAL","Legal","0");
INSERT INTO `llx_c_hrm_department` VALUES("8","40","FINANCIAL","Financial accounting","1");
INSERT INTO `llx_c_hrm_department` VALUES("9","45","HUMANRES","Human resources","1");
INSERT INTO `llx_c_hrm_department` VALUES("10","50","PURCHASING","Purchasing","1");
INSERT INTO `llx_c_hrm_department` VALUES("12","60","CUSTOMSERV","Customer service","0");
INSERT INTO `llx_c_hrm_department` VALUES("14","70","LOGISTIC","Logistics","1");
INSERT INTO `llx_c_hrm_department` VALUES("15","75","CONSTRUCT","Engineering/design","0");
INSERT INTO `llx_c_hrm_department` VALUES("16","80","PRODUCTION","Production","1");
INSERT INTO `llx_c_hrm_department` VALUES("17","85","QUALITY","Quality assurance","0");



DROP TABLE IF EXISTS `llx_c_hrm_function`;
CREATE TABLE `llx_c_hrm_function` (
  `rowid` int NOT NULL,
  `pos` tinyint NOT NULL DEFAULT '0',
  `code` varchar(16) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `c_level` tinyint NOT NULL DEFAULT '0',
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_hrm_function` VALUES("1","5","EXECBOARD","Executive board","0","1");
INSERT INTO `llx_c_hrm_function` VALUES("2","10","MANAGDIR","Managing director","1","1");
INSERT INTO `llx_c_hrm_function` VALUES("3","15","ACCOUNTMANAG","Account manager","0","1");
INSERT INTO `llx_c_hrm_function` VALUES("4","20","ENGAGDIR","Engagement director","1","1");
INSERT INTO `llx_c_hrm_function` VALUES("5","25","DIRECTOR","Director","1","1");
INSERT INTO `llx_c_hrm_function` VALUES("6","30","PROJMANAG","Project manager","0","1");
INSERT INTO `llx_c_hrm_function` VALUES("7","35","DEPHEAD","Department head","0","1");
INSERT INTO `llx_c_hrm_function` VALUES("8","40","SECRETAR","Secretary","0","1");
INSERT INTO `llx_c_hrm_function` VALUES("9","45","EMPLOYEE","Department employee","0","1");



DROP TABLE IF EXISTS `llx_c_hrm_public_holiday`;
CREATE TABLE `llx_c_hrm_public_holiday` (
  `id` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '0',
  `fk_country` int DEFAULT NULL,
  `code` varchar(62) DEFAULT NULL,
  `dayrule` varchar(64) DEFAULT '',
  `day` int DEFAULT NULL,
  `month` int DEFAULT NULL,
  `year` int DEFAULT NULL,
  `active` int DEFAULT '1',
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_hrm_public_holiday` (`entity`,`code`),
  UNIQUE KEY `uk_c_hrm_public_holiday2` (`entity`,`fk_country`,`dayrule`,`day`,`month`,`year`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_hrm_public_holiday` VALUES("1","0","0","NEWYEARDAY1","","1","1","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("2","0","0","LABORDAY1","","1","5","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("3","0","0","ASSOMPTIONDAY1","","15","8","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("4","0","0","CHRISTMASDAY1","","25","12","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("5","0","1","FR-VICTORYDAY","","8","5","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("6","0","1","FR-NATIONALDAY","","14","7","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("7","0","1","FR-ASSOMPTION","","15","8","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("8","0","1","FR-TOUSSAINT","","1","11","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("9","0","1","FR-ARMISTICE","","11","11","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("10","0","1","FR-EASTER","eastermonday","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("11","0","1","FR-ASCENSION","ascension","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("12","0","1","FR-PENTECOST","pentecost","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("13","0","3","IT-LIBEAZIONE","","25","4","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("14","0","3","IT-EPIPHANY","","1","6","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("15","0","3","IT-REPUBBLICA","","2","6","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("16","0","3","IT-TUTTISANTIT","","1","11","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("17","0","3","IT-IMMACULE","","8","12","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("18","0","3","IT-SAINTSTEFAN","","26","12","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("19","0","4","ES-EASTER","easter","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("20","0","4","ES-REYE","","1","6","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("21","0","4","ES-HISPANIDAD","","12","10","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("22","0","4","ES-TOUSSAINT","","1","11","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("23","0","4","ES-CONSTITUIZION","","6","12","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("24","0","4","ES-IMMACULE","","8","12","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("25","0","41","AT-EASTER","eastermonday","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("26","0","41","AT-ASCENSION","ascension","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("27","0","41","AT-PENTECOST","pentecost","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("28","0","41","AT-FRONLEICHNAM","fronleichnam","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("29","0","41","AT-KONEGIE","","1","6","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("30","0","41","AT-26OKT","","26","10","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("31","0","41","AT-TOUSSAINT","","1","11","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("32","0","41","AT-IMMACULE","","8","12","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("33","0","41","AT-24DEC","","24","12","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("34","0","41","AT-SAINTSTEFAN","","26","12","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("35","0","41","AT-Silvester","","31","12","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("36","0","117","IN-REPUBLICDAY","","26","1","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("37","0","117","IN-GANDI","","2","10","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("38","0","2","BE-VICTORYDAY","","8","5","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("39","0","2","BE-NATIONALDAY","","21","7","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("40","0","2","BE-ASSOMPTION","","15","8","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("41","0","2","BE-TOUSSAINT","","1","11","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("42","0","2","BE-ARMISTICE","","11","11","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("43","0","2","BE-EASTER","eastermonday","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("44","0","2","BE-ASCENSION","ascension","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("45","0","2","BE-PENTECOST","pentecost","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("46","0","102","GR-???????????","","1","1","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("47","0","102","GR-?????????","","6","1","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("48","0","102","GR-25? ???????","","25","3","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("49","0","102","GR-??????????","","1","5","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("50","0","102","GR-?????? ???????","??????_???????","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("51","0","102","GR-?????? ?????????","??????_?????????","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("52","0","102","GR-??????? ??? ?????","???????_???_?????","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("53","0","102","GR-??? ????? ?????????","???_?????_?????????","0","0","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("54","0","102","GR-??????? ??? ????????","","15","8","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("55","0","102","GR-28? ?????????","","28","10","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("56","0","102","GR-????????????","","25","12","0","1",NULL);
INSERT INTO `llx_c_hrm_public_holiday` VALUES("57","0","102","GR-?????? ????????","","26","12","0","1",NULL);



DROP TABLE IF EXISTS `llx_c_incoterms`;
CREATE TABLE `llx_c_incoterms` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(3) NOT NULL,
  `libelle` varchar(255) NOT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `label` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_incoterms` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_incoterms` VALUES("1","EXW","Ex Works, au départ non chargé, non dédouané sortie d\'usine (uniquement adapté aux flux domestiques, nationaux)","1",NULL);
INSERT INTO `llx_c_incoterms` VALUES("2","FCA","Free Carrier, marchandises dédouanées et chargées dans le pays de départ, chez le vendeur ou chez le commissionnaire de transport de l\'acheteur","1",NULL);
INSERT INTO `llx_c_incoterms` VALUES("3","FAS","Free Alongside Ship, sur le quai du port de départ","1",NULL);
INSERT INTO `llx_c_incoterms` VALUES("4","FOB","Free On Board, chargé sur le bateau, les frais de chargement dans celui-ci étant fonction du liner term indiqué par la compagnie maritime (à la charge du vendeur)","1",NULL);
INSERT INTO `llx_c_incoterms` VALUES("5","CFR","Cost and Freight, chargé dans le bateau, livraison au port de départ, frais payés jusqu\'au port d\'arrivée, sans assurance pour le transport, non déchargé du navire à destination (les frais de déchargement sont inclus ou non au port d\'arrivée)","1",NULL);
INSERT INTO `llx_c_incoterms` VALUES("6","CIF","Cost, Insurance and Freight, chargé sur le bateau, frais jusqu\'au port d\'arrivée, avec l\'assurance marchandise transportée souscrite par le vendeur pour le compte de l\'acheteur","1",NULL);
INSERT INTO `llx_c_incoterms` VALUES("7","CPT","Carriage Paid To, livraison au premier transporteur, frais jusqu\'au déchargement du mode de transport, sans assurance pour le transport","1",NULL);
INSERT INTO `llx_c_incoterms` VALUES("8","CIP","Carriage and Insurance Paid to, idem CPT, avec assurance marchandise transportée souscrite par le vendeur pour le compte de l\'acheteur","1",NULL);
INSERT INTO `llx_c_incoterms` VALUES("9","DAT","Delivered At Terminal, marchandises (déchargées) livrées sur quai, dans un terminal maritime, fluvial, aérien, routier ou ferroviaire désigné (dédouanement import, et post-acheminement payés par l\'acheteur)","1",NULL);
INSERT INTO `llx_c_incoterms` VALUES("10","DAP","Delivered At Place, marchandises (non déchargées) mises à disposition de l\'acheteur dans le pays d\'importation au lieu précisé dans le contrat (déchargement, dédouanement import payé par l\'acheteur)","1",NULL);
INSERT INTO `llx_c_incoterms` VALUES("11","DDP","Delivered Duty Paid, marchandises (non déchargées) livrées à destination finale, dédouanement import et taxes à la charge du vendeur ; l\'acheteur prend en charge uniquement le déchargement (si exclusion des taxes type TVA, le préciser clairement)","1",NULL);



DROP TABLE IF EXISTS `llx_c_input_method`;
CREATE TABLE `llx_c_input_method` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(30) DEFAULT NULL,
  `libelle` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_input_method` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_input_method` VALUES("1","OrderByMail","Courrier","1",NULL);
INSERT INTO `llx_c_input_method` VALUES("2","OrderByFax","Fax","1",NULL);
INSERT INTO `llx_c_input_method` VALUES("3","OrderByEMail","EMail","1",NULL);
INSERT INTO `llx_c_input_method` VALUES("4","OrderByPhone","Téléphone","1",NULL);
INSERT INTO `llx_c_input_method` VALUES("5","OrderByWWW","En ligne","1",NULL);



DROP TABLE IF EXISTS `llx_c_input_reason`;
CREATE TABLE `llx_c_input_reason` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(30) DEFAULT NULL,
  `label` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_input_reason` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_input_reason` VALUES("1","SRC_INTE","Web site","1",NULL);
INSERT INTO `llx_c_input_reason` VALUES("2","SRC_CAMP_MAIL","Mailing campaign","1",NULL);
INSERT INTO `llx_c_input_reason` VALUES("3","SRC_CAMP_PHO","Phone campaign","1",NULL);
INSERT INTO `llx_c_input_reason` VALUES("4","SRC_CAMP_FAX","Fax campaign","1",NULL);
INSERT INTO `llx_c_input_reason` VALUES("5","SRC_COMM","Commercial contact","1",NULL);
INSERT INTO `llx_c_input_reason` VALUES("6","SRC_SHOP","Shop contact","1",NULL);
INSERT INTO `llx_c_input_reason` VALUES("7","SRC_CAMP_EMAIL","EMailing campaign","1",NULL);
INSERT INTO `llx_c_input_reason` VALUES("8","SRC_WOM","Word of mouth","1",NULL);
INSERT INTO `llx_c_input_reason` VALUES("9","SRC_PARTNER","Partner","1",NULL);
INSERT INTO `llx_c_input_reason` VALUES("10","SRC_EMPLOYEE","Employee","1",NULL);
INSERT INTO `llx_c_input_reason` VALUES("11","SRC_SPONSORING","Sponsorship","1",NULL);



DROP TABLE IF EXISTS `llx_c_invoice_subtype`;
CREATE TABLE `llx_c_invoice_subtype` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `fk_country` int NOT NULL,
  `code` varchar(5) NOT NULL,
  `label` varchar(100) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_invoice_subtype` (`entity`,`code`,`fk_country`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_invoice_subtype` VALUES("1","1","102","1.1","????????? ???????","1");
INSERT INTO `llx_c_invoice_subtype` VALUES("2","1","102","1.2","????????? ??????? / ?????????????? ??????????","1");
INSERT INTO `llx_c_invoice_subtype` VALUES("3","1","102","1.3","????????? ??????? / ?????????? ?????? ?????","1");
INSERT INTO `llx_c_invoice_subtype` VALUES("4","1","102","1.4","????????? ??????? / ?????? ??? ?????????? ??????","0");
INSERT INTO `llx_c_invoice_subtype` VALUES("5","1","102","1.5","????????? ??????? / ?????????? ???????? ?????? - ?????? ??? ???????? ??????","0");
INSERT INTO `llx_c_invoice_subtype` VALUES("6","1","102","1.6","????????? ??????? / ?????????????? ???????????","0");
INSERT INTO `llx_c_invoice_subtype` VALUES("7","1","102","2.1","????????? ???????","1");
INSERT INTO `llx_c_invoice_subtype` VALUES("8","1","102","2.2","????????? ??????? / ????????????? ?????? ?????????","1");
INSERT INTO `llx_c_invoice_subtype` VALUES("9","1","102","2.3","????????? ??????? / ?????? ????????? ?? ????? ?????? ?????","1");
INSERT INTO `llx_c_invoice_subtype` VALUES("10","1","102","2.4","????????? ??????? / ?????????????? ???????????","0");
INSERT INTO `llx_c_invoice_subtype` VALUES("11","1","102","3.1","?????? ?????? (?? ???????? ???????)","0");
INSERT INTO `llx_c_invoice_subtype` VALUES("12","1","102","3.2","?????? ?????? (?????? ??????? ??? ??????? ??????)","0");
INSERT INTO `llx_c_invoice_subtype` VALUES("13","1","102","6.1","???????? ?????????????","0");
INSERT INTO `llx_c_invoice_subtype` VALUES("14","1","102","6.2","???????? ??????????????????","0");
INSERT INTO `llx_c_invoice_subtype` VALUES("15","1","102","7.1","????????? - ?????","0");
INSERT INTO `llx_c_invoice_subtype` VALUES("16","1","102","8.1","??????? - ?????","0");
INSERT INTO `llx_c_invoice_subtype` VALUES("17","1","102","8.2","?????? ???????? – ????????? ????????? ????? ????????","0");
INSERT INTO `llx_c_invoice_subtype` VALUES("18","1","102","11.1","???","1");
INSERT INTO `llx_c_invoice_subtype` VALUES("19","1","102","11.2","???","1");
INSERT INTO `llx_c_invoice_subtype` VALUES("20","1","102","11.3","???????????? ?????????","0");
INSERT INTO `llx_c_invoice_subtype` VALUES("21","1","102","11.5","???????? ???????? ??????? ??? ???/??? ??????","0");
INSERT INTO `llx_c_invoice_subtype` VALUES("22","1","102","5.1","????????? ????????? / ?????????????","0");
INSERT INTO `llx_c_invoice_subtype` VALUES("23","1","102","5.2","????????? ????????? / ?? ?????????????","1");
INSERT INTO `llx_c_invoice_subtype` VALUES("24","1","102","11.4","????????? ?????. ????????","1");



DROP TABLE IF EXISTS `llx_c_lead_status`;
CREATE TABLE `llx_c_lead_status` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(10) DEFAULT NULL,
  `label` varchar(128) DEFAULT NULL,
  `position` int DEFAULT NULL,
  `percent` double(5,2) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_lead_status_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_lead_status` VALUES("1","PROSP","Prospection","10","0.00","1");
INSERT INTO `llx_c_lead_status` VALUES("2","QUAL","Qualification","20","20.00","1");
INSERT INTO `llx_c_lead_status` VALUES("3","PROPO","Proposal","30","40.00","1");
INSERT INTO `llx_c_lead_status` VALUES("4","NEGO","Negotiation","40","60.00","1");
INSERT INTO `llx_c_lead_status` VALUES("5","PENDING","Pending","50","50.00","0");
INSERT INTO `llx_c_lead_status` VALUES("6","WON","Won","60","100.00","1");
INSERT INTO `llx_c_lead_status` VALUES("7","LOST","Lost","70","0.00","1");



DROP TABLE IF EXISTS `llx_c_paiement`;
CREATE TABLE `llx_c_paiement` (
  `id` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `code` varchar(6) NOT NULL,
  `libelle` varchar(128) DEFAULT NULL,
  `type` smallint DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `accountancy_code` varchar(32) DEFAULT NULL,
  `module` varchar(32) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_paiement_code` (`entity`,`code`)
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_paiement` VALUES("1","1","TIP","TIP","2","0",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("2","1","VIR","Transfer","2","1",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("3","1","PRE","Debit order","2","1",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("4","1","LIQ","Cash","2","1",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("6","1","CB","Credit card","2","1",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("7","1","CHQ","Cheque","2","1",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("50","1","VAD","Online payment","2","0",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("51","1","TRA","Traite","2","0",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("52","1","LCR","LCR","2","0",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("53","1","FAC","Factor","2","0",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("54","1","VIR2","Virement bancaire.","0","0",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("55","1","PAYPAL","Paypal","2","1",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("100","1","KLA","Klarna","1","0",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("101","1","SOF","Sofort","1","0",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("102","1","BANCON","Bancontact","1","0",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("103","1","IDE","iDeal","1","0",NULL,NULL,"0");
INSERT INTO `llx_c_paiement` VALUES("104","1","GIR","Giropay","1","0",NULL,NULL,"0");



DROP TABLE IF EXISTS `llx_c_paper_format`;
CREATE TABLE `llx_c_paper_format` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(16) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `width` float(6,2) DEFAULT '0.00',
  `height` float(6,2) DEFAULT '0.00',
  `unit` varchar(5) NOT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=226 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_paper_format` VALUES("1","EU4A0","Format 4A0","1682.00","2378.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("2","EU2A0","Format 2A0","1189.00","1682.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("3","EUA0","Format A0","840.00","1189.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("4","EUA1","Format A1","594.00","840.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("5","EUA2","Format A2","420.00","594.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("6","EUA3","Format A3","297.00","420.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("7","EUA4","Format A4","210.00","297.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("8","EUA5","Format A5","148.00","210.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("9","EUA6","Format A6","105.00","148.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("100","USLetter","Format Letter (A)","216.00","279.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("105","USLegal","Format Legal","216.00","356.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("110","USExecutive","Format Executive","190.00","254.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("115","USLedger","Format Ledger/Tabloid (B)","279.00","432.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("200","CAP1","Format Canadian P1","560.00","860.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("205","CAP2","Format Canadian P2","430.00","560.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("210","CAP3","Format Canadian P3","280.00","430.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("215","CAP4","Format Canadian P4","215.00","280.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("220","CAP5","Format Canadian P5","140.00","215.00","mm","1",NULL);
INSERT INTO `llx_c_paper_format` VALUES("225","CAP6","Format Canadian P6","107.00","140.00","mm","1",NULL);



DROP TABLE IF EXISTS `llx_c_partnership_type`;
CREATE TABLE `llx_c_partnership_type` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `code` varchar(32) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `keyword` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_partnership_type` (`entity`,`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_c_payment_term`;
CREATE TABLE `llx_c_payment_term` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `code` varchar(16) DEFAULT NULL,
  `sortorder` smallint DEFAULT NULL,
  `active` tinyint DEFAULT '1',
  `libelle` varchar(255) DEFAULT NULL,
  `libelle_facture` text,
  `type_cdr` tinyint DEFAULT NULL,
  `nbjour` smallint DEFAULT NULL,
  `decalage` smallint DEFAULT NULL,
  `deposit_percent` varchar(63) DEFAULT NULL,
  `module` varchar(32) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_payment_term_code` (`entity`,`code`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_payment_term` VALUES("1","1","RECEP","1","1","Due upon receipt","Due upon receipt","0","1",NULL,NULL,NULL,"0");
INSERT INTO `llx_c_payment_term` VALUES("2","1","30D","2","1","30 days","Due in 30 days","0","30",NULL,NULL,NULL,"0");
INSERT INTO `llx_c_payment_term` VALUES("3","1","30DENDMONTH","3","1","30 days end of month","Due in 30 days, end of month","1","30",NULL,NULL,NULL,"0");
INSERT INTO `llx_c_payment_term` VALUES("4","1","60D","4","1","60 days","Due in 60 days, end of month","0","60",NULL,NULL,NULL,"0");
INSERT INTO `llx_c_payment_term` VALUES("5","1","60DENDMONTH","5","1","60 days end of month","Due in 60 days, end of month","1","60",NULL,NULL,NULL,"0");
INSERT INTO `llx_c_payment_term` VALUES("6","1","PT_ORDER","6","1","Due on order","Due on order","0","1",NULL,NULL,NULL,"0");
INSERT INTO `llx_c_payment_term` VALUES("7","1","PT_DELIVERY","7","1","Due on delivery","Due on delivery","0","1",NULL,NULL,NULL,"0");
INSERT INTO `llx_c_payment_term` VALUES("8","1","PT_5050","8","1","50 and 50","50% on order, 50% on delivery","0","1",NULL,NULL,NULL,"0");
INSERT INTO `llx_c_payment_term` VALUES("9","1","10D","9","1","10 days","Due in 10 days","0","10",NULL,NULL,NULL,"0");
INSERT INTO `llx_c_payment_term` VALUES("10","1","10DENDMONTH","10","1","10 days end of month","Due in 10 days, end of month","1","10",NULL,NULL,NULL,"0");
INSERT INTO `llx_c_payment_term` VALUES("11","1","14D","11","1","14 days","Due in 14 days","0","14",NULL,NULL,NULL,"0");
INSERT INTO `llx_c_payment_term` VALUES("12","1","14DENDMONTH","12","1","14 days end of month","Due in 14 days, end of month","1","14",NULL,NULL,NULL,"0");
INSERT INTO `llx_c_payment_term` VALUES("13","1","DEP30PCTDEL","13","0","__DEPOSIT_PERCENT__% deposit","__DEPOSIT_PERCENT__% deposit, remainder on delivery","0","1",NULL,"30",NULL,"0");



DROP TABLE IF EXISTS `llx_c_price_expression`;
CREATE TABLE `llx_c_price_expression` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `title` varchar(20) NOT NULL,
  `expression` varchar(255) NOT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_c_price_global_variable`;
CREATE TABLE `llx_c_price_global_variable` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL,
  `description` text,
  `value` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_c_price_global_variable_updater`;
CREATE TABLE `llx_c_price_global_variable_updater` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `type` int NOT NULL,
  `description` text,
  `parameters` text,
  `fk_variable` int NOT NULL,
  `update_interval` int DEFAULT '0',
  `next_update` int DEFAULT '0',
  `last_status` text,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_c_product_nature`;
CREATE TABLE `llx_c_product_nature` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` tinyint NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_product_nature` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_product_nature` VALUES("1","0","RowMaterial","1");
INSERT INTO `llx_c_product_nature` VALUES("2","1","Finished","1");



DROP TABLE IF EXISTS `llx_c_productbatch_qcstatus`;
CREATE TABLE `llx_c_productbatch_qcstatus` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `code` varchar(16) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `active` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_productbatch_qcstatus` (`code`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_productbatch_qcstatus` VALUES("1","1","OK","InWorkingOrder","1");
INSERT INTO `llx_c_productbatch_qcstatus` VALUES("2","1","KO","OutOfOrder","1");



DROP TABLE IF EXISTS `llx_c_propalst`;
CREATE TABLE `llx_c_propalst` (
  `id` smallint NOT NULL,
  `code` varchar(12) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `sortorder` smallint DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_propalst` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_propalst` VALUES("0","PR_DRAFT","Brouillon","1","0");
INSERT INTO `llx_c_propalst` VALUES("1","PR_OPEN","Ouverte","1","0");
INSERT INTO `llx_c_propalst` VALUES("2","PR_SIGNED","Signée","1","0");
INSERT INTO `llx_c_propalst` VALUES("3","PR_NOTSIGNED","Non Signée","1","0");
INSERT INTO `llx_c_propalst` VALUES("4","PR_FAC","Facturée","1","0");



DROP TABLE IF EXISTS `llx_c_prospectcontactlevel`;
CREATE TABLE `llx_c_prospectcontactlevel` (
  `code` varchar(12) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `sortorder` smallint DEFAULT NULL,
  `active` smallint NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_prospectcontactlevel` VALUES("PL_HIGH","High","4","1",NULL);
INSERT INTO `llx_c_prospectcontactlevel` VALUES("PL_LOW","Low","2","1",NULL);
INSERT INTO `llx_c_prospectcontactlevel` VALUES("PL_MEDIUM","Medium","3","1",NULL);
INSERT INTO `llx_c_prospectcontactlevel` VALUES("PL_NONE","None","1","1",NULL);



DROP TABLE IF EXISTS `llx_c_prospectlevel`;
CREATE TABLE `llx_c_prospectlevel` (
  `code` varchar(12) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `sortorder` smallint DEFAULT NULL,
  `active` smallint NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_prospectlevel` VALUES("PL_HIGH","High","4","1",NULL);
INSERT INTO `llx_c_prospectlevel` VALUES("PL_LOW","Low","2","1",NULL);
INSERT INTO `llx_c_prospectlevel` VALUES("PL_MEDIUM","Medium","3","1",NULL);
INSERT INTO `llx_c_prospectlevel` VALUES("PL_NONE","None","1","1",NULL);



DROP TABLE IF EXISTS `llx_c_recruitment_origin`;
CREATE TABLE `llx_c_recruitment_origin` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_c_regions`;
CREATE TABLE `llx_c_regions` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code_region` int NOT NULL,
  `fk_pays` int NOT NULL,
  `cheflieu` varchar(50) DEFAULT NULL,
  `tncc` int DEFAULT NULL,
  `nom` varchar(100) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_code_region` (`code_region`),
  KEY `idx_c_regions_fk_pays` (`fk_pays`),
  CONSTRAINT `fk_c_regions_fk_pays` FOREIGN KEY (`fk_pays`) REFERENCES `llx_c_country` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=236 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_regions` VALUES("1","0","0","0","0","-","1");
INSERT INTO `llx_c_regions` VALUES("2","1","1","97105","3","Guadeloupe","1");
INSERT INTO `llx_c_regions` VALUES("3","2","1","97209","3","Martinique","1");
INSERT INTO `llx_c_regions` VALUES("4","3","1","97302","3","Guyane","1");
INSERT INTO `llx_c_regions` VALUES("5","4","1","97411","3","Réunion","1");
INSERT INTO `llx_c_regions` VALUES("6","6","1","97601","3","Mayotte","1");
INSERT INTO `llx_c_regions` VALUES("7","11","1","75056","1","Île-de-France","1");
INSERT INTO `llx_c_regions` VALUES("11","24","1","45234","2","Centre-Val de Loire","1");
INSERT INTO `llx_c_regions` VALUES("18","52","1","44109","4","Pays de la Loire","1");
INSERT INTO `llx_c_regions` VALUES("19","53","1","35238","0","Bretagne","1");
INSERT INTO `llx_c_regions` VALUES("27","93","1","13055","0","Provence-Alpes-Côte d\'Azur","1");
INSERT INTO `llx_c_regions` VALUES("28","94","1","2A004","0","Corse","1");
INSERT INTO `llx_c_regions` VALUES("29","4101","41","","0","Österreich","1");
INSERT INTO `llx_c_regions` VALUES("30","201","2","","1","Flandre","1");
INSERT INTO `llx_c_regions` VALUES("31","202","2","","2","Wallonie","1");
INSERT INTO `llx_c_regions` VALUES("32","203","2","","3","Bruxelles-Capitale","1");
INSERT INTO `llx_c_regions` VALUES("33","301","3",NULL,"1","Abruzzo","1");
INSERT INTO `llx_c_regions` VALUES("34","302","3",NULL,"1","Basilicata","1");
INSERT INTO `llx_c_regions` VALUES("35","303","3",NULL,"1","Calabria","1");
INSERT INTO `llx_c_regions` VALUES("36","304","3",NULL,"1","Campania","1");
INSERT INTO `llx_c_regions` VALUES("37","305","3",NULL,"1","Emilia-Romagna","1");
INSERT INTO `llx_c_regions` VALUES("38","306","3",NULL,"1","Friuli-Venezia Giulia","1");
INSERT INTO `llx_c_regions` VALUES("39","307","3",NULL,"1","Lazio","1");
INSERT INTO `llx_c_regions` VALUES("40","308","3",NULL,"1","Liguria","1");
INSERT INTO `llx_c_regions` VALUES("41","309","3",NULL,"1","Lombardia","1");
INSERT INTO `llx_c_regions` VALUES("42","310","3",NULL,"1","Marche","1");
INSERT INTO `llx_c_regions` VALUES("43","311","3",NULL,"1","Molise","1");
INSERT INTO `llx_c_regions` VALUES("44","312","3",NULL,"1","Piemonte","1");
INSERT INTO `llx_c_regions` VALUES("45","313","3",NULL,"1","Puglia","1");
INSERT INTO `llx_c_regions` VALUES("46","314","3",NULL,"1","Sardegna","1");
INSERT INTO `llx_c_regions` VALUES("47","315","3",NULL,"1","Sicilia","1");
INSERT INTO `llx_c_regions` VALUES("48","316","3",NULL,"1","Toscana","1");
INSERT INTO `llx_c_regions` VALUES("49","317","3",NULL,"1","Trentino-Alto Adige","1");
INSERT INTO `llx_c_regions` VALUES("50","318","3",NULL,"1","Umbria","1");
INSERT INTO `llx_c_regions` VALUES("51","319","3",NULL,"1","Valle d Aosta","1");
INSERT INTO `llx_c_regions` VALUES("52","320","3",NULL,"1","Veneto","1");
INSERT INTO `llx_c_regions` VALUES("53","401","4","","0","Andalucia","1");
INSERT INTO `llx_c_regions` VALUES("54","402","4","","0","Aragón","1");
INSERT INTO `llx_c_regions` VALUES("55","403","4","","0","Castilla y León","1");
INSERT INTO `llx_c_regions` VALUES("56","404","4","","0","Castilla la Mancha","1");
INSERT INTO `llx_c_regions` VALUES("57","405","4","","0","Canarias","1");
INSERT INTO `llx_c_regions` VALUES("58","406","4","","0","Cataluña","1");
INSERT INTO `llx_c_regions` VALUES("59","407","4","","0","Comunidad de Ceuta","1");
INSERT INTO `llx_c_regions` VALUES("60","408","4","","0","Comunidad Foral de Navarra","1");
INSERT INTO `llx_c_regions` VALUES("61","409","4","","0","Comunidad de Melilla","1");
INSERT INTO `llx_c_regions` VALUES("62","410","4","","0","Cantabria","1");
INSERT INTO `llx_c_regions` VALUES("63","411","4","","0","Comunidad Valenciana","1");
INSERT INTO `llx_c_regions` VALUES("64","412","4","","0","Extemadura","1");
INSERT INTO `llx_c_regions` VALUES("65","413","4","","0","Galicia","1");
INSERT INTO `llx_c_regions` VALUES("66","414","4","","0","Islas Baleares","1");
INSERT INTO `llx_c_regions` VALUES("67","415","4","","0","La Rioja","1");
INSERT INTO `llx_c_regions` VALUES("68","416","4","","0","Comunidad de Madrid","1");
INSERT INTO `llx_c_regions` VALUES("69","417","4","","0","Región de Murcia","1");
INSERT INTO `llx_c_regions` VALUES("70","418","4","","0","Principado de Asturias","1");
INSERT INTO `llx_c_regions` VALUES("71","419","4","","0","Pais Vasco","1");
INSERT INTO `llx_c_regions` VALUES("72","420","4","","0","Otros","1");
INSERT INTO `llx_c_regions` VALUES("73","501","5","","0","Deutschland","1");
INSERT INTO `llx_c_regions` VALUES("74","10201","102",NULL,NULL,"??????","1");
INSERT INTO `llx_c_regions` VALUES("75","10202","102",NULL,NULL,"?????? ??????","1");
INSERT INTO `llx_c_regions` VALUES("76","10203","102",NULL,NULL,"???????? ?????????","1");
INSERT INTO `llx_c_regions` VALUES("77","10204","102",NULL,NULL,"?????","1");
INSERT INTO `llx_c_regions` VALUES("78","10205","102",NULL,NULL,"????????? ????????? ??? ?????","1");
INSERT INTO `llx_c_regions` VALUES("79","10206","102",NULL,NULL,"???????","1");
INSERT INTO `llx_c_regions` VALUES("80","10207","102",NULL,NULL,"????? ?????","1");
INSERT INTO `llx_c_regions` VALUES("81","10208","102",NULL,NULL,"?????? ??????","1");
INSERT INTO `llx_c_regions` VALUES("82","10209","102",NULL,NULL,"????????????","1");
INSERT INTO `llx_c_regions` VALUES("83","10210","102",NULL,NULL,"????? ??????","1");
INSERT INTO `llx_c_regions` VALUES("84","10211","102",NULL,NULL,"?????? ??????","1");
INSERT INTO `llx_c_regions` VALUES("85","10212","102",NULL,NULL,"????????","1");
INSERT INTO `llx_c_regions` VALUES("86","10213","102",NULL,NULL,"?????? ?????????","1");
INSERT INTO `llx_c_regions` VALUES("87","601","6","","1","Cantons","1");
INSERT INTO `llx_c_regions` VALUES("88","701","7","","0","England","1");
INSERT INTO `llx_c_regions` VALUES("89","702","7","","0","Wales","1");
INSERT INTO `llx_c_regions` VALUES("90","703","7","","0","Scotland","1");
INSERT INTO `llx_c_regions` VALUES("91","704","7","","0","Northern Ireland","1");
INSERT INTO `llx_c_regions` VALUES("92","1001","10","","0","Ariana","1");
INSERT INTO `llx_c_regions` VALUES("93","1002","10","","0","Béja","1");
INSERT INTO `llx_c_regions` VALUES("94","1003","10","","0","Ben Arous","1");
INSERT INTO `llx_c_regions` VALUES("95","1004","10","","0","Bizerte","1");
INSERT INTO `llx_c_regions` VALUES("96","1005","10","","0","Gabès","1");
INSERT INTO `llx_c_regions` VALUES("97","1006","10","","0","Gafsa","1");
INSERT INTO `llx_c_regions` VALUES("98","1007","10","","0","Jendouba","1");
INSERT INTO `llx_c_regions` VALUES("99","1008","10","","0","Kairouan","1");
INSERT INTO `llx_c_regions` VALUES("100","1009","10","","0","Kasserine","1");
INSERT INTO `llx_c_regions` VALUES("101","1010","10","","0","Kébili","1");
INSERT INTO `llx_c_regions` VALUES("102","1011","10","","0","La Manouba","1");
INSERT INTO `llx_c_regions` VALUES("103","1012","10","","0","Le Kef","1");
INSERT INTO `llx_c_regions` VALUES("104","1013","10","","0","Mahdia","1");
INSERT INTO `llx_c_regions` VALUES("105","1014","10","","0","Médenine","1");
INSERT INTO `llx_c_regions` VALUES("106","1015","10","","0","Monastir","1");
INSERT INTO `llx_c_regions` VALUES("107","1016","10","","0","Nabeul","1");
INSERT INTO `llx_c_regions` VALUES("108","1017","10","","0","Sfax","1");
INSERT INTO `llx_c_regions` VALUES("109","1018","10","","0","Sidi Bouzid","1");
INSERT INTO `llx_c_regions` VALUES("110","1019","10","","0","Siliana","1");
INSERT INTO `llx_c_regions` VALUES("111","1020","10","","0","Sousse","1");
INSERT INTO `llx_c_regions` VALUES("112","1021","10","","0","Tataouine","1");
INSERT INTO `llx_c_regions` VALUES("113","1022","10","","0","Tozeur","1");
INSERT INTO `llx_c_regions` VALUES("114","1023","10","","0","Tunis","1");
INSERT INTO `llx_c_regions` VALUES("115","1024","10","","0","Zaghouan","1");
INSERT INTO `llx_c_regions` VALUES("116","1101","11","","0","United-States","1");
INSERT INTO `llx_c_regions` VALUES("117","1301","13","","0","Algerie","1");
INSERT INTO `llx_c_regions` VALUES("118","1401","14","","0","Canada","1");
INSERT INTO `llx_c_regions` VALUES("119","1701","17","","0","Provincies van Nederland ","1");
INSERT INTO `llx_c_regions` VALUES("120","2301","23","","0","Norte","1");
INSERT INTO `llx_c_regions` VALUES("121","2302","23","","0","Litoral","1");
INSERT INTO `llx_c_regions` VALUES("122","2303","23","","0","Cuyana","1");
INSERT INTO `llx_c_regions` VALUES("123","2304","23","","0","Central","1");
INSERT INTO `llx_c_regions` VALUES("124","2305","23","","0","Patagonia","1");
INSERT INTO `llx_c_regions` VALUES("125","2801","28","","0","Australia","1");
INSERT INTO `llx_c_regions` VALUES("126","4601","46","","0","Barbados","1");
INSERT INTO `llx_c_regions` VALUES("127","5201","52","","0","Chuquisaca","1");
INSERT INTO `llx_c_regions` VALUES("128","5202","52","","0","La Paz","1");
INSERT INTO `llx_c_regions` VALUES("129","5203","52","","0","Cochabamba","1");
INSERT INTO `llx_c_regions` VALUES("130","5204","52","","0","Oruro","1");
INSERT INTO `llx_c_regions` VALUES("131","5205","52","","0","Potosí","1");
INSERT INTO `llx_c_regions` VALUES("132","5206","52","","0","Tarija","1");
INSERT INTO `llx_c_regions` VALUES("133","5207","52","","0","Santa Cruz","1");
INSERT INTO `llx_c_regions` VALUES("134","5208","52","","0","El Beni","1");
INSERT INTO `llx_c_regions` VALUES("135","5209","52","","0","Pando","1");
INSERT INTO `llx_c_regions` VALUES("136","5601","56","","0","Brasil","1");
INSERT INTO `llx_c_regions` VALUES("137","7001","70","","0","Colombie","1");
INSERT INTO `llx_c_regions` VALUES("138","6701","67",NULL,NULL,"Tarapacá","1");
INSERT INTO `llx_c_regions` VALUES("139","6702","67",NULL,NULL,"Antofagasta","1");
INSERT INTO `llx_c_regions` VALUES("140","6703","67",NULL,NULL,"Atacama","1");
INSERT INTO `llx_c_regions` VALUES("141","6704","67",NULL,NULL,"Coquimbo","1");
INSERT INTO `llx_c_regions` VALUES("142","6705","67",NULL,NULL,"Valparaíso","1");
INSERT INTO `llx_c_regions` VALUES("143","6706","67",NULL,NULL,"General Bernardo O Higgins","1");
INSERT INTO `llx_c_regions` VALUES("144","6707","67",NULL,NULL,"Maule","1");
INSERT INTO `llx_c_regions` VALUES("145","6708","67",NULL,NULL,"Biobío","1");
INSERT INTO `llx_c_regions` VALUES("146","6709","67",NULL,NULL,"Raucanía","1");
INSERT INTO `llx_c_regions` VALUES("147","6710","67",NULL,NULL,"Los Lagos","1");
INSERT INTO `llx_c_regions` VALUES("148","6711","67",NULL,NULL,"Aysén General Carlos Ibáñez del Campo","1");
INSERT INTO `llx_c_regions` VALUES("149","6712","67",NULL,NULL,"Magallanes y Antártica Chilena","1");
INSERT INTO `llx_c_regions` VALUES("150","6713","67",NULL,NULL,"Metropolitana de Santiago","1");
INSERT INTO `llx_c_regions` VALUES("151","6714","67",NULL,NULL,"Los Ríos","1");
INSERT INTO `llx_c_regions` VALUES("152","6715","67",NULL,NULL,"Arica y Parinacota","1");
INSERT INTO `llx_c_regions` VALUES("153","8601","86",NULL,NULL,"Central","1");
INSERT INTO `llx_c_regions` VALUES("154","8602","86",NULL,NULL,"Oriental","1");
INSERT INTO `llx_c_regions` VALUES("155","8603","86",NULL,NULL,"Occidental","1");
INSERT INTO `llx_c_regions` VALUES("156","11401","114","","0","Honduras","1");
INSERT INTO `llx_c_regions` VALUES("157","11701","117","","0","India","1");
INSERT INTO `llx_c_regions` VALUES("158","11801","118","","0","Indonesia","1");
INSERT INTO `llx_c_regions` VALUES("159","1201","12","","0","Tanger-Tétouan","1");
INSERT INTO `llx_c_regions` VALUES("160","1202","12","","0","Gharb-Chrarda-Beni Hssen","1");
INSERT INTO `llx_c_regions` VALUES("161","1203","12","","0","Taza-Al Hoceima-Taounate","1");
INSERT INTO `llx_c_regions` VALUES("162","1204","12","","0","L\'Oriental","1");
INSERT INTO `llx_c_regions` VALUES("163","1205","12","","0","Fès-Boulemane","1");
INSERT INTO `llx_c_regions` VALUES("164","1206","12","","0","Meknès-Tafialet","1");
INSERT INTO `llx_c_regions` VALUES("165","1207","12","","0","Rabat-Salé-Zemour-Zaër","1");
INSERT INTO `llx_c_regions` VALUES("166","1208","12","","0","Grand Cassablanca","1");
INSERT INTO `llx_c_regions` VALUES("167","1209","12","","0","Chaouia-Ouardigha","1");
INSERT INTO `llx_c_regions` VALUES("168","1210","12","","0","Doukahla-Adba","1");
INSERT INTO `llx_c_regions` VALUES("169","1211","12","","0","Marrakech-Tensift-Al Haouz","1");
INSERT INTO `llx_c_regions` VALUES("170","1212","12","","0","Tadla-Azilal","1");
INSERT INTO `llx_c_regions` VALUES("171","1213","12","","0","Sous-Massa-Drâa","1");
INSERT INTO `llx_c_regions` VALUES("172","1214","12","","0","Guelmim-Es Smara","1");
INSERT INTO `llx_c_regions` VALUES("173","1215","12","","0","Laâyoune-Boujdour-Sakia el Hamra","1");
INSERT INTO `llx_c_regions` VALUES("174","1216","12","","0","Oued Ed-Dahab Lagouira","1");
INSERT INTO `llx_c_regions` VALUES("175","14001","140","","0","Diekirch","1");
INSERT INTO `llx_c_regions` VALUES("176","14002","140","","0","Grevenmacher","1");
INSERT INTO `llx_c_regions` VALUES("177","14003","140","","0","Luxembourg","1");
INSERT INTO `llx_c_regions` VALUES("178","15201","152","","0","Rivière Noire","1");
INSERT INTO `llx_c_regions` VALUES("179","15202","152","","0","Flacq","1");
INSERT INTO `llx_c_regions` VALUES("180","15203","152","","0","Grand Port","1");
INSERT INTO `llx_c_regions` VALUES("181","15204","152","","0","Moka","1");
INSERT INTO `llx_c_regions` VALUES("182","15205","152","","0","Pamplemousses","1");
INSERT INTO `llx_c_regions` VALUES("183","15206","152","","0","Plaines Wilhems","1");
INSERT INTO `llx_c_regions` VALUES("184","15207","152","","0","Port-Louis","1");
INSERT INTO `llx_c_regions` VALUES("185","15208","152","","0","Rivière du Rempart","1");
INSERT INTO `llx_c_regions` VALUES("186","15209","152","","0","Savanne","1");
INSERT INTO `llx_c_regions` VALUES("187","15210","152","","0","Rodrigues","1");
INSERT INTO `llx_c_regions` VALUES("188","15211","152","","0","Les îles Agaléga","1");
INSERT INTO `llx_c_regions` VALUES("189","15212","152","","0","Les écueils des Cargados Carajos","1");
INSERT INTO `llx_c_regions` VALUES("190","15401","154","","0","Mexique","1");
INSERT INTO `llx_c_regions` VALUES("191","18801","188","","0","Romania","1");
INSERT INTO `llx_c_regions` VALUES("192","23201","232","","0","Los Andes","1");
INSERT INTO `llx_c_regions` VALUES("193","23202","232","","0","Capital","1");
INSERT INTO `llx_c_regions` VALUES("194","23203","232","","0","Central","1");
INSERT INTO `llx_c_regions` VALUES("195","23204","232","","0","Cento Occidental","1");
INSERT INTO `llx_c_regions` VALUES("196","23205","232","","0","Guayana","1");
INSERT INTO `llx_c_regions` VALUES("197","23206","232","","0","Insular","1");
INSERT INTO `llx_c_regions` VALUES("198","23207","232","","0","Los Llanos","1");
INSERT INTO `llx_c_regions` VALUES("199","23208","232","","0","Nor-Oriental","1");
INSERT INTO `llx_c_regions` VALUES("200","23209","232","","0","Zuliana","1");
INSERT INTO `llx_c_regions` VALUES("201","18101","181","","0","Amazonas","1");
INSERT INTO `llx_c_regions` VALUES("202","18102","181","","0","Ancash","1");
INSERT INTO `llx_c_regions` VALUES("203","18103","181","","0","Apurimac","1");
INSERT INTO `llx_c_regions` VALUES("204","18104","181","","0","Arequipa","1");
INSERT INTO `llx_c_regions` VALUES("205","18105","181","","0","Ayacucho","1");
INSERT INTO `llx_c_regions` VALUES("206","18106","181","","0","Cajamarca","1");
INSERT INTO `llx_c_regions` VALUES("207","18107","181","","0","Callao","1");
INSERT INTO `llx_c_regions` VALUES("208","18108","181","","0","Cuzco","1");
INSERT INTO `llx_c_regions` VALUES("209","18109","181","","0","Huancavelica","1");
INSERT INTO `llx_c_regions` VALUES("210","18110","181","","0","Huanuco","1");
INSERT INTO `llx_c_regions` VALUES("211","18111","181","","0","Ica","1");
INSERT INTO `llx_c_regions` VALUES("212","18112","181","","0","Junin","1");
INSERT INTO `llx_c_regions` VALUES("213","18113","181","","0","La Libertad","1");
INSERT INTO `llx_c_regions` VALUES("214","18114","181","","0","Lambayeque","1");
INSERT INTO `llx_c_regions` VALUES("215","18115","181","","0","Lima Metropolitana","1");
INSERT INTO `llx_c_regions` VALUES("216","18116","181","","0","Lima","1");
INSERT INTO `llx_c_regions` VALUES("217","18117","181","","0","Loreto","1");
INSERT INTO `llx_c_regions` VALUES("218","18118","181","","0","Madre de Dios","1");
INSERT INTO `llx_c_regions` VALUES("219","18119","181","","0","Moquegua","1");
INSERT INTO `llx_c_regions` VALUES("220","18120","181","","0","Pasco","1");
INSERT INTO `llx_c_regions` VALUES("221","18121","181","","0","Piura","1");
INSERT INTO `llx_c_regions` VALUES("222","18122","181","","0","Puno","1");
INSERT INTO `llx_c_regions` VALUES("223","18123","181","","0","San Martín","1");
INSERT INTO `llx_c_regions` VALUES("224","18124","181","","0","Tacna","1");
INSERT INTO `llx_c_regions` VALUES("225","18125","181","","0","Tumbes","1");
INSERT INTO `llx_c_regions` VALUES("226","18126","181","","0","Ucayali","1");
INSERT INTO `llx_c_regions` VALUES("227","17801","178","","0","Panama","1");
INSERT INTO `llx_c_regions` VALUES("228","22701","227","","0","United Arab Emirates","1");
INSERT INTO `llx_c_regions` VALUES("229","27","1","21231","0","Bourgogne-Franche-Comté","1");
INSERT INTO `llx_c_regions` VALUES("230","28","1","76540","0","Normandie","1");
INSERT INTO `llx_c_regions` VALUES("231","32","1","59350","4","Hauts-de-France","1");
INSERT INTO `llx_c_regions` VALUES("232","44","1","67482","2","Grand Est","1");
INSERT INTO `llx_c_regions` VALUES("233","75","1","33063","0","Nouvelle-Aquitaine","1");
INSERT INTO `llx_c_regions` VALUES("234","76","1","31355","1","Occitanie","1");
INSERT INTO `llx_c_regions` VALUES("235","84","1","69123","1","Auvergne-Rhône-Alpes","1");



DROP TABLE IF EXISTS `llx_c_revenuestamp`;
CREATE TABLE `llx_c_revenuestamp` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_pays` int NOT NULL,
  `taux` double NOT NULL,
  `revenuestamp_type` varchar(16) NOT NULL DEFAULT 'fixed',
  `note` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `accountancy_code_sell` varchar(32) DEFAULT NULL,
  `accountancy_code_buy` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=1543 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_revenuestamp` VALUES("101","10","0.4","fixed","Revenue stamp tunisia","1",NULL,NULL);
INSERT INTO `llx_c_revenuestamp` VALUES("1541","154","1.5","percent","Revenue stamp mexico","1",NULL,NULL);
INSERT INTO `llx_c_revenuestamp` VALUES("1542","154","3","percent","Revenue stamp mexico","1",NULL,NULL);



DROP TABLE IF EXISTS `llx_c_shipment_mode`;
CREATE TABLE `llx_c_shipment_mode` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `code` varchar(30) NOT NULL,
  `libelle` varchar(128) DEFAULT NULL,
  `description` text,
  `tracking` varchar(255) DEFAULT NULL,
  `active` tinyint DEFAULT '0',
  `module` varchar(32) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_shipment_mode` (`code`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_shipment_mode` VALUES("1",NULL,"CATCH","At-Store Reclamation","At-Store Reclamation by the customer","","1",NULL,"1");
INSERT INTO `llx_c_shipment_mode` VALUES("2",NULL,"TRANS","Generic transporter","Generic transporter","","1",NULL,"1");
INSERT INTO `llx_c_shipment_mode` VALUES("3",NULL,"COLSUI","Colissimo Suivi","Colissimo Suivi","http://www.colissimo.fr/portail_colissimo/suivre.do?colispart={TRACKID}","0",NULL,"1");
INSERT INTO `llx_c_shipment_mode` VALUES("4",NULL,"LETTREMAX","Lettre Max","Courrier Suivi et Lettre Max","","0",NULL,"1");
INSERT INTO `llx_c_shipment_mode` VALUES("5",NULL,"UPS","UPS","United Parcel Service","http://wwwapps.ups.com/etracking/tracking.cgi?InquiryNumber2=&InquiryNumber3=&tracknums_displayed=3&loc=fr_FR&TypeOfInquiryNumber=T&HTMLVersion=4.0&InquiryNumber22=&InquiryNumber32=&track=Track&Suivi.x=64&Suivi.y=7&Suivi=Valider&InquiryNumber1={TRACKID}","0",NULL,"1");
INSERT INTO `llx_c_shipment_mode` VALUES("6",NULL,"KIALA","KIALA","Relais Kiala","http://www.kiala.fr/tnt/delivery/{TRACKID}","0",NULL,"1");
INSERT INTO `llx_c_shipment_mode` VALUES("7",NULL,"GLS","GLS","General Logistics Systems","https://gls-group.eu/FR/fr/suivi-colis?match={TRACKID}","0",NULL,"1");
INSERT INTO `llx_c_shipment_mode` VALUES("8",NULL,"CHRONO","Chronopost","Chronopost","http://www.chronopost.fr/expedier/inputLTNumbersNoJahia.do?listeNumeros={TRACKID}","0",NULL,"1");
INSERT INTO `llx_c_shipment_mode` VALUES("9",NULL,"INPERSON","In person at your site",NULL,NULL,"0",NULL,"1");
INSERT INTO `llx_c_shipment_mode` VALUES("10",NULL,"FEDEX","Fedex",NULL,"https://www.fedex.com/apps/fedextrack/index.html?tracknumbers={TRACKID}","0",NULL,"1");
INSERT INTO `llx_c_shipment_mode` VALUES("11",NULL,"TNT","TNT",NULL,"https://www.tnt.com/express/fr_fr/site/outils-expedition/suivi.html?searchType=con&cons=={TRACKID}","0",NULL,"1");
INSERT INTO `llx_c_shipment_mode` VALUES("12",NULL,"DHL","DHL",NULL,"https://www.dhl.com/fr-fr/home/tracking/tracking-global-forwarding.html?submit=1&tracking-id={TRACKID}","0",NULL,"1");
INSERT INTO `llx_c_shipment_mode` VALUES("13",NULL,"DPD","DPD",NULL,"https://www.dpd.fr/trace/{TRACKID}","0",NULL,"1");
INSERT INTO `llx_c_shipment_mode` VALUES("14",NULL,"MAINFREIGHT","Mainfreight",NULL,"https://www.mainfreight.com/track?{TRACKID}","0",NULL,"1");



DROP TABLE IF EXISTS `llx_c_shipment_package_type`;
CREATE TABLE `llx_c_shipment_package_type` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `label` varchar(128) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `active` int NOT NULL DEFAULT '1',
  `entity` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_c_socialnetworks`;
CREATE TABLE `llx_c_socialnetworks` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `code` varchar(100) DEFAULT NULL,
  `label` varchar(150) DEFAULT NULL,
  `url` text,
  `icon` varchar(20) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_c_socialnetworks_code_entity` (`code`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_socialnetworks` VALUES("1","1","facebook","Facebook","https://www.facebook.com/{socialid}","fa-facebook","1");
INSERT INTO `llx_c_socialnetworks` VALUES("2","1","skype","Skype","https://www.skype.com/{socialid}","fa-skype","1");
INSERT INTO `llx_c_socialnetworks` VALUES("3","1","twitter","Twitter","https://www.twitter.com/{socialid}","fa-twitter","1");
INSERT INTO `llx_c_socialnetworks` VALUES("4","1","linkedin","LinkedIn","https://www.linkedin.com/{socialid}","fa-linkedin","1");
INSERT INTO `llx_c_socialnetworks` VALUES("5","1","instagram","Instagram","https://www.instagram.com/{socialid}","fa-instagram","1");
INSERT INTO `llx_c_socialnetworks` VALUES("6","1","snapchat","Snapchat","{socialid}","fa-snapchat","1");
INSERT INTO `llx_c_socialnetworks` VALUES("7","1","googleplus","GooglePlus","https://www.googleplus.com/{socialid}","fa-google-plus-g","1");
INSERT INTO `llx_c_socialnetworks` VALUES("8","1","youtube","Youtube","https://www.youtube.com/{socialid}","fa-youtube","1");
INSERT INTO `llx_c_socialnetworks` VALUES("9","1","whatsapp","Whatsapp","{socialid}","fa-whatsapp","1");
INSERT INTO `llx_c_socialnetworks` VALUES("10","1","tumblr","Tumblr","https://www.tumblr.com/{socialid}","fa-tumblr","0");
INSERT INTO `llx_c_socialnetworks` VALUES("11","1","vero","Vero","https://vero.co/{socialid}","","0");
INSERT INTO `llx_c_socialnetworks` VALUES("12","1","viadeo","Viadeo","https://fr.viadeo.com/fr/{socialid}","fa-viadeo","0");
INSERT INTO `llx_c_socialnetworks` VALUES("13","1","slack","Slack","{socialid}","fa-slack","0");
INSERT INTO `llx_c_socialnetworks` VALUES("14","1","xing","Xing","{socialid}","fa-xing","0");
INSERT INTO `llx_c_socialnetworks` VALUES("15","1","meetup","Meetup","{socialid}","fa-meetup","0");
INSERT INTO `llx_c_socialnetworks` VALUES("16","1","pinterest","Pinterest","{socialid}","fa-pinterest","0");
INSERT INTO `llx_c_socialnetworks` VALUES("17","1","flickr","Flickr","{socialid}","fa-flickr","0");
INSERT INTO `llx_c_socialnetworks` VALUES("18","1","500px","500px","{socialid}","fa-500px","0");
INSERT INTO `llx_c_socialnetworks` VALUES("19","1","giphy","Giphy","{socialid}","","0");
INSERT INTO `llx_c_socialnetworks` VALUES("20","1","gifycat","Gificat","{socialid}","","0");
INSERT INTO `llx_c_socialnetworks` VALUES("21","1","dailymotion","Dailymotion","{socialid}","","0");
INSERT INTO `llx_c_socialnetworks` VALUES("22","1","vimeo","Vimeo","{socialid}","","0");
INSERT INTO `llx_c_socialnetworks` VALUES("23","1","periscope","Periscope","{socialid}","","0");
INSERT INTO `llx_c_socialnetworks` VALUES("24","1","twitch","Twitch","{socialid}","","0");
INSERT INTO `llx_c_socialnetworks` VALUES("25","1","discord","Discord","{socialid}","fa-discord","0");
INSERT INTO `llx_c_socialnetworks` VALUES("26","1","wikipedia","Wikipedia","{socialid}","","0");
INSERT INTO `llx_c_socialnetworks` VALUES("27","1","reddit","Reddit","{socialid}","fa-reddit","0");
INSERT INTO `llx_c_socialnetworks` VALUES("28","1","quora","Quora","{socialid}","","0");
INSERT INTO `llx_c_socialnetworks` VALUES("29","1","tripadvisor","Tripadvisor","{socialid}","","0");
INSERT INTO `llx_c_socialnetworks` VALUES("30","1","mastodon","Mastodon","{socialid}","","0");
INSERT INTO `llx_c_socialnetworks` VALUES("31","1","diaspora","Diaspora","{socialid}","","0");
INSERT INTO `llx_c_socialnetworks` VALUES("32","1","viber","Viber","{socialid}","","0");
INSERT INTO `llx_c_socialnetworks` VALUES("33","1","github","Github","https://github.com/{socialid}","fa-github","1");



DROP TABLE IF EXISTS `llx_c_stcomm`;
CREATE TABLE `llx_c_stcomm` (
  `id` int NOT NULL,
  `code` varchar(24) NOT NULL,
  `libelle` varchar(128) DEFAULT NULL,
  `picto` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `sortorder` smallint DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_stcomm` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_stcomm` VALUES("-1","ST_NO","Do not contact",NULL,"1","0");
INSERT INTO `llx_c_stcomm` VALUES("0","ST_NEVER","Never contacted",NULL,"1","0");
INSERT INTO `llx_c_stcomm` VALUES("1","ST_TODO","To contact",NULL,"1","0");
INSERT INTO `llx_c_stcomm` VALUES("2","ST_PEND","Contact in progress",NULL,"1","0");
INSERT INTO `llx_c_stcomm` VALUES("3","ST_DONE","Contacted",NULL,"1","0");



DROP TABLE IF EXISTS `llx_c_stcommcontact`;
CREATE TABLE `llx_c_stcommcontact` (
  `id` int NOT NULL,
  `code` varchar(12) NOT NULL,
  `libelle` varchar(128) DEFAULT NULL,
  `picto` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_stcommcontact` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_stcommcontact` VALUES("-1","ST_NO","Do not contact",NULL,"1");
INSERT INTO `llx_c_stcommcontact` VALUES("0","ST_NEVER","Never contacted",NULL,"1");
INSERT INTO `llx_c_stcommcontact` VALUES("1","ST_TODO","To contact",NULL,"1");
INSERT INTO `llx_c_stcommcontact` VALUES("2","ST_PEND","Contact in progress",NULL,"1");
INSERT INTO `llx_c_stcommcontact` VALUES("3","ST_DONE","Contacted",NULL,"1");



DROP TABLE IF EXISTS `llx_c_ticket_category`;
CREATE TABLE `llx_c_ticket_category` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int DEFAULT '1',
  `code` varchar(32) NOT NULL,
  `pos` int NOT NULL DEFAULT '0',
  `label` varchar(128) NOT NULL,
  `active` int DEFAULT '1',
  `use_default` int DEFAULT '1',
  `description` varchar(255) DEFAULT NULL,
  `fk_parent` int NOT NULL DEFAULT '0',
  `force_severity` varchar(32) DEFAULT NULL,
  `public` int DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_code` (`code`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_ticket_category` VALUES("1","1","OTHER","10","Other","1","1",NULL,"0",NULL,"0");



DROP TABLE IF EXISTS `llx_c_ticket_resolution`;
CREATE TABLE `llx_c_ticket_resolution` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int DEFAULT '1',
  `code` varchar(32) NOT NULL,
  `pos` varchar(32) NOT NULL,
  `label` varchar(128) NOT NULL,
  `active` int DEFAULT '1',
  `use_default` int DEFAULT '1',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_code` (`code`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_ticket_resolution` VALUES("1","1","SOLVED","10","Solved","1","0",NULL);
INSERT INTO `llx_c_ticket_resolution` VALUES("2","1","CANCELED","50","Canceled","1","0",NULL);
INSERT INTO `llx_c_ticket_resolution` VALUES("3","1","OTHER","90","Other","1","0",NULL);



DROP TABLE IF EXISTS `llx_c_ticket_severity`;
CREATE TABLE `llx_c_ticket_severity` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int DEFAULT '1',
  `code` varchar(32) NOT NULL,
  `pos` varchar(32) NOT NULL,
  `label` varchar(128) NOT NULL,
  `color` varchar(10) DEFAULT NULL,
  `active` int DEFAULT '1',
  `use_default` int DEFAULT '1',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_code` (`code`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_ticket_severity` VALUES("1","1","LOW","10","Low","","1","0",NULL);
INSERT INTO `llx_c_ticket_severity` VALUES("2","1","NORMAL","20","Normal","","1","1",NULL);
INSERT INTO `llx_c_ticket_severity` VALUES("3","1","HIGH","30","High","","1","0",NULL);
INSERT INTO `llx_c_ticket_severity` VALUES("4","1","BLOCKING","40","Critical / blocking","","1","0",NULL);



DROP TABLE IF EXISTS `llx_c_ticket_type`;
CREATE TABLE `llx_c_ticket_type` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int DEFAULT '1',
  `code` varchar(32) NOT NULL,
  `pos` varchar(32) NOT NULL,
  `label` varchar(128) NOT NULL,
  `active` int DEFAULT '1',
  `use_default` int DEFAULT '1',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_code` (`code`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_ticket_type` VALUES("1","1","COM","10","Commercial question","1","1",NULL);
INSERT INTO `llx_c_ticket_type` VALUES("2","1","ISSUE","20","Issue or bug","1","0",NULL);
INSERT INTO `llx_c_ticket_type` VALUES("3","1","REQUEST","25","Change or enhancement request","1","0",NULL);
INSERT INTO `llx_c_ticket_type` VALUES("4","1","PROJECT","30","Project","0","0",NULL);
INSERT INTO `llx_c_ticket_type` VALUES("5","1","OTHER","40","Other","1","0",NULL);
INSERT INTO `llx_c_ticket_type` VALUES("6","1","HELP","15","Request for functionnal help","1","0",NULL);
INSERT INTO `llx_c_ticket_type` VALUES("7","1","PROBLEM","22","Problem","0","0",NULL);



DROP TABLE IF EXISTS `llx_c_transport_mode`;
CREATE TABLE `llx_c_transport_mode` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `code` varchar(3) NOT NULL,
  `label` varchar(255) NOT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_transport_mode` (`code`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_transport_mode` VALUES("1","1","MAR","Transport maritime (y compris camions ou wagons sur bateau)","1");
INSERT INTO `llx_c_transport_mode` VALUES("2","1","TRA","Transport par chemin de fer (y compris camions sur wagon)","1");
INSERT INTO `llx_c_transport_mode` VALUES("3","1","ROU","Transport par route","1");
INSERT INTO `llx_c_transport_mode` VALUES("4","1","AIR","Transport par air","1");
INSERT INTO `llx_c_transport_mode` VALUES("5","1","POS","Envois postaux","1");
INSERT INTO `llx_c_transport_mode` VALUES("6","1","OLE","Installations de transport fixe (oléoduc)","1");
INSERT INTO `llx_c_transport_mode` VALUES("7","1","NAV","Transport par navigation intérieure","1");
INSERT INTO `llx_c_transport_mode` VALUES("8","1","PRO","Propulsion propre","1");



DROP TABLE IF EXISTS `llx_c_tva`;
CREATE TABLE `llx_c_tva` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `fk_pays` int NOT NULL,
  `code` varchar(10) DEFAULT '',
  `taux` double NOT NULL,
  `localtax1` varchar(20) NOT NULL DEFAULT '0',
  `localtax1_type` varchar(10) NOT NULL DEFAULT '0',
  `localtax2` varchar(20) NOT NULL DEFAULT '0',
  `localtax2_type` varchar(10) NOT NULL DEFAULT '0',
  `recuperableonly` int NOT NULL DEFAULT '0',
  `note` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `accountancy_code_sell` varchar(32) DEFAULT NULL,
  `accountancy_code_buy` varchar(32) DEFAULT NULL,
  `use_default` tinyint DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_tva_id` (`entity`,`fk_pays`,`code`,`taux`,`recuperableonly`)
) ENGINE=InnoDB AUTO_INCREMENT=2469 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_tva` VALUES("11","1","1","","20","0","0","0","0","0","VAT standard rate (France hors DOM-TOM)","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("14","1","1","","5.5","0","0","0","0","0","VAT reduced rate (France hors DOM-TOM)","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("15","1","1","","0","0","0","0","0","0","VAT Rate 0 ou non applicable","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("16","1","1","","2.1","0","0","0","0","0","VAT super-reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("17","1","1","","10","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("21","1","2","","21","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("22","1","2","","6","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("23","1","2","","0","0","0","0","0","0","VAT Rate 0 ou non applicable","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("24","1","2","","12","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("31","1","3","","22","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("32","1","3","","10","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("33","1","3","","4","0","0","0","0","0","VAT super-reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("34","1","3","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("41","1","4","","21","5.2","3","-19:-15:-9","5","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("42","1","4","","10","1.4","3","-19:-15:-9","5","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("43","1","4","","4","0.5","3","-19:-15:-9","5","0","VAT super-reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("44","1","4","","0","0","3","-19:-15:-9","5","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("51","1","5","","19","0","0","0","0","0","allgemeine Ust.","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("52","1","5","","7","0","0","0","0","0","ermäßigte USt.","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("53","1","5","","0","0","0","0","0","0","keine USt.","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("54","1","5","","5.5","0","0","0","0","0","USt. Forst","0",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("55","1","5","","10.7","0","0","0","0","0","USt. Landwirtschaft","0",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("61","1","6","","7.7","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("62","1","6","","3.7","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("63","1","6","","2.5","0","0","0","0","0","VAT super-reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("64","1","6","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("71","1","7","","20","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("72","1","7","","17.5","0","0","0","0","0","VAT standard rate before 2011","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("73","1","7","","5","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("74","1","7","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("81","1","8","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("82","1","8","","23","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("83","1","8","","13.5","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("84","1","8","","9","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("85","1","8","","4.8","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("91","1","9","","17","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("92","1","9","","13","0","0","0","0","0","VAT reduced rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("93","1","9","","3","0","0","0","0","0","VAT super reduced rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("94","1","9","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("101","1","10","","6","1","4","0","0","0","VAT 6%","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("102","1","10","","12","1","4","0","0","0","VAT 12%","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("103","1","10","","18","1","4","0","0","0","VAT 18%","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("104","1","10","","7.5","1","4","0","0","0","VAT 6% Majoré à 25% (7.5%)","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("105","1","10","","15","1","4","0","0","0","VAT 12% Majoré à 25% (15%)","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("106","1","10","","22.5","1","4","0","0","0","VAT 18% Majoré à 25% (22.5%)","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("107","1","10","","0","1","4","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("111","1","11","","0","0","0","0","0","0","No Sales Tax","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("112","1","11","","4","0","0","0","0","0","Sales Tax 4%","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("113","1","11","","6","0","0","0","0","0","Sales Tax 6%","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("121","1","12","","20","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("122","1","12","","14","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("123","1","12","","10","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("124","1","12","","7","0","0","0","0","0","VAT super-reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("125","1","12","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("141","1","14","","7","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("142","1","14","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("143","1","14","","5","9.975","1","0","0","0","GST/TPS and PST/TVQ rate for Province","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("171","1","17","","19","0","0","0","0","0","Algemeen BTW tarief","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("172","1","17","","6","0","0","0","0","0","Verlaagd BTW tarief","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("173","1","17","","0","0","0","0","0","0","0 BTW tarief","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("174","1","17","","21","0","0","0","0","0","Algemeen BTW tarief (vanaf 1 oktober 2012)","0",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("201","1","20","","25","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("202","1","20","","12","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("203","1","20","","6","0","0","0","0","0","VAT super-reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("204","1","20","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("211","1","21","","0","0","0","0","0","0","IVA Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("212","1","21","","18","7.5","2","0","0","0","IVA standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("221","1","22","","18","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("222","1","22","","10","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("223","1","22","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("231","1","23","","21","0","0","0","0","0","IVA standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("232","1","23","","10.5","0","0","0","0","0","IVA reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("233","1","23","","0","0","0","0","0","0","IVA Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("241","1","24","","19.25","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("242","1","24","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("251","1","25","","23","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("252","1","25","","13","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("253","1","25","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("254","1","25","","6","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("261","1","26","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("262","1","26","","5","0","0","0","0","0","VAT Rate 5","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("271","1","27","","19.6","0","0","0","0","0","VAT standard rate (France hors DOM-TOM)","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("272","1","27","","8.5","0","0","0","0","0","VAT standard rate (DOM sauf Guyane et Saint-Martin)","0",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("273","1","27","","8.5","0","0","0","0","1","VAT standard rate (DOM sauf Guyane et Saint-Martin), non perçu par le vendeur mais récupérable par acheteur","0",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("274","1","27","","5.5","0","0","0","0","0","VAT reduced rate (France hors DOM-TOM)","0",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("275","1","27","","0","0","0","0","0","0","VAT Rate 0 ou non applicable","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("276","1","27","","2.1","0","0","0","0","0","VAT super-reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("277","1","27","","7","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("281","1","28","","10","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("282","1","28","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("411","1","41","","20","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("412","1","41","","10","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("413","1","41","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("461","1","46","","0","0","0","0","0","0","No VAT","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("462","1","46","","15","0","0","0","0","0","VAT 15%","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("463","1","46","","7.5","0","0","0","0","0","VAT 7.5%","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("561","1","56","","0","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("591","1","59","","20","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("592","1","59","","7","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("593","1","59","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("671","1","67","","19","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("672","1","67","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("721","1","72","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("722","1","72","","18","0.9","1","0","0","0","VAT Rate 18+0.9","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("781","1","78","","19","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("782","1","78","","9","0","0","0","0","0","VAT Rate 9","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("783","1","78","","5","0","0","0","0","0","VAT Rate 5","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("784","1","78","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("801","1","80","","25","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("802","1","80","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("803","1","1","85","8.5","0","0","0","0","0","VAT standard rate (DOM sauf Guyane et Saint-Martin)","0",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("804","1","1","85NPR","8.5","0","0","0","0","1","VAT standard rate (DOM sauf Guyane et Saint-Martin), non perçu par le vendeur mais récupérable par acheteur","0",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("805","1","1","85NPROM","8.5","2","3","0","0","1","VAT standard rate (DOM sauf Guyane et Saint-Martin), NPR, Octroi de Mer","0",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("806","1","1","85NPROMOMR","8.5","2","3","2.5","3","1","VAT standard rate (DOM sauf Guyane et Saint-Martin), NPR, Octroi de Mer et Octroi de Mer Regional","0",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("861","1","86","","13","0","0","0","0","0","IVA 13","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("862","1","86","","0","0","0","0","0","0","SIN IVA","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1141","1","114","","0","0","0","0","0","0","No ISV","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1142","1","114","","12","0","0","0","0","0","ISV 12%","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1161","1","116","","25.5","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1162","1","116","","7","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1163","1","116","","0","0","0","0","0","0","VAT rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1171","1","117","","0","0","0","0","0","0","VAT Rate 0","0",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1176","1","117","C+S-18","0","9","1","9","1","0","CGST+SGST - Same state sales","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1177","1","117","I-18","18","0","0","0","0","0","IGST","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1178","1","117","C+S-5","0","2.5","1","2.5","1","0","CGST+SGST - Same state sales","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1179","1","117","I-5","5","0","0","0","0","0","IGST","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1180","1","117","C+S-12","0","6","1","6","1","0","CGST+SGST - Same state sales","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1181","1","117","I-12","12","0","0","0","0","0","IGST","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1182","1","117","C+S-28","0","14","1","14","1","0","CGST+SGST - Same state sales","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1183","1","117","I-28","28","0","0","0","0","0","IGST","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1231","1","123","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1232","1","123","","5","0","0","0","0","0","VAT Rate 5","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1401","1","140","","17","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1402","1","140","","14","0","0","0","0","0","VAT intermediary rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1403","1","140","","8","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1404","1","140","","3","0","0","0","0","0","VAT super-reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1405","1","140","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1481","1","148","","18","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1482","1","148","","7","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1483","1","148","","5","0","0","0","0","0","VAT super-reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1484","1","148","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1511","1","151","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1512","1","151","","14","0","0","0","0","0","VAT Rate 14","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1521","1","152","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1522","1","152","","15","0","0","0","0","0","VAT Rate 15","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1541","1","154","","0","0","0","0","0","0","No VAT","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1542","1","154","","16","0","0","0","0","0","VAT 16%","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1543","1","154","","10","0","0","0","0","0","VAT Frontero","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1662","1","166","","15","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1663","1","166","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1692","1","169","","5","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1693","1","169","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1731","1","173","","25","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1732","1","173","","14","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1733","1","173","","8","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1734","1","173","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1781","1","178","","7","0","0","0","0","0","ITBMS standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1782","1","178","","0","0","0","0","0","0","ITBMS Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1811","1","181","","18","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1812","1","181","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1841","1","184","","23","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1842","1","184","","8","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1843","1","184","","3","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1844","1","184","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1881","1","188","","19","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1882","1","188","","9","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1883","1","188","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1884","1","188","","5","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("1931","1","193","","0","0","0","0","0","0","No VAT in SPM","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2011","1","201","","19","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2012","1","201","","10","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2013","1","201","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2021","1","202","","22","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2022","1","202","","9.5","0","0","0","0","0","VAT reduced rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2023","1","202","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2051","1","205","","15","0","0","0","0","0","VAT standard rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2052","1","205","","14","0","0","0","0","0","VAT 14%","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2053","1","205","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2071","1","207","","0","0","0","0","0","0","VAT 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2072","1","207","","15","0","0","0","0","0","VAT 15%","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2131","1","213","","5","0","0","0","0","0","VAT 5%","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2132","1","213","","0","0","0","0","0","0","VAT 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2261","1","226","","20","0","0","0","0","0","VAT standart rate","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2262","1","226","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2321","1","232","","0","0","0","0","0","0","No VAT","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2322","1","232","","12","0","0","0","0","0","VAT 12%","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2323","1","232","","8","0","0","0","0","0","VAT 8%","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2461","1","246","","0","0","0","0","0","0","VAT Rate 0","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2462","1","102","","24","0","0","0","0","0","????????? ?.?.?.","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2463","1","102","","0","0","0","0","0","0","???????? ?.?.?.","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2464","1","102","","13","0","0","0","0","0","????????? ?.?.?.","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2465","1","102","","6.5","0","0","0","0","0","????????????? ?.?.?.","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2466","1","102","","16","0","0","0","0","0","????? ????????? ?.?.?.","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2467","1","102","","9","0","0","0","0","0","????? ????????? ?.?.?.","1",NULL,NULL,"0");
INSERT INTO `llx_c_tva` VALUES("2468","1","102","","5","0","0","0","0","0","????? ????????????? ?.?.?.","1",NULL,NULL,"0");



DROP TABLE IF EXISTS `llx_c_type_contact`;
CREATE TABLE `llx_c_type_contact` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `element` varchar(30) NOT NULL,
  `source` varchar(8) NOT NULL DEFAULT 'external',
  `code` varchar(32) NOT NULL,
  `libelle` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_type_contact_id` (`element`,`source`,`code`)
) ENGINE=InnoDB AUTO_INCREMENT=213 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_type_contact` VALUES("10","contrat","internal","SALESREPSIGN","Commercial signataire du contrat","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("11","contrat","internal","SALESREPFOLL","Commercial suivi du contrat","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("20","contrat","external","BILLING","Contact client facturation contrat","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("21","contrat","external","CUSTOMER","Contact client suivi contrat","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("22","contrat","external","SALESREPSIGN","Contact client signataire contrat","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("31","propal","internal","SALESREPFOLL","Commercial à l\'origine de la propale","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("40","propal","external","BILLING","Contact client facturation propale","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("41","propal","external","CUSTOMER","Contact client suivi propale","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("42","propal","external","SHIPPING","Contact client livraison propale","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("50","facture","internal","SALESREPFOLL","Responsable suivi du paiement","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("60","facture","external","BILLING","Contact client facturation","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("61","facture","external","SHIPPING","Contact client livraison","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("62","facture","external","SERVICE","Contact client prestation","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("70","invoice_supplier","internal","SALESREPFOLL","Responsable suivi du paiement","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("71","invoice_supplier","external","BILLING","Contact fournisseur facturation","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("72","invoice_supplier","external","SHIPPING","Contact fournisseur livraison","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("73","invoice_supplier","external","SERVICE","Contact fournisseur prestation","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("80","agenda","internal","ACTOR","Responsable","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("81","agenda","internal","GUEST","Guest","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("85","agenda","external","ACTOR","Responsable","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("86","agenda","external","GUEST","Guest","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("91","commande","internal","SALESREPFOLL","Responsable suivi de la commande","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("100","commande","external","BILLING","Contact client facturation commande","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("101","commande","external","CUSTOMER","Contact client suivi commande","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("102","commande","external","SHIPPING","Contact client livraison commande","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("110","supplier_proposal","internal","SALESREPFOLL","Responsable suivi de la demande","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("111","supplier_proposal","external","BILLING","Contact fournisseur facturation","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("112","supplier_proposal","external","SHIPPING","Contact fournisseur livraison","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("113","supplier_proposal","external","SERVICE","Contact fournisseur prestation","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("120","fichinter","internal","INTERREPFOLL","Responsable suivi de l\'intervention","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("121","fichinter","internal","INTERVENING","Intervenant","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("130","fichinter","external","BILLING","Contact client facturation intervention","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("131","fichinter","external","CUSTOMER","Contact client suivi de l\'intervention","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("140","order_supplier","internal","SALESREPFOLL","Responsable suivi de la commande","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("141","order_supplier","internal","SHIPPING","Responsable réception de la commande","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("142","order_supplier","external","BILLING","Contact fournisseur facturation commande","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("143","order_supplier","external","CUSTOMER","Contact fournisseur suivi commande","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("145","order_supplier","external","SHIPPING","Contact fournisseur livraison commande","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("150","dolresource","internal","USERINCHARGE","In charge of resource","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("151","dolresource","external","THIRDINCHARGE","In charge of resource","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("155","ticket","internal","SUPPORTTEC","Utilisateur contact support","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("156","ticket","internal","CONTRIBUTOR","Intervenant","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("157","ticket","external","SUPPORTCLI","Contact client suivi incident","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("158","ticket","external","CONTRIBUTOR","Intervenant","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("160","project","internal","PROJECTLEADER","Chef de Projet","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("161","project","internal","PROJECTCONTRIBUTOR","Intervenant","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("170","project","external","PROJECTLEADER","Chef de Projet","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("171","project","external","PROJECTCONTRIBUTOR","Intervenant","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("180","project_task","internal","TASKEXECUTIVE","Responsable","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("181","project_task","internal","TASKCONTRIBUTOR","Intervenant","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("190","project_task","external","TASKEXECUTIVE","Responsable","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("191","project_task","external","TASKCONTRIBUTOR","Intervenant","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("210","conferenceorbooth","internal","MANAGER","Conference or Booth manager","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("211","conferenceorbooth","external","SPEAKER","Conference Speaker","1",NULL,"0");
INSERT INTO `llx_c_type_contact` VALUES("212","conferenceorbooth","external","RESPONSIBLE","Booth responsible","1",NULL,"0");



DROP TABLE IF EXISTS `llx_c_type_container`;
CREATE TABLE `llx_c_type_container` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `label` varchar(128) DEFAULT NULL,
  `module` varchar(32) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `position` int DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_type_container_id` (`code`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_type_container` VALUES("1","page","1","Page","system","1","0");
INSERT INTO `llx_c_type_container` VALUES("2","banner","1","Banner","system","1","0");
INSERT INTO `llx_c_type_container` VALUES("3","blogpost","1","BlogPost","system","1","0");
INSERT INTO `llx_c_type_container` VALUES("4","other","1","Other","system","1","0");
INSERT INTO `llx_c_type_container` VALUES("5","menu","1","Menu","system","1","0");



DROP TABLE IF EXISTS `llx_c_type_fees`;
CREATE TABLE `llx_c_type_fees` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(12) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `type` int DEFAULT '0',
  `accountancy_code` varchar(32) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_type_fees` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_type_fees` VALUES("1","TF_OTHER","Other","0",NULL,"1",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("2","TF_TRIP","Transportation","0",NULL,"1",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("3","TF_LUNCH","Lunch","0",NULL,"1",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("4","EX_KME","ExpLabelKm","0",NULL,"1",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("5","EX_FUE","ExpLabelFuelCV","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("6","EX_HOT","ExpLabelHotel","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("7","EX_PAR","ExpLabelParkingCV","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("8","EX_TOL","ExpLabelTollCV","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("9","EX_TAX","ExpLabelVariousTaxes","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("10","EX_IND","ExpLabelIndemnityTransSubscrip","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("11","EX_SUM","ExpLabelMaintenanceSupply","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("12","EX_SUO","ExpLabelOfficeSupplies","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("13","EX_CAR","ExpLabelCarRental","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("14","EX_DOC","ExpLabelDocumentation","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("15","EX_CUR","ExpLabelCustomersReceiving","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("16","EX_OTR","ExpLabelOtherReceiving","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("17","EX_POS","ExpLabelPostage","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("18","EX_CAM","ExpLabelMaintenanceRepairCV","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("19","EX_EMM","ExpLabelEmployeesMeal","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("20","EX_GUM","ExpLabelGuestsMeal","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("21","EX_BRE","ExpLabelBreakfast","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("22","EX_FUE_VP","ExpLabelFuelPV","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("23","EX_TOL_VP","ExpLabelTollPV","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("24","EX_PAR_VP","ExpLabelParkingPV","0",NULL,"0",NULL,"0");
INSERT INTO `llx_c_type_fees` VALUES("25","EX_CAM_VP","ExpLabelMaintenanceRepairPV","0",NULL,"0",NULL,"0");



DROP TABLE IF EXISTS `llx_c_type_resource`;
CREATE TABLE `llx_c_type_resource` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_type_resource_id` (`label`,`code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_type_resource` VALUES("1","RES_ROOMS","Rooms","1");
INSERT INTO `llx_c_type_resource` VALUES("2","RES_CARS","Cars","1");



DROP TABLE IF EXISTS `llx_c_typent`;
CREATE TABLE `llx_c_typent` (
  `id` int NOT NULL,
  `code` varchar(12) NOT NULL,
  `libelle` varchar(128) DEFAULT NULL,
  `fk_country` int DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_typent` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_typent` VALUES("1","TE_STARTUP","Start-up",NULL,"0",NULL,"0");
INSERT INTO `llx_c_typent` VALUES("2","TE_GROUP","Grand groupe",NULL,"1",NULL,"0");
INSERT INTO `llx_c_typent` VALUES("3","TE_MEDIUM","PME/PMI",NULL,"1",NULL,"0");
INSERT INTO `llx_c_typent` VALUES("4","TE_SMALL","TPE",NULL,"1",NULL,"0");
INSERT INTO `llx_c_typent` VALUES("5","TE_ADMIN","Administration",NULL,"1",NULL,"0");
INSERT INTO `llx_c_typent` VALUES("6","TE_WHOLE","Grossiste",NULL,"0",NULL,"0");
INSERT INTO `llx_c_typent` VALUES("7","TE_RETAIL","Revendeur",NULL,"0",NULL,"0");
INSERT INTO `llx_c_typent` VALUES("8","TE_PRIVATE","Particulier",NULL,"1",NULL,"0");
INSERT INTO `llx_c_typent` VALUES("100","TE_OTHER","Autres",NULL,"1",NULL,"0");
INSERT INTO `llx_c_typent` VALUES("231","TE_A_RI","Responsable Inscripto (typo A)","23","0",NULL,"0");
INSERT INTO `llx_c_typent` VALUES("232","TE_B_RNI","Responsable No Inscripto (typo B)","23","0",NULL,"0");
INSERT INTO `llx_c_typent` VALUES("233","TE_C_FE","Consumidor Final/Exento (typo C)","23","0",NULL,"0");



DROP TABLE IF EXISTS `llx_c_units`;
CREATE TABLE `llx_c_units` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(3) DEFAULT NULL,
  `sortorder` smallint DEFAULT NULL,
  `label` varchar(128) DEFAULT NULL,
  `short_label` varchar(5) DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `scale` int DEFAULT NULL,
  `unit_type` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_units_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=latin1;

INSERT INTO `llx_c_units` VALUES("1","P",NULL,"piece","p","1",NULL,NULL);
INSERT INTO `llx_c_units` VALUES("2","SET",NULL,"set","se","1",NULL,NULL);
INSERT INTO `llx_c_units` VALUES("3","S",NULL,"second","s","1",NULL,"time");
INSERT INTO `llx_c_units` VALUES("4","H",NULL,"hour","h","1","3600","time");
INSERT INTO `llx_c_units` VALUES("5","D",NULL,"day","d","1","86400","time");
INSERT INTO `llx_c_units` VALUES("6","KG",NULL,"kilogram","kg","1","0","weight");
INSERT INTO `llx_c_units` VALUES("7","G",NULL,"gram","g","1","-3","weight");
INSERT INTO `llx_c_units` VALUES("8","M",NULL,"SizeUnitm","m","1","0","size");
INSERT INTO `llx_c_units` VALUES("9","LM",NULL,"linear meter","lm","0","0","size");
INSERT INTO `llx_c_units` VALUES("10","M2",NULL,"SurfaceUnitm2","m2","1","0","surface");
INSERT INTO `llx_c_units` VALUES("11","M3",NULL,"VolumeUnitm3","m3","1","0","volume");
INSERT INTO `llx_c_units` VALUES("12","L",NULL,"liter","l","0","-3","volume");
INSERT INTO `llx_c_units` VALUES("13","T",NULL,"WeightUnitton","T","1","3","weight");
INSERT INTO `llx_c_units` VALUES("16","MG",NULL,"WeightUnitmg","mg","1","-6","weight");
INSERT INTO `llx_c_units` VALUES("17","OZ",NULL,"WeightUnitounce","Oz","1","98","weight");
INSERT INTO `llx_c_units` VALUES("18","LB",NULL,"WeightUnitpound","lb","1","99","weight");
INSERT INTO `llx_c_units` VALUES("20","DM",NULL,"SizeUnitdm","dm","1","-1","size");
INSERT INTO `llx_c_units` VALUES("21","CM",NULL,"SizeUnitcm","cm","1","-2","size");
INSERT INTO `llx_c_units` VALUES("22","MM",NULL,"SizeUnitmm","mm","1","-3","size");
INSERT INTO `llx_c_units` VALUES("23","FT",NULL,"SizeUnitfoot","ft","1","98","size");
INSERT INTO `llx_c_units` VALUES("24","IN",NULL,"SizeUnitinch","in","1","99","size");
INSERT INTO `llx_c_units` VALUES("26","DM2",NULL,"SurfaceUnitdm2","dm2","1","-2","surface");
INSERT INTO `llx_c_units` VALUES("27","CM2",NULL,"SurfaceUnitcm2","cm2","1","-4","surface");
INSERT INTO `llx_c_units` VALUES("28","MM2",NULL,"SurfaceUnitmm2","mm2","1","-6","surface");
INSERT INTO `llx_c_units` VALUES("29","FT2",NULL,"SurfaceUnitfoot2","ft2","1","98","surface");
INSERT INTO `llx_c_units` VALUES("30","IN2",NULL,"SurfaceUnitinch2","in2","1","99","surface");
INSERT INTO `llx_c_units` VALUES("32","DM3",NULL,"VolumeUnitdm3","dm3","1","-3","volume");
INSERT INTO `llx_c_units` VALUES("33","CM3",NULL,"VolumeUnitcm3","cm3","1","-6","volume");
INSERT INTO `llx_c_units` VALUES("34","MM3",NULL,"VolumeUnitmm3","mm3","1","-9","volume");
INSERT INTO `llx_c_units` VALUES("35","FT3",NULL,"VolumeUnitfoot3","ft3","1","88","volume");
INSERT INTO `llx_c_units` VALUES("36","IN3",NULL,"VolumeUnitinch3","in3","1","89","volume");
INSERT INTO `llx_c_units` VALUES("37","OZ3",NULL,"VolumeUnitounce","Oz","1","97","volume");
INSERT INTO `llx_c_units` VALUES("39","GAL",NULL,"VolumeUnitgallon","gal","1","99","volume");
INSERT INTO `llx_c_units` VALUES("43","MI",NULL,"minute","i","1","60","time");
INSERT INTO `llx_c_units` VALUES("46","W",NULL,"week","w","1","604800","time");
INSERT INTO `llx_c_units` VALUES("47","MO",NULL,"month","m","1","2629800","time");
INSERT INTO `llx_c_units` VALUES("48","Y",NULL,"year","y","1","31557600","time");



DROP TABLE IF EXISTS `llx_c_ziptown`;
CREATE TABLE `llx_c_ziptown` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `code` varchar(5) DEFAULT NULL,
  `fk_county` int DEFAULT NULL,
  `fk_pays` int NOT NULL DEFAULT '0',
  `zip` varchar(10) NOT NULL,
  `town` varchar(180) NOT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `town_up` varchar(180) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_ziptown_fk_pays` (`zip`,`town`,`fk_pays`),
  KEY `idx_c_ziptown_fk_county` (`fk_county`),
  KEY `idx_c_ziptown_fk_pays` (`fk_pays`),
  KEY `idx_c_ziptown_zip` (`zip`),
  CONSTRAINT `fk_c_ziptown_fk_county` FOREIGN KEY (`fk_county`) REFERENCES `llx_c_departements` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_c_ziptown_fk_pays` FOREIGN KEY (`fk_pays`) REFERENCES `llx_c_country` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie`;
CREATE TABLE `llx_categorie` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `fk_parent` int NOT NULL DEFAULT '0',
  `label` varchar(180) NOT NULL,
  `type` int NOT NULL DEFAULT '1',
  `description` text,
  `color` varchar(8) DEFAULT NULL,
  `fk_soc` int DEFAULT NULL,
  `visible` tinyint NOT NULL DEFAULT '1',
  `import_key` varchar(14) DEFAULT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_categorie_ref` (`entity`,`fk_parent`,`label`,`type`),
  KEY `idx_categorie_type` (`type`),
  KEY `idx_categorie_label` (`label`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie_account`;
CREATE TABLE `llx_categorie_account` (
  `fk_categorie` int NOT NULL,
  `fk_account` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_account`),
  KEY `idx_categorie_account_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_account_fk_account` (`fk_account`),
  CONSTRAINT `fk_categorie_account_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_categorie_account_fk_account` FOREIGN KEY (`fk_account`) REFERENCES `llx_bank_account` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie_actioncomm`;
CREATE TABLE `llx_categorie_actioncomm` (
  `fk_categorie` int NOT NULL,
  `fk_actioncomm` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_actioncomm`),
  KEY `idx_categorie_actioncomm_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_actioncomm_fk_actioncomm` (`fk_actioncomm`),
  CONSTRAINT `fk_categorie_actioncomm_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_categorie_actioncomm_fk_actioncomm` FOREIGN KEY (`fk_actioncomm`) REFERENCES `llx_actioncomm` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie_contact`;
CREATE TABLE `llx_categorie_contact` (
  `fk_categorie` int NOT NULL,
  `fk_socpeople` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_socpeople`),
  KEY `idx_categorie_contact_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_contact_fk_socpeople` (`fk_socpeople`),
  CONSTRAINT `fk_categorie_contact_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_categorie_contact_fk_socpeople` FOREIGN KEY (`fk_socpeople`) REFERENCES `llx_socpeople` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie_fournisseur`;
CREATE TABLE `llx_categorie_fournisseur` (
  `fk_categorie` int NOT NULL,
  `fk_soc` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_soc`),
  KEY `idx_categorie_fournisseur_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_fournisseur_fk_societe` (`fk_soc`),
  CONSTRAINT `fk_categorie_fournisseur_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_categorie_fournisseur_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie_knowledgemanagement`;
CREATE TABLE `llx_categorie_knowledgemanagement` (
  `fk_categorie` int NOT NULL,
  `fk_knowledgemanagement` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_knowledgemanagement`),
  KEY `idx_categorie_knowledgemanagement_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_knowledgemanagement_fk_knowledgemanagement` (`fk_knowledgemanagement`),
  CONSTRAINT `fk_categorie_knowledgemanagement_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_categorie_knowledgemanagement_knowledgemanagement_rowid` FOREIGN KEY (`fk_knowledgemanagement`) REFERENCES `llx_knowledgemanagement_knowledgerecord` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie_lang`;
CREATE TABLE `llx_categorie_lang` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_category` int NOT NULL DEFAULT '0',
  `lang` varchar(5) NOT NULL DEFAULT '0',
  `label` varchar(255) NOT NULL,
  `description` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_category_lang` (`fk_category`,`lang`),
  CONSTRAINT `fk_category_lang_fk_category` FOREIGN KEY (`fk_category`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie_member`;
CREATE TABLE `llx_categorie_member` (
  `fk_categorie` int NOT NULL,
  `fk_member` int NOT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_member`),
  KEY `idx_categorie_member_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_member_fk_member` (`fk_member`),
  CONSTRAINT `fk_categorie_member_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_categorie_member_member_rowid` FOREIGN KEY (`fk_member`) REFERENCES `llx_adherent` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie_product`;
CREATE TABLE `llx_categorie_product` (
  `fk_categorie` int NOT NULL,
  `fk_product` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_product`),
  KEY `idx_categorie_product_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_product_fk_product` (`fk_product`),
  CONSTRAINT `fk_categorie_product_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_categorie_product_product_rowid` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie_project`;
CREATE TABLE `llx_categorie_project` (
  `fk_categorie` int NOT NULL,
  `fk_project` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_project`),
  KEY `idx_categorie_project_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_project_fk_project` (`fk_project`),
  CONSTRAINT `fk_categorie_project_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_categorie_project_fk_project_rowid` FOREIGN KEY (`fk_project`) REFERENCES `llx_projet` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie_societe`;
CREATE TABLE `llx_categorie_societe` (
  `fk_categorie` int NOT NULL,
  `fk_soc` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_soc`),
  KEY `idx_categorie_societe_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_societe_fk_societe` (`fk_soc`),
  CONSTRAINT `fk_categorie_societe_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_categorie_societe_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie_ticket`;
CREATE TABLE `llx_categorie_ticket` (
  `fk_categorie` int NOT NULL,
  `fk_ticket` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_ticket`),
  KEY `idx_categorie_ticket_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_ticket_fk_ticket` (`fk_ticket`),
  CONSTRAINT `fk_categorie_ticket_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_categorie_ticket_ticket_rowid` FOREIGN KEY (`fk_ticket`) REFERENCES `llx_ticket` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie_user`;
CREATE TABLE `llx_categorie_user` (
  `fk_categorie` int NOT NULL,
  `fk_user` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_user`),
  KEY `idx_categorie_user_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_user_fk_user` (`fk_user`),
  CONSTRAINT `fk_categorie_user_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_categorie_user_fk_user` FOREIGN KEY (`fk_user`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie_warehouse`;
CREATE TABLE `llx_categorie_warehouse` (
  `fk_categorie` int NOT NULL,
  `fk_warehouse` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_warehouse`),
  KEY `idx_categorie_warehouse_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_warehouse_fk_warehouse` (`fk_warehouse`),
  CONSTRAINT `fk_categorie_warehouse_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_categorie_warehouse_fk_warehouse_rowid` FOREIGN KEY (`fk_warehouse`) REFERENCES `llx_entrepot` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categorie_website_page`;
CREATE TABLE `llx_categorie_website_page` (
  `fk_categorie` int NOT NULL,
  `fk_website_page` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_website_page`),
  KEY `idx_categorie_website_page_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_website_page_fk_website_page` (`fk_website_page`),
  CONSTRAINT `fk_categorie_website_page_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_categorie_website_page_website_page_rowid` FOREIGN KEY (`fk_website_page`) REFERENCES `llx_website_page` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_categories_extrafields`;
CREATE TABLE `llx_categories_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_categories_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_chargesociales`;
CREATE TABLE `llx_chargesociales` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(16) DEFAULT NULL,
  `date_ech` datetime NOT NULL,
  `libelle` varchar(80) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `tms` timestamp NULL DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `fk_type` int NOT NULL,
  `fk_account` int DEFAULT NULL,
  `fk_mode_reglement` int DEFAULT NULL,
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `paye` smallint NOT NULL DEFAULT '0',
  `periode` date DEFAULT NULL,
  `fk_projet` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_commande`;
CREATE TABLE `llx_commande` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `ref_ext` varchar(255) DEFAULT NULL,
  `ref_int` varchar(255) DEFAULT NULL,
  `ref_client` varchar(255) DEFAULT NULL,
  `fk_soc` int NOT NULL,
  `fk_projet` int DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `date_cloture` datetime DEFAULT NULL,
  `date_commande` date DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `fk_user_cloture` int DEFAULT NULL,
  `source` smallint DEFAULT NULL,
  `fk_statut` smallint DEFAULT '0',
  `amount_ht` double(24,8) DEFAULT '0.00000000',
  `remise_percent` double DEFAULT '0',
  `remise_absolue` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `revenuestamp` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `facture` tinyint DEFAULT '0',
  `fk_account` int DEFAULT NULL,
  `fk_currency` varchar(3) DEFAULT NULL,
  `fk_cond_reglement` int DEFAULT NULL,
  `deposit_percent` varchar(63) DEFAULT NULL,
  `fk_mode_reglement` int DEFAULT NULL,
  `date_livraison` datetime DEFAULT NULL,
  `fk_shipping_method` int DEFAULT NULL,
  `fk_warehouse` int DEFAULT NULL,
  `fk_availability` int DEFAULT NULL,
  `fk_input_reason` int DEFAULT NULL,
  `fk_delivery_address` int DEFAULT NULL,
  `fk_incoterms` int DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `module_source` varchar(32) DEFAULT NULL,
  `pos_source` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_commande_ref` (`ref`,`entity`),
  KEY `idx_commande_fk_soc` (`fk_soc`),
  KEY `idx_commande_fk_user_author` (`fk_user_author`),
  KEY `idx_commande_fk_user_valid` (`fk_user_valid`),
  KEY `idx_commande_fk_user_cloture` (`fk_user_cloture`),
  KEY `idx_commande_fk_projet` (`fk_projet`),
  KEY `idx_commande_fk_account` (`fk_account`),
  KEY `idx_commande_fk_currency` (`fk_currency`),
  CONSTRAINT `fk_commande_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_commande_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_commande_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_commande_fk_user_cloture` FOREIGN KEY (`fk_user_cloture`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_commande_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `llx_commande` VALUES("1","CO1810-0001","1",NULL,NULL,NULL,"1",NULL,NULL,"2018-11-02 21:32:34","2018-11-02 21:44:53",NULL,"2018-10-15","1","1","1",NULL,NULL,"1","0.00000000","0",NULL,"0","0.00000000","0.00000000","0.00000000","0.00000000","527.99000000","527.99000000","","Règlement en deux fois","einstein","commande/CO1810-0001/CO1810-0001.pdf","0",NULL,NULL,"1",NULL,"2",NULL,NULL,NULL,NULL,NULL,NULL,"0","",NULL,NULL,"0","EUR","1.00000000","527.99000000","0.00000000","527.99000000",NULL,NULL);
INSERT INTO `llx_commande` VALUES("3","CO1809-0002","1",NULL,NULL,NULL,"3",NULL,NULL,"2018-12-20 11:53:16","2018-12-20 11:55:10",NULL,"2018-09-15","1",NULL,"1",NULL,NULL,"1","0.00000000","0",NULL,"0","0.00000000","0.00000000","0.00000000","0.00000000","750.00000000","750.00000000","","","einstein","commande/CO1809-0002/CO1809-0002.pdf","0",NULL,NULL,"7",NULL,"2","2018-09-01 00:00:00",NULL,NULL,NULL,NULL,NULL,"0","",NULL,NULL,"0","EUR","1.00000000","750.00000000","0.00000000","750.00000000",NULL,NULL);
INSERT INTO `llx_commande` VALUES("4","CO2309-0003","1",NULL,NULL,NULL,"23",NULL,NULL,"2023-09-18 18:11:40","2023-09-18 18:11:50",NULL,"2023-09-18","1",NULL,"1",NULL,NULL,"1","0.00000000","0",NULL,"0","0.00000000","0.00000000","0.00000000","0.00000000","800.00000000","800.00000000","","","einstein","commande/CO2309-0003/CO2309-0003.pdf","0",NULL,NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0","",NULL,NULL,"0","EUR","1.00000000","800.00000000","0.00000000","800.00000000",NULL,NULL);
INSERT INTO `llx_commande` VALUES("5","CO2512-0004","1",NULL,NULL,NULL,"16",NULL,NULL,"2025-12-15 19:55:41","2025-12-15 19:55:46",NULL,"2025-12-15","1","1","1",NULL,NULL,"1","0.00000000","0","0","0","0.00000000","0.00000000","0.00000000","0.00000000","30.00000000","30.00000000","","","einstein","commande/CO2512-0004/CO2512-0004.pdf","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0","",NULL,NULL,"0","EUR","1.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL);



DROP TABLE IF EXISTS `llx_commande_extrafields`;
CREATE TABLE `llx_commande_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_commande_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_commande_fournisseur`;
CREATE TABLE `llx_commande_fournisseur` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(180) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `ref_ext` varchar(255) DEFAULT NULL,
  `ref_supplier` varchar(255) DEFAULT NULL,
  `fk_soc` int NOT NULL,
  `fk_projet` int DEFAULT '0',
  `tms` timestamp NULL DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `date_approve` datetime DEFAULT NULL,
  `date_approve2` datetime DEFAULT NULL,
  `date_commande` date DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `fk_user_approve` int DEFAULT NULL,
  `fk_user_approve2` int DEFAULT NULL,
  `source` smallint NOT NULL,
  `fk_statut` smallint DEFAULT '0',
  `billed` smallint DEFAULT '0',
  `amount_ht` double(24,8) DEFAULT '0.00000000',
  `remise_percent` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `date_livraison` datetime DEFAULT NULL,
  `fk_account` int DEFAULT NULL,
  `fk_cond_reglement` int DEFAULT NULL,
  `fk_mode_reglement` int DEFAULT NULL,
  `fk_input_method` int DEFAULT '0',
  `fk_incoterms` int DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_commande_fournisseur_ref` (`ref`,`entity`),
  KEY `idx_commande_fournisseur_fk_soc` (`fk_soc`),
  KEY `billed` (`billed`),
  CONSTRAINT `fk_commande_fournisseur_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_commande_fournisseur_dispatch`;
CREATE TABLE `llx_commande_fournisseur_dispatch` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_commande` int DEFAULT NULL,
  `fk_product` int DEFAULT NULL,
  `fk_commandefourndet` int DEFAULT NULL,
  `qty` float DEFAULT NULL,
  `fk_entrepot` int DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `comment` varchar(255) DEFAULT NULL,
  `batch` varchar(128) DEFAULT NULL,
  `eatby` date DEFAULT NULL,
  `sellby` date DEFAULT NULL,
  `status` int DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_projet` int DEFAULT NULL,
  `fk_reception` int DEFAULT NULL,
  `cost_price` double(24,8) DEFAULT '0.00000000',
  `element_type` varchar(50) NOT NULL DEFAULT 'supplier_order',
  PRIMARY KEY (`rowid`),
  KEY `idx_commande_fournisseur_dispatch_fk_commande` (`fk_commande`),
  KEY `idx_commande_fournisseur_dispatch_fk_product` (`fk_product`),
  KEY `idx_commande_fournisseur_dispatch_fk_commandefourndet` (`fk_commandefourndet`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_commande_fournisseur_dispatch_extrafields`;
CREATE TABLE `llx_commande_fournisseur_dispatch_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_commande_fournisseur_dispatch_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_commande_fournisseur_extrafields`;
CREATE TABLE `llx_commande_fournisseur_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_commande_fournisseur_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_commande_fournisseur_log`;
CREATE TABLE `llx_commande_fournisseur_log` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `datelog` datetime NOT NULL,
  `fk_commande` int NOT NULL,
  `fk_statut` smallint NOT NULL,
  `fk_user` int NOT NULL,
  `comment` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_commande_fournisseurdet`;
CREATE TABLE `llx_commande_fournisseurdet` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_commande` int NOT NULL,
  `fk_parent_line` int DEFAULT NULL,
  `fk_product` int DEFAULT NULL,
  `ref` varchar(128) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT '0.000',
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `remise_percent` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `subprice` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `product_type` int DEFAULT '0',
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `info_bits` int DEFAULT '0',
  `special_code` int DEFAULT '0',
  `rang` int DEFAULT '0',
  `import_key` varchar(14) DEFAULT NULL,
  `fk_unit` int DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  KEY `fk_commande_fournisseurdet_fk_unit` (`fk_unit`),
  KEY `idx_commande_fournisseurdet_fk_commande` (`fk_commande`),
  KEY `idx_commande_fournisseurdet_fk_product` (`fk_product`),
  CONSTRAINT `fk_commande_fournisseurdet_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_commande_fournisseurdet_extrafields`;
CREATE TABLE `llx_commande_fournisseurdet_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_commande_fournisseurdet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_commandedet`;
CREATE TABLE `llx_commandedet` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_commande` int NOT NULL,
  `fk_parent_line` int DEFAULT NULL,
  `fk_product` int DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `description` text,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT NULL,
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `remise_percent` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `fk_remise_except` int DEFAULT NULL,
  `price` double DEFAULT NULL,
  `subprice` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `product_type` int DEFAULT '0',
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `info_bits` int DEFAULT '0',
  `buy_price_ht` double(24,8) DEFAULT '0.00000000',
  `fk_product_fournisseur_price` int DEFAULT NULL,
  `special_code` int DEFAULT '0',
  `rang` int DEFAULT '0',
  `fk_unit` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `fk_commandefourndet` int DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  KEY `idx_commandedet_fk_commande` (`fk_commande`),
  KEY `idx_commandedet_fk_product` (`fk_product`),
  KEY `fk_commandedet_fk_unit` (`fk_unit`),
  KEY `fk_commandedet_fk_commandefourndet` (`fk_commandefourndet`),
  CONSTRAINT `fk_commandedet_fk_commande` FOREIGN KEY (`fk_commande`) REFERENCES `llx_commande` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_commandedet_fk_commandefourndet` FOREIGN KEY (`fk_commandefourndet`) REFERENCES `llx_commande_fournisseurdet` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_commandedet_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

INSERT INTO `llx_commandedet` VALUES("5","1",NULL,"2",NULL,NULL,"","","0.000","0.000","0","0.000","0","1","0","0",NULL,"0","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,NULL,NULL,"EUR","0.00000000","0.00000000","0.00000000","0.00000000");
INSERT INTO `llx_commandedet` VALUES("6","1",NULL,"1",NULL,NULL,"","","0.000","0.000","0","0.000","0","1","0","0",NULL,"120","120.00000000","120.00000000","0.00000000","0.00000000","0.00000000","120.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,NULL,NULL,"EUR","120.00000000","120.00000000","0.00000000","120.00000000");
INSERT INTO `llx_commandedet` VALUES("7","1",NULL,"4",NULL,NULL,"","","0.000","0.000","0","0.000","0","1","0","0",NULL,"400","400.00000000","400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,NULL,NULL,"EUR","400.00000000","400.00000000","0.00000000","400.00000000");
INSERT INTO `llx_commandedet` VALUES("8","1",NULL,"3",NULL,NULL,"","","0.000","0.000","0","0.000","0","1","0","0",NULL,"7.99","7.99000000","7.99000000","0.00000000","0.00000000","0.00000000","7.99000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,NULL,NULL,"EUR","7.99000000","7.99000000","0.00000000","7.99000000");
INSERT INTO `llx_commandedet` VALUES("9","3",NULL,NULL,NULL,NULL,"Installation du site internet et\r\nparamétrages.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"350","350.00000000","350.00000000","0.00000000","0.00000000","0.00000000","350.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,NULL,NULL,"EUR","350.00000000","350.00000000","0.00000000","350.00000000");
INSERT INTO `llx_commandedet` VALUES("10","3",NULL,NULL,NULL,NULL,"Intégration des pages et de la navigation.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200","200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000");
INSERT INTO `llx_commandedet` VALUES("11","3",NULL,NULL,NULL,NULL,"Intégration des contenus et des images.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200","200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000");
INSERT INTO `llx_commandedet` VALUES("12","4",NULL,NULL,NULL,NULL,"Installation et configuration","","0.000","0.000","0","0.000","0","1","0","0",NULL,"150","150.00000000","150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,NULL,NULL,"EUR","150.00000000","150.00000000","0.00000000","150.00000000");
INSERT INTO `llx_commandedet` VALUES("13","4",NULL,NULL,NULL,NULL,"Cr&eacute;ation d&#39;un site internet vitrine.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"350","350.00000000","350.00000000","0.00000000","0.00000000","0.00000000","350.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,NULL,NULL,"EUR","350.00000000","350.00000000","0.00000000","350.00000000");
INSERT INTO `llx_commandedet` VALUES("14","4",NULL,NULL,NULL,NULL,"insertion des elements graphiques et de pages","","0.000","0.000","0","0.000","0","1","0","0",NULL,"150","150.00000000","150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,NULL,NULL,"EUR","150.00000000","150.00000000","0.00000000","150.00000000");
INSERT INTO `llx_commandedet` VALUES("15","4",NULL,NULL,NULL,NULL,"Personnalisation du design","","0.000","0.000","0","0.000","0","1","0","0",NULL,"150","150.00000000","150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,NULL,NULL,"EUR","150.00000000","150.00000000","0.00000000","150.00000000");
INSERT INTO `llx_commandedet` VALUES("16","5",NULL,NULL,NULL,"","Modification du style Css afin d&#39;afficher les &eacute;l&eacute;ments du menu sans le soulign&eacute;.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"30","30.00000000","30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,NULL,NULL,"EUR","30.00000000","30.00000000","0.00000000","30.00000000");



DROP TABLE IF EXISTS `llx_commandedet_extrafields`;
CREATE TABLE `llx_commandedet_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_commandedet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_comment`;
CREATE TABLE `llx_comment` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `description` text NOT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_element` int DEFAULT NULL,
  `element_type` varchar(50) DEFAULT NULL,
  `entity` int DEFAULT '1',
  `import_key` varchar(125) DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_const`;
CREATE TABLE `llx_const` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `name` varchar(180) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `value` text NOT NULL,
  `type` varchar(64) DEFAULT 'string',
  `visible` tinyint NOT NULL DEFAULT '1',
  `note` text,
  `tms` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_const` (`name`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=581 DEFAULT CHARSET=latin1;

INSERT INTO `llx_const` VALUES("2","MAIN_FEATURES_LEVEL","0","0","chaine","1","Level of features to show: -1=stable+deprecated, 0=stable only (default), 1=stable+experimental, 2=stable+experimental+development",NULL);
INSERT INTO `llx_const` VALUES("3","MAILING_LIMIT_SENDBYWEB","0","25","chaine","1","Number of targets to defined packet size when sending mass email",NULL);
INSERT INTO `llx_const` VALUES("4","MAIN_ENABLE_LOG_TO_HTML","0","0","chaine","1","If this option is set to 1, it is possible to see log output at end of HTML sources by adding paramater logtohtml=1 on URL. Module log must also be enabled.",NULL);
INSERT INTO `llx_const` VALUES("5","MAIN_SECURITY_CSRF_WITH_TOKEN","0","0","chaine","1","If this option is set to 1, a CSRF protection using an antiCSRF token is added.",NULL);
INSERT INTO `llx_const` VALUES("6","SYSLOG_HANDLERS","0","[\"mod_syslog_file\"]","chaine","0","Which logger to use",NULL);
INSERT INTO `llx_const` VALUES("7","SYSLOG_FILE","0","DOL_DATA_ROOT/dolibarr.log","chaine","0","Directory where to write log file",NULL);
INSERT INTO `llx_const` VALUES("8","SYSLOG_LEVEL","0","7","chaine","0","Level of debug info to show",NULL);
INSERT INTO `llx_const` VALUES("9","MAIN_UPLOAD_DOC","0","2048","chaine","0","Max size for file upload (0 means no upload allowed)",NULL);
INSERT INTO `llx_const` VALUES("10","MAIN_ENABLE_OVERWRITE_TRANSLATION","1","1","chaine","0","Enable translation overwrite",NULL);
INSERT INTO `llx_const` VALUES("11","MAIN_ENABLE_DEFAULT_VALUES","1","1","chaine","0","Enable default value overwrite",NULL);
INSERT INTO `llx_const` VALUES("16","MAIN_SIZE_LISTE_LIMIT","0","25","chaine","0","Longueur maximum des listes",NULL);
INSERT INTO `llx_const` VALUES("17","MAIN_SIZE_SHORTLIST_LIMIT","0","3","chaine","0","Longueur maximum des listes courtes (fiche client)",NULL);
INSERT INTO `llx_const` VALUES("18","MAIN_MENU_STANDARD","0","eldy_menu.php","chaine","0","Menu manager for internal users",NULL);
INSERT INTO `llx_const` VALUES("19","MAIN_MENUFRONT_STANDARD","0","eldy_menu.php","chaine","0","Menu manager for external users",NULL);
INSERT INTO `llx_const` VALUES("20","MAIN_MENU_SMARTPHONE","0","eldy_menu.php","chaine","0","Menu manager for internal users using smartphones",NULL);
INSERT INTO `llx_const` VALUES("21","MAIN_MENUFRONT_SMARTPHONE","0","eldy_menu.php","chaine","0","Menu manager for external users using smartphones",NULL);
INSERT INTO `llx_const` VALUES("22","MAIN_DELAY_ACTIONS_TODO","1","7","chaine","0","Tolérance de retard avant alerte (en jours) sur actions planifiées non réalisées",NULL);
INSERT INTO `llx_const` VALUES("23","MAIN_DELAY_ORDERS_TO_PROCESS","1","2","chaine","0","Tolérance de retard avant alerte (en jours) sur commandes clients non traitées",NULL);
INSERT INTO `llx_const` VALUES("24","MAIN_DELAY_SUPPLIER_ORDERS_TO_PROCESS","1","7","chaine","0","Tolérance de retard avant alerte (en jours) sur commandes fournisseurs non traitées",NULL);
INSERT INTO `llx_const` VALUES("25","MAIN_DELAY_PROPALS_TO_CLOSE","1","31","chaine","0","Tolérance de retard avant alerte (en jours) sur propales à cloturer",NULL);
INSERT INTO `llx_const` VALUES("26","MAIN_DELAY_PROPALS_TO_BILL","1","7","chaine","0","Tolérance de retard avant alerte (en jours) sur propales non facturées",NULL);
INSERT INTO `llx_const` VALUES("27","MAIN_DELAY_CUSTOMER_BILLS_UNPAYED","1","31","chaine","0","Tolérance de retard avant alerte (en jours) sur factures client impayées",NULL);
INSERT INTO `llx_const` VALUES("28","MAIN_DELAY_SUPPLIER_BILLS_TO_PAY","1","2","chaine","0","Tolérance de retard avant alerte (en jours) sur factures fournisseur impayées",NULL);
INSERT INTO `llx_const` VALUES("29","MAIN_DELAY_NOT_ACTIVATED_SERVICES","1","0","chaine","0","Tolérance de retard avant alerte (en jours) sur services à activer",NULL);
INSERT INTO `llx_const` VALUES("30","MAIN_DELAY_RUNNING_SERVICES","1","0","chaine","0","Tolérance de retard avant alerte (en jours) sur services expirés",NULL);
INSERT INTO `llx_const` VALUES("31","MAIN_DELAY_MEMBERS","1","31","chaine","0","Tolérance de retard avant alerte (en jours) sur cotisations adhérent en retard",NULL);
INSERT INTO `llx_const` VALUES("32","MAIN_DELAY_TRANSACTIONS_TO_CONCILIATE","1","62","chaine","0","Tolérance de retard avant alerte (en jours) sur rapprochements bancaires à faire",NULL);
INSERT INTO `llx_const` VALUES("33","MAIN_DELAY_EXPENSEREPORTS_TO_PAY","1","31","chaine","0","Tolérance de retard avant alerte (en jours) sur les notes de frais impayées",NULL);
INSERT INTO `llx_const` VALUES("34","MAIN_FIX_FOR_BUGGED_MTA","1","1","chaine","1","Set constant to fix email ending from PHP with some linux ike system",NULL);
INSERT INTO `llx_const` VALUES("35","MAILING_EMAIL_FROM","1","dolibarr@domain.com","chaine","0","EMail emmetteur pour les envois d emailings",NULL);
INSERT INTO `llx_const` VALUES("36","PRODUCT_ADDON_PDF_ODT_PATH","1","DOL_DATA_ROOT/doctemplates/products","chaine","0",NULL,NULL);
INSERT INTO `llx_const` VALUES("37","CONTRACT_ADDON_PDF_ODT_PATH","1","DOL_DATA_ROOT/doctemplates/contracts","chaine","0",NULL,NULL);
INSERT INTO `llx_const` VALUES("38","USERGROUP_ADDON_PDF_ODT_PATH","1","DOL_DATA_ROOT/doctemplates/usergroups","chaine","0",NULL,NULL);
INSERT INTO `llx_const` VALUES("39","USER_ADDON_PDF_ODT_PATH","1","DOL_DATA_ROOT/doctemplates/users","chaine","0",NULL,NULL);
INSERT INTO `llx_const` VALUES("41","DATABASE_PWD_ENCRYPTED","1","1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("42","MAIN_SECURITY_SALT","0","20181102204627","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("43","MAIN_SECURITY_HASH_ALGO","0","password_hash","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("44","MAIN_VERSION_FIRST_INSTALL","0","8.0.2","chaine","0","Dolibarr version when first install",NULL);
INSERT INTO `llx_const` VALUES("45","MAIN_VERSION_LAST_INSTALL","0","8.0.2","chaine","0","Dolibarr version when last install",NULL);
INSERT INTO `llx_const` VALUES("88","SOCIETE_CODECLIENT_ADDON","1","mod_codeclient_monkey","chaine","0","Module to control third parties codes",NULL);
INSERT INTO `llx_const` VALUES("89","SOCIETE_CODECOMPTA_ADDON","1","mod_codecompta_panicum","chaine","0","Module to control third parties codes",NULL);
INSERT INTO `llx_const` VALUES("90","COMPANY_ADDON_PDF_ODT_PATH","1","DOL_DATA_ROOT/doctemplates/thirdparties","chaine","0",NULL,NULL);
INSERT INTO `llx_const` VALUES("91","SOCIETE_ADD_REF_IN_LIST","1","0","yesno","0","Display customer ref into select list",NULL);
INSERT INTO `llx_const` VALUES("92","MAIN_MODULE_PROPALE","1","1","string","0","{\"authorid\":\"1\",\"ip\":\"91.163.201.5\"}",NULL);
INSERT INTO `llx_const` VALUES("93","PROPALE_ADDON_PDF","1","azur","chaine","0","Name of the proposal generation manager in PDF format",NULL);
INSERT INTO `llx_const` VALUES("94","PROPALE_ADDON","1","mod_propale_marbre","chaine","0","Name of proposal numbering manager",NULL);
INSERT INTO `llx_const` VALUES("95","PROPALE_VALIDITY_DURATION","1","15","chaine","0","Duration of validity of business proposals",NULL);
INSERT INTO `llx_const` VALUES("96","PROPALE_ADDON_PDF_ODT_PATH","1","DOL_DATA_ROOT/doctemplates/proposals","chaine","0",NULL,NULL);
INSERT INTO `llx_const` VALUES("98","COMMANDE_ADDON_PDF","1","einstein","chaine","0","Name of PDF model of order",NULL);
INSERT INTO `llx_const` VALUES("99","COMMANDE_ADDON","1","mod_commande_marbre","chaine","0","Name of numbering numerotation rules of order",NULL);
INSERT INTO `llx_const` VALUES("100","COMMANDE_ADDON_PDF_ODT_PATH","1","DOL_DATA_ROOT/doctemplates/orders","chaine","0",NULL,NULL);
INSERT INTO `llx_const` VALUES("102","FACTURE_ADDON","1","mod_facture_terre","chaine","0","Name of numbering numerotation rules of invoice",NULL);
INSERT INTO `llx_const` VALUES("103","FACTURE_ADDON_PDF","1","crabe","chaine","0","Name of PDF model of invoice",NULL);
INSERT INTO `llx_const` VALUES("104","FACTURE_ADDON_PDF_ODT_PATH","1","DOL_DATA_ROOT/doctemplates/invoices","chaine","0",NULL,NULL);
INSERT INTO `llx_const` VALUES("107","ECM_AUTO_TREE_ENABLED","1","1","chaine","0","Auto tree is enabled by default",NULL);
INSERT INTO `llx_const` VALUES("151","SYSTEMTOOLS_MYSQLDUMP","1","/usr/bin/mysqldump","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("159","MAIN_MODULE_NOTIFICATION","1","1","string","0","{\"authorid\":\"1\",\"ip\":\"91.163.201.5\"}",NULL);
INSERT INTO `llx_const` VALUES("160","MAIN_MODULE_TAX","1","1","string","0","{\"authorid\":\"1\",\"ip\":\"91.163.201.5\"}",NULL);
INSERT INTO `llx_const` VALUES("161","MAIN_MODULE_CATEGORIE","1","1","string","0","{\"authorid\":\"1\",\"ip\":\"91.163.201.5\"}",NULL);
INSERT INTO `llx_const` VALUES("162","CATEGORIE_RECURSIV_ADD","1","0","yesno","0","Affect parent categories",NULL);
INSERT INTO `llx_const` VALUES("163","MAIN_MODULE_GEOIPMAXMIND","1","1","string","0","{\"authorid\":\"1\",\"ip\":\"91.163.201.5\"}",NULL);
INSERT INTO `llx_const` VALUES("180","MAIN_LANG_DEFAULT","1","auto","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("181","MAIN_MULTILANGS","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("184","MAIN_SIZE_LISTE_LIMIT","1","25","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("185","MAIN_SIZE_SHORTLIST_LIMIT","1","3","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("186","MAIN_DISABLE_JAVASCRIPT","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("187","MAIN_BUTTON_HIDE_UNAUTHORIZED","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("188","MAIN_START_WEEK","1","1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("189","MAIN_DEFAULT_WORKING_DAYS","1","1-5","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("190","MAIN_DEFAULT_WORKING_HOURS","1","9-18","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("191","MAIN_SHOW_LOGO","1","1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("192","MAIN_FIRSTNAME_NAME_POSITION","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("193","MAIN_HELPCENTER_DISABLELINK","0","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("195","MAIN_BUGTRACK_ENABLELINK","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("196","MAIN_MODULE_PAYPAL","1","1","string","0","{\"authorid\":\"1\",\"ip\":\"91.163.201.5\"}",NULL);
INSERT INTO `llx_const` VALUES("207","PAYPAL_API_USER","1","benjouabde_api1.gmail.com","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("208","PAYPAL_API_PASSWORD","1","TUMZUWAXJ7GYVTTS","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("209","PAYPAL_API_SIGNATURE","1","A70yhW2E1fJ-3GvRelFH2WSViF4fAkJiat.xMaEXlb6eCkMRP4TbRGZV","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("210","PAYPAL_SSLVERSION","1","1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("211","ONLINE_PAYMENT_CREDITOR","1","Benjou Abdelouhab","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("212","PAYPAL_BANK_ACCOUNT_FOR_PAYMENTS","1","1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("213","PAYPAL_API_INTEGRAL_OR_PAYPALONLY","1","integral","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("214","PAYPAL_ADD_PAYMENT_URL","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("215","ONLINE_PAYMENT_MESSAGE_FORM","1","paiement en ligne","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("216","ONLINE_PAYMENT_MESSAGE_OK","1","paiement validé","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("217","ONLINE_PAYMENT_MESSAGE_KO","1","paiement annulé","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("218","ONLINE_PAYMENT_SENDEMAIL","1","benjouabde@gmail.com","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("219","PAYMENT_SECURITY_TOKEN_UNIQUE","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("220","MAIN_MODULE_WEBSERVICES","1","1","string","0","{\"authorid\":\"1\",\"ip\":\"91.163.201.85\"}",NULL);
INSERT INTO `llx_const` VALUES("221","WEBSERVICES_KEY","1","matacima","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("222","FACTURE_RIB_NUMBER","1","2","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("223","FACTURE_CHQ_NUMBER","1","-1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("235","MAIN_MODULE_FCKEDITOR","1","1","string","0","{\"authorid\":\"1\",\"ip\":\"82.66.110.158\"}",NULL);
INSERT INTO `llx_const` VALUES("236","FCKEDITOR_ENABLE_SOCIETE","1","1","yesno","0","WYSIWIG for description and note (except products/services)",NULL);
INSERT INTO `llx_const` VALUES("237","FCKEDITOR_ENABLE_PRODUCTDESC","1","1","yesno","0","WYSIWIG for products/services description and note",NULL);
INSERT INTO `llx_const` VALUES("238","FCKEDITOR_ENABLE_MAILING","1","1","yesno","0","WYSIWIG for mass emailings",NULL);
INSERT INTO `llx_const` VALUES("239","FCKEDITOR_ENABLE_DETAILS","1","1","yesno","0","WYSIWIG for products details lines for all entities",NULL);
INSERT INTO `llx_const` VALUES("240","FCKEDITOR_ENABLE_USERSIGN","1","1","yesno","0","WYSIWIG for user signature",NULL);
INSERT INTO `llx_const` VALUES("241","FCKEDITOR_ENABLE_MAIL","1","1","yesno","0","WYSIWIG for products details lines for all entities",NULL);
INSERT INTO `llx_const` VALUES("242","FCKEDITOR_SKIN","1","moono-lisa","string","0","Skin by default for fckeditor",NULL);
INSERT INTO `llx_const` VALUES("260","USER_PASSWORD_PATTERN","1","8;1;1;1;3;1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("294","MAIN_DISABLE_ALL_MAILS","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("295","MAIN_MAIL_ENABLED_USER_DEST_SELECT","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("296","MAIN_MAIL_SENDMODE","1","smtps","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("297","MAIN_MAIL_SMTP_PORT","1","465","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("298","MAIN_MAIL_SMTP_SERVER","1","ssl0.ovh.net","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("299","MAIN_MAIL_SMTPS_ID","1","contact@pixelorigin.com","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("300","MAIN_MAIL_SMTPS_PW","1","Matacima65","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("301","MAIN_MAIL_EMAIL_TLS","1","1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("302","MAIN_MAIL_EMAIL_STARTTLS","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("303","MAIN_MAIL_EMAIL_FROM","1","contact@pixelorigin.com","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("304","MAIN_MAIL_DEFAULT_FROMTYPE","1","company","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("322","MAIN_MODULE_EXPORT","1","1","string","0","{\"authorid\":\"1\",\"ip\":\"2001:861:5882:3ed0:f9ce:edce:af74:9dc2\"}",NULL);
INSERT INTO `llx_const` VALUES("323","EXPORTS_SHARE_MODELS","1","1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("328","PRODUCT_PRICE_BASE_TYPE","0","HT","string","0",NULL,NULL);
INSERT INTO `llx_const` VALUES("334","MAIN_SECURITY_MAX_IMG_IN_HTML_CONTENT","1","1000","int","0",NULL,NULL);
INSERT INTO `llx_const` VALUES("337","PROPOSAL_ALLOW_ONLINESIGN","1","1","string","0",NULL,NULL);
INSERT INTO `llx_const` VALUES("338","MAIN_MODULE_BANQUE","1","1","string","0","{\"authorid\":0,\"ip\":\"2001:861:5882:3ed0:d850:54df:b41f:564c\",\"lastactivationversion\":\"dolibarr\"}",NULL);
INSERT INTO `llx_const` VALUES("339","MAIN_MODULE_COMMANDE","1","1","string","0","{\"authorid\":0,\"ip\":\"2001:861:5882:3ed0:d850:54df:b41f:564c\",\"lastactivationversion\":\"dolibarr\"}",NULL);
INSERT INTO `llx_const` VALUES("340","MAIN_MODULE_ECM","1","1","string","0","{\"authorid\":0,\"ip\":\"2001:861:5882:3ed0:d850:54df:b41f:564c\",\"lastactivationversion\":\"dolibarr\"}",NULL);
INSERT INTO `llx_const` VALUES("342","MAIN_MODULE_SERVICE","1","1","string","0","{\"authorid\":0,\"ip\":\"2001:861:5882:3ed0:d850:54df:b41f:564c\",\"lastactivationversion\":\"dolibarr\"}",NULL);
INSERT INTO `llx_const` VALUES("343","MAIN_MODULE_SOCIETE","1","1","string","0","{\"authorid\":0,\"ip\":\"2001:861:5882:3ed0:d850:54df:b41f:564c\",\"lastactivationversion\":\"dolibarr\"}",NULL);
INSERT INTO `llx_const` VALUES("344","MAIN_MODULE_USER","0","1","string","0","{\"authorid\":0,\"ip\":\"2001:861:5882:3ed0:d850:54df:b41f:564c\",\"lastactivationversion\":\"dolibarr\"}",NULL);
INSERT INTO `llx_const` VALUES("345","MAIN_VERSION_LAST_UPGRADE","0","19.0.1","chaine","0","Dolibarr version for last upgrade",NULL);
INSERT INTO `llx_const` VALUES("346","MAIN_FIRST_PING_OK_DATE","1","20240323143309","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("347","MAIN_FIRST_PING_OK_ID","1","e25729d62073f772c1c6aa48abab6dce6aad9ff30ea65a702ae5502b80531518","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("352","MAIN_MODULE_FACTURE","1","1","string","0","{\"authorid\":\"1\",\"ip\":\"2001:861:5882:3ed0:d850:54df:b41f:564c\",\"lastactivationversion\":\"dolibarr\"}",NULL);
INSERT INTO `llx_const` VALUES("394","MAIN_THEME","1","md","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("396","THEME_ELDY_TOPMENU_BACK1","1","50,151,252","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("397","THEME_ELDY_VERMENU_BACK1","1","226,226,226","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("398","THEME_ELDY_TEXTTITLELINK","1","0,142,69","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("399","THEME_ELDY_BTNACTION","1","8,178,76","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("444","MAIN_PDF_NO_RECIPENT_FRAME","1","1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("445","MAIN_PDF_NO_SENDER_FRAME","1","1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("446","MAIN_PDF_USE_ISO_LOCATION","1","1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("460","MAIN_USE_TOP_MENU_QUICKADD_DROPDOWN","1","1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("462","MAIN_USE_TOP_MENU_SEARCH_DROPDOWN","1","1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("545","MAIN_INFO_SOCIETE_COUNTRY","1","1:FR:France","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("546","MAIN_INFO_SOCIETE_STATE","1","72:65:Hautes-Pyrénées","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("547","MAIN_INFO_SOCIETE_NOM","1","Benjou Abdelouhab","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("548","MAIN_INFO_SOCIETE_ADDRESS","1","38 ter rue Raymond Peyres","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("549","MAIN_INFO_SOCIETE_TOWN","1","Tarbes","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("550","MAIN_INFO_SOCIETE_ZIP","1","65000","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("551","MAIN_MONNAIE","1","EUR","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("552","MAIN_INFO_SOCIETE_TEL","1","+33651413714","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("553","MAIN_INFO_SOCIETE_MAIL","1","contact@pixelorigin.com","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("554","MAIN_INFO_SOCIETE_WEB","1","http://www.pixelorigin.com","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("555","MAIN_INFO_SOCIETE_NOTE","1","Règlements à l\'ordre de Benjou Abdelouhab ","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("556","MAIN_INFO_SOCIETE_LOGO","1","po.jpg","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("557","MAIN_INFO_SOCIETE_LOGO_SMALL","1","po_small.jpg","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("558","MAIN_INFO_SOCIETE_LOGO_MINI","1","po_mini.jpg","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("559","MAIN_INFO_SOCIETE_MANAGERS","1","Pixelorigin","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("560","MAIN_INFO_SOCIETE_FORME_JURIDIQUE","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("561","MAIN_INFO_SIREN","1","533 253 464","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("562","MAIN_INFO_SIRET","1","53325346400010","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("563","MAIN_INFO_APE","1","6201Z","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("564","SOCIETE_FISCAL_MONTH_START","1","1","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("565","FACTURE_TVAOPTION","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("566","MAIN_PDF_FORMAT","1","EUA4","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("567","MAIN_PDF_MARGIN_LEFT","1","10","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("568","MAIN_PDF_MARGIN_RIGHT","1","10","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("569","MAIN_PDF_MARGIN_TOP","1","10","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("570","MAIN_PDF_MARGIN_BOTTOM","1","10","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("571","MAIN_DOCUMENTS_LOGO_HEIGHT","1","10","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("572","MAIN_GENERATE_DOCUMENTS_SHOW_FOOT_DETAILS","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("573","PDF_USE_ALSO_LANGUAGE_CODE","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("574","PDF_INCLUDE_ALIAS_IN_THIRDPARTY_NAME","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("575","PDF_USE_A","1","0","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("578","MAIN_MODULE_IMPORT","1","1","string","0","{\"authorid\":\"1\",\"ip\":\"2a01:e0a:1be:a760:35b4:4346:890f:feac\",\"lastactivationversion\":\"dolibarr\"}",NULL);
INSERT INTO `llx_const` VALUES("579","MAIN_IHM_PARAMS_REV","1","19","chaine","0","",NULL);
INSERT INTO `llx_const` VALUES("580","MAIN_MODULE_SETUP_ON_LIST_BY_DEFAULT","1","commonkanban","chaine","0","",NULL);



DROP TABLE IF EXISTS `llx_contrat`;
CREATE TABLE `llx_contrat` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(255) DEFAULT NULL,
  `ref_customer` varchar(255) DEFAULT NULL,
  `ref_supplier` varchar(255) DEFAULT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `date_contrat` datetime DEFAULT NULL,
  `statut` smallint DEFAULT '0',
  `mise_en_service` datetime DEFAULT NULL,
  `fin_validite` datetime DEFAULT NULL,
  `date_cloture` datetime DEFAULT NULL,
  `fk_soc` int NOT NULL,
  `fk_projet` int DEFAULT NULL,
  `fk_commercial_signature` int DEFAULT NULL,
  `fk_commercial_suivi` int DEFAULT NULL,
  `fk_user_author` int NOT NULL DEFAULT '0',
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_mise_en_service` int DEFAULT NULL,
  `fk_user_cloture` int DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_contrat_ref` (`ref`,`entity`),
  KEY `idx_contrat_fk_soc` (`fk_soc`),
  KEY `idx_contrat_fk_user_author` (`fk_user_author`),
  CONSTRAINT `fk_contrat_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_contrat_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_contrat_extrafields`;
CREATE TABLE `llx_contrat_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_contrat_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_contratdet`;
CREATE TABLE `llx_contratdet` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_contrat` int NOT NULL,
  `fk_product` int DEFAULT NULL,
  `statut` smallint DEFAULT '0',
  `label` text,
  `description` text,
  `fk_remise_except` int DEFAULT NULL,
  `date_commande` datetime DEFAULT NULL,
  `date_ouverture_prevue` datetime DEFAULT NULL,
  `date_ouverture` datetime DEFAULT NULL,
  `date_fin_validite` datetime DEFAULT NULL,
  `date_cloture` datetime DEFAULT NULL,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT '0.000',
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `qty` double NOT NULL,
  `remise_percent` double DEFAULT '0',
  `subprice` double(24,8) DEFAULT '0.00000000',
  `price_ht` double DEFAULT NULL,
  `remise` double DEFAULT '0',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `product_type` int DEFAULT '1',
  `info_bits` int DEFAULT '0',
  `rang` int DEFAULT '0',
  `buy_price_ht` double(24,8) DEFAULT NULL,
  `fk_product_fournisseur_price` int DEFAULT NULL,
  `fk_user_author` int NOT NULL DEFAULT '0',
  `fk_user_ouverture` int DEFAULT NULL,
  `fk_user_cloture` int DEFAULT NULL,
  `commentaire` text,
  `fk_unit` int DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  KEY `idx_contratdet_fk_contrat` (`fk_contrat`),
  KEY `idx_contratdet_fk_product` (`fk_product`),
  KEY `idx_contratdet_date_ouverture_prevue` (`date_ouverture_prevue`),
  KEY `idx_contratdet_date_ouverture` (`date_ouverture`),
  KEY `idx_contratdet_date_fin_validite` (`date_fin_validite`),
  KEY `fk_contratdet_fk_unit` (`fk_unit`),
  KEY `idx_contratdet_statut` (`statut`),
  CONSTRAINT `fk_contratdet_fk_contrat` FOREIGN KEY (`fk_contrat`) REFERENCES `llx_contrat` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_contratdet_fk_product` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_contratdet_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_contratdet_extrafields`;
CREATE TABLE `llx_contratdet_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_contratdet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_contratdet_log`;
CREATE TABLE `llx_contratdet_log` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_contratdet` int NOT NULL,
  `date` datetime NOT NULL,
  `statut` smallint NOT NULL,
  `fk_user_author` int NOT NULL,
  `commentaire` text,
  PRIMARY KEY (`rowid`),
  KEY `idx_contratdet_log_fk_contratdet` (`fk_contratdet`),
  KEY `idx_contratdet_log_date` (`date`),
  CONSTRAINT `fk_contratdet_log_fk_contratdet` FOREIGN KEY (`fk_contratdet`) REFERENCES `llx_contratdet` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_cronjob`;
CREATE TABLE `llx_cronjob` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `jobtype` varchar(10) NOT NULL,
  `label` varchar(255) NOT NULL,
  `command` varchar(255) DEFAULT NULL,
  `classesname` varchar(255) DEFAULT NULL,
  `objectname` varchar(255) DEFAULT NULL,
  `methodename` varchar(255) DEFAULT NULL,
  `params` text,
  `md5params` varchar(32) DEFAULT NULL,
  `module_name` varchar(255) DEFAULT NULL,
  `priority` int DEFAULT '0',
  `datelastrun` datetime DEFAULT NULL,
  `datenextrun` datetime DEFAULT NULL,
  `datestart` datetime DEFAULT NULL,
  `dateend` datetime DEFAULT NULL,
  `datelastresult` datetime DEFAULT NULL,
  `lastresult` text,
  `lastoutput` text,
  `unitfrequency` varchar(255) NOT NULL DEFAULT '3600',
  `frequency` int NOT NULL DEFAULT '0',
  `maxrun` int NOT NULL DEFAULT '0',
  `nbrun` int DEFAULT NULL,
  `autodelete` int DEFAULT '0',
  `status` int NOT NULL DEFAULT '1',
  `processing` int NOT NULL DEFAULT '0',
  `test` varchar(255) DEFAULT '1',
  `fk_user_author` int DEFAULT NULL,
  `fk_user_mod` int DEFAULT NULL,
  `fk_mailing` int DEFAULT NULL,
  `note` text,
  `libname` varchar(255) DEFAULT NULL,
  `entity` int DEFAULT '0',
  `email_alert` varchar(128) DEFAULT NULL,
  `pid` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_cronjob` (`label`,`entity`),
  KEY `idx_cronjob_status` (`status`),
  KEY `idx_cronjob_datelastrun` (`datelastrun`),
  KEY `idx_cronjob_datenextrun` (`datenextrun`),
  KEY `idx_cronjob_datestart` (`datestart`),
  KEY `idx_cronjob_dateend` (`dateend`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `llx_cronjob` VALUES("1",NULL,"2018-11-02 20:55:08","method","RecurringInvoicesJob",NULL,"compta/facture/class/facture-rec.class.php","FactureRec","createRecurringInvoices",NULL,NULL,"facture","50",NULL,NULL,"2018-11-02 20:55:08",NULL,NULL,NULL,NULL,"86400","1","0",NULL,"0","1","0","$conf->facture->enabled",NULL,NULL,NULL,"Generate recurring invoices",NULL,"1",NULL,NULL);
INSERT INTO `llx_cronjob` VALUES("2",NULL,"2018-12-20 17:26:41","method","GCSCronjob_label",NULL,"/googlecontactsync/class/gcs.class.php","TGCSToken","gcs_cronjob_nyancat","50",NULL,"googlecontactsync","0",NULL,NULL,"2018-12-20 12:00:00",NULL,NULL,NULL,NULL,"60","30","0","0","0","0","0",NULL,"1","1",NULL,"",NULL,"1",NULL,NULL);
INSERT INTO `llx_cronjob` VALUES("3",NULL,"2024-03-23 15:26:17","method","SendEmailsRemindersOnInvoiceDueDate",NULL,"compta/facture/class/facture.class.php","Facture","sendEmailsRemindersOnInvoiceDueDate","10,all,EmailTemplateCode,duedate",NULL,"facture","50",NULL,NULL,"2024-03-23 23:00:00",NULL,NULL,NULL,NULL,"86400","1","0",NULL,"0","0","0","$conf->facture->enabled",NULL,NULL,NULL,"Send an email when we reach the invoice due date (or invoice date) - n days. First param is n, the number of days before due date (or invoice date) to send the remind (or after if value is negative), second parameter is \"all\" or a payment mode code, third parameter is the code of the email template to use (an email template with the EmailTemplateCode must exists. The version of the email template in the language of the thirdparty will be used in priority. Language of the thirdparty will be also used to update the PDF of the sent invoice). The fourth parameter is the string \"duedate\" (default) or \"invoicedate\" to define which date of the invoice to use.",NULL,"1",NULL,NULL);



DROP TABLE IF EXISTS `llx_default_values`;
CREATE TABLE `llx_default_values` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `type` varchar(10) DEFAULT NULL,
  `user_id` int NOT NULL DEFAULT '0',
  `page` varchar(255) DEFAULT NULL,
  `param` varchar(255) DEFAULT NULL,
  `value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_default_values` (`type`,`entity`,`user_id`,`page`,`param`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_delivery`;
CREATE TABLE `llx_delivery` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `ref` varchar(30) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `fk_soc` int NOT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `ref_int` varchar(255) DEFAULT NULL,
  `ref_customer` varchar(255) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `date_delivery` datetime DEFAULT NULL,
  `fk_address` int DEFAULT NULL,
  `fk_statut` smallint DEFAULT '0',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `fk_incoterms` int DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_delivery_uk_ref` (`ref`,`entity`),
  KEY `idx_delivery_fk_soc` (`fk_soc`),
  KEY `idx_delivery_fk_user_author` (`fk_user_author`),
  KEY `idx_delivery_fk_user_valid` (`fk_user_valid`),
  CONSTRAINT `fk_delivery_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_delivery_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_delivery_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_delivery_extrafields`;
CREATE TABLE `llx_delivery_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_livraison_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_deliverydet`;
CREATE TABLE `llx_deliverydet` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_delivery` int DEFAULT NULL,
  `fk_origin_line` int DEFAULT NULL,
  `fk_product` int DEFAULT NULL,
  `description` text,
  `qty` double DEFAULT NULL,
  `subprice` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `rang` int DEFAULT '0',
  PRIMARY KEY (`rowid`),
  KEY `idx_deliverydet_fk_delivery` (`fk_delivery`),
  CONSTRAINT `fk_deliverydet_fk_delivery` FOREIGN KEY (`fk_delivery`) REFERENCES `llx_delivery` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_deliverydet_extrafields`;
CREATE TABLE `llx_deliverydet_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_livraisondet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_deplacement`;
CREATE TABLE `llx_deplacement` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `datec` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `dated` datetime DEFAULT NULL,
  `fk_user` int NOT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `type` varchar(12) NOT NULL,
  `fk_statut` int NOT NULL DEFAULT '1',
  `km` double DEFAULT NULL,
  `fk_soc` int DEFAULT NULL,
  `fk_projet` int DEFAULT '0',
  `note_private` text,
  `note_public` text,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_document_model`;
CREATE TABLE `llx_document_model` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `nom` varchar(50) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `type` varchar(64) DEFAULT NULL,
  `libelle` varchar(255) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_document_model` (`nom`,`type`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO `llx_document_model` VALUES("1","azur","1","propal",NULL,NULL);
INSERT INTO `llx_document_model` VALUES("2","einstein","1","order",NULL,NULL);
INSERT INTO `llx_document_model` VALUES("3","crabe","1","invoice",NULL,NULL);
INSERT INTO `llx_document_model` VALUES("4","sepamandate","1","bankaccount","sepamandate",NULL);
INSERT INTO `llx_document_model` VALUES("5","eratosthene","1","order",NULL,NULL);
INSERT INTO `llx_document_model` VALUES("7","sponge","1","invoice",NULL,NULL);



DROP TABLE IF EXISTS `llx_don`;
CREATE TABLE `llx_don` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `tms` timestamp NULL DEFAULT NULL,
  `fk_statut` smallint NOT NULL DEFAULT '0',
  `datedon` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `fk_payment` int DEFAULT NULL,
  `paid` smallint NOT NULL DEFAULT '0',
  `firstname` varchar(50) DEFAULT NULL,
  `lastname` varchar(50) DEFAULT NULL,
  `societe` varchar(50) DEFAULT NULL,
  `address` text,
  `zip` varchar(30) DEFAULT NULL,
  `town` varchar(50) DEFAULT NULL,
  `country` varchar(50) DEFAULT NULL,
  `fk_country` int NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(24) DEFAULT NULL,
  `phone_mobile` varchar(24) DEFAULT NULL,
  `public` smallint NOT NULL DEFAULT '1',
  `fk_projet` int DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `fk_user_author` int NOT NULL,
  `date_valid` datetime DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `fk_soc` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_don_uk_ref` (`ref`,`entity`),
  KEY `idx_don_fk_soc` (`fk_soc`),
  KEY `idx_don_fk_project` (`fk_projet`),
  KEY `idx_don_fk_user_author` (`fk_user_author`),
  KEY `idx_don_fk_user_valid` (`fk_user_valid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_don_extrafields`;
CREATE TABLE `llx_don_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_don_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_ecm_directories`;
CREATE TABLE `llx_ecm_directories` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `label` varchar(64) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `fk_parent` int DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  `cachenbofdoc` int NOT NULL DEFAULT '0',
  `fullpath` varchar(750) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `date_c` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_c` int DEFAULT NULL,
  `fk_user_m` int DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `acl` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_ecm_directories` (`label`,`fk_parent`,`entity`),
  KEY `idx_ecm_directories_fk_user_c` (`fk_user_c`),
  KEY `idx_ecm_directories_fk_user_m` (`fk_user_m`),
  CONSTRAINT `fk_ecm_directories_fk_user_c` FOREIGN KEY (`fk_user_c`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_ecm_directories_fk_user_m` FOREIGN KEY (`fk_user_m`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_ecm_directories_extrafields`;
CREATE TABLE `llx_ecm_directories_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_ecm_directories_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_ecm_files`;
CREATE TABLE `llx_ecm_files` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(128) DEFAULT NULL,
  `label` varchar(128) NOT NULL,
  `share` varchar(128) DEFAULT NULL,
  `share_pass` varchar(32) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `filepath` varchar(255) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `src_object_type` varchar(64) DEFAULT NULL,
  `src_object_id` int DEFAULT NULL,
  `fullpath_orig` varchar(750) DEFAULT NULL,
  `description` text,
  `keywords` varchar(750) DEFAULT NULL,
  `cover` text,
  `position` int DEFAULT NULL,
  `gen_or_uploaded` varchar(12) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `date_c` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_c` int DEFAULT NULL,
  `fk_user_m` int DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `acl` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_ecm_files` (`filepath`,`filename`,`entity`),
  KEY `idx_ecm_files_label` (`label`)
) ENGINE=InnoDB AUTO_INCREMENT=221 DEFAULT CHARSET=latin1;

INSERT INTO `llx_ecm_files` VALUES("2","5db7124cb2780b4c41cd6ff73abcd43d","26b6e7b0ce778c80c688fead537f6b30",NULL,NULL,"1","commande/(PROV1)","(PROV1).pdf","commande","1","","",NULL,NULL,"1","generated",NULL,"2018-11-02 21:42:33","2018-11-02 21:42:33","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("3","b27a2419ebb9e534d6d9fb05b9cf461d","7cb9769f460960477e573bac2b6e328b",NULL,NULL,"1","commande/CO1810-0001","CO1810-0001.pdf","commande","1","","",NULL,NULL,"1","generated",NULL,"2018-11-02 21:44:53","2018-11-02 21:44:53","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("4","ad5cb957f68346751c26f9d4b0514bb7","716084f93112c658909a7accec7f58fc",NULL,NULL,"1","facture/(PROV1)","(PROV1).pdf","facture","1","","",NULL,NULL,"1","generated",NULL,"2018-11-03 12:16:48","2018-11-03 12:16:48","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("5","5ff261afde35281f2c593061a3b06c76","ba30f9b7c59c2f2bb2c7e94592857660",NULL,NULL,"1","facture/FA1810-0001","FA1810-0001.pdf","facture","1","","",NULL,NULL,"1","generated",NULL,"2018-11-03 12:25:18","2018-11-03 12:25:18","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("6","7ae20ec2199ccb742d22aec9e2c2c96c","0209a3401e6a994b03086c45a4a75b3b",NULL,NULL,"1","facture/FA1810-0002","FA1810-0002.pdf","facture","2","","",NULL,NULL,"1","generated",NULL,"2018-11-26 14:16:34","2018-11-26 14:16:34","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("7","0d1c00fbc00001e3098ae05dfbb32791","1c27e369fb8391a8352179555c65f085",NULL,NULL,"1","facture/(PROV3)","(PROV3).pdf","facture","3","","",NULL,NULL,"1","generated",NULL,"2018-12-09 15:58:47","2018-12-09 15:58:47","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("8","8f3c272d22b38f9708996b3fdd60cc4f","faf608416dcb66d5ba0a0aee7f81eb37",NULL,NULL,"1","facture/FA1812-0003","FA1812-0003.pdf","facture","3","","",NULL,NULL,"1","generated",NULL,"2018-12-09 15:59:10","2018-12-09 15:59:10","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("9","8e3afb925b9ce2d1d2a9bbb26930c693","1025c444daad7863cedcafdd22f40316",NULL,NULL,"1","commande/(PROV3)","(PROV3).pdf","commande","3","","",NULL,NULL,"1","generated",NULL,"2018-12-20 11:53:51","2018-12-20 11:53:51","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("10","a2f53e794592bbff345add234db8e137","bd73151443713992a6245e597d7ff180",NULL,NULL,"1","commande/CO1809-0002","CO1809-0002.pdf","commande","3","","",NULL,NULL,"1","generated",NULL,"2018-12-20 11:55:10","2018-12-20 11:55:10","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("11","1a1b8099c0d407b8b445cf5d9168e204","ab36dd464766b80c77a596c71b9e54e7",NULL,NULL,"1","facture/FA1806-0004","FA1806-0004.pdf","facture","4","","",NULL,NULL,"1","generated",NULL,"2018-12-20 11:57:26","2018-12-20 11:57:26","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("12","6a732fb89ef9fc77fd3399ce9828fd64","8a3c853b511c503881611099e8267af2",NULL,NULL,"1","propale/(PROV1)","(PROV1).pdf","propal","1","","",NULL,NULL,"1","generated",NULL,"2019-02-01 18:21:09","2019-02-01 18:21:09","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("13","ff6a28130fe700eeff33299ec745fa89","ba8763b80e739a7005cacbb3288a82df",NULL,NULL,"1","propale/PR1902-0001","PR1902-0001.pdf","propal","1","","",NULL,NULL,"1","generated",NULL,"2019-02-01 18:21:40","2019-02-01 18:21:40","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("14","1770992495b671ab2356c94316756579","c96bb8120cd633025e54ed8fa3301516",NULL,NULL,"1","facture/(PROV5)","(PROV5).pdf","facture","5","","",NULL,NULL,"1","generated",NULL,"2019-04-12 14:38:04","2019-04-12 14:38:04","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("15","c6363508edd5d664f8e28fb01f1131b3","26da62d591451c037ad49347abebc0f2",NULL,NULL,"1","facture/(PROV6)","(PROV6).pdf","facture","6","","",NULL,NULL,"1","generated",NULL,"2019-04-12 14:38:58","2019-04-12 14:38:58","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("16","7910754414e07a013b04e81f2a49052f","4a5a04fa47d4118af72635ecc935c233",NULL,NULL,"1","facture/(PROV7)","(PROV7).pdf","facture","7","","",NULL,NULL,"1","generated",NULL,"2019-04-12 14:39:21","2019-04-12 14:39:21","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("17","93fe7ba389a0a91b4b123220a7918904","a33ec0c77e1a5eeb25856a40b0862032",NULL,NULL,"1","facture/(PROV8)","(PROV8).pdf","facture","8","","",NULL,NULL,"1","generated",NULL,"2019-04-12 14:39:46","2019-04-12 14:39:46","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("18","8d55190bba6b9cd2253fea549cf932a0","c7322f6fe8eb5b7c331c7b3cceae0454",NULL,NULL,"1","facture/FA1901-0005","FA1901-0005.pdf","facture","5","","",NULL,NULL,"1","generated",NULL,"2019-04-12 14:56:00","2019-04-12 14:56:00","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("19","3ea3c6ff69f72f48b32210db44d8f685","092e26c0dbe8efc70bd85ff97a590d6d",NULL,NULL,"1","facture/FA1902-0006","FA1902-0006.pdf","facture","6","","",NULL,NULL,"1","generated",NULL,"2019-04-12 14:56:40","2019-04-12 14:56:40","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("20","622a3043380f70b29de46bec5ab12c26","d002cc31c0c23613787b6779e7d4790d",NULL,NULL,"1","facture/FA1903-0007","FA1903-0007.pdf","facture","7","","",NULL,NULL,"1","generated",NULL,"2019-04-12 14:57:00","2019-04-12 14:57:00","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("21","39c81ed9d4954eed52336af45f01cef9","cbe4e9c79f27d7e9d3c65d0c5502686e",NULL,NULL,"1","facture/FA1904-0008","FA1904-0008.pdf","facture","8","","",NULL,NULL,"1","generated",NULL,"2019-04-12 14:57:19","2019-04-12 14:57:19","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("22","b33f0003f7dab58d0fcaa04d2b313f06","18524b6f6a72a118385eb43c28c1f565",NULL,NULL,"1","facture/(PROV9)","(PROV9).pdf","facture","9","","",NULL,NULL,"1","generated",NULL,"2019-04-12 22:17:38","2019-04-12 22:17:38","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("23","5c497c8999c11106c67acad26d5ddee5","cda65482eef106c835671a9cb3b53571",NULL,NULL,"1","facture/FA1904-0009","FA1904-0009.pdf","facture","9","","",NULL,NULL,"1","generated",NULL,"2019-04-12 22:44:38","2019-04-12 22:44:38","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("24","f74f0819832199fa28bdac687ffb97e5","cdb6f6dc6240421fad4775f65be69085",NULL,NULL,"1","propale/(PROV2)","(PROV2).pdf","propal","2","","",NULL,NULL,"1","generated",NULL,"2019-04-15 18:07:02","2019-04-15 18:07:02","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("25","67aff7b004e64cab6644af020fb626cf","a6a96d1e0e61559effcf43cf47b36ea9",NULL,NULL,"1","propale/PR1904-0002","PR1904-0002.pdf","propal","2","","",NULL,NULL,"1","generated",NULL,"2019-04-18 15:35:28","2019-04-18 15:35:28","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("26","e7ddaffebbd1c9e1fd6462971e84f421","2cf2073f7bcbdbc774142859d9284f71",NULL,NULL,"1","facture/(PROV10)","(PROV10).pdf","facture","10","","",NULL,NULL,"1","generated",NULL,"2019-05-15 08:46:12","2019-05-15 08:46:12","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("27","6d9cd82be74b0c382e91ccc353f420f5","1a6a26cddcefd0c98ae4f97ad0fa60dd",NULL,NULL,"1","facture/FA1905-0010","FA1905-0010.pdf","facture","10","","",NULL,NULL,"1","generated",NULL,"2019-05-15 08:50:11","2019-05-15 08:50:11","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("28","d8a9d3bc2a181d35c1541be23b05996e","6bc271589cd7a49be7018ef38dd4d1c1",NULL,NULL,"1","facture/(PROV11)","(PROV11).pdf","facture","11","","",NULL,NULL,"1","generated",NULL,"2019-06-21 16:16:29","2019-06-21 16:16:29","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("29","175ef3073e5944079f35049bf3167435","5ce5e47126c9a9adadc8974f365680c0",NULL,NULL,"1","facture/FA1906-0011","FA1906-0011.pdf","facture","11","","",NULL,NULL,"1","generated",NULL,"2019-06-21 16:17:13","2019-06-21 16:17:13","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("30","fe157e7eba81452c8101b894f7ce810a","f98c3f3459f28dadbb44fc61cd225a75",NULL,NULL,"1","facture/(PROV12)","(PROV12).pdf","facture","12","","",NULL,NULL,"1","generated",NULL,"2019-08-08 16:40:02","2019-08-08 16:40:02","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("31","86491af349452600caa7054ece50a035","43edf3579659995a8d0e63499bffe7fd",NULL,NULL,"1","facture/FA1908-0012","FA1908-0012.pdf","facture","12","","",NULL,NULL,"1","generated",NULL,"2019-08-08 16:40:29","2019-08-08 16:40:29","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("32","a76e1d2e26bf0a1cd9655fcf376e4692","1f0c4413aa347879abbb57cb8a840905",NULL,NULL,"1","facture/(PROV13)","(PROV13).pdf","facture","13","","",NULL,NULL,"1","generated",NULL,"2019-08-08 16:41:06","2019-08-08 16:41:06","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("33","d53652884c8d4d87cf9f6af678cb9cea","d7a5873e38ef4a7ac95de39e7cd5820e",NULL,NULL,"1","facture/FA1908-0013","FA1908-0013.pdf","facture","13","","",NULL,NULL,"1","generated",NULL,"2019-08-08 16:41:35","2019-08-08 16:41:35","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("34","1d47ff1a4bc4be8f95ae87d30f323384","f0a2ab65df0d67d2ee8d369f85fee856",NULL,NULL,"1","propale/(PROV3)","(PROV3).pdf","propal","3","","",NULL,NULL,"1","generated",NULL,"2019-08-22 11:00:33","2019-08-22 11:00:33","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("35","c839eeb0a25668e0d347cc485e8a38b3","703c9b5910d80a556e9812f74d61b626",NULL,NULL,"1","facture/(PROV14)","(PROV14).pdf","facture","14","","",NULL,NULL,"1","generated",NULL,"2019-09-03 11:30:38","2019-09-03 11:30:38","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("36","f49655b95679fca279beb89a417014b5","db0561c76eabb797b77d3b4b0a135974",NULL,NULL,"1","facture/FA1909-0014","FA1909-0014.pdf","facture","14","","",NULL,NULL,"1","generated",NULL,"2019-09-03 11:32:07","2019-09-03 11:32:07","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("37","34ab6e7ca6b367ebe5772357895c7939","09e3617f8e99db83f0972d63594b78cd",NULL,NULL,"1","propale/PR1909-0003","PR1909-0003.pdf","propal","3","","",NULL,NULL,"1","generated",NULL,"2019-09-13 11:45:40","2019-09-13 11:45:40","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("38","8163032d624bbf3d4d63bee9f370d699","ac16526c71614c0e7bb44923160753e7",NULL,NULL,"1","facture/(PROV15)","(PROV15).pdf","facture","15","","",NULL,NULL,"1","generated",NULL,"2019-10-07 20:12:38","2019-10-07 20:12:38","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("39","fed9e35a2caecf1b941a1997e032e310","1bd05db3733d6a9fe5ee8e83ca0db57f",NULL,NULL,"1","facture/FA1910-0015","FA1910-0015.pdf","facture","15","","",NULL,NULL,"1","generated",NULL,"2019-10-07 20:12:52","2019-10-07 20:12:52","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("40","90865d73d9d3cb58674d4d5b029e7c5c","ed12d43592590b0a6a705288da0ebe73",NULL,NULL,"1","facture/(PROV16)","(PROV16).pdf","facture","16","","",NULL,NULL,"1","generated",NULL,"2019-10-31 17:15:05","2019-10-31 17:15:05","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("41","d6e6a12d7de295f3e8c943c609ecab20","00595aaa0e28cbb5b257dd5a37271e46",NULL,NULL,"1","facture/FA1910-0016","FA1910-0016.pdf","facture","16","","",NULL,NULL,"1","generated",NULL,"2019-11-04 12:01:38","2019-11-04 12:01:38","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("42","9d7699d01c32d47bfa8c07a383b6744b","bcb0bbda1f61fc0781588ddf3660b4ce",NULL,NULL,"1","facture/(PROV17)","(PROV17).pdf","facture","17","","",NULL,NULL,"1","generated",NULL,"2019-12-05 19:57:02","2019-12-05 19:57:02","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("43","0280814f80ac577935d710fa7cb315c9","d674706454123994074b2992aa020b11",NULL,NULL,"1","facture/FA1912-0017","FA1912-0017.pdf","facture","17","","",NULL,NULL,"1","generated",NULL,"2019-12-05 19:58:59","2019-12-05 19:58:59","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("44","5e6372dcb16c4edd10145221f026191d","e2ccb9cbb73337435f87c282614773de",NULL,NULL,"1","facture/(PROV18)","(PROV18).pdf","facture","18","","",NULL,NULL,"1","generated",NULL,"2019-12-17 08:55:24","2019-12-17 08:55:24","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("45","8d88764e9eae20b22f9707155c87ad47","82726f36129704bc6db1357a6f4add66",NULL,NULL,"1","facture/FA1912-0018","FA1912-0018.pdf","facture","18","","",NULL,NULL,"1","generated",NULL,"2019-12-17 08:56:04","2019-12-17 08:56:04","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("46","790d0de4bf6e33eded84a12c5563a0f8","e4397507a6493d360a1060d7429e63ef",NULL,NULL,"1","facture/(PROV19)","(PROV19).pdf","facture","19","","",NULL,NULL,"1","generated",NULL,"2019-12-17 08:57:04","2019-12-17 08:57:04","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("47","ff3d5104f63c8bf7e23e3c512bf7aea6","254c3eaa5cff31faa54212ea9eed823e",NULL,NULL,"1","facture/FA1912-0019","FA1912-0019.pdf","facture","19","","",NULL,NULL,"1","generated",NULL,"2019-12-17 08:57:10","2019-12-17 08:57:10","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("48","8c42538a44c9cef57142a30854cdfc7e","15727cd051b825b87a74562784c6d7ed",NULL,NULL,"1","facture/(PROV20)","(PROV20).pdf","facture","20","","",NULL,NULL,"1","generated",NULL,"2020-01-10 11:23:57","2020-01-10 11:23:57","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("49","6e372b1834d10160f0dc914b2434113f","bcc9678bd52240356e5364bd10b5a2fd",NULL,NULL,"1","facture/FA2001-0020","FA2001-0020.pdf","facture","20","","",NULL,NULL,"1","generated",NULL,"2020-01-10 11:24:16","2020-01-10 11:24:16","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("50","cabc585d1a4b112415cf042640b1a485","8de584c1364a2b75432b3ea20a61e581",NULL,NULL,"1","facture/(PROV21)","(PROV21).pdf","facture","21","","",NULL,NULL,"1","generated",NULL,"2020-01-24 16:09:33","2020-01-24 16:09:33","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("51","94ef77538b0f24cbdb22aed13eb776f7","3ffe10588f46ea5cd1ae81821a004197",NULL,NULL,"1","facture/FA2001-0021","FA2001-0021.pdf","facture","21","","",NULL,NULL,"1","generated",NULL,"2020-01-24 16:10:09","2020-01-24 16:10:09","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("52","74a9a6bd2ed4d6ef65e6c9928b06d322","7218ea92e194c9721bb2ae3131f80e8f",NULL,NULL,"1","facture/(PROV22)","(PROV22).pdf","facture","22","","",NULL,NULL,"1","generated",NULL,"2020-02-10 10:47:12","2020-02-10 10:47:12","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("53","d160817509ccb34e57f51e1a47cd4b65","b1629c1a0f9962491b0ea4aa65e0b62e",NULL,NULL,"1","facture/FA2002-0022","FA2002-0022.pdf","facture","22","","",NULL,NULL,"1","generated",NULL,"2020-02-10 10:47:31","2020-02-10 10:47:31","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("54","a751eb2ec8628b43c2c9cf63aadd83b3","20ab26fa730fbc596032678a74207172",NULL,NULL,"1","facture/(PROV23)","(PROV23).pdf","facture","23","","",NULL,NULL,"1","generated",NULL,"2020-02-10 10:52:12","2020-02-10 10:52:12","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("55","939b72a3d22fb8c2650d2b21b051ba62","cfbdc844b1cfbe64e56ae5c75ff285ad",NULL,NULL,"1","facture/FA2002-0023","FA2002-0023.pdf","facture","23","","",NULL,NULL,"1","generated",NULL,"2020-02-10 10:54:40","2020-02-10 10:54:40","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("56","8fc7903fcc9b1ef7462fcefb8b337f83","380109d5bdf8a547b4fe658fea2d778c",NULL,NULL,"1","facture/(PROV24)","(PROV24).pdf","facture","24","","",NULL,NULL,"1","generated",NULL,"2020-03-06 14:01:42","2020-03-06 14:01:42","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("57","9de9bad3206f6ded0ff8b2d3d54011b1","567cbbb76d1d3c8e93b48e96dbefccbd",NULL,NULL,"1","facture/(PROV25)","(PROV25).pdf","facture","25","","",NULL,NULL,"1","generated",NULL,"2020-06-07 10:47:10","2020-06-07 10:47:10","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("58","03a6cf0bc2601571168c6b40e34d6608","9c16ab12da8c8b33d7d70d76baeb2bea",NULL,NULL,"1","facture/FA2006-0024","FA2006-0024.pdf","facture","25","","",NULL,NULL,"1","generated",NULL,"2020-06-07 10:48:49","2020-06-07 10:48:49","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("59","a6e8a187abb77730cee83dd0d7100854","adf6b302ee681cf71b3378a36d9797d3",NULL,NULL,"1","facture/FA2003-0025","FA2003-0025.pdf","facture","26","","",NULL,NULL,"1","generated",NULL,"2020-06-10 12:18:42","2020-06-10 12:18:42","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("60","53acfe3dba1256a710458382e0d61b02","7e888151381c85f1b5ac35fea1bd1d84",NULL,NULL,"1","facture/(PROV27)","(PROV27).pdf","facture","27","","",NULL,NULL,"1","generated",NULL,"2020-06-10 12:19:57","2020-06-10 12:19:57","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("61","b8f168bd0609eb4043974471ac912522","6cc5fd620d9e23954c39dfd87b552673",NULL,NULL,"1","facture/FA2004-0026","FA2004-0026.pdf","facture","27","","",NULL,NULL,"1","generated",NULL,"2020-06-10 12:20:18","2020-06-10 12:20:18","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("62","3412d507ea0fb085a6c7e6b62acb1ea9","9a3e17098e79e4d758f05c3d3d14ba95",NULL,NULL,"1","facture/FA2005-0027","FA2005-0027.pdf","facture","28","","",NULL,NULL,"1","generated",NULL,"2020-06-10 12:20:59","2020-06-10 12:20:59","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("63","ad91a0da78e6fc31e5578f3150b6b7cf","60235f119bd8b3e101cc43d53ab18247",NULL,NULL,"1","facture/(PROV29)","(PROV29).pdf","facture","29","","",NULL,NULL,"1","generated",NULL,"2020-07-09 12:00:48","2020-07-09 12:00:48","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("64","0d0175250ce52b25fbf22d3b5a73a499","b698d52afe5108372378036131c7a5d6",NULL,NULL,"1","facture/FA2007-0028","FA2007-0028.pdf","facture","29","","",NULL,NULL,"1","generated",NULL,"2020-07-09 12:01:12","2020-07-09 12:01:12","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("65","975dd5d1f098270b3dd17a1a1be65b73","182788f7c4362d809980fc7734b1af8a",NULL,NULL,"1","facture/(PROV30)","(PROV30).pdf","facture","30","","",NULL,NULL,"1","generated",NULL,"2020-07-29 11:30:50","2020-07-29 11:30:50","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("66","25907fabcc57fad21222c4dce9cd0b27","2aef15b8ba3bf8d81fdf20842da1e76c",NULL,NULL,"1","facture/FA2007-0029","FA2007-0029.pdf","facture","30","","",NULL,NULL,"1","generated",NULL,"2020-07-29 11:34:14","2020-07-29 11:34:14","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("67","9efe3c8106e7c7df83d3d3e734825e29","1844f208f541ac3ee41eb1223321b445",NULL,NULL,"1","facture/(PROV31)","(PROV31).pdf","facture","31","","",NULL,NULL,"1","generated",NULL,"2020-08-05 11:26:53","2020-08-05 11:26:53","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("68","85f107d2d29a3f510c4eab65b00f8261","99fb3fec07fda5deb879d4e3891caca4",NULL,NULL,"1","facture/FA2008-0030","FA2008-0030.pdf","facture","31","","",NULL,NULL,"1","generated",NULL,"2020-08-05 11:27:10","2020-08-05 11:27:10","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("69","b8be05d542684ade1dd50c5b349214dd","7a65cbcb44c9a6bf9a6415a5edcdd454",NULL,NULL,"1","propale/(PROV4)","(PROV4).pdf","propal","4","","",NULL,NULL,"1","generated",NULL,"2020-08-06 17:54:40","2020-08-06 17:54:40","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("70","76dd820d3eafb0d514e78b2a80de2682","4829ad9f98e266d5367e8a1e06c0d287",NULL,NULL,"1","propale/PR2008-0004","PR2008-0004.pdf","propal","4","","",NULL,NULL,"1","generated",NULL,"2020-08-06 19:38:46","2020-08-06 19:38:46","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("71","429aea3fd3a3390d5a1a335ba7683b86","d49e94dbba67c3a9e77593ceb9476bd1",NULL,NULL,"1","propale/(PROV5)","(PROV5).pdf","propal","5","","",NULL,NULL,"1","generated",NULL,"2020-08-18 10:55:50","2020-08-18 10:55:50","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("72","c73ffd3e56d7434ff93da32711f2ef68","3965ae5d220efdccf91efd6a2d1df7b4",NULL,NULL,"1","propale/PR2008-0005","PR2008-0005.pdf","propal","5","","",NULL,NULL,"1","generated",NULL,"2020-08-18 11:00:10","2020-08-18 11:00:10","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("73","1224ea58ca77a15fcc1358f834ba6f05","2c2d4b276cd03c230ce0ed99ffd5f261",NULL,NULL,"1","facture/FA2008-0031","FA2008-0031.pdf","facture","32","","",NULL,NULL,"1","generated",NULL,"2020-08-21 16:59:10","2020-08-21 16:59:10","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("74","582775139faaa71ce8ad4b4cb38869f4","718804fda4fbc4c1f6f0e211e9871598",NULL,NULL,"1","propale/(PROV6)","(PROV6).pdf","propal","6","","",NULL,NULL,"1","generated",NULL,"2020-09-11 09:26:34","2020-09-11 09:26:34","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("75","555bfc3cb6481b250b89f17a1753f837","ee10e8549bd96952ef895642e6c13c92",NULL,NULL,"1","propale/PR2009-0006","PR2009-0006.pdf","propal","6","","",NULL,NULL,"1","generated",NULL,"2020-09-11 09:29:03","2020-09-11 09:29:03","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("76","72796979b375491789509c87bbf9ad6f","0b0af1afe136cac6a6ddbb1aaa20dc4d",NULL,NULL,"1","facture/(PROV33)","(PROV33).pdf","facture","33","","",NULL,NULL,"1","generated",NULL,"2020-09-21 18:39:14","2020-09-21 18:39:14","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("77","a8145720a0f5cb7eb540f47e622728d3","d91cbf348bf5f32b0f3bfff2b436e20b",NULL,NULL,"1","facture/FA2009-0032","FA2009-0032.pdf","facture","33","","",NULL,NULL,"1","generated",NULL,"2020-09-21 18:40:22","2020-09-21 18:40:22","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("78","66a23fe7c7ca7e281ea18c20e4e05077","5efc8120055705e8d78d8ad999e184ab",NULL,NULL,"1","facture/(PROV34)","(PROV34).pdf","facture","34","","",NULL,NULL,"1","generated",NULL,"2020-09-30 10:27:13","2020-09-30 10:27:13","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("79","932866c1efc1dcd5caa23f34e18dcbfd","161d42e91c794f0ad7ca8e53f1928459",NULL,NULL,"1","facture/FA2009-0033","FA2009-0033.pdf","facture","34","","",NULL,NULL,"1","generated",NULL,"2020-09-30 10:27:54","2020-09-30 10:27:54","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("80","974241a877229bcaf0f28036831d789e","d31188922a97d2ad1f5916b4383a59ca",NULL,NULL,"1","facture/(PROV35)","(PROV35).pdf","facture","35","","",NULL,NULL,"1","generated",NULL,"2020-09-30 10:31:37","2020-09-30 10:31:37","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("81","6be731db32dc5e3550e6e101412fb2c4","8aa8a617c72a79b86a820396faf7d874",NULL,NULL,"1","facture/(PROV36)","(PROV36).pdf","facture","36","","",NULL,NULL,"1","generated",NULL,"2020-09-30 10:32:20","2020-09-30 10:32:20","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("82","d1691a05407938b9ebe17b73011205ac","772fc0310294d6ada14aa387349eab69",NULL,NULL,"1","facture/FA2009-0034","FA2009-0034.pdf","facture","35","","",NULL,NULL,"1","generated",NULL,"2020-09-30 10:33:14","2020-09-30 10:33:14","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("83","1c366481d8f8ea49fe79f080852a819e","b97cc269a65559b793ebd9f6d27b0b68",NULL,NULL,"1","facture/FA2009-0035","FA2009-0035.pdf","facture","36","","",NULL,NULL,"1","generated",NULL,"2020-09-30 10:34:19","2020-09-30 10:34:19","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("84","4a428bb44d93caec1b2c6aaa3ce685c5","f63526a16834457d0ec4b39d3cb28474",NULL,NULL,"1","propale/(PROV7)","(PROV7).pdf","propal","7","","",NULL,NULL,"1","generated",NULL,"2020-11-04 12:26:27","2020-11-04 12:26:27","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("85","fe11deded5781715db792c10a1f1148f","ab58b7ab521fe2663e278647e4652c69",NULL,NULL,"1","propale/PR2011-0007","PR2011-0007.pdf","propal","7","","",NULL,NULL,"1","generated",NULL,"2020-11-04 20:37:55","2020-11-04 20:37:55","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("86","27eeb176b4c1757c9901e73335108e4e","aec92a2d74b38ce38e8eca3c16b3f6dc",NULL,NULL,"1","facture/(PROV37)","(PROV37).pdf","facture","37","","",NULL,NULL,"1","generated",NULL,"2020-12-26 19:14:03","2020-12-26 19:14:03","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("87","f7be5dd11e64d8bf2c0602d8866430ba","ac328ed391ab1865855ef6d3119ef5ff",NULL,NULL,"1","facture/FA2012-0036","FA2012-0036.pdf","facture","37","","",NULL,NULL,"1","generated",NULL,"2020-12-26 19:14:09","2020-12-26 19:14:09","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("88","8eeb6e23bdac35f2bb172b00805ccdaa","9c9b41dbc5afc9bce142fba509738a6a",NULL,NULL,"1","facture/(PROV38)","(PROV38).pdf","facture","38","","",NULL,NULL,"1","generated",NULL,"2020-12-26 19:15:08","2020-12-26 19:15:08","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("89","a73e10889e33cb5b652057d25859f936","b0c27745a16cc77cbe43e2d85961022f",NULL,NULL,"1","facture/FA2011-0037","FA2011-0037.pdf","facture","38","","",NULL,NULL,"1","generated",NULL,"2020-12-26 19:15:12","2020-12-26 19:15:12","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("90","905a0e0000c0568c254e83e97a08016e","64d836dc43deac9c969b047e33dbff4f",NULL,NULL,"1","facture/(PROV39)","(PROV39).pdf","facture","39","","",NULL,NULL,"1","generated",NULL,"2020-12-26 19:15:39","2020-12-26 19:15:39","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("91","5298faa630ca876d0a10fc49889667fe","a59046ebc4a367bad70121fea07e78cf",NULL,NULL,"1","facture/FA2012-0038","FA2012-0038.pdf","facture","39","","",NULL,NULL,"1","generated",NULL,"2020-12-26 19:16:21","2020-12-26 19:16:21","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("92","55f5b104e093455fd7e4cf88e4858cd9","23c8efbcf938697b898cfe99dcbab93b",NULL,NULL,"1","facture/(PROV40)","(PROV40).pdf","facture","40","","",NULL,NULL,"1","generated",NULL,"2020-12-26 19:23:57","2020-12-26 19:23:57","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("93","107841944d523172ae55d0369c63c535","c6e8e348a415e25b024c11056762d718",NULL,NULL,"1","facture/FA2010-0039","FA2010-0039.pdf","facture","40","","",NULL,NULL,"1","generated",NULL,"2020-12-26 19:26:11","2020-12-26 19:26:11","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("94","b8b505be95669fa27ddc9d2547596190","edcc034edc6f31efca196eff1b105006",NULL,NULL,"1","facture/(PROV41)","(PROV41).pdf","facture","41","","",NULL,NULL,"1","generated",NULL,"2021-01-15 18:55:16","2021-01-15 18:55:16","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("95","fed50c0d6b3354d693053de1a2f41be3","e7bdd9e08699b56f9c3c8da378589d24",NULL,NULL,"1","facture/FA2012-0040","FA2012-0040.pdf","facture","41","","",NULL,NULL,"1","generated",NULL,"2021-01-15 18:57:09","2021-01-15 18:57:09","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("96","9f04278ca537f5409f56ba0f044af878","c9c20d1f9f32c675c2eddc948056c63e",NULL,NULL,"1","propale/(PROV8)","(PROV8).pdf","propal","8","","",NULL,NULL,"1","generated",NULL,"2021-02-18 17:44:16","2021-02-18 17:44:16","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("97","23c9d5678f8eb535f606857cdfd0cad7","df88f48eb3e0aaae18cc23a316682c97",NULL,NULL,"1","propale/PR2102-0008","PR2102-0008.pdf","propal","8","","",NULL,NULL,"1","generated",NULL,"2021-02-18 18:49:17","2021-02-18 18:49:17","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("98","51a5555e1ca70c4711b258418d87a6bd","c5c3142310b92814d77189376ab3b25c",NULL,NULL,"1","facture/FA2103-0041","FA2103-0041.pdf","facture","42","","",NULL,NULL,"1","generated",NULL,"2021-03-21 20:10:07","2021-03-21 20:10:07","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("99","93b5c27963fa099d615cbfdcea3c54d1","53f612225726bcd4b417e82dfa0b2533",NULL,NULL,"1","facture/FA2103-0042","FA2103-0042.pdf","facture","43","","",NULL,NULL,"1","generated",NULL,"2021-03-21 20:12:10","2021-03-21 20:12:10","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("100","3623c5162c7228188c3107404f2e13d9","1b0a6b9fdd1d6d8e0419c795f6c163a2",NULL,NULL,"1","facture/(PROV44)","(PROV44).pdf","facture","44","","",NULL,NULL,"1","generated",NULL,"2021-03-21 20:56:01","2021-03-21 20:56:01","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("101","955210e3169d10215a496bc5e4ea3ba4","50e59ac81862307fee5f59ab36983c57",NULL,NULL,"1","facture/FA2103-0043","FA2103-0043.pdf","facture","44","","",NULL,NULL,"1","generated",NULL,"2021-03-21 20:56:49","2021-03-21 20:56:49","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("102","bbfe311ec9ff60cfcc403687f937ad51","abd56e38d4e4f4c7b45af64eaf796457",NULL,NULL,"1","facture/(PROV45)","(PROV45).pdf","facture","45","","",NULL,NULL,"1","generated",NULL,"2021-04-20 13:15:21","2021-04-20 13:15:21","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("103","6d6d3749135d61a1e437eb5cf69ba44d","a77901e901c41a4fa31a9b85bfbccc2f",NULL,NULL,"1","facture/FA2104-0044","FA2104-0044.pdf","facture","45","","",NULL,NULL,"1","generated",NULL,"2021-04-20 13:15:54","2021-04-20 13:15:54","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("104","7b902a40877b941cf17363f38f4ef093","100341dfd5069a77a3e85aa1ea26dc42",NULL,NULL,"1","propale/(PROV9)","(PROV9).pdf","propal","9","","",NULL,NULL,"1","generated",NULL,"2021-05-03 19:54:05","2021-05-03 19:54:05","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("105","ad9897623c4c22ded30f445bfd1fd719","81a9f7e65ed8752cbb89a72778942571",NULL,NULL,"1","propale/PR2105-0009","PR2105-0009.pdf","propal","9","","",NULL,NULL,"1","generated",NULL,"2021-05-04 13:29:32","2021-05-04 13:29:32","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("106","3fbba0fe78c7bc653125bde3a9de339e","1f9742c6a19675054a20f55e0399960f",NULL,NULL,"1","facture/(PROV46)","(PROV46).pdf","facture","46","","",NULL,NULL,"1","generated",NULL,"2021-05-04 13:36:35","2021-05-04 13:36:35","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("107","a8115e058f62cd0189b524ed093974d0","bcf1c4b8c0b511cc7e4906bfa4720a87",NULL,NULL,"1","facture/FA2105-0045","FA2105-0045.pdf","facture","46","","",NULL,NULL,"1","generated",NULL,"2021-05-04 13:40:21","2021-05-04 13:40:21","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("108","f8c3182dd93a6cfb681cc391d402330a","9f0da96df7ae1d854987f00d909d6fc1",NULL,NULL,"1","propale/(PROV10)","(PROV10).pdf","propal","10","","",NULL,NULL,"1","generated",NULL,"2021-08-02 09:00:27","2021-08-02 09:00:27","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("109","39bf347f9e493466767ba440db1aeda7","0d7591c93b92cf063f34b54c5b31a632",NULL,NULL,"1","propale/PR2108-0010","PR2108-0010.pdf","propal","10","","",NULL,NULL,"1","generated",NULL,"2021-08-02 09:01:24","2021-08-02 09:01:24","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("110","3a6e658b2d19f2c1399fc896f34c3c3d","5fa35e054e02ae115311dfe04aec48b0",NULL,NULL,"1","facture/(PROV47)","(PROV47).pdf","facture","47","","",NULL,NULL,"1","generated",NULL,"2021-08-08 08:36:18","2021-08-08 08:36:18","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("111","371220cc7710feb4114ddfe66e5097bd","b4acaaca0eb9113d481c9d30b5716ce4",NULL,NULL,"1","facture/FA2104-0046","FA2104-0046.pdf","facture","47","","",NULL,NULL,"1","generated",NULL,"2021-08-08 08:37:28","2021-08-08 08:37:28","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("112","72556b54ffa7673a5c5a55d0b3cf7f19","ed2b8571279a1411f66f3cbba4d99af5",NULL,NULL,"1","facture/(PROV48)","(PROV48).pdf","facture","48","","",NULL,NULL,"1","generated",NULL,"2021-08-08 08:38:28","2021-08-08 08:38:28","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("113","9c56e1fc543a4aa5204d5cf191ab8a2b","222480c45d7ae0d9949ebac1adb1f2a8",NULL,NULL,"1","facture/FA2105-0047","FA2105-0047.pdf","facture","48","","",NULL,NULL,"1","generated",NULL,"2021-08-08 08:40:39","2021-08-08 08:40:39","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("114","e814b811cd0eae84a52a48a71e22bcae","bc9de1907382d77ed60a11f234a3e451",NULL,NULL,"1","facture/(PROV49)","(PROV49).pdf","facture","49","","",NULL,NULL,"1","generated",NULL,"2021-08-08 08:41:08","2021-08-08 08:41:08","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("115","746e06bbccfabf55d015521ab22109c7","7bc2d1d62a8c1b24bca369f3079b26bf",NULL,NULL,"1","facture/FA2106-0048","FA2106-0048.pdf","facture","49","","",NULL,NULL,"1","generated",NULL,"2021-08-08 08:41:33","2021-08-08 08:41:33","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("116","aacb70af047e08d6a50dd8c5c37d7875","6a643c8d9ac399716749eed52ea10659",NULL,NULL,"1","facture/(PROV50)","(PROV50).pdf","facture","50","","",NULL,NULL,"1","generated",NULL,"2021-08-08 08:41:54","2021-08-08 08:41:54","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("117","b218636defaa121b2d119903dff9a1de","2e1c7c5c60812d6cb5bce404a9a2b201",NULL,NULL,"1","facture/FA2107-0049","FA2107-0049.pdf","facture","50","","",NULL,NULL,"1","generated",NULL,"2021-08-08 08:42:42","2021-08-08 08:42:42","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("118","a3988a3895de86d2f4d8d91e3cf60007","ba6f3885a630bd1817b710184d42ec2e",NULL,NULL,"1","facture/FA2109-0050","FA2109-0050.pdf","facture","51","","","",NULL,"1","generated",NULL,"2021-09-20 18:28:32","2024-03-23 21:26:17","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("119","9a656513d4f7b1c833406d29e356caff","1111bceefe6fa3f035dc31335322224e",NULL,NULL,"1","propale/(PROV11)","(PROV11).pdf","propal","11","","",NULL,NULL,"1","generated",NULL,"2021-09-25 15:30:35","2021-09-25 15:30:35","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("120","a7ea04b17203df1fa8f69e14b318d0b8","b3e82c9d9c6bb0d3e6a4668996b20c61",NULL,NULL,"1","propale/PR2109-0011","PR2109-0011.pdf","propal","11","","",NULL,NULL,"1","generated",NULL,"2021-09-25 15:32:30","2021-09-25 15:32:30","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("121","16c08bd9c31c4fa906d4cae7abc30976","83afad5a2a2588d3a152f81ee530d528",NULL,NULL,"1","facture/(PROV52)","(PROV52).pdf","facture","52","","",NULL,NULL,"1","generated",NULL,"2021-09-25 15:55:18","2021-09-25 15:55:18","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("122","619f9bcf4f0a62ad350eb1972d770eb8","5a507114c663f24403366810b3d9780e",NULL,NULL,"1","facture/FA2109-0051","FA2109-0051.pdf","facture","52","","",NULL,NULL,"1","generated",NULL,"2021-09-25 15:55:44","2021-09-25 15:55:44","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("123","82410d82f49f403994afff26005e9caf","09aa7de7816e221248d459bf750c8554",NULL,NULL,"1","facture/(PROV53)","(PROV53).pdf","facture","53","","",NULL,NULL,"1","generated",NULL,"2021-11-22 18:52:49","2021-11-22 18:52:49","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("124","d3e1b13428811b91fb60dc0a6b7ffc07","af9da3bb2dd127426169600616521ea2",NULL,NULL,"1","facture/FA2105-0052","FA2105-0052.pdf","facture","53","","",NULL,NULL,"1","generated",NULL,"2021-11-22 18:56:01","2021-11-22 18:56:01","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("125","9caec56ea453fd155978d19562369aba","53bd4730951a4259e3238bccdbed6444",NULL,NULL,"1","facture/(PROV54)","(PROV54).pdf","facture","54","","",NULL,NULL,"1","generated",NULL,"2021-11-22 19:09:20","2021-11-22 19:09:20","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("126","81b50b8076a006836a228bb124a762d6","15091a27c1cf0a62fc6f3661b1a63c74",NULL,NULL,"1","facture/FA2012-0053","FA2012-0053.pdf","facture","54","","",NULL,NULL,"1","generated",NULL,"2021-11-22 19:14:36","2021-11-22 19:14:36","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("127","b1d65efdd631e8196c042ac80b8d182e","60b2910e70a754c1e2fd433f47d66665",NULL,NULL,"1","facture/(PROV55)","(PROV55).pdf","facture","55","","",NULL,NULL,"1","generated",NULL,"2021-11-22 19:17:01","2021-11-22 19:17:01","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("128","74957947614a99422614f8eb92c1eda3","b28a01bc2a996431ace72b52012ffa20",NULL,NULL,"1","facture/FA2111-0054","FA2111-0054.pdf","facture","55","","",NULL,NULL,"1","generated",NULL,"2021-11-22 19:17:53","2021-11-22 19:17:53","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("129","c3b9d5b86528208cd46bb0d679830718","c1381571bd94e575f11dd88895165c17",NULL,NULL,"1","facture/(PROV56)","(PROV56).pdf","facture","56","","",NULL,NULL,"1","generated",NULL,"2022-03-03 20:40:28","2022-03-03 20:40:28","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("130","1c75efd9137b6406cb9fee139043b7b1","16488ed46c351a26830d665bd82ddca1",NULL,NULL,"1","facture/FA2201-0055","FA2201-0055.pdf","facture","56","","",NULL,NULL,"1","generated",NULL,"2022-03-03 20:40:41","2022-03-03 20:40:41","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("131","d3cc9689d92d5b7ae4fab95e0de82a4e","7bc5c50f223479799f6db5c3e53a2787",NULL,NULL,"1","facture/(PROV57)","(PROV57).pdf","facture","57","","",NULL,NULL,"1","generated",NULL,"2022-03-03 20:41:27","2022-03-03 20:41:27","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("132","3ffbc16d44224f2db8fa50eb7e9b3cf2","ee4e7ac6665ef362f911bd0f3f7a0354",NULL,NULL,"1","facture/FA2203-0056","FA2203-0056.pdf","facture","57","","",NULL,NULL,"1","generated",NULL,"2022-03-03 20:41:53","2022-03-03 20:41:53","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("133","6e5dc8db578ee12c3fb40c7a73ad1f84","066a0f6503f73f06fc0a47192f893c4f",NULL,NULL,"1","facture/(PROV58)","(PROV58).pdf","facture","58","","",NULL,NULL,"1","generated",NULL,"2022-03-03 20:57:12","2022-03-03 20:57:12","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("134","6f76823f24bf02fb6b7eb6a25a8e80b5","1f3da91242d38be9f1dbfc5b351c1b50",NULL,NULL,"1","facture/FA2203-0057","FA2203-0057.pdf","facture","58","","",NULL,NULL,"1","generated",NULL,"2022-03-03 20:57:42","2022-03-03 20:57:42","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("135","99a25124c96cf96fe26cbd8a46f67cd3","6200cb6c985e5ec5e8557ab64293be3a",NULL,NULL,"1","facture/(PROV59)","(PROV59).pdf","facture","59","","",NULL,NULL,"1","generated",NULL,"2022-03-03 21:08:35","2022-03-03 21:08:35","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("136","b9468ca8a27df63224c36a26cf328ac6","c414e3339d9db8dbeba174b54626d7d2",NULL,NULL,"1","facture/FA2203-0058","FA2203-0058.pdf","facture","59","","",NULL,NULL,"1","generated",NULL,"2022-03-03 21:08:44","2022-03-03 21:08:44","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("137","c58b530c9230c1a32d70b054f3934f7f","b91bf84f575ba6a8c03e6fd6e594136e",NULL,NULL,"1","propale/(PROV12)","(PROV12).pdf","propal","12","","",NULL,NULL,"1","generated",NULL,"2022-04-04 16:36:01","2022-04-04 16:36:01","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("138","fbe0cfaa2f9e09087a0039e8dad689e5","00204b603881ee303540c0b5db6d15e7",NULL,NULL,"1","propale/PR2204-0012","PR2204-0012.pdf","propal","12","","",NULL,NULL,"1","generated",NULL,"2022-04-04 16:48:10","2022-04-04 16:48:10","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("139","e2290d0bda4b2a18821ef9a32d92264a","bb624fa35d9edcabf9d80b1d48a99da7",NULL,NULL,"1","facture/(PROV60)","(PROV60).pdf","facture","60","","",NULL,NULL,"1","generated",NULL,"2022-04-11 14:07:28","2022-04-11 14:07:28","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("140","d1113bef4feda6e77b552b1e9997309b","8fd3813a60bcc1bff6a0fc0843b3db14",NULL,NULL,"1","facture/FA2101-0059","FA2101-0059.pdf","facture","60","","",NULL,NULL,"1","generated",NULL,"2022-04-11 14:07:35","2022-04-11 14:07:35","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("141","78d848f75b22f2ad222cb6a55d7b913e","4092f34e41958ceeb34a79051c1e7652",NULL,NULL,"1","facture/(PROV61)","(PROV61).pdf","facture","61","","",NULL,NULL,"1","generated",NULL,"2022-06-07 19:08:14","2022-06-07 19:08:14","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("142","d0df73365bbc794d2912241932b74558","05fc8f20bad37f42c05e8fef9d7c52eb",NULL,NULL,"1","facture/FA2206-0060","FA2206-0060.pdf","facture","61","","",NULL,NULL,"1","generated",NULL,"2022-06-07 19:09:13","2022-06-07 19:09:13","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("143","39d3422e14d4b26f44ef2256e2076509","258f5abb5ddc92038df2ad02c482ffa1",NULL,NULL,"1","facture/(PROV62)","(PROV62).pdf","facture","62","","",NULL,NULL,"1","generated",NULL,"2022-06-13 10:33:24","2022-06-13 10:33:24","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("145","88ff59fc4519cb14dfaa39a838dbc517","091360c448e72b3cdcb805aa8122bfec",NULL,NULL,"1","facture/(PROV63)","(PROV63).pdf","facture","63","","",NULL,NULL,"1","generated",NULL,"2022-06-13 10:38:46","2022-06-13 10:38:46","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("146","ef949992ef5bde841057849c72da0180","fd9bc3501a78c9299a0b4caffcc4199b",NULL,NULL,"1","facture/FA2206-0062","FA2206-0062.pdf","facture","63","","",NULL,NULL,"1","generated",NULL,"2022-06-13 10:42:47","2022-06-13 10:42:47","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("147","057c752bcbc2bd0b48e212f06aaae00f","c19d0da63f364e8f7910c0a6d01f6ceb",NULL,NULL,"1","facture/FA2206-0063","FA2206-0063.pdf","facture","64","","",NULL,NULL,"1","generated",NULL,"2022-06-13 11:26:56","2022-06-13 11:26:56","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("148","f58ec6dd6e0615ad7170415d8b855f50","946744e69bd8c10ab0f4431272d371c3",NULL,NULL,"1","facture/(PROV65)","(PROV65).pdf","facture","65","","",NULL,NULL,"1","generated",NULL,"2022-09-08 09:16:58","2022-09-08 09:16:58","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("149","aa0c91b8f2120c23057fddb45ba30aa4","467fec7c0c53f3e92bcc8dda18e56e02",NULL,NULL,"1","propale/(PROV13)","(PROV13).pdf","propal","13","","",NULL,NULL,"1","generated",NULL,"2022-09-30 15:58:31","2022-09-30 15:58:31","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("150","926c203ed61e3f3fd43a9269e3ced059","240ed4e334f9cdf859a4bb021f493467",NULL,NULL,"1","propale/(PROV14)","(PROV14).pdf","propal","14","","",NULL,NULL,"1","generated",NULL,"2022-09-30 16:05:53","2022-09-30 16:05:53","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("151","5ee5b7c756d92894c95c3bdcaf30313c","62c22b026e43a03a8763e591e824f711",NULL,NULL,"1","propale/PR2209-0013","PR2209-0013.pdf","propal","14","","",NULL,NULL,"1","generated",NULL,"2022-09-30 18:39:23","2022-09-30 18:39:23","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("152","d69c4b31e63f034a81dddd702b30fac4","e795ce937e70e9d0f98d2b2db6252892",NULL,NULL,"1","facture/FA2209-0064","FA2209-0064.pdf","facture","65","","",NULL,NULL,"1","generated",NULL,"2022-10-14 21:38:06","2022-10-14 21:38:06","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("153","dc93744cdb21f54bb7bff51d75b024a1","176de5edbe0194801b76d5c25a750d3a",NULL,NULL,"1","facture/(PROV66)","(PROV66).pdf","facture","66","","",NULL,NULL,"1","generated",NULL,"2022-10-27 17:12:14","2022-10-27 17:12:14","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("154","80e878312b49a0256e30a7f5f2278887","f64b3253f446613a5c8df6162fd1a239",NULL,NULL,"1","facture/FA2204-0065","FA2204-0065.pdf","facture","66","","",NULL,NULL,"1","generated",NULL,"2022-10-27 17:12:52","2022-10-27 17:12:52","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("155","59981e54d64da9d891381b8801e8dc91","7df12a92de7f3725651826426dc9cb9a",NULL,NULL,"1","facture/FA2206-0061","FA2206-0061.pdf","facture","62","","","",NULL,"1","generated",NULL,"2022-11-15 21:10:57","2024-11-20 15:57:42","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("156","1b0bea19b93212814f0536fe66521be2","52551590ec9ac0cdad86e74a592febe8",NULL,NULL,"1","facture/FA2211-0066","FA2211-0066.pdf","facture","67","","",NULL,NULL,"1","generated",NULL,"2022-11-25 18:32:43","2022-11-25 18:32:43","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("157","769509e21a09e711259c27e58a681417","76b65509a8cd153d879640d99668b698",NULL,NULL,"1","facture/(PROV68)","(PROV68).pdf","facture","68","","",NULL,NULL,"1","generated",NULL,"2023-05-15 19:51:59","2023-05-15 19:51:59","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("158","f0421eabec37c395e465c3f87e32c27a","1e830b168bb91df269ca4a344f1ee566",NULL,NULL,"1","facture/FA2305-0067","FA2305-0067.pdf","facture","68","","",NULL,NULL,"1","generated",NULL,"2023-05-15 19:52:10","2023-05-15 19:52:10","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("159","375b76af1747f72ceb5e65d181c3199f","a12d890c0973c56951d67acaaa163788",NULL,NULL,"1","propale/(PROV15)","(PROV15).pdf","propal","15","","",NULL,NULL,"1","generated",NULL,"2023-05-26 13:38:39","2023-05-26 13:38:39","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("160","689c9e71097f49f69a37eb8d2f25d475","aab2c2f100b47b0e284bda35e9a87f66",NULL,NULL,"1","propale/PR2305-0014","PR2305-0014.pdf","propal","15","","",NULL,NULL,"1","generated",NULL,"2023-05-26 13:40:37","2023-05-26 13:40:37","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("161","9b6c4c5494ce2298fb6a2ae1fd751598","55d35603d84845e166a11567d06f8ed3",NULL,NULL,"1","propale/(PROV16)","(PROV16).pdf","propal","16","","",NULL,NULL,"1","generated",NULL,"2023-05-31 00:28:22","2023-05-31 00:28:22","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("162","e54ba969bb102a4eac90f50f7b51bcb9","dbe9eb53174f444ee3eff3b530b6eec7","5K46pOAca0432jViMShhjhB0rNYKf7X4",NULL,"1","propale/PR2306-0015","PR2306-0015.pdf","propal","16","","","",NULL,"1","generated",NULL,"2023-06-02 17:30:03","2025-06-14 17:29:35","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("163","84cabf31c32c3cd826d3cc5bbe9d26f9","868af6c0895b34a5faca90c2dcab14a7",NULL,NULL,"1","facture/FA2306-0068","FA2306-0068.pdf","facture","70","","",NULL,NULL,"1","generated",NULL,"2023-06-02 17:31:03","2023-06-02 17:31:03","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("164","a139f2cd770582e31030db7f40adcc61","bab17b0b86d19bd088f087d6630bc71a",NULL,NULL,"1","facture/FA2306-0069","FA2306-0069.pdf","facture","71","","",NULL,NULL,"1","generated",NULL,"2023-06-05 20:02:01","2023-06-05 20:02:01","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("165","4cc867bba1afbd73ef8894ba2a1b4612","58fe1a3a67a33d66873ebc112b04dc2e",NULL,NULL,"1","facture/(PROV72)","(PROV72).pdf","facture","72","","",NULL,NULL,"1","generated",NULL,"2023-08-10 18:32:58","2023-08-10 18:32:58","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("166","1f8a3b7f191a8780632e5966fa7b654a","7b471f489c99b60274357ad8c35206c7",NULL,NULL,"1","facture/FA2308-0070","FA2308-0070.pdf","facture","72","","",NULL,NULL,"1","generated",NULL,"2023-08-10 18:33:13","2023-08-10 18:33:13","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("167","24b9836e9b560b38546a4c2b1c6ec9ae","3fe31b1f8857138e92048f2faf32a61a",NULL,NULL,"1","facture/(PROV73)","(PROV73).pdf","facture","73","","",NULL,NULL,"1","generated",NULL,"2023-09-05 18:13:31","2023-09-05 18:13:31","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("168","ed498413f647eab375a8e54d1f008db9","13075dcad52464f351d91962eb0f4897",NULL,NULL,"1","facture/FA2309-0071","FA2309-0071.pdf","facture","73","","","",NULL,"1","generated",NULL,"2023-09-05 18:13:55","2024-11-20 15:52:47","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("169","a4a802a0a45054f05f279e2b3e9aa14f","9f4cb36ed4005e4f3df5ccc851e0425a",NULL,NULL,"1","facture/(PROV74)","(PROV74).pdf","facture","74","","",NULL,NULL,"1","generated",NULL,"2023-09-11 11:05:07","2023-09-11 11:05:07","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("170","4b19ccd7dd0d8280a9a4692f865f0043","46e80831e5b1bb3dbad143a1985190fc",NULL,NULL,"1","facture/FA2309-0072","FA2309-0072.pdf","facture","74","","",NULL,NULL,"1","generated",NULL,"2023-09-11 11:05:44","2023-09-11 11:05:44","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("171","34c46f70a2005746eac7f8761448d8ab","8a727cbacf0a0429b1e6a457b53bce50",NULL,NULL,"1","propale/(PROV17)","(PROV17).pdf","propal","17","","",NULL,NULL,"1","generated",NULL,"2023-09-18 17:58:55","2023-09-18 17:58:55","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("172","d5a8769b75fd56fac27c2a858cb6c3dc","139d4c09520889952fb346b06bda2ff0",NULL,NULL,"1","propale/PR2309-0016","PR2309-0016.pdf","propal","17","","",NULL,NULL,"1","generated",NULL,"2023-09-18 18:05:41","2023-09-18 18:05:41","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("173","c2dbf636424c38b5694e2cc0c371252e","775dad7e4c73dd7b608fe6b1b24e31f5",NULL,NULL,"1","commande/CO2309-0003","CO2309-0003.pdf","commande","4","","",NULL,NULL,"1","generated",NULL,"2023-09-18 18:11:50","2023-09-18 18:11:50","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("174","3fa263722736c5c97bc109f93ee3af12","cbafc054f4ca5fe1f2db86bad43a05a7",NULL,NULL,"1","facture/FA2311-0073","FA2311-0073.pdf","facture","75","","",NULL,NULL,"1","generated",NULL,"2023-11-13 18:58:10","2023-11-13 18:58:10","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("175","df54bb2f6c2b5ee620ed0d9ddb54c64e","7aae44194e94b400d0063c216fae2951",NULL,NULL,"1","facture/(PROV76)","(PROV76).pdf","facture","76","","",NULL,NULL,"1","generated",NULL,"2023-12-13 19:50:56","2023-12-13 19:50:56","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("176","560a614d1fa6294c4316ed2deb5d304b","506bec4ca07216ca5286c547d8268c9d",NULL,NULL,"1","facture/FA2312-0074","FA2312-0074.pdf","facture","76","","",NULL,NULL,"1","generated",NULL,"2023-12-13 19:51:03","2023-12-13 19:51:03","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("177","d94ddb70ea9a40c95bef3bd32c530bb4","0ea9245e41b39f85cb6687c89a1082fa",NULL,NULL,"1","propale/(PROV18)","(PROV18).pdf","propal","18","","",NULL,NULL,"1","generated",NULL,"2024-02-02 09:25:00","2024-02-02 09:25:00","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("178","90e825242e4a05a2c770beb9e39f8f04","8b2127a21230cf27771a63d2265a21e9",NULL,NULL,"1","propale/PR2402-0017","PR2402-0017.pdf","propal","18","","",NULL,NULL,"1","generated",NULL,"2024-02-02 09:27:54","2024-02-02 09:27:54","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("179","67b67e7a71916bad7d95695f7dbc4cea","cc31d01c943bec953a914eec65167b8e",NULL,NULL,"1","facture/FA2401-0075","FA2401-0075.pdf","facture","77","","","",NULL,"1","generated",NULL,"2024-02-02 09:28:50","2024-03-23 21:20:57","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("180","26ee11de657612f0fce72a4efb33cc58","830854e73fe678d46adc1fe7d5b041a6","6U1jZY8HkkkdQ2x70dlG6B33m5QUGydI",NULL,"1","propale/PR2404-0018","PR2404-0018.pdf","propal","19","","","",NULL,"1","generated",NULL,"2024-04-10 19:06:39","2024-04-11 15:12:41","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("181","a5f8ae50e91179a3a4a13e663242dedc","97d356dcbcd450d1b752bf6da9a344fa",NULL,NULL,"1","facture/FA2404-0076","FA2404-0076.pdf","facture","78","","","",NULL,"1","generated",NULL,"2024-04-11 15:13:19","2024-04-11 15:13:19","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("182","80633d2bdd44829850ca327fa96ff33a","a432ec50ec7973505af27371630fad0b","lXurdTDAgDG0kBs8l7B71OhAa2u2468O",NULL,"1","propale/PR2408-0019","PR2408-0019.pdf","propal","20","","","",NULL,"1","generated",NULL,"2024-08-09 16:55:22","2024-08-09 17:06:48","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("183","bb0505660274bd5d84006d7a9aaf6174","c2974d56d96ab6585928ef806659259b",NULL,NULL,"1","facture/FA2408-0077","FA2408-0077.pdf","facture","79","","","",NULL,"1","generated",NULL,"2024-08-09 17:07:11","2024-08-10 11:57:09","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("184","5973e03df2589b664760baa2b3845123","0af19c788cf8da8bba28397243f66e43","eOl9Kv3P99a4HXq00urUIR3sNx1Q9Wvb",NULL,"1","propale/PR2409-0020","PR2409-0020.pdf","propal","21","","","",NULL,"1","generated",NULL,"2024-09-21 19:13:54","2024-10-05 10:24:51","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("185","b940be26cb8a227956665c6eb2ee6ccc","e442945d0b37aea8eaadcc7778085110",NULL,NULL,"1","facture/FA2410-0078","FA2410-0078.pdf","facture","80","","","",NULL,"1","generated",NULL,"2024-10-05 10:28:19","2024-10-11 18:31:57","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("186","863d04f03b0f92b57edc0a37a4471adc","bec4baae25399c34d895a12442c66028","9lNQ3Eb9vQfXcvylm7L722487DEDPmgS",NULL,"1","propale/PR2410-0021","PR2410-0021.pdf","propal","22","","","",NULL,"1","generated",NULL,"2024-10-05 10:43:48","2024-10-05 10:48:21","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("187","96335130aee10b6ed3458d15d386c1cb","2b18e37a1fb710508e7b403e65126e6f",NULL,NULL,"1","facture/FA2410-0079","FA2410-0079.pdf","facture","81","","","",NULL,"1","generated",NULL,"2024-10-05 10:48:45","2024-12-03 17:46:25","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("188","bb532a6a2cd2343351b7144438ca3c37","4882a97ae2ce6eda5b06d8a0e9f8989d",NULL,NULL,"1","facture/FA2410-0080","FA2410-0080.pdf","facture","82","","","",NULL,"1","generated",NULL,"2024-10-06 19:41:13","2024-11-20 15:52:47","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("189","f7c36ab06ae76c918a4a7d415788d9a9","5859c8f54ad0e44ccad691ed63ad9df2","3AdzTvM88wGDTgbs62W8HF7a3z4r1TjV",NULL,"1","propale/PR2410-0022","PR2410-0022.pdf","propal","23","","","",NULL,"1","generated",NULL,"2024-10-11 18:33:17","2024-10-12 17:34:41","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("190","6aab6c6753b37a2d0a7f36043cf4c306","bff36cfd2f369081ee2852b4181313da",NULL,NULL,"1","facture/FA2410-0081","FA2410-0081.pdf","facture","83","","","",NULL,"1","generated",NULL,"2024-10-12 17:35:20","2024-10-12 17:35:20","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("191","62d6920a4d71bfd83cc7245a5a448c59","bb1153b9c065b0eca65455f4fc654ef2",NULL,NULL,"1","facture/FA2411-0082","FA2411-0082.pdf","facture","84","","","",NULL,"1","generated",NULL,"2024-11-15 11:19:04","2024-11-20 15:56:02","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("192","835d913283100c3dca0e3a918105511e","b0dd666f30b5de513297f89098d35adf","8gZQ6Ay287BfffFfh3v1YxPQsAF40G8o",NULL,"1","propale/(PROV24)","(PROV24).pdf","propal","24","","","",NULL,"1","generated",NULL,"2024-11-19 10:01:03","2024-11-19 15:48:59","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("193","4ef6ae8e1f6feddc011656e99f4e338e","53e0410cc29ca041d6686f441988f810","K6E1v2B02FUc9Wmqhc9kqoMLy94LKTc7",NULL,"1","propale/(PROV25)","(PROV25).pdf","propal","25","","","",NULL,"1","generated",NULL,"2024-11-19 10:09:41","2024-11-19 10:36:44","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("194","68605507881d68a83c1b662208095adb","ed00bdb5168c74695c5e7cf22056ec72","Nn7yM7rB9VDx1yi3qdJZiZ8I3sDm2P96",NULL,"1","propale/(PROV26)","(PROV26).pdf","propal","26","","","",NULL,"1","generated",NULL,"2024-11-19 10:38:27","2024-11-19 10:47:38","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("195","3cdc2cff62cd3052bb3903373d451811","f28cc0cf6f1cf5047cc237ad1a2b50fc",NULL,NULL,"1","facture/FA2412-0086","FA2412-0086.pdf","facture","85","","","",NULL,"1","generated",NULL,"2024-12-03 10:36:07","2025-06-16 11:32:44","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("196","ed93054314954f6c2e026341739586b2","123204cfa48ed7f660cd022c1060f96e","ryBQn25gCB6SlfAGd890W9eXVC38h3pw",NULL,"1","propale/PR2412-0023","PR2412-0023.pdf","propal","27","","","",NULL,"1","generated",NULL,"2024-12-09 18:51:51","2024-12-10 10:39:16","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("197","1d11ab1b72812d51697decc9578e2549","4179a1674114b3dcb89989f6e661089f",NULL,NULL,"1","facture/FA2412-0083","FA2412-0083.pdf","facture","86","","","",NULL,"1","generated",NULL,"2024-12-10 10:39:33","2024-12-10 10:39:33","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("198","e54327005b5e5925db8d3973dcfb5291","8280c2f46cb9158f7866013a869e01d1","60fdMQHzHETtE01uHv9rcU7dM713x8Qf",NULL,"1","propale/PR2412-0024","PR2412-0024.pdf","propal","28","","","",NULL,"1","generated",NULL,"2024-12-20 15:58:30","2024-12-20 15:58:52","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("199","9ed52dbcaff4487625bb2003ae219ed0","39b32e86373093b9a31ae1b90f7f7c00",NULL,NULL,"1","facture/FA2412-0084","FA2412-0084.pdf","facture","87","","","",NULL,"1","generated",NULL,"2024-12-20 15:59:23","2024-12-20 15:59:23","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("200","e947af56aa465661e2842db67d55553e","15a5c56b650b74b7276d0125cbb59321","3yx9yApKrA941W4kS6de69JjSQkQ2IdY",NULL,"1","propale/(PROV29)","(PROV29).pdf","propal","29","","","",NULL,"1","generated",NULL,"2025-02-03 19:54:31","2025-02-03 19:54:31","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("202","89cda708b6a0693a3cef5e7d0dad5fde","c090d43e2fdd17b30cdc9dc05e10b39b","twpfKs7hB3w0S1nT4Jf6V3Sz5SXRY90s",NULL,"1","propale/PR2503-0025","PR2503-0025.pdf","propal","31","","","",NULL,"1","generated",NULL,"2025-03-04 19:42:59","2025-03-04 20:05:51","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("203","b36251083e552a374e80a198246ac1db","2075ea34bafeacc7fca08fcf71a688bb","NqGr0gQe66210Gvg8PgUDiZ0NI34mljA",NULL,"1","propale/PR2503-0026","PR2503-0026.pdf","propal","32","","","",NULL,"1","generated",NULL,"2025-03-31 08:12:43","2025-04-10 19:48:12","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("204","113e404275eafbbc15e8c84989cdd7c7","40c42766a6bbc639d6c64621db030505",NULL,NULL,"1","facture/FA2504-0085","FA2504-0085.pdf","facture","88","","","",NULL,"1","generated",NULL,"2025-04-10 20:10:57","2025-06-13 10:22:10","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("205","04066fa21025c8c81e25cd12e53a2938","94c6d47dfa2e86037ebe3d806d98b45a","h4bmH0t29BsSQKmQa3C16JjI3uQ0fs3I",NULL,"1","propale/PR2506-0027","PR2506-0027.pdf","propal","33","","","",NULL,"1","generated",NULL,"2025-06-11 10:09:22","2025-06-13 10:04:06","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("207","9228fd0ec531c4f0cf7decfd5ac10b59","3e327d130589d7a2caf13da1a2a049ef","Kj5rdFH293A8K6wbi7F3BcIc6G3QihPh",NULL,"1","propale/PR2506-0028","PR2506-0028.pdf","propal","35","","","",NULL,"1","generated",NULL,"2025-06-24 19:33:57","2025-06-24 19:36:36","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("208","a667e8d65d2138158c0ede0dbb7fb9c8","f8854301ee0e716b908e996254d21378",NULL,NULL,"1","facture/FA2506-0087","FA2506-0087.pdf","facture","89","","","",NULL,"1","generated",NULL,"2025-06-24 19:38:10","2025-06-24 19:38:10","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("209","42bb2e1312121b004b0f478df110578d","e4df86e0add1a08016c4cbee008e32ee","8JTYop866hdH4Etj3HiDsm5Z2EGef5R6",NULL,"1","propale/(PROV36)","(PROV36).pdf","propal","36","","","",NULL,"1","generated",NULL,"2025-07-04 10:30:24","2025-07-04 10:30:24","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("210","825d61aebb9e88ccb5e34d22b3d044d7","acf24b00538dd3f21063ed54d03f5dc4","0Eccu14ve12rp4tLe71XGdsQ0Z0EJKGP",NULL,"1","propale/PR2507-0029","PR2507-0029.pdf","propal","37","","","",NULL,"1","generated",NULL,"2025-07-04 10:33:46","2025-09-02 16:31:29","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("211","576acc688290694d63fb72bc758e871d","718974de6cb44632e351fd2eda93a30e","EspHz4nWK2N0pibC736lJ1wuI86QnOP0",NULL,"1","propale/PR2508-0030","PR2508-0030.pdf","propal","38","","","",NULL,"1","generated",NULL,"2025-08-05 08:34:51","2025-08-07 23:20:10","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("212","dc9f4a6539c6e975988f6130fc4f1e30","60fa9049251c1bcb0f80d0b1f64add81","Gvd786LQsxZEf1GAdH65Pac6Tq48g6wI",NULL,"1","propale/PR2508-0030","PR2508-0030_signed-20250806083618.pdf","propal","38","","","",NULL,"2","generated",NULL,"2025-08-06 08:36:20","2025-08-06 08:36:20","0",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("213","a8b373ea1c182e744c93a5edfe766218","f661643f23fe67f111ca59a8e21a7480",NULL,NULL,"1","facture/FA2508-0088","FA2508-0088.pdf","facture","90","","","",NULL,"1","generated",NULL,"2025-08-07 23:17:44","2025-08-07 23:19:06","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("214","22c476b452865b11a39c6f98a963b125","03237c19159a8a9eff6dd7343ea29c8a",NULL,NULL,"1","facture/FA2508-0089","FA2508-0089.pdf","facture","91","","","",NULL,"1","generated",NULL,"2025-09-02 16:32:39","2025-09-27 14:31:58","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("215","b38b01a7e86c0b4cf09365f22bf3f129","3bba3050595c211cfde20ef381dcbbc9","0h9NesjZNt72ARrz4VHPcPoN2J302nr1",NULL,"1","propale/(PROV39)","(PROV39).pdf","propal","39","","","",NULL,"1","generated",NULL,"2025-10-19 20:16:30","2025-10-19 20:25:58","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("216","31135e9faeba1fed1d36c9731c394615","9f1c362c31ac3ec01a0f7b352bb51d03","tS5kljP6qPP6g7Dz6nXAgE45HpXYd484",NULL,"1","propale/PR2511-0031","PR2511-0031.pdf","propal","40","","","",NULL,"1","generated",NULL,"2025-11-27 10:58:20","2025-11-27 12:20:30","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("217","9a2f702e4fafb8a19f18242752bfe1ec","512d3d46586e33142e0364085da1b0c4",NULL,NULL,"1","facture/FA2512-0090","FA2512-0090.pdf","facture","92","","","",NULL,"1","generated",NULL,"2025-12-01 19:42:54","2025-12-01 19:44:23","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("218","3847f5333ad021f073238fbbd58cef2b","c3ad904c9236d673c7be2b37689584f7","lNyGixEigrhV3A2z039D909MAJVt8d6G",NULL,"1","propale/PR2512-0032","PR2512-0032.pdf","propal","41","","","",NULL,"1","generated",NULL,"2025-12-11 23:35:27","2025-12-15 19:55:29","1","1",NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("219","814f3c6a14d79deb37064c7e210c2b00","7a3a9d1580f52fae2c138316a5dbc93c",NULL,NULL,"1","commande/CO2512-0004","CO2512-0004.pdf","commande","5","","","",NULL,"1","generated",NULL,"2025-12-15 19:55:46","2025-12-15 19:55:46","1",NULL,NULL,NULL,NULL);
INSERT INTO `llx_ecm_files` VALUES("220","17e8d8b9e52bc2132823401a525a3561","fface8c3dfd8bdab58cf3fa11a3bbe9a",NULL,NULL,"1","facture/FA2512-0091","FA2512-0091.pdf","facture","93","","","",NULL,"1","generated",NULL,"2025-12-15 19:56:18","2025-12-15 19:57:17","1","1",NULL,NULL,NULL);



DROP TABLE IF EXISTS `llx_ecm_files_extrafields`;
CREATE TABLE `llx_ecm_files_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_ecm_files_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_element_categorie`;
CREATE TABLE `llx_element_categorie` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_categorie` int NOT NULL,
  `fk_element` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_element_categorie_idx` (`fk_element`,`fk_categorie`),
  KEY `fk_element_categorie_fk_categorie` (`fk_categorie`),
  CONSTRAINT `fk_element_categorie_fk_categorie` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_element_contact`;
CREATE TABLE `llx_element_contact` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `datecreate` datetime DEFAULT NULL,
  `statut` smallint DEFAULT '5',
  `element_id` int NOT NULL,
  `fk_c_type_contact` int NOT NULL,
  `fk_socpeople` int NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_element_contact_idx1` (`element_id`,`fk_c_type_contact`,`fk_socpeople`),
  KEY `idx_element_contact_fk_socpeople` (`fk_socpeople`),
  KEY `fk_element_contact_fk_c_type_contact` (`fk_c_type_contact`),
  CONSTRAINT `fk_element_contact_fk_c_type_contact` FOREIGN KEY (`fk_c_type_contact`) REFERENCES `llx_c_type_contact` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_element_element`;
CREATE TABLE `llx_element_element` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_source` int NOT NULL,
  `sourcetype` varchar(32) NOT NULL,
  `fk_target` int NOT NULL,
  `targettype` varchar(32) NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_element_element_idx1` (`fk_source`,`sourcetype`,`fk_target`,`targettype`),
  KEY `idx_element_element_fk_target` (`fk_target`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;

INSERT INTO `llx_element_element` VALUES("1","1","commande","2","facture");
INSERT INTO `llx_element_element` VALUES("2","3","commande","4","facture");
INSERT INTO `llx_element_element` VALUES("25","5","commande","93","facture");
INSERT INTO `llx_element_element` VALUES("3","5","propal","32","facture");
INSERT INTO `llx_element_element` VALUES("4","9","propal","51","facture");
INSERT INTO `llx_element_element` VALUES("5","11","propal","64","facture");
INSERT INTO `llx_element_element` VALUES("6","12","propal","66","facture");
INSERT INTO `llx_element_element` VALUES("7","14","propal","67","facture");
INSERT INTO `llx_element_element` VALUES("9","15","propal","71","facture");
INSERT INTO `llx_element_element` VALUES("8","16","propal","70","facture");
INSERT INTO `llx_element_element` VALUES("10","17","propal","4","commande");
INSERT INTO `llx_element_element` VALUES("11","17","propal","75","facture");
INSERT INTO `llx_element_element` VALUES("12","18","propal","77","facture");
INSERT INTO `llx_element_element` VALUES("13","19","propal","78","facture");
INSERT INTO `llx_element_element` VALUES("14","20","propal","79","facture");
INSERT INTO `llx_element_element` VALUES("15","21","propal","80","facture");
INSERT INTO `llx_element_element` VALUES("16","22","propal","81","facture");
INSERT INTO `llx_element_element` VALUES("17","23","propal","83","facture");
INSERT INTO `llx_element_element` VALUES("18","27","propal","86","facture");
INSERT INTO `llx_element_element` VALUES("19","28","propal","87","facture");
INSERT INTO `llx_element_element` VALUES("20","32","propal","88","facture");
INSERT INTO `llx_element_element` VALUES("21","35","propal","89","facture");
INSERT INTO `llx_element_element` VALUES("23","37","propal","91","facture");
INSERT INTO `llx_element_element` VALUES("22","38","propal","90","facture");
INSERT INTO `llx_element_element` VALUES("24","41","propal","5","commande");



DROP TABLE IF EXISTS `llx_element_resources`;
CREATE TABLE `llx_element_resources` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `element_id` int DEFAULT NULL,
  `element_type` varchar(64) DEFAULT NULL,
  `resource_id` int DEFAULT NULL,
  `resource_type` varchar(64) DEFAULT NULL,
  `busy` int DEFAULT NULL,
  `mandatory` int DEFAULT NULL,
  `duree` double DEFAULT NULL,
  `fk_user_create` int DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_element_resources_idx1` (`resource_id`,`resource_type`,`element_id`,`element_type`),
  KEY `idx_element_element_element_id` (`element_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_element_tag`;
CREATE TABLE `llx_element_tag` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_categorie` int NOT NULL,
  `fk_element` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_element_tag_uk` (`fk_categorie`,`fk_element`),
  CONSTRAINT `fk_element_tag_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_element_time`;
CREATE TABLE `llx_element_time` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_element` int NOT NULL,
  `elementtype` varchar(32) NOT NULL DEFAULT 'task',
  `element_date` date DEFAULT NULL,
  `element_datehour` datetime DEFAULT NULL,
  `element_date_withhour` int DEFAULT NULL,
  `element_duration` double DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `thm` double(24,8) DEFAULT NULL,
  `invoice_id` int DEFAULT NULL,
  `invoice_line_id` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `note` text,
  `intervention_id` int DEFAULT NULL,
  `intervention_line_id` int DEFAULT NULL,
  `fk_product` int DEFAULT NULL,
  `ref_ext` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_element_time_task` (`fk_element`),
  KEY `idx_element_time_date` (`element_date`),
  KEY `idx_element_time_datehour` (`element_datehour`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_emailcollector_emailcollector`;
CREATE TABLE `llx_emailcollector_emailcollector` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `ref` varchar(128) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `host` varchar(255) DEFAULT NULL,
  `login` varchar(128) DEFAULT NULL,
  `password` varchar(128) DEFAULT NULL,
  `source_directory` varchar(255) NOT NULL,
  `target_directory` varchar(255) DEFAULT NULL,
  `datelastresult` datetime DEFAULT NULL,
  `codelastresult` varchar(16) DEFAULT NULL,
  `lastresult` text,
  `note_public` text,
  `note_private` text,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `status` int NOT NULL,
  `datelastok` datetime DEFAULT NULL,
  `maxemailpercollect` int DEFAULT '100',
  `hostcharset` varchar(16) DEFAULT 'UTF-8',
  `imap_encryption` varchar(16) DEFAULT 'ssl',
  `norsh` int DEFAULT '0',
  `position` int NOT NULL DEFAULT '0',
  `port` varchar(10) DEFAULT '993',
  `acces_type` int DEFAULT '0',
  `oauth_service` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_emailcollector_emailcollector_ref` (`ref`,`entity`),
  KEY `idx_emailcollector_entity` (`entity`),
  KEY `idx_emailcollector_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_emailcollector_emailcollectoraction`;
CREATE TABLE `llx_emailcollector_emailcollectoraction` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_emailcollector` int NOT NULL,
  `type` varchar(128) NOT NULL,
  `actionparam` text,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `position` int DEFAULT '0',
  `import_key` varchar(14) DEFAULT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_emailcollector_emailcollectoraction` (`fk_emailcollector`,`type`),
  KEY `idx_emailcollector_fk_emailcollector` (`fk_emailcollector`),
  CONSTRAINT `fk_emailcollectoraction_fk_emailcollector` FOREIGN KEY (`fk_emailcollector`) REFERENCES `llx_emailcollector_emailcollector` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_emailcollector_emailcollectorfilter`;
CREATE TABLE `llx_emailcollector_emailcollectorfilter` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_emailcollector` int NOT NULL,
  `type` varchar(128) NOT NULL,
  `rulevalue` varchar(128) DEFAULT NULL,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_emailcollector_emailcollectorfilter` (`fk_emailcollector`,`type`,`rulevalue`),
  KEY `idx_emailcollector_fk_emailcollector` (`fk_emailcollector`),
  CONSTRAINT `fk_emailcollectorfilter_fk_emailcollector` FOREIGN KEY (`fk_emailcollector`) REFERENCES `llx_emailcollector_emailcollector` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_entrepot`;
CREATE TABLE `llx_entrepot` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(255) NOT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `fk_project` int DEFAULT NULL,
  `description` text,
  `lieu` varchar(64) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `zip` varchar(10) DEFAULT NULL,
  `town` varchar(50) DEFAULT NULL,
  `fk_departement` int DEFAULT NULL,
  `fk_pays` int DEFAULT '0',
  `statut` tinyint DEFAULT '1',
  `fk_user_author` int DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `fk_parent` int DEFAULT '0',
  `fax` varchar(20) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `warehouse_usage` int DEFAULT '1',
  `barcode` varchar(180) DEFAULT NULL,
  `fk_barcode_type` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_entrepot_label` (`ref`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_entrepot_extrafields`;
CREATE TABLE `llx_entrepot_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_entrepot_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_establishment`;
CREATE TABLE `llx_establishment` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `name` varchar(50) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `zip` varchar(25) DEFAULT NULL,
  `town` varchar(50) DEFAULT NULL,
  `fk_state` int DEFAULT '0',
  `fk_country` int DEFAULT '0',
  `profid1` varchar(20) DEFAULT NULL,
  `profid2` varchar(20) DEFAULT NULL,
  `profid3` varchar(20) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `fk_user_author` int NOT NULL,
  `fk_user_mod` int DEFAULT NULL,
  `datec` datetime NOT NULL,
  `tms` timestamp NOT NULL,
  `status` tinyint DEFAULT '1',
  `ref` varchar(30) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_event_element`;
CREATE TABLE `llx_event_element` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_source` int NOT NULL,
  `fk_target` int NOT NULL,
  `targettype` varchar(32) NOT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_eventorganization_conferenceorboothattendee`;
CREATE TABLE `llx_eventorganization_conferenceorboothattendee` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(128) NOT NULL,
  `fk_soc` int DEFAULT NULL,
  `fk_actioncomm` int DEFAULT NULL,
  `fk_project` int NOT NULL,
  `fk_invoice` int DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `email_company` varchar(128) DEFAULT NULL,
  `date_subscription` datetime DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `note_public` text,
  `note_private` text,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `status` smallint NOT NULL,
  `firstname` varchar(100) DEFAULT NULL,
  `lastname` varchar(100) DEFAULT NULL,
  `ip` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_eventorganization_conferenceorboothattendee` (`fk_project`,`email`,`fk_actioncomm`),
  KEY `idx_eventorganization_conferenceorboothattendee_rowid` (`rowid`),
  KEY `idx_eventorganization_conferenceorboothattendee_ref` (`ref`),
  KEY `idx_eventorganization_conferenceorboothattendee_fk_soc` (`fk_soc`),
  KEY `idx_eventorganization_conferenceorboothattendee_fk_actioncomm` (`fk_actioncomm`),
  KEY `idx_eventorganization_conferenceorboothattendee_email` (`email`),
  KEY `idx_eventorganization_conferenceorboothattendee_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_eventorganization_conferenceorboothattendee_extrafields`;
CREATE TABLE `llx_eventorganization_conferenceorboothattendee_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_conferenceorboothattendee_fk_object` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_events`;
CREATE TABLE `llx_events` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `type` varchar(32) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `dateevent` datetime DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `description` varchar(250) NOT NULL,
  `ip` varchar(250) NOT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `fk_object` int DEFAULT NULL,
  `prefix_session` varchar(255) DEFAULT NULL,
  `authentication_method` varchar(64) DEFAULT NULL,
  `fk_oauth_token` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_events_dateevent` (`dateevent`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_expedition`;
CREATE TABLE `llx_expedition` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `ref` varchar(30) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `fk_soc` int NOT NULL,
  `fk_projet` int DEFAULT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `ref_int` varchar(255) DEFAULT NULL,
  `ref_customer` varchar(255) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `date_delivery` datetime DEFAULT NULL,
  `date_expedition` datetime DEFAULT NULL,
  `fk_address` int DEFAULT NULL,
  `fk_shipping_method` int DEFAULT NULL,
  `tracking_number` varchar(50) DEFAULT NULL,
  `fk_statut` smallint DEFAULT '0',
  `billed` smallint DEFAULT '0',
  `height` float DEFAULT NULL,
  `width` float DEFAULT NULL,
  `size_units` int DEFAULT NULL,
  `size` float DEFAULT NULL,
  `weight_units` int DEFAULT NULL,
  `weight` float DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `fk_incoterms` int DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_expedition_uk_ref` (`ref`,`entity`),
  KEY `idx_expedition_fk_soc` (`fk_soc`),
  KEY `idx_expedition_fk_user_author` (`fk_user_author`),
  KEY `idx_expedition_fk_user_valid` (`fk_user_valid`),
  KEY `idx_expedition_fk_shipping_method` (`fk_shipping_method`),
  CONSTRAINT `fk_expedition_fk_shipping_method` FOREIGN KEY (`fk_shipping_method`) REFERENCES `llx_c_shipment_mode` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_expedition_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_expedition_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_expedition_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_expedition_extrafields`;
CREATE TABLE `llx_expedition_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_expedition_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_expedition_package`;
CREATE TABLE `llx_expedition_package` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_expedition` int NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `value` double(24,8) DEFAULT '0.00000000',
  `fk_parcel_type` int DEFAULT NULL,
  `height` float DEFAULT NULL,
  `width` float DEFAULT NULL,
  `size` float DEFAULT NULL,
  `size_units` int DEFAULT NULL,
  `weight` float DEFAULT NULL,
  `weight_units` int DEFAULT NULL,
  `dangerous_goods` smallint DEFAULT '0',
  `tail_lift` smallint DEFAULT '0',
  `rang` int DEFAULT '0',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_expeditiondet`;
CREATE TABLE `llx_expeditiondet` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_expedition` int NOT NULL,
  `fk_origin_line` int DEFAULT NULL,
  `fk_entrepot` int DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `rang` int DEFAULT '0',
  PRIMARY KEY (`rowid`),
  KEY `idx_expeditiondet_fk_expedition` (`fk_expedition`),
  KEY `idx_expeditiondet_fk_origin_line` (`fk_origin_line`),
  CONSTRAINT `fk_expeditiondet_fk_expedition` FOREIGN KEY (`fk_expedition`) REFERENCES `llx_expedition` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_expeditiondet_batch`;
CREATE TABLE `llx_expeditiondet_batch` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_expeditiondet` int NOT NULL,
  `eatby` date DEFAULT NULL,
  `sellby` date DEFAULT NULL,
  `batch` varchar(128) DEFAULT NULL,
  `qty` double NOT NULL DEFAULT '0',
  `fk_origin_stock` int NOT NULL,
  `fk_warehouse` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_fk_expeditiondet` (`fk_expeditiondet`),
  CONSTRAINT `fk_expeditiondet_batch_fk_expeditiondet` FOREIGN KEY (`fk_expeditiondet`) REFERENCES `llx_expeditiondet` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_expeditiondet_extrafields`;
CREATE TABLE `llx_expeditiondet_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_expeditiondet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_expensereport`;
CREATE TABLE `llx_expensereport` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(50) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `ref_number_int` int DEFAULT NULL,
  `ref_ext` int DEFAULT NULL,
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `date_debut` date NOT NULL,
  `date_fin` date NOT NULL,
  `date_create` datetime NOT NULL,
  `date_valid` datetime DEFAULT NULL,
  `date_approve` datetime DEFAULT NULL,
  `date_refuse` datetime DEFAULT NULL,
  `date_cancel` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_user_author` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `fk_user_validator` int DEFAULT NULL,
  `fk_user_approve` int DEFAULT NULL,
  `fk_user_refuse` int DEFAULT NULL,
  `fk_user_cancel` int DEFAULT NULL,
  `fk_statut` int NOT NULL,
  `fk_c_paiement` int DEFAULT NULL,
  `paid` smallint NOT NULL DEFAULT '0',
  `note_public` text,
  `note_private` text,
  `detail_refuse` varchar(255) DEFAULT NULL,
  `detail_cancel` varchar(255) DEFAULT NULL,
  `integration_compta` int DEFAULT NULL,
  `fk_bank_account` int DEFAULT NULL,
  `model_pdf` varchar(50) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `fk_user_creat` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_expensereport_uk_ref` (`ref`,`entity`),
  KEY `idx_expensereport_date_debut` (`date_debut`),
  KEY `idx_expensereport_date_fin` (`date_fin`),
  KEY `idx_expensereport_fk_statut` (`fk_statut`),
  KEY `idx_expensereport_fk_user_author` (`fk_user_author`),
  KEY `idx_expensereport_fk_user_valid` (`fk_user_valid`),
  KEY `idx_expensereport_fk_user_approve` (`fk_user_approve`),
  KEY `idx_expensereport_fk_user_refuse` (`fk_user_refuse`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_expensereport_det`;
CREATE TABLE `llx_expensereport_det` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_expensereport` int NOT NULL,
  `docnumber` varchar(128) DEFAULT NULL,
  `fk_c_type_fees` int NOT NULL,
  `fk_c_exp_tax_cat` int DEFAULT NULL,
  `fk_projet` int DEFAULT NULL,
  `comments` text NOT NULL,
  `product_type` int DEFAULT '-1',
  `qty` double NOT NULL,
  `subprice` double(24,8) NOT NULL DEFAULT '0.00000000',
  `value_unit` double(24,8) NOT NULL,
  `remise_percent` double DEFAULT NULL,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT NULL,
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `total_ht` double(24,8) NOT NULL DEFAULT '0.00000000',
  `total_tva` double(24,8) NOT NULL DEFAULT '0.00000000',
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) NOT NULL DEFAULT '0.00000000',
  `date` date NOT NULL,
  `info_bits` int DEFAULT '0',
  `special_code` int DEFAULT '0',
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `fk_facture` int DEFAULT '0',
  `fk_code_ventilation` int DEFAULT '0',
  `rang` int DEFAULT '0',
  `import_key` varchar(14) DEFAULT NULL,
  `rule_warning_message` text,
  `fk_ecm_files` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_expensereport_extrafields`;
CREATE TABLE `llx_expensereport_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_expensereport_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_expensereport_ik`;
CREATE TABLE `llx_expensereport_ik` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_c_exp_tax_cat` int NOT NULL DEFAULT '0',
  `fk_range` int NOT NULL DEFAULT '0',
  `coef` double NOT NULL DEFAULT '0',
  `ikoffset` double NOT NULL DEFAULT '0',
  `active` int DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

INSERT INTO `llx_expensereport_ik` VALUES("1",NULL,NULL,"4","1","0.41","0","1");
INSERT INTO `llx_expensereport_ik` VALUES("2",NULL,NULL,"4","2","0.244","824","1");
INSERT INTO `llx_expensereport_ik` VALUES("3",NULL,NULL,"4","3","0.286","0","1");
INSERT INTO `llx_expensereport_ik` VALUES("4",NULL,NULL,"5","4","0.493","0","1");
INSERT INTO `llx_expensereport_ik` VALUES("5",NULL,NULL,"5","5","0.277","1082","1");
INSERT INTO `llx_expensereport_ik` VALUES("6",NULL,NULL,"5","6","0.332","0","1");
INSERT INTO `llx_expensereport_ik` VALUES("7",NULL,NULL,"6","7","0.543","0","1");
INSERT INTO `llx_expensereport_ik` VALUES("8",NULL,NULL,"6","8","0.305","1180","1");
INSERT INTO `llx_expensereport_ik` VALUES("9",NULL,NULL,"6","9","0.364","0","1");
INSERT INTO `llx_expensereport_ik` VALUES("10",NULL,NULL,"7","10","0.568","0","1");
INSERT INTO `llx_expensereport_ik` VALUES("11",NULL,NULL,"7","11","0.32","1244","1");
INSERT INTO `llx_expensereport_ik` VALUES("12",NULL,NULL,"7","12","0.382","0","1");
INSERT INTO `llx_expensereport_ik` VALUES("13",NULL,NULL,"8","13","0.595","0","1");
INSERT INTO `llx_expensereport_ik` VALUES("14",NULL,NULL,"8","14","0.337","1288","1");
INSERT INTO `llx_expensereport_ik` VALUES("15",NULL,NULL,"8","15","0.401","0","1");



DROP TABLE IF EXISTS `llx_expensereport_rules`;
CREATE TABLE `llx_expensereport_rules` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `dates` datetime NOT NULL,
  `datee` datetime NOT NULL,
  `amount` double(24,8) NOT NULL,
  `restrictive` tinyint NOT NULL,
  `fk_user` int DEFAULT NULL,
  `fk_usergroup` int DEFAULT NULL,
  `fk_c_type_fees` int NOT NULL,
  `code_expense_rules_type` varchar(50) NOT NULL,
  `is_for_all` tinyint DEFAULT '0',
  `entity` int DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_export_compta`;
CREATE TABLE `llx_export_compta` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(12) NOT NULL,
  `date_export` datetime NOT NULL,
  `fk_user` int NOT NULL,
  `note` text,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_export_model`;
CREATE TABLE `llx_export_model` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_user` int NOT NULL DEFAULT '0',
  `label` varchar(50) NOT NULL,
  `type` varchar(64) DEFAULT NULL,
  `field` text NOT NULL,
  `filter` text,
  `entity` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_export_model` (`label`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_extrafields`;
CREATE TABLE `llx_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `elementtype` varchar(64) NOT NULL DEFAULT 'member',
  `label` varchar(255) NOT NULL,
  `type` varchar(8) DEFAULT NULL,
  `size` varchar(8) DEFAULT NULL,
  `fieldcomputed` text,
  `fielddefault` text,
  `fieldunique` int DEFAULT '0',
  `fieldrequired` int DEFAULT '0',
  `perms` varchar(255) DEFAULT NULL,
  `enabled` varchar(255) DEFAULT NULL,
  `pos` int DEFAULT '0',
  `alwayseditable` int DEFAULT '0',
  `param` text,
  `list` varchar(255) DEFAULT '1',
  `totalizable` tinyint(1) DEFAULT '0',
  `langs` varchar(64) DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `help` text,
  `printable` int DEFAULT '0',
  `css` varchar(128) DEFAULT NULL,
  `cssview` varchar(128) DEFAULT NULL,
  `csslist` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_extrafields_name` (`name`,`entity`,`elementtype`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_facture`;
CREATE TABLE `llx_facture` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `ref_ext` varchar(255) DEFAULT NULL,
  `ref_int` varchar(255) DEFAULT NULL,
  `ref_client` varchar(255) DEFAULT NULL,
  `type` smallint NOT NULL DEFAULT '0',
  `increment` varchar(10) DEFAULT NULL,
  `fk_soc` int NOT NULL,
  `datec` datetime DEFAULT NULL,
  `datef` date DEFAULT NULL,
  `date_pointoftax` date DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `date_closing` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `paye` smallint NOT NULL DEFAULT '0',
  `remise_percent` double DEFAULT '0',
  `remise_absolue` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `close_code` varchar(16) DEFAULT NULL,
  `close_missing_amount` double(24,8) DEFAULT NULL,
  `close_note` varchar(128) DEFAULT NULL,
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `revenuestamp` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `fk_statut` smallint NOT NULL DEFAULT '0',
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `fk_user_closing` int DEFAULT NULL,
  `fk_fac_rec_source` int DEFAULT NULL,
  `fk_facture_source` int DEFAULT NULL,
  `fk_projet` int DEFAULT NULL,
  `fk_account` int DEFAULT NULL,
  `fk_currency` varchar(3) DEFAULT NULL,
  `fk_cond_reglement` int NOT NULL DEFAULT '1',
  `fk_mode_reglement` int DEFAULT NULL,
  `date_lim_reglement` date DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `fk_incoterms` int DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `fk_transport_mode` int DEFAULT NULL,
  `situation_cycle_ref` int DEFAULT NULL,
  `situation_counter` smallint DEFAULT NULL,
  `situation_final` smallint DEFAULT NULL,
  `retained_warranty` double DEFAULT NULL,
  `retained_warranty_date_limit` date DEFAULT NULL,
  `retained_warranty_fk_cond_reglement` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `module_source` varchar(32) DEFAULT NULL,
  `pos_source` varchar(32) DEFAULT NULL,
  `prorata_discount` double DEFAULT NULL,
  `subtype` smallint DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_facture_ref` (`ref`,`entity`),
  KEY `idx_facture_fk_soc` (`fk_soc`),
  KEY `idx_facture_fk_user_author` (`fk_user_author`),
  KEY `idx_facture_fk_user_valid` (`fk_user_valid`),
  KEY `idx_facture_fk_facture_source` (`fk_facture_source`),
  KEY `idx_facture_fk_projet` (`fk_projet`),
  KEY `idx_facture_fk_account` (`fk_account`),
  KEY `idx_facture_fk_currency` (`fk_currency`),
  KEY `idx_facture_fk_statut` (`fk_statut`),
  KEY `idx_facture_datef` (`datef`),
  CONSTRAINT `fk_facture_fk_facture_source` FOREIGN KEY (`fk_facture_source`) REFERENCES `llx_facture` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_facture_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_facture_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_facture_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_facture_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=latin1;

INSERT INTO `llx_facture` VALUES("1","FA1810-0001","1",NULL,NULL,NULL,"0",NULL,"2","2018-11-03 12:14:24","2018-10-01",NULL,"2018-11-03 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2018-11-07",NULL,NULL,"crabe","facture/FA1810-0001/FA1810-0001.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("2","FA1810-0002","1",NULL,NULL,NULL,"0",NULL,"1","2018-11-26 14:16:18","2018-10-31",NULL,"2018-11-26 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","527.99000000","527.99000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2018-11-01",NULL,"Règlement en deux fois","crabe","facture/FA1810-0002/FA1810-0002.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","527.99000000","0.00000000","527.99000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("3","FA1812-0003","1",NULL,NULL,NULL,"0",NULL,"2","2018-12-09 15:58:06","2018-12-09",NULL,"2018-12-09 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2018-12-10",NULL,NULL,"crabe","facture/FA1812-0003/FA1812-0003.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("4","FA1806-0004","1",NULL,NULL,NULL,"0",NULL,"3","2018-12-20 11:56:59","2018-06-01",NULL,"2018-12-20 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","750.00000000","750.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"7","54","2018-06-02",NULL,NULL,"crabe","facture/FA1806-0004/FA1806-0004.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","750.00000000","0.00000000","750.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("5","FA1901-0005","1",NULL,NULL,NULL,"0",NULL,"2","2019-04-12 14:37:31","2019-01-01",NULL,"2019-04-12 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2019-04-13",NULL,NULL,"crabe","facture/FA1901-0005/FA1901-0005.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("6","FA1902-0006","1",NULL,NULL,NULL,"0",NULL,"2","2019-04-12 14:38:30","2019-02-01",NULL,"2019-04-12 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2019-04-13",NULL,NULL,"crabe","facture/FA1902-0006/FA1902-0006.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("7","FA1903-0007","1",NULL,NULL,NULL,"0",NULL,"2","2019-04-12 14:39:05","2019-03-01",NULL,"2019-04-12 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2019-04-13",NULL,NULL,"crabe","facture/FA1903-0007/FA1903-0007.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("8","FA1904-0008","1",NULL,NULL,NULL,"0",NULL,"2","2019-04-12 14:39:30","2019-04-01",NULL,"2019-04-12 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2019-04-13",NULL,NULL,"crabe","facture/FA1904-0008/FA1904-0008.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("9","FA1904-0009","1",NULL,NULL,NULL,"0",NULL,"4","2019-04-12 22:17:03","2019-04-12",NULL,"2019-04-12 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","770.00000000","770.00000000","1","1","1","1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2019-04-13",NULL,"Règlements en 2 fois","crabe","facture/FA1904-0009/FA1904-0009.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","770.00000000","0.00000000","770.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("10","FA1905-0010","1",NULL,NULL,NULL,"0",NULL,"2","2019-05-15 08:45:56","2019-05-15",NULL,"2019-05-15 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2019-05-16",NULL,NULL,"crabe","facture/FA1905-0010/FA1905-0010.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("11","FA1906-0011","1",NULL,NULL,NULL,"0",NULL,"2","2019-06-21 16:11:03","2019-06-21",NULL,"2019-06-21 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2019-06-22",NULL,NULL,"crabe","facture/FA1906-0011/FA1906-0011.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("12","FA1908-0012","1",NULL,NULL,NULL,"0",NULL,"2","2019-08-08 16:39:42","2019-08-08",NULL,"2019-08-08 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2019-08-09",NULL,NULL,"crabe","facture/FA1908-0012/FA1908-0012.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("13","FA1908-0013","1",NULL,NULL,NULL,"0",NULL,"2","2019-08-08 16:40:44","2019-08-08",NULL,"2019-08-08 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2019-08-09",NULL,NULL,"crabe","facture/FA1908-0013/FA1908-0013.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("14","FA1909-0014","1",NULL,NULL,NULL,"0",NULL,"2","2019-09-03 11:30:01","2019-09-03",NULL,"2019-09-03 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2019-09-04",NULL,NULL,"crabe","facture/FA1909-0014/FA1909-0014.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("15","FA1910-0015","1",NULL,NULL,NULL,"0",NULL,"2","2019-10-07 20:11:59","2019-10-07",NULL,"2019-10-07 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2019-10-08",NULL,NULL,"crabe","facture/FA1910-0015/FA1910-0015.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("16","FA1910-0016","1",NULL,NULL,NULL,"0",NULL,"2","2019-10-31 17:14:38","2019-10-31",NULL,"2019-11-05 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2019-11-01",NULL,NULL,"crabe","facture/FA1910-0016/FA1910-0016.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("17","FA1912-0017","1",NULL,NULL,NULL,"0",NULL,"2","2019-12-05 19:56:26","2019-12-05",NULL,"2019-12-05 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2019-12-06",NULL,NULL,"crabe","facture/FA1912-0017/FA1912-0017.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("18","FA1912-0018","1",NULL,NULL,NULL,"0",NULL,"6","2019-12-17 08:54:47","2019-12-17",NULL,"2019-12-17 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","7","2019-12-18",NULL,NULL,"crabe","facture/FA1912-0018/FA1912-0018.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("19","FA1912-0019","1",NULL,NULL,NULL,"0",NULL,"6","2019-12-17 08:56:16","2019-12-17",NULL,"2019-12-17 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","7","2019-12-18",NULL,NULL,"crabe","facture/FA1912-0019/FA1912-0019.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("20","FA2001-0020","1",NULL,NULL,NULL,"0",NULL,"2","2020-01-10 11:23:29","2020-01-10",NULL,"2020-01-10 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-01-11",NULL,NULL,"crabe","facture/FA2001-0020/FA2001-0020.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("21","FA2001-0021","1",NULL,NULL,NULL,"0",NULL,"7","2020-01-24 16:08:00","2020-01-24",NULL,"2020-01-24 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","35.00000000","35.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","7","2020-01-25",NULL,NULL,"crabe","facture/FA2001-0021/FA2001-0021.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","35.00000000","0.00000000","35.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("22","FA2002-0022","1",NULL,NULL,NULL,"0",NULL,"2","2020-02-10 10:46:31","2020-02-01",NULL,"2020-03-06 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-02-11",NULL,NULL,"crabe","facture/FA2002-0022/FA2002-0022.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("23","FA2002-0023","1",NULL,NULL,NULL,"0",NULL,"8","2020-02-10 10:51:40","2020-02-10",NULL,"2020-02-10 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","1250.00000000","1250.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2020-02-11",NULL,NULL,"crabe","facture/FA2002-0023/FA2002-0023.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","1250.00000000","0.00000000","1250.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("24","(PROV24)","1",NULL,NULL,NULL,"0",NULL,"2","2020-03-06 14:01:21","2020-03-06",NULL,NULL,NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","0","1",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-03-07",NULL,NULL,"crabe","facture/(PROV24)/(PROV24).pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("25","FA2006-0024","1",NULL,NULL,NULL,"0",NULL,"1","2020-06-07 10:46:49","2020-06-07",NULL,"2020-06-10 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","127.99000000","127.99000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-06-08",NULL,"Règlement en deux fois","crabe","facture/FA2006-0024/FA2006-0024.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","127.99000000","0.00000000","127.99000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("26","FA2003-0025","1",NULL,NULL,NULL,"0",NULL,"2","2020-06-10 12:17:53","2020-03-31",NULL,"2020-06-10 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-06-11",NULL,NULL,"crabe","facture/FA2003-0025/FA2003-0025.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("27","FA2004-0026","1",NULL,NULL,NULL,"0",NULL,"2","2020-06-10 12:19:44","2020-04-30",NULL,"2020-06-10 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-06-11",NULL,NULL,"crabe","facture/FA2004-0026/FA2004-0026.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("28","FA2005-0027","1",NULL,NULL,NULL,"0",NULL,"2","2020-06-10 12:20:34","2020-05-31",NULL,"2020-06-10 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-06-11",NULL,NULL,"crabe","facture/FA2005-0027/FA2005-0027.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("29","FA2007-0028","1",NULL,NULL,NULL,"0",NULL,"2","2020-07-09 12:00:29","2020-07-09",NULL,"2020-07-09 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-07-10",NULL,NULL,"crabe","facture/FA2007-0028/FA2007-0028.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("30","FA2007-0029","1",NULL,NULL,NULL,"0",NULL,"10","2020-07-29 11:29:05","2020-07-29",NULL,"2020-07-29 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","500.00000000","500.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2020-07-30",NULL,NULL,"crabe","facture/FA2007-0029/FA2007-0029.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","500.00000000","0.00000000","500.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("31","FA2008-0030","1",NULL,NULL,NULL,"0",NULL,"2","2020-08-05 11:26:34","2020-08-05",NULL,"2020-08-05 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-08-06",NULL,NULL,"crabe","facture/FA2008-0030/FA2008-0030.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("32","FA2008-0031","1",NULL,NULL,NULL,"0",NULL,"11","2020-08-21 16:58:51","2020-08-21",NULL,"2020-08-21 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","1700.00000000","1700.00000000","2","1","1","1",NULL,NULL,NULL,NULL,NULL,NULL,"2","2","2020-09-20",NULL,"Règlement de 850€ à la signature et 850€ à la mise en ligne du site.","crabe","facture/FA2008-0031/FA2008-0031.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","1700.00000000","0.00000000","1700.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("33","FA2009-0032","1",NULL,NULL,NULL,"0",NULL,"10","2020-09-21 18:39:04","2020-09-21",NULL,"2020-09-21 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","300.00000000","300.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2020-09-22",NULL,NULL,"crabe","facture/FA2009-0032/FA2009-0032.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","300.00000000","0.00000000","300.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("34","FA2009-0033","1",NULL,NULL,NULL,"0",NULL,"13","2020-09-30 10:25:55","2020-09-28",NULL,"2020-09-30 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","30.00000000","30.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-09-29",NULL,NULL,"crabe","facture/FA2009-0033/FA2009-0033.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("35","FA2009-0034","1",NULL,NULL,NULL,"0",NULL,"2","2020-09-30 10:30:51","2020-09-01",NULL,"2020-09-30 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-10-01",NULL,NULL,"crabe","facture/FA2009-0034/FA2009-0034.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("36","FA2009-0035","1",NULL,NULL,NULL,"0",NULL,"2","2020-09-30 10:32:05","2020-09-30",NULL,"2020-09-30 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-10-01",NULL,NULL,"crabe","facture/FA2009-0035/FA2009-0035.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("37","FA2012-0036","1",NULL,NULL,NULL,"0",NULL,"2","2020-12-26 19:12:11","2020-10-31",NULL,"2020-12-26 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-12-27",NULL,NULL,"crabe","facture/FA2012-0036/FA2012-0036.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("38","FA2011-0037","1",NULL,NULL,NULL,"0",NULL,"2","2020-12-26 19:14:34","2020-11-30",NULL,"2020-12-26 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-12-27",NULL,NULL,"crabe","facture/FA2011-0037/FA2011-0037.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("39","FA2012-0038","1",NULL,NULL,NULL,"0",NULL,"2","2020-12-26 19:15:21","2020-12-31",NULL,"2020-12-26 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2021-01-15",NULL,NULL,"crabe","facture/FA2012-0038/FA2012-0038.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("40","FA2010-0039","1",NULL,NULL,NULL,"0",NULL,"2","2020-12-26 19:21:22","2020-10-10",NULL,"2020-12-26 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","170.00000000","170.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2020-10-31",NULL,NULL,"crabe","facture/FA2010-0039/FA2010-0039.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","170.00000000","0.00000000","170.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("41","FA2012-0040","1",NULL,NULL,NULL,"0",NULL,"10","2021-01-15 18:54:47","2020-12-30",NULL,"2021-01-15 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","1000.00000000","1000.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","7","2021-01-16",NULL,NULL,"crabe","facture/FA2012-0040/FA2012-0040.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","1000.00000000","0.00000000","1000.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("42","FA2103-0041","1",NULL,NULL,NULL,"0",NULL,"2","2021-03-21 20:09:13","2021-01-31",NULL,"2021-03-21 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2021-03-22",NULL,NULL,"crabe","facture/FA2103-0041/FA2103-0041.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("43","FA2103-0042","1",NULL,NULL,NULL,"0",NULL,"2","2021-03-21 20:11:14","2021-03-21",NULL,"2021-03-21 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2021-03-22",NULL,NULL,"crabe","facture/FA2103-0042/FA2103-0042.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("44","FA2103-0043","1",NULL,NULL,NULL,"0",NULL,"8","2021-03-21 20:55:31","2021-03-21",NULL,"2021-03-21 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","1275.00000000","1275.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2021-03-22",NULL,NULL,"crabe","facture/FA2103-0043/FA2103-0043.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","1275.00000000","0.00000000","1275.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("45","FA2104-0044","1",NULL,NULL,NULL,"0",NULL,"2","2021-04-20 13:14:48","2021-04-20",NULL,"2021-04-20 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2021-04-21",NULL,NULL,"crabe","facture/FA2104-0044/FA2104-0044.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("46","FA2105-0045","1",NULL,NULL,NULL,"0",NULL,"16","2021-05-04 13:33:37","2021-05-04",NULL,"2021-05-04 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","2","1","1","1",NULL,NULL,NULL,NULL,NULL,NULL,"1","7","2021-05-05",NULL,"Cette somme de 200€ sera déduite dans la facture pour effectuer la migration.","crabe","facture/FA2105-0045/FA2105-0045.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("47","FA2104-0046","1",NULL,NULL,NULL,"0",NULL,"2","2021-08-08 08:35:50","2021-04-30",NULL,"2021-08-08 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2021-08-31",NULL,NULL,"crabe","facture/FA2104-0046/FA2104-0046.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("48","FA2105-0047","1",NULL,NULL,NULL,"0",NULL,"2","2021-08-08 08:37:38","2021-05-31",NULL,"2021-08-08 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2021-08-31",NULL,NULL,"crabe","facture/FA2105-0047/FA2105-0047.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("49","FA2106-0048","1",NULL,NULL,NULL,"0",NULL,"2","2021-08-08 08:40:56","2021-06-30",NULL,"2021-08-08 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2021-08-31",NULL,NULL,"crabe","facture/FA2106-0048/FA2106-0048.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("50","FA2107-0049","1",NULL,NULL,NULL,"0",NULL,"2","2021-08-08 08:41:39","2021-07-31",NULL,"2021-08-08 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2021-08-31",NULL,NULL,"crabe","facture/FA2107-0049/FA2107-0049.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("51","FA2109-0050","1",NULL,NULL,NULL,"0",NULL,"16","2021-09-20 18:28:13","2021-09-20",NULL,"2021-09-20 00:00:00","2024-03-23 21:26:17",NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","2980.00000000","2980.00000000","2","1",NULL,"1","1",NULL,NULL,NULL,NULL,NULL,"1","7","2021-09-21",NULL,"La somme de 200 € sera déduite sur la facture après acceptation.","crabe","facture/FA2109-0050/FA2109-0050.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","2980.00000000","0.00000000","2980.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("52","FA2109-0051","1",NULL,NULL,NULL,"0",NULL,"19","2021-09-25 15:52:59","2021-09-25",NULL,"2021-09-25 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","95.00000000","95.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2021-09-26",NULL,NULL,"crabe","facture/FA2109-0051/FA2109-0051.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","95.00000000","0.00000000","95.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("53","FA2105-0052","1",NULL,NULL,NULL,"0",NULL,"14","2021-11-22 18:50:34","2021-05-07",NULL,"2021-11-22 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","500.00000000","500.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2021-05-08",NULL,NULL,"crabe","facture/FA2105-0052/FA2105-0052.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","500.00000000","0.00000000","500.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("54","FA2012-0053","1",NULL,NULL,NULL,"0",NULL,"4","2021-11-22 19:07:21","2020-12-02",NULL,"2021-11-22 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","250.00000000","250.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2021-11-23",NULL,NULL,"crabe","facture/FA2012-0053/FA2012-0053.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","250.00000000","0.00000000","250.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("55","FA2111-0054","1",NULL,NULL,NULL,"0",NULL,"4","2021-11-22 19:13:36","2021-11-22",NULL,"2021-11-22 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","400.00000000","400.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2021-11-23",NULL,NULL,"crabe","facture/FA2111-0054/FA2111-0054.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","400.00000000","0.00000000","400.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("56","FA2201-0055","1",NULL,NULL,NULL,"0",NULL,"2","2022-03-03 20:39:34","2022-01-31",NULL,"2022-03-03 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2022-03-04",NULL,NULL,"crabe","facture/FA2201-0055/FA2201-0055.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("57","FA2203-0056","1",NULL,NULL,NULL,"0",NULL,"2","2022-03-03 20:40:53","2022-03-03",NULL,"2022-03-03 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","200.00000000","200.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2022-03-04",NULL,NULL,"crabe","facture/FA2203-0056/FA2203-0056.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("58","FA2203-0057","1",NULL,NULL,NULL,"0",NULL,"20","2022-03-03 20:56:12","2022-03-03",NULL,"2022-03-03 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","75.00000000","75.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2022-03-04",NULL,NULL,"crabe","facture/FA2203-0057/FA2203-0057.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","75.00000000","0.00000000","75.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("59","FA2203-0058","1",NULL,NULL,NULL,"0",NULL,"16","2022-03-03 21:05:14","2022-03-03",NULL,"2022-03-03 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","85.00000000","85.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2022-03-04",NULL,NULL,"crabe","facture/FA2203-0058/FA2203-0058.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","85.00000000","0.00000000","85.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("60","FA2101-0059","1",NULL,NULL,NULL,"0",NULL,"10","2022-04-11 14:06:22","2021-01-10",NULL,"2022-04-11 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","1050.00000000","1050.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","7","2021-03-10",NULL,NULL,"crabe","facture/FA2101-0059/FA2101-0059.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","1050.00000000","0.00000000","1050.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("61","FA2206-0060","1",NULL,NULL,NULL,"0",NULL,"1","2022-06-07 19:08:08","2022-06-07",NULL,"2022-06-07 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","130.00000000","130.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2022-06-08",NULL,"Règlement en deux fois","crabe","facture/FA2206-0060/FA2206-0060.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","130.00000000","0.00000000","130.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("62","FA2206-0061","1",NULL,NULL,NULL,"0",NULL,"11","2022-06-13 10:31:55","2022-06-13",NULL,"2022-11-15 00:00:00","2024-11-20 15:57:41",NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","60.00000000","60.00000000","2","1",NULL,"1","1",NULL,NULL,NULL,"2",NULL,"1","7","2022-06-14",NULL,NULL,"crabe","facture/FA2206-0061/FA2206-0061.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","60.00000000","0.00000000","60.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("63","FA2206-0062","1",NULL,NULL,NULL,"0",NULL,"16","2022-06-13 10:36:20","2022-06-13",NULL,"2022-06-13 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","30.00000000","30.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","7","2022-06-14",NULL,NULL,"crabe","facture/FA2206-0062/FA2206-0062.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("64","FA2206-0063","1",NULL,NULL,NULL,"0",NULL,"18","2022-06-13 11:26:33","2022-06-13",NULL,"2022-06-13 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","78.00000000","78.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","7","2022-06-14",NULL,NULL,"crabe","facture/FA2206-0063/FA2206-0063.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","78.00000000","0.00000000","78.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("65","FA2209-0064","1",NULL,NULL,NULL,"0",NULL,"4","2022-09-08 09:15:39","2022-09-08",NULL,"2022-10-14 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","800.00000000","800.00000000","2","1","1","1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2022-09-09",NULL,"Premier réglement de 400€ puis tout les mois","crabe","facture/FA2209-0064/FA2209-0064.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","800.00000000","0.00000000","800.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("66","FA2204-0065","1",NULL,NULL,NULL,"0",NULL,"21","2022-10-27 17:12:01","2022-04-02",NULL,"2022-10-27 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","1100.00000000","1100.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2022-04-03","R&egrave;glements : 600 &euro; &agrave; la signature de devis puis 500 &euro; a la mise en ligne","R&egrave;glements : 600 &euro; &agrave; la signature de devis puis 500 &euro; a la mise en ligne.","crabe","facture/FA2204-0065/FA2204-0065.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","1100.00000000","0.00000000","1100.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("67","FA2211-0066","1",NULL,NULL,NULL,"0",NULL,"22","2022-11-25 18:32:33","2022-11-25",NULL,"2022-11-25 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","716.99000000","716.99000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2022-11-26",NULL,NULL,"crabe","facture/FA2211-0066/FA2211-0066.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","716.99000000","0.00000000","716.99000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("68","FA2305-0067","1",NULL,NULL,NULL,"0",NULL,"1","2023-05-15 19:51:36","2023-05-15",NULL,"2023-05-15 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","130.00000000","130.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2023-05-16",NULL,"Règlement en deux fois","crabe","facture/FA2305-0067/FA2305-0067.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","130.00000000","0.00000000","130.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("70","FA2306-0068","1",NULL,NULL,NULL,"0",NULL,"4","2023-06-02 17:30:42","2023-06-02",NULL,"2023-06-02 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","800.00000000","800.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","54","2023-06-03",NULL,NULL,"crabe","facture/FA2306-0068/FA2306-0068.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","800.00000000","0.00000000","800.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("71","FA2306-0069","1",NULL,NULL,NULL,"0",NULL,"16","2023-06-05 20:01:34","2023-06-05",NULL,"2023-06-05 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","30.00000000","30.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","7","2023-06-06",NULL,NULL,"crabe","facture/FA2306-0069/FA2306-0069.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("72","FA2308-0070","1",NULL,NULL,NULL,"0",NULL,"16","2023-08-10 18:32:03","2023-08-10",NULL,"2023-08-10 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","30.00000000","30.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","7","2023-08-11",NULL,NULL,"crabe","facture/FA2308-0070/FA2308-0070.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("73","FA2309-0071","1",NULL,NULL,NULL,"0",NULL,"11","2023-09-05 18:13:14","2023-09-05",NULL,"2023-09-05 00:00:00","2024-11-20 15:52:44",NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","32.00000000","32.00000000","2","1",NULL,"1","1",NULL,NULL,NULL,"2",NULL,"1","2","2023-09-06",NULL,NULL,"crabe","facture/FA2309-0071/FA2309-0071.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","32.00000000","0.00000000","32.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("74","FA2309-0072","1",NULL,NULL,NULL,"0",NULL,"4","2023-09-11 11:04:39","2023-09-11",NULL,"2023-09-11 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","800.00000000","800.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","2","2023-09-12",NULL,"Premier réglement de 400€ puis tout les mois","crabe","facture/FA2309-0072/FA2309-0072.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","800.00000000","0.00000000","800.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("75","FA2311-0073","1",NULL,NULL,NULL,"0",NULL,"23","2023-11-13 18:57:56","2023-11-13",NULL,"2023-11-13 00:00:00",NULL,NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","800.00000000","800.00000000","2","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2023-11-14",NULL,NULL,"crabe","facture/FA2311-0073/FA2311-0073.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","800.00000000","0.00000000","800.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("76","FA2312-0074","1",NULL,NULL,NULL,"0",NULL,"16","2023-12-13 19:49:12","2023-12-13",NULL,"2023-12-13 00:00:00",NULL,NULL,"0",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","32.00000000","32.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2023-12-14",NULL,NULL,"crabe","facture/FA2312-0074/FA2312-0074.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","32.00000000","0.00000000","32.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("77","FA2401-0075","1",NULL,NULL,NULL,"0",NULL,"24","2024-02-02 09:28:40","2024-01-01",NULL,"2024-02-02 00:00:00","2024-03-23 21:20:56",NULL,"1",NULL,NULL,"0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","300.00000000","300.00000000","2","1",NULL,"1","1",NULL,NULL,NULL,NULL,NULL,"1","0","2024-01-02",NULL,NULL,"crabe","facture/FA2401-0075/FA2401-0075.pdf","0","",NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","EUR","1.00000000","300.00000000","0.00000000","300.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("78","FA2404-0076","1",NULL,NULL,NULL,"0",NULL,"16","2024-04-11 15:13:07","2024-04-11",NULL,"2024-04-11 15:13:18",NULL,NULL,"0","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","35.00000000","35.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","7","2024-04-12",NULL,NULL,"crabe","facture/FA2404-0076/FA2404-0076.pdf","0","",NULL,NULL,NULL,"0","0","2024-04-12","0",NULL,NULL,"0","EUR","1.00000000","35.00000000","0.00000000","35.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("79","FA2408-0077","1",NULL,NULL,NULL,"0",NULL,"25","2024-08-09 17:07:05","2024-08-09",NULL,"2024-08-10 11:57:07",NULL,NULL,"0","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","1500.00000000","1500.00000000","1","1","1","1",NULL,NULL,NULL,NULL,NULL,NULL,"0","7","2024-08-09",NULL,"Règlement de 600€ a la commande et 1100€ à la livraison.","crabe","facture/FA2408-0077/FA2408-0077.pdf","0","",NULL,NULL,NULL,"0","0","2024-08-09","0",NULL,NULL,"0","EUR","1.00000000","1500.00000000","0.00000000","1500.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("80","FA2410-0078","1",NULL,NULL,NULL,"0",NULL,"16","2024-10-05 10:25:25","2024-10-05",NULL,"2024-10-05 10:28:17","2024-10-11 18:31:56",NULL,"1","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","50.00000000","50.00000000","2","1",NULL,"1","1",NULL,NULL,NULL,NULL,NULL,"1","7","2024-10-06",NULL,NULL,"crabe","facture/FA2410-0078/FA2410-0078.pdf","0","",NULL,NULL,NULL,"0","0","2024-10-06","0",NULL,NULL,"0","EUR","1.00000000","50.00000000","0.00000000","50.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("81","FA2410-0079","1",NULL,NULL,"pla","0",NULL,"4","2024-10-05 10:48:35","2024-10-05",NULL,"2024-12-03 17:45:47","2024-12-03 17:46:25",NULL,"1","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","100.00000000","100.00000000","2","1",NULL,"1","1",NULL,NULL,NULL,NULL,NULL,"0","0","2024-10-05",NULL,NULL,"crabe","facture/FA2410-0079/FA2410-0079.pdf","0","",NULL,NULL,NULL,"0","0","2024-10-05","0",NULL,NULL,"0","EUR","1.00000000","100.00000000","0.00000000","100.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("82","FA2410-0080","1",NULL,NULL,NULL,"0",NULL,"11","2024-10-06 19:40:53","2024-10-06",NULL,"2024-10-06 19:41:09","2024-11-20 15:52:47",NULL,"1","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","32.00000000","32.00000000","2","1",NULL,"1","1",NULL,NULL,NULL,"2",NULL,"1","2","2024-10-07",NULL,NULL,"crabe","facture/FA2410-0080/FA2410-0080.pdf","0","",NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,"0","EUR","1.00000000","32.00000000","0.00000000","32.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("83","FA2410-0081","1",NULL,NULL,"sli","0",NULL,"10","2024-10-12 17:35:10","2024-10-12",NULL,"2024-10-12 17:35:19",NULL,NULL,"0","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","120.00000000","120.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,"2",NULL,"1","2","2024-10-13",NULL,NULL,"crabe","facture/FA2410-0081/FA2410-0081.pdf","0","",NULL,NULL,NULL,"0","0","2024-10-13","0",NULL,NULL,"0","EUR","1.00000000","120.00000000","0.00000000","120.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("84","FA2411-0082","1",NULL,NULL,NULL,"0",NULL,"11","2024-11-15 11:16:53","2024-11-15",NULL,"2024-11-15 11:23:25","2024-11-20 15:56:02",NULL,"1","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","50.00000000","50.00000000","2","1",NULL,"1","1",NULL,NULL,NULL,NULL,NULL,"0","0","2024-11-15",NULL,NULL,"crabe","facture/FA2411-0082/FA2411-0082.pdf","0","",NULL,NULL,NULL,"0","0","2024-11-15","0",NULL,NULL,"0","EUR","1.00000000","50.00000000","0.00000000","50.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("85","FA2412-0086","1",NULL,NULL,NULL,"0",NULL,"10","2024-12-03 10:34:24","2024-12-03",NULL,"2025-06-16 11:32:43",NULL,NULL,"0","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","166.00000000","166.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"0","0","2024-12-03",NULL,NULL,"crabe","facture/FA2412-0086/FA2412-0086.pdf","0","",NULL,NULL,NULL,"0","0","2024-12-03","0",NULL,NULL,"0","EUR","1.00000000","166.00000000","0.00000000","166.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("86","FA2412-0083","1",NULL,NULL,NULL,"0",NULL,"24","2024-12-10 10:39:26","2024-12-10",NULL,"2024-12-10 10:39:32",NULL,NULL,"0","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","300.00000000","300.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2024-12-11",NULL,NULL,"crabe","facture/FA2412-0083/FA2412-0083.pdf","0","",NULL,NULL,NULL,"0","0","2024-12-11","0",NULL,NULL,"0","EUR","1.00000000","300.00000000","0.00000000","300.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("87","FA2412-0084","1",NULL,NULL,NULL,"0",NULL,"24","2024-12-20 15:59:05","2024-12-20",NULL,"2024-12-20 15:59:22",NULL,NULL,"0","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","90.00000000","90.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","0","2024-12-21",NULL,NULL,"crabe","facture/FA2412-0084/FA2412-0084.pdf","0","",NULL,NULL,NULL,"0","0","2024-12-21","0",NULL,NULL,"0","EUR","1.00000000","90.00000000","0.00000000","90.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("88","FA2504-0085","1",NULL,NULL,NULL,"0",NULL,"16","2025-04-10 19:48:31","2025-04-10",NULL,"2025-04-10 20:10:57",NULL,NULL,"0","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","35.00000000","35.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"1","7","2025-04-11",NULL,NULL,"crabe","facture/FA2504-0085/FA2504-0085.pdf","0","",NULL,NULL,NULL,"0","0","2025-04-11","0",NULL,NULL,"0","EUR","1.00000000","35.00000000","0.00000000","35.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("89","FA2506-0087","1",NULL,NULL,NULL,"0",NULL,"27","2025-06-24 19:37:53","2025-06-24",NULL,"2025-06-24 19:38:09",NULL,NULL,"0","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","110.00000000","110.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"0","7","2025-06-24",NULL,NULL,"crabe","facture/FA2506-0087/FA2506-0087.pdf","0","",NULL,NULL,NULL,"0","0","2025-06-24","0",NULL,NULL,"0","EUR","1.00000000","110.00000000","0.00000000","110.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("90","FA2508-0088","1",NULL,NULL,NULL,"0",NULL,"11","2025-08-07 23:17:29","2025-08-07",NULL,"2025-08-07 23:19:05",NULL,NULL,"0","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","600.00000000","600.00000000","1","1","1","1",NULL,NULL,NULL,NULL,"2",NULL,"1","2","2025-08-08",NULL,"Règlement : 300 € à ma signature du devis et 300€ à la livraison","crabe","facture/FA2508-0088/FA2508-0088.pdf","0","",NULL,NULL,NULL,"0","0","2025-08-08","0",NULL,NULL,"0","EUR","1.00000000","600.00000000","0.00000000","600.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("91","FA2508-0089","1",NULL,NULL,NULL,"0",NULL,"28","2025-09-02 16:32:29","2025-08-15",NULL,"2025-09-27 14:31:55",NULL,NULL,"0","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","1552.00000000","1552.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,"2",NULL,"1","2","2025-08-16",NULL,NULL,"crabe","facture/FA2508-0089/FA2508-0089.pdf","0","",NULL,NULL,NULL,"0","0","2025-08-16","0",NULL,NULL,"0","EUR","1.00000000","1552.00000000","0.00000000","1552.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("92","FA2512-0090","1",NULL,NULL,NULL,"0",NULL,"11","2025-12-01 19:41:29","2025-12-01",NULL,"2025-12-01 19:44:22",NULL,NULL,"0","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","30.00000000","30.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"0","0","2025-12-01",NULL,NULL,"crabe","facture/FA2512-0090/FA2512-0090.pdf","0","",NULL,NULL,NULL,"0","0","2025-12-01","0",NULL,NULL,"0","EUR","1.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL,NULL,NULL);
INSERT INTO `llx_facture` VALUES("93","FA2512-0091","1",NULL,NULL,NULL,"0",NULL,"16","2025-12-15 19:56:08","2025-12-15",NULL,"2025-12-15 19:57:17",NULL,NULL,"0","0","0","0",NULL,NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","30.00000000","30.00000000","1","1",NULL,"1",NULL,NULL,NULL,NULL,NULL,NULL,"0","0","2025-12-15",NULL,NULL,"crabe","facture/FA2512-0091/FA2512-0091.pdf","0","",NULL,NULL,NULL,"0","0","2025-12-15","0",NULL,NULL,"0","EUR","1.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL,NULL,NULL);



DROP TABLE IF EXISTS `llx_facture_extrafields`;
CREATE TABLE `llx_facture_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_facture_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_facture_fourn`;
CREATE TABLE `llx_facture_fourn` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(180) NOT NULL,
  `ref_supplier` varchar(180) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `ref_ext` varchar(255) DEFAULT NULL,
  `type` smallint NOT NULL DEFAULT '0',
  `fk_soc` int NOT NULL,
  `datec` datetime DEFAULT NULL,
  `datef` date DEFAULT NULL,
  `date_pointoftax` date DEFAULT NULL,
  `date_valid` date DEFAULT NULL,
  `date_closing` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `libelle` varchar(255) DEFAULT NULL,
  `paye` smallint NOT NULL DEFAULT '0',
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `remise` double(24,8) DEFAULT '0.00000000',
  `close_code` varchar(16) DEFAULT NULL,
  `close_missing_amount` double(24,8) DEFAULT NULL,
  `close_note` varchar(128) DEFAULT NULL,
  `vat_reverse_charge` tinyint DEFAULT '0',
  `tva` double(24,8) DEFAULT '0.00000000',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `fk_statut` smallint NOT NULL DEFAULT '0',
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `fk_user_closing` int DEFAULT NULL,
  `fk_facture_source` int DEFAULT NULL,
  `fk_projet` int DEFAULT NULL,
  `fk_account` int DEFAULT NULL,
  `fk_cond_reglement` int DEFAULT NULL,
  `fk_mode_reglement` int DEFAULT NULL,
  `date_lim_reglement` date DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `fk_incoterms` int DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `fk_transport_mode` int DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `fk_fac_rec_source` int DEFAULT NULL,
  `revenuestamp` double(24,8) DEFAULT '0.00000000',
  `subtype` smallint DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_facture_fourn_ref` (`ref`,`entity`),
  UNIQUE KEY `uk_facture_fourn_ref_supplier` (`ref_supplier`,`fk_soc`,`entity`),
  KEY `idx_facture_fourn_date_lim_reglement` (`date_lim_reglement`),
  KEY `idx_facture_fourn_fk_soc` (`fk_soc`),
  KEY `idx_facture_fourn_fk_user_author` (`fk_user_author`),
  KEY `idx_facture_fourn_fk_user_valid` (`fk_user_valid`),
  KEY `idx_facture_fourn_fk_projet` (`fk_projet`),
  CONSTRAINT `fk_facture_fourn_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_facture_fourn_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_facture_fourn_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_facture_fourn_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_facture_fourn_det`;
CREATE TABLE `llx_facture_fourn_det` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_facture_fourn` int NOT NULL,
  `fk_parent_line` int DEFAULT NULL,
  `fk_product` int DEFAULT NULL,
  `ref` varchar(128) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `pu_ht` double(24,8) DEFAULT NULL,
  `pu_ttc` double(24,8) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `remise_percent` double DEFAULT '0',
  `fk_remise_except` int DEFAULT NULL,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT NULL,
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `total_ht` double(24,8) DEFAULT NULL,
  `tva` double(24,8) DEFAULT NULL,
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT NULL,
  `product_type` int DEFAULT '0',
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `info_bits` int DEFAULT '0',
  `fk_code_ventilation` int NOT NULL DEFAULT '0',
  `special_code` int DEFAULT '0',
  `rang` int DEFAULT '0',
  `import_key` varchar(14) DEFAULT NULL,
  `fk_unit` int DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_fk_remise_except` (`fk_remise_except`,`fk_facture_fourn`),
  KEY `idx_facture_fourn_det_fk_facture` (`fk_facture_fourn`),
  KEY `idx_facture_fourn_det_fk_product` (`fk_product`),
  KEY `idx_facture_fourn_det_fk_code_ventilation` (`fk_code_ventilation`),
  KEY `fk_facture_fourn_det_fk_unit` (`fk_unit`),
  CONSTRAINT `fk_facture_fourn_det_fk_facture` FOREIGN KEY (`fk_facture_fourn`) REFERENCES `llx_facture_fourn` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_facture_fourn_det_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_facture_fourn_det_extrafields`;
CREATE TABLE `llx_facture_fourn_det_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_facture_fourn_det_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_facture_fourn_det_rec`;
CREATE TABLE `llx_facture_fourn_det_rec` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_facture_fourn` int NOT NULL,
  `fk_parent_line` int DEFAULT NULL,
  `fk_product` int DEFAULT NULL,
  `ref` varchar(50) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `pu_ht` double(24,8) DEFAULT NULL,
  `pu_ttc` double(24,8) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `remise_percent` double DEFAULT '0',
  `fk_remise_except` int DEFAULT NULL,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(7,4) DEFAULT NULL,
  `localtax1_tx` double(7,4) DEFAULT '0.0000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(7,4) DEFAULT '0.0000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `total_ht` double(24,8) DEFAULT NULL,
  `total_tva` double(24,8) DEFAULT NULL,
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT NULL,
  `product_type` int DEFAULT '0',
  `date_start` int DEFAULT NULL,
  `date_end` int DEFAULT NULL,
  `info_bits` int DEFAULT '0',
  `special_code` int unsigned DEFAULT '0',
  `rang` int DEFAULT '0',
  `fk_unit` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  KEY `fk_facture_fourn_det_rec_fk_unit` (`fk_unit`),
  CONSTRAINT `fk_facture_fourn_det_rec_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_facture_fourn_det_rec_extrafields`;
CREATE TABLE `llx_facture_fourn_det_rec_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_facture_fourn_det_rec_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_facture_fourn_extrafields`;
CREATE TABLE `llx_facture_fourn_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_facture_fourn_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_facture_fourn_rec`;
CREATE TABLE `llx_facture_fourn_rec` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `titre` varchar(200) NOT NULL,
  `ref_supplier` varchar(180) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `subtype` smallint DEFAULT NULL,
  `fk_soc` int NOT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `suspended` int DEFAULT '0',
  `libelle` varchar(255) DEFAULT NULL,
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `remise` double DEFAULT '0',
  `vat_src_code` varchar(10) DEFAULT '',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_projet` int DEFAULT NULL,
  `fk_account` int DEFAULT NULL,
  `fk_cond_reglement` int DEFAULT NULL,
  `fk_mode_reglement` int DEFAULT NULL,
  `date_lim_reglement` date DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `modelpdf` varchar(255) DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `usenewprice` int DEFAULT '0',
  `frequency` int DEFAULT NULL,
  `unit_frequency` varchar(2) DEFAULT 'm',
  `date_when` datetime DEFAULT NULL,
  `date_last_gen` datetime DEFAULT NULL,
  `nb_gen_done` int DEFAULT NULL,
  `nb_gen_max` int DEFAULT NULL,
  `auto_validate` int DEFAULT '0',
  `generate_pdf` int DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_facture_fourn_rec_ref` (`titre`,`entity`),
  UNIQUE KEY `uk_facture_fourn_rec_ref_supplier` (`ref_supplier`,`fk_soc`,`entity`),
  KEY `idx_facture_fourn_rec_date_lim_reglement` (`date_lim_reglement`),
  KEY `idx_facture_fourn_rec_fk_soc` (`fk_soc`),
  KEY `idx_facture_fourn_rec_fk_user_author` (`fk_user_author`),
  KEY `idx_facture_fourn_rec_fk_projet` (`fk_projet`),
  CONSTRAINT `fk_facture_fourn_rec_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_facture_fourn_rec_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_facture_fourn_rec_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_facture_fourn_rec_extrafields`;
CREATE TABLE `llx_facture_fourn_rec_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_facture_fourn_rec_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_facture_rec`;
CREATE TABLE `llx_facture_rec` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `titre` varchar(200) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `subtype` smallint DEFAULT NULL,
  `fk_soc` int NOT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `suspended` int DEFAULT '0',
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `remise` double DEFAULT '0',
  `remise_percent` double DEFAULT '0',
  `remise_absolue` double DEFAULT '0',
  `vat_src_code` varchar(10) DEFAULT '',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `revenuestamp` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_projet` int DEFAULT NULL,
  `fk_cond_reglement` int NOT NULL DEFAULT '1',
  `fk_mode_reglement` int DEFAULT '0',
  `date_lim_reglement` date DEFAULT NULL,
  `fk_account` int DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `modelpdf` varchar(255) DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `usenewprice` int DEFAULT '0',
  `frequency` int DEFAULT NULL,
  `unit_frequency` varchar(2) DEFAULT 'm',
  `date_when` datetime DEFAULT NULL,
  `date_last_gen` datetime DEFAULT NULL,
  `nb_gen_done` int DEFAULT NULL,
  `nb_gen_max` int DEFAULT NULL,
  `auto_validate` int DEFAULT '0',
  `generate_pdf` int DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_facture_rec_uk_titre` (`titre`,`entity`),
  KEY `idx_facture_rec_fk_soc` (`fk_soc`),
  KEY `idx_facture_rec_fk_user_author` (`fk_user_author`),
  KEY `idx_facture_rec_fk_projet` (`fk_projet`),
  KEY `idx_facture_rec_datec` (`datec`),
  CONSTRAINT `fk_facture_rec_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_facture_rec_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_facture_rec_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_facture_rec_extrafields`;
CREATE TABLE `llx_facture_rec_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_facture_rec_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_facturedet`;
CREATE TABLE `llx_facturedet` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_facture` int NOT NULL,
  `fk_parent_line` int DEFAULT NULL,
  `fk_product` int DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT NULL,
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `remise_percent` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `fk_remise_except` int DEFAULT NULL,
  `subprice` double(24,8) DEFAULT NULL,
  `price` double(24,8) DEFAULT NULL,
  `total_ht` double(24,8) DEFAULT NULL,
  `total_tva` double(24,8) DEFAULT NULL,
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT NULL,
  `product_type` int DEFAULT '0',
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `info_bits` int DEFAULT '0',
  `buy_price_ht` double(24,8) DEFAULT '0.00000000',
  `fk_product_fournisseur_price` int DEFAULT NULL,
  `fk_code_ventilation` int NOT NULL DEFAULT '0',
  `special_code` int DEFAULT '0',
  `rang` int DEFAULT '0',
  `fk_contract_line` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `situation_percent` double DEFAULT '100',
  `fk_prev_id` int DEFAULT NULL,
  `fk_unit` int DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `ref_ext` varchar(255) DEFAULT NULL,
  `batch` varchar(128) DEFAULT NULL,
  `fk_warehouse` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_fk_remise_except` (`fk_remise_except`,`fk_facture`),
  KEY `idx_facturedet_fk_facture` (`fk_facture`),
  KEY `idx_facturedet_fk_product` (`fk_product`),
  KEY `idx_facturedet_fk_code_ventilation` (`fk_code_ventilation`),
  KEY `fk_facturedet_fk_unit` (`fk_unit`),
  CONSTRAINT `fk_facturedet_fk_facture` FOREIGN KEY (`fk_facture`) REFERENCES `llx_facture` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_facturedet_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=161 DEFAULT CHARSET=latin1;

INSERT INTO `llx_facturedet` VALUES("1","1",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de septembre 2018","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("2","2",NULL,"1",NULL,"Hébergement Offre Mutualisée Pro 2014 - 12 mois Du 16 Juin 2018 au 15 Juin 2019","","0.000","0.000","0","0.000","0","1","0","0",NULL,"120.00000000",NULL,"120.00000000","0.00000000","0.00000000","0.00000000","120.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","120.00000000","120.00000000","0.00000000","120.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("3","2",NULL,"2",NULL,"Domaine offert la première année de l\'hébergement","","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("4","2",NULL,"3",NULL,"Demande de transfert d\'un domaine .com","","0.000","0.000","0","0.000","0","1","0","0",NULL,"7.99000000",NULL,"7.99000000","0.00000000","0.00000000","0.00000000","7.99000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","3",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","7.99000000","7.99000000","0.00000000","7.99000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("5","2",NULL,"4",NULL,"Migration de site vers le nouvel hébergeur, modification sur les produits, paramétrages et formation","","0.000","0.000","0","0.000","0","1","0","0",NULL,"400.00000000",NULL,"400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","4",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","400.00000000","400.00000000","0.00000000","400.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("6","3",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de novembre 2018","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("7","4",NULL,NULL,NULL,"Installation du site internet et\r\nparamétrages.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"350.00000000",NULL,"350.00000000","0.00000000","0.00000000","0.00000000","350.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","350.00000000","350.00000000","0.00000000","350.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("8","4",NULL,NULL,NULL,"Intégration des pages et de la navigation.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("9","4",NULL,NULL,NULL,"Intégration des contenus et des images.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","3",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("10","5",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de decembre 2018","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("11","6",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de janvier 2019","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("12","7",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de fevrier 2019","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("13","8",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de mars 2019","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("14","9",NULL,NULL,NULL,"Prêt de 3 ordinateurs à l’année.\r\nUne imprimante, une webcam.\r\nMaintenance régulière (sauvegarde).\r\nIntervention rapide en cas de\r\npanne.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"770.00000000",NULL,"770.00000000","0.00000000","0.00000000","0.00000000","770.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","770.00000000","770.00000000","0.00000000","770.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("15","9",NULL,NULL,NULL,"Conseil et maintenance logiciel pour\r\nle réseau et réglage pilote\r\nimprimante si nécessaire.\r\nContrat du 01/02/2019 au 30/01/2020","","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("16","10",NULL,NULL,NULL,"Maintenance mensuel du site internet mois d\'avril 2019","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("17","11",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de mai 2019","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("18","12",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de juin 2019","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("19","13",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de juillet 2019","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("20","14",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de août 2019","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("21","15",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de septembre 2019","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("22","16",NULL,NULL,NULL,"Maintenance mensuel du site internet mois d\'octobre 2019","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("23","17",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de novembre 2019","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("24","18",NULL,NULL,NULL,"Analyse du site internet et optimisation du contenu pour un meilleur référencement sur les moteurs de recherches.\r\nMois de décembre 2019","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("25","19",NULL,NULL,NULL,"Analyse du site internet et optimisation du contenu pour un meilleur référencement sur les moteurs de recherches.\r\nMois de janvier 2020","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("26","20",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de décembre 2019","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("27","21",NULL,NULL,NULL,"Remise en fonction du site internet - nettoyage de la base de données","","0.000","0.000","0","0.000","0","1","0","0",NULL,"35.00000000",NULL,"35.00000000","0.00000000","0.00000000","0.00000000","35.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","35.00000000","35.00000000","0.00000000","35.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("28","22",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de janvier 2020","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("29","23",NULL,NULL,NULL,"Contrat annuel de maintenance standard 5 postes et réseau informatique.\r\nDates du contrat : du 01 mars 2019 au 01 mars 2020.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("30","23",NULL,NULL,NULL,"Contrat de base","","0.000","0.000","0","0.000","0","5","0","0",NULL,"250.00000000",NULL,"1250.00000000","0.00000000","0.00000000","0.00000000","1250.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","250.00000000","1250.00000000","0.00000000","1250.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("31","23",NULL,NULL,NULL,"Réseau informatique (inclus)","","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","3",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("32","24",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de février 2020","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("35","25",NULL,"3",NULL,"Nom de domaine .com","","0.000","0.000","0","0.000","0","1","0","0",NULL,"7.99000000",NULL,"7.99000000","0.00000000","0.00000000","0.00000000","7.99000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","3",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","7.99000000","7.99000000","0.00000000","7.99000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("37","25",NULL,NULL,NULL,"Hébergement Offre Mutualisée Pro 2014 - 12 mois Du 1 Juin 2020 au 1 Juin 2021","","0.000","0.000","0","0.000","0","1","0","0",NULL,"120.00000000",NULL,"120.00000000","0.00000000","0.00000000","0.00000000","120.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","120.00000000","120.00000000","0.00000000","120.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("38","26",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de mars 2020","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("39","27",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de avril 2020","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("40","28",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de avril 2020","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("41","29",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de juin 2020","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("42","30",NULL,NULL,NULL,"Création de l\'application Slimane Pro pour les commandes des revendeurs","","0.000","0.000","0","0.000","0","1","0","0",NULL,"500.00000000",NULL,"500.00000000","0.00000000","0.00000000","0.00000000","500.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","500.00000000","500.00000000","0.00000000","500.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("43","31",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de juillet 2020","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("44","32",NULL,NULL,NULL,"Installation du site ecommerce Prestashop et Configuration. Installation du thème et ajustements. Import et ajout des produits et photos produits. Paramétrage des modes de livraisons et tarifs. installation et tests des modes de payements. Ajout des pages informations pour les hébergements. Amélioration des contenues pour un meilleur réferencement des moteurs de recherches.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"1700.00000000",NULL,"1700.00000000","0.00000000","0.00000000","0.00000000","1700.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","1700.00000000","1700.00000000","0.00000000","1700.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("45","32",NULL,NULL,NULL,"Sauvegarde de votre ancien site.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("46","32",NULL,NULL,NULL,"Mise en ligne du site ecommerce.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","3",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("48","33",NULL,NULL,NULL,"Maintenance du site  internet et optimisation.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"300.00000000",NULL,"300.00000000","0.00000000","0.00000000","0.00000000","300.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","300.00000000","300.00000000","0.00000000","300.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("49","34",NULL,NULL,NULL,"Recherche de virus et nettoyage de l\'ordinateur.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000",NULL,"30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("50","35",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de août 2020","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("51","36",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de septembre 2020","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("52","37",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de octobre 2020","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("53","38",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de novembre 2020","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("54","39",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de décembre 2020","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("55","40",NULL,NULL,NULL,"Hébergement  du site internet et nom de domaine (27/10/2020-26/10/2021) artiligne.com","","0.000","0.000","0","0.000","0","1","0","0",NULL,"170.00000000",NULL,"170.00000000","0.00000000","0.00000000","0.00000000","170.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","170.00000000","170.00000000","0.00000000","170.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("56","41",NULL,NULL,NULL,"Maintenance du site  internet et optimisations.\r\nParamétrages du logiciel de gestion.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"1000.00000000",NULL,"1000.00000000","0.00000000","0.00000000","0.00000000","1000.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","1000.00000000","1000.00000000","0.00000000","1000.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("57","42",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de janvier 2021","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("58","43",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de février  2021","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("59","44",NULL,NULL,NULL,"Contrat annuel de maintenance standard 5 postes et réseau informatique.\r\nDates du contrat : du 01 mars 2021 au 01 mars 2022.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("60","44",NULL,NULL,NULL,"Contrat de base","","0.000","0.000","0","0.000","0","5","0","0",NULL,"255.00000000",NULL,"1275.00000000","0.00000000","0.00000000","0.00000000","1275.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","255.00000000","1275.00000000","0.00000000","1275.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("61","44",NULL,NULL,NULL,"Réseau informatique (inclus)","","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","3",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("62","45",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de mars  2021","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("63","46",NULL,NULL,NULL,"Préparation a la migration du site internet www.billardsdefrance.fr sur le serveur local","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("64","47",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de avril 2021","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("65","48",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de mai 2021","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("66","49",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de juin 2021","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("67","50",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de juillet 2021","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("68","51",NULL,NULL,NULL,"Sauvegarde du site internet","","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000",NULL,"50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("69","51",NULL,NULL,NULL,"Installation sur le serveur test et parametrages.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"120.00000000",NULL,"120.00000000","0.00000000","0.00000000","0.00000000","120.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","120.00000000","120.00000000","0.00000000","120.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("70","51",NULL,NULL,NULL,"Installation de la version de prestashop cible 1,7","","0.000","0.000","0","0.000","0","1","0","0",NULL,"90.00000000",NULL,"90.00000000","0.00000000","0.00000000","0.00000000","90.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","3",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","90.00000000","90.00000000","0.00000000","90.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("71","51",NULL,NULL,NULL,"Désactivation des modules non compatible avec la version cible.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","4",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("72","51",NULL,NULL,NULL,"Migrations des données sur la nouvelles installation cible. (produits, images, déclinaisons, clients, et ancienne factures si possible)","","0.000","0.000","0","0.000","0","1","0","0",NULL,"1100.00000000",NULL,"1100.00000000","0.00000000","0.00000000","0.00000000","1100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","5",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","1100.00000000","1100.00000000","0.00000000","1100.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("73","51",NULL,NULL,NULL,"Configuration des moyens de transport et tarifs","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","6",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("74","51",NULL,NULL,NULL,"Configurations des moyens de payements","","0.000","0.000","0","0.000","0","1","0","0",NULL,"600.00000000",NULL,"600.00000000","0.00000000","0.00000000","0.00000000","600.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","7",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","600.00000000","600.00000000","0.00000000","600.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("75","51",NULL,NULL,NULL,"Installation du thème choisi par le client","","0.000","0.000","0","0.000","0","1","0","0",NULL,"120.00000000",NULL,"120.00000000","0.00000000","0.00000000","0.00000000","120.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","8",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","120.00000000","120.00000000","0.00000000","120.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("76","51",NULL,NULL,NULL,"Installations des modules déjà acquis.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","9",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("77","51",NULL,NULL,NULL,"Vérification complète  du bon fonctionnement avant mise en ligne","","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000",NULL,"50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","10",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("78","51",NULL,NULL,NULL,"Changement de la version de php  (langage de prestashop) sur le serveur et mise en ligne du site en version 1.7","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","11",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("79","51",NULL,NULL,NULL,"Vérification complète du bon fonctionnement du site en production.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000",NULL,"50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","12",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("80","52",NULL,NULL,NULL,"Intervention sur le site de facturation : Nettoyage de la base de donnée, et blocage de la source du problème.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"95.00000000",NULL,"95.00000000","0.00000000","0.00000000","0.00000000","95.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","95.00000000","95.00000000","0.00000000","95.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("81","53",NULL,NULL,NULL,"Installation  du site internet  (Solution et base de donnée)","","0.000","0.000","0","0.000","0","1","0","0",NULL,"300.00000000",NULL,"300.00000000","0.00000000","0.00000000","0.00000000","300.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","300.00000000","300.00000000","0.00000000","300.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("82","53",NULL,NULL,NULL,"Mise en ligne des produits","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("84","54",NULL,NULL,NULL,"Calendrier de l\'avent sur site internet","","0.000","0.000","0","0.000","0","1","0","0",NULL,"250.00000000",NULL,"250.00000000","0.00000000","0.00000000","0.00000000","250.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","250.00000000","250.00000000","0.00000000","250.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("85","55",NULL,NULL,NULL,"Création d\'un site administrable pour gestion/publication du planning du club.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"400.00000000",NULL,"400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","400.00000000","400.00000000","0.00000000","400.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("86","56",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de janvier 2022","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("87","57",NULL,NULL,NULL,"Maintenance mensuel du site internet mois de fevrier 2022","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("88","58",NULL,NULL,NULL,"Réparation du site internet et remise en fonction de l\'éditeur.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"75.00000000",NULL,"75.00000000","0.00000000","0.00000000","0.00000000","75.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","75.00000000","75.00000000","0.00000000","75.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("89","59",NULL,NULL,NULL,"Modification en masse des déclinaisons du site internet et préparation d\'un tutoriel vidéo pour l\'utilisation du module.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"85.00000000",NULL,"85.00000000","0.00000000","0.00000000","0.00000000","85.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","85.00000000","85.00000000","0.00000000","85.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("90","60",NULL,NULL,NULL,"Maintenance du site  internet et optimisations.\r\nParamétrages du logiciel de gestion.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"1050.00000000",NULL,"1050.00000000","0.00000000","0.00000000","0.00000000","1050.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","1050.00000000","1050.00000000","0.00000000","1050.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("91","61",NULL,NULL,NULL,"Hébergement Offre Mutualisée Pro 2014 - 12 mois Du 1 Juin 2022 au 1 Juin 2023","","0.000","0.000","0","0.000","0","1","0","0",NULL,"130.00000000",NULL,"130.00000000","0.00000000","0.00000000","0.00000000","130.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","130.00000000","130.00000000","0.00000000","130.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("93","62",NULL,NULL,NULL,"Mise a jour/ajout d\'un article sur prestashop (ajout foire)","","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000",NULL,"30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("94","63",NULL,NULL,NULL,"Modifications de paramètres  afin de differencier les clients métropole et Corse pour appliquer les tarifs de livraisons correspondant.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000",NULL,"30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("95","64",NULL,NULL,NULL,"Intervention sur le site internet pour rétablir la connexion à la base de donnée.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"78.00000000",NULL,"78.00000000","0.00000000","0.00000000","0.00000000","78.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","78.00000000","78.00000000","0.00000000","78.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("96","65",NULL,NULL,NULL,"Mise a jour du planning papier 2022 pr&eacute;paration pour l&#39;impression.<br />\r\nMaintenance r&eacute;guli&egrave;re (sauvegarde).<br />\r\nIntervention rapide en cas de panne.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"800.00000000",NULL,"800.00000000","0.00000000","0.00000000","0.00000000","800.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","800.00000000","800.00000000","0.00000000","800.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("97","65",NULL,NULL,NULL,"Conseil et maintenance logiciel pour<br />\r\nle r&eacute;seau et r&eacute;glage pilote<br />\r\nimprimante si n&eacute;cessaire.<br />\r\nContrat du 01/09/2022 au 30/08/2023","","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("98","66",NULL,NULL,NULL,"Installation d\'une solution e-Commerce pour la vente en ligne d\'objets personnalisés.\r\ninstallation et paramétrage du module e-Commerce  \r\nAmélioration du thème\r\nInstallation et paramétrage  du  module de personnalisation.\r\nAjout de 4 produits\r\nParamétrage du moyen de payement et vérification du site.\r\nFormation a la gestion des commandes et ajout de produits.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"1100.00000000",NULL,"1100.00000000","0.00000000","0.00000000","0.00000000","1100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","1100.00000000","1100.00000000","0.00000000","1100.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("99","62",NULL,NULL,NULL,"Mise a jour du module de paiement etransaction&nbsp;","","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000",NULL,"30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("100","67",NULL,"3",NULL,"Demande de transfert d\'un domaine .com","","0.000","0.000","0","0.000","0","1","0","0",NULL,"7.99000000",NULL,"7.99000000","0.00000000","0.00000000","0.00000000","7.99000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","7.99000000","7.99000000","0.00000000","7.99000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("101","67",NULL,NULL,NULL,"Installation du site vitrine sur les bases du site existant.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"649.00000000",NULL,"649.00000000","0.00000000","0.00000000","0.00000000","649.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","649.00000000","649.00000000","0.00000000","649.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("102","67",NULL,NULL,NULL,"Installation du certificat de s&eacute;curit&eacute; https","","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000",NULL,"30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","3",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("103","67",NULL,NULL,NULL,"Ajout de nouveaus contenus au site et modifications","","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000",NULL,"30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","4",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("104","68",NULL,NULL,NULL,"H&eacute;bergement Offre Mutualis&eacute;e Pro 2014 - 12 mois Du 1 Juin 2023 au 1 Juin 2024","","0.000","0.000","0","0.000","0","1","0","0",NULL,"130.00000000",NULL,"130.00000000","0.00000000","0.00000000","0.00000000","130.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","130.00000000","130.00000000","0.00000000","130.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("106","70",NULL,NULL,NULL,"Installation du site internet et param&eacute;trage","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("107","70",NULL,NULL,NULL,"Installation des modules et parametrages","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("108","70",NULL,NULL,NULL,"Travail sur les elements graphiques&nbsp;","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","3",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("109","70",NULL,NULL,NULL,"Mise en forme css et code javascript","","0.000","0.000","0","0.000","0","1","0","0",NULL,"100.00000000",NULL,"100.00000000","0.00000000","0.00000000","0.00000000","100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","4",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","100.00000000","100.00000000","0.00000000","100.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("110","70",NULL,NULL,NULL,"Edition des pages et navigation du site.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"100.00000000",NULL,"100.00000000","0.00000000","0.00000000","0.00000000","100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","5",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","100.00000000","100.00000000","0.00000000","100.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("111","71",NULL,NULL,NULL,"Mise &agrave; jour du module Floa banque. conservation des param&egrave;tres","","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000",NULL,"30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("112","72",NULL,NULL,NULL,"Ajout de Searchconsole pour billardsdefrance.fr","","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000",NULL,"30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("113","73",NULL,NULL,NULL,"Mise a jour/ajout d&#39;un article sur prestashop (ajout foire)","","0.000","0.000","0","0.000","0","1","0","0",NULL,"32.00000000",NULL,"32.00000000","0.00000000","0.00000000","0.00000000","32.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","32.00000000","32.00000000","0.00000000","32.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("114","74",NULL,NULL,NULL,"Mise a jour du planning papier 2023 pr&eacute;paration pour l&#39;impression.<br />\r\nMaintenance r&eacute;guli&egrave;re (sauvegarde).<br />\r\nIntervention rapide en cas de panne.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"800.00000000",NULL,"800.00000000","0.00000000","0.00000000","0.00000000","800.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","800.00000000","800.00000000","0.00000000","800.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("115","74",NULL,NULL,NULL,"Conseil et maintenance logiciel pour<br />\r\nle r&eacute;seau et r&eacute;glage pilote<br />\r\nimprimante si n&eacute;cessaire.<br />\r\nContrat du 01/09/2023 au 30/08/2024","","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("116","75",NULL,NULL,NULL,"Installation et configuration","","0.000","0.000","0","0.000","0","1","0","0",NULL,"150.00000000",NULL,"150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","150.00000000","150.00000000","0.00000000","150.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("117","75",NULL,NULL,NULL,"Cr&eacute;ation d&#39;un site internet vitrine.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"350.00000000",NULL,"350.00000000","0.00000000","0.00000000","0.00000000","350.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","350.00000000","350.00000000","0.00000000","350.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("118","75",NULL,NULL,NULL,"insertion des elements graphiques et de pages","","0.000","0.000","0","0.000","0","1","0","0",NULL,"150.00000000",NULL,"150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","3",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","150.00000000","150.00000000","0.00000000","150.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("119","75",NULL,NULL,NULL,"Personnalisation du design","","0.000","0.000","0","0.000","0","1","0","0",NULL,"150.00000000",NULL,"150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","4",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","150.00000000","150.00000000","0.00000000","150.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("120","76",NULL,NULL,NULL,"Modification du theme afin d&#39;afficher de mani&egrave;re plus visible le commantaire de commande","","0.000","0.000","0","0.000","0","1","0","0",NULL,"32.00000000",NULL,"32.00000000","0.00000000","0.00000000","0.00000000","32.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","32.00000000","32.00000000","0.00000000","32.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("121","77",NULL,NULL,NULL,"Prestation pour le parametrage et la maintenance du site internet avec helloasso exercice 2023","","0.000","0.000","0","0.000","0","1","0","0",NULL,"300.00000000",NULL,"300.00000000","0.00000000","0.00000000","0.00000000","300.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","300.00000000","300.00000000","0.00000000","300.00000000",NULL,NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("122","78",NULL,NULL,NULL,"Modification de la page cat&eacute;gorie pour supprimer l&#39;affichage liste","","0.000","0.000","0","0.000","0","1","0","0",NULL,"35.00000000",NULL,"35.00000000","0.00000000","0.00000000","0.00000000","35.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","35.00000000","35.00000000","0.00000000","35.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("123","79",NULL,NULL,NULL,"Cr&eacute;ation du nom de domaine instalation de l&#39;h&eacute;bergement et du site internet.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("124","79",NULL,NULL,NULL,"Installation et configuration de la solution de vente en ligne","","0.000","0.000","0","0.000","0","1","0","0",NULL,"400.00000000",NULL,"400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","400.00000000","400.00000000","0.00000000","400.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("125","79",NULL,NULL,NULL,"Param&eacute;trage du th&egrave;me et modifications","","0.000","0.000","0","0.000","0","1","0","0",NULL,"400.00000000",NULL,"400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","3",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","400.00000000","400.00000000","0.00000000","400.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("126","79",NULL,NULL,NULL,"Ajout des produits et tarifs","","0.000","0.000","0","0.000","0","1","0","0",NULL,"400.00000000",NULL,"400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","4",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","400.00000000","400.00000000","0.00000000","400.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("127","79",NULL,NULL,NULL,"Configuration de la boutique en ligne, param&eacute;trage et tests.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"100.00000000",NULL,"100.00000000","0.00000000","0.00000000","0.00000000","100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","5",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","100.00000000","100.00000000","0.00000000","100.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("128","79",NULL,NULL,NULL,"<strong><em>R&egrave;glement de 600&euro; &agrave; la commande et 900&euro; &agrave; la livraison.</em></strong>","","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","6",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","0.00000000","0.00000000","0.00000000","0.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("129","80",NULL,NULL,NULL,"Installation d&#39;un module de compte a rebour fin de promotion sur la page produit.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000",NULL,"50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","50.00000000","50.00000000","0.00000000","50.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("130","81",NULL,NULL,NULL,"Nettoyage du site internet apr&eacute;s piratage, ajout de firewall et outils de verification d&#39;integrit&eacute; du site.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"100.00000000",NULL,"100.00000000","0.00000000","0.00000000","0.00000000","100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","100.00000000","100.00000000","0.00000000","100.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("131","82",NULL,NULL,NULL,"Mise a jour/ajout d&#39;un article sur prestashop (ajout foire)","","0.000","0.000","0","0.000","0","1","0","0",NULL,"32.00000000",NULL,"32.00000000","0.00000000","0.00000000","0.00000000","32.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","32.00000000","32.00000000","0.00000000","32.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("132","83",NULL,NULL,NULL,"Mise a jour du module de payement sur le site pro et particulier et test.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000",NULL,"50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","50.00000000","50.00000000","0.00000000","50.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("133","83",NULL,NULL,NULL,"Correction du bug sur la sur la page de modification des produits","","0.000","0.000","0","0.000","0","1","0","0",NULL,"70.00000000",NULL,"70.00000000","0.00000000","0.00000000","0.00000000","70.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","70.00000000","70.00000000","0.00000000","70.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("134","84",NULL,NULL,NULL,"Mise a jour du module de paiement et correction de l&#39;&eacute;tape d&#39;affichage des moyens de livraisons.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"40.00000000",NULL,"40.00000000","0.00000000","0.00000000","0.00000000","40.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","40.00000000","40.00000000","0.00000000","40.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("135","84",NULL,NULL,NULL,"Corrections des r&eacute;ductions pour les p&acirc;t&eacute;s (6 , 12, 18, etc)","","0.000","0.000","0","0.000","0","1","0","0",NULL,"10.00000000",NULL,"10.00000000","0.00000000","0.00000000","0.00000000","10.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","10.00000000","10.00000000","0.00000000","10.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("136","85",NULL,NULL,NULL,"Recherche de problemes dans le systeme de paiement","","0.000","0.000","0","0.000","0","1","0","0",NULL,"20.00000000",NULL,"20.00000000","0.00000000","0.00000000","0.00000000","20.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","20.00000000","20.00000000","0.00000000","20.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("137","85",NULL,NULL,NULL,"Intervertion des ordinateurs impressions etiquettes et impressions des courbes de cuissons pour une meilleur performance.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"80.00000000",NULL,"80.00000000","0.00000000","0.00000000","0.00000000","80.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","80.00000000","80.00000000","0.00000000","80.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("138","85",NULL,NULL,NULL,"Ajout de 3 produits avec code barre et reference, creation des etiquettes, photo et mise en ligne sur les deux sites.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000",NULL,"50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","3",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","50.00000000","50.00000000","0.00000000","50.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("139","86",NULL,NULL,NULL,"Prestation pour le parametrage et la maintenance du site internet GDSA65 avec HelloAsso exercice 2024","","0.000","0.000","0","0.000","0","1","0","0",NULL,"300.00000000",NULL,"300.00000000","0.00000000","0.00000000","0.00000000","300.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","300.00000000","300.00000000","0.00000000","300.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("140","85",NULL,NULL,NULL,"Ajout d&#39;un nouveau produit (confit d&#39;oie) sur site particulier et pro et gestion commerciale, creation code barre et etiquette + photo","","0.000","0.000","0","0.000","0","1","0","0",NULL,"16.00000000",NULL,"16.00000000","0.00000000","0.00000000","0.00000000","16.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","4",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","16.00000000","16.00000000","0.00000000","16.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("141","87",NULL,NULL,NULL,"Prestation pour la pr&eacute;paration et l&#39;envoi de l&#39;invitation aux r&eacute;unions du GDSA65 (janvier 2025 et F&eacute;vrier 2025))","","0.000","0.000","0","0.000","0","1","0","0",NULL,"90.00000000",NULL,"90.00000000","0.00000000","0.00000000","0.00000000","90.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","90.00000000","90.00000000","0.00000000","90.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("142","88",NULL,NULL,NULL,"Modidfication de la pr&eacute;sentation du formulaire de contact afin de le rendre plus visible et changement de possition de la case a cocher","","0.000","0.000","0","0.000","0","1","0","0",NULL,"35.00000000",NULL,"35.00000000","0.00000000","0.00000000","0.00000000","35.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","35.00000000","35.00000000","0.00000000","35.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("143","89",NULL,NULL,NULL,"R&eacute;paration, netoyage et parametrage de l&#39;ordinateur.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"110.00000000",NULL,"110.00000000","0.00000000","0.00000000","0.00000000","110.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","110.00000000","110.00000000","0.00000000","110.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("144","90",NULL,NULL,NULL,"Sauvegarde du site internet","","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000",NULL,"50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","50.00000000","50.00000000","0.00000000","50.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("145","90",NULL,NULL,NULL,"Installation sur le serveur test de mise &agrave; jour et parametrages.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000",NULL,"50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","50.00000000","50.00000000","0.00000000","50.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("146","90",NULL,NULL,NULL,"Mise a jour vers le version cible de prestashop. (produits, images, d&eacute;clinaisons, clients, et ancienne factures)","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","3",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("147","90",NULL,NULL,NULL,"Configurations des moyens de payements","","0.000","0.000","0","0.000","0","1","0","0",NULL,"100.00000000",NULL,"100.00000000","0.00000000","0.00000000","0.00000000","100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","4",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","100.00000000","100.00000000","0.00000000","100.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("148","90",NULL,NULL,NULL,"Installation du th&egrave;me choisi par le client","","0.000","0.000","0","0.000","0","1","0","0",NULL,"100.00000000",NULL,"100.00000000","0.00000000","0.00000000","0.00000000","100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","5",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","100.00000000","100.00000000","0.00000000","100.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("149","90",NULL,NULL,NULL,"Installation du module de livraison MBE (offert)","","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","6",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","0.00000000","0.00000000","0.00000000","0.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("150","90",NULL,NULL,NULL,"Configuration des moyens de transport et tarifs","","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000",NULL,"50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","7",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","50.00000000","50.00000000","0.00000000","50.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("151","90",NULL,NULL,NULL,"Vérification complète du bon fonctionnement du site en production.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000",NULL,"50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","8",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","50.00000000","50.00000000","0.00000000","50.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("152","91",NULL,NULL,NULL,"Cr&eacute;ation du nom de domaine instalation de l&#39;h&eacute;bergement et du site internet.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000",NULL,"200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","200.00000000","200.00000000","0.00000000","200.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("153","91",NULL,NULL,NULL,"Installation et configuration de la solution de vente en ligne","","0.000","0.000","0","0.000","0","1","0","0",NULL,"400.00000000",NULL,"400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","2",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","400.00000000","400.00000000","0.00000000","400.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("154","91",NULL,NULL,NULL,"Param&eacute;trage du th&egrave;me et modifications","","0.000","0.000","0","0.000","0","1","0","0",NULL,"400.00000000",NULL,"400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","3",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","400.00000000","400.00000000","0.00000000","400.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("155","91",NULL,NULL,NULL,"Ajout des produits et tarifs","","0.000","0.000","0","0.000","0","1","0","0",NULL,"400.00000000",NULL,"400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","4",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","400.00000000","400.00000000","0.00000000","400.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("156","91",NULL,NULL,NULL,"Configuration de la boutique en ligne, param&eacute;trage et tests.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"88.00000000",NULL,"88.00000000","0.00000000","0.00000000","0.00000000","88.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","5",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","88.00000000","88.00000000","0.00000000","88.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("157","91",NULL,NULL,NULL,"R&eacute;glement de 744 &euro; &agrave; la signature puis 744 &euro; + 64 &euro; d&#39;h&eacute;bergement : <strong>808 &euro; &agrave; la mise en ligne.</strong>","","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","7",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","0.00000000","0.00000000","0.00000000","0.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("158","91",NULL,NULL,NULL,"R&eacute;glement de l&#39;ebergement OVH pour la prem&egrave;re ann&eacute;e :&nbsp;FR71526848&nbsp;&nbsp; &nbsp;231849425&nbsp;&nbsp; &nbsp;<br />\r\n28 juil. 2025","","0.000","0.000","0","0.000","0","1","0","0",NULL,"64.00000000",NULL,"64.00000000","0.00000000","0.00000000","0.00000000","64.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","6",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","64.00000000","64.00000000","0.00000000","64.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("159","92",NULL,NULL,NULL,"pr&eacute;paration des fichiers contact pour envois des SMS et envoi.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000",NULL,"30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","30.00000000","30.00000000","0.00000000","30.00000000","",NULL,NULL);
INSERT INTO `llx_facturedet` VALUES("160","93",NULL,NULL,NULL,"Modification du style Css afin d&#39;afficher les &eacute;l&eacute;ments du menu sans le soulign&eacute;.","","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000",NULL,"30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","0","1",NULL,NULL,"100",NULL,NULL,"1","1","0","EUR","30.00000000","30.00000000","0.00000000","30.00000000","",NULL,NULL);



DROP TABLE IF EXISTS `llx_facturedet_extrafields`;
CREATE TABLE `llx_facturedet_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_facturedet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_facturedet_rec`;
CREATE TABLE `llx_facturedet_rec` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_facture` int NOT NULL,
  `fk_parent_line` int DEFAULT NULL,
  `fk_product` int DEFAULT NULL,
  `product_type` int DEFAULT '0',
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT NULL,
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `remise_percent` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `subprice` double(24,8) DEFAULT NULL,
  `price` double(24,8) DEFAULT NULL,
  `total_ht` double(24,8) DEFAULT NULL,
  `total_tva` double(24,8) DEFAULT NULL,
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT NULL,
  `date_start_fill` int DEFAULT '0',
  `date_end_fill` int DEFAULT '0',
  `info_bits` int DEFAULT '0',
  `special_code` int unsigned DEFAULT '0',
  `rang` int DEFAULT '0',
  `fk_contract_line` int DEFAULT NULL,
  `fk_unit` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `buy_price_ht` double(24,8) DEFAULT '0.00000000',
  `fk_product_fournisseur_price` int DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `fk_facturedet_rec_fk_unit` (`fk_unit`),
  CONSTRAINT `fk_facturedet_rec_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_facturedet_rec_extrafields`;
CREATE TABLE `llx_facturedet_rec_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_facturedet_rec_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_fichinter`;
CREATE TABLE `llx_fichinter` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_soc` int NOT NULL,
  `fk_projet` int DEFAULT '0',
  `fk_contrat` int DEFAULT '0',
  `ref` varchar(30) NOT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `ref_client` varchar(255) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `datei` date DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `fk_statut` smallint DEFAULT '0',
  `dateo` date DEFAULT NULL,
  `datee` date DEFAULT NULL,
  `datet` date DEFAULT NULL,
  `duree` double DEFAULT NULL,
  `description` text,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_fichinter_ref` (`ref`,`entity`),
  KEY `idx_fichinter_fk_soc` (`fk_soc`),
  CONSTRAINT `fk_fichinter_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_fichinter_extrafields`;
CREATE TABLE `llx_fichinter_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_ficheinter_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_fichinter_rec`;
CREATE TABLE `llx_fichinter_rec` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `titre` varchar(50) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `fk_soc` int DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `fk_contrat` int DEFAULT '0',
  `fk_user_author` int DEFAULT NULL,
  `fk_projet` int DEFAULT NULL,
  `duree` double DEFAULT NULL,
  `description` text,
  `modelpdf` varchar(50) DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `frequency` int DEFAULT NULL,
  `unit_frequency` varchar(2) DEFAULT 'm',
  `date_when` datetime DEFAULT NULL,
  `date_last_gen` datetime DEFAULT NULL,
  `nb_gen_done` int DEFAULT NULL,
  `nb_gen_max` int DEFAULT NULL,
  `auto_validate` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_fichinter_rec_uk_titre` (`titre`,`entity`),
  KEY `idx_fichinter_rec_fk_soc` (`fk_soc`),
  KEY `idx_fichinter_rec_fk_user_author` (`fk_user_author`),
  KEY `idx_fichinter_rec_fk_projet` (`fk_projet`),
  CONSTRAINT `fk_fichinter_rec_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_fichinter_rec_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_fichinterdet`;
CREATE TABLE `llx_fichinterdet` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_fichinter` int DEFAULT NULL,
  `fk_parent_line` int DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `description` text,
  `duree` int DEFAULT NULL,
  `rang` int DEFAULT '0',
  PRIMARY KEY (`rowid`),
  KEY `idx_fichinterdet_fk_fichinter` (`fk_fichinter`),
  CONSTRAINT `fk_fichinterdet_fk_fichinter` FOREIGN KEY (`fk_fichinter`) REFERENCES `llx_fichinter` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_fichinterdet_extrafields`;
CREATE TABLE `llx_fichinterdet_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_ficheinterdet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_fichinterdet_rec`;
CREATE TABLE `llx_fichinterdet_rec` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_fichinter` int NOT NULL,
  `date` datetime DEFAULT NULL,
  `description` text,
  `duree` int DEFAULT NULL,
  `rang` int DEFAULT '0',
  `total_ht` double(24,8) DEFAULT NULL,
  `subprice` double(24,8) DEFAULT NULL,
  `fk_parent_line` int DEFAULT NULL,
  `fk_product` int DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `tva_tx` double(6,3) DEFAULT NULL,
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(1) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(1) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `remise_percent` double DEFAULT '0',
  `fk_remise_except` int DEFAULT NULL,
  `price` double(24,8) DEFAULT NULL,
  `total_tva` double(24,8) DEFAULT NULL,
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT NULL,
  `product_type` int DEFAULT '0',
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `info_bits` int DEFAULT '0',
  `buy_price_ht` double(24,8) DEFAULT '0.00000000',
  `fk_product_fournisseur_price` int DEFAULT NULL,
  `fk_code_ventilation` int NOT NULL DEFAULT '0',
  `special_code` int unsigned DEFAULT '0',
  `fk_unit` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_holiday`;
CREATE TABLE `llx_holiday` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `fk_user` int NOT NULL,
  `fk_user_create` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_type` int NOT NULL,
  `date_create` datetime NOT NULL,
  `description` varchar(255) NOT NULL,
  `date_debut` date NOT NULL,
  `date_fin` date NOT NULL,
  `halfday` int DEFAULT '0',
  `statut` int NOT NULL DEFAULT '1',
  `fk_validator` int NOT NULL,
  `date_valid` datetime DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `date_refuse` datetime DEFAULT NULL,
  `fk_user_refuse` int DEFAULT NULL,
  `date_cancel` datetime DEFAULT NULL,
  `fk_user_cancel` int DEFAULT NULL,
  `detail_refuse` varchar(250) DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `tms` timestamp NULL DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `date_approval` datetime DEFAULT NULL,
  `fk_user_approve` int DEFAULT NULL,
  `nb_open_day` double(24,8) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_holiday_entity` (`entity`),
  KEY `idx_holiday_fk_user` (`fk_user`),
  KEY `idx_holiday_fk_user_create` (`fk_user_create`),
  KEY `idx_holiday_date_create` (`date_create`),
  KEY `idx_holiday_date_debut` (`date_debut`),
  KEY `idx_holiday_date_fin` (`date_fin`),
  KEY `idx_holiday_fk_validator` (`fk_validator`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_holiday_config`;
CREATE TABLE `llx_holiday_config` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `value` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_holiday_config` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `llx_holiday_config` VALUES("1","lastUpdate",NULL);



DROP TABLE IF EXISTS `llx_holiday_extrafields`;
CREATE TABLE `llx_holiday_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_holiday_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_holiday_logs`;
CREATE TABLE `llx_holiday_logs` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `date_action` datetime NOT NULL,
  `fk_user_action` int NOT NULL,
  `fk_user_update` int NOT NULL,
  `fk_type` int NOT NULL,
  `type_action` varchar(255) NOT NULL,
  `prev_solde` varchar(255) NOT NULL,
  `new_solde` varchar(255) NOT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_holiday_users`;
CREATE TABLE `llx_holiday_users` (
  `fk_user` int NOT NULL,
  `fk_type` int NOT NULL,
  `nb_holiday` double NOT NULL DEFAULT '0',
  UNIQUE KEY `uk_holiday_users` (`fk_user`,`fk_type`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_hrm_evaluation`;
CREATE TABLE `llx_hrm_evaluation` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(128) NOT NULL DEFAULT '(PROV)',
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `note_public` text,
  `note_private` text,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `status` smallint NOT NULL,
  `date_eval` date DEFAULT NULL,
  `fk_user` int NOT NULL,
  `fk_job` int NOT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_hrm_evaluation_rowid` (`rowid`),
  KEY `idx_hrm_evaluation_ref` (`ref`),
  KEY `llx_hrm_evaluation_fk_user_creat` (`fk_user_creat`),
  KEY `idx_hrm_evaluation_status` (`status`),
  CONSTRAINT `llx_hrm_evaluation_fk_user_creat` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_hrm_evaluation_extrafields`;
CREATE TABLE `llx_hrm_evaluation_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_evaluation_fk_object` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_hrm_evaluationdet`;
CREATE TABLE `llx_hrm_evaluationdet` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_skill` int NOT NULL,
  `fk_evaluation` int NOT NULL,
  `rankorder` int NOT NULL,
  `required_rank` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `comment` text,
  PRIMARY KEY (`rowid`),
  KEY `idx_hrm_evaluationdet_rowid` (`rowid`),
  KEY `llx_hrm_evaluationdet_fk_user_creat` (`fk_user_creat`),
  KEY `idx_hrm_evaluationdet_fk_skill` (`fk_skill`),
  KEY `idx_hrm_evaluationdet_fk_evaluation` (`fk_evaluation`),
  CONSTRAINT `llx_hrm_evaluationdet_fk_user_creat` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_hrm_evaluationdet_extrafields`;
CREATE TABLE `llx_hrm_evaluationdet_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_evaluationdet_fk_object` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_hrm_job`;
CREATE TABLE `llx_hrm_job` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `label` varchar(255) NOT NULL,
  `description` text,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deplacement` varchar(255) DEFAULT NULL,
  `note_public` text,
  `note_private` text,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_hrm_job_rowid` (`rowid`),
  KEY `idx_hrm_job_label` (`label`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_hrm_job_extrafields`;
CREATE TABLE `llx_hrm_job_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_job_fk_object` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_hrm_job_user`;
CREATE TABLE `llx_hrm_job_user` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `description` text,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_contrat` int DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `fk_job` int NOT NULL,
  `date_start` date DEFAULT NULL,
  `date_end` date DEFAULT NULL,
  `abort_comment` varchar(255) DEFAULT NULL,
  `note_public` text,
  `note_private` text,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_hrm_job_user_rowid` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_hrm_skill`;
CREATE TABLE `llx_hrm_skill` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `required_level` int NOT NULL,
  `date_validite` int NOT NULL,
  `temps_theorique` double(24,8) NOT NULL,
  `skill_type` int NOT NULL,
  `note_public` text,
  `note_private` text,
  PRIMARY KEY (`rowid`),
  KEY `idx_hrm_skill_rowid` (`rowid`),
  KEY `llx_hrm_skill_fk_user_creat` (`fk_user_creat`),
  KEY `idx_hrm_skill_skill_type` (`skill_type`),
  CONSTRAINT `llx_hrm_skill_fk_user_creat` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_hrm_skill_extrafields`;
CREATE TABLE `llx_hrm_skill_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_skill_fk_object` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_hrm_skilldet`;
CREATE TABLE `llx_hrm_skilldet` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `description` text,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_skill` int NOT NULL,
  `rankorder` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_hrm_skilldet_rowid` (`rowid`),
  KEY `llx_hrm_skilldet_fk_user_creat` (`fk_user_creat`),
  CONSTRAINT `llx_hrm_skilldet_fk_user_creat` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_hrm_skillrank`;
CREATE TABLE `llx_hrm_skillrank` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_skill` int NOT NULL,
  `rankorder` int NOT NULL,
  `fk_object` int NOT NULL,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `objecttype` varchar(128) NOT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_hrm_skillrank_rowid` (`rowid`),
  KEY `idx_hrm_skillrank_fk_skill` (`fk_skill`),
  KEY `llx_hrm_skillrank_fk_user_creat` (`fk_user_creat`),
  CONSTRAINT `llx_hrm_skillrank_fk_user_creat` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_import_model`;
CREATE TABLE `llx_import_model` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_user` int NOT NULL DEFAULT '0',
  `label` varchar(50) NOT NULL,
  `type` varchar(64) DEFAULT NULL,
  `field` text NOT NULL,
  `entity` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_import_model` (`label`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_intracommreport`;
CREATE TABLE `llx_intracommreport` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `type_declaration` varchar(32) DEFAULT NULL,
  `periods` varchar(32) DEFAULT NULL,
  `mode` varchar(32) DEFAULT NULL,
  `content_xml` text,
  `type_export` varchar(10) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_inventory`;
CREATE TABLE `llx_inventory` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int DEFAULT '0',
  `ref` varchar(48) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `fk_warehouse` int DEFAULT NULL,
  `fk_product` int DEFAULT NULL,
  `categories_product` varchar(255) DEFAULT NULL,
  `status` int DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `date_inventory` datetime DEFAULT NULL,
  `date_validation` datetime DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_inventory_ref` (`ref`,`entity`),
  KEY `idx_inventory_tms` (`tms`),
  KEY `idx_inventory_date_creation` (`date_creation`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_inventory_extrafields`;
CREATE TABLE `llx_inventory_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_inventory_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_inventorydet`;
CREATE TABLE `llx_inventorydet` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_inventory` int DEFAULT '0',
  `fk_warehouse` int DEFAULT '0',
  `fk_product` int DEFAULT '0',
  `batch` varchar(30) DEFAULT NULL,
  `qty_view` double DEFAULT NULL,
  `qty_stock` double DEFAULT NULL,
  `qty_regulated` double DEFAULT NULL,
  `fk_movement` int DEFAULT NULL,
  `pmp_real` double DEFAULT NULL,
  `pmp_expected` double DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_inventorydet` (`fk_inventory`,`fk_warehouse`,`fk_product`,`batch`),
  KEY `idx_inventorydet_tms` (`tms`),
  KEY `idx_inventorydet_datec` (`datec`),
  KEY `idx_inventorydet_fk_inventory` (`fk_inventory`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_knowledgemanagement_knowledgerecord`;
CREATE TABLE `llx_knowledgemanagement_knowledgerecord` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(128) NOT NULL,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `question` text NOT NULL,
  `answer` text,
  `url` varchar(255) DEFAULT NULL,
  `fk_ticket` int DEFAULT NULL,
  `fk_c_ticket_category` int DEFAULT NULL,
  `status` int NOT NULL,
  `lang` varchar(6) DEFAULT NULL,
  `entity` int DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_knowledgemanagement_knowledgerecord_extrafields`;
CREATE TABLE `llx_knowledgemanagement_knowledgerecord_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_links`;
CREATE TABLE `llx_links` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `datea` datetime NOT NULL,
  `url` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `objecttype` varchar(255) NOT NULL,
  `objectid` int NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_links` (`objectid`,`objecttype`,`label`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_loan`;
CREATE TABLE `llx_loan` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `label` varchar(80) NOT NULL,
  `fk_bank` int DEFAULT NULL,
  `capital` double(24,8) NOT NULL DEFAULT '0.00000000',
  `datestart` date DEFAULT NULL,
  `dateend` date DEFAULT NULL,
  `nbterm` double DEFAULT NULL,
  `rate` double NOT NULL,
  `note_private` text,
  `note_public` text,
  `capital_position` double(24,8) DEFAULT '0.00000000',
  `date_position` date DEFAULT NULL,
  `paid` smallint NOT NULL DEFAULT '0',
  `accountancy_account_capital` varchar(32) DEFAULT NULL,
  `accountancy_account_insurance` varchar(32) DEFAULT NULL,
  `accountancy_account_interest` varchar(32) DEFAULT NULL,
  `fk_projet` int DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `active` tinyint NOT NULL DEFAULT '1',
  `insurance_amount` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_loan_schedule`;
CREATE TABLE `llx_loan_schedule` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_loan` int DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datep` datetime DEFAULT NULL,
  `amount_capital` double(24,8) DEFAULT '0.00000000',
  `amount_insurance` double(24,8) DEFAULT '0.00000000',
  `amount_interest` double(24,8) DEFAULT '0.00000000',
  `fk_typepayment` int NOT NULL,
  `num_payment` varchar(50) DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `fk_bank` int NOT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_payment_loan` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_loan_schedule_ref` (`fk_loan`,`datep`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_localtax`;
CREATE TABLE `llx_localtax` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `localtaxtype` tinyint DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datep` date DEFAULT NULL,
  `datev` date DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `note` text,
  `fk_bank` int DEFAULT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_mailing`;
CREATE TABLE `llx_mailing` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `statut` smallint DEFAULT '0',
  `titre` varchar(128) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `sujet` varchar(128) DEFAULT NULL,
  `body` mediumtext,
  `bgcolor` varchar(8) DEFAULT NULL,
  `bgimage` varchar(255) DEFAULT NULL,
  `cible` varchar(60) DEFAULT NULL,
  `nbemail` int DEFAULT NULL,
  `email_from` varchar(160) DEFAULT NULL,
  `name_from` varchar(128) DEFAULT NULL,
  `email_replyto` varchar(160) DEFAULT NULL,
  `email_errorsto` varchar(160) DEFAULT NULL,
  `tag` varchar(128) DEFAULT NULL,
  `date_creat` datetime DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `date_appro` datetime DEFAULT NULL,
  `date_envoi` datetime DEFAULT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `fk_user_appro` int DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `joined_file1` varchar(255) DEFAULT NULL,
  `joined_file2` varchar(255) DEFAULT NULL,
  `joined_file3` varchar(255) DEFAULT NULL,
  `joined_file4` varchar(255) DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `evenunsubscribe` smallint DEFAULT '0',
  `note_private` text,
  `note_public` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_mailing` (`titre`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_mailing_advtarget`;
CREATE TABLE `llx_mailing_advtarget` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `name` varchar(180) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `fk_element` int NOT NULL,
  `type_element` varchar(180) NOT NULL,
  `filtervalue` text,
  `fk_user_author` int NOT NULL,
  `datec` datetime NOT NULL,
  `fk_user_mod` int NOT NULL,
  `tms` timestamp NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_advtargetemailing_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_mailing_cibles`;
CREATE TABLE `llx_mailing_cibles` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_mailing` int NOT NULL,
  `fk_contact` int NOT NULL,
  `lastname` varchar(160) DEFAULT NULL,
  `firstname` varchar(160) DEFAULT NULL,
  `email` varchar(160) NOT NULL,
  `other` varchar(255) DEFAULT NULL,
  `tag` varchar(64) DEFAULT NULL,
  `statut` smallint NOT NULL DEFAULT '0',
  `source_url` varchar(255) DEFAULT NULL,
  `source_id` int DEFAULT NULL,
  `source_type` varchar(32) DEFAULT NULL,
  `date_envoi` datetime DEFAULT NULL,
  `error_text` varchar(255) DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_mailing_cibles` (`fk_mailing`,`email`),
  KEY `idx_mailing_cibles_email` (`email`),
  KEY `idx_mailing_cibles_tag` (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_mailing_unsubscribe`;
CREATE TABLE `llx_mailing_unsubscribe` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `email` varchar(255) DEFAULT NULL,
  `unsubscribegroup` varchar(128) DEFAULT '',
  `ip` varchar(128) DEFAULT NULL,
  `date_creat` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_mailing_unsubscribe` (`email`,`entity`,`unsubscribegroup`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_menu`;
CREATE TABLE `llx_menu` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `menu_handler` varchar(16) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `module` varchar(255) DEFAULT NULL,
  `type` varchar(4) NOT NULL,
  `mainmenu` varchar(100) NOT NULL,
  `leftmenu` varchar(100) DEFAULT NULL,
  `fk_menu` int NOT NULL,
  `fk_mainmenu` varchar(100) DEFAULT NULL,
  `fk_leftmenu` varchar(100) DEFAULT NULL,
  `position` int NOT NULL,
  `url` varchar(255) NOT NULL,
  `target` varchar(100) DEFAULT NULL,
  `titre` varchar(255) NOT NULL,
  `prefix` varchar(255) DEFAULT NULL,
  `langs` varchar(100) DEFAULT NULL,
  `level` smallint DEFAULT NULL,
  `perms` text,
  `enabled` text,
  `usertype` int NOT NULL DEFAULT '0',
  `tms` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_menu_uk_menu` (`menu_handler`,`fk_menu`,`position`,`url`,`entity`),
  KEY `idx_menu_menuhandler_type` (`menu_handler`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

INSERT INTO `llx_menu` VALUES("5","all","1","paypal","left","billing","customers_bills_payment_paypal","-1","billing","customers_bills_payment","501","/paypal/importpayments.php","","PaypalImportPayment",NULL,"paypal",NULL,"$user->rights->banque->consolidate","$conf->paypal->enabled && $conf->banque->enabled && $conf->global->MAIN_FEATURES_LEVEL >= 2","2",NULL);
INSERT INTO `llx_menu` VALUES("6","all","1","ecm","top","ecm",NULL,"0",NULL,NULL,"82","/ecm/index.php","","MenuECM","<span class=\"fas fa-folder-open pictofixedwidth\" style=\"\"></span>","ecm",NULL,"$user->rights->ecm->read || $user->rights->ecm->upload || $user->rights->ecm->setup","isModEnabled(\"ecm\")","2",NULL);
INSERT INTO `llx_menu` VALUES("7","all","1","ecm","left","ecm","ecm","-1","ecm",NULL,"101","/ecm/index.php?mainmenu=ecm&leftmenu=ecm","","ECMArea","<span class=\"fas fa-folder-open paddingright pictofixedwidth\" style=\"\"></span>","ecm",NULL,"$user->rights->ecm->read || $user->rights->ecm->upload","$user->rights->ecm->read || $user->rights->ecm->upload","2",NULL);
INSERT INTO `llx_menu` VALUES("8","all","1","ecm","left","ecm","ecm_manual","-1","ecm","ecm","102","/ecm/index.php?action=file_manager&mainmenu=ecm&leftmenu=ecm","","ECMSectionsManual","","ecm",NULL,"$user->rights->ecm->read || $user->rights->ecm->upload","$user->rights->ecm->read || $user->rights->ecm->upload","2",NULL);
INSERT INTO `llx_menu` VALUES("9","all","1","ecm","left","ecm",NULL,"-1","ecm","ecm","103","/ecm/index_auto.php?action=file_manager&mainmenu=ecm&leftmenu=ecm","","ECMSectionsAuto","","ecm",NULL,"$user->rights->ecm->read || $user->rights->ecm->upload","($user->rights->ecm->read || $user->rights->ecm->upload) && !getDolGlobalInt(\"ECM_AUTO_TREE_HIDEN\")","2",NULL);
INSERT INTO `llx_menu` VALUES("10","all","1","ecm","left","ecm",NULL,"-1","ecm","ecm","104","/ecm/index_medias.php?action=file_manager&mainmenu=ecm&leftmenu=ecm","","ECMSectionsMedias","","ecm",NULL,"$user->rights->ecm->read || $user->rights->ecm->upload","($user->rights->ecm->read || $user->rights->ecm->upload) && getDolGlobalInt(\"MAIN_FEATURES_LEVEL\") == 2","2",NULL);



DROP TABLE IF EXISTS `llx_mrp_mo`;
CREATE TABLE `llx_mrp_mo` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(128) NOT NULL DEFAULT '(PROV)',
  `entity` int NOT NULL DEFAULT '1',
  `label` varchar(255) DEFAULT NULL,
  `qty` double NOT NULL,
  `fk_warehouse` int DEFAULT NULL,
  `fk_soc` int DEFAULT NULL,
  `note_public` text,
  `note_private` text,
  `date_creation` datetime NOT NULL,
  `date_valid` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `status` int NOT NULL,
  `fk_product` int NOT NULL,
  `date_start_planned` datetime DEFAULT NULL,
  `date_end_planned` datetime DEFAULT NULL,
  `fk_bom` int DEFAULT NULL,
  `fk_project` int DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `mrptype` int DEFAULT '0',
  `fk_parent_line` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_mrp_mo_ref` (`ref`),
  KEY `idx_mrp_mo_entity` (`entity`),
  KEY `idx_mrp_mo_fk_soc` (`fk_soc`),
  KEY `fk_mrp_mo_fk_user_creat` (`fk_user_creat`),
  KEY `idx_mrp_mo_status` (`status`),
  KEY `idx_mrp_mo_fk_product` (`fk_product`),
  KEY `idx_mrp_mo_date_start_planned` (`date_start_planned`),
  KEY `idx_mrp_mo_date_end_planned` (`date_end_planned`),
  KEY `idx_mrp_mo_fk_bom` (`fk_bom`),
  KEY `idx_mrp_mo_fk_project` (`fk_project`),
  CONSTRAINT `fk_mrp_mo_fk_user_creat` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_mrp_mo_extrafields`;
CREATE TABLE `llx_mrp_mo_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_mrp_mo_fk_object` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_mrp_production`;
CREATE TABLE `llx_mrp_production` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_mo` int NOT NULL,
  `origin_id` int DEFAULT NULL,
  `origin_type` varchar(10) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '0',
  `fk_product` int NOT NULL,
  `fk_warehouse` int DEFAULT NULL,
  `qty` double NOT NULL DEFAULT '1',
  `qty_frozen` smallint DEFAULT '0',
  `disable_stock_change` smallint DEFAULT '0',
  `batch` varchar(128) DEFAULT NULL,
  `role` varchar(10) DEFAULT NULL,
  `fk_mrp_production` int DEFAULT NULL,
  `fk_stock_movement` int DEFAULT NULL,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `fk_default_workstation` int DEFAULT NULL,
  `fk_unit` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `fk_mrp_production_product` (`fk_product`),
  KEY `fk_mrp_production_stock_movement` (`fk_stock_movement`),
  KEY `idx_mrp_production_fk_mo` (`fk_mo`),
  CONSTRAINT `fk_mrp_production_mo` FOREIGN KEY (`fk_mo`) REFERENCES `llx_mrp_mo` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_mrp_production_product` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_mrp_production_stock_movement` FOREIGN KEY (`fk_stock_movement`) REFERENCES `llx_stock_mouvement` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_mrp_production_extrafields`;
CREATE TABLE `llx_mrp_production_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_mrp_production_fk_object` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_multicurrency`;
CREATE TABLE `llx_multicurrency` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `date_create` datetime DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `entity` int DEFAULT '1',
  `fk_user` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_multicurrency_rate`;
CREATE TABLE `llx_multicurrency_rate` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `date_sync` datetime DEFAULT NULL,
  `rate` double NOT NULL DEFAULT '0',
  `fk_multicurrency` int NOT NULL,
  `entity` int DEFAULT '1',
  `rate_indirect` double DEFAULT '0',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_notify`;
CREATE TABLE `llx_notify` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `daten` datetime DEFAULT NULL,
  `fk_action` int NOT NULL,
  `fk_soc` int DEFAULT NULL,
  `fk_contact` int DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `type` varchar(16) DEFAULT 'email',
  `type_target` varchar(16) DEFAULT NULL,
  `objet_type` varchar(24) NOT NULL,
  `objet_id` int NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=latin1;

INSERT INTO `llx_notify` VALUES("1",NULL,"2023-06-02 17:31:03","13","4",NULL,"1","email","touserid","facture","70","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("2",NULL,"2023-06-05 20:02:01","13","16",NULL,"1","email","touserid","facture","71","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("3",NULL,"2023-08-10 18:33:13","13","16",NULL,"1","email","touserid","facture","72","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("4",NULL,"2023-09-05 18:13:54","13","11",NULL,"1","email","touserid","facture","73","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("5",NULL,"2023-09-11 11:05:43","13","4",NULL,"1","email","touserid","facture","74","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("6",NULL,"2023-09-18 18:05:41","3","23",NULL,"1","email","touserid","propal","17","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("7",NULL,"2023-11-13 18:58:10","13","23",NULL,"1","email","touserid","facture","75","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("8",NULL,"2023-12-13 19:51:03","13","16",NULL,"1","email","touserid","facture","76","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("9",NULL,"2024-02-02 09:28:50","13","24",NULL,"1","email","touserid","facture","77","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("10",NULL,"2024-04-10 19:10:32","3","16",NULL,"1","email","touserid","propal","19","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("11",NULL,"2024-04-11 15:13:19","13","16",NULL,"1","email","touserid","facture","78","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("12",NULL,"2024-08-09 17:06:35","3","25",NULL,"1","email","touserid","propal","20","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("13",NULL,"2024-08-09 17:11:57","13","25",NULL,"1","email","touserid","facture","79","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("14",NULL,"2024-08-10 11:57:08","13","25",NULL,"1","email","touserid","facture","79","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("15",NULL,"2024-09-21 19:16:03","3","16",NULL,"1","email","touserid","propal","21","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("16",NULL,"2024-10-05 10:28:19","13","16",NULL,"1","email","touserid","facture","80","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("17",NULL,"2024-10-05 10:48:09","3","4",NULL,"1","email","touserid","propal","22","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("18",NULL,"2024-10-05 10:48:45","13","4",NULL,"1","email","touserid","facture","81","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("19",NULL,"2024-10-06 19:41:12","13","11",NULL,"1","email","touserid","facture","82","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("20",NULL,"2024-10-11 20:30:32","3","10",NULL,"1","email","touserid","propal","23","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("21",NULL,"2024-10-12 17:35:20","13","10",NULL,"1","email","touserid","facture","83","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("22",NULL,"2024-11-15 11:23:26","13","11",NULL,"1","email","touserid","facture","84","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("23",NULL,"2024-12-03 17:45:48","13","4",NULL,"1","email","touserid","facture","81","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("24",NULL,"2024-12-09 18:52:39","3","24",NULL,"1","email","touserid","propal","27","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("25",NULL,"2024-12-10 10:39:33","13","24",NULL,"1","email","touserid","facture","86","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("26",NULL,"2024-12-20 15:58:39","3","24",NULL,"1","email","touserid","propal","28","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("27",NULL,"2025-03-04 19:42:59","3","26",NULL,"1","email","touserid","propal","31","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("28",NULL,"2025-03-04 19:56:35","3","26",NULL,"1","email","touserid","propal","31","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("29",NULL,"2025-03-31 08:14:45","3","16",NULL,"1","email","touserid","propal","32","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("30",NULL,"2025-04-10 20:10:57","13","16",NULL,"1","email","touserid","facture","88","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("31",NULL,"2025-06-11 19:43:17","3","4",NULL,"1","email","touserid","propal","33","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("32",NULL,"2025-06-11 19:47:07","3","4",NULL,"1","email","touserid","propal","33","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("33",NULL,"2025-06-16 11:32:43","13","10",NULL,"1","email","touserid","facture","85","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("34",NULL,"2025-06-24 19:36:27","3","27",NULL,"1","email","touserid","propal","35","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("35",NULL,"2025-07-04 10:48:37","3","28",NULL,"1","email","touserid","propal","37","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("36",NULL,"2025-07-23 19:50:33","3","28",NULL,"1","email","touserid","propal","37","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("37",NULL,"2025-08-05 10:43:28","3","11",NULL,"1","email","touserid","propal","38","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("38",NULL,"2025-09-02 16:32:39","13","28",NULL,"1","email","touserid","facture","91","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("39",NULL,"2025-09-27 14:31:56","13","28",NULL,"1","email","touserid","facture","91","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("40",NULL,"2025-11-27 11:11:46","3","30",NULL,"1","email","touserid","propal","40","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("41",NULL,"2025-12-01 19:44:23","13","11",NULL,"1","email","touserid","facture","92","contact@pixelorigin.com");
INSERT INTO `llx_notify` VALUES("42",NULL,"2025-12-11 23:37:50","3","16",NULL,"1","email","touserid","propal","41","contact@pixelorigin.com");



DROP TABLE IF EXISTS `llx_notify_def`;
CREATE TABLE `llx_notify_def` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `datec` date DEFAULT NULL,
  `fk_action` int NOT NULL,
  `fk_soc` int DEFAULT NULL,
  `fk_contact` int DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `type` varchar(16) DEFAULT 'email',
  `email` varchar(255) DEFAULT NULL,
  `threshold` double(24,8) DEFAULT NULL,
  `context` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `llx_notify_def` VALUES("1",NULL,"2023-05-31","3",NULL,NULL,"1","email",NULL,NULL,NULL);
INSERT INTO `llx_notify_def` VALUES("2",NULL,"2023-05-31","13",NULL,NULL,"1","email",NULL,NULL,NULL);



DROP TABLE IF EXISTS `llx_notify_def_object`;
CREATE TABLE `llx_notify_def_object` (
  `id` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `objet_type` varchar(16) DEFAULT NULL,
  `objet_id` int NOT NULL,
  `type_notif` varchar(16) DEFAULT 'browser',
  `date_notif` datetime DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `moreparam` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_oauth_state`;
CREATE TABLE `llx_oauth_state` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `service` varchar(36) DEFAULT NULL,
  `state` varchar(128) DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `fk_adherent` int DEFAULT NULL,
  `entity` int DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_oauth_token`;
CREATE TABLE `llx_oauth_token` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `service` varchar(36) DEFAULT NULL,
  `token` text,
  `fk_soc` int DEFAULT NULL,
  `tokenstring` text,
  `state` text,
  `fk_user` int DEFAULT NULL,
  `fk_adherent` int DEFAULT NULL,
  `entity` int DEFAULT '1',
  `restricted_ips` varchar(200) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_object_lang`;
CREATE TABLE `llx_object_lang` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_object` int NOT NULL DEFAULT '0',
  `type_object` varchar(32) NOT NULL,
  `property` varchar(32) NOT NULL,
  `lang` varchar(5) NOT NULL DEFAULT '0',
  `value` text,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_object_lang` (`fk_object`,`type_object`,`property`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_onlinesignature`;
CREATE TABLE `llx_onlinesignature` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `object_type` varchar(32) NOT NULL,
  `object_id` int NOT NULL,
  `datec` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `ip` varchar(128) DEFAULT NULL,
  `pathoffile` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_opensurvey_comments`;
CREATE TABLE `llx_opensurvey_comments` (
  `id_comment` int unsigned NOT NULL AUTO_INCREMENT,
  `id_sondage` char(16) NOT NULL,
  `comment` text NOT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `usercomment` text,
  `ip` varchar(250) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  PRIMARY KEY (`id_comment`),
  KEY `idx_id_comment` (`id_comment`),
  KEY `idx_id_sondage` (`id_sondage`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_opensurvey_formquestions`;
CREATE TABLE `llx_opensurvey_formquestions` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `id_sondage` varchar(16) DEFAULT NULL,
  `question` text,
  `available_answers` text,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_opensurvey_sondage`;
CREATE TABLE `llx_opensurvey_sondage` (
  `id_sondage` varchar(16) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `commentaires` text,
  `mail_admin` varchar(128) DEFAULT NULL,
  `nom_admin` varchar(64) DEFAULT NULL,
  `fk_user_creat` int NOT NULL,
  `titre` text NOT NULL,
  `date_fin` datetime DEFAULT NULL,
  `status` int DEFAULT '1',
  `format` varchar(2) NOT NULL,
  `mailsonde` tinyint NOT NULL DEFAULT '0',
  `allow_comments` tinyint NOT NULL DEFAULT '1',
  `allow_spy` tinyint NOT NULL DEFAULT '1',
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `sujet` text,
  PRIMARY KEY (`id_sondage`),
  KEY `idx_date_fin` (`date_fin`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_opensurvey_user_formanswers`;
CREATE TABLE `llx_opensurvey_user_formanswers` (
  `fk_user_survey` int NOT NULL,
  `fk_question` int NOT NULL,
  `reponses` text
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_opensurvey_user_studs`;
CREATE TABLE `llx_opensurvey_user_studs` (
  `id_users` int NOT NULL AUTO_INCREMENT,
  `nom` varchar(64) NOT NULL,
  `id_sondage` varchar(16) NOT NULL,
  `reponses` varchar(200) NOT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `ip` varchar(250) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  PRIMARY KEY (`id_users`),
  KEY `idx_opensurvey_user_studs_id_users` (`id_users`),
  KEY `idx_opensurvey_user_studs_nom` (`nom`),
  KEY `idx_opensurvey_user_studs_id_sondage` (`id_sondage`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_overwrite_trans`;
CREATE TABLE `llx_overwrite_trans` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `lang` varchar(5) DEFAULT NULL,
  `transkey` varchar(128) DEFAULT NULL,
  `transvalue` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_overwrite_trans` (`entity`,`lang`,`transkey`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_paiement`;
CREATE TABLE `llx_paiement` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datep` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `multicurrency_amount` double(24,8) DEFAULT '0.00000000',
  `fk_paiement` int NOT NULL,
  `num_paiement` varchar(50) DEFAULT NULL,
  `note` text,
  `fk_bank` int NOT NULL DEFAULT '0',
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `statut` smallint NOT NULL DEFAULT '0',
  `fk_export_compta` int NOT NULL DEFAULT '0',
  `pos_change` double(24,8) DEFAULT '0.00000000',
  `ext_payment_id` varchar(255) DEFAULT NULL,
  `ext_payment_site` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=latin1;

INSERT INTO `llx_paiement` VALUES("1","PAY1810-0001",NULL,"1","2018-11-26 14:17:24",NULL,"2018-10-31 12:00:00","527.99000000","527.99000000","2","","","0","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("2","PAY1904-0002",NULL,"1","2019-04-12 14:59:18",NULL,"2019-04-12 12:00:00","400.00000000","400.00000000","54","","","2","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("3","PAY1904-0003",NULL,"1","2019-05-15 08:55:32",NULL,"2019-04-01 12:00:00","800.00000000","800.00000000","2","","","3","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("4","PAY1908-0004",NULL,"1","2019-08-08 16:51:52",NULL,"2019-08-08 12:00:00","400.00000000","400.00000000","2","","","4","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("5","PAY1911-0005",NULL,"1","2019-12-05 19:55:35",NULL,"2019-11-06 12:00:00","200.00000000","200.00000000","2","","","5","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("6","PAY2002-0006",NULL,"1","2020-03-06 14:00:58",NULL,"2020-02-04 12:00:00","200.00000000","200.00000000","2","","","6","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("7","PAY2002-0007",NULL,"1","2020-06-10 12:26:21",NULL,"2020-02-10 12:00:00","1250.00000000","1250.00000000","7","","","7","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("8","PAY2005-0008",NULL,"1","2020-07-09 12:04:38",NULL,"2020-05-31 12:00:00","1800.00000000","1800.00000000","2","","","8","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("9","PAY2006-0009",NULL,"1","2020-07-09 12:08:11",NULL,"2020-06-11 12:00:00","127.99000000","127.99000000","2","","","9","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("10","PAY2008-0010",NULL,"1","2020-10-19 10:30:56",NULL,"2020-08-22 12:00:00","850.00000000","850.00000000","7","","","10","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("11","PAY2007-0011",NULL,"1","2021-05-19 10:04:45",NULL,"2020-07-29 12:00:00","500.00000000","500.00000000","7","","","11","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("12","PAY2009-0012",NULL,"1","2021-05-19 10:05:40",NULL,"2020-09-21 12:00:00","300.00000000","300.00000000","7","","","12","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("13","PAY2012-0013",NULL,"1","2021-05-19 10:06:15",NULL,"2020-12-30 12:00:00","1000.00000000","1000.00000000","7","","","13","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("14","PAY2104-0014",NULL,"1","2021-08-08 08:47:34",NULL,"2021-04-20 12:00:00","1970.00000000","1970.00000000","2","","","14","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("15","PAY2103-0015",NULL,"1","2021-08-08 08:48:08",NULL,"2021-03-21 12:00:00","1275.00000000","1275.00000000","7","","","15","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("16","PAY2105-0016",NULL,"1","2021-08-08 08:48:51",NULL,"2021-05-04 12:00:00","200.00000000","200.00000000","7","","","16","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("17","PAY2108-0017",NULL,"1","2021-08-08 08:50:24",NULL,"2021-08-08 12:00:00","850.00000000","850.00000000","7","","","17","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("18","PAY2009-0018",NULL,"1","2021-08-08 08:51:16",NULL,"2020-09-30 12:00:00","200.00000000","200.00000000","2","","","18","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("19","PAY2206-0019",NULL,"1","2022-06-13 11:13:36",NULL,"2022-06-10 12:00:00","130.00000000","130.00000000","54","","","20","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("20","PAY2210-0020",NULL,"1","2022-10-27 17:13:44",NULL,"2022-10-27 12:00:00","1100.00000000","1100.00000000","7","","","21","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("21","PAY2211-0021",NULL,"1","2023-05-31 00:20:49",NULL,"2022-11-25 12:00:00","716.99000000","716.99000000","7","","","22","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("22","PAY2209-0022",NULL,"1","2023-05-31 00:23:09",NULL,"2022-09-08 12:00:00","800.00000000","800.00000000","54","","","23","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("23","PAY2309-0023",NULL,"1","2023-09-11 11:03:13",NULL,"2023-09-08 12:00:00","30.00000000","30.00000000","7","","","24","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("24","PAY2306-0024",NULL,"1","2023-10-03 11:46:18",NULL,"2023-06-02 12:00:00","800.00000000","800.00000000","54","","","25","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("25","PAY2309-0025",NULL,"1","2023-12-13 11:22:51",NULL,"2023-09-18 12:00:00","400.00000000","400.00000000","55","","","26","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("26","PAY2311-0026",NULL,"1","2023-12-13 11:23:43",NULL,"2023-11-13 12:00:00","400.00000000","400.00000000","55","","","27","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("27","PAY2012-0027",NULL,"1","2023-12-13 11:26:44",NULL,"2020-12-02 12:00:00","250.00000000","250.00000000","2","","","28","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("28","PAY2401-0028","","1","2024-03-23 21:20:56",NULL,"2024-01-01 12:00:00","300.00000000","300.00000000","7","","","29","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("29","PAY2109-0029","","1","2024-03-23 21:26:17",NULL,"2021-09-20 12:00:00","2980.00000000","2980.00000000","7","","","30","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("30","PAY2410-0030","","1","2024-10-11 18:31:55",NULL,"2024-10-11 12:00:00","50.00000000","50.00000000","7","","","31","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("31","PAY2411-0031","","1","2024-11-20 15:52:44",NULL,"2024-11-14 12:00:00","64.00000000","64.00000000","2","","","32","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("32","PAY2411-0032","","1","2024-11-20 15:56:02",NULL,"2024-11-15 12:00:00","50.00000000","50.00000000","2","","","33","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("33","PAY2206-0033","","1","2024-11-20 15:57:41",NULL,"2022-06-13 12:00:00","60.00000000","60.00000000","2","","","34","1",NULL,"0","0","0.00000000",NULL,NULL);
INSERT INTO `llx_paiement` VALUES("34","PAY2412-0034","","1","2024-12-03 17:46:25",NULL,"2024-12-03 12:00:00","100.00000000","100.00000000","2","","","35","1",NULL,"0","0","0.00000000",NULL,NULL);



DROP TABLE IF EXISTS `llx_paiement_facture`;
CREATE TABLE `llx_paiement_facture` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_paiement` int DEFAULT NULL,
  `fk_facture` int DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_amount` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_paiement_facture` (`fk_paiement`,`fk_facture`),
  KEY `idx_paiement_facture_fk_facture` (`fk_facture`),
  KEY `idx_paiement_facture_fk_paiement` (`fk_paiement`),
  CONSTRAINT `fk_paiement_facture_fk_facture` FOREIGN KEY (`fk_facture`) REFERENCES `llx_facture` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_paiement_facture_fk_paiement` FOREIGN KEY (`fk_paiement`) REFERENCES `llx_paiement` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=latin1;

INSERT INTO `llx_paiement_facture` VALUES("1","1","2","527.99000000",NULL,"1.00000000","527.99000000");
INSERT INTO `llx_paiement_facture` VALUES("2","2","1","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("3","2","3","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("4","3","5","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("5","3","6","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("6","3","7","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("7","3","8","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("8","4","10","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("9","4","11","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("10","5","15","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("11","6","22","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("12","7","23","1250.00000000",NULL,"1.00000000","1250.00000000");
INSERT INTO `llx_paiement_facture` VALUES("13","8","12","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("14","8","13","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("15","8","14","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("16","8","16","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("17","8","17","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("18","8","20","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("19","8","26","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("20","8","27","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("21","8","28","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("22","9","25","127.99000000",NULL,"1.00000000","127.99000000");
INSERT INTO `llx_paiement_facture` VALUES("23","10","32","850.00000000",NULL,"1.00000000","850.00000000");
INSERT INTO `llx_paiement_facture` VALUES("24","11","30","500.00000000",NULL,"1.00000000","500.00000000");
INSERT INTO `llx_paiement_facture` VALUES("25","12","33","300.00000000",NULL,"1.00000000","300.00000000");
INSERT INTO `llx_paiement_facture` VALUES("26","13","41","1000.00000000",NULL,"1.00000000","1000.00000000");
INSERT INTO `llx_paiement_facture` VALUES("27","14","29","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("28","14","31","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("29","14","35","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("30","14","40","170.00000000",NULL,"1.00000000","170.00000000");
INSERT INTO `llx_paiement_facture` VALUES("31","14","37","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("32","14","38","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("33","14","39","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("34","14","42","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("35","14","43","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("36","14","45","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("37","15","44","1275.00000000",NULL,"1.00000000","1275.00000000");
INSERT INTO `llx_paiement_facture` VALUES("38","16","46","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("39","17","32","850.00000000",NULL,"1.00000000","850.00000000");
INSERT INTO `llx_paiement_facture` VALUES("40","18","36","200.00000000",NULL,"1.00000000","200.00000000");
INSERT INTO `llx_paiement_facture` VALUES("41","19","61","130.00000000",NULL,"1.00000000","130.00000000");
INSERT INTO `llx_paiement_facture` VALUES("42","20","66","1100.00000000",NULL,"1.00000000","1100.00000000");
INSERT INTO `llx_paiement_facture` VALUES("43","21","67","716.99000000",NULL,"1.00000000","716.99000000");
INSERT INTO `llx_paiement_facture` VALUES("44","22","65","800.00000000",NULL,"1.00000000","800.00000000");
INSERT INTO `llx_paiement_facture` VALUES("45","23","72","30.00000000",NULL,"1.00000000","30.00000000");
INSERT INTO `llx_paiement_facture` VALUES("46","24","70","800.00000000",NULL,"1.00000000","800.00000000");
INSERT INTO `llx_paiement_facture` VALUES("47","25","75","400.00000000",NULL,"1.00000000","400.00000000");
INSERT INTO `llx_paiement_facture` VALUES("48","26","75","400.00000000",NULL,"1.00000000","400.00000000");
INSERT INTO `llx_paiement_facture` VALUES("49","27","54","250.00000000",NULL,"1.00000000","250.00000000");
INSERT INTO `llx_paiement_facture` VALUES("50","28","77","300.00000000","EUR","1.00000000","300.00000000");
INSERT INTO `llx_paiement_facture` VALUES("51","29","51","2980.00000000","EUR","1.00000000","2980.00000000");
INSERT INTO `llx_paiement_facture` VALUES("52","30","80","50.00000000","EUR","1.00000000","50.00000000");
INSERT INTO `llx_paiement_facture` VALUES("53","31","73","32.00000000","EUR","1.00000000","32.00000000");
INSERT INTO `llx_paiement_facture` VALUES("54","31","82","32.00000000","EUR","1.00000000","32.00000000");
INSERT INTO `llx_paiement_facture` VALUES("55","32","84","50.00000000","EUR","1.00000000","50.00000000");
INSERT INTO `llx_paiement_facture` VALUES("56","33","62","60.00000000","EUR","1.00000000","60.00000000");
INSERT INTO `llx_paiement_facture` VALUES("57","34","81","100.00000000","EUR","1.00000000","100.00000000");



DROP TABLE IF EXISTS `llx_paiementcharge`;
CREATE TABLE `llx_paiementcharge` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_charge` int DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datep` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `fk_typepaiement` int NOT NULL,
  `num_paiement` varchar(50) DEFAULT NULL,
  `note` text,
  `fk_bank` int NOT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_paiementfourn`;
CREATE TABLE `llx_paiementfourn` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) DEFAULT NULL,
  `entity` int DEFAULT '1',
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `datep` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `multicurrency_amount` double(24,8) DEFAULT '0.00000000',
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_paiement` int NOT NULL,
  `num_paiement` varchar(50) DEFAULT NULL,
  `note` text,
  `fk_bank` int NOT NULL,
  `statut` smallint NOT NULL DEFAULT '0',
  `model_pdf` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_paiementfourn_facturefourn`;
CREATE TABLE `llx_paiementfourn_facturefourn` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_paiementfourn` int DEFAULT NULL,
  `fk_facturefourn` int DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_amount` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_paiementfourn_facturefourn` (`fk_paiementfourn`,`fk_facturefourn`),
  KEY `idx_paiementfourn_facturefourn_fk_facture` (`fk_facturefourn`),
  KEY `idx_paiementfourn_facturefourn_fk_paiement` (`fk_paiementfourn`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_partnership`;
CREATE TABLE `llx_partnership` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(128) NOT NULL DEFAULT '(PROV)',
  `status` smallint NOT NULL DEFAULT '0',
  `fk_soc` int DEFAULT NULL,
  `fk_member` int DEFAULT NULL,
  `email_partnership` varchar(64) DEFAULT NULL,
  `date_partnership_start` date NOT NULL,
  `date_partnership_end` date DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `reason_decline_or_cancel` text,
  `date_creation` datetime NOT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_modif` int DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `count_last_url_check_error` int DEFAULT '0',
  `last_check_backlink` datetime DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `fk_type` int NOT NULL DEFAULT '0',
  `url_to_check` varchar(255) DEFAULT NULL,
  `ip` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_fk_type_fk_soc` (`fk_type`,`fk_soc`,`date_partnership_start`),
  UNIQUE KEY `uk_fk_type_fk_member` (`fk_type`,`fk_member`,`date_partnership_start`),
  KEY `idx_partnership_rowid` (`rowid`),
  KEY `idx_partnership_ref` (`ref`),
  KEY `idx_partnership_fk_soc` (`fk_soc`),
  KEY `llx_partnership_fk_user_creat` (`fk_user_creat`),
  KEY `idx_partnership_status` (`status`),
  KEY `idx_partnership_fk_member` (`fk_member`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_partnership_extrafields`;
CREATE TABLE `llx_partnership_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_partnership_fk_object` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_payment_donation`;
CREATE TABLE `llx_payment_donation` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_donation` int DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datep` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `fk_typepayment` int NOT NULL,
  `num_payment` varchar(50) DEFAULT NULL,
  `note` text,
  `ext_payment_id` varchar(255) DEFAULT NULL,
  `ext_payment_site` varchar(128) DEFAULT NULL,
  `fk_bank` int NOT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_payment_expensereport`;
CREATE TABLE `llx_payment_expensereport` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_expensereport` int DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datep` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `fk_typepayment` int NOT NULL,
  `num_payment` varchar(50) DEFAULT NULL,
  `note` text,
  `fk_bank` int NOT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_payment_loan`;
CREATE TABLE `llx_payment_loan` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_loan` int DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datep` datetime DEFAULT NULL,
  `amount_capital` double(24,8) DEFAULT '0.00000000',
  `amount_insurance` double(24,8) DEFAULT '0.00000000',
  `amount_interest` double(24,8) DEFAULT '0.00000000',
  `fk_typepayment` int NOT NULL,
  `num_payment` varchar(50) DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `fk_bank` int NOT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_payment_salary`;
CREATE TABLE `llx_payment_salary` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `datep` datetime DEFAULT NULL,
  `datev` date DEFAULT NULL,
  `salary` double(24,8) DEFAULT NULL,
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `fk_projet` int DEFAULT NULL,
  `fk_typepayment` int NOT NULL,
  `num_payment` varchar(50) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `datesp` date DEFAULT NULL,
  `dateep` date DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `note` text,
  `fk_bank` int DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_salary` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_payment_salary_ref` (`num_payment`),
  KEY `idx_payment_salary_user` (`fk_user`,`entity`),
  KEY `idx_payment_salary_datep` (`datep`),
  KEY `idx_payment_salary_datesp` (`datesp`),
  KEY `idx_payment_salary_dateep` (`dateep`),
  CONSTRAINT `fk_payment_salary_user` FOREIGN KEY (`fk_user`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_payment_various`;
CREATE TABLE `llx_payment_various` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) DEFAULT NULL,
  `num_payment` varchar(50) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `datep` date DEFAULT NULL,
  `datev` date DEFAULT NULL,
  `sens` smallint NOT NULL DEFAULT '0',
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `fk_typepayment` int NOT NULL,
  `accountancy_code` varchar(32) DEFAULT NULL,
  `fk_projet` int DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `note` text,
  `fk_bank` int DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `subledger_account` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_payment_vat`;
CREATE TABLE `llx_payment_vat` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_tva` int DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datep` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `fk_typepaiement` int NOT NULL,
  `num_paiement` varchar(50) DEFAULT NULL,
  `note` text,
  `fk_bank` int NOT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_pos_cash_fence`;
CREATE TABLE `llx_pos_cash_fence` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `ref` varchar(64) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `opening` double(24,8) DEFAULT '0.00000000',
  `cash` double(24,8) DEFAULT '0.00000000',
  `card` double(24,8) DEFAULT '0.00000000',
  `cheque` double(24,8) DEFAULT '0.00000000',
  `status` int DEFAULT NULL,
  `date_creation` datetime NOT NULL,
  `date_valid` datetime DEFAULT NULL,
  `day_close` int DEFAULT NULL,
  `month_close` int DEFAULT NULL,
  `year_close` int DEFAULT NULL,
  `posmodule` varchar(30) DEFAULT NULL,
  `posnumber` varchar(30) DEFAULT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `tms` timestamp NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_prelevement`;
CREATE TABLE `llx_prelevement` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_facture` int DEFAULT NULL,
  `fk_prelevement_lignes` int NOT NULL,
  `fk_facture_fourn` int DEFAULT NULL,
  `fk_salary` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_prelevement_facture_fk_prelevement_lignes` (`fk_prelevement_lignes`),
  CONSTRAINT `fk_prelevement_facture_fk_prelevement_lignes` FOREIGN KEY (`fk_prelevement_lignes`) REFERENCES `llx_prelevement_lignes` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_prelevement_bons`;
CREATE TABLE `llx_prelevement_bons` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(12) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `datec` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `statut` smallint DEFAULT '0',
  `credite` smallint DEFAULT '0',
  `note` text,
  `date_trans` datetime DEFAULT NULL,
  `method_trans` smallint DEFAULT NULL,
  `fk_user_trans` int DEFAULT NULL,
  `date_credit` datetime DEFAULT NULL,
  `fk_user_credit` int DEFAULT NULL,
  `type` varchar(16) DEFAULT 'debit-order',
  `fk_bank_account` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_prelevement_bons_ref` (`ref`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_prelevement_demande`;
CREATE TABLE `llx_prelevement_demande` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_facture` int DEFAULT NULL,
  `amount` double(24,8) NOT NULL,
  `date_demande` datetime NOT NULL,
  `traite` smallint DEFAULT '0',
  `date_traite` datetime DEFAULT NULL,
  `fk_prelevement_bons` int DEFAULT NULL,
  `fk_user_demande` int NOT NULL,
  `code_banque` varchar(128) DEFAULT NULL,
  `code_guichet` varchar(6) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `cle_rib` varchar(5) DEFAULT NULL,
  `entity` int DEFAULT NULL,
  `sourcetype` varchar(32) DEFAULT NULL,
  `ext_payment_id` varchar(255) DEFAULT NULL,
  `ext_payment_site` varchar(128) DEFAULT NULL,
  `fk_facture_fourn` int DEFAULT NULL,
  `fk_salary` int DEFAULT NULL,
  `type` varchar(12) DEFAULT '',
  PRIMARY KEY (`rowid`),
  KEY `idx_prelevement_facture_demande_fk_facture` (`fk_facture`),
  KEY `idx_prelevement_facture_demande_fk_facture_fourn` (`fk_facture_fourn`),
  KEY `idx_prelevement_demande_ext_payment_id` (`ext_payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_prelevement_lignes`;
CREATE TABLE `llx_prelevement_lignes` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_prelevement_bons` int DEFAULT NULL,
  `fk_soc` int NOT NULL,
  `statut` smallint DEFAULT '0',
  `client_nom` varchar(255) DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `code_banque` varchar(128) DEFAULT NULL,
  `code_guichet` varchar(6) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `cle_rib` varchar(5) DEFAULT NULL,
  `note` text,
  `fk_user` int DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rowid`),
  KEY `idx_prelevement_lignes_fk_prelevement_bons` (`fk_prelevement_bons`),
  CONSTRAINT `fk_prelevement_lignes_fk_prelevement_bons` FOREIGN KEY (`fk_prelevement_bons`) REFERENCES `llx_prelevement_bons` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_prelevement_rejet`;
CREATE TABLE `llx_prelevement_rejet` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_prelevement_lignes` int DEFAULT NULL,
  `date_rejet` datetime DEFAULT NULL,
  `motif` int DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `fk_user_creation` int DEFAULT NULL,
  `note` text,
  `afacturer` tinyint DEFAULT '0',
  `fk_facture` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_printing`;
CREATE TABLE `llx_printing` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `printer_name` text NOT NULL,
  `printer_location` text NOT NULL,
  `printer_id` varchar(255) NOT NULL,
  `copy` int NOT NULL DEFAULT '1',
  `module` varchar(16) NOT NULL,
  `driver` varchar(16) NOT NULL,
  `userid` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product`;
CREATE TABLE `llx_product` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(128) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `ref_ext` varchar(128) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_parent` int DEFAULT '0',
  `label` varchar(255) NOT NULL,
  `description` text,
  `note_public` text,
  `note` text,
  `customcode` varchar(32) DEFAULT NULL,
  `fk_country` int DEFAULT NULL,
  `fk_state` int DEFAULT NULL,
  `price` double(24,8) DEFAULT '0.00000000',
  `price_ttc` double(24,8) DEFAULT '0.00000000',
  `price_min` double(24,8) DEFAULT '0.00000000',
  `price_min_ttc` double(24,8) DEFAULT '0.00000000',
  `price_base_type` varchar(3) DEFAULT 'HT',
  `cost_price` double(24,8) DEFAULT NULL,
  `default_vat_code` varchar(10) DEFAULT NULL,
  `tva_tx` double(6,3) DEFAULT NULL,
  `recuperableonly` int NOT NULL DEFAULT '0',
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) NOT NULL DEFAULT '0',
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) NOT NULL DEFAULT '0',
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `tosell` tinyint DEFAULT '1',
  `tobuy` tinyint DEFAULT '1',
  `onportal` tinyint DEFAULT '0',
  `tobatch` tinyint NOT NULL DEFAULT '0',
  `sell_or_eat_by_mandatory` tinyint NOT NULL DEFAULT '0',
  `fk_product_type` int DEFAULT '0',
  `duration` varchar(6) DEFAULT NULL,
  `seuil_stock_alerte` float DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `barcode` varchar(180) DEFAULT NULL,
  `fk_barcode_type` int DEFAULT NULL,
  `accountancy_code_sell` varchar(32) DEFAULT NULL,
  `accountancy_code_sell_intra` varchar(32) DEFAULT NULL,
  `accountancy_code_sell_export` varchar(32) DEFAULT NULL,
  `accountancy_code_buy` varchar(32) DEFAULT NULL,
  `accountancy_code_buy_intra` varchar(32) DEFAULT NULL,
  `accountancy_code_buy_export` varchar(32) DEFAULT NULL,
  `partnumber` varchar(32) DEFAULT NULL,
  `weight` float DEFAULT NULL,
  `weight_units` tinyint DEFAULT NULL,
  `length` float DEFAULT NULL,
  `length_units` tinyint DEFAULT NULL,
  `width` float DEFAULT NULL,
  `width_units` tinyint DEFAULT NULL,
  `height` float DEFAULT NULL,
  `height_units` tinyint DEFAULT NULL,
  `surface` float DEFAULT NULL,
  `surface_units` tinyint DEFAULT NULL,
  `volume` float DEFAULT NULL,
  `volume_units` tinyint DEFAULT NULL,
  `stock` double DEFAULT NULL,
  `pmp` double(24,8) NOT NULL DEFAULT '0.00000000',
  `fifo` double(24,8) DEFAULT NULL,
  `lifo` double(24,8) DEFAULT NULL,
  `fk_default_warehouse` int DEFAULT NULL,
  `canvas` varchar(32) DEFAULT NULL,
  `finished` tinyint DEFAULT NULL,
  `hidden` tinyint DEFAULT '0',
  `import_key` varchar(14) DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `fk_price_expression` int DEFAULT NULL,
  `desiredstock` float DEFAULT NULL,
  `fk_unit` int DEFAULT NULL,
  `price_autogen` tinyint DEFAULT '0',
  `fk_project` int DEFAULT NULL,
  `net_measure` float DEFAULT NULL,
  `net_measure_units` tinyint DEFAULT NULL,
  `batch_mask` varchar(32) DEFAULT NULL,
  `lifetime` int DEFAULT NULL,
  `qc_frequency` int DEFAULT NULL,
  `mandatory_period` tinyint DEFAULT '0',
  `fk_default_bom` int DEFAULT NULL,
  `fk_default_workstation` int DEFAULT NULL,
  `stockable_product` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_ref` (`ref`,`entity`),
  UNIQUE KEY `uk_product_barcode` (`barcode`,`fk_barcode_type`,`entity`),
  KEY `idx_product_label` (`label`),
  KEY `idx_product_barcode` (`barcode`),
  KEY `idx_product_import_key` (`import_key`),
  KEY `idx_product_seuil_stock_alerte` (`seuil_stock_alerte`),
  KEY `idx_product_fk_country` (`fk_country`),
  KEY `idx_product_fk_user_author` (`fk_user_author`),
  KEY `idx_product_fk_barcode_type` (`fk_barcode_type`),
  KEY `fk_product_fk_unit` (`fk_unit`),
  KEY `fk_product_default_warehouse` (`fk_default_warehouse`),
  KEY `idx_product_fk_project` (`fk_project`),
  KEY `fk_product_finished` (`finished`),
  CONSTRAINT `fk_product_barcode_type` FOREIGN KEY (`fk_barcode_type`) REFERENCES `llx_c_barcode_type` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_product_default_warehouse` FOREIGN KEY (`fk_default_warehouse`) REFERENCES `llx_entrepot` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_product_finished` FOREIGN KEY (`finished`) REFERENCES `llx_c_product_nature` (`code`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_product_fk_country` FOREIGN KEY (`fk_country`) REFERENCES `llx_c_country` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_product_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

INSERT INTO `llx_product` VALUES("1","heber","1",NULL,"2018-11-02 21:34:36",NULL,"0","Hébergement Offre Mutualisée Pro 2014 - 12 mois Du 16 Juin 2018 au 15 Juin 2019","",NULL,"","",NULL,NULL,"120.00000000","120.00000000","0.00000000","0.00000000","HT",NULL,NULL,"0.000","0","0.000","0","0.000","0","1","1","1","1","0","0","0","1","",NULL,NULL,NULL,NULL,"","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0.00000000",NULL,NULL,NULL,"","0","0",NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,"0");
INSERT INTO `llx_product` VALUES("2","Dom1","1",NULL,"2018-11-02 21:35:16",NULL,"0","Domaine offert la première année de l\'hébergement","",NULL,"","",NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","HT",NULL,NULL,"0.000","0","0.000","0","0.000","0","1","1","1","1","0","0","0","1","",NULL,NULL,NULL,NULL,"","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0.00000000",NULL,NULL,NULL,"","0","0",NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,"0");
INSERT INTO `llx_product` VALUES("3","dom","1",NULL,"2018-11-02 21:36:55",NULL,"0","Demande de transfert d\'un domaine .com","",NULL,"","",NULL,NULL,"7.99000000","7.99000000","0.00000000","0.00000000","HT",NULL,NULL,"0.000","0","0.000","0","0.000","0","1","1","1","1","0","0","0","1","",NULL,NULL,NULL,NULL,"","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0.00000000",NULL,NULL,NULL,"","0","0",NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,"0");
INSERT INTO `llx_product` VALUES("4","migra","1",NULL,"2018-11-02 21:37:58",NULL,"0","Migration de site vers le nouvel hébergeur, modification sur les produits, paramétrages et formation","",NULL,"","",NULL,NULL,"400.00000000","400.00000000","0.00000000","0.00000000","HT",NULL,NULL,"0.000","0","0.000","0","0.000","0","1","1","1","1","0","0","0","1","",NULL,NULL,NULL,NULL,"","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0.00000000",NULL,NULL,NULL,"","0","0",NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,"0");
INSERT INTO `llx_product` VALUES("5","SR","1",NULL,"2025-06-11 10:10:26",NULL,"0","Suivi du référencement et positionnement","",NULL,"","",NULL,NULL,"10.00000000","10.00000000","0.00000000","0.00000000","HT",NULL,NULL,"0.000","0","0.000","0","0.000","0","1","1","1","1","0","0","0","1","h","0",NULL,NULL,NULL,"","","","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0.00000000",NULL,NULL,NULL,"",NULL,"0",NULL,NULL,NULL,"0",NULL,"0",NULL,NULL,NULL,"",NULL,NULL,"0",NULL,NULL,"1");
INSERT INTO `llx_product` VALUES("6","OTE","1",NULL,"2025-06-11 10:11:48",NULL,"0","Optimisations techniques et éditoriales","",NULL,"","",NULL,NULL,"10.00000000","10.00000000","0.00000000","0.00000000","HT",NULL,NULL,"0.000","0","0.000","0","0.000","0","1","1","1","1","0","0","0","1","h","0",NULL,NULL,NULL,"","","","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0.00000000",NULL,NULL,NULL,"",NULL,"0",NULL,NULL,NULL,"0",NULL,"0",NULL,NULL,NULL,"",NULL,NULL,"0",NULL,NULL,"1");
INSERT INTO `llx_product` VALUES("7","SMC","1",NULL,"2025-06-11 10:15:08",NULL,"0","Suivi des mots-clés","",NULL,"","",NULL,NULL,"10.00000000","10.00000000","0.00000000","0.00000000","HT",NULL,NULL,"0.000","0","0.000","0","0.000","0","1","1","1","1","0","0","0","1","h","0",NULL,NULL,NULL,"","","","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0.00000000",NULL,NULL,NULL,"",NULL,"0",NULL,NULL,NULL,"0",NULL,"0",NULL,NULL,NULL,"",NULL,NULL,"0",NULL,NULL,"1");
INSERT INTO `llx_product` VALUES("8","MAJG","1",NULL,"2025-06-11 10:16:01",NULL,"0","Mise à jour régulière selon les évolutions de Google","",NULL,"","",NULL,NULL,"10.00000000","10.00000000","0.00000000","0.00000000","HT",NULL,NULL,"0.000","0","0.000","0","0.000","0","1","1","1","1","0","0","0","1","h","0",NULL,NULL,NULL,"","","","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0.00000000",NULL,NULL,NULL,"",NULL,"0",NULL,NULL,NULL,"0",NULL,"0",NULL,NULL,NULL,"",NULL,NULL,"0",NULL,NULL,"1");
INSERT INTO `llx_product` VALUES("9","BACK","1",NULL,"2025-06-11 11:22:22",NULL,"0","Sauvegarde mensuelle","",NULL,"","",NULL,NULL,"10.00000000","10.00000000","0.00000000","0.00000000","HT",NULL,NULL,"0.000","0","0.000","0","0.000","0","1","1","1","1","0","0","0","1","h","0",NULL,NULL,NULL,"","","","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0.00000000",NULL,NULL,NULL,"",NULL,"0",NULL,NULL,NULL,"0",NULL,"0",NULL,NULL,NULL,"",NULL,NULL,"0",NULL,NULL,"1");
INSERT INTO `llx_product` VALUES("10","AA","1",NULL,"2025-06-11 11:26:07",NULL,"0","Améliorations du site et suivi poussé et complet,  ajout de contenu","Am&eacute;liorations du site et suivi pouss&eacute; et complet,&nbsp; ajout de contenu",NULL,"","",NULL,NULL,"0.00000000","0.00000000","0.00000000","0.00000000","HT",NULL,NULL,"0.000","0","0.000","0","0.000","0","1","1","1","1","0","0","0","1","s","0",NULL,NULL,NULL,"","","","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0.00000000",NULL,NULL,NULL,"",NULL,"0",NULL,NULL,NULL,"0",NULL,"0",NULL,NULL,NULL,"",NULL,NULL,"0",NULL,NULL,"1");
INSERT INTO `llx_product` VALUES("11","AS","1",NULL,"2025-06-11 11:26:49",NULL,"0","Actions spécifiques pour la visibilité sur les assistants IA","",NULL,"","",NULL,NULL,"10.00000000","10.00000000","0.00000000","0.00000000","HT",NULL,NULL,"0.000","0","0.000","0","0.000","0","1","1","1","1","0","0","0","1","h","0",NULL,NULL,NULL,"","","","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0.00000000",NULL,NULL,NULL,"",NULL,"0",NULL,NULL,NULL,"0",NULL,"0",NULL,NULL,NULL,"",NULL,NULL,"0",NULL,NULL,"1");
INSERT INTO `llx_product` VALUES("12","SD","1",NULL,"2025-06-11 11:27:39",NULL,"0","Suivi détaillé via Google Search Console / Analytics","",NULL,"","",NULL,NULL,"10.00000000","10.00000000","0.00000000","0.00000000","HT",NULL,NULL,"0.000","0","0.000","0","0.000","0","1","1","1","1","0","0","0","1","h","0",NULL,NULL,NULL,"","","","","","",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0.00000000",NULL,NULL,NULL,"",NULL,"0",NULL,NULL,NULL,"0",NULL,"0",NULL,NULL,NULL,"",NULL,NULL,"0",NULL,NULL,"1");



DROP TABLE IF EXISTS `llx_product_association`;
CREATE TABLE `llx_product_association` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_product_pere` int NOT NULL DEFAULT '0',
  `fk_product_fils` int NOT NULL DEFAULT '0',
  `qty` double DEFAULT NULL,
  `incdec` int DEFAULT '1',
  `rang` int DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_association` (`fk_product_pere`,`fk_product_fils`),
  KEY `idx_product_association_fils` (`fk_product_fils`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_attribute`;
CREATE TABLE `llx_product_attribute` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(255) NOT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `label` varchar(255) NOT NULL,
  `position` int NOT NULL DEFAULT '0',
  `entity` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_attribute_ref` (`ref`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_attribute_combination`;
CREATE TABLE `llx_product_attribute_combination` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_product_parent` int NOT NULL,
  `fk_product_child` int NOT NULL,
  `variation_price` float NOT NULL,
  `variation_price_percentage` int DEFAULT NULL,
  `variation_weight` float NOT NULL,
  `variation_ref_ext` varchar(255) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  KEY `idx_product_att_com_product_parent` (`fk_product_parent`),
  KEY `idx_product_att_com_product_child` (`fk_product_child`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_attribute_combination2val`;
CREATE TABLE `llx_product_attribute_combination2val` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_prod_combination` int NOT NULL,
  `fk_prod_attr` int NOT NULL,
  `fk_prod_attr_val` int NOT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_attribute_combination_price_level`;
CREATE TABLE `llx_product_attribute_combination_price_level` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_product_attribute_combination` int NOT NULL DEFAULT '1',
  `fk_price_level` int NOT NULL DEFAULT '1',
  `variation_price` double(24,8) NOT NULL,
  `variation_price_percentage` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `fk_product_attribute_combination` (`fk_product_attribute_combination`,`fk_price_level`),
  UNIQUE KEY `fk_product_attribute_combinati_2` (`fk_product_attribute_combination`,`fk_price_level`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_attribute_value`;
CREATE TABLE `llx_product_attribute_value` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_product_attribute` int NOT NULL,
  `ref` varchar(180) NOT NULL,
  `value` varchar(255) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `position` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_attribute_value` (`fk_product_attribute`,`ref`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_batch`;
CREATE TABLE `llx_product_batch` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_product_stock` int NOT NULL,
  `eatby` datetime DEFAULT NULL,
  `sellby` datetime DEFAULT NULL,
  `batch` varchar(128) DEFAULT NULL,
  `qty` double NOT NULL DEFAULT '0',
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_batch` (`fk_product_stock`,`batch`),
  KEY `idx_fk_product_stock` (`fk_product_stock`),
  KEY `idx_batch` (`batch`),
  CONSTRAINT `fk_product_batch_fk_product_stock` FOREIGN KEY (`fk_product_stock`) REFERENCES `llx_product_stock` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_customer_price`;
CREATE TABLE `llx_product_customer_price` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_product` int NOT NULL,
  `fk_soc` int NOT NULL,
  `price` double(24,8) DEFAULT '0.00000000',
  `price_ttc` double(24,8) DEFAULT '0.00000000',
  `price_min` double(24,8) DEFAULT '0.00000000',
  `price_min_ttc` double(24,8) DEFAULT '0.00000000',
  `price_base_type` varchar(3) DEFAULT 'HT',
  `default_vat_code` varchar(10) DEFAULT NULL,
  `tva_tx` double(6,3) DEFAULT NULL,
  `recuperableonly` int NOT NULL DEFAULT '0',
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) NOT NULL DEFAULT '0',
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) NOT NULL DEFAULT '0',
  `fk_user` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `ref_customer` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_customer_price_fk_product_fk_soc` (`fk_product`,`fk_soc`),
  KEY `idx_product_customer_price_fk_user` (`fk_user`),
  KEY `idx_product_customer_price_fk_soc` (`fk_soc`),
  CONSTRAINT `fk_product_customer_price_fk_product` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_product_customer_price_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_product_customer_price_fk_user` FOREIGN KEY (`fk_user`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_customer_price_log`;
CREATE TABLE `llx_product_customer_price_log` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `datec` datetime DEFAULT NULL,
  `fk_product` int NOT NULL,
  `fk_soc` int NOT NULL DEFAULT '0',
  `price` double(24,8) DEFAULT '0.00000000',
  `price_ttc` double(24,8) DEFAULT '0.00000000',
  `price_min` double(24,8) DEFAULT '0.00000000',
  `price_min_ttc` double(24,8) DEFAULT '0.00000000',
  `price_base_type` varchar(3) DEFAULT 'HT',
  `default_vat_code` varchar(10) DEFAULT NULL,
  `tva_tx` double(6,3) DEFAULT NULL,
  `recuperableonly` int NOT NULL DEFAULT '0',
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) NOT NULL DEFAULT '0',
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) NOT NULL DEFAULT '0',
  `fk_user` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `ref_customer` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_extrafields`;
CREATE TABLE `llx_product_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_product_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_fournisseur_price`;
CREATE TABLE `llx_product_fournisseur_price` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_product` int DEFAULT NULL,
  `fk_soc` int DEFAULT NULL,
  `ref_fourn` varchar(128) DEFAULT NULL,
  `desc_fourn` text,
  `fk_availability` int DEFAULT NULL,
  `price` double(24,8) DEFAULT '0.00000000',
  `quantity` double DEFAULT NULL,
  `remise_percent` double NOT NULL DEFAULT '0',
  `remise` double NOT NULL DEFAULT '0',
  `unitprice` double(24,8) DEFAULT '0.00000000',
  `charges` double(24,8) DEFAULT '0.00000000',
  `default_vat_code` varchar(10) DEFAULT NULL,
  `tva_tx` double(6,3) NOT NULL,
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) NOT NULL DEFAULT '0',
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) NOT NULL DEFAULT '0',
  `info_bits` int NOT NULL DEFAULT '0',
  `fk_user` int DEFAULT NULL,
  `fk_supplier_price_expression` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `delivery_time_days` int DEFAULT NULL,
  `supplier_reputation` varchar(10) DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_unitprice` double(24,8) DEFAULT NULL,
  `multicurrency_price` double(24,8) DEFAULT NULL,
  `barcode` varchar(180) DEFAULT NULL,
  `fk_barcode_type` int DEFAULT NULL,
  `packaging` double DEFAULT NULL,
  `status` int DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_fournisseur_price_ref` (`ref_fourn`,`fk_soc`,`quantity`,`entity`),
  UNIQUE KEY `uk_product_barcode` (`barcode`,`fk_barcode_type`,`entity`),
  KEY `idx_product_fournisseur_price_fk_user` (`fk_user`),
  KEY `idx_product_fourn_price_fk_product` (`fk_product`,`entity`),
  KEY `idx_product_fourn_price_fk_soc` (`fk_soc`,`entity`),
  KEY `idx_product_barcode` (`barcode`),
  KEY `idx_product_fk_barcode_type` (`fk_barcode_type`),
  CONSTRAINT `fk_product_fournisseur_price_barcode_type` FOREIGN KEY (`fk_barcode_type`) REFERENCES `llx_c_barcode_type` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_product_fournisseur_price_fk_product` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_product_fournisseur_price_fk_user` FOREIGN KEY (`fk_user`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_fournisseur_price_extrafields`;
CREATE TABLE `llx_product_fournisseur_price_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_product_fournisseur_price_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_fournisseur_price_log`;
CREATE TABLE `llx_product_fournisseur_price_log` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `fk_product_fournisseur` int NOT NULL,
  `price` double(24,8) DEFAULT '0.00000000',
  `quantity` double DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_unitprice` double(24,8) DEFAULT NULL,
  `multicurrency_price` double(24,8) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_product_fournisseur_price_log_fk_product_fournisseur` (`fk_product_fournisseur`),
  KEY `idx_product_fournisseur_price_log_fk_user` (`fk_user`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_lang`;
CREATE TABLE `llx_product_lang` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_product` int NOT NULL DEFAULT '0',
  `lang` varchar(5) NOT NULL DEFAULT '0',
  `label` varchar(255) NOT NULL,
  `description` text,
  `note` text,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_lang` (`fk_product`,`lang`),
  CONSTRAINT `fk_product_lang_fk_product` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_lot`;
CREATE TABLE `llx_product_lot` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int DEFAULT '1',
  `fk_product` int NOT NULL,
  `batch` varchar(128) DEFAULT NULL,
  `note_public` text,
  `note_private` text,
  `eatby` date DEFAULT NULL,
  `sellby` date DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `import_key` int DEFAULT NULL,
  `eol_date` datetime DEFAULT NULL,
  `manufacturing_date` datetime DEFAULT NULL,
  `scrapping_date` datetime DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `barcode` varchar(180) DEFAULT NULL,
  `fk_barcode_type` int DEFAULT NULL,
  `qc_frequency` int DEFAULT NULL,
  `lifetime` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_lot` (`fk_product`,`batch`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_lot_extrafields`;
CREATE TABLE `llx_product_lot_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_product_lot_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_perentity`;
CREATE TABLE `llx_product_perentity` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_product` int DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `accountancy_code_sell` varchar(32) DEFAULT NULL,
  `accountancy_code_sell_intra` varchar(32) DEFAULT NULL,
  `accountancy_code_sell_export` varchar(32) DEFAULT NULL,
  `accountancy_code_buy` varchar(32) DEFAULT NULL,
  `accountancy_code_buy_intra` varchar(32) DEFAULT NULL,
  `accountancy_code_buy_export` varchar(32) DEFAULT NULL,
  `pmp` double(24,8) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_perentity` (`fk_product`,`entity`),
  KEY `idx_product_perentity_fk_product` (`fk_product`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_price`;
CREATE TABLE `llx_product_price` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `tms` timestamp NULL DEFAULT NULL,
  `fk_product` int NOT NULL,
  `date_price` datetime NOT NULL,
  `price_level` smallint DEFAULT '1',
  `price` double(24,8) DEFAULT NULL,
  `price_ttc` double(24,8) DEFAULT NULL,
  `price_min` double(24,8) DEFAULT NULL,
  `price_min_ttc` double(24,8) DEFAULT NULL,
  `price_base_type` varchar(3) DEFAULT 'HT',
  `default_vat_code` varchar(10) DEFAULT NULL,
  `tva_tx` double(6,3) NOT NULL DEFAULT '0.000',
  `recuperableonly` int NOT NULL DEFAULT '0',
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) NOT NULL DEFAULT '0',
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) NOT NULL DEFAULT '0',
  `fk_user_author` int DEFAULT NULL,
  `tosell` tinyint DEFAULT '1',
  `price_by_qty` int NOT NULL DEFAULT '0',
  `fk_price_expression` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_price` double(24,8) DEFAULT NULL,
  `multicurrency_price_ttc` double(24,8) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_product_price_fk_user_author` (`fk_user_author`),
  KEY `idx_product_price_fk_product` (`fk_product`),
  CONSTRAINT `fk_product_price_product` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_product_price_user_author` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

INSERT INTO `llx_product_price` VALUES("1","1",NULL,"1","2018-11-02 21:34:36","1","120.00000000","120.00000000","0.00000000","0.00000000","HT",NULL,"0.000","0","0.000","0","0.000","0","1","1","0",NULL,NULL,NULL,NULL,"1.00000000",NULL,NULL);
INSERT INTO `llx_product_price` VALUES("2","1",NULL,"2","2018-11-02 21:35:16","1","0.00000000","0.00000000","0.00000000","0.00000000","HT",NULL,"0.000","0","0.000","0","0.000","0","1","1","0",NULL,NULL,NULL,NULL,"1.00000000",NULL,NULL);
INSERT INTO `llx_product_price` VALUES("3","1",NULL,"3","2018-11-02 21:36:55","1","7.99000000","7.99000000","0.00000000","0.00000000","HT",NULL,"0.000","0","0.000","0","0.000","0","1","1","0",NULL,NULL,NULL,NULL,"1.00000000",NULL,NULL);
INSERT INTO `llx_product_price` VALUES("4","1",NULL,"4","2018-11-02 21:37:58","1","400.00000000","400.00000000","0.00000000","0.00000000","HT",NULL,"0.000","0","0.000","0","0.000","0","1","1","0",NULL,NULL,NULL,NULL,"1.00000000",NULL,NULL);
INSERT INTO `llx_product_price` VALUES("5","1",NULL,"5","2025-06-11 10:10:26","1","10.00000000","10.00000000","0.00000000","0.00000000","HT",NULL,"0.000","0","0.000","0","0.000","0","1","1","0",NULL,NULL,NULL,NULL,"1.00000000",NULL,NULL);
INSERT INTO `llx_product_price` VALUES("6","1",NULL,"6","2025-06-11 10:11:48","1","10.00000000","10.00000000","0.00000000","0.00000000","HT",NULL,"0.000","0","0.000","0","0.000","0","1","1","0",NULL,NULL,NULL,NULL,"1.00000000",NULL,NULL);
INSERT INTO `llx_product_price` VALUES("7","1",NULL,"7","2025-06-11 10:15:08","1","10.00000000","10.00000000","0.00000000","0.00000000","HT",NULL,"0.000","0","0.000","0","0.000","0","1","1","0",NULL,NULL,NULL,NULL,"1.00000000",NULL,NULL);
INSERT INTO `llx_product_price` VALUES("8","1",NULL,"8","2025-06-11 10:16:01","1","10.00000000","10.00000000","0.00000000","0.00000000","HT",NULL,"0.000","0","0.000","0","0.000","0","1","1","0",NULL,NULL,NULL,NULL,"1.00000000",NULL,NULL);
INSERT INTO `llx_product_price` VALUES("9","1",NULL,"9","2025-06-11 11:22:22","1","10.00000000","10.00000000","0.00000000","0.00000000","HT",NULL,"0.000","0","0.000","0","0.000","0","1","1","0",NULL,NULL,NULL,NULL,"1.00000000",NULL,NULL);
INSERT INTO `llx_product_price` VALUES("10","1",NULL,"10","2025-06-11 11:26:07","1","0.00000000","0.00000000","0.00000000","0.00000000","HT",NULL,"0.000","0","0.000","0","0.000","0","1","1","0",NULL,NULL,NULL,NULL,"1.00000000",NULL,NULL);
INSERT INTO `llx_product_price` VALUES("11","1",NULL,"11","2025-06-11 11:26:49","1","10.00000000","10.00000000","0.00000000","0.00000000","HT",NULL,"0.000","0","0.000","0","0.000","0","1","1","0",NULL,NULL,NULL,NULL,"1.00000000",NULL,NULL);
INSERT INTO `llx_product_price` VALUES("12","1",NULL,"12","2025-06-11 11:27:39","1","10.00000000","10.00000000","0.00000000","0.00000000","HT",NULL,"0.000","0","0.000","0","0.000","0","1","1","0",NULL,NULL,NULL,NULL,"1.00000000",NULL,NULL);



DROP TABLE IF EXISTS `llx_product_price_by_qty`;
CREATE TABLE `llx_product_price_by_qty` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_product_price` int NOT NULL,
  `price` double(24,8) DEFAULT '0.00000000',
  `price_base_type` varchar(3) DEFAULT 'HT',
  `quantity` double DEFAULT NULL,
  `remise_percent` double NOT NULL DEFAULT '0',
  `remise` double NOT NULL DEFAULT '0',
  `unitprice` double(24,8) DEFAULT '0.00000000',
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_price` double(24,8) DEFAULT NULL,
  `multicurrency_price_ttc` double(24,8) DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_price_by_qty_level` (`fk_product_price`,`quantity`),
  KEY `idx_product_price_by_qty_fk_product_price` (`fk_product_price`),
  CONSTRAINT `fk_product_price_by_qty_fk_product_price` FOREIGN KEY (`fk_product_price`) REFERENCES `llx_product_price` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_pricerules`;
CREATE TABLE `llx_product_pricerules` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `level` int NOT NULL,
  `fk_level` int NOT NULL,
  `var_percent` float NOT NULL,
  `var_min_percent` float NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `unique_level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_stock`;
CREATE TABLE `llx_product_stock` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_product` int NOT NULL,
  `fk_entrepot` int NOT NULL,
  `reel` double DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_stock` (`fk_product`,`fk_entrepot`),
  KEY `idx_product_stock_fk_product` (`fk_product`),
  KEY `idx_product_stock_fk_entrepot` (`fk_entrepot`),
  CONSTRAINT `fk_entrepot_entrepot_rowid` FOREIGN KEY (`fk_entrepot`) REFERENCES `llx_entrepot` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_product_product_rowid` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_product_warehouse_properties`;
CREATE TABLE `llx_product_warehouse_properties` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_product` int NOT NULL,
  `fk_entrepot` int NOT NULL,
  `seuil_stock_alerte` float DEFAULT NULL,
  `desiredstock` float DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_projet`;
CREATE TABLE `llx_projet` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_soc` int DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `dateo` date DEFAULT NULL,
  `datee` date DEFAULT NULL,
  `ref` varchar(50) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `title` varchar(255) NOT NULL,
  `description` text,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `public` int DEFAULT NULL,
  `fk_statut` int NOT NULL DEFAULT '0',
  `fk_opp_status` int DEFAULT NULL,
  `opp_percent` double(5,2) DEFAULT NULL,
  `date_close` datetime DEFAULT NULL,
  `fk_user_close` int DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `opp_amount` double(24,8) DEFAULT NULL,
  `budget_amount` double(24,8) DEFAULT NULL,
  `usage_bill_time` int DEFAULT '0',
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `usage_opportunity` int DEFAULT '0',
  `usage_task` int DEFAULT '1',
  `usage_organize_event` int DEFAULT '0',
  `email_msgid` varchar(255) DEFAULT NULL,
  `fk_opp_status_end` int DEFAULT NULL,
  `accept_conference_suggestions` int DEFAULT '0',
  `accept_booth_suggestions` int DEFAULT '0',
  `price_registration` double(24,8) DEFAULT NULL,
  `price_booth` double(24,8) DEFAULT NULL,
  `max_attendees` int DEFAULT '0',
  `ip` varchar(250) DEFAULT NULL,
  `date_start_event` datetime DEFAULT NULL,
  `date_end_event` datetime DEFAULT NULL,
  `location` varchar(255) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `fk_project` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_projet_ref` (`ref`,`entity`),
  KEY `idx_projet_fk_soc` (`fk_soc`),
  CONSTRAINT `fk_projet_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_projet_extrafields`;
CREATE TABLE `llx_projet_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_projet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_projet_task`;
CREATE TABLE `llx_projet_task` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(50) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `fk_projet` int NOT NULL,
  `fk_task_parent` int NOT NULL DEFAULT '0',
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `dateo` datetime DEFAULT NULL,
  `datee` datetime DEFAULT NULL,
  `datev` datetime DEFAULT NULL,
  `label` varchar(255) NOT NULL,
  `description` text,
  `duration_effective` double DEFAULT '0',
  `planned_workload` double DEFAULT '0',
  `progress` int DEFAULT '0',
  `priority` int DEFAULT '0',
  `budget_amount` double(24,8) DEFAULT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `fk_statut` smallint NOT NULL DEFAULT '0',
  `note_private` text,
  `note_public` text,
  `rang` int DEFAULT '0',
  `model_pdf` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_projet_task_ref` (`ref`,`entity`),
  KEY `idx_projet_task_fk_projet` (`fk_projet`),
  KEY `idx_projet_task_fk_user_creat` (`fk_user_creat`),
  KEY `idx_projet_task_fk_user_valid` (`fk_user_valid`),
  CONSTRAINT `fk_projet_task_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_projet_task_fk_user_creat` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_projet_task_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_projet_task_extrafields`;
CREATE TABLE `llx_projet_task_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_projet_task_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_propal`;
CREATE TABLE `llx_propal` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `ref_ext` varchar(255) DEFAULT NULL,
  `ref_int` varchar(255) DEFAULT NULL,
  `ref_client` varchar(255) DEFAULT NULL,
  `fk_soc` int DEFAULT NULL,
  `fk_projet` int DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `datep` date DEFAULT NULL,
  `fin_validite` datetime DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `date_signature` datetime DEFAULT NULL,
  `date_cloture` datetime DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `fk_user_signature` int DEFAULT NULL,
  `fk_user_cloture` int DEFAULT NULL,
  `fk_statut` smallint NOT NULL DEFAULT '0',
  `price` double DEFAULT '0',
  `remise_percent` double DEFAULT '0',
  `remise_absolue` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `fk_account` int DEFAULT NULL,
  `fk_currency` varchar(3) DEFAULT NULL,
  `fk_cond_reglement` int DEFAULT NULL,
  `deposit_percent` varchar(63) DEFAULT NULL,
  `fk_mode_reglement` int DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `date_livraison` date DEFAULT NULL,
  `fk_shipping_method` int DEFAULT NULL,
  `fk_warehouse` int DEFAULT NULL,
  `fk_availability` int DEFAULT NULL,
  `fk_input_reason` int DEFAULT NULL,
  `fk_incoterms` int DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `fk_delivery_address` int DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `online_sign_ip` varchar(48) DEFAULT NULL,
  `online_sign_name` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_propal_ref` (`ref`,`entity`),
  KEY `idx_propal_fk_soc` (`fk_soc`),
  KEY `idx_propal_fk_user_author` (`fk_user_author`),
  KEY `idx_propal_fk_user_valid` (`fk_user_valid`),
  KEY `idx_propal_fk_user_cloture` (`fk_user_cloture`),
  KEY `idx_propal_fk_projet` (`fk_projet`),
  KEY `idx_propal_fk_account` (`fk_account`),
  KEY `idx_propal_fk_currency` (`fk_currency`),
  KEY `idx_propal_fk_warehouse` (`fk_warehouse`),
  KEY `fk_propal_fk_user_signature` (`fk_user_signature`),
  CONSTRAINT `fk_propal_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_propal_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_propal_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_propal_fk_user_cloture` FOREIGN KEY (`fk_user_cloture`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_propal_fk_user_signature` FOREIGN KEY (`fk_user_signature`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_propal_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=latin1;

INSERT INTO `llx_propal` VALUES("1","PR1902-0001","1",NULL,NULL,"","4",NULL,"2019-02-01 18:21:06","2019-02-01 18:21:06","2019-02-01","2019-02-16 12:00:00","2019-02-01 18:21:40",NULL,NULL,"1",NULL,"1",NULL,NULL,"1","0",NULL,NULL,"0","400.00000000","0.00000000","0.00000000","0.00000000","400.00000000",NULL,NULL,"1",NULL,NULL,"","","azur","propale/PR1902-0001/PR1902-0001.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","400.00000000","0.00000000","400.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("2","PR1904-0002","1",NULL,NULL,"","2",NULL,"2019-04-15 18:07:00","2019-04-15 18:07:00","2019-04-15","2019-04-30 12:00:00","2019-04-18 15:35:26",NULL,NULL,"1",NULL,"1",NULL,NULL,"1","0",NULL,NULL,"0","2808.70000000","0.00000000","0.00000000","0.00000000","2808.70000000",NULL,NULL,"1",NULL,NULL,"","","azur","propale/PR1904-0002/PR1904-0002.pdf","2019-04-15",NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","2808.70000000","0.00000000","2808.70000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("3","PR1909-0003","1",NULL,NULL,"","5",NULL,"2019-08-22 11:00:31","2019-08-22 11:00:31","2019-08-22","2019-09-06 12:00:00","2019-09-13 11:45:40",NULL,NULL,"1",NULL,"1",NULL,NULL,"1","0",NULL,NULL,"0","240.00000000","0.00000000","0.00000000","0.00000000","240.00000000",NULL,NULL,"1",NULL,NULL,"","","azur","propale/PR1909-0003/PR1909-0003.pdf","2019-08-22",NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","240.00000000","0.00000000","240.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("4","PR2008-0004","1",NULL,NULL,"","11",NULL,"2020-08-06 17:54:39","2020-08-06 17:54:39","2020-08-06","2020-08-21 12:00:00","2020-10-19 10:27:31","2020-10-19 10:27:49","2020-10-19 10:27:49","1","1","1","1","1","2","0",NULL,NULL,"0","660.00000000","0.00000000","0.00000000","0.00000000","660.00000000",NULL,NULL,"1",NULL,NULL,"","Règlement de 850€ à la signature et 850€ à la mise en ligne du site.","azur","propale/PR2008-0004/PR2008-0004.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","660.00000000","0.00000000","660.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("5","PR2008-0005","1",NULL,NULL,"","11",NULL,"2020-08-18 10:45:24","2020-08-18 10:45:24","2020-08-18","2020-09-02 10:45:24","2020-08-18 11:00:09","2020-08-21 16:57:44","2020-08-21 16:57:44","1",NULL,"1","1","1","2","0",NULL,NULL,"0","1700.00000000","0.00000000","0.00000000","0.00000000","1700.00000000",NULL,NULL,"1",NULL,NULL,"","Règlement de 300€ à la signature et 360€ à la mise en ligne du site.","azur","propale/PR2008-0005/PR2008-0005.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","1700.00000000","0.00000000","1700.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("6","PR2009-0006","1",NULL,NULL,"","12",NULL,"2020-09-11 09:26:33","2020-09-11 09:26:33","2020-09-11","2020-09-26 12:00:00","2020-09-11 09:29:03",NULL,NULL,"1",NULL,"1",NULL,NULL,"1","0",NULL,NULL,"0","95.00000000","0.00000000","0.00000000","0.00000000","95.00000000",NULL,NULL,"1",NULL,NULL,"","","azur","propale/PR2009-0006/PR2009-0006.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","95.00000000","0.00000000","95.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("7","PR2011-0007","1",NULL,NULL,"","14",NULL,"2020-11-04 12:26:26","2020-11-04 12:26:26","2020-11-04","2020-12-04 12:00:00","2020-11-04 20:37:55",NULL,NULL,"1",NULL,"1",NULL,NULL,"1","0",NULL,NULL,"0","4040.00000000","0.00000000","0.00000000","0.00000000","4040.00000000",NULL,NULL,"1",NULL,"7","","","azur","propale/PR2011-0007/PR2011-0007.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","4040.00000000","0.00000000","4040.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("8","PR2102-0008","1",NULL,NULL,"","15",NULL,"2021-02-18 17:37:48","2021-02-18 17:37:48","2021-02-18","2021-03-05 17:37:48","2021-02-18 18:49:17",NULL,NULL,"1",NULL,"1",NULL,NULL,"1","0",NULL,NULL,"0","1343.06000000","0.00000000","0.00000000","0.00000000","1343.06000000",NULL,NULL,NULL,NULL,NULL,"","Règlement de 300€ à la signature et 360€ à la mise en ligne du site.","azur","propale/PR2102-0008/PR2102-0008.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","1343.06000000","0.00000000","1343.06000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("9","PR2105-0009","1",NULL,NULL,"","16",NULL,"2021-05-03 19:54:04","2021-05-03 19:54:04","2021-05-03","2021-05-18 12:00:00","2021-05-04 13:43:13","2021-09-20 18:27:32","2021-09-20 18:27:32","1","1","1","1","1","2","0",NULL,NULL,"0","2980.00000000","0.00000000","0.00000000","0.00000000","2980.00000000",NULL,NULL,"1",NULL,NULL,"","La somme de 200 € sera déduite sur la facture après acceptation.","azur","propale/PR2105-0009/PR2105-0009.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","2980.00000000","0.00000000","2980.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("10","PR2108-0010","1",NULL,NULL,"","17",NULL,"2021-08-02 09:00:27","2021-08-02 09:00:27","2021-08-02","2021-08-17 12:00:00","2021-08-02 09:01:24",NULL,NULL,"1",NULL,"1",NULL,NULL,"1","0",NULL,NULL,"0","1.00000000","0.00000000","0.00000000","0.00000000","1.00000000",NULL,NULL,"1",NULL,NULL,"","","azur","propale/PR2108-0010/PR2108-0010.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","1.00000000","0.00000000","1.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("11","PR2109-0011","1",NULL,NULL,"","18",NULL,"2021-09-25 15:30:34","2021-09-25 15:30:34","2021-09-25","2021-10-10 12:00:00","2021-09-25 15:32:59","2022-06-13 11:26:08","2022-06-13 11:26:08","1",NULL,"1","1","1","2","0",NULL,NULL,"0","78.00000000","0.00000000","0.00000000","0.00000000","78.00000000",NULL,NULL,"1",NULL,"7","","","azur","propale/PR2109-0011/PR2109-0011.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","78.00000000","0.00000000","78.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("12","PR2204-0012","1",NULL,NULL,"","21",NULL,"2022-04-04 16:36:00","2022-04-04 16:36:00","2022-04-04","2022-04-19 12:00:00","2022-10-27 17:07:54","2022-10-27 17:08:28","2022-10-27 17:08:28","1","1","1","1","1","2","0",NULL,NULL,"0","1100.00000000","0.00000000","0.00000000","0.00000000","1100.00000000",NULL,NULL,"1",NULL,NULL,"Règlements : 600 € à la signature de devis puis 500 € a la mise en ligne","Règlements : 600 € à la signature de devis puis 500 € a la mise en ligne.","azur","propale/PR2204-0012/PR2204-0012.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","1100.00000000","0.00000000","1100.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("13","(PROV13)","1",NULL,NULL,"","22",NULL,"2022-09-30 15:58:28","2022-09-30 15:58:28","2022-09-30","2022-10-15 12:00:00",NULL,NULL,NULL,"1",NULL,NULL,NULL,NULL,"0","0",NULL,NULL,"0","567.99000000","0.00000000","0.00000000","0.00000000","567.99000000",NULL,NULL,"1",NULL,NULL,"","","azur","propale/(PROV13)/(PROV13).pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","567.99000000","0.00000000","567.99000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("14","PR2209-0013","1",NULL,NULL,"","22",NULL,"2022-09-30 16:04:53","2022-09-30 16:04:53","2022-09-30","2022-10-15 16:04:53","2022-09-30 18:39:22","2022-11-25 18:32:13","2022-11-25 18:32:13","1",NULL,"1","1","1","2","0",NULL,NULL,"0","716.99000000","0.00000000","0.00000000","0.00000000","716.99000000",NULL,NULL,"1",NULL,NULL,"","","azur","propale/PR2209-0013/PR2209-0013.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","716.99000000","0.00000000","716.99000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("15","PR2305-0014","1",NULL,NULL,"","16",NULL,"2023-05-26 13:38:38","2023-05-26 13:38:38","2023-05-26","2023-06-10 12:00:00","2023-05-26 13:40:37","2023-06-05 20:01:08","2023-06-05 20:01:08","1",NULL,"1","1","1","2","0",NULL,NULL,"0","30.00000000","0.00000000","0.00000000","0.00000000","30.00000000",NULL,NULL,"1",NULL,NULL,"","","azur","propale/PR2305-0014/PR2305-0014.pdf","2023-05-26",NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("16","PR2306-0015","1",NULL,NULL,"","4",NULL,"2023-05-31 00:28:22","2023-05-31 00:28:22","2023-05-31","2023-06-15 12:00:00","2023-06-02 17:30:02","2023-06-02 17:30:18","2023-06-02 17:30:18","1",NULL,"1","1","1","2","0",NULL,NULL,"0","800.00000000","0.00000000","0.00000000","0.00000000","800.00000000",NULL,NULL,"1",NULL,"54","","","azur","propale/PR2306-0015/PR2306-0015.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","800.00000000","0.00000000","800.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("17","PR2309-0016","1",NULL,NULL,"","23",NULL,"2023-09-18 17:58:55","2023-09-18 17:58:55","2023-09-18","2023-10-03 12:00:00","2023-09-18 18:05:40","2023-09-18 18:11:28","2023-09-18 18:11:28","1",NULL,"1","1","1","2","0",NULL,NULL,"0","800.00000000","0.00000000","0.00000000","0.00000000","800.00000000",NULL,NULL,"1",NULL,NULL,"","","azur","propale/PR2309-0016/PR2309-0016.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","800.00000000","0.00000000","800.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("18","PR2402-0017","1",NULL,NULL,"","24",NULL,"2024-02-02 09:24:59","2024-02-02 09:24:59","2024-01-01","2024-02-17 12:00:00","2024-02-02 09:27:53","2024-02-02 09:28:14","2024-02-02 09:28:14","1",NULL,"1","1","1","2","0",NULL,NULL,"0","300.00000000","0.00000000","0.00000000","0.00000000","300.00000000",NULL,NULL,"1",NULL,NULL,"","","azur","propale/PR2402-0017/PR2402-0017.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","300.00000000","0.00000000","300.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("19","PR2404-0018","1","",NULL,"","16",NULL,NULL,"2024-04-10 19:06:37","2024-04-10","2024-04-25 12:00:00","2024-04-10 19:10:31","2024-04-11 15:12:40",NULL,"1",NULL,"1","1",NULL,"2","0","0","0","0","35.00000000","0.00000000","0.00000000","0.00000000","35.00000000",NULL,NULL,NULL,NULL,NULL,"","","azur","propale/PR2404-0018/PR2404-0018.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","35.00000000","0.00000000","35.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("20","PR2408-0019","1","",NULL,"","25",NULL,NULL,"2024-08-09 16:55:21","2024-08-09","2024-08-24 12:00:00","2024-08-09 17:06:30","2024-08-09 17:06:48",NULL,"1",NULL,"1","1",NULL,"2","0","0","0","0","1500.00000000","0.00000000","0.00000000","0.00000000","1500.00000000",NULL,NULL,NULL,NULL,NULL,"","","azur","propale/PR2408-0019/PR2408-0019.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","1500.00000000","0.00000000","1500.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("21","PR2409-0020","1","",NULL,"","16",NULL,NULL,"2024-09-21 19:13:53","2024-09-21","2024-10-06 12:00:00","2024-09-21 19:16:02","2024-10-05 10:24:50",NULL,"1",NULL,"1","1",NULL,"2","0","0","0","0","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000",NULL,NULL,NULL,NULL,NULL,"","","azur","propale/PR2409-0020/PR2409-0020.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","50.00000000","0.00000000","50.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("22","PR2410-0021","1","",NULL,"pla","4",NULL,NULL,"2024-10-05 10:43:48","2024-10-05","2024-10-20 12:00:00","2024-10-05 10:48:08","2024-10-05 10:48:21",NULL,"1",NULL,"1","1",NULL,"2","0","0","0","0","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000",NULL,NULL,NULL,NULL,NULL,"","","azur","propale/PR2410-0021/PR2410-0021.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","50.00000000","0.00000000","50.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("23","PR2410-0022","1","",NULL,"sli","10",NULL,NULL,"2024-10-11 18:33:17","2024-10-11","2024-10-26 12:00:00","2024-10-11 20:30:31","2024-10-12 17:34:40",NULL,"1",NULL,"1","1",NULL,"2","0","0","0","0","120.00000000","0.00000000","0.00000000","0.00000000","120.00000000",NULL,NULL,NULL,NULL,NULL,"","","azur","propale/PR2410-0022/PR2410-0022.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","120.00000000","0.00000000","120.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("24","(PROV24)","1","",NULL,"","5",NULL,NULL,"2024-11-19 10:00:32","2024-11-19","2024-12-04 10:00:32",NULL,NULL,NULL,"1",NULL,NULL,NULL,NULL,"0","0","0","0","0","760.00000000","0.00000000","0.00000000","0.00000000","760.00000000",NULL,NULL,NULL,NULL,NULL,"","La somme de 200 € sera déduite sur la facture après acceptation.","azur","propale/(PROV24)/(PROV24).pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","760.00000000","0.00000000","760.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("25","(PROV25)","1","",NULL,"","5",NULL,NULL,"2024-11-19 10:09:40","2024-11-19","2024-12-04 12:00:00",NULL,NULL,NULL,"1",NULL,NULL,NULL,NULL,"0","0","0","0","0","782.00000000","0.00000000","0.00000000","0.00000000","782.00000000",NULL,NULL,NULL,NULL,"7","","","azur","propale/(PROV25)/(PROV25).pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","782.00000000","0.00000000","782.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("26","(PROV26)","1","",NULL,"","5",NULL,NULL,"2024-11-19 10:38:27","2024-11-19","2024-12-04 12:00:00",NULL,NULL,NULL,"1",NULL,NULL,NULL,NULL,"0","0","0","0","0","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000",NULL,NULL,NULL,NULL,"7","","","azur","propale/(PROV26)/(PROV26).pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","200.00000000","0.00000000","200.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("27","PR2412-0023","1","",NULL,"","24",NULL,NULL,"2024-12-09 18:51:26","2024-12-09","2024-12-24 18:51:26","2024-12-10 10:39:03","2024-12-10 10:39:16",NULL,"1",NULL,"1","1",NULL,"2","0","0","0","0","300.00000000","0.00000000","0.00000000","0.00000000","300.00000000",NULL,NULL,"1",NULL,NULL,"","","azur","propale/PR2412-0023/PR2412-0023.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","300.00000000","0.00000000","300.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("28","PR2412-0024","1","",NULL,"","24",NULL,NULL,"2024-12-20 15:54:26","2024-12-20","2025-01-04 15:54:26","2024-12-20 15:58:39","2024-12-20 15:58:52",NULL,"1",NULL,"1","1",NULL,"2","0","0","0","0","90.00000000","0.00000000","0.00000000","0.00000000","90.00000000",NULL,NULL,"1",NULL,NULL,"","","azur","propale/PR2412-0024/PR2412-0024.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","90.00000000","0.00000000","90.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("29","(PROV29)","1","",NULL,"","10",NULL,NULL,"2025-02-03 19:54:29","2025-02-03","2025-02-18 12:00:00",NULL,NULL,NULL,"1",NULL,NULL,NULL,NULL,"0","0","0","0","0","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000",NULL,NULL,NULL,NULL,NULL,"","","azur","propale/(PROV29)/(PROV29).pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","0.00000000","0.00000000","0.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("31","PR2503-0025","1","",NULL,"","26",NULL,NULL,"2025-03-04 19:42:27","2025-03-04","2025-03-19 19:42:27","2025-03-04 19:56:35",NULL,NULL,"1","1","1",NULL,NULL,"1","0","0","0","0","700.00000000","0.00000000","0.00000000","0.00000000","700.00000000",NULL,NULL,NULL,NULL,NULL,"","Règlement de 350€ à la signature et 350€ à la mise en ligne du site.","azur","propale/PR2503-0025/PR2503-0025.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","700.00000000","0.00000000","700.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("32","PR2503-0026","1","",NULL,"","16",NULL,NULL,"2025-03-31 08:12:41","2025-03-31","2025-04-15 12:00:00","2025-03-31 08:14:44","2025-04-10 19:48:11",NULL,"1",NULL,"1","1",NULL,"2","0","0","0","0","35.00000000","0.00000000","0.00000000","0.00000000","35.00000000",NULL,NULL,NULL,NULL,NULL,"","","azur","propale/PR2503-0026/PR2503-0026.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","35.00000000","0.00000000","35.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("33","PR2506-0027","1","",NULL,"","4",NULL,NULL,"2025-06-11 10:09:21","2025-06-11","2025-06-26 12:00:00","2025-06-11 19:47:07",NULL,NULL,"1",NULL,"1",NULL,NULL,"1","0","0","0","0","120.00000000","0.00000000","0.00000000","0.00000000","120.00000000",NULL,NULL,NULL,NULL,NULL,"","","azur","propale/PR2506-0027/PR2506-0027.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","120.00000000","0.00000000","120.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("35","PR2506-0028","1","",NULL,"","27",NULL,NULL,"2025-06-24 19:33:56","2025-06-24","2025-07-09 12:00:00","2025-06-24 19:36:27","2025-06-24 19:36:36",NULL,"1",NULL,"1","1",NULL,"2","0","0","0","0","110.00000000","0.00000000","0.00000000","0.00000000","110.00000000",NULL,NULL,NULL,NULL,NULL,"","","azur","propale/PR2506-0028/PR2506-0028.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","110.00000000","0.00000000","110.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("36","(PROV36)","1","",NULL,"","28",NULL,NULL,"2025-07-04 10:30:23","2025-07-04","2025-07-19 12:00:00",NULL,NULL,NULL,"1",NULL,NULL,NULL,NULL,"0","0","0","0","0","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000",NULL,NULL,NULL,NULL,NULL,"","","azur","propale/(PROV36)/(PROV36).pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","0.00000000","0.00000000","0.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("37","PR2507-0029","1","",NULL,"","28",NULL,NULL,"2025-07-04 10:31:39","2025-07-04","2025-07-19 10:31:39","2025-07-23 19:50:32","2025-09-02 16:31:28",NULL,"1",NULL,"1","1",NULL,"2","0","0","0","0","1488.00000000","0.00000000","0.00000000","0.00000000","1488.00000000",NULL,NULL,NULL,NULL,NULL,"","","azur","propale/PR2507-0029/PR2507-0029.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","1488.00000000","0.00000000","1488.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("38","PR2508-0030","1","",NULL,"","11",NULL,NULL,"2025-08-05 08:32:45","2025-08-05","2025-08-20 08:32:45","2025-08-05 10:43:27","2025-08-06 08:36:20",NULL,"1","1","1",NULL,NULL,"2","0","0","0","0","600.00000000","0.00000000","0.00000000","0.00000000","600.00000000",NULL,NULL,NULL,NULL,NULL,"","Règlement : 300 € à ma signature du devis et 300€ à la livraison","azur","propale/PR2508-0030/PR2508-0030.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","600.00000000","0.00000000","600.00000000","2001:861:2cc0:870:6976:6a1e:2b7a:2b4a","Garbage Philippe");
INSERT INTO `llx_propal` VALUES("39","(PROV39)","1","",NULL,"","29",NULL,NULL,"2025-10-19 20:16:28","2025-10-19","2025-11-03 11:00:00",NULL,NULL,NULL,"1",NULL,NULL,NULL,NULL,"0","0","0","0","0","1400.00000000","0.00000000","0.00000000","0.00000000","1400.00000000",NULL,NULL,NULL,NULL,NULL,"","","azur","propale/(PROV39)/(PROV39).pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","1400.00000000","0.00000000","1400.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("40","PR2511-0031","1","",NULL,NULL,"30",NULL,NULL,"2025-11-27 10:58:19","2025-11-27","2025-12-12 12:00:00","2025-11-27 11:11:45",NULL,NULL,"1",NULL,"1",NULL,NULL,"0","0","0","0","0","600.00000000","0.00000000","0.00000000","0.00000000","600.00000000",NULL,NULL,NULL,NULL,NULL,"","","azur","propale/PR2511-0031/PR2511-0031.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","600.00000000","0.00000000","600.00000000",NULL,NULL);
INSERT INTO `llx_propal` VALUES("41","PR2512-0032","1","",NULL,"","16",NULL,NULL,"2025-12-11 23:35:26","2025-12-11","2025-12-26 12:00:00","2025-12-11 23:37:49","2025-12-15 19:55:28",NULL,"1",NULL,"1","1",NULL,"2","0","0","0","0","30.00000000","0.00000000","0.00000000","0.00000000","30.00000000",NULL,NULL,NULL,NULL,NULL,"","","azur","propale/PR2512-0032/PR2512-0032.pdf",NULL,NULL,NULL,"0","0","0","",NULL,NULL,NULL,"0","EUR","1.00000000","30.00000000","0.00000000","30.00000000",NULL,NULL);



DROP TABLE IF EXISTS `llx_propal_extrafields`;
CREATE TABLE `llx_propal_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_propal_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_propal_merge_pdf_product`;
CREATE TABLE `llx_propal_merge_pdf_product` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_product` int NOT NULL,
  `file_name` varchar(200) NOT NULL,
  `lang` varchar(5) DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_mod` int NOT NULL,
  `datec` datetime NOT NULL,
  `tms` timestamp NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_propaldet`;
CREATE TABLE `llx_propaldet` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_propal` int NOT NULL,
  `fk_parent_line` int DEFAULT NULL,
  `fk_product` int DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `fk_remise_except` int DEFAULT NULL,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT '0.000',
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `remise_percent` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `price` double DEFAULT NULL,
  `subprice` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `product_type` int DEFAULT '0',
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `info_bits` int DEFAULT '0',
  `buy_price_ht` double(24,8) DEFAULT '0.00000000',
  `fk_product_fournisseur_price` int DEFAULT NULL,
  `special_code` int DEFAULT '0',
  `rang` int DEFAULT '0',
  `fk_unit` int DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_propaldet_fk_propal` (`fk_propal`),
  KEY `idx_propaldet_fk_product` (`fk_product`),
  KEY `fk_propaldet_fk_unit` (`fk_unit`),
  CONSTRAINT `fk_propaldet_fk_propal` FOREIGN KEY (`fk_propal`) REFERENCES `llx_propal` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_propaldet_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=164 DEFAULT CHARSET=latin1;

INSERT INTO `llx_propaldet` VALUES("1","1",NULL,"4",NULL,"",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"400.00000000","400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","400.00000000","400.00000000","0.00000000","400.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("2","2",NULL,NULL,NULL,"EBP Gestion Commerciale PRO 2019\r\n\r\nmonoposte\r\nNombre de postes ou utilisateurs: 1",NULL,"","0.000","0.000","0","0.000","0","1","15","0",NULL,"630.00000000","535.50000000","0.00000000","0.00000000","0.00000000","535.50000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","630.00000000","535.50000000","0.00000000","535.50000000",NULL);
INSERT INTO `llx_propaldet` VALUES("3","2",NULL,NULL,NULL,"Service PRIVILEGE EBP Gestion\r\nCommerciale PRO monoposte inclus\r\nmodule\r\nGammes Pro\r\nNombre de postes ou utilisateurs: 1",NULL,"","0.000","0.000","0","0.000","0","1","15","0",NULL,"612.00000000","520.20000000","0.00000000","0.00000000","0.00000000","520.20000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","612.00000000","520.20000000","0.00000000","520.20000000",NULL);
INSERT INTO `llx_propaldet` VALUES("4","2",NULL,NULL,NULL,"Connecteur Vaisonet\r\nEBP / Prestashop / B2B",NULL,"","0.000","0.000","0","0.000","0","1","0","0","1090","1090.00000000","1090.00000000","0.00000000","0.00000000","0.00000000","1090.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","1090.00000000","1090.00000000","0.00000000","1090.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("5","2",NULL,NULL,NULL,"Maintenance et assistance par email et téléphone (1 an)",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"540.00000000","540.00000000","0.00000000","0.00000000","0.00000000","540.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","540.00000000","540.00000000","0.00000000","540.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("6","2",NULL,NULL,NULL,"ZC465801 USB Noir - Jaune 2.0 Handheld Barcode Reader, barres laser scanner de code pour PC POS",NULL,"","0.000","0.000","0","0.000","0","0","0","0",NULL,"23.00000000","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"3","5",NULL,NULL,"EUR","23.00000000","0.00000000","0.00000000","0.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("7","2",NULL,NULL,NULL,"Imprimante de tickets Epson TM-T20II ",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"123.00000000","123.00000000","0.00000000","0.00000000","0.00000000","123.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","6",NULL,NULL,"EUR","123.00000000","123.00000000","0.00000000","123.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("8","3",NULL,NULL,NULL,"Sauvegarde du site internet",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("9","3",NULL,NULL,NULL,"Mise à jour du site ecommerce",NULL,"","0.000","0.000","0","0.000","0","1","0","0","90","90.00000000","90.00000000","0.00000000","0.00000000","0.00000000","90.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","90.00000000","90.00000000","0.00000000","90.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("10","3",NULL,NULL,NULL,"Installation du certificat de sécurité https",NULL,"","0.000","0.000","0","0.000","0","1","0","0","50","50.00000000","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("11","3",NULL,NULL,NULL,"Installation du module RGPD",NULL,"","0.000","0.000","0","0.000","0","1","0","0","40","40.00000000","40.00000000","0.00000000","0.00000000","0.00000000","40.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","40.00000000","40.00000000","0.00000000","40.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("12","3",NULL,NULL,NULL,"Installation du module information clients sur l\'utilisation des cookies ",NULL,"","0.000","0.000","0","0.000","0","1","0","0","30","30.00000000","30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","5",NULL,NULL,"EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("13","3",NULL,NULL,NULL,"Blocage des inscriptions de faux clients.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000","30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","6",NULL,NULL,"EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("14","4",NULL,NULL,NULL,"Mise à jour de votre site joomla ",NULL,"","0.000","0.000","0","0.000","0","1","0","0","150","150.00000000","150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","150.00000000","150.00000000","0.00000000","150.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("15","4",NULL,NULL,NULL,"Mise à jour du module Hikashop",NULL,"","0.000","0.000","0","0.000","0","1","0","0","110","110.00000000","110.00000000","0.00000000","0.00000000","0.00000000","110.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","110.00000000","110.00000000","0.00000000","110.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("16","4",NULL,NULL,NULL,"Modification Thème",NULL,"","0.000","0.000","0","0.000","0","1","0","0","200","200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("17","4",NULL,NULL,NULL,"Modification du contenu pour un meilleur référencement sur les moteurs de recherches.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","150","150.00000000","150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","150.00000000","150.00000000","0.00000000","150.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("18","4",NULL,NULL,NULL,"Installation d\'un outils de sauvegardes du site et sauvegarde avant et après mon intervention.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","50","50.00000000","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","5",NULL,NULL,"EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("24","5",NULL,NULL,NULL,"Installation du site ecommerce Prestashop et Configuration. Installation du thème et ajustements. Import et ajout des produits et photos produits. Paramétrage des modes de livraisons et tarifs. installation et tests des modes de payements. Ajout des pages informations pour les hébergements. Amélioration des contenues pour un meilleur réferencement des moteurs de recherches. ",NULL,"","0.000","0.000","0","0.000","0","1","0","0","1700","1700.00000000","1700.00000000","0.00000000","0.00000000","0.00000000","1700.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","1700.00000000","1700.00000000","0.00000000","1700.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("25","5",NULL,NULL,NULL,"Sauvegarde de votre ancien site.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("26","5",NULL,NULL,NULL,"Mise en ligne du site ecommerce.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("27","6",NULL,NULL,NULL,"Dépannage du site internet : Problèmes d\'accès au site internet.\r\nFacturation uniquement sur résultats.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"95.00000000","95.00000000","0.00000000","0.00000000","0.00000000","95.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","95.00000000","95.00000000","0.00000000","95.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("28","7",NULL,NULL,NULL,"Installation du site ecommerce Prestashop",NULL,"","0.000","0.000","0","0.000","0","1","0","0","690","690.00000000","690.00000000","0.00000000","0.00000000","0.00000000","690.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","690.00000000","690.00000000","0.00000000","690.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("29","7",NULL,NULL,NULL,"Configuration de la solution ecommerce",NULL,"","0.000","0.000","0","0.000","0","1","0","0","540","540.00000000","540.00000000","0.00000000","0.00000000","0.00000000","540.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","540.00000000","540.00000000","0.00000000","540.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("30","7",NULL,NULL,NULL,"Installation du thème et ajustements",NULL,"","0.000","0.000","0","0.000","0","1","0","0","490","490.00000000","490.00000000","0.00000000","0.00000000","0.00000000","490.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","490.00000000","490.00000000","0.00000000","490.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("31","7",NULL,NULL,NULL,"Import et ajout des produits et photos produits",NULL,"","0.000","0.000","0","0.000","0","1","0","0","400","400.00000000","400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","400.00000000","400.00000000","0.00000000","400.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("32","7",NULL,NULL,NULL,"Paramétrage des modes de livraisons et tarifs.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","290","290.00000000","290.00000000","0.00000000","0.00000000","0.00000000","290.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","5",NULL,NULL,"EUR","290.00000000","290.00000000","0.00000000","290.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("33","7",NULL,NULL,NULL,"Installation et tests des modes de payements",NULL,"","0.000","0.000","0","0.000","0","1","0","0","250","250.00000000","250.00000000","0.00000000","0.00000000","0.00000000","250.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","6",NULL,NULL,"EUR","250.00000000","250.00000000","0.00000000","250.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("34","7",NULL,NULL,NULL,"Amélioration des contenues pour un meilleur référencement des moteurs de recherches.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","450","450.00000000","450.00000000","0.00000000","0.00000000","0.00000000","450.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","7",NULL,NULL,"EUR","450.00000000","450.00000000","0.00000000","450.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("35","7",NULL,NULL,NULL,"Formation à la gestion des nouvelles commandes & gestion des produits",NULL,"","0.000","0.000","0","0.000","0","1","0","0","390","390.00000000","390.00000000","0.00000000","0.00000000","0.00000000","390.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","8",NULL,NULL,"EUR","390.00000000","390.00000000","0.00000000","390.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("36","7",NULL,NULL,NULL,"Installation et paramétrage du module de location de produits.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","540","540.00000000","540.00000000","0.00000000","0.00000000","0.00000000","540.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","9",NULL,NULL,"EUR","540.00000000","540.00000000","0.00000000","540.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("37","8",NULL,NULL,NULL,"Installation du site et Configuration. Installation du thème et ajustements. \r\nAjout des pages de présentation du restaurant (Salles, etc) \r\nAjout du menu (entrées, plats, desserts, boissons ...)\r\nFormulaire de réservation.\r\nAjout des produits pour la vente avec photos et tarifs.\r\nParamétrage des modes payements ou payement à la livraisons\r\nInstallation et tests des modes de payements. \r\nAjout des pages informations pour la vente en ligne.\r\nAmélioration des contenues pour un meilleur référencement des moteurs de recherches (google)",NULL,"","0.000","0.000","0","0.000","0","1","0","0","800","800.00000000","800.00000000","0.00000000","0.00000000","0.00000000","800.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","800.00000000","800.00000000","0.00000000","800.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("38","8",NULL,NULL,NULL,"Installation du module Click and Collect \r\nLes clients choisissent l\'heure de retrait dans les heures d\'ouvertures et la commande s\'imprime automatiquement sur votre imprimante à reçu.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","500","500.00000000","500.00000000","0.00000000","0.00000000","0.00000000","500.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","500.00000000","500.00000000","0.00000000","500.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("39","8",NULL,NULL,NULL,"Nom de domaine et Hébergement (exemple : www.darbaba.fr ou www.restaurant-darbaba.fr)\r\nCe nom de domaine vous appartient il faut le payer tout les ans à l\'hébergeur de votre site web. ",NULL,"","0.000","0.000","0","0.000","0","1","0","0","43.06","43.06000000","43.06000000","0.00000000","0.00000000","0.00000000","43.06000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","43.06000000","43.06000000","0.00000000","43.06000000",NULL);
INSERT INTO `llx_propaldet` VALUES("40","9",NULL,NULL,NULL,"Sauvegarde du site internet",NULL,"","0.000","0.000","0","0.000","0","1","0","0","50","50.00000000","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("41","9",NULL,NULL,NULL,"Installation sur le serveur test et parametrages.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","120","120.00000000","120.00000000","0.00000000","0.00000000","0.00000000","120.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","120.00000000","120.00000000","0.00000000","120.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("42","9",NULL,NULL,NULL,"Installation de la version de prestashop cible 1,7 ",NULL,"","0.000","0.000","0","0.000","0","1","0","0","90","90.00000000","90.00000000","0.00000000","0.00000000","0.00000000","90.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","90.00000000","90.00000000","0.00000000","90.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("43","9",NULL,NULL,NULL,"Désactivation des modules non compatible avec la version cible.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","5",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("44","9",NULL,NULL,NULL,"Migrations des données sur la nouvelles installation cible. (produits, images, déclinaisons, clients, et ancienne factures si possible)",NULL,"","0.000","0.000","0","0.000","0","1","0","0","1100","1100.00000000","1100.00000000","0.00000000","0.00000000","0.00000000","1100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","6",NULL,NULL,"EUR","1100.00000000","1100.00000000","0.00000000","1100.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("45","9",NULL,NULL,NULL,"Configuration des moyens de transport et tarifs",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","7",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("46","9",NULL,NULL,NULL,"Configurations des moyens de payements",NULL,"","0.000","0.000","0","0.000","0","1","0","0","600","600.00000000","600.00000000","0.00000000","0.00000000","0.00000000","600.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","8",NULL,NULL,"EUR","600.00000000","600.00000000","0.00000000","600.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("47","9",NULL,NULL,NULL,"Installation du thème choisi par le client",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"120.00000000","120.00000000","0.00000000","0.00000000","0.00000000","120.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","9",NULL,NULL,"EUR","120.00000000","120.00000000","0.00000000","120.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("48","9",NULL,NULL,NULL,"Installations des modules déjà acquis.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","10",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("49","9",NULL,NULL,NULL,"Vérification complète  du bon fonctionnement avant mise en ligne ",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","11",NULL,NULL,"EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("50","9",NULL,NULL,NULL,"Changement de la version de php  (langage de prestashop) sur le serveur et mise en ligne du site en version 1.7",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","12",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("51","9",NULL,NULL,NULL,"Vérification complète du bon fonctionnement du site en production.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","13",NULL,NULL,"EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("52","10",NULL,NULL,NULL,"test",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"1.00000000","1.00000000","0.00000000","0.00000000","0.00000000","1.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","1.00000000","1.00000000","0.00000000","1.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("53","11",NULL,NULL,NULL,"Intervention sur le site internet pour rétablir la connexion à la base de donnée.  ",NULL,"","0.000","0.000","0","0.000","0","1","0","0","78","78.00000000","78.00000000","0.00000000","0.00000000","0.00000000","78.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","78.00000000","78.00000000","0.00000000","78.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("54","12",NULL,NULL,NULL,"Installation d\'une solution e-Commerce pour la vente en ligne d\'objets personnalisés.\r\ninstallation et paramétrage du module e-Commerce  \r\nAmélioration du thème\r\nInstallation et paramétrage  du  module de personnalisation.\r\nAjout de 4 produits\r\nParamétrage du moyen de payement et vérification du site.\r\nFormation a la gestion des commandes et ajout de produits.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","1100","1100.00000000","1100.00000000","0.00000000","0.00000000","0.00000000","1100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","1100.00000000","1100.00000000","0.00000000","1100.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("55","13",NULL,"3",NULL,"",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"7.99000000","7.99000000","0.00000000","0.00000000","0.00000000","7.99000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","7.99000000","7.99000000","0.00000000","7.99000000",NULL);
INSERT INTO `llx_propaldet` VALUES("56","13",NULL,NULL,NULL,"Installation du site vitrine sur les bases du site existant.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"500.00000000","500.00000000","0.00000000","0.00000000","0.00000000","500.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","500.00000000","500.00000000","0.00000000","500.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("57","13",NULL,NULL,NULL,"Installation du certificat de s&eacute;curit&eacute; https",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000","30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("58","13",NULL,NULL,NULL,"Ajout de nouveaus contenus au site et modifications",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000","30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("59","14",NULL,"3",NULL,"",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"7.99000000","7.99000000","0.00000000","0.00000000","0.00000000","7.99000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","7.99000000","7.99000000","0.00000000","7.99000000",NULL);
INSERT INTO `llx_propaldet` VALUES("60","14",NULL,NULL,NULL,"Installation du site vitrine sur les bases du site existant.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","649","649.00000000","649.00000000","0.00000000","0.00000000","0.00000000","649.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","649.00000000","649.00000000","0.00000000","649.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("61","14",NULL,NULL,NULL,"Installation du certificat de s&eacute;curit&eacute; https",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000","30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("62","14",NULL,NULL,NULL,"Ajout de nouveaus contenus au site et modifications",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000","30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("63","15",NULL,NULL,NULL,"Mise &agrave; jour du module Floa banque. conservation des param&egrave;tres",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000","30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("64","16",NULL,NULL,NULL,"Installation du site internet et param&eacute;trage",NULL,"","0.000","0.000","0","0.000","0","1","0","0","200","200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("65","16",NULL,NULL,NULL,"Installation des modules et parametrages",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("66","16",NULL,NULL,NULL,"Travail sur les elements graphiques&nbsp;",NULL,"","0.000","0.000","0","0.000","0","1","0","0","200","200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("67","16",NULL,NULL,NULL,"Mise en forme css et code javascript",NULL,"","0.000","0.000","0","0.000","0","1","0","0","100","100.00000000","100.00000000","0.00000000","0.00000000","0.00000000","100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","100.00000000","100.00000000","0.00000000","100.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("68","16",NULL,NULL,NULL,"Edition des pages et navigation du site.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","100","100.00000000","100.00000000","0.00000000","0.00000000","0.00000000","100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","5",NULL,NULL,"EUR","100.00000000","100.00000000","0.00000000","100.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("69","17",NULL,NULL,NULL,"Cr&eacute;ation d&#39;un site internet vitrine.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","350","350.00000000","350.00000000","0.00000000","0.00000000","0.00000000","350.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","350.00000000","350.00000000","0.00000000","350.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("70","17",NULL,NULL,NULL,"Installation et configuration",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"150.00000000","150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","150.00000000","150.00000000","0.00000000","150.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("71","17",NULL,NULL,NULL,"insertion des elements graphiques et de pages",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"150.00000000","150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","150.00000000","150.00000000","0.00000000","150.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("72","17",NULL,NULL,NULL,"Personnalisation du design",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"150.00000000","150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","5",NULL,NULL,"EUR","150.00000000","150.00000000","0.00000000","150.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("73","18",NULL,NULL,NULL,"Prestation pour le parametrage et la maintenance du site internet avec helloasso exercice 2023",NULL,"","0.000","0.000","0","0.000","0","1","0","0","300","300.00000000","300.00000000","0.00000000","0.00000000","0.00000000","300.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","300.00000000","300.00000000","0.00000000","300.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("74","19",NULL,NULL,NULL,"Modification de la page cat&eacute;gorie pour supprimer l&#39;affichage liste",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"35.00000000","35.00000000","0.00000000","0.00000000","0.00000000","35.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","35.00000000","35.00000000","0.00000000","35.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("75","20",NULL,NULL,NULL,"Cr&eacute;ation du nom de domaine instalation de l&#39;h&eacute;bergement et du site internet.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("76","20",NULL,NULL,NULL,"Installation et configuration de la solution de vente en ligne",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"400.00000000","400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","400.00000000","400.00000000","0.00000000","400.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("77","20",NULL,NULL,NULL,"Param&eacute;trage du th&egrave;me et modifications",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","400.00000000","400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","400.00000000","400.00000000","0.00000000","400.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("78","20",NULL,NULL,NULL,"Ajout des produits et tarifs",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","400.00000000","400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","5",NULL,NULL,"EUR","400.00000000","400.00000000","0.00000000","400.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("79","20",NULL,NULL,NULL,"Configuration de la boutique en ligne, param&eacute;trage et tests.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","100.00000000","100.00000000","0.00000000","0.00000000","0.00000000","100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","6",NULL,NULL,"EUR","100.00000000","100.00000000","0.00000000","100.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("80","21",NULL,NULL,NULL,"Installation d&#39;un module de compte a rebour fin de promotion sur la page produit.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("81","22",NULL,NULL,NULL,"Nettoyage du site internet apr&eacute;s piratage, ajout de firewall et outils de verification d&#39;integrit&eacute; du site.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","50.00000000","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("82","23",NULL,NULL,NULL,"Mise a jour du module de payement sur le site pro et particulier et test.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("83","23",NULL,NULL,NULL,"Correction du bug sur la sur la page de modification des produits",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"70.00000000","70.00000000","0.00000000","0.00000000","0.00000000","70.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","70.00000000","70.00000000","0.00000000","70.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("86","24",NULL,NULL,NULL,"Installation de la version de prestashop cible 1,7",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","60.00000000","60.00000000","0.00000000","0.00000000","0.00000000","60.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","60.00000000","60.00000000","0.00000000","60.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("88","24",NULL,NULL,NULL,"Migrations des donn&eacute;es sur la nouvelles installation cible. (produits, images, d&eacute;clinaisons, clients, et ancienne factures si possible)",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","320.00000000","320.00000000","0.00000000","0.00000000","0.00000000","320.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","320.00000000","320.00000000","0.00000000","320.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("89","24",NULL,NULL,NULL,"Configuration des moyens de transport et tarifs",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","120.00000000","120.00000000","0.00000000","0.00000000","0.00000000","120.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","120.00000000","120.00000000","0.00000000","120.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("90","24",NULL,NULL,NULL,"Configurations des moyens de payements",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","90.00000000","90.00000000","0.00000000","0.00000000","0.00000000","90.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","90.00000000","90.00000000","0.00000000","90.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("91","24",NULL,NULL,NULL,"Installation du thème choisi par le client",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"120.00000000","120.00000000","0.00000000","0.00000000","0.00000000","120.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","5",NULL,NULL,"EUR","120.00000000","120.00000000","0.00000000","120.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("95","24",NULL,NULL,NULL,"Vérification complète du bon fonctionnement du site en production.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","6",NULL,NULL,"EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("96","25",NULL,NULL,NULL,"Installation du module de relance panier, parametrage, et test.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","150.00000000","150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","150.00000000","150.00000000","0.00000000","150.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("97","25",NULL,NULL,NULL,"Installation du module de newletter, configuration et envoi de la premi&egrave;re newsletter d&#39;annonce promotion avec code promo.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","150.00000000","150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","150.00000000","150.00000000","0.00000000","150.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("98","25",NULL,NULL,NULL,"Modification des balises et descriptions pour 100 produits de la boutique afin d&#39;am&eacute;liorer le classement sur les moteurs de recherche.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("99","25",NULL,NULL,NULL,"Tarif du module de relance panier",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"170.00000000","170.00000000","0.00000000","0.00000000","0.00000000","170.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","170.00000000","170.00000000","0.00000000","170.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("100","25",NULL,NULL,NULL,"Tarif du module de newletter",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"112.00000000","112.00000000","0.00000000","0.00000000","0.00000000","112.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","5",NULL,NULL,"EUR","112.00000000","112.00000000","0.00000000","112.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("101","26",NULL,NULL,NULL,"Am&eacute;lioration du r&eacute;ferencement du site internet Tarif par mois",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("102","26",NULL,NULL,NULL,"Identifier les mots-cl&eacute;s les plus recherch&eacute;s li&eacute;s &agrave; la vape et les int&eacute;grer strat&eacute;giquement dans les pages principales du site (produits, cat&eacute;gories, blog).<br />\r\nCr&eacute;ation de contenu pertinent.<br />\r\nInt&eacute;grer des mots-cl&eacute;s secondaires pour renforcer le SEO de longue tra&icirc;ne.<br />\r\nOptimisation technique :<br />\r\nVitesse du site : S&#39;assurer que le site se charge rapidement (r&eacute;duire la taille des images, utiliser un CDN, activer la compression).<br />\r\nMobile-friendly : V&eacute;rifier que le site est parfaitement adapt&eacute; aux mobiles.<br />\r\nCorriger les erreurs SEO (liens cass&eacute;s, balises manquantes).<br />\r\nOptimiser votre fiche Google My Business pour am&eacute;liorer la visibilit&eacute; locale.<br />\r\nSuivi r&eacute;gulier avec des outils comme Google Analytics et Google Search Console<br />\r\n<br />\r\n&nbsp;",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("103","27",NULL,NULL,NULL,"Prestation pour le parametrage et la maintenance du site internet GDSA65 avec HelloAsso exercice 2024",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","300.00000000","300.00000000","0.00000000","0.00000000","0.00000000","300.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","300.00000000","300.00000000","0.00000000","300.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("104","28",NULL,NULL,NULL,"Prestation pour la pr&eacute;paration et l&#39;envoi de l&#39;invitation aux r&eacute;unions du GDSA65 (janvier 2025 et F&eacute;vrier 2025))",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","90.00000000","90.00000000","0.00000000","0.00000000","0.00000000","90.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","90.00000000","90.00000000","0.00000000","90.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("110","31",NULL,NULL,NULL,"Installation et configuration",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"150.00000000","150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","150.00000000","150.00000000","0.00000000","150.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("111","31",NULL,NULL,NULL,"Cr&eacute;ation d&#39;un site internet one page modifiable par le client",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","250.00000000","250.00000000","0.00000000","0.00000000","0.00000000","250.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","250.00000000","250.00000000","0.00000000","250.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("112","31",NULL,NULL,NULL,"insertion des elements graphiques et de pages",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"150.00000000","150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","150.00000000","150.00000000","0.00000000","150.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("113","31",NULL,NULL,NULL,"Personnalisation du design",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"150.00000000","150.00000000","0.00000000","0.00000000","0.00000000","150.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","150.00000000","150.00000000","0.00000000","150.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("114","31",NULL,NULL,NULL,"Conception graphique de la catre de visite et du flyer A5&nbsp;",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","5",NULL,NULL,"EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("115","32",NULL,NULL,NULL,"Modidfication de la pr&eacute;sentation du formulaire de contact afin de le rendre plus visible et changement de possition de la case a cocher",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"35.00000000","35.00000000","0.00000000","0.00000000","0.00000000","35.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","35.00000000","35.00000000","0.00000000","35.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("116","33",NULL,"5",NULL,"",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","15.00000000","15.00000000","0.00000000","0.00000000","0.00000000","15.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","15.00000000","15.00000000","0.00000000","15.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("117","33",NULL,"6",NULL,"",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","20.00000000","20.00000000","0.00000000","0.00000000","0.00000000","20.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","20.00000000","20.00000000","0.00000000","20.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("118","33",NULL,"7",NULL,"",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","10.00000000","10.00000000","0.00000000","0.00000000","0.00000000","10.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","10.00000000","10.00000000","0.00000000","10.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("119","33",NULL,"9",NULL,"",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","10.00000000","10.00000000","0.00000000","0.00000000","0.00000000","10.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","6",NULL,NULL,"EUR","10.00000000","10.00000000","0.00000000","10.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("120","33",NULL,"10",NULL,"",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","25.00000000","25.00000000","0.00000000","0.00000000","0.00000000","25.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","7",NULL,NULL,"EUR","25.00000000","25.00000000","0.00000000","25.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("121","33",NULL,"11",NULL,"",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","15.00000000","15.00000000","0.00000000","0.00000000","0.00000000","15.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","8",NULL,NULL,"EUR","15.00000000","15.00000000","0.00000000","15.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("122","33",NULL,"12",NULL,"",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","10.00000000","10.00000000","0.00000000","0.00000000","0.00000000","10.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","9",NULL,NULL,"EUR","10.00000000","10.00000000","0.00000000","10.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("123","33",NULL,NULL,NULL,"&nbsp;Formule Accompagnement SEO (5h/mois)",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("134","33",NULL,"8",NULL,"",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","15.00000000","15.00000000","0.00000000","0.00000000","0.00000000","15.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","5",NULL,NULL,"EUR","15.00000000","15.00000000","0.00000000","15.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("135","35",NULL,NULL,NULL,"R&eacute;paration, netoyage et parametrage de l&#39;ordinateur.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"110.00000000","110.00000000","0.00000000","0.00000000","0.00000000","110.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","110.00000000","110.00000000","0.00000000","110.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("136","37",NULL,NULL,NULL,"Cr&eacute;ation du nom de domaine instalation de l&#39;h&eacute;bergement et du site internet.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("137","37",NULL,NULL,NULL,"Installation et configuration de la solution de vente en ligne",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"400.00000000","400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","400.00000000","400.00000000","0.00000000","400.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("138","37",NULL,NULL,NULL,"Param&eacute;trage du th&egrave;me et modifications",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"400.00000000","400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","400.00000000","400.00000000","0.00000000","400.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("139","37",NULL,NULL,NULL,"Ajout des produits et tarifs",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"400.00000000","400.00000000","0.00000000","0.00000000","0.00000000","400.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","400.00000000","400.00000000","0.00000000","400.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("140","37",NULL,NULL,NULL,"Configuration de la boutique en ligne, param&eacute;trage et tests.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","88.00000000","88.00000000","0.00000000","0.00000000","0.00000000","88.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","5",NULL,NULL,"EUR","88.00000000","88.00000000","0.00000000","88.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("142","37",NULL,NULL,NULL,"R&eacute;glement de 744&euro; &agrave; la signature puis 744&euro; &agrave; la mise en ligne.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","6",NULL,NULL,"EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("143","38",NULL,NULL,NULL,"Sauvegarde du site internet",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("144","38",NULL,NULL,NULL,"Installation sur le serveur test de mise &agrave; jour et parametrages.",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","50.00000000","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("147","38",NULL,NULL,NULL,"Mise a jour vers le version cible de prestashop. (produits, images, d&eacute;clinaisons, clients, et ancienne factures)",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("148","38",NULL,NULL,NULL,"Configuration des moyens de transport et tarifs",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","50.00000000","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","7",NULL,NULL,"EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("149","38",NULL,NULL,NULL,"Configurations des moyens de payements",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","100.00000000","100.00000000","0.00000000","0.00000000","0.00000000","100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","100.00000000","100.00000000","0.00000000","100.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("150","38",NULL,NULL,NULL,"Installation du th&egrave;me choisi par le client",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","100.00000000","100.00000000","0.00000000","0.00000000","0.00000000","100.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","5",NULL,NULL,"EUR","100.00000000","100.00000000","0.00000000","100.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("153","38",NULL,NULL,NULL,"Installation du module de livraison MBE (offert)",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","6",NULL,NULL,"EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("154","38",NULL,NULL,NULL,"Vérification complète du bon fonctionnement du site en production.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"50.00000000","50.00000000","0.00000000","0.00000000","0.00000000","50.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","8",NULL,NULL,"EUR","50.00000000","50.00000000","0.00000000","50.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("155","39",NULL,NULL,NULL,"<p>1. Conception et d&eacute;veloppement du site web</p>\r\n\r\n<ul>\r\n	<li>Installation et configuration de WordPress sur l&rsquo;h&eacute;bergement du client.</li>\r\n	<li>Installation d&rsquo;un th&egrave;me professionnel adapt&eacute; &agrave; la r&eacute;servation immobili&egrave;re.</li>\r\n	<li>Personnalisation graphique (couleurs, logo, typographie, mise en page).</li>\r\n	<li>Cr&eacute;ation des pages : Accueil, Pr&eacute;sentation, Liste des biens &agrave; louer, D&eacute;tail d&rsquo;un bien, Contact avec formulaire, Mentions l&eacute;gales / Politique de confidentialit&eacute;.</li>\r\n</ul>",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","700.00000000","700.00000000","0.00000000","0.00000000","0.00000000","700.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","700.00000000","700.00000000","0.00000000","700.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("156","39",NULL,NULL,NULL,"<p>2. Module de r&eacute;servation sp&eacute;cifique</p>\r\n\r\n<ul>\r\n	<li>\r\n	<p>Int&eacute;gration d&rsquo;un syst&egrave;me de r&eacute;servation en ligne : calendrier de disponibilit&eacute;s, gestion tarifs / saisons, formulaire de r&eacute;servation ou paiement en ligne (si souhait&eacute;), notifications email.</p>\r\n	</li>\r\n	<li>\r\n	<p>Configuration, tests et adaptation selon les besoins.</p>\r\n	</li>\r\n</ul>",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","500.00000000","500.00000000","0.00000000","0.00000000","0.00000000","500.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","500.00000000","500.00000000","0.00000000","500.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("157","39",NULL,NULL,NULL,"<p>3. R&eacute;f&eacute;rencement naturel (SEO) de base</p>\r\n\r\n<ul>\r\n	<li>\r\n	<p>Optimisation technique : balises titres, m&eacute;ta-descriptions, structure Hn, URLs.</p>\r\n	</li>\r\n	<li>\r\n	<p>Mise en place de Google Search Console et Google Analytics.</p>\r\n	</li>\r\n	<li>\r\n	<p>Soumission du site &agrave; Google.</p>\r\n	</li>\r\n	<li>\r\n	<p>Conseils de r&eacute;daction SEO pour les contenus.<br />\r\n	&nbsp;</p>\r\n	</li>\r\n</ul>",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("158","39",NULL,NULL,NULL,"<p>4. Formation et mise en ligne</p>\r\n\r\n<ul>\r\n	<li>\r\n	<p>Formation &agrave; l&rsquo;usage de WordPress et du module de r&eacute;servation.</p>\r\n	</li>\r\n	<li>\r\n	<p>Mise en ligne du site et v&eacute;rification du bon fonctionnement.</p>\r\n	</li>\r\n</ul>",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("159","40",NULL,NULL,NULL,"Compression GZIP activ&eacute;e &rarr; NON\r\n<ul>\r\n	<li>\r\n	<p>Activer la compression (GZIP ).</p>\r\n	</li>\r\n	<li>\r\n	<p>Optimiser les images.</p>\r\n	</li>\r\n	<li>\r\n	<p>Tester avant/apr&egrave;s pour mesurer l&rsquo;am&eacute;lioration (PageSpeed / GTmetrix / Lighthouse).</p>\r\n	</li>\r\n</ul>",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","2",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("160","40",NULL,NULL,NULL,"2. Sitemap XML : NON<br />\r\n&nbsp;\r\n<ul>\r\n	<li>\r\n	<p>Installer/activer un plugin WordPress SEO (ex. Open Graph/Sitemap) ou configurer le sitemap via le plugin existant.</p>\r\n	</li>\r\n	<li>\r\n	<p>G&eacute;n&eacute;rer automatiquement le fichier sitemap.xml.</p>\r\n	</li>\r\n	<li>\r\n	<p>Mettre &agrave; jour robots.txt pour y d&eacute;clarer l&rsquo;emplacement du sitemap (Sitemap: https://www.coursmontaignedeparis.com/sitemap.xml).</p>\r\n	</li>\r\n	<li>\r\n	<p>V&eacute;rification et test &mdash; soumission du sitemap &agrave; Google Search Console (ou autre).</p>\r\n	</li>\r\n</ul>",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","3",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("161","40",NULL,NULL,NULL,"Balises Twitter Card : NON\r\n<ul>\r\n	<li>\r\n	<p>Installer/configurer un plugin SEO (si non d&eacute;j&agrave;) &mdash; ex. pour g&eacute;rer title, meta description, balises Open Graph, images de partage, Twitter Cards.</p>\r\n	</li>\r\n	<li>\r\n	<p>Pour chaque page (accueil, pages internes, articles blog&hellip;), s&rsquo;assurer que les m&eacute;tadonn&eacute;es sont correctement renseign&eacute;es.</p>\r\n	</li>\r\n	<li>\r\n	<p>Mettre en place des valeurs dynamiques si possible (variables WordPress) pour titre, description, image, afin d&rsquo;&eacute;viter la redondance ou l&rsquo;oubli.</p>\r\n	</li>\r\n	<li>\r\n	<p>Tester le rendu des partages sur r&eacute;seaux sociaux, v&eacute;rifier qu&rsquo;Open Graph et Twitter Card fonctionnent correctement.</p>\r\n	</li>\r\n</ul>",NULL,"","0.000","0.000","0","0.000","0","1","0","0","0","200.00000000","200.00000000","0.00000000","0.00000000","0.00000000","200.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","4",NULL,NULL,"EUR","200.00000000","200.00000000","0.00000000","200.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("162","40",NULL,NULL,NULL,"Am&eacute;liorations du site de votre client<br />\r\nhttps://www.coursmontaignedeparis.com/",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","0.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","0.00000000","0.00000000","0.00000000","0.00000000",NULL);
INSERT INTO `llx_propaldet` VALUES("163","41",NULL,NULL,NULL,"Modification du style Css afin d&#39;afficher les &eacute;l&eacute;ments du menu sans le soulign&eacute;.",NULL,"","0.000","0.000","0","0.000","0","1","0","0",NULL,"30.00000000","30.00000000","0.00000000","0.00000000","0.00000000","30.00000000","1",NULL,NULL,"0","0.00000000",NULL,"0","1",NULL,NULL,"EUR","30.00000000","30.00000000","0.00000000","30.00000000",NULL);



DROP TABLE IF EXISTS `llx_propaldet_extrafields`;
CREATE TABLE `llx_propaldet_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_propaldet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_reception`;
CREATE TABLE `llx_reception` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ref` varchar(30) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `fk_soc` int NOT NULL,
  `fk_projet` int DEFAULT NULL,
  `ref_ext` varchar(30) DEFAULT NULL,
  `ref_int` varchar(30) DEFAULT NULL,
  `ref_supplier` varchar(255) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `date_delivery` datetime DEFAULT NULL,
  `date_reception` datetime DEFAULT NULL,
  `fk_shipping_method` int DEFAULT NULL,
  `tracking_number` varchar(50) DEFAULT NULL,
  `fk_statut` smallint DEFAULT '0',
  `billed` smallint DEFAULT '0',
  `height` float DEFAULT NULL,
  `width` float DEFAULT NULL,
  `size_units` int DEFAULT NULL,
  `size` float DEFAULT NULL,
  `weight_units` int DEFAULT NULL,
  `weight` float DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `fk_incoterms` int DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_reception_uk_ref` (`ref`,`entity`),
  KEY `idx_reception_fk_soc` (`fk_soc`),
  KEY `idx_reception_fk_user_author` (`fk_user_author`),
  KEY `idx_reception_fk_user_valid` (`fk_user_valid`),
  KEY `idx_reception_fk_shipping_method` (`fk_shipping_method`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_reception_extrafields`;
CREATE TABLE `llx_reception_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_reception_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_recruitment_recruitmentcandidature`;
CREATE TABLE `llx_recruitment_recruitmentcandidature` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `fk_recruitmentjobposition` int DEFAULT NULL,
  `ref` varchar(128) NOT NULL DEFAULT '(PROV)',
  `description` text,
  `note_public` text,
  `note_private` text,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `status` smallint NOT NULL,
  `firstname` varchar(128) DEFAULT NULL,
  `lastname` varchar(128) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(64) DEFAULT NULL,
  `date_birth` date DEFAULT NULL,
  `remuneration_requested` int DEFAULT NULL,
  `remuneration_proposed` int DEFAULT NULL,
  `email_msgid` varchar(175) DEFAULT NULL,
  `email_date` datetime DEFAULT NULL,
  `fk_recruitment_origin` int DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_recruitmentcandidature_email_msgid` (`email_msgid`),
  KEY `idx_recruitment_recruitmentcandidature_rowid` (`rowid`),
  KEY `idx_recruitment_recruitmentcandidature_ref` (`ref`),
  KEY `llx_recruitment_recruitmentcandidature_fk_user_creat` (`fk_user_creat`),
  KEY `idx_recruitment_recruitmentcandidature_status` (`status`),
  CONSTRAINT `llx_recruitment_recruitmentcandidature_fk_user_creat` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_recruitment_recruitmentcandidature_extrafields`;
CREATE TABLE `llx_recruitment_recruitmentcandidature_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_recruitmentcandidature_fk_object` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_recruitment_recruitmentjobposition`;
CREATE TABLE `llx_recruitment_recruitmentjobposition` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(128) NOT NULL DEFAULT '(PROV)',
  `entity` int NOT NULL DEFAULT '1',
  `label` varchar(255) NOT NULL,
  `qty` int NOT NULL DEFAULT '1',
  `fk_soc` int DEFAULT NULL,
  `fk_project` int DEFAULT NULL,
  `fk_user_recruiter` int DEFAULT NULL,
  `fk_user_supervisor` int DEFAULT NULL,
  `fk_establishment` int DEFAULT NULL,
  `date_planned` date DEFAULT NULL,
  `remuneration_suggested` varchar(255) DEFAULT NULL,
  `description` text,
  `note_public` text,
  `note_private` text,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `status` smallint NOT NULL,
  `email_recruiter` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_recruitment_recruitmentjobposition_rowid` (`rowid`),
  KEY `idx_recruitment_recruitmentjobposition_ref` (`ref`),
  KEY `idx_recruitment_recruitmentjobposition_fk_soc` (`fk_soc`),
  KEY `idx_recruitment_recruitmentjobposition_fk_project` (`fk_project`),
  KEY `llx_recruitment_recruitmentjobposition_fk_user_recruiter` (`fk_user_recruiter`),
  KEY `llx_recruitment_recruitmentjobposition_fk_user_supervisor` (`fk_user_supervisor`),
  KEY `llx_recruitment_recruitmentjobposition_fk_establishment` (`fk_establishment`),
  KEY `llx_recruitment_recruitmentjobposition_fk_user_creat` (`fk_user_creat`),
  KEY `idx_recruitment_recruitmentjobposition_status` (`status`),
  CONSTRAINT `llx_recruitment_recruitmentjobposition_fk_establishment` FOREIGN KEY (`fk_establishment`) REFERENCES `llx_establishment` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `llx_recruitment_recruitmentjobposition_fk_user_creat` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `llx_recruitment_recruitmentjobposition_fk_user_recruiter` FOREIGN KEY (`fk_user_recruiter`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `llx_recruitment_recruitmentjobposition_fk_user_supervisor` FOREIGN KEY (`fk_user_supervisor`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_recruitment_recruitmentjobposition_extrafields`;
CREATE TABLE `llx_recruitment_recruitmentjobposition_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_recruitmentjobposition_fk_object` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_resource`;
CREATE TABLE `llx_resource` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `ref` varchar(255) DEFAULT NULL,
  `asset_number` varchar(255) DEFAULT NULL,
  `description` text,
  `fk_code_type_resource` varchar(32) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `zip` varchar(25) DEFAULT NULL,
  `town` varchar(50) DEFAULT NULL,
  `photo_filename` varchar(255) DEFAULT NULL,
  `max_users` int DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `fk_statut` smallint NOT NULL DEFAULT '0',
  `note_public` text,
  `note_private` text,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `fk_country` int DEFAULT NULL,
  `fk_state` int DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_resource_ref` (`ref`,`entity`),
  KEY `fk_code_type_resource_idx` (`fk_code_type_resource`),
  KEY `idx_resource_fk_country` (`fk_country`),
  KEY `idx_resource_fk_state` (`fk_state`),
  CONSTRAINT `fk_resource_fk_country` FOREIGN KEY (`fk_country`) REFERENCES `llx_c_country` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_resource_extrafields`;
CREATE TABLE `llx_resource_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_resource_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_rights_def`;
CREATE TABLE `llx_rights_def` (
  `id` int NOT NULL,
  `libelle` varchar(255) DEFAULT NULL,
  `module` varchar(64) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `perms` varchar(50) DEFAULT NULL,
  `subperms` varchar(50) DEFAULT NULL,
  `type` varchar(1) DEFAULT NULL,
  `bydefault` tinyint DEFAULT '0',
  `module_position` int NOT NULL DEFAULT '0',
  `family_position` int NOT NULL DEFAULT '0',
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `llx_rights_def` VALUES("11","Read invoices","facture","1","lire",NULL,"a","0","0","0","2024-03-23 15:35:26");
INSERT INTO `llx_rights_def` VALUES("12","Create and update invoices","facture","1","creer",NULL,"a","0","0","0","2024-03-23 15:35:26");
INSERT INTO `llx_rights_def` VALUES("13","Devalidate invoices","facture","1","invoice_advance","unvalidate","a","0","0","0","2024-03-23 15:35:26");
INSERT INTO `llx_rights_def` VALUES("14","Validate invoices","facture","1","invoice_advance","validate","a","0","0","0","2024-03-23 15:35:26");
INSERT INTO `llx_rights_def` VALUES("15","Send invoices by email","facture","1","invoice_advance","send","a","0","0","0","2024-03-23 15:35:26");
INSERT INTO `llx_rights_def` VALUES("16","Issue payments on invoices","facture","1","paiement",NULL,"a","0","0","0","2024-03-23 15:35:26");
INSERT INTO `llx_rights_def` VALUES("19","Delete invoices","facture","1","supprimer",NULL,"a","0","0","0","2024-03-23 15:35:26");
INSERT INTO `llx_rights_def` VALUES("21","Read commercial proposals","propale","1","lire",NULL,"r","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("22","Create and update commercial proposals","propale","1","creer",NULL,"w","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("24","Validate commercial proposals","propale","1","propal_advance","validate","d","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("25","Send commercial proposals to customers","propale","1","propal_advance","send","d","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("26","Close commercial proposals","propale","1","propal_advance","close","d","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("27","Delete commercial proposals","propale","1","supprimer",NULL,"d","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("28","Exporting commercial proposals and attributes","propale","1","export",NULL,"r","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("81","Read sales orders","commande","1","lire",NULL,"r","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("82","Creeat/modify sales orders","commande","1","creer",NULL,"w","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("84","Validate sales orders","commande","1","order_advance","validate","d","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("85","Generate the documents sales orders","commande","1","order_advance","generetedoc","d","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("86","Send sales orders by email","commande","1","order_advance","send","d","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("87","Close sale orders","commande","1","order_advance","close","d","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("88","Cancel sale orders","commande","1","order_advance","annuler","d","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("89","Delete sales orders","commande","1","supprimer",NULL,"d","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("91","Lire les charges","tax","1","charges","lire","r","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("92","Creer/modifier les charges","tax","1","charges","creer","w","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("93","Supprimer les charges","tax","1","charges","supprimer","d","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("94","Exporter les charges","tax","1","charges","export","r","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("111","Read bank account and transactions","banque","1","lire",NULL,"r","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("112","Creer/modifier montant/supprimer ecriture bancaire","banque","1","modifier",NULL,"w","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("113","Configurer les comptes bancaires (creer, gerer categories)","banque","1","configurer",NULL,"a","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("114","Rapprocher les ecritures bancaires","banque","1","consolidate",NULL,"w","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("115","Exporter transactions et releves","banque","1","export",NULL,"r","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("116","Virements entre comptes","banque","1","transfer",NULL,"w","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("117","Gerer les envois de cheques","banque","1","cheque",NULL,"w","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("121","Read third parties","societe","1","lire",NULL,"r","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("122","Create and update third parties","societe","1","creer",NULL,"w","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("125","Delete third parties","societe","1","supprimer",NULL,"d","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("126","Export third parties","societe","1","export",NULL,"r","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("130","Modify thirdparty information payment","societe","1","thirdparty_paymentinformation_advance","write","w","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("241","Lire les categories","categorie","1","lire",NULL,"r","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("242","Creer/modifier les categories","categorie","1","creer",NULL,"w","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("243","Supprimer les categories","categorie","1","supprimer",NULL,"d","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("251","Read information of other users, groups and permissions","user","1","user","lire","r","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("252","Read permissions of other users","user","1","user_advance","readperms","r","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("253","Create/modify internal and external users, groups and permissions","user","1","user","creer","w","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("254","Create/modify external users only","user","1","user_advance","write","w","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("255","Modify the password of other users","user","1","user","password","w","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("256","Delete or disable other users","user","1","user","supprimer","d","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("262","Read all third parties (and their objects) by internal users (otherwise only if commercial contact). Not effective for external users (limited to themselves).","societe","1","client","voir","r","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("281","Read contacts","societe","1","contact","lire","r","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("282","Create and update contact","societe","1","contact","creer","w","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("283","Delete contacts","societe","1","contact","supprimer","d","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("286","Export contacts","societe","1","contact","export","d","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("341","Read its own permissions","user","1","self_advance","readperms","r","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("342","Create/modify of its own user","user","1","self","creer","w","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("343","Modify its own password","user","1","self","password","w","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("344","Modify its own permissions","user","1","self_advance","writeperms","w","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("351","Read groups","user","1","group_advance","read","r","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("352","Read permissions of groups","user","1","group_advance","readperms","r","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("353","Create/modify groups and permissions","user","1","group_advance","write","w","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("354","Delete groups","user","1","group_advance","delete","d","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("358","Export all users","user","1","user","export","r","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("531","Read services","service","1","lire",NULL,"r","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("532","Create/modify services","service","1","creer",NULL,"w","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("533","Read prices services","service","1","service_advance","read_prices","w","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("534","Delete les services","service","1","supprimer",NULL,"d","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("538","Export services","service","1","export",NULL,"r","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("1201","Lire les exports","export","1","lire",NULL,"r","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("1202","Creer/modifier un export","export","1","creer",NULL,"w","0","0","0","2024-03-23 15:25:44");
INSERT INTO `llx_rights_def` VALUES("1251","Run mass imports of external data (data load)","import","1","run",NULL,"r","0","0","0","2025-10-19 20:12:04");
INSERT INTO `llx_rights_def` VALUES("1321","Export customer invoices, attributes and payments","facture","1","facture","export","r","0","0","0","2024-03-23 15:35:26");
INSERT INTO `llx_rights_def` VALUES("1322","Re-open a fully paid invoice","facture","1","invoice_advance","reopen","r","0","0","0","2024-03-23 15:35:26");
INSERT INTO `llx_rights_def` VALUES("1421","Export sales orders and attributes","commande","1","commande","export","r","0","0","0","2024-03-23 15:26:16");
INSERT INTO `llx_rights_def` VALUES("2501","Read or download documents","ecm","1","read",NULL,"r","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("2503","Upload a document","ecm","1","upload",NULL,"w","0","0","0","2024-03-23 15:26:17");
INSERT INTO `llx_rights_def` VALUES("2515","Administer directories of documents","ecm","1","setup",NULL,"w","0","0","0","2024-03-23 15:26:17");



DROP TABLE IF EXISTS `llx_salary`;
CREATE TABLE `llx_salary` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datec` datetime DEFAULT NULL,
  `fk_user` int NOT NULL,
  `datep` date DEFAULT NULL,
  `datev` date DEFAULT NULL,
  `salary` double(24,8) DEFAULT NULL,
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `fk_projet` int DEFAULT NULL,
  `datesp` date DEFAULT NULL,
  `dateep` date DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `note` text,
  `fk_bank` int DEFAULT NULL,
  `paye` smallint NOT NULL DEFAULT '0',
  `fk_typepayment` int NOT NULL,
  `fk_account` int DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `note_public` text,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_salary_extrafields`;
CREATE TABLE `llx_salary_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_salary_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_session`;
CREATE TABLE `llx_session` (
  `session_id` varchar(50) NOT NULL,
  `session_variable` text,
  `last_accessed` datetime NOT NULL,
  `fk_user` int NOT NULL,
  `remote_ip` varchar(64) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_societe`;
CREATE TABLE `llx_societe` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `nom` varchar(128) DEFAULT NULL,
  `name_alias` varchar(128) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `ref_ext` varchar(255) DEFAULT NULL,
  `ref_int` varchar(255) DEFAULT NULL,
  `statut` tinyint DEFAULT '0',
  `parent` int DEFAULT NULL,
  `status` tinyint DEFAULT '1',
  `code_client` varchar(24) DEFAULT NULL,
  `code_fournisseur` varchar(24) DEFAULT NULL,
  `code_compta` varchar(24) DEFAULT NULL,
  `code_compta_fournisseur` varchar(24) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `zip` varchar(25) DEFAULT NULL,
  `town` varchar(50) DEFAULT NULL,
  `fk_departement` int DEFAULT '0',
  `fk_pays` int DEFAULT '0',
  `fk_account` int DEFAULT '0',
  `phone` varchar(20) DEFAULT NULL,
  `fax` varchar(20) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `email` varchar(128) DEFAULT NULL,
  `socialnetworks` text,
  `fk_effectif` int DEFAULT '0',
  `fk_typent` int DEFAULT NULL,
  `fk_forme_juridique` int DEFAULT '0',
  `fk_currency` varchar(3) DEFAULT NULL,
  `siren` varchar(128) DEFAULT NULL,
  `siret` varchar(128) DEFAULT NULL,
  `ape` varchar(128) DEFAULT NULL,
  `idprof4` varchar(128) DEFAULT NULL,
  `idprof5` varchar(128) DEFAULT NULL,
  `idprof6` varchar(128) DEFAULT NULL,
  `tva_intra` varchar(20) DEFAULT NULL,
  `capital` double(24,8) DEFAULT NULL,
  `fk_stcomm` int NOT NULL DEFAULT '0',
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `prefix_comm` varchar(5) DEFAULT NULL,
  `client` tinyint DEFAULT '0',
  `fournisseur` tinyint DEFAULT '0',
  `supplier_account` varchar(32) DEFAULT NULL,
  `fk_prospectlevel` varchar(12) DEFAULT NULL,
  `fk_incoterms` int DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `customer_bad` tinyint DEFAULT '0',
  `customer_rate` double DEFAULT '0',
  `supplier_rate` double DEFAULT '0',
  `remise_client` double DEFAULT '0',
  `remise_supplier` double DEFAULT '0',
  `mode_reglement` tinyint DEFAULT NULL,
  `cond_reglement` tinyint DEFAULT NULL,
  `deposit_percent` varchar(63) DEFAULT NULL,
  `transport_mode` tinyint DEFAULT NULL,
  `mode_reglement_supplier` tinyint DEFAULT NULL,
  `cond_reglement_supplier` tinyint DEFAULT NULL,
  `transport_mode_supplier` tinyint DEFAULT NULL,
  `fk_shipping_method` int DEFAULT NULL,
  `tva_assuj` tinyint DEFAULT '1',
  `vat_reverse_charge` tinyint DEFAULT '0',
  `localtax1_assuj` tinyint DEFAULT '0',
  `localtax1_value` double(6,3) DEFAULT NULL,
  `localtax2_assuj` tinyint DEFAULT '0',
  `localtax2_value` double(6,3) DEFAULT NULL,
  `barcode` varchar(180) DEFAULT NULL,
  `fk_barcode_type` int DEFAULT '0',
  `price_level` int DEFAULT NULL,
  `outstanding_limit` double(24,8) DEFAULT NULL,
  `order_min_amount` double(24,8) DEFAULT NULL,
  `supplier_order_min_amount` double(24,8) DEFAULT NULL,
  `default_lang` varchar(6) DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `canvas` varchar(32) DEFAULT NULL,
  `fk_warehouse` int DEFAULT NULL,
  `webservices_url` varchar(255) DEFAULT NULL,
  `webservices_key` varchar(128) DEFAULT NULL,
  `accountancy_code_sell` varchar(32) DEFAULT NULL,
  `accountancy_code_buy` varchar(32) DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `logo_squarred` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_societe_prefix_comm` (`prefix_comm`,`entity`),
  UNIQUE KEY `uk_societe_code_client` (`code_client`,`entity`),
  UNIQUE KEY `uk_societe_code_fournisseur` (`code_fournisseur`,`entity`),
  UNIQUE KEY `uk_societe_barcode` (`barcode`,`fk_barcode_type`,`entity`),
  KEY `idx_societe_user_creat` (`fk_user_creat`),
  KEY `idx_societe_user_modif` (`fk_user_modif`),
  KEY `idx_societe_warehouse` (`fk_warehouse`),
  KEY `idx_societe_nom` (`nom`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1;

INSERT INTO `llx_societe` VALUES("1","Komaki shushi","","1",NULL,NULL,"0",NULL,"1","CU1811-0001",NULL,NULL,NULL,"C.C Le Colibri 45, bld Vincent C.C Le Colibri 45, bld Vincent Auriol","31170","Tournefeuille","38","1","0","+33664864195",NULL,NULL,"christineChan_6@msn.com",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2018-11-02 21:30:53","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("2","Cophil International","","1",NULL,NULL,"0",NULL,"1","CU1811-0002",NULL,NULL,NULL,"18 rue de Boissy","93370","Sucy en Brie","101","1","0",NULL,NULL,NULL,"contact@cophilinternational.fr",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2018-11-03 12:12:52","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("3","PLANETFORM RT","","1",NULL,NULL,"0",NULL,"1","CU1812-0003",NULL,NULL,NULL,"14 Rue des Artisans,",NULL,"Quetigny","0","1","0",NULL,NULL,NULL,"romain.toulouse.planetform@gmail.com",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2018-12-20 11:52:16","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("4","Planet form Tarbes","LB DEVELOPPEMENT","1",NULL,NULL,"0",NULL,"1","CU1902-0004",NULL,NULL,NULL,"66 RUE CORPS FRANC POMMIES","65000","Tarbes","0","1","0",NULL,NULL,NULL,"laurentbayle.planetform@gmail.com",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2019-02-01 18:20:26","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("5","La boutique du vapoteur","","1",NULL,NULL,"0",NULL,"1","CU1908-0005",NULL,NULL,NULL,"5 Rue François Mousis","65000","Tarbes","0","1","0","0581599103",NULL,NULL,"laboutiqueduvapoteur.fr@gmail.com",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2019-08-22 10:59:30","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("6","Tamporex Laser","","1",NULL,NULL,"0",NULL,"1","CU1912-0006",NULL,NULL,NULL,"1 Boulevard Claude Debussy","65000","Tarbes","72","1","0",NULL,NULL,NULL,"tamporexlaser@orange.fr",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2019-12-17 08:54:12","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("7","Pyrénées Concept","","1",NULL,NULL,"0",NULL,"1","CU2001-0007",NULL,NULL,NULL,"Route de Tarbes, Lieu dit Saux","65100","Lourdes","0","1","0","0962148285",NULL,NULL,"contact@pyrenees-concept.com",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2020-01-24 16:07:31","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("8","Cabinet MAXIM-VALERY","","1",NULL,NULL,"0",NULL,"1","CU2002-0008",NULL,NULL,NULL,"2, rue Colomés de Juillan","65000","Tarbes","72","1","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2020-02-10 10:51:28","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("9","SARL DE FIGEAS","","1",NULL,NULL,"0",NULL,"1","CU2005-0009",NULL,NULL,NULL,"",NULL,NULL,"0","1","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2020-05-24 09:17:08","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("10","Slimane Foie Gras","","1",NULL,NULL,"0",NULL,"1","CU2007-0010",NULL,NULL,NULL,"22 Route des Pyrénées","65000","Tarbes","72","1","0",NULL,NULL,NULL,"slimanefoiegras@gmail.com",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2020-07-29 11:28:52","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("11","Maison Garbage","","1",NULL,NULL,"0",NULL,"1","CU2008-0011",NULL,NULL,NULL,"Le Hauron","32110","Urgosse","0","1","0","0652526792",NULL,NULL,"maisongarbage@gmail.com",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2020-08-06 17:54:27","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("12","Axelles","Lydie Aiello","1",NULL,NULL,"0",NULL,"1","CU2009-0012",NULL,NULL,NULL,"27 Allé de Catchère","31770","Colomiers","0","1","0","0672896544",NULL,"www.axelles.eu","direction@axelles.eu",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2020-09-11 09:26:26","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("13","Axelles","","1",NULL,NULL,"0",NULL,"1","CU2009-0013",NULL,NULL,NULL,"27 allée de Catchère","31770","Colomiers","0","1","0",NULL,NULL,NULL,"direction@axelles.eu",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2020-09-30 10:25:38","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("14","Mille et une mariée","Nadia Masrar","1",NULL,NULL,"0",NULL,"1","CU2011-0014",NULL,NULL,NULL,"route de, 180 Route de Seysses","31100","Toulouse","0","1","0","0781862047",NULL,NULL,"nmasrar@hotmail.fr",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2020-11-04 12:25:59","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("15","Restaurant Dar Baba","","1",NULL,NULL,"0",NULL,"1","CU2102-0015",NULL,NULL,NULL,"",NULL,NULL,"0","1","0","0637181733",NULL,NULL,"mohamed.mawla@hotmail.com",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"2","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2021-02-18 17:36:43","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("16","FITAN et FILS SAS Billards de France","","1",NULL,NULL,"0",NULL,"1","CU2105-0016",NULL,NULL,NULL,"Chemin de la Riberotte","32160","Plaisance du Gers","0","1","0",NULL,NULL,NULL,"contact@billardsdefrance.fr",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2021-05-03 19:53:50","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("17","benjou","","1",NULL,NULL,"0",NULL,"1","CU2108-0017",NULL,NULL,NULL,"","65000","Tarbes","72","1","0",NULL,NULL,NULL,"benjouabde@gmail.com",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2021-08-02 09:00:23","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("18","CAESAR","","1",NULL,NULL,"0",NULL,"1","CU2109-0018",NULL,NULL,NULL,"1 RUE DE LA GROTTE","65100","Lourdes","0","1","0","0562943511",NULL,NULL,"caesar65@orange.fr",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2021-09-25 15:30:28","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("19","HRV","","1",NULL,NULL,"0",NULL,"1","CU2109-0019",NULL,NULL,NULL,"170 , avenue de grande Bretagne","31300","Toulouse","0","1","0",NULL,NULL,"contact@hrv-france.fr","hrv.c@gmx.fr",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2021-09-25 15:51:19","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("20","Stéphane Martineau","","1",NULL,NULL,"0",NULL,"1","CU2203-0020",NULL,NULL,NULL,"6 rue de l\'You","65100","Lourdes","0","1","0","0686878831",NULL,NULL,"contact@via-camina.fr",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2022-03-03 20:56:06","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("21","Imprimerie Augé","Julien","1",NULL,NULL,"0",NULL,"1","CU2204-0021",NULL,NULL,NULL,"14 Av. Saint-Joseph","65100","Lourdes","0","1","0","0562942111",NULL,NULL,"imprimerie-auge2@wanadoo.fr",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2022-04-04 16:35:56","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("22","Kit Auto","","1",NULL,NULL,"0",NULL,"1","CU2209-0022",NULL,NULL,NULL,"8 Rue Ampère","65100","Lourdes","0","1","0","0562948095",NULL,NULL,"casseautolourdes@kitauto65.fr",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2022-09-30 15:58:23","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("23","AMRI Mouhcine","AMRI Mouhcine","1",NULL,NULL,"0",NULL,"1","CU2309-0023",NULL,NULL,NULL,"18 chemin de la gravette","31170","Tournefeuille","38","1","0","0660862329",NULL,NULL,"am.serrurier.metallier@gmail.com",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2023-09-18 17:58:51","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("24","GDSA65","","1",NULL,NULL,"0",NULL,"1","CU2402-0024",NULL,NULL,NULL,"22 place du foirail","65000","Tarbes","72","1","0",NULL,NULL,NULL,"gdsadu65@gmail.com",NULL,NULL,NULL,NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,"2024-02-02 09:24:53","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("25","SARL AVESTA","","1",NULL,NULL,"0",NULL,"1","CU2408-00025",NULL,NULL,NULL,"40 Av. Maréchal Joffre, 65000 Tarbes","65000","Tarbes",NULL,"1","0","0562510579",NULL,NULL,"dadaylinevzat@hotmail.com","[]",NULL,"0",NULL,NULL,"810111302","81011130200016","","Tarbes B 810 111 302","","","FR82810111302",NULL,"0",NULL,NULL,"",NULL,NULL,"1","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"","",NULL,"2024-08-09 16:55:17","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("26","Sherpas du Pyrène Destrian Guillaumes","","1",NULL,NULL,"0",NULL,"1","CU2503-00026",NULL,NULL,NULL,"",NULL,"Louey",NULL,"1","0","0637615364",NULL,NULL,"guillaume.destrian@gmail.com","[]",NULL,"0",NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,"",NULL,NULL,"1","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"","",NULL,"2025-03-04 19:38:55","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("27","PENA ANDALOUSE GUAZAMARA","","1",NULL,NULL,"0",NULL,"1","CU2506-00027",NULL,NULL,NULL,"Résidence La Fontaine ESC 5\r\n11 boulevard du Martinet","65000","Tarbes",NULL,"1","0",NULL,NULL,NULL,NULL,"[]",NULL,"0",NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,"",NULL,NULL,"1","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"","",NULL,"2025-06-24 19:33:52","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("28","Guillaume Griffon","","1",NULL,NULL,"0",NULL,"1","CU2507-00028",NULL,NULL,NULL,"10 impasse du berye hameau des granges Julos","65100","Julos",NULL,"1","0","0611165334",NULL,NULL,"guillaume.griff@gmail.com","[]",NULL,"0",NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,"",NULL,NULL,"1","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"","",NULL,"2025-07-04 10:30:18","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("29","Hervé Lebreton","","1",NULL,NULL,"0",NULL,"1","CU2510-00029",NULL,NULL,NULL,"",NULL,NULL,NULL,"1","0",NULL,NULL,NULL,"he.lebreton@laposte.net","[]",NULL,"0",NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,"",NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"","",NULL,"2025-10-19 20:16:26","1","1","0","",NULL,NULL);
INSERT INTO `llx_societe` VALUES("30","SARL ECP44 - Ekole","","1",NULL,NULL,"0",NULL,"1","CU2511-00030",NULL,NULL,NULL,"3 RUE DU DEVON BP 4407","LA CHAPELLE SUR ERDRE CED","44244",NULL,"1","0",NULL,NULL,"https://www.ekole.fr/","gauthier@ekole.fr","[]",NULL,"0",NULL,NULL,"","","","","","","",NULL,"0",NULL,NULL,"",NULL,NULL,"3","0",NULL,"","0",NULL,"0","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1","0",NULL,"0.000",NULL,"0.000",NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"","",NULL,"2025-11-27 10:58:13","1","1","0","",NULL,NULL);



DROP TABLE IF EXISTS `llx_societe_account`;
CREATE TABLE `llx_societe_account` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int DEFAULT '1',
  `key_account` varchar(128) DEFAULT NULL,
  `login` varchar(128) NOT NULL,
  `pass_encoding` varchar(24) DEFAULT NULL,
  `pass_crypted` varchar(128) DEFAULT NULL,
  `pass_temp` varchar(128) DEFAULT NULL,
  `fk_soc` int DEFAULT NULL,
  `site` varchar(128) NOT NULL,
  `fk_website` int DEFAULT NULL,
  `note_private` text,
  `date_last_login` datetime DEFAULT NULL,
  `date_previous_login` datetime DEFAULT NULL,
  `date_creation` datetime NOT NULL,
  `tms` timestamp NOT NULL,
  `fk_user_creat` int NOT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `site_account` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_societe_account_login_website_soc` (`entity`,`fk_soc`,`login`,`site`,`fk_website`),
  UNIQUE KEY `uk_societe_account_key_account_soc` (`entity`,`fk_soc`,`key_account`,`site`,`fk_website`),
  KEY `idx_societe_account_rowid` (`rowid`),
  KEY `idx_societe_account_login` (`login`),
  KEY `idx_societe_account_status` (`status`),
  KEY `idx_societe_account_fk_website` (`fk_website`),
  KEY `idx_societe_account_fk_soc` (`fk_soc`),
  CONSTRAINT `llx_societe_account_fk_societe` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_societe_address`;
CREATE TABLE `llx_societe_address` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `label` varchar(30) DEFAULT NULL,
  `fk_soc` int DEFAULT '0',
  `name` varchar(60) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `zip` varchar(10) DEFAULT NULL,
  `town` varchar(50) DEFAULT NULL,
  `fk_pays` int DEFAULT '0',
  `phone` varchar(20) DEFAULT NULL,
  `fax` varchar(20) DEFAULT NULL,
  `note` text,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_societe_commerciaux`;
CREATE TABLE `llx_societe_commerciaux` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_soc` int DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_societe_commerciaux` (`fk_soc`,`fk_user`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_societe_contacts`;
CREATE TABLE `llx_societe_contacts` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `date_creation` datetime NOT NULL,
  `fk_soc` int NOT NULL,
  `fk_c_type_contact` int NOT NULL,
  `fk_socpeople` int NOT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_societe_contacts_idx1` (`entity`,`fk_soc`,`fk_c_type_contact`,`fk_socpeople`),
  KEY `fk_societe_contacts_fk_soc` (`fk_soc`),
  KEY `fk_societe_contacts_fk_socpeople` (`fk_socpeople`),
  KEY `fk_societe_contacts_fk_c_type_contact` (`fk_c_type_contact`),
  CONSTRAINT `fk_societe_contacts_fk_c_type_contact` FOREIGN KEY (`fk_c_type_contact`) REFERENCES `llx_c_type_contact` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_societe_contacts_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_societe_contacts_fk_socpeople` FOREIGN KEY (`fk_socpeople`) REFERENCES `llx_socpeople` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_societe_extrafields`;
CREATE TABLE `llx_societe_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_societe_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_societe_log`;
CREATE TABLE `llx_societe_log` (
  `id` int NOT NULL AUTO_INCREMENT,
  `datel` datetime DEFAULT NULL,
  `fk_soc` int DEFAULT NULL,
  `fk_statut` int DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `author` varchar(30) DEFAULT NULL,
  `label` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_societe_perentity`;
CREATE TABLE `llx_societe_perentity` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_soc` int DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `accountancy_code_customer` varchar(24) DEFAULT NULL,
  `accountancy_code_supplier` varchar(24) DEFAULT NULL,
  `accountancy_code_sell` varchar(32) DEFAULT NULL,
  `accountancy_code_buy` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_societe_perentity` (`fk_soc`,`entity`),
  KEY `idx_societe_perentity_fk_soc` (`fk_soc`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_societe_prices`;
CREATE TABLE `llx_societe_prices` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_soc` int DEFAULT '0',
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `price_level` tinyint DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_societe_remise`;
CREATE TABLE `llx_societe_remise` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `fk_soc` int NOT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `remise_client` double(6,3) NOT NULL DEFAULT '0.000',
  `note` text,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_societe_remise_except`;
CREATE TABLE `llx_societe_remise_except` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `fk_soc` int NOT NULL,
  `discount_type` int NOT NULL DEFAULT '0',
  `datec` datetime DEFAULT NULL,
  `amount_ht` double(24,8) NOT NULL,
  `amount_tva` double(24,8) NOT NULL DEFAULT '0.00000000',
  `amount_ttc` double(24,8) NOT NULL DEFAULT '0.00000000',
  `tva_tx` double(6,3) NOT NULL DEFAULT '0.000',
  `fk_user` int NOT NULL,
  `fk_facture_line` int DEFAULT NULL,
  `fk_facture` int DEFAULT NULL,
  `fk_facture_source` int DEFAULT NULL,
  `fk_invoice_supplier_line` int DEFAULT NULL,
  `fk_invoice_supplier` int DEFAULT NULL,
  `fk_invoice_supplier_source` int DEFAULT NULL,
  `description` text NOT NULL,
  `multicurrency_amount_ht` double(24,8) NOT NULL DEFAULT '0.00000000',
  `multicurrency_amount_tva` double(24,8) NOT NULL DEFAULT '0.00000000',
  `multicurrency_amount_ttc` double(24,8) NOT NULL DEFAULT '0.00000000',
  `vat_src_code` varchar(10) DEFAULT '',
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_societe_remise_except_fk_user` (`fk_user`),
  KEY `idx_societe_remise_except_fk_soc` (`fk_soc`),
  KEY `idx_societe_remise_except_fk_facture_line` (`fk_facture_line`),
  KEY `idx_societe_remise_except_fk_facture` (`fk_facture`),
  KEY `idx_societe_remise_except_fk_facture_source` (`fk_facture_source`),
  KEY `idx_societe_remise_except_discount_type` (`discount_type`),
  KEY `fk_soc_remise_fk_invoice_supplier_line` (`fk_invoice_supplier_line`),
  KEY `fk_societe_remise_fk_invoice_supplier_source` (`fk_invoice_supplier`),
  CONSTRAINT `fk_soc_remise_fk_facture_line` FOREIGN KEY (`fk_facture_line`) REFERENCES `llx_facturedet` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_soc_remise_fk_invoice_supplier_line` FOREIGN KEY (`fk_invoice_supplier_line`) REFERENCES `llx_facture_fourn_det` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_soc_remise_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_societe_remise_fk_facture` FOREIGN KEY (`fk_facture`) REFERENCES `llx_facture` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_societe_remise_fk_facture_source` FOREIGN KEY (`fk_facture_source`) REFERENCES `llx_facture` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_societe_remise_fk_invoice_supplier` FOREIGN KEY (`fk_invoice_supplier`) REFERENCES `llx_facture_fourn` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_societe_remise_fk_invoice_supplier_source` FOREIGN KEY (`fk_invoice_supplier`) REFERENCES `llx_facture_fourn` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_societe_remise_fk_user` FOREIGN KEY (`fk_user`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_societe_remise_supplier`;
CREATE TABLE `llx_societe_remise_supplier` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `fk_soc` int NOT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `remise_supplier` double(6,3) NOT NULL DEFAULT '0.000',
  `note` text,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_societe_rib`;
CREATE TABLE `llx_societe_rib` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `type` varchar(32) NOT NULL DEFAULT 'ban',
  `label` varchar(200) DEFAULT NULL,
  `fk_soc` int NOT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `bank` varchar(255) DEFAULT NULL,
  `code_banque` varchar(128) DEFAULT NULL,
  `code_guichet` varchar(6) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `cle_rib` varchar(5) DEFAULT NULL,
  `bic` varchar(20) DEFAULT NULL,
  `bic_intermediate` varchar(11) DEFAULT NULL,
  `iban_prefix` varchar(34) DEFAULT NULL,
  `domiciliation` varchar(255) DEFAULT NULL,
  `proprio` varchar(60) DEFAULT NULL,
  `owner_address` varchar(255) DEFAULT NULL,
  `default_rib` smallint NOT NULL DEFAULT '0',
  `state_id` int DEFAULT NULL,
  `fk_country` int DEFAULT NULL,
  `currency_code` varchar(3) DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `rum` varchar(32) DEFAULT NULL,
  `date_rum` date DEFAULT NULL,
  `frstrecur` varchar(16) DEFAULT 'FRST',
  `last_four` varchar(4) DEFAULT NULL,
  `card_type` varchar(255) DEFAULT NULL,
  `cvn` varchar(255) DEFAULT NULL,
  `exp_date_month` int DEFAULT NULL,
  `exp_date_year` int DEFAULT NULL,
  `country_code` varchar(10) DEFAULT NULL,
  `approved` int DEFAULT '0',
  `email` varchar(255) DEFAULT NULL,
  `ending_date` date DEFAULT NULL,
  `max_total_amount_of_all_payments` double(24,8) DEFAULT NULL,
  `preapproval_key` varchar(255) DEFAULT NULL,
  `starting_date` date DEFAULT NULL,
  `total_amount_of_all_payments` double(24,8) DEFAULT NULL,
  `stripe_card_ref` varchar(128) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '1',
  `import_key` varchar(14) DEFAULT NULL,
  `comment` varchar(255) DEFAULT NULL,
  `ipaddress` varchar(68) DEFAULT NULL,
  `stripe_account` varchar(128) DEFAULT NULL,
  `date_signature` datetime DEFAULT NULL,
  `online_sign_ip` varchar(48) DEFAULT NULL,
  `online_sign_name` varchar(64) DEFAULT NULL,
  `ext_payment_site` varchar(128) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_societe_rib` (`label`,`fk_soc`),
  KEY `llx_societe_rib_fk_societe` (`fk_soc`),
  CONSTRAINT `llx_societe_rib_fk_societe` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_socpeople`;
CREATE TABLE `llx_socpeople` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_soc` int DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `ref_ext` varchar(255) DEFAULT NULL,
  `civility` varchar(6) DEFAULT NULL,
  `lastname` varchar(50) DEFAULT NULL,
  `firstname` varchar(50) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `zip` varchar(25) DEFAULT NULL,
  `town` varchar(255) DEFAULT NULL,
  `fk_departement` int DEFAULT NULL,
  `fk_pays` int DEFAULT '0',
  `birthday` date DEFAULT NULL,
  `poste` varchar(255) DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `phone_perso` varchar(30) DEFAULT NULL,
  `phone_mobile` varchar(30) DEFAULT NULL,
  `fax` varchar(30) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `socialnetworks` text,
  `photo` varchar(255) DEFAULT NULL,
  `no_email` smallint NOT NULL DEFAULT '0',
  `priv` smallint NOT NULL DEFAULT '0',
  `fk_prospectlevel` varchar(12) DEFAULT NULL,
  `fk_stcommcontact` int NOT NULL DEFAULT '0',
  `fk_user_creat` int DEFAULT '0',
  `fk_user_modif` int DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `default_lang` varchar(6) DEFAULT NULL,
  `canvas` varchar(32) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `statut` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  KEY `idx_socpeople_fk_soc` (`fk_soc`),
  KEY `idx_socpeople_fk_user_creat` (`fk_user_creat`),
  KEY `idx_socpeople_lastname` (`lastname`),
  CONSTRAINT `fk_socpeople_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_socpeople_user_creat_user_rowid` FOREIGN KEY (`fk_user_creat`) REFERENCES `llx_user` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_socpeople_extrafields`;
CREATE TABLE `llx_socpeople_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_socpeople_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_stock_mouvement`;
CREATE TABLE `llx_stock_mouvement` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `datem` datetime DEFAULT NULL,
  `fk_product` int NOT NULL,
  `batch` varchar(128) DEFAULT NULL,
  `eatby` date DEFAULT NULL,
  `sellby` date DEFAULT NULL,
  `fk_entrepot` int NOT NULL,
  `value` double DEFAULT NULL,
  `price` double(24,8) DEFAULT '0.00000000',
  `type_mouvement` smallint DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `inventorycode` varchar(128) DEFAULT NULL,
  `fk_origin` int DEFAULT NULL,
  `origintype` varchar(64) DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `fk_projet` int NOT NULL DEFAULT '0',
  `fk_project` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_stock_mouvement_fk_product` (`fk_product`),
  KEY `idx_stock_mouvement_fk_entrepot` (`fk_entrepot`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_stock_mouvement_extrafields`;
CREATE TABLE `llx_stock_mouvement_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_stock_mouvement_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_subscription`;
CREATE TABLE `llx_subscription` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `fk_adherent` int DEFAULT NULL,
  `dateadh` datetime DEFAULT NULL,
  `datef` datetime DEFAULT NULL,
  `subscription` double(24,8) DEFAULT NULL,
  `fk_bank` int DEFAULT NULL,
  `note` text,
  `fk_type` int DEFAULT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_subscription` (`fk_adherent`,`dateadh`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_supplier_proposal`;
CREATE TABLE `llx_supplier_proposal` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `ref_ext` varchar(255) DEFAULT NULL,
  `ref_int` varchar(255) DEFAULT NULL,
  `fk_soc` int DEFAULT NULL,
  `fk_projet` int DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `date_cloture` datetime DEFAULT NULL,
  `fk_user_author` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `fk_user_valid` int DEFAULT NULL,
  `fk_user_cloture` int DEFAULT NULL,
  `fk_statut` smallint NOT NULL DEFAULT '0',
  `price` double DEFAULT '0',
  `remise_percent` double DEFAULT '0',
  `remise_absolue` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `fk_account` int DEFAULT NULL,
  `fk_currency` varchar(3) DEFAULT NULL,
  `fk_cond_reglement` int DEFAULT NULL,
  `fk_mode_reglement` int DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `date_livraison` date DEFAULT NULL,
  `fk_shipping_method` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_supplier_proposal_ref` (`ref`,`entity`),
  KEY `idx_supplier_proposal_fk_soc` (`fk_soc`),
  KEY `idx_supplier_proposal_fk_user_author` (`fk_user_author`),
  KEY `idx_supplier_proposal_fk_user_valid` (`fk_user_valid`),
  KEY `idx_supplier_proposal_fk_projet` (`fk_projet`),
  KEY `idx_supplier_proposal_fk_account` (`fk_account`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_supplier_proposal_extrafields`;
CREATE TABLE `llx_supplier_proposal_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_supplier_proposal_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_supplier_proposaldet`;
CREATE TABLE `llx_supplier_proposaldet` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `fk_supplier_proposal` int NOT NULL,
  `fk_parent_line` int DEFAULT NULL,
  `fk_product` int DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `fk_remise_except` int DEFAULT NULL,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT '0.000',
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `remise_percent` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `price` double DEFAULT NULL,
  `subprice` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `product_type` int DEFAULT '0',
  `info_bits` int DEFAULT '0',
  `buy_price_ht` double(24,8) DEFAULT '0.00000000',
  `fk_product_fournisseur_price` int DEFAULT NULL,
  `special_code` int DEFAULT '0',
  `rang` int DEFAULT '0',
  `ref_fourn` varchar(30) DEFAULT NULL,
  `fk_multicurrency` int DEFAULT NULL,
  `multicurrency_code` varchar(3) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `fk_unit` int DEFAULT NULL,
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_supplier_proposaldet_fk_supplier_proposal` (`fk_supplier_proposal`),
  KEY `idx_supplier_proposaldet_fk_product` (`fk_product`),
  KEY `fk_supplier_proposaldet_fk_unit` (`fk_unit`),
  CONSTRAINT `fk_supplier_proposaldet_fk_supplier_proposal` FOREIGN KEY (`fk_supplier_proposal`) REFERENCES `llx_supplier_proposal` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_supplier_proposaldet_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_supplier_proposaldet_extrafields`;
CREATE TABLE `llx_supplier_proposaldet_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_supplier_proposaldet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_takepos_floor_tables`;
CREATE TABLE `llx_takepos_floor_tables` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `label` varchar(255) DEFAULT NULL,
  `leftpos` float DEFAULT NULL,
  `toppos` float DEFAULT NULL,
  `floor` smallint DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_takepos_floor_tables` (`entity`,`label`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_ticket`;
CREATE TABLE `llx_ticket` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int DEFAULT '1',
  `ref` varchar(128) NOT NULL,
  `track_id` varchar(128) NOT NULL,
  `fk_soc` int DEFAULT '0',
  `fk_project` int DEFAULT '0',
  `fk_contract` int DEFAULT '0',
  `origin_email` varchar(128) DEFAULT NULL,
  `fk_user_create` int DEFAULT NULL,
  `fk_user_assign` int DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `message` mediumtext,
  `fk_statut` int DEFAULT NULL,
  `resolution` int DEFAULT NULL,
  `progress` int DEFAULT NULL,
  `timing` varchar(20) DEFAULT NULL,
  `type_code` varchar(32) DEFAULT NULL,
  `category_code` varchar(32) DEFAULT NULL,
  `severity_code` varchar(32) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `date_read` datetime DEFAULT NULL,
  `date_last_msg_sent` datetime DEFAULT NULL,
  `date_close` datetime DEFAULT NULL,
  `notify_tiers_at_create` tinyint DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `email_msgid` varchar(255) DEFAULT NULL,
  `email_date` datetime DEFAULT NULL,
  `ip` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_ticket_track_id` (`track_id`),
  UNIQUE KEY `uk_ticket_ref` (`ref`,`entity`),
  KEY `idx_ticket_entity` (`entity`),
  KEY `idx_ticket_fk_soc` (`fk_soc`),
  KEY `idx_ticket_fk_user_assign` (`fk_user_assign`),
  KEY `idx_ticket_fk_project` (`fk_project`),
  KEY `idx_ticket_fk_statut` (`fk_statut`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_ticket_extrafields`;
CREATE TABLE `llx_ticket_extrafields` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_object` int NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_ticket_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_tva`;
CREATE TABLE `llx_tva` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `tms` timestamp NULL DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `datep` date DEFAULT NULL,
  `datev` date DEFAULT NULL,
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `fk_typepayment` int DEFAULT NULL,
  `num_payment` varchar(50) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `entity` int NOT NULL DEFAULT '1',
  `note` text,
  `fk_bank` int DEFAULT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `paye` smallint NOT NULL DEFAULT '0',
  `fk_account` int DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `llx_user`;
CREATE TABLE `llx_user` (
  `rowid` int NOT NULL AUTO_INCREMENT,
  `entity` int NOT NULL DEFAULT '1',
  `ref_employee` varchar(50) DEFAULT NULL,
  `ref_ext` varchar(50) DEFAULT NULL,
  `employee` tinyint DEFAULT '1',
  `fk_establishment` int DEFAULT '0',
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NULL DEFAULT NULL,
  `fk_user_creat` int DEFAULT NULL,
  `fk_user_modif` int DEFAULT NULL,
  `login` varchar(50) NOT NULL,
  `pass_encoding` varchar(24) DEFAULT NULL,
  `pass` varchar(128) DEFAULT NULL,
  `pass_crypted` varchar(128) DEFAULT NULL,
  `pass_temp` varchar(128) DEFAULT NULL,
  `api_key` varchar(128) DEFAULT NULL,
  `gender` varchar(10) DEFAULT NULL,
  `civility` varchar(6) DEFAULT NULL,
  `lastname` varchar(50) DEFAULT NULL,
  `firstname` varchar(50) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `zip` varchar(25) DEFAULT NULL,
  `town` varchar(50) DEFAULT NULL,
  `fk_state` int DEFAULT '0',
  `fk_country` int DEFAULT '0',
  `birth` date DEFAULT NULL,
  `job` varchar(128) DEFAULT NULL,
  `office_phone` varchar(20) DEFAULT NULL,
  `office_fax` varchar(20) DEFAULT NULL,
  `user_mobile` varchar(20) DEFAULT NULL,
  `personal_mobile` varchar(20) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `personal_email` varchar(255) DEFAULT NULL,
  `socialnetworks` text,
  `signature` text,
  `admin` smallint DEFAULT '0',
  `fk_soc` int DEFAULT NULL,
  `fk_socpeople` int DEFAULT NULL,
  `fk_member` int DEFAULT NULL,
  `fk_user` int DEFAULT NULL,
  `fk_user_expense_validator` int DEFAULT NULL,
  `fk_user_holiday_validator` int DEFAULT NULL,
  `note_public` text,
  `note_private` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `datelastlogin` datetime DEFAULT NULL,
  `datepreviouslogin` datetime DEFAULT NULL,
  `egroupware_id` int DEFAULT NULL,
  `ldap_sid` varchar(255) DEFAULT NULL,
  `openid` varchar(255) DEFAULT NULL,
  `statut` tinyint DEFAULT '1',
  `photo` varchar(255) DEFAULT NULL,
  `lang` varchar(6) DEFAULT NULL,
  `color` varchar(6) DEFAULT NULL,
  `barcode` varchar(255) DEFAULT NULL,
  `fk_barcode_type` int DEFAULT '0',
  `accountancy_code` varchar(32) DEFAULT NULL,
  `nb_holiday` int DEFAULT '0',
  `thm` double(24,8) DEFAULT NULL,
  `tjm` double(24,8) DEFAULT NULL,
  `salary` double(24,8) DEFAULT NULL,
  `salaryextra` double(24,8) DEFAULT NULL,
  `dateemployment` date DEFAULT NULL,
  `dateemploymentend` date DEFAULT NULL,
  `weeklyhours` double(16,8) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `default_range` int DEFAULT NULL,
  `default_c_exp_tax_cat` int DEFAULT NULL,
  `fk_warehouse` int DEFAULT NULL,
  `iplastlogin` varchar(250) DEFAULT NULL,
  `ippreviouslogin` varchar(250) DEFAULT NULL,
  `datelastpassvalidation` datetime DEFAULT NULL,
  `datestartvalidity` datetime DEFAULT NULL,
  `dateendvalidity` datetime DEFAULT NULL,
  `national_registration_number` varchar(50) DEFAULT NULL,
  `birth_place` varchar(64) DEFAULT NULL,
  `flagdelsessionsbefore` datetime DEFAULT NULL,
  `email_oauth2` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_user_login` (`login`,`entity`),
  UNIQUE KEY `uk_user_fk_socpeople` (`fk_socpeople`),
  UNIQUE KEY `uk_user_fk_member` (`fk_member`),
  UNIQUE KEY `uk_user_api_key` (`api_key`),
  KEY `idx_user_fk_societe` (`fk_soc`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `llx_user` VALUES("1","0",NULL,NULL,"1","0","2018-11-02 20:46:27",NULL,NULL,NULL,"abde",NULL,NULL,"$2y$10$s6Fs9ptfE7OAMa6U/SfPGOGyXEzgpbr2dat0pDCoWzb4TFlFuu6em",NULL,NULL,NULL,NULL,"SuperAdmin","","","","",NULL,NULL,NULL,"","","","",NULL,"contact@pixelorigin.com",NULL,"[]","&nbsp;\r\n<table border=\"0\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px\">\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"text-align:center; vertical-align:top\"><span style=\"color:#48a1e5\"><strong><span style=\"font-size:xx-large\">PIXELORIGIN</span></strong></span>\r\n			<div style=\"text-align:center\">Benjou Abdelouhab<br />\r\n			Cr&eacute;ation de site e-Commerce<br />\r\n			&amp; applications&nbsp;&nbsp;</div>\r\n			</td>\r\n			<td>\r\n			<table border=\"0\" cellpadding=\"1\" cellspacing=\"1\" style=\"text-align:center; vertical-align:top\">\r\n				<tbody>\r\n					<tr>\r\n						<td style=\"text-align:center; vertical-align:middle\"><img src=\"https://cdn.gifo.wisestamp.com/social/rich-field-mobile-1/48A1E5/14/trans.png\" style=\"color:#48a1e5\" /></td>\r\n						<td style=\"text-align:left; vertical-align:middle\"><a href=\"tel:0651413714\">06 51 41 37 14</a></td>\r\n					</tr>\r\n					<tr>\r\n						<td style=\"text-align:center; vertical-align:middle\"><img src=\"https://cdn.gifo.wisestamp.com/social/rich-field-website-1/48A1E5/14/trans.png\" style=\"color:#48a1e5\" /></td>\r\n						<td style=\"text-align:left; vertical-align:middle\"><a href=\"https://www.pixelorigin.com\">www.pixelorigin.com</a></td>\r\n					</tr>\r\n					<tr>\r\n						<td style=\"text-align:center; vertical-align:middle\"><img src=\"https://cdn.gifo.wisestamp.com/social/rich-field-email-1/48A1E5/14/trans.png\" style=\"color:#48a1e5\" /></td>\r\n						<td style=\"text-align:left; vertical-align:middle\"><a href=\"mailto:benjouabde@gmail.com\">benjouabde@gmail.com</a></td>\r\n					</tr>\r\n					<tr>\r\n						<td style=\"text-align:center; vertical-align:middle\"><img src=\"https://cdn.gifo.wisestamp.com/social/rich-field-address-2/48A1E5/14/trans.png\" style=\"color:#48a1e5\" /></td>\r\n						<td style=\"text-align:left; vertical-align:middle\">38 ter rue Raymond Peyres 65000 Tarbes</